/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsRetrievalStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsResult;

public class BlockingGetRecordsCache
implements GetRecordsCache {
    private static final Log log = LogFactory.getLog(BlockingGetRecordsCache.class);
    private final int maxRecordsPerCall;
    private final GetRecordsRetrievalStrategy getRecordsRetrievalStrategy;

    public BlockingGetRecordsCache(int maxRecordsPerCall, GetRecordsRetrievalStrategy getRecordsRetrievalStrategy) {
        this.maxRecordsPerCall = maxRecordsPerCall;
        this.getRecordsRetrievalStrategy = getRecordsRetrievalStrategy;
    }

    @Override
    public void start() {
    }

    @Override
    public ProcessRecordsInput getNextResult() {
        GetRecordsResult getRecordsResult = this.getRecordsRetrievalStrategy.getRecords(this.maxRecordsPerCall);
        return new ProcessRecordsInput().withRecords(getRecordsResult.getRecords()).withMillisBehindLatest(getRecordsResult.getMillisBehindLatest());
    }

    @Override
    public GetRecordsRetrievalStrategy getGetRecordsRetrievalStrategy() {
        return this.getRecordsRetrievalStrategy;
    }

    @Override
    public void shutdown() {
        this.getRecordsRetrievalStrategy.shutdown();
    }
}

