/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.Beta;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.ExpressionSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;

@Beta
public final class QueryExpressionSpec
extends ExpressionSpec {
    private final String projectionExpression;
    private final String filterExpression;
    private final Map<String, String> nameMap;
    private final Map<String, Object> valueMap;
    private final String keyConditionExpression;

    QueryExpressionSpec(ExpressionSpecBuilder builder) {
        SubstitutionContext context = new SubstitutionContext();
        this.keyConditionExpression = builder.buildKeyConditionExpression(context);
        this.filterExpression = builder.buildConditionExpression(context);
        this.projectionExpression = builder.buildProjectionExpression(context);
        Map<String, String> nameMap = context.getNameMap();
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(nameMap);
        Map<String, Object> valueMap = context.getValueMap();
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(valueMap);
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public String getKeyConditionExpression() {
        return this.keyConditionExpression;
    }

    @Override
    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }
}

