/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamDescription;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamStatus;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.ShardAdapter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;

public class StreamDescriptionAdapter
extends org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription {
    private static final String STREAM_STATUS_DYNAMODB_DISABLED = StreamStatus.DISABLED.toString();
    private static final String STREAM_STATUS_DYNAMODB_DISABLING = StreamStatus.DISABLING.toString();
    private static final String STREAM_STATUS_DYNAMODB_ENABLED = StreamStatus.ENABLED.toString();
    private static final String STREAM_STATUS_DYNAMODB_ENABLING = StreamStatus.ENABLING.toString();
    private static final String STREAM_STATUS_KINESIS_ACTIVE = org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamStatus.ACTIVE.toString();
    private static final String STREAM_STATUS_KINESIS_CREATING = org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamStatus.CREATING.toString();
    private final StreamDescription internalDescription;
    private final List<Shard> shards;

    public StreamDescriptionAdapter(StreamDescription streamDescription) {
        this.internalDescription = streamDescription;
        this.shards = new ArrayList<Shard>();
        for (org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Shard shard : streamDescription.getShards()) {
            this.shards.add(new ShardAdapter(shard));
        }
    }

    public StreamDescription getInternalObject() {
        return this.internalDescription;
    }

    @Override
    public String getStreamName() {
        return this.internalDescription.getStreamArn();
    }

    @Override
    public void setStreamName(String streamName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withStreamName(String streamName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStreamARN() {
        return this.internalDescription.getStreamArn();
    }

    @Override
    public void setStreamARN(String streamARN) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withStreamARN(String streamARN) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStreamStatus() {
        String status = this.internalDescription.getStreamStatus();
        if (STREAM_STATUS_DYNAMODB_ENABLED.equals(status)) {
            status = STREAM_STATUS_KINESIS_ACTIVE;
        } else if (STREAM_STATUS_DYNAMODB_ENABLING.equals(status)) {
            status = STREAM_STATUS_KINESIS_CREATING;
        } else if (STREAM_STATUS_DYNAMODB_DISABLED.equals(status)) {
            status = STREAM_STATUS_KINESIS_ACTIVE;
        } else if (STREAM_STATUS_DYNAMODB_DISABLING.equals(status)) {
            status = STREAM_STATUS_KINESIS_ACTIVE;
        } else {
            throw new UnsupportedOperationException("Unsupported StreamStatus: " + status);
        }
        return status;
    }

    @Override
    public void setStreamStatus(String streamStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withStreamStatus(String streamStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStreamStatus(org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamStatus streamStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withStreamStatus(org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamStatus streamStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Shard> getShards() {
        return this.shards;
    }

    @Override
    public void setShards(Collection<Shard> shards) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withShards(Shard ... shards) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withShards(Collection<Shard> shards) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean isHasMoreShards() {
        return this.internalDescription.getLastEvaluatedShardId() != null;
    }

    @Override
    public Boolean getHasMoreShards() {
        return this.internalDescription.getLastEvaluatedShardId() != null;
    }

    @Override
    public void setHasMoreShards(Boolean hasMoreShards) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription withHasMoreShards(Boolean hasMoreShards) {
        throw new UnsupportedOperationException();
    }
}

