/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.StreamsWorkerFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang.MultiLangDaemon;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang.MultiLangDaemonConfig;

public class StreamsMultiLangDaemon {
    private static final Log LOG = LogFactory.getLog(StreamsMultiLangDaemon.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            MultiLangDaemon.printUsage(System.err, "You must provide a properties file");
            System.exit(1);
        }
        MultiLangDaemonConfig config = null;
        try {
            config = new MultiLangDaemonConfig(args[0]);
        }
        catch (IOException | IllegalArgumentException e) {
            MultiLangDaemon.printUsage(System.err, "You must provide a valid properties file");
            System.exit(1);
        }
        ExecutorService executorService = config.getExecutorService();
        Worker worker = StreamsWorkerFactory.createDynamoDbStreamsWorker(config.getRecordProcessorFactory(), config.getKinesisClientLibConfiguration(), executorService);
        MultiLangDaemon daemon = new MultiLangDaemon(worker);
        Future<Integer> future = executorService.submit(daemon);
        try {
            System.exit(future.get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Encountered an error while running daemon", e);
        }
        System.exit(1);
    }
}

