/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.GetItemOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.GetItemApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetItemResult;

public class GetItemImpl
extends AbstractImpl
implements GetItemApi {
    public GetItemImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public GetItemOutcome getItemOutcome(KeyAttribute ... primaryKeyComponents) {
        return this.doLoadItem(new GetItemSpec().withPrimaryKey(primaryKeyComponents));
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey) {
        return this.doLoadItem(new GetItemSpec().withPrimaryKey(primaryKey));
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.doLoadItem(new GetItemSpec().withPrimaryKey(primaryKey).withProjectionExpression(projectionExpression).withNameMap(nameMap));
    }

    @Override
    public GetItemOutcome getItemOutcome(GetItemSpec spec) {
        return this.doLoadItem(spec);
    }

    @Override
    public Item getItem(GetItemSpec spec) {
        return this.doLoadItem(spec).getItem();
    }

    private GetItemOutcome doLoadItem(GetItemSpec spec) {
        String tableName = this.getTable().getTableName();
        GetItemRequest req = ((GetItemRequest)spec.getRequest()).withTableName(tableName).withKey(InternalUtils.toAttributeValueMap(spec.getKeyComponents())).withExpressionAttributeNames(spec.getNameMap());
        GetItemResult result = this.getClient().getItem(req);
        return new GetItemOutcome(result);
    }

    @Override
    public Item getItem(KeyAttribute ... primaryKey) {
        return this.getItemOutcome(primaryKey).getItem();
    }

    @Override
    public Item getItem(PrimaryKey primaryKey) {
        return this.getItemOutcome(primaryKey).getItem();
    }

    @Override
    public Item getItem(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(primaryKey, projectionExpression, nameMap).getItem();
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue) {
        return this.getItemOutcome(new KeyAttribute(hashKeyName, hashKeyValue));
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemOutcome(new KeyAttribute(hashKeyName, hashKeyValue), new KeyAttribute(rangeKeyName, rangeKeyValue));
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue) {
        return this.getItemOutcome(hashKeyName, hashKeyValue).getItem();
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue).getItem();
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue), projectionExpression, nameMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), projectionExpression, nameMap);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue), projectionExpression, nameMap).getItem();
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), projectionExpression, nameMap).getItem();
    }
}

