/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeAction;

public class AttributeUpdate {
    private final String attributeName;
    private AttributeAction action;
    private Set<Object> attributeValues;
    private Object value;

    public AttributeUpdate(String attributeName) {
        this.attributeName = attributeName;
    }

    public AttributeUpdate put(Object attributeValue) {
        this.action = AttributeAction.PUT;
        this.value = attributeValue;
        return this;
    }

    public AttributeUpdate delete() {
        this.action = AttributeAction.DELETE;
        return this;
    }

    public AttributeUpdate removeElements(Object ... elementsToBeRemoved) {
        this.action = AttributeAction.DELETE;
        this.attributeValues = Collections.unmodifiableSet(new LinkedHashSet<Object>(Arrays.asList(elementsToBeRemoved)));
        return this;
    }

    public AttributeUpdate addNumeric(Number value) {
        this.action = AttributeAction.ADD;
        this.value = value;
        return this;
    }

    public AttributeUpdate addElements(Object ... newElements) {
        this.action = AttributeAction.ADD;
        this.attributeValues = Collections.unmodifiableSet(new LinkedHashSet<Object>(Arrays.asList(newElements)));
        return this;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeAction getAction() {
        return this.action;
    }

    public Set<Object> getAttributeValues() {
        return this.attributeValues;
    }

    public Object getValue() {
        return this.value;
    }
}

