/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.http.conn;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.conn.ClientConnectionRequestFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.conn.Wrapped;
import org.apache.flink.kinesis.shaded.org.apache.http.conn.ConnectionRequest;
import org.apache.flink.kinesis.shaded.org.apache.http.conn.HttpClientConnectionManager;
import org.apache.flink.kinesis.shaded.org.apache.http.pool.ConnPoolControl;

public class ClientConnectionManagerFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionManagerFactory.class);

    public static HttpClientConnectionManager wrap(HttpClientConnectionManager orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        Class[] interfaces = orig instanceof ConnPoolControl ? new Class[]{HttpClientConnectionManager.class, ConnPoolControl.class, Wrapped.class} : new Class[]{HttpClientConnectionManager.class, Wrapped.class};
        return (HttpClientConnectionManager)Proxy.newProxyInstance(ClientConnectionManagerFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final HttpClientConnectionManager orig;

        Handler(HttpClientConnectionManager real) {
            this.orig = real;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object ret = method.invoke((Object)this.orig, args);
                return ret instanceof ConnectionRequest ? ClientConnectionRequestFactory.wrap((ConnectionRequest)ret) : ret;
            }
            catch (InvocationTargetException e) {
                log.debug("", e);
                throw e.getCause();
            }
        }
    }
}

