/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.flink.connectors.producer;

import com.amazonaws.services.kinesisanalytics.flink.connectors.config.AWSConfigConstants;
import com.amazonaws.services.kinesisanalytics.flink.connectors.exception.FlinkKinesisFirehoseException;
import com.amazonaws.services.kinesisanalytics.flink.connectors.exception.RecordCouldNotBeSentException;
import com.amazonaws.services.kinesisanalytics.flink.connectors.producer.IProducer;
import com.amazonaws.services.kinesisanalytics.flink.connectors.producer.impl.FirehoseProducer;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.CredentialProvider;
import com.amazonaws.services.kinesisanalytics.flink.connectors.provider.credential.factory.CredentialProviderFactory;
import com.amazonaws.services.kinesisanalytics.flink.connectors.serialization.KinesisFirehoseSerializationSchema;
import com.amazonaws.services.kinesisanalytics.flink.connectors.util.AWSUtil;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import com.amazonaws.services.kinesisfirehose.model.Record;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkKinesisFirehoseProducer<OUT>
extends RichSinkFunction<OUT>
implements CheckpointedFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkKinesisFirehoseProducer.class);
    private final KinesisFirehoseSerializationSchema<OUT> schema;
    private final Properties config;
    private final AWSConfigConstants.CredentialProviderType credentialProviderType;
    private final String defaultDeliveryStream;
    private boolean failOnError;
    private volatile transient Throwable lastThrownException;
    private transient CredentialProvider credentialsProvider;
    private transient AmazonKinesisFirehose firehoseClient;
    private transient IProducer<FirehoseProducer.UserRecordResult, Record> firehoseProducer;
    private transient FutureCallback<FirehoseProducer.UserRecordResult> monitorCallback;

    public FlinkKinesisFirehoseProducer(String deliveryStream, KinesisFirehoseSerializationSchema<OUT> schema, Properties configProps, AWSConfigConstants.CredentialProviderType credentialProviderType) {
        this.defaultDeliveryStream = (String)Validate.notBlank((CharSequence)deliveryStream, (String)"Delivery stream cannot be null or empty", (Object[])new Object[0]);
        this.schema = (KinesisFirehoseSerializationSchema)Validate.notNull(schema, (String)"Kinesis serialization schema cannot be null", (Object[])new Object[0]);
        this.config = (Properties)Validate.notNull((Object)configProps, (String)"Configuration properties cannot be null", (Object[])new Object[0]);
        this.credentialProviderType = (AWSConfigConstants.CredentialProviderType)((Object)Validate.notNull((Object)((Object)credentialProviderType), (String)"Credential Provider type cannot be null", (Object[])new Object[0]));
    }

    public FlinkKinesisFirehoseProducer(String deliveryStream, final SerializationSchema<OUT> schema, Properties configProps, AWSConfigConstants.CredentialProviderType credentialProviderType) {
        this(deliveryStream, new KinesisFirehoseSerializationSchema<OUT>(){

            @Override
            public ByteBuffer serialize(OUT element) {
                return ByteBuffer.wrap(schema.serialize(element));
            }
        }, configProps, credentialProviderType);
    }

    public FlinkKinesisFirehoseProducer(String deliveryStream, KinesisFirehoseSerializationSchema<OUT> schema, Properties configProps) {
        this(deliveryStream, schema, configProps, FlinkKinesisFirehoseProducer.getCredentialProviderType(configProps));
    }

    public FlinkKinesisFirehoseProducer(String deliveryStream, SerializationSchema<OUT> schema, Properties configProps) {
        this(deliveryStream, schema, configProps, FlinkKinesisFirehoseProducer.getCredentialProviderType(configProps));
    }

    @VisibleForTesting
    FlinkKinesisFirehoseProducer(String deliveryStream, KinesisFirehoseSerializationSchema<OUT> schema, Properties configProps, AmazonKinesisFirehose firehoseClient, IProducer<FirehoseProducer.UserRecordResult, Record> firehoseProducer) {
        this(deliveryStream, schema, configProps);
        this.firehoseClient = (AmazonKinesisFirehose)Validate.notNull((Object)firehoseClient);
        this.firehoseProducer = (IProducer)Validate.notNull(firehoseProducer);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.credentialsProvider = CredentialProviderFactory.newCredentialProvider(this.credentialProviderType, this.config);
        LOGGER.info("Credential provider: {}", (Object)this.credentialsProvider.getAwsCredentialsProvider().getClass().getName());
        this.firehoseClient = this.firehoseClient != null ? this.firehoseClient : AWSUtil.createKinesisFirehoseClientFromConfiguration(this.config, this.credentialsProvider);
        this.firehoseProducer = this.firehoseProducer != null ? this.firehoseProducer : new FirehoseProducer(this.defaultDeliveryStream, this.firehoseClient, this.config);
        LOGGER.info("Started Kinesis Firehose client. Delivering to stream: {}", (Object)this.defaultDeliveryStream);
        this.monitorCallback = new FutureCallback<FirehoseProducer.UserRecordResult>(){

            @Override
            public void onSuccess(@Nullable FirehoseProducer.UserRecordResult result) {
                if (result == null) {
                    return;
                }
                if (!result.isSuccessful()) {
                    if (FlinkKinesisFirehoseProducer.this.failOnError && FlinkKinesisFirehoseProducer.this.lastThrownException == null) {
                        FlinkKinesisFirehoseProducer.this.lastThrownException = new RecordCouldNotBeSentException("Record could not be successfully sent.", result.getException());
                    } else {
                        LOGGER.warn("Record could not be successfully sent.");
                    }
                }
            }

            @Override
            public void onFailure(Throwable t) {
                if (FlinkKinesisFirehoseProducer.this.failOnError) {
                    FlinkKinesisFirehoseProducer.this.lastThrownException = t;
                } else {
                    LOGGER.warn("An error has occurred trying to write a record.", t);
                }
            }
        };
    }

    public void invoke(OUT value, SinkFunction.Context context) throws Exception {
        Validate.notNull(value);
        ByteBuffer serializedValue = this.schema.serialize(value);
        Validate.validState((this.firehoseProducer != null && !this.firehoseProducer.isDestroyed() ? 1 : 0) != 0, (String)"Firehose producer has been destroyed", (Object[])new Object[0]);
        Validate.validState((this.firehoseClient != null ? 1 : 0) != 0, (String)"Kinesis Firehose client has been closed", (Object[])new Object[0]);
        this.propagateAsyncExceptions();
        ListenableFuture<FirehoseProducer.UserRecordResult> future = this.firehoseProducer.addUserRecord(new Record().withData(serializedValue));
        Futures.addCallback(future, this.monitorCallback);
    }

    public void snapshotState(FunctionSnapshotContext functionSnapshotContext) throws Exception {
        this.propagateAsyncExceptions();
        LOGGER.debug("Outstanding records before snapshot: {}", (Object)this.firehoseProducer.getOutstandingRecordsCount());
        this.flushSync();
        LOGGER.debug("Outstanding records after snapshot: {}", (Object)this.firehoseProducer.getOutstandingRecordsCount());
        if (this.firehoseProducer.getOutstandingRecordsCount() > 0) {
            throw new IllegalStateException("An error has occurred trying to flush the buffer synchronously.");
        }
        this.propagateAsyncExceptions();
    }

    public void initializeState(FunctionInitializationContext functionInitializationContext) throws Exception {
    }

    public void close() throws Exception {
        try {
            try {
                super.close();
                this.propagateAsyncExceptions();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        finally {
            this.flushSync();
            this.firehoseProducer.destroy();
            if (this.firehoseClient != null) {
                LOGGER.debug("Shutting down Kinesis Firehose client...");
                this.firehoseClient.shutdown();
            }
        }
    }

    private static AWSConfigConstants.CredentialProviderType getCredentialProviderType(Properties configProps) {
        return AWSUtil.containsBasicProperties(configProps) ? AWSConfigConstants.CredentialProviderType.BASIC : AWSConfigConstants.CredentialProviderType.AUTO;
    }

    private void propagateAsyncExceptions() throws Exception {
        if (this.lastThrownException == null) {
            return;
        }
        if (this.failOnError) {
            throw new FlinkKinesisFirehoseException("An exception has been thrown while trying to process a record", this.lastThrownException);
        }
        LOGGER.warn("An exception has been thrown while trying to process a record", this.lastThrownException);
        this.lastThrownException = null;
    }

    private void flushSync() {
        while (this.firehoseProducer.getOutstandingRecordsCount() > 0 && !this.firehoseProducer.isFlushFailed()) {
            this.firehoseProducer.flush();
            try {
                LOGGER.debug("Number of outstanding records before going to sleep: {}", (Object)this.firehoseProducer.getOutstandingRecordsCount());
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Flushing has been interrupted.");
                break;
            }
        }
    }
}

