/*
 * Copyright (C) 2000 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: tcpillust.h,v 1.2 2000/04/20 07:13:59 nishida Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <tcl.h>
#include <tk.h>
#include <X11/Xutil.h>

#define PROG_NAME		"tcpillust"
#define PROG_VERSION	"1.00a (20000414)"
#define FL_VERBOSE		0x0001
#define FL_CHKCLT		0x0002
#define TYPE_CLIENT		1
#define TYPE_SERVER		2
#define ST_SERVER		1
#define ST_CLIENT		2
#define ST_BOTH			3
#define NUM_DUPACK		3
#define STAT_DATA		0
#define STAT_ACK		1
#define STAT_DUPACK		2
#define STAT_RETRANS	3
#define STAT_LOST		4
#define STAT_REALLOST	5

#define DATA_COLOR "blue"
#define ACK_COLOR "red"
#define DUPACK_COLOR "green"
#define RETRANS_COLOR "orange"
#define LOST_COLOR "cyan"
#define REALLOST_COLOR "cyan"

#define MAXFILENAME 256
#define MAXITEMS 20
#define CANVAS_HEIGHT_RATIO 2
#define SUBCANVAS_HEIGHT_RATIO 4

int zoomout_clib __P((ClientData, Tcl_Interp *, int, char **));
int zoomin_clib __P((ClientData, Tcl_Interp *, int, char **));
int subzoomout_clib __P((ClientData, Tcl_Interp *, int, char **));
int subzoomin_clib __P((ClientData, Tcl_Interp *, int, char **));
int movebar_clib __P((ClientData, Tcl_Interp *, int, char **));
int drawline_clib __P((ClientData, Tcl_Interp *, int, char **));
int bpress_clib __P((ClientData, Tcl_Interp *, int, char **));
int scrlbar1_clib __P((ClientData, Tcl_Interp *, int, char **));
int scrlbar2_clib __P((ClientData, Tcl_Interp *, int, char **));
int forward_clib __P((ClientData, Tcl_Interp *, int, char **));
int back_clib __P((ClientData, Tcl_Interp *, int, char **));
int text_clib __P((ClientData, Tcl_Interp *, int, char **));
int time_clib __P((ClientData, Tcl_Interp *, int, char **));
int openfile_clib __P((ClientData, Tcl_Interp *, int, char **));
void read_binfile __P((char *, int));
void parser __P((int, char **));
void load_file __P((int, char **, int));
void initial_showregion __P((void));
void reset_showregion __P((void));
void config_frame __P((void));
void config_subframe __P((void));
void config_lines __P((void));
void config_texts __P((void));
void config_times __P((void));
void config_sublines __P((void));
void config_rectangle __P((void));
void draw_canvas __P((void));
void draw_subcanvas __P((void));
void draw_rectangle __P((void));

struct tcppkt {
	float captime;
	u_long src_addr;
	u_long dst_addr;
	u_short src_port;
	u_short dst_port;
	u_short id;
	u_short win;
	u_char	flags;
	long seq;
	long ack;
	long datalen;
}; 

struct iltdata {
	int	flag;
	float sendtime;
	float recvtime;
	float delay;
	int state;
	long seq;
	char text[256];
};

#ifndef MAIN
extern Tk_Window main_tkwin;
extern Tk_Window canvas_tkwin; 
extern Tk_Window subcanvas_tkwin;
extern Tcl_Interp *interp;
extern u_char	filename[MAXFILENAME];
extern int canvas_width;
extern int canvas_height;
extern int appl_width;
extern int appl_height;
extern int appl_x;
extern int appl_y;
extern int subcanvas_width;
extern int subcanvas_height;
extern int fontsize;
extern int texton;
extern int timeon;
extern int iltcnt;
extern int loaded;
extern int pktcount[2];
extern float delay;
extern float ratio;
extern float baseratio;
extern float starttime;
extern float endtime;
extern float capendtime;
extern float subratio;
extern float basesubratio;
extern float substarttime;
extern float subendtime;
extern struct tcppkt *pkt[2]; 
extern struct tcppkt *client; 
extern struct tcppkt *server; 
extern struct iltdata *ilt;
#endif
