/*
 * Copyright (C) 2000 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: draw.c,v 1.3 2000/04/20 07:13:55 nishida Exp $
 */
#include "tcpillust.h"

#define LEDGE(x) (80)
#define REDGE(x) (x - 80)
#define SUBLEDGE(x) ((float)x * 0.15)
#define SUBREDGE(x) ((float)x * 0.85)
#define RECTLEDGE(x) ((float)x * 0.05)
#define RECTREDGE(x) ((float)x * 0.95)
#define TOP(x) (20)
#define BOTTOM(x) (x * CANVAS_HEIGHT_RATIO)
#define SUBTOP(x) (5)
#define SUBBOTTOM(x) (x * SUBCANVAS_HEIGHT_RATIO)
#define CHECK_TEXT 5
#define CHECK_TIME 5
#define TEXT_HEIGHT 9
#define TIME_MARGIN 40

static int startidx;
static int endidx;
static char tclcolor[][50] = 
	{DATA_COLOR, ACK_COLOR, DUPACK_COLOR, RETRANS_COLOR, 
	 LOST_COLOR, REALLOST_COLOR};

void
initial_showregion()
{
	/* XXX */
	baseratio = ratio = canvas_height / (delay * 4.0);
	basesubratio = subratio = subcanvas_height / (delay * 50.0);

	substarttime = 0.0;

	starttime = substarttime + delay * -1.0 * CANVAS_HEIGHT_RATIO;
	endtime = delay * 3.0 * CANVAS_HEIGHT_RATIO;

	reset_showregion();
}

void
config_frame()
{
	char x1s[20], x2s[20], y1s[20], y2s[20];
	
	sprintf(x1s, "%d", LEDGE(canvas_width));
	sprintf(x2s, "%d", LEDGE(canvas_width));
	sprintf(y1s, "%d", TOP(canvas_height));
	sprintf(y2s, "%d", BOTTOM(canvas_height));

	Tcl_SetVar2(interp, "fx1", "0", x1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "fx2", "0", x2s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "fy1", "0", y1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "fy2", "0", y2s, TCL_GLOBAL_ONLY);

	sprintf(x1s, "%d", REDGE(canvas_width));
	sprintf(x2s, "%d", REDGE(canvas_width));
	sprintf(y1s, "%d", TOP(canvas_height));
	sprintf(y2s, "%d", BOTTOM(canvas_height));

	Tcl_SetVar2(interp, "fx1", "1", x1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "fx2", "1", x2s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "fy1", "1", y1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "fy2", "1", y2s, TCL_GLOBAL_ONLY);
}


void
config_subframe()
{
	char x1s[20], x2s[20], y1s[20], y2s[20];
	
	sprintf(x1s, "%f", SUBLEDGE(subcanvas_width));
	sprintf(x2s, "%f", SUBLEDGE(subcanvas_width));
	sprintf(y1s, "%d", SUBTOP(subcanvas_height));
	sprintf(y2s, "%d", SUBBOTTOM(subcanvas_height));

	Tcl_SetVar2(interp, "subfx1", "0", x1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "subfx2", "0", x2s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "subfy1", "0", y1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "subfy2", "0", y2s, TCL_GLOBAL_ONLY);

	sprintf(x1s, "%f", SUBREDGE(subcanvas_width));
	sprintf(x2s, "%f", SUBREDGE(subcanvas_width));
	sprintf(y1s, "%d", SUBTOP(subcanvas_height));
	sprintf(y2s, "%d", SUBBOTTOM(subcanvas_height));

	Tcl_SetVar2(interp, "subfx1", "1", x1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "subfx2", "1", x2s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "subfy1", "1", y1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "subfy2", "1", y2s, TCL_GLOBAL_ONLY);
}

void
config_lines()
{
	int i = 0, x1, y1, x2, y2, count = 0;
	char x1s[20], x2s[20], y1s[20], y2s[20], is[20];

	startidx = -1;
	endidx = -1;
		
	for (i = 0; i < iltcnt; i ++){
		if (ilt[i].sendtime > endtime) continue;
		if (ilt[i].recvtime < starttime) continue;

		if (endidx < i) endidx = i;
		if (startidx < 0 || startidx > i) startidx = i;

		/* OK, this data is inside region */
		x1 = LEDGE(canvas_width);
		x2 = REDGE(canvas_width);

		if (ilt[i].flag == TYPE_CLIENT){
			y1 = (ilt[i].sendtime - starttime) * ratio + TOP(canvas_height);
			y2 = (ilt[i].sendtime - starttime + ilt[i].delay) 
					* ratio + TOP(canvas_height);
		} else {
			y1 = (ilt[i].sendtime - starttime + ilt[i].delay) 
					* ratio + TOP(canvas_height);
			y2 = (ilt[i].sendtime - starttime) * ratio + TOP(canvas_height);
		}
		sprintf(is, "%d", count);
		sprintf(x1s, "%d", x1);
		sprintf(x2s, "%d", x2);
		sprintf(y1s, "%d", y1);
		sprintf(y2s, "%d", y2);

		Tcl_SetVar2(interp, "x1", is, x1s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "x2", is, x2s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "y1", is, y1s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "y2", is, y2s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "color", is, 
			tclcolor[ilt[i].state], TCL_GLOBAL_ONLY);

		if (ilt[i].flag == TYPE_CLIENT)
			Tcl_SetVar2(interp, "arrow", is, "last", TCL_GLOBAL_ONLY);
		else
			Tcl_SetVar2(interp, "arrow", is, "first", TCL_GLOBAL_ONLY);
		count ++;
	}
	sprintf(is, "%d", count);
	Tcl_SetVar(interp, "linecnt", is, TCL_GLOBAL_ONLY);
}

void
config_texts()
{
	int i = 0, x, y, count = 0, last_y[CHECK_TEXT], j, k, drawok;
	char is[20], xs[20], ys[20];

	for (j = 0; j < CHECK_TEXT; j ++) 
		last_y[j] = -100;
	for (i = startidx; i <= endidx; i ++){
		x = canvas_width / 2;
		y = (ilt[i].sendtime - starttime + ilt[i].delay / 2.0) * ratio 
				+ TOP(canvas_height) - TEXT_HEIGHT / 2;
		drawok = 1;
		for (j = 0; j < CHECK_TEXT; j ++){
			if (abs(y - last_y[j]) < TEXT_HEIGHT) {
				y = last_y[j] + TEXT_HEIGHT;
				for (k = 0; k < CHECK_TEXT; k ++){
					if (abs(y - last_y[k]) < TEXT_HEIGHT) {
						drawok = 0;
						break;
					}
				}
			}
		}
		if (!drawok) continue; /* there's no space for putting this text */
		for (j = 1; j < CHECK_TEXT; j ++) 
			last_y[j -1] = last_y[j];
		last_y[CHECK_TEXT -1] = y;

		sprintf(is, "%d", count);
		sprintf(xs, "%d", x);
		sprintf(ys, "%d", y);

		Tcl_SetVar2(interp, "txcolor", is, 
			tclcolor[ilt[i].state], TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "tx", is, xs, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "ty", is, ys, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "text", is, ilt[i].text, TCL_GLOBAL_ONLY);
		count ++;
	}
	sprintf(is, "%d", count);
	Tcl_SetVar(interp, "textcnt", is, TCL_GLOBAL_ONLY);
}

void
config_times()
{
	int i = 0, x, y, count = 0, j, k, drawok;
	int last_ly[CHECK_TIME], last_ry[CHECK_TIME];
	char is[20], xs[20], ys[20], times[20];
	float left, right;

	for (j = 0; j < CHECK_TIME; j ++) {
		last_ly[j] = -100;
		last_ry[j] = -100;
	}

	for (i = startidx; i <= endidx; i ++){
		if (ilt[i].flag == TYPE_CLIENT){
			left = ilt[i].sendtime;
			right = ilt[i].recvtime;
		} else {
			right = ilt[i].sendtime;
			left = ilt[i].recvtime;
		}
			
		/* left side processing */
		x = LEDGE(canvas_width) - TIME_MARGIN;
		y = (left - starttime) * ratio + TOP(canvas_height) - TEXT_HEIGHT / 2;
		drawok = 1;
		for (j = 0; j < CHECK_TIME; j ++){
			if (abs(y - last_ly[j]) < TEXT_HEIGHT) {
				y = last_ly[j] + TEXT_HEIGHT;
				for (k = 0; k < CHECK_TIME; k ++){
					if (abs(y - last_ly[k]) < TEXT_HEIGHT) {
						drawok = 0;
						break;
					}
				}
			}
		}
		if (!drawok) goto right;

		for (j = 1; j < CHECK_TIME; j ++) 
			last_ly[j -1] = last_ly[j];
		last_ly[CHECK_TIME -1] = y;

		sprintf(is, "%d", count);
		sprintf(xs, "%d", x);
		sprintf(ys, "%d", y);
/* XXX */
		sprintf(times, "%04.6f", left);

		Tcl_SetVar2(interp, "tmcolor", is, 
			tclcolor[ilt[i].state], TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "tmx", is, xs, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "tmy", is, ys, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "time", is, times, TCL_GLOBAL_ONLY);
		count ++;

right:
		/* right side processing */
		x = REDGE(canvas_width) + TIME_MARGIN;
		y = (right - starttime) * ratio + TOP(canvas_height) - TEXT_HEIGHT / 2;
		drawok = 1;
		for (j = 0; j < CHECK_TIME; j ++){
			if (abs(y - last_ry[j]) < TEXT_HEIGHT) {
				y = last_ry[j] + TEXT_HEIGHT;
				for (k = 0; k < CHECK_TIME; k ++){
					if (abs(y - last_ry[k]) < TEXT_HEIGHT) {
						drawok = 0;
						break;
					}
				}
			}
		}
		if (!drawok) continue;

		for (j = 1; j < CHECK_TIME; j ++) 
			last_ry[j -1] = last_ry[j];
		last_ry[CHECK_TIME -1] = y;

		sprintf(is, "%d", count);
		sprintf(xs, "%d", x);
		sprintf(ys, "%d", y);
/* XXX */
		sprintf(times, "%04.6f", right);

		Tcl_SetVar2(interp, "tmcolor", is, 
			tclcolor[ilt[i].state], TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "tmx", is, xs, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "tmy", is, ys, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "time", is, times, TCL_GLOBAL_ONLY);
		count ++;

	}
	sprintf(is, "%d", count);
	Tcl_SetVar(interp, "timecnt", is, TCL_GLOBAL_ONLY);
}

void
config_sublines()
{
	int i = 0, x1, y1, x2, y2, count = 0;
	char x1s[20], x2s[20], y1s[20], y2s[20], is[20];
		
	for (i = 0; i < iltcnt; i ++){
		if (ilt[i].sendtime > subendtime) continue;
		if (ilt[i].recvtime < substarttime) continue;

		x1 = SUBLEDGE(subcanvas_width) +1;
		x2 = SUBREDGE(subcanvas_width) -1;

		if (ilt[i].flag == TYPE_CLIENT){
			y1 = (ilt[i].sendtime - substarttime) 
					* subratio + SUBTOP(canvas_height);
			y2 = (ilt[i].sendtime - substarttime + ilt[i].delay) 
					* subratio + SUBTOP(subcanvas_height);
		} else {
			y1 = (ilt[i].sendtime - substarttime + ilt[i].delay) 
					* subratio + SUBTOP(subcanvas_height);
			y2 = (ilt[i].sendtime - substarttime) 
					* subratio + SUBTOP(subcanvas_height);
		}
		sprintf(is, "%d", count);
		sprintf(x1s, "%d", x1);
		sprintf(x2s, "%d", x2);
		sprintf(y1s, "%d", y1);
		sprintf(y2s, "%d", y2);

		Tcl_SetVar2(interp, "subx1", is, x1s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "subx2", is, x2s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "suby1", is, y1s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "suby2", is, y2s, TCL_GLOBAL_ONLY);
		Tcl_SetVar2(interp, "subcolor", is, 
			tclcolor[ilt[i].state], TCL_GLOBAL_ONLY);
		count ++;
	}
	sprintf(is, "%d", count);
	Tcl_SetVar(interp, "sublinecnt", is, TCL_GLOBAL_ONLY);
}

void
reset_showregion()
{
	float center, diff;

	center = (endtime + starttime) / 2;
	diff = canvas_height * CANVAS_HEIGHT_RATIO / ratio;
	starttime = center - diff / 2.0; 
	endtime  = center + diff / 2.0; 
	subendtime = substarttime + subcanvas_height 
					* SUBCANVAS_HEIGHT_RATIO / subratio;
}

void
config_rectangle()
{
	float x1, y1, x2, y2, ry1, ry2, adj;
	char x1s[20], x2s[20], y1s[20], y2s[20];

	x1 = RECTLEDGE(subcanvas_width);
	x2 = RECTREDGE(subcanvas_width);
	ry1 = subcanvas_height * 4 * (starttime - substarttime)
				/ (subendtime - substarttime);
	ry2 = subcanvas_height * 4 * (endtime - substarttime)
				/ (subendtime - substarttime);

	/* XXX adjust view area */
	adj = (ry2 - ry1) / 4.0;
	y1 = ry1 + adj;
	y2 = ry2 - adj;

	sprintf(x1s, "%f", x1);
	sprintf(x2s, "%f", x2);
	sprintf(y1s, "%f", y1);
	sprintf(y2s, "%f", y2);

	Tcl_SetVar(interp, "rx1", x1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "rx2", x2s, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "ry1", y1s, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "ry2", y2s, TCL_GLOBAL_ONLY);
}

void
draw_canvas()
{
	config_lines();
	Tcl_Eval(interp, "eraselines");
	Tcl_Eval(interp, "drawlines");
	if (texton){
		config_texts();
		Tcl_Eval(interp, "erasetexts");
		Tcl_Eval(interp, "drawtexts");
	}
	if (timeon){
		config_times();
		Tcl_Eval(interp, "erasetimes");
		Tcl_Eval(interp, "drawtimes");
	}
}

void
draw_subcanvas()
{
	config_sublines();
	Tcl_Eval(interp, "erasesublines");
	Tcl_Eval(interp, "drawsublines");
}

void
draw_rectangle()
{
	config_rectangle();
	Tcl_Eval(interp, "erasebox");
	Tcl_Eval(interp, "drawbox");
	Tcl_Eval(interp, ".subframe1.canvas yview moveto 0.25");
}
