/* Created RJudd January 10, 1998 */
/* SPAWARSYSCEN D881 */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: vsip_vcreate_blackman_d.c,v 2.0 2003/02/22 15:19:12 judd Exp $ */
/* Removed Tisdale error checking Sept 00 */

#include<vsip.h>
#include<vsip_vviewattributes_d.h>
#include"VI_vcreate_d.h"

#define twoPI 6.2831853071796

vsip_vview_d* (vsip_vcreate_blackman_d)(
  vsip_length N, 
  vsip_memory_hint h) {
   vsip_vview_d *a;
   a  = VI_vcreate_d(N,h); 
   if(a == NULL) return (vsip_vview_d*)NULL;
   {
      /*define variables*/
      register unsigned int n =  0;
      vsip_scalar_d *ap  = (a->block->array) + a->offset,
                    temp1 = twoPI / (N - 1),
                    temp2 = 2 * temp1;
      /*end define*/
      /* Note this is always unit stride */
      while(n < N){
         *ap++ = 0.42 - 0.5 * (vsip_scalar_d)cos(temp1 * (vsip_scalar_d) n) + 
                   0.08 * (vsip_scalar_d)cos(temp2 * (vsip_scalar_d) n);
          n++;
      }
   }
   return a;
}
