/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "defs.h"
#include "global.h"
#include "struct.h"
#include "database.h"

/* Just a linked list for now.  Make it a hash table when there are more players...
 */

struct player_db {
	struct player_db *next;
	char name[MAXNAMELEN];
	char password[MAXNAMELEN];
	unsigned int wins, losses;
	unsigned int pickups, deliveries;
};

static struct player_db *first_pdb = NULL;

/* Called when the server starts up, then it just stays in memory. */
void database_init()
{
	FILE *plf;
	char line[256];
	struct player_db *new_pdb;
	char *c;

	if((plf = fopen(".players", "r")) != NULL) {
		while(!feof(plf)) {
			new_pdb = malloc(sizeof(struct player_db));
			if(fgets(line, 256, plf) != NULL) {
				if((c = index(line, '\n')) != NULL) 
					*c = 0;
				strcpy(new_pdb->name, line);
			}

			if(fgets(line, 256, plf) != NULL) {
				if(( c = index(line, '\n')) != NULL)
					*c = 0;
				strcpy(new_pdb->password, line);
			}

			if(fgets(line, 256, plf) != NULL) {
				if(sscanf(line, "%d,%d,%d,%d\n",
						  &new_pdb->wins, &new_pdb->losses,
						  &new_pdb->pickups, &new_pdb->deliveries) != 4) {
					fprintf(stderr, "Bad line in .players: %s\n", line);
				} else {
					fprintf(stderr, "Read player %s, %d/%d\n", new_pdb->name,
							new_pdb->wins, new_pdb->losses);
					new_pdb->next = first_pdb;
					first_pdb = new_pdb;
				}
			}
		}
		fclose(plf);
	} else {
		fprintf(stderr, "failed to open .players\n");
	}
}

void database_load(int pl)
{
	struct player_db *chk;

	if(strcmp("guest", GLO_players[pl].p_name) == 0) {
		GLO_players[pl].p_wins = GLO_players[pl].p_losses = 0;
		return;
	}

	for(chk = first_pdb; chk; chk = chk->next) {
		if(strcmp(chk->name, GLO_players[pl].p_name) == 0) {
			GLO_players[pl].p_wins   = chk->wins;
			GLO_players[pl].p_losses = chk->losses;
			return;
		}
	}

	/* If we get here, this is a new player */
	chk = malloc(sizeof(*chk));
	chk->next = first_pdb;
	first_pdb = chk;
	strcpy(chk->name, GLO_players[pl].p_name);
	chk->password[0] = 0;
	chk->wins = GLO_players[pl].p_wins = 0;
	chk->losses = GLO_players[pl].p_losses = 0;
	chk->pickups = chk->deliveries = 0;
}

void database_save(int pl)
{
	FILE *plf;
	struct player_db *pdb;

	if(strcmp(GLO_players[pl].p_name, "guest") == 0)
		return;

	for(pdb = first_pdb; pdb; pdb = pdb->next) {
		if(strcmp(pdb->name, GLO_players[pl].p_name) == 0) {
			pdb->wins   = GLO_players[pl].p_wins;
			pdb->losses = GLO_players[pl].p_losses;
		}
	}

	rename(".players", ".players.bak");
	
	if((plf = fopen(".players", "w")) != NULL) {
		for(pdb = first_pdb; pdb; pdb = pdb->next) {
			fprintf(plf, "%s\n%s\n%d,%d,%d,%d\n",
					pdb->name, pdb->password,
					pdb->wins, pdb->losses,
					pdb->pickups, pdb->deliveries);
		}
		fclose(plf);
	}
}

