open Types

(* bind the server socket *)
val bind_server : int -> Unix.file_descr

(* Closes a connexion *)
val close_connexion : connexion -> unit

(* put a connexion in a state where it just has to
 * finish writing data to the client and then exit *)
val finish : connexion -> string -> unit

(* read a whole file *)
val read_file : string -> string

(* hack for using the parser in the parser *)
val pars :
    (int -> Lexing.lexbuf -> string list) ref
val lex : int ref
val read_string_list : string -> string list

(* does the string match the pattern *)
val match_pattern : string -> string -> bool

(* decode password for authentication *)
val decode64 : string -> string

(* encode passwd for authentication *)
val encode64 : string -> string
