#include "stride.h"

int ReadPhiPsiMap(char *MapFile, float ***PhiPsiMap, COMMAND *Cmd)
{

  int i, j, NFields, Cnt=0;
  FILE *fi;
  BUFFER Buffer;
  char *Fields[MAX_FIELD];

  Cmd->NPixel = 0;

  if( (fi = fopen(MapFile,"r")) != 0 ) {

    while( fgets(Buffer,BUFSZ,fi) != NULL ) {
      if( !(NFields = SplitString(Buffer,Fields,MAX_FIELD)) ) continue;
      if( Cmd->NPixel == 0 ) {
	if( !strcmp(tolostr(Fields[0]),"npixel") ) {
	  Cmd->NPixel = atoi(Fields[1]);
	  if( Cmd->NPixel < 1 || Cmd->NPixel > 1000 ) 
	    die("Wrong number of pixels in the PhiPsi Map file %s\n",MapFile);
	  *PhiPsiMap = FloatMatrix(Cmd->NPixel,Cmd->NPixel);
	}
      }
      else  {
	if( !strcmp(tolostr(Fields[0]),"pixel") ) {
	  if( (i = atoi(Fields[1])) >= 0 && i < Cmd->NPixel &&
	      (j = atoi(Fields[2])) >= 0 && j < Cmd->NPixel &&
	     Cnt ==  i*Cmd->NPixel+j &&  NFields >= 4 ) {
	    (*PhiPsiMap)[i][j] = atof(Fields[5]);
	    Cnt++;
	  }
	  else die("Error in the PhiPsi Map file %s\n",MapFile);
	}
      }
    }
    fclose(fi);
    Cmd->PhiPsiStep = (MAXPHIPSI - MINPHIPSI)/(float)Cmd->NPixel;
  }
  
  if( !Cmd->NPixel ) die("Error reading PhiPsiMap file %s\n",MapFile);

  return(Cmd->NPixel);
}

float **DefaultHelixMap(COMMAND *Cmd)
{

  register int i;

  float **Map;
  static float Data[DEFNUMPIXEL][DEFNUMPIXEL] = {

      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0009014423, 0.0041898815,
      0.0085105160, 0.0133839026, 0.0245425366, 0.0407802090, 0.0464176536, 0.0330946408,
      0.0134803243, 0.0024038462, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0007370283, 0.0077203326, 0.0269849468,
      0.0492307022, 0.0621860325, 0.0747849122, 0.0919913873, 0.0918549150, 0.0617070347,
      0.0241584498, 0.0041428790, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0041416897, 0.0287234355, 0.0835687742,
      0.1384727061, 0.1562444866, 0.1470608264, 0.1360232681, 0.1159155145, 0.0742164999,
      0.0290896539, 0.0050673936, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0009375000, 0.0156580955, 0.0757770315, 0.1856354773,
      0.2785892785, 0.2880102694, 0.2332847565, 0.1741978228, 0.1281246394, 0.0793832615,
      0.0320557840, 0.0058840578, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0048893229, 0.0437000208, 0.1617751122, 0.3399706185,
      0.4626395404, 0.4418565035, 0.3235570788, 0.2100441158, 0.1358627081, 0.0776144490,
      0.0297011137, 0.0052390974, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0136979166, 0.0917820632, 0.2773087323, 0.5047551394,
      0.6214492917, 0.5485223532, 0.3655386865, 0.2054343373, 0.1121114418, 0.0548815951,
      0.0178668182, 0.0025975490, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0246484373, 0.1396044195, 0.3594934344, 0.5710113049,
      0.6337110400, 0.5133636594, 0.3054708838, 0.1402616948, 0.0584463216, 0.0228670351,
      0.0058531328, 0.0005151099, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0265885405, 0.1365883052, 0.3163702190, 0.4545661211,
      0.4628692269, 0.3425511420, 0.1761947423, 0.0607788190, 0.0158569515, 0.0042061093,
      0.0008107311, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0152018229, 0.0738445148, 0.1630392224, 0.2269553691,
      0.2237145752, 0.1528334022, 0.0652616471, 0.0150429625, 0.0014589608, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0035156249, 0.0165251363, 0.0379281938, 0.0584417619,
      0.0619409233, 0.0404052660, 0.0136552500, 0.0016678370, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0011718750, 0.0046875002,
      0.0070312503, 0.0046875002, 0.0011718750, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0006944445, 0.0036063762, 0.0080820229, 0.0101532144, 0.0076146079,
      0.0032324446, 0.0006009616, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000
  };


  Map = (float **)ckalloc(DEFNUMPIXEL*sizeof(float *));

  for( i=0; i<DEFNUMPIXEL; i++ )
    Map[i] = &(Data[i][0]);

  Cmd->NPixel = DEFNUMPIXEL;
  Cmd->PhiPsiStep = (MAXPHIPSI - MINPHIPSI)/(float)Cmd->NPixel;

  return(Map);
}


float **DefaultSheetMap(COMMAND *Cmd)
{

  register int i;
  float **Map;
  static float Data[DEFNUMPIXEL][DEFNUMPIXEL] = {

      0.2769023776, 0.1408346891, 0.0464910716, 0.0073784725, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0047086575, 0.0218229108, 0.0569166169,
      0.1254088134, 0.2340224832, 0.3511219919, 0.4355685711, 0.4584180117, 0.4007356465,
      0.4067636132, 0.2329865396, 0.0927943364, 0.0237838365, 0.0055147060, 0.0013786765,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0088186050, 0.0420726910, 0.1043856740,
      0.2086037844, 0.3677131534, 0.5367187858, 0.6412357688, 0.6458424330, 0.5580080152,
      0.4286311865, 0.2678007782, 0.1282834113, 0.0529448465, 0.0220588241, 0.0055147060,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0086062262, 0.0445192643, 0.1197573245,
      0.2487278134, 0.4369854629, 0.6241853237, 0.7160459757, 0.6829043031, 0.5716546178,
      0.3639202416, 0.2397334576, 0.1305907220, 0.0683420748, 0.0330882370, 0.0082720593,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0053559211, 0.0328565054, 0.1048930883,
      0.2402425259, 0.4295993447, 0.6026929021, 0.6669865251, 0.6039550304, 0.4841639400,
      0.2637948096, 0.1723874062, 0.0920098722, 0.0464194641, 0.0220588241, 0.0055147060,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0030202419, 0.0224239044, 0.0804052502,
      0.1923188865, 0.3456886411, 0.4811576009, 0.5223571062, 0.4586051404, 0.3565762639,
      0.1628032923, 0.0930610597, 0.0400134660, 0.0143100554, 0.0055147060, 0.0013786765,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0015453297, 0.0132468110, 0.0489843786,
      0.1174781919, 0.2150468081, 0.3082944453, 0.3439011276, 0.3080393970, 0.2371628135,
      0.0825822726, 0.0338854715, 0.0092895878, 0.0012122844, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0003863324, 0.0046614520, 0.0186656341,
      0.0477515720, 0.0961741805, 0.1546680480, 0.1961039603, 0.1944279373, 0.1469529718,
      0.0326442868, 0.0073916214, 0.0008854167, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0006347656, 0.0031504754,
      0.0104655549, 0.0272454955, 0.0570511036, 0.0941907763, 0.1088592261, 0.0785619915,
      0.0090501504, 0.0007651417, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0007207961, 0.0035958111, 0.0131648667, 0.0318824202, 0.0425693691, 0.0292618107,
      0.0013020834, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0013020834, 0.0052083335, 0.0078125000, 0.0052083335,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0210939310, 0.0078523019, 0.0013020834, 0.0000000000, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0014204546,
      0.0071634995, 0.0169352461, 0.0272206441, 0.0357281528, 0.0395361669, 0.0343801714,
      0.1146211401, 0.0503530800, 0.0130920913, 0.0015190972, 0.0000000000, 0.0000000000,
      0.0000000000, 0.0000000000, 0.0000000000, 0.0010016026, 0.0046167620, 0.0157516468,
      0.0453012958, 0.0937970504, 0.1454590708, 0.1861637682, 0.2019522935, 0.1764564067
  };

 
  Map = (float **)ckalloc(DEFNUMPIXEL*sizeof(float *));

  for( i=0; i<DEFNUMPIXEL; i++ )
    Map[i] = &(Data[i][0]);

  Cmd->NPixel = DEFNUMPIXEL;
  Cmd->PhiPsiStep = (MAXPHIPSI - MINPHIPSI)/(float)Cmd->NPixel;

  return(Map); 
}
