/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_NETWORK_PREFERENCES_PAGE_H
#define _ST_NETWORK_PREFERENCES_PAGE_H

#include <gtk/gtk.h>
#include "st-preferences-page.h"

#define ST_TYPE_NETWORK_PREFERENCES_PAGE		(st_network_preferences_page_get_type())
#define ST_NETWORK_PREFERENCES_PAGE(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_NETWORK_PREFERENCES_PAGE, STNetworkPreferencesPage))
#define ST_NETWORK_PREFERENCES_PAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_NETWORK_PREFERENCES_PAGE, STNetworkPreferencesPageClass))
#define ST_IS_NETWORK_PREFERENCES_PAGE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_NETWORK_PREFERENCES_PAGE))
#define ST_IS_NETWORK_PREFERENCES_PAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_NETWORK_PREFERENCES_PAGE))
#define ST_NETWORK_PREFERENCES_PAGE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_NETWORK_PREFERENCES_PAGE, STNetworkPreferencesPageClass))

typedef struct _STNetworkPreferencesPagePrivate STNetworkPreferencesPagePrivate;

typedef struct
{
  STPreferencesPage			page;
  
  STNetworkPreferencesPagePrivate	*priv;
} STNetworkPreferencesPage;

typedef struct
{
  STPreferencesPageClass		parent_class;
} STNetworkPreferencesPageClass;

GType st_network_preferences_page_get_type (void);
STPreferencesPage *st_network_preferences_page_new (void);

#endif /* _ST_NETWORK_PREFERENCES_PAGE_H */
