/*
 * addr_netcmp.c
 *
 * Just a simple function to determine if an CIDR block contained within
 * a struct addr is completely contained within another struct addr
 * that specifies a subnet. (Well, works for non IP addrs as well,
 * but you don't see "subnets" of those nearly as often).
 *
 * Returns 0 if it is within the subnet, -1 if not.
 *
 * Copyright (c) 2002, 2003 Todd MacDermid <tmacd@synacklabs.net>
 *
 */

#include <dnet.h>

int 
addr_netcmp(const struct addr *subnet, const struct addr *b)
{
  int i, j;
  uint8_t k;

  if (subnet->addr_type != b->addr_type)
    return(-1);

  if (subnet->addr_bits > b->addr_bits)
    return(-1);
  
  j = subnet->addr_bits/8; 

  for(i = 0; i < j; i ++)
    if(subnet->addr_data8[i] != b->addr_data8[i])
      return(-1);

  if(subnet->addr_bits%8 == 0)
    return(0);

  k = subnet->addr_bits%8;
  k = ~0 << (8 - k);

  if((subnet->addr_data8[j] & k) == (b->addr_data8[j] & k))
    return(0);
  
  return(-1);
}
