#include <stan/math/prim/scal/fun/grad_reg_lower_inc_gamma.hpp>
#include <gtest/gtest.h>
#include <vector>

// NOLINT()
TEST(PrimScalFun, lower_reg_inc_gamma_accuarcy) {
  const int n_tests = 9600;
  double const test[n_tests][3] = {{0.0001, 0.0001, -8.62594024578651},
                                   {0.0001, 0.2501, -1.043983702295472},
                                   {0.0001, 0.5001, -0.559710976064692},
                                   {0.0001, 0.7501, -0.3403330648538443},
                                   {0.0001, 1.0001, -0.2193920393374747},
                                   {0.0001, 1.2501, -0.146425360625888},
                                   {0.0001, 1.5001, -0.1000313789992058},
                                   {0.0001, 1.7501, -0.06949897554463814},
                                   {0.0001, 2.0001, -0.04890902060488023},
                                   {0.0001, 2.2501, -0.03476891380227148},
                                   {0.0001, 2.5001, -0.02492032641765518},
                                   {0.0001, 2.7501, -0.0179831704646452},
                                   {0.0001, 3.0001, -0.01305167061607386},
                                   {0.0001, 3.2501, -0.00951905263302263},
                                   {0.0001, 3.5001, -0.006972103062010499},
                                   {0.0001, 3.7501, -0.005125613208359185},
                                   {0.0001, 4.0001, -0.003780513627753275},
                                   {0.0001, 4.2501, -0.002796544177456598},
                                   {0.0001, 4.5001, -0.002074084638451469},
                                   {0.0001, 4.7501, -0.0015418890917538},
                                   {0.0001, 5.0001, -0.001148697556746513},
                                   {0.0001, 5.2501, -0.000857435176076771},
                                   {0.0001, 5.5001, -0.0006411621419087327},
                                   {0.0001, 5.7501, -0.0004802223213934926},
                                   {0.0001, 6.0001, -0.0003602211170155327},
                                   {0.0001, 6.2501, -0.0002705821702813008},
                                   {0.0001, 6.5001, -0.0002035113406328981},
                                   {0.0001, 6.7501, -0.0001532492594878595},
                                   {0.0001, 7.0001, -0.0001155296314952508},
                                   {0.0001, 7.2501, -0.0000871850461631746},
                                   {0.0001, 7.5001, -0.00006585907514253089},
                                   {0.0001, 7.7501, -0.00004979529568399881},
                                   {0.0001, 8.0001, -0.00003768221684757421},
                                   {0.0001, 8.2501, -0.00002853898014746541},
                                   {0.0001, 8.5001, -0.00002163089991709606},
                                   {0.0001, 8.7501, -0.00001640690785999976},
                                   {0.0001, 9.0001, -0.00001245312161953031},
                                   {0.0001, 9.2501, -9.4583129992176e-6},
                                   {0.0001, 9.5001, -7.188178997080442e-6},
                                   {0.0001, 9.7501, -5.466138982769719e-6},
                                   {0.0001, 10.0001, -4.158979942823098e-6},
                                   {0.0001, 10.2501, -3.166109956322839e-6},
                                   {0.0001, 10.5001, -2.411501820107549e-6},
                                   {0.0001, 10.7501, -1.837645597307558e-6},
                                   {0.0001, 11.0001, -1.40100364172525e-6},
                                   {0.0001, 11.2501, -1.068590921290271e-6},
                                   {0.0001, 11.5001, -8.15399266776583e-7},
                                   {0.0001, 11.7501, -6.22455316692474e-7},
                                   {0.0001, 12.0001, -4.753548581441044e-7},
                                   {0.0001, 12.2501, -3.631557035475979e-7},
                                   {0.0001, 12.5001, -2.775406821933887e-7},
                                   {0.0001, 12.7501, -2.121843332875009e-7},
                                   {0.0001, 13.0001, -1.622733575646538e-7},
                                   {0.0001, 13.2501, -1.241432313565997e-7},
                                   {0.0001, 13.5001, -9.50026546894601e-8},
                                   {0.0001, 13.7501, -7.272446442785173e-8},
                                   {0.0001, 14.0001, -5.568687998252415e-8},
                                   {0.0001, 14.2501, -4.265289395132516e-8},
                                   {0.0001, 14.5001, -3.267858916453952e-8},
                                   {0.0001, 14.7501, -2.504340556035019e-8},
                                   {0.0001, 15.0001, -1.919707530675899e-8},
                                   {0.0001, 15.2501, -1.47192210267613e-8},
                                   {0.0001, 15.5001, -1.128857961681753e-8},
                                   {0.0001, 15.7501, -8.65954930107857e-9},
                                   {0.0001, 16.0001, -6.644307750657985e-9},
                                   {0.0001, 16.2501, -5.09917273528946e-9},
                                   {0.0001, 16.5001, -3.914194969804656e-9},
                                   {0.0001, 16.7501, -3.005213070408504e-9},
                                   {0.0001, 17.0001, -2.307786302868633e-9},
                                   {0.0001, 17.2501, -1.772560160280509e-9},
                                   {0.0001, 17.5001, -1.361724085597672e-9},
                                   {0.0001, 17.7501, -1.046303552844242e-9},
                                   {0.0001, 18.0001, -8.04089873763009e-10},
                                   {0.0001, 18.2501, -6.180559178861024e-10},
                                   {0.0001, 18.5001, -4.751438689580329e-10},
                                   {0.0001, 18.7501, -3.653379783274905e-10},
                                   {0.0001, 19.0001, -2.809539265402833e-10},
                                   {0.0001, 19.2501, -2.160946256785452e-10},
                                   {0.0001, 19.5001, -1.662339936368609e-10},
                                   {0.0001, 19.7501, -1.278972830752892e-10},
                                   {0.0001, 20.0001, -9.84161242953885e-11},
                                   {0.0001, 20.2501, -7.574142324576107e-11},
                                   {0.0001, 20.5001, -5.829911997531613e-11},
                                   {0.0001, 20.7501, -4.48796186220117e-11},
                                   {0.0001, 21.0001, -3.455368164674726e-11},
                                   {0.0001, 21.2501, -2.660709213865518e-11},
                                   {0.0001, 21.5001, -2.049050684791712e-11},
                                   {0.0001, 21.7501, -1.578208744540922e-11},
                                   {0.0001, 22.0001, -1.215707657513748e-11},
                                   {0.0001, 22.2501, -9.36581701782006e-12},
                                   {0.0001, 22.5001, -7.21627159610253e-12},
                                   {0.0001, 22.7501, -5.56070274142e-12},
                                   {0.0001, 23.0001, -4.285436358317136e-12},
                                   {0.0001, 23.2501, -3.302995377488415e-12},
                                   {0.0001, 23.5001, -2.54605296628307e-12},
                                   {0.0001, 23.7501, -1.962784031329923e-12},
                                   {0.0001, 24.0001, -1.513290421500652e-12},
                                   {0.0001, 24.2501, -1.166852154862443e-12},
                                   {0.0001, 24.5001, -8.99813076886352e-13},
                                   {0.0001, 24.7501, -6.939542645798591e-13},
                                   {0.0001, 25.0001, -5.352425240798134e-13},
                                   {0.0001, 25.2501, -4.128676928257118e-13},
                                   {0.0001, 25.5001, -3.185010342657312e-13},
                                   {0.0001, 25.7501, -2.456454093954785e-13},
                                   {0.0001, 26.0001, -1.895331764797947e-13},
                                   {0.0001, 26.2501, -1.462512294429785e-13},
                                   {0.0001, 26.5001, -1.128626814402012e-13},
                                   {0.0001, 26.7501, -8.71038809656388e-14},
                                   {0.0001, 27.0001, -6.72295335721329e-14},
                                   {0.0001, 27.2501, -5.189403594341169e-14},
                                   {0.0001, 27.5001, -4.005980660040653e-14},
                                   {0.0001, 27.7501, -3.092675854993177e-14},
                                   {0.0001, 28.0001, -2.387770970530001e-14},
                                   {0.0001, 28.2501, -1.843669531279013e-14},
                                   {0.0001, 28.5001, -1.423660451679853e-14},
                                   {0.0001, 28.7501, -1.099408107954614e-14},
                                   {0.0001, 29.0001, -8.49071247338573e-15},
                                   {0.0001, 29.2501, -6.557796840278574e-15},
                                   {0.0001, 29.5001, -5.065284129635028e-15},
                                   {0.0001, 29.7501, -3.912723010174313e-15},
                                   {0.2501, 0.0001, -0.990158942354134},
                                   {0.2501, 0.2501, -0.977313778091076},
                                   {0.2501, 0.5001, -0.6501744076885957},
                                   {0.2501, 0.7501, -0.450748610937528},
                                   {0.2501, 1.0001, -0.3196508046930008},
                                   {0.2501, 1.2501, -0.2300281566139779},
                                   {0.2501, 1.5001, -0.1672613137177786},
                                   {0.2501, 1.7501, -0.122573713819852},
                                   {0.2501, 2.0001, -0.0903753001449793},
                                   {0.2501, 2.2501, -0.06696377355711272},
                                   {0.2501, 2.5001, -0.04981900144902351},
                                   {0.2501, 2.7501, -0.03719072459987607},
                                   {0.2501, 3.0001, -0.02784466926035025},
                                   {0.2501, 3.2501, -0.02089998687505484},
                                   {0.2501, 3.5001, -0.01572202844502455},
                                   {0.2501, 3.7501, -0.01184996145395173},
                                   {0.2501, 4.0001, -0.00894700201923156},
                                   {0.2501, 4.2501, -0.006765686358681361},
                                   {0.2501, 4.5001, -0.005123341960993142},
                                   {0.2501, 4.7501, -0.003884588459400138},
                                   {0.2501, 5.0001, -0.002948748421800567},
                                   {0.2501, 5.2501, -0.002240725915580562},
                                   {0.2501, 5.5001, -0.001704357432052404},
                                   {0.2501, 5.7501, -0.001297539649892971},
                                   {0.2501, 6.0001, -0.000988642976618364},
                                   {0.2501, 6.2501, -0.0007538610560090487},
                                   {0.2501, 6.5001, -0.000575245125781075},
                                   {0.2501, 6.7501, -0.000439241752207222},
                                   {0.2501, 7.0001, -0.0003356020314367867},
                                   {0.2501, 7.2501, -0.000256565882035104},
                                   {0.2501, 7.5001, -0.0001962506978326574},
                                   {0.2501, 7.7501, -0.0001501922429166681},
                                   {0.2501, 8.0001, -0.0001149992488062129},
                                   {0.2501, 8.2501, -0.0000880931235823753},
                                   {0.2501, 8.5001, -0.00006751150310486271},
                                   {0.2501, 8.7501, -0.00005175977986025906},
                                   {0.2501, 9.0001, -0.00003969874871523852},
                                   {0.2501, 9.2501, -0.00003045948375958945},
                                   {0.2501, 9.5001, -0.00002337877599982668},
                                   {0.2501, 9.7501, -0.00001795011607765785},
                                   {0.2501, 10.0001, -0.00001378644427820865},
                                   {0.2501, 10.2501, -0.00001059181808423896},
                                   {0.2501, 10.5001, -8.139844878602e-6},
                                   {0.2501, 10.7501, -6.257251853991112e-6},
                                   {0.2501, 11.0001, -4.811360577628015e-6},
                                   {0.2501, 11.2501, -3.700531690673756e-6},
                                   {0.2501, 11.5001, -2.84687099564814e-6},
                                   {0.2501, 11.7501, -2.190658295373706e-6},
                                   {0.2501, 12.0001, -1.68608975749912e-6},
                                   {0.2501, 12.2501, -1.298022365052601e-6},
                                   {0.2501, 12.5001, -9.994832838348e-7},
                                   {0.2501, 12.7501, -7.697636718195224e-7},
                                   {0.2501, 13.0001, -5.92958972087415e-7},
                                   {0.2501, 13.2501, -4.568506125325698e-7},
                                   {0.2501, 13.5001, -3.520491286321652e-7},
                                   {0.2501, 13.7501, -2.713370705369982e-7},
                                   {0.2501, 14.0001, -2.091650983196083e-7},
                                   {0.2501, 14.2501, -1.612653756898004e-7},
                                   {0.2501, 14.5001, -1.243547714349915e-7},
                                   {0.2501, 14.7501, -9.59071703377253e-8},
                                   {0.2501, 15.0001, -7.397839214384804e-8},
                                   {0.2501, 15.2501, -5.70718310605134e-8},
                                   {0.2501, 15.5001, -4.403520246596896e-8},
                                   {0.2501, 15.7501, -3.398111452969471e-8},
                                   {0.2501, 16.0001, -2.622605795505153e-8},
                                   {0.2501, 16.2501, -2.024343538745615e-8},
                                   {0.2501, 16.5001, -1.562751480186833e-8},
                                   {0.2501, 16.7501, -1.206558867905033e-8},
                                   {0.2501, 17.0001, -9.31663208370699e-9},
                                   {0.2501, 17.2501, -7.194797026551749e-9},
                                   {0.2501, 17.5001, -5.556833676115023e-9},
                                   {0.2501, 17.7501, -4.292237845911373e-9},
                                   {0.2501, 18.0001, -3.31577927101339e-9},
                                   {0.2501, 18.2501, -2.561725636345279e-9},
                                   {0.2501, 18.5001, -1.979362442165261e-9},
                                   {0.2501, 18.7501, -1.529527860077386e-9},
                                   {0.2501, 19.0001, -1.182040544370188e-9},
                                   {0.2501, 19.2501, -9.13583473900247e-10},
                                   {0.2501, 19.5001, -7.061640845302191e-10},
                                   {0.2501, 19.7501, -5.458824228235435e-10},
                                   {0.2501, 20.0001, -4.220173009294218e-10},
                                   {0.2501, 20.2501, -3.26285934218042e-10},
                                   {0.2501, 20.5001, -2.522929391595634e-10},
                                   {0.2501, 20.7501, -1.95095264439073e-10},
                                   {0.2501, 21.0001, -1.508752188900844e-10},
                                   {0.2501, 21.2501, -1.166877731488787e-10},
                                   {0.2501, 21.5001, -9.02671612480166e-11},
                                   {0.2501, 21.7501, -6.981345940966502e-11},
                                   {0.2501, 22.0001, -5.400863847922271e-11},
                                   {0.2501, 22.2501, -4.179277532353923e-11},
                                   {0.2501, 22.5001, -3.23308260447305e-11},
                                   {0.2501, 22.7501, -2.501936466853711e-11},
                                   {0.2501, 23.0001, -1.936068692637376e-11},
                                   {0.2501, 23.2501, -1.497676385917116e-11},
                                   {0.2501, 23.5001, -1.159126912568956e-11},
                                   {0.2501, 23.7501, -8.97108198850357e-12},
                                   {0.2501, 24.0001, -6.947135260619593e-12},
                                   {0.2501, 24.2501, -5.373994707699191e-12},
                                   {0.2501, 24.5001, -4.159902420096881e-12},
                                   {0.2501, 24.7501, -3.220423118694748e-12},
                                   {0.2501, 25.0001, -2.493096572422168e-12},
                                   {0.2501, 25.2501, -1.930132144915722e-12},
                                   {0.2501, 25.5001, -1.495052353663491e-12},
                                   {0.2501, 25.7501, -1.167101441639733e-12},
                                   {0.2501, 26.0001, -8.95996324210035e-13},
                                   {0.2501, 26.2501, -7.05795784313902e-13},
                                   {0.2501, 26.5001, -5.373237011045537e-13},
                                   {0.2501, 26.7501, -4.17015087949817e-13},
                                   {0.2501, 27.0001, -3.345331446261404e-13},
                                   {0.2501, 27.2501, -2.54865735034997e-13},
                                   {0.2501, 27.5001, -1.960256769970598e-13},
                                   {0.2501, 27.7501, -1.532786558872271e-13},
                                   {0.2501, 28.0001, -1.259807353796681e-13},
                                   {0.2501, 28.2501, -9.43658927959158e-14},
                                   {0.2501, 28.5001, -6.965955903152912e-14},
                                   {0.2501, 28.7501, -5.460208508091108e-14},
                                   {0.2501, 29.0001, -4.595151515408268e-14},
                                   {0.2501, 29.2501, -3.243935582649153e-14},
                                   {0.2501, 29.5001, -2.761896857609424e-14},
                                   {0.2501, 29.7501, -2.171738875097303e-14},
                                   {0.5001, 0.0001, -0.1042409501459808},
                                   {0.5001, 0.2501, -0.7978156547799145},
                                   {0.5001, 0.5001, -0.6471233014932263},
                                   {0.5001, 0.7501, -0.5049527448985353},
                                   {0.5001, 1.0001, -0.3898178624664172},
                                   {0.5001, 1.2501, -0.2997728627807467},
                                   {0.5001, 1.5001, -0.2301933518760258},
                                   {0.5001, 1.7501, -0.1766872934497418},
                                   {0.5001, 2.0001, -0.1356232765850561},
                                   {0.5001, 2.2501, -0.104130471527128},
                                   {0.5001, 2.5001, -0.079980300783083},
                                   {0.5001, 2.7501, -0.06145685750074729},
                                   {0.5001, 3.0001, -0.04724395932624462},
                                   {0.5001, 3.2501, -0.03633371329148346},
                                   {0.5001, 3.5001, -0.02795475776137188},
                                   {0.5001, 3.7501, -0.02151676324948343},
                                   {0.5001, 4.0001, -0.01656781594735981},
                                   {0.5001, 4.2501, -0.0127618088745892},
                                   {0.5001, 4.5001, -0.00983353053064772},
                                   {0.5001, 4.7501, -0.007579644531078157},
                                   {0.5001, 5.0001, -0.005844166703643423},
                                   {0.5001, 5.2501, -0.004507372277144043},
                                   {0.5001, 5.5001, -0.003477318549618584},
                                   {0.5001, 5.7501, -0.002683362362161241},
                                   {0.5001, 6.0001, -0.002071199744292454},
                                   {0.5001, 6.2501, -0.001599067807673684},
                                   {0.5001, 6.5001, -0.001234834683806334},
                                   {0.5001, 6.7501, -0.000953768477201762},
                                   {0.5001, 7.0001, -0.0007368257752319335},
                                   {0.5001, 7.2501, -0.0005693379776164228},
                                   {0.5001, 7.5001, -0.000440002434936816},
                                   {0.5001, 7.7501, -0.0003401072793396845},
                                   {0.5001, 8.0001, -0.0002629355307599279},
                                   {0.5001, 8.2501, -0.0002033068111770437},
                                   {0.5001, 8.5001, -0.0001572247402519583},
                                   {0.5001, 8.7501, -0.0001216055338614379},
                                   {0.5001, 9.0001, -0.0000940690264162397},
                                   {0.5001, 9.2501, -0.00007277770211497002},
                                   {0.5001, 9.5001, -0.00005631266443612959},
                                   {0.5001, 9.7501, -0.0000435780372647914},
                                   {0.5001, 10.0001, -0.00003372725820926423},
                                   {0.5001, 10.2501, -0.00002610623469801939},
                                   {0.5001, 10.5001, -0.0000202094931910444},
                                   {0.5001, 10.7501, -0.00001564634299051179},
                                   {0.5001, 11.0001, -0.00001211476121600677},
                                   {0.5001, 11.2501, -9.38123240121102e-6},
                                   {0.5001, 11.5001, -7.26518156506191e-6},
                                   {0.5001, 11.7501, -5.626951647417578e-6},
                                   {0.5001, 12.0001, -4.35851646475043e-6},
                                   {0.5001, 12.2501, -3.376305407403938e-6},
                                   {0.5001, 12.5001, -2.615658694759707e-6},
                                   {0.5001, 12.7501, -2.026541909043717e-6},
                                   {0.5001, 13.0001, -1.570233261668579e-6},
                                   {0.5001, 13.2501, -1.216762391025611e-6},
                                   {0.5001, 13.5001, -9.42929897080865e-7},
                                   {0.5001, 13.7501, -7.307757108526447e-7},
                                   {0.5001, 14.0001, -5.663944129450216e-7},
                                   {0.5001, 14.2501, -4.390187859848185e-7},
                                   {0.5001, 14.5001, -3.403107760825219e-7},
                                   {0.5001, 14.7501, -2.638128545206909e-7},
                                   {0.5001, 15.0001, -2.045234426942309e-7},
                                   {0.5001, 15.2501, -1.585683080043277e-7},
                                   {0.5001, 15.5001, -1.229462091107232e-7},
                                   {0.5001, 15.7501, -9.53319924663129e-8},
                                   {0.5001, 16.0001, -7.392414776729984e-8},
                                   {0.5001, 16.2501, -5.732677210253114e-8},
                                   {0.5001, 16.5001, -4.445816746970772e-8},
                                   {0.5001, 16.7501, -3.448005553631793e-8},
                                   {0.5001, 17.0001, -2.674275414423088e-8},
                                   {0.5001, 17.2501, -2.074271253700901e-8},
                                   {0.5001, 17.5001, -1.608961652277848e-8},
                                   {0.5001, 17.7501, -1.248090478004855e-8},
                                   {0.5001, 18.0001, -9.6820250161644e-9},
                                   {0.5001, 18.2501, -7.511135972837353e-9},
                                   {0.5001, 18.5001, -5.827253290143784e-9},
                                   {0.5001, 18.7501, -4.521063283864486e-9},
                                   {0.5001, 19.0001, -3.507803688006589e-9},
                                   {0.5001, 19.2501, -2.721745901431509e-9},
                                   {0.5001, 19.5001, -2.111918188312685e-9},
                                   {0.5001, 19.7501, -1.638790524673392e-9},
                                   {0.5001, 20.0001, -1.271704700696579e-9},
                                   {0.5001, 20.2501, -9.86882020431536e-10},
                                   {0.5001, 20.5001, -7.658786893659302e-10},
                                   {0.5001, 20.7501, -5.943882199183195e-10},
                                   {0.5001, 21.0001, -4.613128401852511e-10},
                                   {0.5001, 21.2501, -3.580434430019636e-10},
                                   {0.5001, 21.5001, -2.779012113641017e-10},
                                   {0.5001, 21.7501, -2.157045957183752e-10},
                                   {0.5001, 22.0001, -1.674334855180339e-10},
                                   {0.5001, 22.2501, -1.299687454836587e-10},
                                   {0.5001, 22.5001, -1.0089019449608e-10},
                                   {0.5001, 22.7501, -7.831990609213923e-11},
                                   {0.5001, 23.0001, -6.080065715205666e-11},
                                   {0.5001, 23.2501, -4.72016371288821e-11},
                                   {0.5001, 23.5001, -3.664530059726814e-11},
                                   {0.5001, 23.7501, -2.845061924987385e-11},
                                   {0.5001, 24.0001, -2.208905534605293e-11},
                                   {0.5001, 24.2501, -1.715040312501526e-11},
                                   {0.5001, 24.5001, -1.331628491877362e-11},
                                   {0.5001, 24.7501, -1.033958665565422e-11},
                                   {0.5001, 25.0001, -8.02850033993509e-12},
                                   {0.5001, 25.2501, -6.234141260847802e-12},
                                   {0.5001, 25.5001, -4.84093906735516e-12},
                                   {0.5001, 25.7501, -3.759180523492731e-12},
                                   {0.5001, 26.0001, -2.919222158308545e-12},
                                   {0.5001, 26.2501, -2.266999065541885e-12},
                                   {0.5001, 26.5001, -1.760538812946796e-12},
                                   {0.5001, 26.7501, -1.367255710958669e-12},
                                   {0.5001, 27.0001, -1.061851120652649e-12},
                                   {0.5001, 27.2501, -8.24683082860664e-13},
                                   {0.5001, 27.5001, -6.405011865487048e-13},
                                   {0.5001, 27.7501, -4.9746449125161e-13},
                                   {0.5001, 28.0001, -3.863788585872507e-13},
                                   {0.5001, 28.2501, -3.0010522009743e-13},
                                   {0.5001, 28.5001, -2.33100201636437e-13},
                                   {0.5001, 28.7501, -1.81059138706783e-13},
                                   {0.5001, 29.0001, -1.406392992686649e-13},
                                   {0.5001, 29.2501, -1.092449926944617e-13},
                                   {0.5001, 29.5001, -8.48602975892588e-14},
                                   {0.5001, 29.7501, -6.591977875204024e-14},
                                   {0.7501, 0.0001, -0.01028066720069231},
                                   {0.7501, 0.2501, -0.5945738953901775},
                                   {0.7501, 0.5001, -0.583371985515663},
                                   {0.7501, 0.7501, -0.5095306268969905},
                                   {0.7501, 1.0001, -0.4263545216729358},
                                   {0.7501, 1.2501, -0.3491155338991256},
                                   {0.7501, 1.5001, -0.2822418357285079},
                                   {0.7501, 1.7501, -0.2262954861691384},
                                   {0.7501, 2.0001, -0.1804017320836402},
                                   {0.7501, 2.2501, -0.1432186667732347},
                                   {0.7501, 2.5001, -0.1133446043205894},
                                   {0.7501, 2.7501, -0.0894853744609441},
                                   {0.7501, 3.0001, -0.07051352083148044},
                                   {0.7501, 3.2501, -0.05547824438554452},
                                   {0.7501, 3.5001, -0.04359372805085942},
                                   {0.7501, 3.7501, -0.03421915707463454},
                                   {0.7501, 4.0001, -0.02683683966453708},
                                   {0.7501, 4.2501, -0.02103139318526969},
                                   {0.7501, 4.5001, -0.01647122595793014},
                                   {0.7501, 4.7501, -0.0128926747502858},
                                   {0.7501, 5.0001, -0.01008673659436722},
                                   {0.7501, 5.2501, -0.007888146417579978},
                                   {0.7501, 5.5001, -0.006166486318057176},
                                   {0.7501, 5.7501, -0.004819007855737829},
                                   {0.7501, 6.0001, -0.003764873076535482},
                                   {0.7501, 6.2501, -0.00294055585965162},
                                   {0.7501, 6.5001, -0.002296183577811611},
                                   {0.7501, 6.7501, -0.001792635538253657},
                                   {0.7501, 7.0001, -0.001399247267017725},
                                   {0.7501, 7.2501, -0.001091997782139745},
                                   {0.7501, 7.5001, -0.000852080630999476},
                                   {0.7501, 7.7501, -0.0006647790272229109},
                                   {0.7501, 8.0001, -0.0005185814244685204},
                                   {0.7501, 8.2501, -0.0004044868410720126},
                                   {0.7501, 8.5001, -0.0003154597024825012},
                                   {0.7501, 8.7501, -0.0002460023444881479},
                                   {0.7501, 9.0001, -0.0001918200041419662},
                                   {0.7501, 9.2501, -0.0001495584409892837},
                                   {0.7501, 9.5001, -0.0001165985471205764},
                                   {0.7501, 9.7501, -0.0000908956406455549},
                                   {0.7501, 10.0001, -0.00007085377200128708},
                                   {0.7501, 10.2501, -0.00005522745013088825},
                                   {0.7501, 10.5001, -0.00004304483159119173},
                                   {0.7501, 10.7501, -0.00003354770242114109},
                                   {0.7501, 11.0001, -0.00002614459365961335},
                                   {0.7501, 11.2501, -0.00002037416512231166},
                                   {0.7501, 11.5001, -0.00001587661467319571},
                                   {0.7501, 11.7501, -0.00001237135830966696},
                                   {0.7501, 12.0001, -9.63960876855331e-6},
                                   {0.7501, 12.2501, -7.510779783344582e-6},
                                   {0.7501, 12.5001, -5.851877472990376e-6},
                                   {0.7501, 12.7501, -4.559223684880672e-6},
                                   {0.7501, 13.0001, -3.551999497938017e-6},
                                   {0.7501, 13.2501, -2.767209187420873e-6},
                                   {0.7501, 13.5001, -2.155752561837285e-6},
                                   {0.7501, 13.7501, -1.679362034641634e-6},
                                   {0.7501, 14.0001, -1.30821426463877e-6},
                                   {0.7501, 14.2501, -1.019067958482963e-6},
                                   {0.7501, 14.5001, -7.938120348665015e-7},
                                   {0.7501, 14.7501, -6.183338044677306e-7},
                                   {0.7501, 15.0001, -4.816366876932629e-7},
                                   {0.7501, 15.2501, -3.751524973366349e-7},
                                   {0.7501, 15.5001, -2.922054117915707e-7},
                                   {0.7501, 15.7501, -2.275942035881978e-7},
                                   {0.7501, 16.0001, -1.772666514238113e-7},
                                   {0.7501, 16.2501, -1.380658073444989e-7},
                                   {0.7501, 16.5001, -1.075322702061819e-7},
                                   {0.7501, 16.7501, -8.3750109843519e-8},
                                   {0.7501, 17.0001, -6.522681036204654e-8},
                                   {0.7501, 17.2501, -5.079972488977526e-8},
                                   {0.7501, 17.5001, -3.956319003513204e-8},
                                   {0.7501, 17.7501, -3.081173923075574e-8},
                                   {0.7501, 18.0001, -2.39958604757514e-8},
                                   {0.7501, 18.2501, -1.868752841189377e-8},
                                   {0.7501, 18.5001, -1.455335208188613e-8},
                                   {0.7501, 18.7501, -1.133365625222692e-8},
                                   {0.7501, 19.0001, -8.82618557249609e-9},
                                   {0.7501, 19.2501, -6.873410273915194e-9},
                                   {0.7501, 19.5001, -5.352637659793781e-9},
                                   {0.7501, 19.7501, -4.168309397450668e-9},
                                   {0.7501, 20.0001, -3.246001576245768e-9},
                                   {0.7501, 20.2501, -2.527751208989291e-9},
                                   {0.7501, 20.5001, -1.968415999313136e-9},
                                   {0.7501, 20.7501, -1.532838980139806e-9},
                                   {0.7501, 21.0001, -1.193640100325019e-9},
                                   {0.7501, 21.2501, -9.29496157111407e-10},
                                   {0.7501, 21.5001, -7.238011076796518e-10},
                                   {0.7501, 21.7501, -5.636226569506881e-10},
                                   {0.7501, 22.0001, -4.388896102171513e-10},
                                   {0.7501, 22.2501, -3.417589626085624e-10},
                                   {0.7501, 22.5001, -2.661229782127749e-10},
                                   {0.7501, 22.7501, -2.072252996448122e-10},
                                   {0.7501, 23.0001, -1.613619754589275e-10},
                                   {0.7501, 23.2501, -1.256486231906376e-10},
                                   {0.7501, 23.5001, -9.78391003138421e-11},
                                   {0.7501, 23.7501, -7.618429024858376e-11},
                                   {0.7501, 24.0001, -5.932212944510416e-11},
                                   {0.7501, 24.2501, -4.619196497948446e-11},
                                   {0.7501, 24.5001, -3.596786066940989e-11},
                                   {0.7501, 24.7501, -2.800665906024757e-11},
                                   {0.7501, 25.0001, -2.180753553882739e-11},
                                   {0.7501, 25.2501, -1.698050175672714e-11},
                                   {0.7501, 25.5001, -1.322187812564935e-11},
                                   {0.7501, 25.7501, -1.029519394681725e-11},
                                   {0.7501, 26.0001, -8.0163140184033e-12},
                                   {0.7501, 26.2501, -6.241856255786211e-12},
                                   {0.7501, 26.5001, -4.86017270146613e-12},
                                   {0.7501, 26.7501, -3.784326416232786e-12},
                                   {0.7501, 27.0001, -2.946622233455421e-12},
                                   {0.7501, 27.2501, -2.294348379632699e-12},
                                   {0.7501, 27.5001, -1.786460179301051e-12},
                                   {0.7501, 27.7501, -1.390997714463507e-12},
                                   {0.7501, 28.0001, -1.083075263150124e-12},
                                   {0.7501, 28.2501, -8.43315442162559e-13},
                                   {0.7501, 28.5001, -6.566299108010214e-13},
                                   {0.7501, 28.7501, -5.112702432928194e-13},
                                   {0.7501, 29.0001, -3.980885517594293e-13},
                                   {0.7501, 29.2501, -3.099617590690436e-13},
                                   {0.7501, 29.5001, -2.413436784277309e-13},
                                   {0.7501, 29.7501, -1.87915717191205e-13},
                                   {1.0001, 0.0001, -0.000962345763297453},
                                   {1.0001, 0.2501, -0.4141698684811926},
                                   {1.0001, 0.5001, -0.4894243315077763},
                                   {1.0001, 0.7501, -0.4770746176502396},
                                   {1.0001, 1.0001, -0.4317051162837499},
                                   {1.0001, 1.2501, -0.375703332622927},
                                   {1.0001, 1.5001, -0.3192748912908745},
                                   {1.0001, 1.7501, -0.26703470961508},
                                   {1.0001, 2.0001, -0.220823089869113},
                                   {1.0001, 2.2501, -0.1810714393551319},
                                   {1.0001, 2.5001, -0.1475106280642932},
                                   {1.0001, 2.7501, -0.1195506055360235},
                                   {1.0001, 3.0001, -0.0964853400904698},
                                   {1.0001, 3.2501, -0.0776015075845087},
                                   {1.0001, 3.5001, -0.0622331514339288},
                                   {1.0001, 3.7501, -0.04978591575338597},
                                   {1.0001, 4.0001, -0.03974436430261933},
                                   {1.0001, 4.2501, -0.0316702204139279},
                                   {1.0001, 4.5001, -0.02519608158794056},
                                   {1.0001, 4.7501, -0.02001723188980713},
                                   {1.0001, 5.0001, -0.01588302821610018},
                                   {1.0001, 5.2501, -0.01258865333498786},
                                   {1.0001, 5.5001, -0.00996762403686369},
                                   {1.0001, 5.7501, -0.007885206901751685},
                                   {1.0001, 6.0001, -0.006232760833357277},
                                   {1.0001, 6.2501, -0.004922954181022386},
                                   {1.0001, 6.5001, -0.003885770092785043},
                                   {1.0001, 6.7501, -0.003065201365702782},
                                   {1.0001, 7.0001, -0.002416536027149096},
                                   {1.0001, 7.2501, -0.0019041414073973},
                                   {1.0001, 7.5001, -0.001499664058674784},
                                   {1.0001, 7.7501, -0.001180573482458218},
                                   {1.0001, 8.0001, -0.000928988081084559},
                                   {1.0001, 8.2501, -0.0007307314379769013},
                                   {1.0001, 8.5001, -0.000574575672807152},
                                   {1.0001, 8.7501, -0.0004516361306719691},
                                   {1.0001, 9.0001, -0.0003548880761712645},
                                   {1.0001, 9.2501, -0.0002787814607675328},
                                   {1.0001, 9.5001, -0.0002189343275521182},
                                   {1.0001, 9.7501, -0.0001718891309778837},
                                   {1.0001, 10.0001, -0.000134919295714304},
                                   {1.0001, 10.2501, -0.0001058758244621246},
                                   {1.0001, 10.5001, -0.0000830657832542029},
                                   {1.0001, 10.7501, -0.00006515612582683511},
                                   {1.0001, 11.0001, -0.0000510976353583248},
                                   {1.0001, 11.2501, -0.00004006482048822805},
                                   {1.0001, 11.5001, -0.00003140845153290263},
                                   {1.0001, 11.7501, -0.00002461810222999825},
                                   {1.0001, 12.0001, -0.00001929260501250049},
                                   {1.0001, 12.2501, -0.0000151167605228799},
                                   {1.0001, 12.5001, -0.00001184298659018818},
                                   {1.0001, 12.7501, -9.27686581454308e-6},
                                   {1.0001, 13.0001, -7.265768434102238e-6},
                                   {1.0001, 13.2501, -5.689899708881565e-6},
                                   {1.0001, 13.5001, -4.455257804710364e-6},
                                   {1.0001, 13.7501, -3.488096432662628e-6},
                                   {1.0001, 14.0001, -2.730572153662993e-6},
                                   {1.0001, 14.2501, -2.137323968058867e-6},
                                   {1.0001, 14.5001, -1.672786297760891e-6},
                                   {1.0001, 14.7501, -1.309078694305963e-6},
                                   {1.0001, 15.0001, -1.024348921393561e-6},
                                   {1.0001, 15.2501, -8.01472330968527e-7},
                                   {1.0001, 15.5001, -6.270311568398466e-7},
                                   {1.0001, 15.7501, -4.905136605094329e-7},
                                   {1.0001, 16.0001, -3.836859072431481e-7},
                                   {1.0001, 16.2501, -3.000990593546211e-7},
                                   {1.0001, 16.5001, -2.347030272859729e-7},
                                   {1.0001, 16.7501, -1.835435746227218e-7},
                                   {1.0001, 17.0001, -1.435248915283278e-7},
                                   {1.0001, 17.2501, -1.122235168310656e-7},
                                   {1.0001, 17.5001, -8.77425264974018e-8},
                                   {1.0001, 17.7501, -6.859729225815913e-8},
                                   {1.0001, 18.0001, -5.362598793367397e-8},
                                   {1.0001, 18.2501, -4.191949213362317e-8},
                                   {1.0001, 18.5001, -3.276649073224751e-8},
                                   {1.0001, 18.7501, -2.561048868266631e-8},
                                   {1.0001, 19.0001, -2.001615168636811e-8},
                                   {1.0001, 19.2501, -1.564295591485084e-8},
                                   {1.0001, 19.5001, -1.222456134431556e-8},
                                   {1.0001, 19.7501, -9.55266720855807e-9},
                                   {1.0001, 20.0001, -7.46437693322817e-9},
                                   {1.0001, 20.2501, -5.832310655402009e-9},
                                   {1.0001, 20.5001, -4.556868593699582e-9},
                                   {1.0001, 20.7501, -3.560177952487778e-9},
                                   {1.0001, 21.0001, -2.781357438430585e-9},
                                   {1.0001, 21.2501, -2.172812898819293e-9},
                                   {1.0001, 21.5001, -1.697339803797638e-9},
                                   {1.0001, 21.7501, -1.325857017579217e-9},
                                   {1.0001, 22.0001, -1.035634457393252e-9},
                                   {1.0001, 22.2501, -8.08907109716206e-10},
                                   {1.0001, 22.5001, -6.317912602558349e-10},
                                   {1.0001, 22.7501, -4.93437100234713e-10},
                                   {1.0001, 23.0001, -3.853661991067613e-10},
                                   {1.0001, 23.2501, -3.009535480507637e-10},
                                   {1.0001, 23.5001, -2.350226536639737e-10},
                                   {1.0001, 23.7501, -1.835290266522468e-10},
                                   {1.0001, 24.0001, -1.433127832144328e-10},
                                   {1.0001, 24.2501, -1.119052795513331e-10},
                                   {1.0001, 24.5001, -8.73779863423413e-11},
                                   {1.0001, 24.7501, -6.822438321988069e-11},
                                   {1.0001, 25.0001, -5.326766332281693e-11},
                                   {1.0001, 25.2501, -4.158861108923706e-11},
                                   {1.0001, 25.5001, -3.24692472912472e-11},
                                   {1.0001, 25.7501, -2.534879630204826e-11},
                                   {1.0001, 26.0001, -1.978928262739444e-11},
                                   {1.0001, 26.2501, -1.544865287280909e-11},
                                   {1.0001, 26.5001, -1.20597773620769e-11},
                                   {1.0001, 26.7501, -9.41404618203215e-12},
                                   {1.0001, 27.0001, -7.348555184345913e-12},
                                   {1.0001, 27.2501, -5.736096287433728e-12},
                                   {1.0001, 27.5001, -4.477338874493617e-12},
                                   {1.0001, 27.7501, -3.494723213741567e-12},
                                   {1.0001, 28.0001, -2.72769056535658e-12},
                                   {1.0001, 28.2501, -2.128958126872893e-12},
                                   {1.0001, 28.5001, -1.66160982613137e-12},
                                   {1.0001, 28.7501, -1.296824147198486e-12},
                                   {1.0001, 29.0001, -1.012099964835706e-12},
                                   {1.0001, 29.2501, -7.898711051445597e-13},
                                   {1.0001, 29.5001, -6.164242366668562e-13},
                                   {1.0001, 29.7501, -4.810541829766711e-13},
                                   {1.2501, 0.0001, -0.0000862561936285953},
                                   {1.2501, 0.2501, -0.2734984125240663},
                                   {1.2501, 0.5001, -0.3882007009013014},
                                   {1.2501, 0.7501, -0.4215477222514126},
                                   {1.2501, 1.0001, -0.4119540038013453},
                                   {1.2501, 1.2501, -0.3806102141928961},
                                   {1.2501, 1.5001, -0.3396714440752313},
                                   {1.2501, 1.7501, -0.2961132735149526},
                                   {1.2501, 2.0001, -0.2538263985089672},
                                   {1.2501, 2.2501, -0.2148388045527575},
                                   {1.2501, 2.5001, -0.1800567720785596},
                                   {1.2501, 2.7501, -0.1497231717921676},
                                   {1.2501, 3.0001, -0.1237031075879498},
                                   {1.2501, 3.2501, -0.1016616089520168},
                                   {1.2501, 3.5001, -0.0831729197351039},
                                   {1.2501, 3.7501, -0.06778619233141825},
                                   {1.2501, 4.0001, -0.05506341810367596},
                                   {1.2501, 4.2501, -0.04459980105100315},
                                   {1.2501, 4.5001, -0.03603318891259807},
                                   {1.2501, 4.7501, -0.02904684925158036},
                                   {1.2501, 5.0001, -0.02336835809343288},
                                   {1.2501, 5.2501, -0.01876637097257934},
                                   {1.2501, 5.5001, -0.01504639054409921},
                                   {1.2501, 5.7501, -0.01204621497533639},
                                   {1.2501, 6.0001, -0.00963147109942486},
                                   {1.2501, 6.2501, -0.007691455544474223},
                                   {1.2501, 6.5001, -0.006135392308878727},
                                   {1.2501, 6.7501, -0.004889144175728621},
                                   {1.2501, 7.0001, -0.003892372961799562},
                                   {1.2501, 7.2501, -0.003096119833565218},
                                   {1.2501, 7.5001, -0.002460765074297797},
                                   {1.2501, 7.7501, -0.001954322277728227},
                                   {1.2501, 8.0001, -0.001551022016902702},
                                   {1.2501, 8.2501, -0.001230142657707312},
                                   {1.2501, 8.5001, -0.000975049910205261},
                                   {1.2501, 8.7501, -0.0007724111542646225},
                                   {1.2501, 9.0001, -0.0006115550626491064},
                                   {1.2501, 9.2501, -0.0004839513002890636},
                                   {1.2501, 9.5001, -0.0003827889590103695},
                                   {1.2501, 9.7501, -0.0003026358315429134},
                                   {1.2501, 10.0001, -0.0002391636269484568},
                                   {1.2501, 10.2501, -0.0001889268011723316},
                                   {1.2501, 10.5001, -0.0001491848566220304},
                                   {1.2501, 10.7501, -0.0001177597960257016},
                                   {1.2501, 11.0001, -0.0000929219425337975},
                                   {1.2501, 11.2501, -0.00007329860278046794},
                                   {1.2501, 11.5001, -0.00005780109181216488},
                                   {1.2501, 11.7501, -0.00004556649369703309},
                                   {1.2501, 12.0001, -0.0000359112301662997},
                                   {1.2501, 12.2501, -0.00002829407846733634},
                                   {1.2501, 12.5001, -0.00002228674142938844},
                                   {1.2501, 12.7501, -0.00001755044669722505},
                                   {1.2501, 13.0001, -0.00001381735418155724},
                                   {1.2501, 13.2501, -0.00001087579430398061},
                                   {1.2501, 13.5001, -8.55855556063052e-6},
                                   {1.2501, 13.7501, -6.733597320186602e-6},
                                   {1.2501, 14.0001, -5.296689998321194e-6},
                                   {1.2501, 14.2501, -4.165585839931263e-6},
                                   {1.2501, 14.5001, -3.275404393693009e-6},
                                   {1.2501, 14.7501, -2.574981354683695e-6},
                                   {1.2501, 15.0001, -2.023980994374367e-6},
                                   {1.2501, 15.2501, -1.590613487340996e-6},
                                   {1.2501, 15.5001, -1.249831170013152e-6},
                                   {1.2501, 15.7501, -9.81903808597001e-7},
                                   {1.2501, 16.0001, -7.712936594451804e-7},
                                   {1.2501, 16.2501, -6.057675564209005e-7},
                                   {1.2501, 16.5001, -4.756963213331841e-7},
                                   {1.2501, 16.7501, -3.735021569166364e-7},
                                   {1.2501, 17.0001, -2.932228993616111e-7},
                                   {1.2501, 17.2501, -2.30168519604121e-7},
                                   {1.2501, 17.5001, -1.806504205322348e-7},
                                   {1.2501, 17.7501, -1.417681604726339e-7},
                                   {1.2501, 18.0001, -1.112414641503993e-7},
                                   {1.2501, 18.2501, -8.72779375259287e-8},
                                   {1.2501, 18.5001, -6.846892290249849e-8},
                                   {1.2501, 18.7501, -5.370752691572828e-8},
                                   {1.2501, 19.0001, -4.21241148689824e-8},
                                   {1.2501, 19.2501, -3.303556045286398e-8},
                                   {1.2501, 19.5001, -2.590532571759878e-8},
                                   {1.2501, 19.7501, -2.031206623274801e-8},
                                   {1.2501, 20.0001, -1.592494547510919e-8},
                                   {1.2501, 20.2501, -1.248422817635891e-8},
                                   {1.2501, 20.5001, -9.78602641096314e-9},
                                   {1.2501, 20.7501, -7.670311825959151e-9},
                                   {1.2501, 21.0001, -6.011496211198132e-9},
                                   {1.2501, 21.2501, -4.711031319670639e-9},
                                   {1.2501, 21.5001, -3.691595956870924e-9},
                                   {1.2501, 21.7501, -2.892530559348723e-9},
                                   {1.2501, 22.0001, -2.266252055199342e-9},
                                   {1.2501, 22.2501, -1.775438910742458e-9},
                                   {1.2501, 22.5001, -1.390821203110197e-9},
                                   {1.2501, 22.7501, -1.089445903676943e-9},
                                   {1.2501, 23.0001, -8.53315357272228e-10},
                                   {1.2501, 23.2501, -6.683188010286457e-10},
                                   {1.2501, 23.5001, -5.233939511103499e-10},
                                   {1.2501, 23.7501, -4.098691944601957e-10},
                                   {1.2501, 24.0001, -3.209475389326593e-10},
                                   {1.2501, 24.2501, -2.513018161130578e-10},
                                   {1.2501, 24.5001, -1.967571864906241e-10},
                                   {1.2501, 24.7501, -1.540421439147247e-10},
                                   {1.2501, 25.0001, -1.205932599511169e-10},
                                   {1.2501, 25.2501, -9.44020849111652e-11},
                                   {1.2501, 25.5001, -7.38951149138102e-11},
                                   {1.2501, 25.7501, -5.783969181092466e-11},
                                   {1.2501, 26.0001, -4.527024047591231e-11},
                                   {1.2501, 26.2501, -3.543045252996929e-11},
                                   {1.2501, 26.5001, -2.772797319071055e-11},
                                   {1.2501, 26.7501, -2.169889053517128e-11},
                                   {1.2501, 27.0001, -1.697990851588388e-11},
                                   {1.2501, 27.2501, -1.328654302565688e-11},
                                   {1.2501, 27.5001, -1.039603895442776e-11},
                                   {1.2501, 27.7501, -8.13398644484402e-12},
                                   {1.2501, 28.0001, -6.363836648404741e-12},
                                   {1.2501, 28.2501, -4.978689199615873e-12},
                                   {1.2501, 28.5001, -3.894859417326907e-12},
                                   {1.2501, 28.7501, -3.046840284998875e-12},
                                   {1.2501, 29.0001, -2.383356885112029e-12},
                                   {1.2501, 29.2501, -1.864276342577328e-12},
                                   {1.2501, 29.5001, -1.458188397193385e-12},
                                   {1.2501, 29.7501, -1.140510975002182e-12},
                                   {1.5001, 0.0001, -7.449668236912872e-6},
                                   {1.5001, 0.2501, -0.1728176873598922},
                                   {1.5001, 0.5001, -0.2940989383468805},
                                   {1.5001, 0.7501, -0.3553434932244588},
                                   {1.5001, 1.0001, -0.3746741191671099},
                                   {1.5001, 1.2501, -0.3672301646943775},
                                   {1.5001, 1.5001, -0.3439591133020414},
                                   {1.5001, 1.7501, -0.31237060155562},
                                   {1.5001, 2.0001, -0.2774267923761016},
                                   {1.5001, 2.2501, -0.2422782811180748},
                                   {1.5001, 2.5001, -0.2088201646867918},
                                   {1.5001, 2.7501, -0.1780967164771011},
                                   {1.5001, 3.0001, -0.1505895892648321},
                                   {1.5001, 3.2501, -0.1264197623449292},
                                   {1.5001, 3.5001, -0.1054869169036318},
                                   {1.5001, 3.7501, -0.0875640471512603},
                                   {1.5001, 4.0001, -0.07236040941011579},
                                   {1.5001, 4.2501, -0.05956232069121869},
                                   {1.5001, 4.5001, -0.04885864395279738},
                                   {1.5001, 4.7501, -0.03995583344896253},
                                   {1.5001, 5.0001, -0.03258598525061647},
                                   {1.5001, 5.2501, -0.02651030678562639},
                                   {1.5001, 5.5001, -0.02151967953452524},
                                   {1.5001, 5.7501, -0.01743346180648729},
                                   {1.5001, 6.0001, -0.01409730532261542},
                                   {1.5001, 6.2501, -0.01138049719025557},
                                   {1.5001, 6.5001, -0.00917315638192804},
                                   {1.5001, 6.7501, -0.007383488215418134},
                                   {1.5001, 7.0001, -0.005935215040947241},
                                   {1.5001, 7.2501, -0.004765244456824174},
                                   {1.5001, 7.5001, -0.003821599335514676},
                                   {1.5001, 7.7501, -0.003061610628351124},
                                   {1.5001, 8.0001, -0.002450359978800703},
                                   {1.5001, 8.2501, -0.001959351538131557},
                                   {1.5001, 8.5001, -0.00156538888883202},
                                   {1.5001, 8.7501, -0.0012496321434234},
                                   {1.5001, 9.0001, -0.000996811071271266},
                                   {1.5001, 9.2501, -0.0007945718176089642},
                                   {1.5001, 9.5001, -0.0006329369548058883},
                                   {1.5001, 9.7501, -0.0005038609464615298},
                                   {1.5001, 10.0001, -0.0004008654232039356},
                                   {1.5001, 10.2501, -0.0003187408547969507},
                                   {1.5001, 10.5001, -0.0002533031973584838},
                                   {1.5001, 10.7501, -0.0002011958718576128},
                                   {1.5001, 11.0001, -0.0001597289866518301},
                                   {1.5001, 11.2501, -0.0001267490616496276},
                                   {1.5001, 11.5001, -0.0001005336609963715},
                                   {1.5001, 11.7501, -0.00007970631473368739},
                                   {1.5001, 12.0001, -0.00006316792849344086},
                                   {1.5001, 12.2501, -0.00005004156434352084},
                                   {1.5001, 12.5001, -0.00003962804448533424},
                                   {1.5001, 12.7501, -0.00003137029993429972},
                                   {1.5001, 13.0001, -0.00002482477397711559},
                                   {1.5001, 13.2501, -0.00001963850852783254},
                                   {1.5001, 13.5001, -0.00001553080208083916},
                                   {1.5001, 13.7501, -0.00001227854066411232},
                                   {1.5001, 14.0001, -9.70447638912154e-6},
                                   {1.5001, 14.2501, -7.66786889490736e-6},
                                   {1.5001, 14.5001, -6.057019053848824e-6},
                                   {1.5001, 14.7501, -4.783316612989212e-6},
                                   {1.5001, 15.0001, -3.776498011965321e-6},
                                   {1.5001, 15.2501, -2.980870761005825e-6},
                                   {1.5001, 15.5001, -2.35230920035522e-6},
                                   {1.5001, 15.7501, -1.8558654215508e-6},
                                   {1.5001, 16.0001, -1.463870427337832e-6},
                                   {1.5001, 16.2501, -1.154425718877677e-6},
                                   {1.5001, 16.5001, -9.10205626816001e-7},
                                   {1.5001, 16.7501, -7.175068197682322e-7},
                                   {1.5001, 17.0001, -5.654943170339175e-7},
                                   {1.5001, 17.2501, -4.456036376415767e-7},
                                   {1.5001, 17.5001, -3.510669478296658e-7},
                                   {1.5001, 17.7501, -2.765376366140325e-7},
                                   {1.5001, 18.0001, -2.17792986169032e-7},
                                   {1.5001, 18.2501, -1.714987770062229e-7},
                                   {1.5001, 18.5001, -1.35022991299259e-7},
                                   {1.5001, 18.7501, -1.062884226269828e-7},
                                   {1.5001, 19.0001, -8.36561041530295e-8},
                                   {1.5001, 19.2501, -6.583313963151944e-8},
                                   {1.5001, 19.5001, -5.179985037651297e-8},
                                   {1.5001, 19.7501, -4.075220652954151e-8},
                                   {1.5001, 20.0001, -3.205634852241515e-8},
                                   {1.5001, 20.2501, -2.521266914309257e-8},
                                   {1.5001, 20.5001, -1.982745359567248e-8},
                                   {1.5001, 20.7501, -1.559049269132112e-8},
                                   {1.5001, 21.0001, -1.225741532570161e-8},
                                   {1.5001, 21.2501, -9.63574859452755e-9},
                                   {1.5001, 21.5001, -7.573921507819849e-9},
                                   {1.5001, 21.7501, -5.952592588966641e-9},
                                   {1.5001, 22.0001, -4.677811668970406e-9},
                                   {1.5001, 22.2501, -3.67562903619276e-9},
                                   {1.5001, 22.5001, -2.887846429250485e-9},
                                   {1.5001, 22.7501, -2.268668652922117e-9},
                                   {1.5001, 23.0001, -1.782065405707828e-9},
                                   {1.5001, 23.2501, -1.399693049648542e-9},
                                   {1.5001, 23.5001, -1.09925776043557e-9},
                                   {1.5001, 23.7501, -8.63226533339377e-10},
                                   {1.5001, 24.0001, -6.778122856283081e-10},
                                   {1.5001, 24.2501, -5.321748979397814e-10},
                                   {1.5001, 24.5001, -4.177923464073228e-10},
                                   {1.5001, 24.7501, -3.279657889849146e-10},
                                   {1.5001, 25.0001, -2.574301298284784e-10},
                                   {1.5001, 25.2501, -2.020476252681349e-10},
                                   {1.5001, 25.5001, -1.585668570664428e-10},
                                   {1.5001, 25.7501, -1.24433153345537e-10},
                                   {1.5001, 26.0001, -9.76394946871091e-11},
                                   {1.5001, 26.2501, -7.660927486980817e-11},
                                   {1.5001, 26.5001, -6.010412204472683e-11},
                                   {1.5001, 26.7501, -4.715143204970032e-11},
                                   {1.5001, 27.0001, -3.698740539486026e-11},
                                   {1.5001, 27.2501, -2.901227647795995e-11},
                                   {1.5001, 27.5001, -2.275512888486534e-11},
                                   {1.5001, 27.7501, -1.784624779897881e-11},
                                   {1.5001, 28.0001, -1.399539711416118e-11},
                                   {1.5001, 28.2501, -1.097475323822731e-11},
                                   {1.5001, 28.5001, -8.60549906501188e-12},
                                   {1.5001, 28.7501, -6.747294036448719e-12},
                                   {1.5001, 29.0001, -5.290003847984153e-12},
                                   {1.5001, 29.2501, -4.147205934292715e-12},
                                   {1.5001, 29.5001, -3.251089744611143e-12},
                                   {1.5001, 29.7501, -2.548452328457905e-12},
                                   {1.7501, 0.0001, -6.229084777841297e-7},
                                   {1.7501, 0.2501, -0.1051825480957966},
                                   {1.7501, 0.5001, -0.2143323189010944},
                                   {1.7501, 0.7501, -0.287894885240777},
                                   {1.7501, 1.0001, -0.327311399327779},
                                   {1.7501, 1.2501, -0.3401513789544972},
                                   {1.7501, 1.5001, -0.3342267010897392},
                                   {1.7501, 1.7501, -0.3160867600245543},
                                   {1.7501, 2.0001, -0.2907645950775006},
                                   {1.7501, 2.2501, -0.2619216112973785},
                                   {1.7501, 2.5001, -0.2321009649537248},
                                   {1.7501, 2.7501, -0.2029838036316259},
                                   {1.7501, 3.0001, -0.1756118389263208},
                                   {1.7501, 3.2501, -0.1505673950398622},
                                   {1.7501, 3.5001, -0.1281129989486837},
                                   {1.7501, 3.7501, -0.1082963891934346},
                                   {1.7501, 4.0001, -0.0910275802723169},
                                   {1.7501, 4.2501, -0.07613412893860559},
                                   {1.7501, 4.5001, -0.0633998235482524},
                                   {1.7501, 4.7501, -0.05259102342436525},
                                   {1.7501, 5.0001, -0.04347396549324072},
                                   {1.7501, 5.2501, -0.0358255835075133},
                                   {1.7501, 5.5001, -0.02943975806235324},
                                   {1.7501, 5.7501, -0.02413042053806196},
                                   {1.7501, 6.0001, -0.01973255129732118},
                                   {1.7501, 6.2501, -0.01610182127451288},
                                   {1.7501, 6.5001, -0.01311340765541182},
                                   {1.7501, 6.7501, -0.01066035255137981},
                                   {1.7501, 7.0001, -0.00865171520921587},
                                   {1.7501, 7.2501, -0.007010682810416497},
                                   {1.7501, 7.5001, -0.005672744029873379},
                                   {1.7501, 7.7501, -0.00458398685705374},
                                   {1.7501, 8.0001, -0.003699552860538464},
                                   {1.7501, 8.2501, -0.002982260422116974},
                                   {1.7501, 8.5001, -0.002401396730475099},
                                   {1.7501, 8.7501, -0.001931670470842639},
                                   {1.7501, 9.0001, -0.001552312681854898},
                                   {1.7501, 9.2501, -0.001246311088873983},
                                   {1.7501, 9.5001, -0.000999762583903531},
                                   {1.7501, 9.7501, -0.000801328852044698},
                                   {1.7501, 10.0001, -0.0006417810555042609},
                                   {1.7501, 10.2501, -0.000513620711961938},
                                   {1.7501, 10.5001, -0.0004107652655534002},
                                   {1.7501, 10.7501, -0.0003282882291632428},
                                   {1.7501, 11.0001, -0.0002622051034759164},
                                   {1.7501, 11.2501, -0.0002092975091635091},
                                   {1.7501, 11.5001, -0.0001669690823448537},
                                   {1.7501, 11.7501, -0.0001331276724732465},
                                   {1.7501, 12.0001, -0.0001060892473794438},
                                   {1.7501, 12.2501, -0.0000844996589590112},
                                   {1.7501, 12.5001, -0.00006727106457451595},
                                   {1.7501, 12.7501, -0.00005353034464034645},
                                   {1.7501, 13.0001, -0.00004257731738609488},
                                   {1.7501, 13.2501, -0.00003385093842516734},
                                   {1.7501, 13.5001, -0.00002690199572772431},
                                   {1.7501, 13.7501, -0.00002137107921385835},
                                   {1.7501, 14.0001, -0.00001697082672988741},
                                   {1.7501, 14.2501, -0.00001347163191594174},
                                   {1.7501, 14.5001, -0.00001069015071519879},
                                   {1.7501, 14.7501, -8.48006741876418e-6},
                                   {1.7501, 15.0001, -6.724682784921122e-6},
                                   {1.7501, 15.2501, -5.330969804793193e-6},
                                   {1.7501, 15.5001, -4.224810374652401e-6},
                                   {1.7501, 15.7501, -3.347181208424523e-6},
                                   {1.7501, 16.0001, -2.651102054433032e-6},
                                   {1.7501, 16.2501, -2.09919555133782e-6},
                                   {1.7501, 16.5001, -1.661737425115377e-6},
                                   {1.7501, 16.7501, -1.315099472630105e-6},
                                   {1.7501, 17.0001, -1.04050694953657e-6},
                                   {1.7501, 17.2501, -8.23047442244752e-7},
                                   {1.7501, 17.5001, -6.50880759245822e-7},
                                   {1.7501, 17.7501, -5.146094000722861e-7},
                                   {1.7501, 18.0001, -4.067772175340962e-7},
                                   {1.7501, 18.2501, -3.214703599757597e-7},
                                   {1.7501, 18.5001, -2.539997727922061e-7},
                                   {1.7501, 18.7501, -2.006487014464784e-7},
                                   {1.7501, 19.0001, -1.584719731981459e-7},
                                   {1.7501, 19.2501, -1.251365043607968e-7},
                                   {1.7501, 19.5001, -9.87946153695088e-8},
                                   {1.7501, 19.7501, -7.798344296673109e-8},
                                   {1.7501, 20.0001, -6.154510247947943e-8},
                                   {1.7501, 20.2501, -4.856334185401606e-8},
                                   {1.7501, 20.5001, -3.831329777243702e-8},
                                   {1.7501, 20.7501, -3.022165687888274e-8},
                                   {1.7501, 21.0001, -2.383507723600371e-8},
                                   {1.7501, 21.2501, -1.879516493225072e-8},
                                   {1.7501, 21.5001, -1.481865093404824e-8},
                                   {1.7501, 21.7501, -1.168169195680592e-8},
                                   {1.7501, 22.0001, -9.20744081374292e-9},
                                   {1.7501, 22.2501, -7.256207968545918e-9},
                                   {1.7501, 22.5001, -5.717676115520858e-9},
                                   {1.7501, 22.7501, -4.504740916502133e-9},
                                   {1.7501, 23.0001, -3.548639418344271e-9},
                                   {1.7501, 23.2501, -2.7950978509502e-9},
                                   {1.7501, 23.5001, -2.201286196668212e-9},
                                   {1.7501, 23.7501, -1.733411102204196e-9},
                                   {1.7501, 24.0001, -1.36481374268056e-9},
                                   {1.7501, 24.2501, -1.07446702572713e-9},
                                   {1.7501, 24.5001, -8.45788538492834e-10},
                                   {1.7501, 24.7501, -6.657030851342239e-10},
                                   {1.7501, 25.0001, -5.239024783782486e-10},
                                   {1.7501, 25.2501, -4.122611899287977e-10},
                                   {1.7501, 25.5001, -3.243751265996387e-10},
                                   {1.7501, 25.7501, -2.551976535827607e-10},
                                   {1.7501, 26.0001, -2.007524102758491e-10},
                                   {1.7501, 26.2501, -1.579067556345993e-10},
                                   {1.7501, 26.5001, -1.241930721054673e-10},
                                   {1.7501, 26.7501, -9.76678410736238e-11},
                                   {1.7501, 27.0001, -7.680052356464114e-11},
                                   {1.7501, 27.2501, -6.03859555234979e-11},
                                   {1.7501, 27.5001, -4.747529207564726e-11},
                                   {1.7501, 27.7501, -3.732158149689396e-11},
                                   {1.7501, 28.0001, -2.933687511827004e-11},
                                   {1.7501, 28.2501, -2.305843324658206e-11},
                                   {1.7501, 28.5001, -1.81221014810066e-11},
                                   {1.7501, 28.7501, -1.424133861917067e-11},
                                   {1.7501, 29.0001, -1.119069894278939e-11},
                                   {1.7501, 29.2501, -8.79282429971569e-12},
                                   {1.7501, 29.5001, -6.908201217324507e-12},
                                   {1.7501, 29.7501, -5.427096809748376e-12},
                                   {2.0001, 0.0001, -5.061118785578268e-8},
                                   {2.0001, 0.2501, -0.06196527310830866},
                                   {2.0001, 0.5001, -0.1510460052994179},
                                   {2.0001, 0.7501, -0.2254080686966682},
                                   {2.0001, 1.0001, -0.2761910871538591},
                                   {2.0001, 1.2501, -0.3042141897805598},
                                   {2.0001, 1.5001, -0.3134791589905002},
                                   {2.0001, 1.7501, -0.3086423075647423},
                                   {2.0001, 2.0001, -0.2939967513534516},
                                   {2.0001, 2.2501, -0.2731132626580421},
                                   {2.0001, 2.5001, -0.2487782032690285},
                                   {2.0001, 2.7501, -0.2230600753872612},
                                   {2.0001, 3.0001, -0.1974232562179973},
                                   {2.0001, 3.2501, -0.1728497932201712},
                                   {2.0001, 3.5001, -0.1499515103331797},
                                   {2.0001, 3.7501, -0.1290655806807736},
                                   {2.0001, 4.0001, -0.1103321848804275},
                                   {2.0001, 4.2501, -0.0937554564640771},
                                   {2.0001, 4.5001, -0.07924997300092709},
                                   {2.0001, 4.7501, -0.06667531828182667},
                                   {2.0001, 5.0001, -0.05586111953853273},
                                   {2.0001, 5.2501, -0.04662467322286108},
                                   {2.0001, 5.5001, -0.03878293022036047},
                                   {2.0001, 5.7501, -0.03216027600669442},
                                   {2.0001, 6.0001, -0.02659324064733374},
                                   {2.0001, 6.2501, -0.02193301764963089},
                                   {2.0001, 6.5001, -0.01804646024407277},
                                   {2.0001, 6.7501, -0.01481605495664323},
                                   {2.0001, 7.0001, -0.01213923975757817},
                                   {2.0001, 7.2501, -0.00992733165107825},
                                   {2.0001, 7.5001, -0.00810425065106633},
                                   {2.0001, 7.7501, -0.006605168671414451},
                                   {2.0001, 8.0001, -0.005375168708170238},
                                   {2.0001, 8.2501, -0.004367968317226519},
                                   {2.0001, 8.5001, -0.003544738982186108},
                                   {2.0001, 8.7501, -0.002873037297051739},
                                   {2.0001, 9.0001, -0.002325853218251865},
                                   {2.0001, 9.2501, -0.0018807736301311},
                                   {2.0001, 9.5001, -0.001519255096196078},
                                   {2.0001, 9.7501, -0.00122599716575898},
                                   {2.0001, 10.0001, -0.000988406399093066},
                                   {2.0001, 10.2501, -0.0007961409420117884},
                                   {2.0001, 10.5001, -0.0006407257164825881},
                                   {2.0001, 10.7501, -0.0005152288781727327},
                                   {2.0001, 11.0001, -0.0004139909704849521},
                                   {2.0001, 11.2501, -0.000332399071606824},
                                   {2.0001, 11.5001, -0.0002666991154988468},
                                   {2.0001, 11.7501, -0.0002138404241139844},
                                   {2.0001, 12.0001, -0.0001713472890691166},
                                   {2.0001, 12.2501, -0.000137213171678705},
                                   {2.0001, 12.5001, -0.0001098137445178765},
                                   {2.0001, 12.7501, -0.0000878355750012084},
                                   {2.0001, 13.0001, -0.0000702177549411454},
                                   {2.0001, 13.2501, -0.00005610421490781585},
                                   {2.0001, 13.5001, -0.00004480483477373484},
                                   {2.0001, 13.7501, -0.00003576377882609528},
                                   {2.0001, 14.0001, -0.00002853375195664061},
                                   {2.0001, 14.2501, -0.00002275509905978258},
                                   {2.0001, 14.5001, -0.00001813885876126031},
                                   {2.0001, 14.7501, -0.0000144530402721066},
                                   {2.0001, 15.0001, -0.00001151152323348973},
                                   {2.0001, 15.2501, -9.16508902329858e-6},
                                   {2.0001, 15.5001, -7.294181722933129e-6},
                                   {2.0001, 15.7501, -5.803070877255621e-6},
                                   {2.0001, 16.0001, -4.615148954246152e-6},
                                   {2.0001, 16.2501, -3.669146255404619e-6},
                                   {2.0001, 16.5001, -2.916086825228117e-6},
                                   {2.0001, 16.7501, -2.316842237313174e-6},
                                   {2.0001, 17.0001, -1.840167315252841e-6},
                                   {2.0001, 17.2501, -1.461123976825096e-6},
                                   {2.0001, 17.5001, -1.159817381116182e-6},
                                   {2.0001, 17.7501, -9.20383163708169e-7},
                                   {2.0001, 18.0001, -7.301763863331232e-7},
                                   {2.0001, 18.2501, -5.79122415698746e-7},
                                   {2.0001, 18.5001, -4.59197701127844e-7},
                                   {2.0001, 18.7501, -3.640146858901544e-7},
                                   {2.0001, 19.0001, -2.8849014356357e-7},
                                   {2.0001, 19.2501, -2.285803076582566e-7},
                                   {2.0001, 19.5001, -1.810694467888677e-7},
                                   {2.0001, 19.7501, -1.434011807497748e-7},
                                   {2.0001, 20.0001, -1.135439582653827e-7},
                                   {2.0001, 20.2501, -8.98838249811591e-8},
                                   {2.0001, 20.5001, -7.113898145361119e-8},
                                   {2.0001, 20.7501, -5.62917310384911e-8},
                                   {2.0001, 21.0001, -4.453429964105712e-8},
                                   {2.0001, 21.2501, -3.522571604539914e-8},
                                   {2.0001, 21.5001, -2.785750746743813e-8},
                                   {2.0001, 21.7501, -2.202641786961533e-8},
                                   {2.0001, 22.0001, -1.741271880078379e-8},
                                   {2.0001, 22.2501, -1.37629720738648e-8},
                                   {2.0001, 22.5001, -1.087633492773028e-8},
                                   {2.0001, 22.7501, -8.59368304626672e-9},
                                   {2.0001, 23.0001, -6.788974246444777e-9},
                                   {2.0001, 23.2501, -5.362393269795712e-9},
                                   {2.0001, 23.5001, -4.234911903830756e-9},
                                   {2.0001, 23.7501, -3.343973418209829e-9},
                                   {2.0001, 24.0001, -2.640069863105672e-9},
                                   {2.0001, 24.2501, -2.084028211116257e-9},
                                   {2.0001, 24.5001, -1.644859087482536e-9},
                                   {2.0001, 24.7501, -1.298051884330465e-9},
                                   {2.0001, 25.0001, -1.024223959422581e-9},
                                   {2.0001, 25.2501, -8.08050630976961e-10},
                                   {2.0001, 25.5001, -6.374177912822068e-10},
                                   {2.0001, 25.7501, -5.027509710435819e-10},
                                   {2.0001, 26.0001, -3.964842273037912e-10},
                                   {2.0001, 26.2501, -3.126398039926177e-10},
                                   {2.0001, 26.5001, -2.4649552960854e-10},
                                   {2.0001, 26.7501, -1.943216918905613e-10},
                                   {2.0001, 27.0001, -1.531729167044267e-10},
                                   {2.0001, 27.2501, -1.207235844881e-10},
                                   {2.0001, 27.5001, -9.51377008720127e-11},
                                   {2.0001, 27.7501, -7.496602714996268e-11},
                                   {2.0001, 28.0001, -5.906477468746592e-11},
                                   {2.0001, 28.2501, -4.653135432454697e-11},
                                   {2.0001, 28.5001, -3.665361133723033e-11},
                                   {2.0001, 28.7501, -2.886972258078355e-11},
                                   {2.0001, 29.0001, -2.273652138724934e-11},
                                   {2.0001, 29.2501, -1.790448287257671e-11},
                                   {2.0001, 29.5001, -1.409797254085442e-11},
                                   {2.0001, 29.7501, -1.10996529650949e-11},
                                   {2.2501, 0.0001, -4.007526509177381e-9},
                                   {2.2501, 0.2501, -0.03546838687275351},
                                   {2.2501, 0.5001, -0.1033459665452952},
                                   {2.2501, 0.7501, -0.1712592278184799},
                                   {2.2501, 1.0001, -0.2260719013567798},
                                   {2.2501, 1.2501, -0.2638433800301419},
                                   {2.2501, 1.5001, -0.2850546330578166},
                                   {2.2501, 1.7501, -0.2921219942327122},
                                   {2.2501, 2.0001, -0.288086261385154},
                                   {2.2501, 2.2501, -0.2759444870480094},
                                   {2.2501, 2.5001, -0.2583396003699678},
                                   {2.2501, 2.7501, -0.2374473975652093},
                                   {2.2501, 3.0001, -0.2149685018444784},
                                   {2.2501, 3.2501, -0.1921719381209348},
                                   {2.2501, 3.5001, -0.1699599278189584},
                                   {2.2501, 3.7501, -0.1489371443387839},
                                   {2.2501, 4.0001, -0.1294757515611449},
                                   {2.2501, 4.2501, -0.1117722741581377},
                                   {2.2501, 4.5001, -0.0958950374028249},
                                   {2.2501, 4.7501, -0.0818223701130117},
                                   {2.2501, 5.0001, -0.06947248305761713},
                                   {2.2501, 5.2501, -0.05872622291737535},
                                   {2.2501, 5.5001, -0.04944394733285874},
                                   {2.2501, 5.7501, -0.04147768463730584},
                                   {2.2501, 6.0001, -0.0346796013276483},
                                   {2.2501, 6.2501, -0.02890764108812924},
                                   {2.2501, 6.5001, -0.0240290432835695},
                                   {2.2501, 6.7501, -0.01992230740899865},
                                   {2.2501, 7.0001, -0.01647804764155243},
                                   {2.2501, 7.2501, -0.01359907927958526},
                                   {2.2501, 7.5001, -0.01119999535134407},
                                   {2.2501, 7.7501, -0.00920642494621748},
                                   {2.2501, 8.0001, -0.007554112437462946},
                                   {2.2501, 8.2501, -0.006187916306508461},
                                   {2.2501, 8.5001, -0.00506079551740391},
                                   {2.2501, 8.7501, -0.004132828371826798},
                                   {2.2501, 9.0001, -0.003370291842945341},
                                   {2.2501, 9.2501, -0.002744817169178309},
                                   {2.2501, 9.5001, -0.002232628873950056},
                                   {2.2501, 9.7501, -0.001813868476928228},
                                   {2.2501, 10.0001, -0.001472000277210505},
                                   {2.2501, 10.2501, -0.001193294176788623},
                                   {2.2501, 10.5001, -0.00096637915704343},
                                   {2.2501, 10.7501, -0.0007818604065594946},
                                   {2.2501, 11.0001, -0.0006319929891916031},
                                   {2.2501, 11.2501, -0.0005104051629182001},
                                   {2.2501, 11.5001, -0.0004118648860348956},
                                   {2.2501, 11.7501, -0.0003320835873711999},
                                   {2.2501, 12.0001, -0.0002675518684287469},
                                   {2.2501, 12.2501, -0.0002154024048981832},
                                   {2.2501, 12.5001, -0.0001732958950621671},
                                   {2.2501, 12.7501, -0.0001393264460455734},
                                   {2.2501, 13.0001, -0.0001119432862877647},
                                   {2.2501, 13.2501, -0.0000898861398519725},
                                   {2.2501, 13.5001, -0.00007213199470165383},
                                   {2.2501, 13.7501, -0.00005785134463125583},
                                   {2.2501, 14.0001, -0.0000463722863189061},
                                   {2.2501, 14.2501, -0.00003715111292062387},
                                   {2.2501, 14.5001, -0.00002974826802510078},
                                   {2.2501, 14.7501, -0.00002380871293859277},
                                   {2.2501, 15.0001, -0.00001904592031140707},
                                   {2.2501, 15.2501, -0.00001522884191264373},
                                   {2.2501, 15.5001, -0.0000121713114295761},
                                   {2.2501, 15.7501, -9.72343766814863e-6},
                                   {2.2501, 16.0001, -7.764622251407236e-6},
                                   {2.2501, 16.2501, -6.197901292403047e-6},
                                   {2.2501, 16.5001, -4.945364670201212e-6},
                                   {2.2501, 16.7501, -3.94445127834165e-6},
                                   {2.2501, 17.0001, -3.14495549532444e-6},
                                   {2.2501, 17.2501, -2.506610463073428e-6},
                                   {2.2501, 17.5001, -1.997138664066859e-6},
                                   {2.2501, 17.7501, -1.590680696196137e-6},
                                   {2.2501, 18.0001, -1.266529839839227e-6},
                                   {2.2501, 18.2501, -1.008113647981679e-6},
                                   {2.2501, 18.5001, -8.02174911469481e-7},
                                   {2.2501, 18.7501, -6.381134089006151e-7},
                                   {2.2501, 19.0001, -5.074572175895529e-7},
                                   {2.2501, 19.2501, -4.034383466059023e-7},
                                   {2.2501, 19.5001, -3.20652308821077e-7},
                                   {2.2501, 19.7501, -2.547851847158485e-7},
                                   {2.2501, 20.0001, -2.02394917419279e-7},
                                   {2.2501, 20.2501, -1.60736156099527e-7},
                                   {2.2501, 20.5001, -1.276200478534495e-7},
                                   {2.2501, 20.7501, -1.013020600580911e-7},
                                   {2.2501, 21.0001, -8.03922718751832e-8},
                                   {2.2501, 21.2501, -6.378366718746575e-8},
                                   {2.2501, 21.5001, -5.059484205006727e-8},
                                   {2.2501, 21.7501, -4.012424863673543e-8},
                                   {2.2501, 22.0001, -3.181366779724312e-8},
                                   {2.2501, 22.2501, -2.521906056955334e-8},
                                   {2.2501, 22.5001, -1.998731703476878e-8},
                                   {2.2501, 22.7501, -1.583771632846166e-8},
                                   {2.2501, 23.0001, -1.254714861626694e-8},
                                   {2.2501, 23.2501, -9.93833985119963e-9},
                                   {2.2501, 23.5001, -7.870472386104298e-9},
                                   {2.2501, 23.7501, -6.231716452578571e-9},
                                   {2.2501, 24.0001, -4.933285126615136e-9},
                                   {2.2501, 24.2501, -3.90470349345087e-9},
                                   {2.2501, 24.5001, -3.090045175208799e-9},
                                   {2.2501, 24.7501, -2.444939302867489e-9},
                                   {2.2501, 25.0001, -1.934190896620316e-9},
                                   {2.2501, 25.2501, -1.529889470761876e-9},
                                   {2.2501, 25.5001, -1.209906105118251e-9},
                                   {2.2501, 25.7501, -9.56699515321277e-10},
                                   {2.2501, 26.0001, -7.563678383273436e-10},
                                   {2.2501, 26.2501, -5.978957543436962e-10},
                                   {2.2501, 26.5001, -4.725568521837392e-10},
                                   {2.2501, 26.7501, -3.734393409588343e-10},
                                   {2.2501, 27.0001, -2.9506973816531e-10},
                                   {2.2501, 27.2501, -2.331143639690072e-10},
                                   {2.2501, 27.5001, -1.84142605830201e-10},
                                   {2.2501, 27.7501, -1.454392135522872e-10},
                                   {2.2501, 28.0001, -1.148555006171575e-10},
                                   {2.2501, 28.2501, -9.06914126112186e-11},
                                   {2.2501, 28.5001, -7.160207835539633e-11},
                                   {2.2501, 28.7501, -5.652377615307566e-11},
                                   {2.2501, 29.0001, -4.461529209173449e-11},
                                   {2.2501, 29.2501, -3.521147983334261e-11},
                                   {2.2501, 29.5001, -2.778648980312139e-11},
                                   {2.2501, 29.7501, -2.192465917328988e-11},
                                   {2.5001, 0.0001, -3.099934675078024e-10},
                                   {2.5001, 0.2501, -0.01978443304904183},
                                   {2.5001, 0.5001, -0.06886659577334806},
                                   {2.5001, 0.7501, -0.126677674435552},
                                   {2.5001, 1.0001, -0.1801017791665438},
                                   {2.5001, 1.2501, -0.2226616819961635},
                                   {2.5001, 1.5001, -0.2521709247378872},
                                   {2.5001, 1.7501, -0.2689351754745106},
                                   {2.5001, 2.0001, -0.2745449026744731},
                                   {2.5001, 2.2501, -0.2711158727634309},
                                   {2.5001, 2.5001, -0.2608394047369502},
                                   {2.5001, 2.7501, -0.2457370182847845},
                                   {2.5001, 3.0001, -0.2275448359578167},
                                   {2.5001, 3.2501, -0.2076768732925034},
                                   {2.5001, 3.5001, -0.1872335333915858},
                                   {2.5001, 3.7501, -0.1670336150627513},
                                   {2.5001, 4.0001, -0.1476563166493747},
                                   {2.5001, 4.2501, -0.1294851735376752},
                                   {2.5001, 4.5001, -0.11274943159896},
                                   {2.5001, 4.7501, -0.0975606285365276},
                                   {2.5001, 5.0001, -0.083943552936887},
                                   {2.5001, 5.2501, -0.07186157148094957},
                                   {2.5001, 5.5001, -0.06123676105045353},
                                   {2.5001, 5.7501, -0.05196549213063992},
                                   {2.5001, 6.0001, -0.04393017523991694},
                                   {2.5001, 6.2501, -0.03700786391080142},
                                   {2.5001, 6.5001, -0.03107634524952367},
                                   {2.5001, 6.7501, -0.02601826697167314},
                                   {2.5001, 7.0001, -0.02172376296438295},
                                   {2.5001, 7.2501, -0.01809195638011792},
                                   {2.5001, 7.5001, -0.015031644427028},
                                   {2.5001, 7.7501, -0.01246140421778108},
                                   {2.5001, 8.0001, -0.01030930456006911},
                                   {2.5001, 8.2501, -0.00851236383384608},
                                   {2.5001, 8.5001, -0.007015858079808152},
                                   {2.5001, 8.7501, -0.005772554927193807},
                                   {2.5001, 9.0001, -0.004741926813036049},
                                   {2.5001, 9.2501, -0.003889379965108713},
                                   {2.5001, 9.5001, -0.003185522835745234},
                                   {2.5001, 9.7501, -0.002605488221285464},
                                   {2.5001, 10.0001, -0.002128316458146711},
                                   {2.5001, 10.2501, -0.001736402255606619},
                                   {2.5001, 10.5001, -0.001415004425210323},
                                   {2.5001, 10.7501, -0.001151815612904117},
                                   {2.5001, 11.0001, -0.000936587830256299},
                                   {2.5001, 11.2501, -0.0007608088807702805},
                                   {2.5001, 11.5001, -0.0006174245064661146},
                                   {2.5001, 11.7501, -0.0005006011025838194},
                                   {2.5001, 12.0001, -0.0004055240630389267},
                                   {2.5001, 12.2501, -0.000328227151738841},
                                   {2.5001, 12.5001, -0.0002654486914765575},
                                   {2.5001, 12.7501, -0.0002145107851583897},
                                   {2.5001, 13.0001, -0.0001732182078451444},
                                   {2.5001, 13.2501, -0.0001397740156151969},
                                   {2.5001, 13.5001, -0.0001127092982056523},
                                   {2.5001, 13.7501, -0.0000908248510273304},
                                   {2.5001, 14.0001, -0.00007314285602749564},
                                   {2.5001, 14.2501, -0.00005886693977190623},
                                   {2.5001, 14.5001, -0.00004734922228028735},
                                   {2.5001, 14.7501, -0.00003806318372573725},
                                   {2.5001, 15.0001, -0.00003058136074943139},
                                   {2.5001, 15.2501, -0.00002455704271770503},
                                   {2.5001, 15.5001, -0.00001970927365735541},
                                   {2.5001, 15.7501, -0.00001581058064696753},
                                   {2.5001, 16.0001, -0.00001267694674170253},
                                   {2.5001, 16.2501, -0.00001015962847181998},
                                   {2.5001, 16.5001, -8.13848674864204e-6},
                                   {2.5001, 16.7501, -6.516557562189304e-6},
                                   {2.5001, 17.0001, -5.215636855812596e-6},
                                   {2.5001, 17.2501, -4.172693889785314e-6},
                                   {2.5001, 17.5001, -3.336960532726389e-6},
                                   {2.5001, 17.7501, -2.667571341135901e-6},
                                   {2.5001, 18.0001, -2.131651937145444e-6},
                                   {2.5001, 18.2501, -1.702771865784917e-6},
                                   {2.5001, 18.5001, -1.359693475903745e-6},
                                   {2.5001, 18.7501, -1.085360987633585e-6},
                                   {2.5001, 19.0001, -8.66084257220056e-7},
                                   {2.5001, 19.2501, -6.908802228934624e-7},
                                   {2.5001, 19.5001, -5.509419430008984e-7},
                                   {2.5001, 19.7501, -4.392107940659663e-7},
                                   {2.5001, 20.0001, -3.500320091005493e-7},
                                   {2.5001, 20.2501, -2.788774934436575e-7},
                                   {2.5001, 20.5001, -2.221229118760229e-7},
                                   {2.5001, 20.7501, -1.768685246683984e-7},
                                   {2.5001, 21.0001, -1.407952667362802e-7},
                                   {2.5001, 21.2501, -1.120491995354948e-7},
                                   {2.5001, 21.5001, -8.91487905111155e-8},
                                   {2.5001, 21.7501, -7.09105477101815e-8},
                                   {2.5001, 22.0001, -5.638940491775922e-8},
                                   {2.5001, 22.2501, -4.483095399246928e-8},
                                   {2.5001, 22.5001, -3.56331874417589e-8},
                                   {2.5001, 22.7501, -2.831587131722078e-8},
                                   {2.5001, 23.0001, -2.249603706172615e-8},
                                   {2.5001, 23.2501, -1.786837793359055e-8},
                                   {2.5001, 23.5001, -1.418957480323933e-8},
                                   {2.5001, 23.7501, -1.126576859785843e-8},
                                   {2.5001, 24.0001, -8.94255148492021e-9},
                                   {2.5001, 24.2501, -7.096973327526557e-9},
                                   {2.5001, 24.5001, -5.631159917364963e-9},
                                   {2.5001, 24.7501, -4.467219764899974e-9},
                                   {2.5001, 25.0001, -3.543180643849192e-9},
                                   {2.5001, 25.2501, -2.809748757635219e-9},
                                   {2.5001, 25.5001, -2.227724819916733e-9},
                                   {2.5001, 25.7501, -1.765944534464321e-9},
                                   {2.5001, 26.0001, -1.399637546708203e-9},
                                   {2.5001, 26.2501, -1.109120224927314e-9},
                                   {2.5001, 26.5001, -8.78754661415699e-10},
                                   {2.5001, 26.7501, -6.961199097501529e-10},
                                   {2.5001, 27.0001, -5.513523684393364e-10},
                                   {2.5001, 27.2501, -4.366209303554372e-10},
                                   {2.5001, 27.5001, -3.457094706697718e-10},
                                   {2.5001, 27.7501, -2.736848085318119e-10},
                                   {2.5001, 28.0001, -2.1663270729985e-10},
                                   {2.5001, 28.2501, -1.714480237317346e-10},
                                   {2.5001, 28.5001, -1.356679390235092e-10},
                                   {2.5001, 28.7501, -1.073394575904429e-10},
                                   {2.5001, 29.0001, -8.49141557814511e-11},
                                   {2.5001, 29.2501, -6.716459562403649e-11},
                                   {2.5001, 29.5001, -5.311795798680667e-11},
                                   {2.5001, 29.7501, -4.200335855355487e-11},
                                   {2.7501, 0.0001, -2.347136703471159e-11},
                                   {2.7501, 0.2501, -0.0107808133455587},
                                   {2.7501, 0.5001, -0.04480846318211897},
                                   {2.7501, 0.7501, -0.0914630084188273},
                                   {2.7501, 1.0001, -0.1400186323028182},
                                   {2.7501, 1.2501, -0.1833406076341206},
                                   {2.7501, 1.5001, -0.2176240850074756},
                                   {2.7501, 1.7501, -0.2414999138472113},
                                   {2.7501, 2.0001, -0.255175311753691},
                                   {2.7501, 2.2501, -0.2597627305214825},
                                   {2.7501, 2.5001, -0.2568047334357936},
                                   {2.7501, 2.7501, -0.2479614426458454},
                                   {2.7501, 3.0001, -0.2348202580875096},
                                   {2.7501, 3.2501, -0.2187920276589291},
                                   {2.7501, 3.5001, -0.2010652618592815},
                                   {2.7501, 3.7501, -0.1825972479087321},
                                   {2.7501, 4.0001, -0.1641270179378105},
                                   {2.7501, 4.2501, -0.1461998787653077},
                                   {2.7501, 4.5001, -0.1291967440646857},
                                   {2.7501, 4.7501, -0.1133640446055395},
                                   {2.7501, 5.0001, -0.098841754600809},
                                   {2.7501, 5.2501, -0.0856882589194021},
                                   {2.7501, 5.5001, -0.07390155619592386},
                                   {2.7501, 5.7501, -0.06343676958173178},
                                   {2.7501, 6.0001, -0.05422021195493302},
                                   {2.7501, 6.2501, -0.04616039288137851},
                                   {2.7501, 6.5001, -0.03915640831353119},
                                   {2.7501, 6.7501, -0.03310415430811722},
                                   {2.7501, 7.0001, -0.02790077570462913},
                                   {2.7501, 7.2501, -0.02344771485622144},
                                   {2.7501, 7.5001, -0.01965267385428694},
                                   {2.7501, 7.7501, -0.01643075219631114},
                                   {2.7501, 8.0001, -0.01370497392192579},
                                   {2.7501, 8.2501, -0.01140637560427952},
                                   {2.7501, 8.5001, -0.00947378987028009},
                                   {2.7501, 8.7501, -0.007853428307907295},
                                   {2.7501, 9.0001, -0.006498342296245603},
                                   {2.7501, 9.2501, -0.005367819867156723},
                                   {2.7501, 9.5001, -0.004426760508404614},
                                   {2.7501, 9.7501, -0.003645057180901676},
                                   {2.7501, 10.0001, -0.002997005126727117},
                                   {2.7501, 10.2501, -0.002460749735085233},
                                   {2.7501, 10.5001, -0.002017780330159125},
                                   {2.7501, 10.7501, -0.001652472841815628},
                                   {2.7501, 11.0001, -0.001351681580641456},
                                   {2.7501, 11.2501, -0.001104378488277884},
                                   {2.7501, 11.5001, -0.000901337051867842},
                                   {2.7501, 11.7501, -0.0007348573828028748},
                                   {2.7501, 12.0001, -0.0005985286281203575},
                                   {2.7501, 12.2501, -0.0004870248023165956},
                                   {2.7501, 12.5001, -0.0003959302176656526},
                                   {2.7501, 12.7501, -0.0003215908921066943},
                                   {2.7501, 13.0001, -0.0002609885809379096},
                                   {2.7501, 13.2501, -0.0002116343797904491},
                                   {2.7501, 13.5001, -0.0001714791589666635},
                                   {2.7501, 13.7501, -0.0001388383977058282},
                                   {2.7501, 14.0001, -0.0001123292811515604},
                                   {2.7501, 14.2501, -0.0000908181965594413},
                                   {2.7501, 14.5001, -0.00007337701528366043},
                                   {2.7501, 14.7501, -0.000059246772023019},
                                   {2.7501, 15.0001, -0.00004780755278201844},
                                   {2.7501, 15.2501, -0.00003855357901786629},
                                   {2.7501, 15.5001, -0.00003107262906914791},
                                   {2.7501, 15.7501, -0.00002502907107863935},
                                   {2.7501, 16.0001, -0.00002014989624679314},
                                   {2.7501, 16.2501, -0.00001621323941006686},
                                   {2.7501, 16.5001, -0.00001303895758531739},
                                   {2.7501, 16.7501, -0.00001048090809267683},
                                   {2.7501, 17.0001, -8.42062784971344e-6},
                                   {2.7501, 17.2501, -6.762165941594342e-6},
                                   {2.7501, 17.5001, -5.427863972855604e-6},
                                   {2.7501, 17.7501, -4.354914193641331e-6},
                                   {2.7501, 18.0001, -3.492555013681393e-6},
                                   {2.7501, 18.2501, -2.799788178946526e-6},
                                   {2.7501, 18.5001, -2.243522371462155e-6},
                                   {2.7501, 18.7501, -1.797064972792085e-6},
                                   {2.7501, 19.0001, -1.438897777889726e-6},
                                   {2.7501, 19.2501, -1.151684043567706e-6},
                                   {2.7501, 19.5001, -9.21463814828373e-7},
                                   {2.7501, 19.7501, -7.37002338121455e-7},
                                   {2.7501, 20.0001, -5.892628331343882e-7},
                                   {2.7501, 20.2501, -4.709801965986698e-7},
                                   {2.7501, 20.5001, -3.763165552613363e-7},
                                   {2.7501, 20.7501, -3.005831391776252e-7},
                                   {2.7501, 21.0001, -2.40015850788374e-7},
                                   {2.7501, 21.2501, -1.915942758437777e-7},
                                   {2.7501, 21.5001, -1.528958150469538e-7},
                                   {2.7501, 21.7501, -1.219781894870072e-7},
                                   {2.7501, 22.0001, -9.7284853760596e-8},
                                   {2.7501, 22.2501, -7.756889180349002e-8},
                                   {2.7501, 22.5001, -6.18318159529712e-8},
                                   {2.7501, 22.7501, -4.927437579095089e-8},
                                   {2.7501, 23.0001, -3.925703947938737e-8},
                                   {2.7501, 23.2501, -3.126826081891718e-8},
                                   {2.7501, 23.5001, -2.489900991913689e-8},
                                   {2.7501, 23.7501, -1.982234030437968e-8},
                                   {2.7501, 24.0001, -1.577700366308262e-8},
                                   {2.7501, 24.2501, -1.255431597951082e-8},
                                   {2.7501, 24.5001, -9.98763418694453e-9},
                                   {2.7501, 24.7501, -7.943927835234497e-9},
                                   {2.7501, 25.0001, -6.317031310294113e-9},
                                   {2.7501, 25.2501, -5.022243554210708e-9},
                                   {2.7501, 25.5001, -3.992007784048275e-9},
                                   {2.7501, 25.7501, -3.172456455789606e-9},
                                   {2.7501, 26.0001, -2.520649148136072e-9},
                                   {2.7501, 26.2501, -2.002365148196539e-9},
                                   {2.7501, 26.5001, -1.590339922707694e-9},
                                   {2.7501, 26.7501, -1.262856669163127e-9},
                                   {2.7501, 27.0001, -1.002621805341114e-9},
                                   {2.7501, 27.2501, -7.958674326436871e-10},
                                   {2.7501, 27.5001, -6.316351718556112e-10},
                                   {2.7501, 27.7501, -5.012048900382964e-10},
                                   {2.7501, 28.0001, -3.976391311110383e-10},
                                   {2.7501, 28.2501, -3.154199194851993e-10},
                                   {2.7501, 28.5001, -2.501592844264524e-10},
                                   {2.7501, 28.7501, -1.983686028682783e-10},
                                   {2.7501, 29.0001, -1.572748568213573e-10},
                                   {2.7501, 29.2501, -1.246743006764254e-10},
                                   {2.7501, 29.5001, -9.88159508003026e-11},
                                   {2.7501, 29.7501, -7.830884119140445e-11},
                                   {3.0001, 0.0001, -1.742459922779571e-12},
                                   {3.0001, 0.2501, -0.005750428838544311},
                                   {3.0001, 0.5001, -0.02852721825840989},
                                   {3.0001, 0.7501, -0.0645989934626636},
                                   {3.0001, 1.0001, -0.1064642129657668},
                                   {3.0001, 1.2501, -0.1476229095129709},
                                   {3.0001, 1.5001, -0.1836301565130313},
                                   {3.0001, 1.7501, -0.2120131232081351},
                                   {3.0001, 2.0001, -0.2318450035658014},
                                   {3.0001, 2.2501, -0.2432734885330735},
                                   {3.0001, 2.5001, -0.2471126569410292},
                                   {3.0001, 2.7501, -0.2445283086502676},
                                   {3.0001, 3.0001, -0.2368140682846728},
                                   {3.0001, 3.2501, -0.2252435757165407},
                                   {3.0001, 3.5001, -0.2109813978700839},
                                   {3.0001, 3.7501, -0.195036602277168},
                                   {3.0001, 4.0001, -0.1782456715394917},
                                   {3.0001, 4.2501, -0.1612744141414527},
                                   {3.0001, 4.5001, -0.1446312226051293},
                                   {3.0001, 4.7501, -0.1286862622788846},
                                   {3.0001, 5.0001, -0.113692921511987},
                                   {3.0001, 5.2501, -0.0998091656757061},
                                   {3.0001, 5.5001, -0.0871173872810491},
                                   {3.0001, 5.7501, -0.07564200845013462},
                                   {3.0001, 6.0001, -0.06536453864156082},
                                   {3.0001, 6.2501, -0.05623607695641152},
                                   {3.0001, 6.5001, -0.04818742009421981},
                                   {3.0001, 6.7501, -0.0411370291324496},
                                   {3.0001, 7.0001, -0.03499714698741122},
                                   {3.0001, 7.2501, -0.029678362798883},
                                   {3.0001, 7.5001, -0.02509290316115995},
                                   {3.0001, 7.7501, -0.021156902509701},
                                   {3.0001, 8.0001, -0.01779187237493874},
                                   {3.0001, 8.2501, -0.01492555569721817},
                                   {3.0001, 8.5001, -0.01249232043223143},
                                   {3.0001, 8.7501, -0.01043321763793052},
                                   {3.0001, 9.0001, -0.00869580375661356},
                                   {3.0001, 9.2501, -0.007233805047007403},
                                   {3.0001, 9.5001, -0.006006683944881834},
                                   {3.0001, 9.7501, -0.004979152235487726},
                                   {3.0001, 10.0001, -0.004120663925431398},
                                   {3.0001, 10.2501, -0.003404911199782548},
                                   {3.0001, 10.5001, -0.002809339446883516},
                                   {3.0001, 10.7501, -0.002314691663272672},
                                   {3.0001, 11.0001, -0.001904588289270613},
                                   {3.0001, 11.2501, -0.001565145390635453},
                                   {3.0001, 11.5001, -0.001284631854863714},
                                   {3.0001, 11.7501, -0.001053164713928101},
                                   {3.0001, 12.0001, -0.000862440676230902},
                                   {3.0001, 12.2501, -0.0007055013184100733},
                                   {3.0001, 12.5001, -0.0005765290481983394},
                                   {3.0001, 12.7501, -0.0004706708210096503},
                                   {3.0001, 13.0001, -0.0003838866119461029},
                                   {3.0001, 13.2501, -0.0003128197630847054},
                                   {3.0001, 13.5001, -0.000254686506822724},
                                   {3.0001, 13.7501, -0.0002071821828450854},
                                   {3.0001, 14.0001, -0.0001684018994783105},
                                   {3.0001, 14.2501, -0.0001367736261121547},
                                   {3.0001, 14.5001, -0.0001110019326864605},
                                   {3.0001, 14.7501, -0.000090020808936908},
                                   {3.0001, 15.0001, -0.00007295419658755366},
                                   {3.0001, 15.2501, -0.00005908305015680792},
                                   {3.0001, 15.5001, -0.00004781790594552171},
                                   {3.0001, 15.7501, -0.00003867608439870043},
                                   {3.0001, 16.0001, -0.00003126277923705307},
                                   {3.0001, 16.2501, -0.0000252553987468159},
                                   {3.0001, 16.5001, -0.00002039062178753732},
                                   {3.0001, 16.7501, -0.00001645371489200567},
                                   {3.0001, 17.0001, -0.00001326972874923473},
                                   {3.0001, 17.2501, -0.000010696253782373},
                                   {3.0001, 17.5001, -8.61746677123006e-6},
                                   {3.0001, 17.7501, -6.939244728993893e-6},
                                   {3.0001, 18.0001, -5.58515961426615e-6},
                                   {3.0001, 18.2501, -4.493198915762416e-6},
                                   {3.0001, 18.5001, -3.613083547895914e-6},
                                   {3.0001, 18.7501, -2.90407659454529e-6},
                                   {3.0001, 19.0001, -2.333194891040355e-6},
                                   {3.0001, 19.2501, -1.873750807241826e-6},
                                   {3.0001, 19.5001, -1.504164374348592e-6},
                                   {3.0001, 19.7501, -1.20699650102579e-6},
                                   {3.0001, 20.0001, -9.68162805011914e-7},
                                   {3.0001, 20.2501, -7.762948450496523e-7},
                                   {3.0001, 20.5001, -6.222215287043984e-7},
                                   {3.0001, 20.7501, -4.985484082101401e-7},
                                   {3.0001, 21.0001, -3.993166384447295e-7},
                                   {3.0001, 21.2501, -3.197267088078668e-7},
                                   {3.0001, 21.5001, -2.559147996967144e-7},
                                   {3.0001, 21.7501, -2.047718590521041e-7},
                                   {3.0001, 22.0001, -1.637973320500318e-7},
                                   {3.0001, 22.2501, -1.309809795931714e-7},
                                   {3.0001, 22.5001, -1.047074485724644e-7},
                                   {3.0001, 22.7501, -8.36792583132714e-8},
                                   {3.0001, 23.0001, -6.685468395840692e-8},
                                   {3.0001, 23.2501, -5.339768236177283e-8},
                                   {3.0001, 23.5001, -4.263754700298606e-8},
                                   {3.0001, 23.7501, -3.403641819106827e-8},
                                   {3.0001, 24.0001, -2.716313203224263e-8},
                                   {3.0001, 24.2501, -2.167218155644349e-8},
                                   {3.0001, 24.5001, -1.728679852586975e-8},
                                   {3.0001, 24.7501, -1.378535499943912e-8},
                                   {3.0001, 25.0001, -1.099043804110534e-8},
                                   {3.0001, 25.2501, -8.76007584410827e-9},
                                   {3.0001, 25.5001, -6.980694542404581e-9},
                                   {3.0001, 25.7501, -5.561466610302524e-9},
                                   {3.0001, 26.0001, -4.429777687752135e-9},
                                   {3.0001, 26.2501, -3.527591894522777e-9},
                                   {3.0001, 26.5001, -2.808538638849019e-9},
                                   {3.0001, 26.7501, -2.235578552670932e-9},
                                   {3.0001, 27.0001, -1.779134089800702e-9},
                                   {3.0001, 27.2501, -1.415592800920147e-9},
                                   {3.0001, 27.5001, -1.12610939482877e-9},
                                   {3.0001, 27.7501, -8.95647255956541e-10},
                                   {3.0001, 28.0001, -7.122117999665509e-10},
                                   {3.0001, 28.2501, -5.662374643029389e-10},
                                   {3.0001, 28.5001, -4.500976953002807e-10},
                                   {3.0001, 28.7501, -3.577133711404397e-10},
                                   {3.0001, 29.0001, -2.8423997795379e-10},
                                   {3.0001, 29.2501, -2.258177717679335e-10},
                                   {3.0001, 29.5001, -1.793723005822045e-10},
                                   {3.0001, 29.7501, -1.424551786748469e-10},
                                   {3.2501, 0.0001, -1.270132755186068e-13},
                                   {3.2501, 0.2501, -0.003007503250204744},
                                   {3.2501, 0.5001, -0.01780209431509512},
                                   {3.2501, 0.7501, -0.04471194499665995},
                                   {3.2501, 1.0001, -0.07931729057973929},
                                   {3.2501, 1.2501, -0.1164496525765369},
                                   {3.2501, 1.5001, -0.1517828692450817},
                                   {3.2501, 1.7501, -0.1823095290437498},
                                   {3.2501, 2.0001, -0.2063108065620959},
                                   {3.2501, 2.2501, -0.2231239469060425},
                                   {3.2501, 2.5001, -0.2328584289485722},
                                   {3.2501, 2.7501, -0.2361311887883753},
                                   {3.2501, 3.0001, -0.2338487756936418},
                                   {3.2501, 3.2501, -0.2270425919960918},
                                   {3.2501, 3.5001, -0.2167530705621463},
                                   {3.2501, 3.7501, -0.2039545379077169},
                                   {3.2501, 4.0001, -0.1895116382538395},
                                   {3.2501, 4.2501, -0.1741588845631361},
                                   {3.2501, 4.5001, -0.1584962326865142},
                                   {3.2501, 4.7501, -0.1429950519327459},
                                   {3.2501, 5.0001, -0.1280102458587136},
                                   {3.2501, 5.2501, -0.1137954571683079},
                                   {3.2501, 5.5001, -0.1005192427256439},
                                   {3.2501, 5.7501, -0.0882808399599193},
                                   {3.2501, 6.0001, -0.07712469274067458},
                                   {3.2501, 6.2501, -0.06705329686964654},
                                   {3.2501, 6.5001, -0.05803819555315235},
                                   {3.2501, 6.7501, -0.05002913271412219},
                                   {3.2501, 7.0001, -0.04296148110795227},
                                   {3.2501, 7.2501, -0.03676212242424499},
                                   {3.2501, 7.5001, -0.03135398301690046},
                                   {3.2501, 7.7501, -0.02665943301715523},
                                   {3.2501, 8.0001, -0.02260274672431226},
                                   {3.2501, 8.2501, -0.01911180431974641},
                                   {3.2501, 8.5001, -0.0161191932551683},
                                   {3.2501, 8.7501, -0.01356284489121827},
                                   {3.2501, 9.0001, -0.01138631986267026},
                                   {3.2501, 9.2501, -0.00953883525572209},
                                   {3.2501, 9.5001, -0.007975108533307709},
                                   {3.2501, 9.7501, -0.006655077431048394},
                                   {3.2501, 10.0001, -0.005543541747218647},
                                   {3.2501, 10.2501, -0.004609761911686447},
                                   {3.2501, 10.5001, -0.003827040216867989},
                                   {3.2501, 10.7501, -0.003172303373566543},
                                   {3.2501, 11.0001, -0.002625699357479749},
                                   {3.2501, 11.2501, -0.002170217091925116},
                                   {3.2501, 11.5001, -0.001791334144378828},
                                   {3.2501, 11.7501, -0.001476695100221072},
                                   {3.2501, 12.0001, -0.001215821445331848},
                                   {3.2501, 12.2501, -0.000999852494983997},
                                   {3.2501, 12.5001, -0.000821316029333722},
                                   {3.2501, 12.7501, -0.0006739267370118039},
                                   {3.2501, 13.0001, -0.0005524102481525597},
                                   {3.2501, 13.2501, -0.0004523503931372069},
                                   {3.2501, 13.5001, -0.000370057303425652},
                                   {3.2501, 13.7501, -0.000302454037371059},
                                   {3.2501, 14.0001, -0.0002469795372558848},
                                   {3.2501, 14.2501, -0.0002015058817065752},
                                   {3.2501, 14.5001, -0.0001642679737263938},
                                   {3.2501, 14.7501, -0.0001338039870048396},
                                   {3.2501, 15.0001, -0.0001089050736427635},
                                   {3.2501, 15.2501, -0.0000885730094153249},
                                   {3.2501, 15.5001, -0.00007198461466651594},
                                   {3.2501, 15.7501, -0.00005846193788954617},
                                   {3.2501, 16.0001, -0.00004744732409541253},
                                   {3.2501, 16.2501, -0.00003848261108169329},
                                   {3.2501, 16.5001, -0.00003119180408850339},
                                   {3.2501, 16.7501, -0.00002526667381550574},
                                   {3.2501, 17.0001, -0.00002045480532517117},
                                   {3.2501, 17.2501, -0.00001654969703024855},
                                   {3.2501, 17.5001, -0.00001338257084810873},
                                   {3.2501, 17.7501, -0.0000108156077756605},
                                   {3.2501, 18.0001, -8.7363686215999e-6},
                                   {3.2501, 18.2501, -7.053198384642098e-6},
                                   {3.2501, 18.5001, -5.691445663883625e-6},
                                   {3.2501, 18.7501, -4.590356322755442e-6},
                                   {3.2501, 19.0001, -3.700524108702379e-6},
                                   {3.2501, 19.2501, -2.981800682667076e-6},
                                   {3.2501, 19.5001, -2.401584084816437e-6},
                                   {3.2501, 19.7501, -1.933418534179948e-6},
                                   {3.2501, 20.0001, -1.555850044251425e-6},
                                   {3.2501, 20.2501, -1.251491990943356e-6},
                                   {3.2501, 20.5001, -1.006262799380369e-6},
                                   {3.2501, 20.7501, -8.08764582860141e-7},
                                   {3.2501, 21.0001, -6.497770927567396e-7},
                                   {3.2501, 21.2501, -5.218459101302882e-7},
                                   {3.2501, 21.5001, -4.189475870304077e-7},
                                   {3.2501, 21.7501, -3.362175615387479e-7},
                                   {3.2501, 22.0001, -2.697292376585952e-7},
                                   {3.2501, 22.2501, -2.163147331676629e-7},
                                   {3.2501, 22.5001, -1.734195339961374e-7},
                                   {3.2501, 22.7501, -1.38984718013728e-7},
                                   {3.2501, 23.0001, -1.113515787545436e-7},
                                   {3.2501, 23.2501, -8.91844357944544e-8},
                                   {3.2501, 23.5001, -7.140820070082566e-8},
                                   {3.2501, 23.7501, -5.715790672076708e-8},
                                   {3.2501, 24.0001, -4.573793229216817e-8},
                                   {3.2501, 24.2501, -3.65890741930128e-8},
                                   {3.2501, 24.5001, -2.92619731145661e-8},
                                   {3.2501, 24.7501, -2.339567698328552e-8},
                                   {3.2501, 25.0001, -1.870035724178452e-8},
                                   {3.2501, 25.2501, -1.494338019993846e-8},
                                   {3.2501, 25.5001, -1.193808740276748e-8},
                                   {3.2501, 25.7501, -9.53476222379541e-9},
                                   {3.2501, 26.0001, -7.613359887529025e-9},
                                   {3.2501, 26.2501, -6.077659188597531e-9},
                                   {3.2501, 26.5001, -4.850559850435825e-9},
                                   {3.2501, 26.7501, -3.870302639970919e-9},
                                   {3.2501, 27.0001, -3.087432379575624e-9},
                                   {3.2501, 27.2501, -2.462358792367358e-9},
                                   {3.2501, 27.5001, -1.963398235120187e-9},
                                   {3.2501, 27.7501, -1.565202089846198e-9},
                                   {3.2501, 28.0001, -1.247495921029916e-9},
                                   {3.2501, 28.2501, -9.94068303661547e-10},
                                   {3.2501, 28.5001, -7.919601600857458e-10},
                                   {3.2501, 28.7501, -6.308150637765104e-10},
                                   {3.2501, 29.0001, -5.023587177492797e-10},
                                   {3.2501, 29.2501, -3.999820585073254e-10},
                                   {3.2501, 29.5001, -3.18407459885448e-10},
                                   {3.2501, 29.7501, -2.534215535993571e-10},
                                   {3.5001, 0.0001, -9.10199142897023e-15},
                                   {3.5001, 0.2501, -0.00154453335438472},
                                   {3.5001, 0.5001, -0.01090548730358684},
                                   {3.5001, 0.7501, -0.03037408604633145},
                                   {3.5001, 1.0001, -0.05799005468415222},
                                   {3.5001, 1.2501, -0.0901354386858634},
                                   {3.5001, 1.5001, -0.1230931745200603},
                                   {3.5001, 1.7501, -0.153799077491374},
                                   {3.5001, 2.0001, -0.1800999449548489},
                                   {3.5001, 2.2501, -0.2007418841371824},
                                   {3.5001, 2.5001, -0.2152311571880447},
                                   {3.5001, 2.7501, -0.2236515040295065},
                                   {3.5001, 3.0001, -0.2264836791309257},
                                   {3.5001, 3.2501, -0.2244491817130477},
                                   {3.5001, 3.5001, -0.2183861340880891},
                                   {3.5001, 3.7501, -0.2091575161668998},
                                   {3.5001, 4.0001, -0.1975881208069043},
                                   {3.5001, 4.2501, -0.1844250786994952},
                                   {3.5001, 4.5001, -0.1703165968763216},
                                   {3.5001, 4.7501, -0.1558040256317628},
                                   {3.5001, 5.0001, -0.1413231304128067},
                                   {3.5001, 5.2501, -0.1272112767201808},
                                   {3.5001, 5.5001, -0.1137180189772261},
                                   {3.5001, 5.7501, -0.1010172634549729},
                                   {3.5001, 6.0001, -0.0892197326328109},
                                   {3.5001, 6.2501, -0.07838489632834632},
                                   {3.5001, 6.5001, -0.06853186631165266},
                                   {3.5001, 6.7501, -0.05964899276315693},
                                   {3.5001, 7.0001, -0.05170207021043428},
                                   {3.5001, 7.2501, -0.04464117352657137},
                                   {3.5001, 7.5001, -0.03840621505895458},
                                   {3.5001, 7.7501, -0.03293135343715853},
                                   {3.5001, 8.0001, -0.02814840221512691},
                                   {3.5001, 8.2501, -0.02398938930226841},
                                   {3.5001, 8.5001, -0.02038841144765547},
                                   {3.5001, 8.7501, -0.01728291575254689},
                                   {3.5001, 9.0001, -0.01461452506219612},
                                   {3.5001, 9.2501, -0.01232950802206911},
                                   {3.5001, 9.5001, -0.01037897881599477},
                                   {3.5001, 9.7501, -0.00871889689440553},
                                   {3.5001, 10.0001, -0.007309923766915496},
                                   {3.5001, 10.2501, -0.006117182354819844},
                                   {3.5001, 10.5001, -0.005109954497294401},
                                   {3.5001, 10.7501, -0.004261343901874524},
                                   {3.5001, 11.0001, -0.003547924988964738},
                                   {3.5001, 11.2501, -0.00294939253675031},
                                   {3.5001, 11.5001, -0.002448222613128734},
                                   {3.5001, 11.7501, -0.002029351815232568},
                                   {3.5001, 12.0001, -0.001679879166495486},
                                   {3.5001, 12.2501, -0.001388793003558811},
                                   {3.5001, 12.5001, -0.001146723695720894},
                                   {3.5001, 12.7501, -0.00094572197088011},
                                   {3.5001, 13.0001, -0.0007790618836150159},
                                   {3.5001, 13.2501, -0.0006410669781561225},
                                   {3.5001, 13.5001, -0.0005269579101548169},
                                   {3.5001, 13.7501, -0.0004327196468135646},
                                   {3.5001, 14.0001, -0.0003549863256639419},
                                   {3.5001, 14.2501, -0.0002909418870776157},
                                   {3.5001, 14.5001, -0.0002382346804691574},
                                   {3.5001, 14.7501, -0.0001949043607949407},
                                   {3.5001, 15.0001, -0.0001593195266536899},
                                   {3.5001, 15.2501, -0.0001301246939857444},
                                   {3.5001, 15.5001, -0.000106195342851473},
                                   {3.5001, 15.7501, -0.0000865999140701061},
                                   {3.5001, 16.0001, -0.00007056776434467304},
                                   {3.5001, 16.2501, -0.00005746221089290938},
                                   {3.5001, 16.5001, -0.00004675790849998003},
                                   {3.5001, 16.7501, -0.00003802190294209737},
                                   {3.5001, 17.0001, -0.0000308977950157938},
                                   {3.5001, 17.2501, -0.00002509252938452321},
                                   {3.5001, 17.5001, -0.00002036539276701808},
                                   {3.5001, 17.7501, -0.00001651886740321316},
                                   {3.5001, 18.0001, -0.00001339103906084967},
                                   {3.5001, 18.2501, -0.00001084930491558935},
                                   {3.5001, 18.5001, -8.78516625421216e-6},
                                   {3.5001, 18.7501, -7.10992487664865e-6},
                                   {3.5001, 19.0001, -5.751131016027035e-6},
                                   {3.5001, 19.2501, -4.649655203387193e-6},
                                   {3.5001, 19.5001, -3.757277358665971e-6},
                                   {3.5001, 19.7501, -3.034704012763773e-6},
                                   {3.5001, 20.0001, -2.449939417618721e-6},
                                   {3.5001, 20.2501, -1.976948786658236e-6},
                                   {3.5001, 20.5001, -1.594562379415748e-6},
                                   {3.5001, 20.7501, -1.285577907249488e-6},
                                   {3.5001, 21.0001, -1.0360260556915e-6},
                                   {3.5001, 21.2501, -8.34570019395888e-7},
                                   {3.5001, 21.5001, -6.720150215268729e-7},
                                   {3.5001, 21.7501, -5.409080056109486e-7},
                                   {3.5001, 22.0001, -4.352111843403942e-7},
                                   {3.5001, 22.2501, -3.500360249946994e-7},
                                   {3.5001, 22.5001, -2.814266449772145e-7},
                                   {3.5001, 22.7501, -2.261835675417986e-7},
                                   {3.5001, 23.0001, -1.8172041770245e-7},
                                   {3.5001, 23.2501, -1.459474807005049e-7},
                                   {3.5001, 23.5001, -1.171771496579626e-7},
                                   {3.5001, 23.7501, -9.40471963797562e-8},
                                   {3.5001, 24.0001, -7.545854399142106e-8},
                                   {3.5001, 24.2501, -6.052483071287972e-8},
                                   {3.5001, 24.5001, -4.853155422703242e-8},
                                   {3.5001, 24.7501, -3.890299539221425e-8},
                                   {3.5001, 25.0001, -3.117545466779456e-8},
                                   {3.5001, 25.2501, -2.497560795570994e-8},
                                   {3.5001, 25.5001, -2.000301164010946e-8},
                                   {3.5001, 25.7501, -1.601596852331099e-8},
                                   {3.5001, 26.0001, -1.28201145876792e-8},
                                   {3.5001, 26.2501, -1.025920720419458e-8},
                                   {3.5001, 26.5001, -8.20769360383417e-9},
                                   {3.5001, 26.7501, -6.564718264172854e-9},
                                   {3.5001, 27.0001, -5.249292727595837e-9},
                                   {3.5001, 27.2501, -4.196404034898799e-9},
                                   {3.5001, 27.5001, -3.353880687430471e-9},
                                   {3.5001, 27.7501, -2.679869708942014e-9},
                                   {3.5001, 28.0001, -2.140806455415381e-9},
                                   {3.5001, 28.2501, -1.709781570837776e-9},
                                   {3.5001, 28.5001, -1.365227896556104e-9},
                                   {3.5001, 28.7501, -1.089865038194669e-9},
                                   {3.5001, 29.0001, -8.69851338011904e-10},
                                   {3.5001, 29.2501, -6.941027365753614e-10},
                                   {3.5001, 29.5001, -5.537458688904934e-10},
                                   {3.5001, 29.7501, -4.416790885535157e-10},
                                   {3.7501, 0.0001, -6.419416012491408e-16},
                                   {3.7501, 0.2501, -0.0007798586272584298},
                                   {3.7501, 0.5001, -0.006566604119214682},
                                   {3.7501, 0.7501, -0.02027848704745728},
                                   {3.7501, 1.0001, -0.04166198217976972},
                                   {3.7501, 1.2501, -0.06855072458746623},
                                   {3.7501, 1.5001, -0.0980775191780608},
                                   {3.7501, 1.7501, -0.1274654585016982},
                                   {3.7501, 2.0001, -0.1544448658708975},
                                   {3.7501, 2.2501, -0.1774086955443468},
                                   {3.7501, 2.5001, -0.1954081053276096},
                                   {3.7501, 2.7501, -0.2080633811315364},
                                   {3.7501, 3.0001, -0.2154402336263113},
                                   {3.7501, 3.2501, -0.2179219207361769},
                                   {3.7501, 3.5001, -0.2160938289611588},
                                   {3.7501, 3.7501, -0.2106480366409401},
                                   {3.7501, 4.0001, -0.2023097683357657},
                                   {3.7501, 4.2501, -0.1917844708855336},
                                   {3.7501, 4.5001, -0.1797226733789185},
                                   {3.7501, 4.7501, -0.1666992340955229},
                                   {3.7501, 5.0001, -0.1532036097708291},
                                   {3.7501, 5.2501, -0.1396381279136754},
                                   {3.7501, 5.5001, -0.126321723834827},
                                   {3.7501, 5.7501, -0.1134971132026135},
                                   {3.7501, 6.0001, -0.1013398482514449},
                                   {3.7501, 6.2501, -0.0899681217998072},
                                   {3.7501, 6.5001, -0.0794525275830005},
                                   {3.7501, 6.7501, -0.06982525880544567},
                                   {3.7501, 7.0001, -0.06108843593762848},
                                   {3.7501, 7.2501, -0.05322140892607451},
                                   {3.7501, 7.5001, -0.04618698808219877},
                                   {3.7501, 7.7501, -0.03993663139169058},
                                   {3.7501, 8.0001, -0.03441466218546324},
                                   {3.7501, 8.2501, -0.02956161708153243},
                                   {3.7501, 8.5001, -0.02531683557796897},
                                   {3.7501, 8.7501, -0.02162040417377281},
                                   {3.7501, 9.0001, -0.018414562886357},
                                   {3.7501, 9.2501, -0.01564467310862281},
                                   {3.7501, 9.5001, -0.01325983477838695},
                                   {3.7501, 9.7501, -0.01121322912836789},
                                   {3.7501, 10.0001, -0.00946225172378536},
                                   {3.7501, 10.2501, -0.00796848963050964},
                                   {3.7501, 10.5001, -0.006697586706615115},
                                   {3.7501, 10.7501, -0.005619032323394626},
                                   {3.7501, 11.0001, -0.004705901332904254},
                                   {3.7501, 11.2501, -0.003934566767646813},
                                   {3.7501, 11.5001, -0.003284401498331135},
                                   {3.7501, 11.7501, -0.002737480777613344},
                                   {3.7501, 12.0001, -0.002278294141402722},
                                   {3.7501, 12.2501, -0.001893472404760882},
                                   {3.7501, 12.5001, -0.001571533362891439},
                                   {3.7501, 12.7501, -0.001302648185249499},
                                   {3.7501, 13.0001, -0.001078429279996297},
                                   {3.7501, 13.2501, -0.000891739526567555},
                                   {3.7501, 13.5001, -0.0007365221574902687},
                                   {3.7501, 13.7501, -0.0006076501592512646},
                                   {3.7501, 14.0001, -0.0005007938084129862},
                                   {3.7501, 14.2501, -0.0004123048244696785},
                                   {3.7501, 14.5001, -0.0003391155738894844},
                                   {3.7501, 14.7501, -0.0002786517755693666},
                                   {3.7501, 15.0001, -0.0002287572170895039},
                                   {3.7501, 15.2501, -0.0001876290786767832},
                                   {3.7501, 15.5001, -0.0001537625662724533},
                                   {3.7501, 15.7501, -0.0001259036680550476},
                                   {3.7501, 16.0001, -0.0001030089640172985},
                                   {3.7501, 16.2501, -0.000084211531371593},
                                   {3.7501, 16.5001, -0.00006879209670564961},
                                   {3.7501, 16.7501, -0.00005615468704506644},
                                   {3.7501, 17.0001, -0.00004580612522432828},
                                   {3.7501, 17.2501, -0.0000373387997374024},
                                   {3.7501, 17.5001, -0.00003041621547294366},
                                   {3.7501, 17.7501, -0.00002476089967209514},
                                   {3.7501, 18.0001, -0.00002014429750904835},
                                   {3.7501, 18.2501, -0.00001637834443623738},
                                   {3.7501, 18.5001, -0.00001330844847203466},
                                   {3.7501, 18.7501, -0.00001080765557784365},
                                   {3.7501, 19.0001, -8.77180580768343e-6},
                                   {3.7501, 19.2501, -7.115517626902156e-6},
                                   {3.7501, 19.5001, -5.768863261182794e-6},
                                   {3.7501, 19.7501, -4.674619682371604e-6},
                                   {3.7501, 20.0001, -3.78599834633993e-6},
                                   {3.7501, 20.2501, -3.064772504396794e-6},
                                   {3.7501, 20.5001, -2.479734200835162e-6},
                                   {3.7501, 20.7501, -2.005424287313814e-6},
                                   {3.7501, 21.0001, -1.621088230411711e-6},
                                   {3.7501, 21.2501, -1.309818423965998e-6},
                                   {3.7501, 21.5001, -1.057850370145042e-6},
                                   {3.7501, 21.7501, -8.53985658955697e-7},
                                   {3.7501, 22.0001, -6.891193238224752e-7},
                                   {3.7501, 22.2501, -5.558530255037106e-7},
                                   {3.7501, 22.5001, -4.481787411988509e-7},
                                   {3.7501, 22.7501, -3.612203150656156e-7},
                                   {3.7501, 23.0001, -2.910224493525114e-7},
                                   {3.7501, 23.2501, -2.343785570671674e-7},
                                   {3.7501, 23.5001, -1.88690420865116e-7},
                                   {3.7501, 23.7501, -1.518538619120531e-7},
                                   {3.7501, 24.0001, -1.221656615472597e-7},
                                   {3.7501, 24.2501, -9.82478350746795e-8},
                                   {3.7501, 24.5001, -7.898606221666555e-8},
                                   {3.7501, 24.7501, -6.347965878081853e-8},
                                   {3.7501, 25.0001, -5.100095063585775e-8},
                                   {3.7501, 25.2501, -4.096230224110316e-8},
                                   {3.7501, 25.5001, -3.288937271869318e-8},
                                   {3.7501, 25.7501, -2.639943522705132e-8},
                                   {3.7501, 26.0001, -2.118381047853402e-8},
                                   {3.7501, 26.2501, -1.699364114570134e-8},
                                   {3.7501, 26.5001, -1.362837763603154e-8},
                                   {3.7501, 26.7501, -1.092646307777094e-8},
                                   {3.7501, 27.0001, -8.75780110998544e-9},
                                   {3.7501, 27.2501, -7.017668134717116e-9},
                                   {3.7501, 27.5001, -5.62179528116432e-9},
                                   {3.7501, 27.7501, -4.502397112904427e-9},
                                   {3.7501, 28.0001, -3.604966223354325e-9},
                                   {3.7501, 28.2501, -2.885687117783744e-9},
                                   {3.7501, 28.5001, -2.309350602497027e-9},
                                   {3.7501, 28.7501, -1.847672498009719e-9},
                                   {3.7501, 29.0001, -1.477938829932803e-9},
                                   {3.7501, 29.2501, -1.181914524715293e-9},
                                   {3.7501, 29.5001, -9.44964692355469e-10},
                                   {3.7501, 29.7501, -7.553473452451888e-10},
                                   {4.0001, 0.0001, -4.460056232730877e-17},
                                   {4.0001, 0.2501, -0.0003875559623358229},
                                   {4.0001, 0.5001, -0.003890854203762093},
                                   {4.0001, 0.7501, -0.01332037043259646},
                                   {4.0001, 1.0001, -0.02944623095502382},
                                   {4.0001, 1.2501, -0.05128563326368941},
                                   {4.0001, 1.5001, -0.07686735593764076},
                                   {4.0001, 1.7501, -0.1039064047032874},
                                   {4.0001, 2.0001, -0.1302631833748794},
                                   {4.0001, 2.2501, -0.1541984316913909},
                                   {4.0001, 2.5001, -0.1744737246717233},
                                   {4.0001, 2.7501, -0.1903500819752583},
                                   {4.0001, 3.0001, -0.2015279432627053},
                                   {4.0001, 3.2501, -0.2080599757643991},
                                   {4.0001, 3.5001, -0.2102575537646318},
                                   {4.0001, 3.7501, -0.2086034057469659},
                                   {4.0001, 4.0001, -0.2036769118579843},
                                   {4.0001, 4.2501, -0.1960944986927007},
                                   {4.0001, 4.5001, -0.1864650670796637},
                                   {4.0001, 4.7501, -0.17535897706499},
                                   {4.0001, 5.0001, -0.1632884524930417},
                                   {4.0001, 5.2501, -0.150697087268105},
                                   {4.0001, 5.5001, -0.137956241977714},
                                   {4.0001, 5.7501, -0.1253663783949647},
                                   {4.0001, 6.0001, -0.1131617016360637},
                                   {4.0001, 6.2501, -0.1015168101221982},
                                   {4.0001, 6.5001, -0.0905543601988738},
                                   {4.0001, 6.7501, -0.0803530193845295},
                                   {4.0001, 7.0001, -0.07095520406049492},
                                   {4.0001, 7.2501, -0.06237427449334303},
                                   {4.0001, 7.5001, -0.05460099636719777},
                                   {4.0001, 7.7501, -0.04760917909137473},
                                   {4.0001, 8.0001, -0.04136047310090585},
                                   {4.0001, 8.2501, -0.03580835702920673},
                                   {4.0001, 8.5001, -0.0309013762608451},
                                   {4.0001, 8.7501, -0.02658571147519538},
                                   {4.0001, 9.0001, -0.02280716309191405},
                                   {4.0001, 9.2501, -0.01951263800769084},
                                   {4.0001, 9.5001, -0.01665122099047129},
                                   {4.0001, 9.7501, -0.0141749063279611},
                                   {4.0001, 10.0001, -0.01203905710183917},
                                   {4.0001, 10.2501, -0.01020265069449973},
                                   {4.0001, 10.5001, -0.00862836045626776},
                                   {4.0001, 10.7501, -0.007282515270356892},
                                   {4.0001, 11.0001, -0.006134971287536512},
                                   {4.0001, 11.2501, -0.005158923480348271},
                                   {4.0001, 11.5001, -0.004330678922245012},
                                   {4.0001, 11.7501, -0.003629408809029856},
                                   {4.0001, 12.0001, -0.003036892152320521},
                                   {4.0001, 12.2501, -0.002537260711548089},
                                   {4.0001, 12.5001, -0.002116752007311755},
                                   {4.0001, 12.7501, -0.00176347508823804},
                                   {4.0001, 13.0001, -0.001467192022555899},
                                   {4.0001, 13.2501, -0.001219116777307613},
                                   {4.0001, 13.5001, -0.001011732163158799},
                                   {4.0001, 13.7501, -0.000838624800256688},
                                   {4.0001, 14.0001, -0.0006943375480346978},
                                   {4.0001, 14.2501, -0.0005742384947903013},
                                   {4.0001, 14.5001, -0.0004744053841259228},
                                   {4.0001, 14.7501, -0.0003915242343462105},
                                   {4.0001, 15.0001, -0.0003228008587870152},
                                   {4.0001, 15.2501, -0.0002658839998710386},
                                   {4.0001, 15.5001, -0.000218798831663934},
                                   {4.0001, 15.7501, -0.0001798896525353799},
                                   {4.0001, 16.0001, -0.0001477706717628446},
                                   {4.0001, 16.2501, -0.0001212838844257061},
                                   {4.0001, 16.5001, -0.0000994631224651628},
                                   {4.0001, 16.7501, -0.0000815034625532186},
                                   {4.0001, 17.0001, -0.00006673526080425298},
                                   {4.0001, 17.2501, -0.00005460216865358516},
                                   {4.0001, 17.5001, -0.00004464256237837994},
                                   {4.0001, 17.7501, -0.0000364738902150057},
                                   {4.0001, 18.0001, -0.00002977950567238921},
                                   {4.0001, 18.2501, -0.00002429761355507151},
                                   {4.0001, 18.5001, -0.00001981200667413811},
                                   {4.0001, 18.7501, -0.00001614431663610346},
                                   {4.0001, 19.0001, -0.00001314754192367537},
                                   {4.0001, 19.2501, -0.00001070065121442379},
                                   {4.0001, 19.5001, -8.70409002621453e-6},
                                   {4.0001, 19.7501, -7.076044822568255e-6},
                                   {4.0001, 20.0001, -5.749341123846606e-6},
                                   {4.0001, 20.2501, -4.668871387080179e-6},
                                   {4.0001, 20.5001, -3.789464838657675e-6},
                                   {4.0001, 20.7501, -3.074125433200932e-6},
                                   {4.0001, 21.0001, -2.492575994865486e-6},
                                   {4.0001, 21.2501, -2.020056664268318e-6},
                                   {4.0001, 21.5001, -1.63633428160981e-6},
                                   {4.0001, 21.7501, -1.324886509267168e-6},
                                   {4.0001, 22.0001, -1.072230531429693e-6},
                                   {4.0001, 22.2501, -8.67371234532742e-7},
                                   {4.0001, 22.5001, -7.013480174570358e-7},
                                   {4.0001, 22.7501, -5.668629312696956e-7},
                                   {4.0001, 23.0001, -4.579758131702406e-7},
                                   {4.0001, 23.2501, -3.698545509199897e-7},
                                   {4.0001, 23.5001, -2.985706712556694e-7},
                                   {4.0001, 23.7501, -2.409321555745858e-7},
                                   {4.0001, 24.0001, -1.943468052169761e-7},
                                   {4.0001, 24.2501, -1.567106548276256e-7},
                                   {4.0001, 24.5001, -1.263169058804715e-7},
                                   {4.0001, 24.7501, -1.017816573978324e-7},
                                   {4.0001, 25.0001, -8.1983375625874e-8},
                                   {4.0001, 25.2501, -6.601359275143021e-8},
                                   {4.0001, 25.5001, -5.313677656117646e-8},
                                   {4.0001, 25.7501, -4.275768485289167e-8},
                                   {4.0001, 26.0001, -3.439482423925711e-8},
                                   {4.0001, 26.2501, -2.765888423789796e-8},
                                   {4.0001, 26.5001, -2.223522376504014e-8},
                                   {4.0001, 26.7501, -1.786965626680933e-8},
                                   {4.0001, 27.0001, -1.435691828851201e-8},
                                   {4.0001, 27.2501, -1.153131972309226e-8},
                                   {4.0001, 27.5001, -9.25916677894073e-9},
                                   {4.0001, 27.7501, -7.43262455947157e-9},
                                   {4.0001, 28.0001, -5.964748102437454e-9},
                                   {4.0001, 28.2501, -4.785461295404757e-9},
                                   {4.0001, 28.5001, -3.838304327484512e-9},
                                   {4.0001, 28.7501, -3.077803955213671e-9},
                                   {4.0001, 29.0001, -2.467348242951654e-9},
                                   {4.0001, 29.2501, -1.977469727464476e-9},
                                   {4.0001, 29.5001, -1.584459090191248e-9},
                                   {4.0001, 29.7501, -1.269246162811173e-9},
                                   {4.2501, 0.0001, -3.055200422185725e-18},
                                   {4.2501, 0.2501, -0.0001897441871006225},
                                   {4.2501, 0.5001, -0.002270829323631396},
                                   {4.2501, 0.7501, -0.00861747478536799},
                                   {4.2501, 1.0001, -0.02049571303376042},
                                   {4.2501, 1.2501, -0.03778254833857863},
                                   {4.2501, 1.5001, -0.05931981382918287},
                                   {4.2501, 1.7501, -0.0833978294011203},
                                   {4.2501, 2.0001, -0.1081714403519851},
                                   {4.2501, 2.2501, -0.1319501946879968},
                                   {4.2501, 2.5001, -0.1533651261925622},
                                   {4.2501, 2.7501, -0.1714372469652734},
                                   {4.2501, 3.0001, -0.1855774667780698},
                                   {4.2501, 3.2501, -0.1955444687421113},
                                   {4.2501, 3.5001, -0.2013812249974835},
                                   {4.2501, 3.7501, -0.2033447898163078},
                                   {4.2501, 4.0001, -0.2018388030515914},
                                   {4.2501, 4.2501, -0.1973540931624364},
                                   {4.2501, 4.5001, -0.190419858475025},
                                   {4.2501, 4.7501, -0.1815659560373372},
                                   {4.2501, 5.0001, -0.171295627833767},
                                   {4.2501, 5.2501, -0.1600673432000847},
                                   {4.2501, 5.5001, -0.1482841641644749},
                                   {4.2501, 5.7501, -0.1362890137257363},
                                   {4.2501, 6.0001, -0.1243643466027845},
                                   {4.2501, 6.2501, -0.1127349175730394},
                                   {4.2501, 6.5001, -0.1015725669488284},
                                   {4.2501, 6.7501, -0.0910021661252387},
                                   {4.2501, 7.0001, -0.0811080710855212},
                                   {4.2501, 7.2501, -0.07194060955293455},
                                   {4.2501, 7.5001, -0.06352227514033438},
                                   {4.2501, 7.7501, -0.05585341994719025},
                                   {4.2501, 8.0001, -0.04891732819881122},
                                   {4.2501, 8.2501, -0.04268462131367571},
                                   {4.2501, 8.5001, -0.03711699312718499},
                                   {4.2501, 8.7501, -0.03217030668555954},
                                   {4.2501, 9.0001, -0.02779710449421061},
                                   {4.2501, 9.2501, -0.02394859534213603},
                                   {4.2501, 9.5001, -0.02057618531701314},
                                   {4.2501, 9.7501, -0.01763262038967489},
                                   {4.2501, 10.0001, -0.01507280456706886},
                                   {4.2501, 10.2501, -0.01285435230309514},
                                   {4.2501, 10.5001, -0.01093792751896243},
                                   {4.2501, 10.7501, -0.00928741486769427},
                                   {4.2501, 11.0001, -0.007869962229264137},
                                   {4.2501, 11.2501, -0.006655927136512208},
                                   {4.2501, 11.5001, -0.005618754083576105},
                                   {4.2501, 11.7501, -0.004734804548462971},
                                   {4.2501, 12.0001, -0.003983157099233185},
                                   {4.2501, 12.2501, -0.003345391137314722},
                                   {4.2501, 12.5001, -0.0028053646233784},
                                   {4.2501, 12.7501, -0.002348993477024799},
                                   {4.2501, 13.0001, -0.001964038179650453},
                                   {4.2501, 13.2501, -0.00163990137657213},
                                   {4.2501, 13.5001, -0.001367438907740841},
                                   {4.2501, 13.7501, -0.001138785638129079},
                                   {4.2501, 14.0001, -0.000947196656442195},
                                   {4.2501, 14.2501, -0.0007869038174871655},
                                   {4.2501, 14.5001, -0.0006529871787356233},
                                   {4.2501, 14.7501, -0.0005412605906471355},
                                   {4.2501, 15.0001, -0.0004481705139626707},
                                   {4.2501, 15.2501, -0.0003707070311837732},
                                   {4.2501, 15.5001, -0.0003063259739486211},
                                   {4.2501, 15.7501, -0.0002528810869318164},
                                   {4.2501, 16.0001, -0.0002085651794059164},
                                   {4.2501, 16.2501, -0.0001718592676167792},
                                   {4.2501, 16.5001, -0.0001414887768187095},
                                   {4.2501, 16.7501, -0.0001163859452283245},
                                   {4.2501, 17.0001, -0.0000956576488367246},
                                   {4.2501, 17.2501, -0.00007855794272558885},
                                   {4.2501, 17.5001, -0.00006446468897781131},
                                   {4.2501, 17.7501, -0.00005285971191670003},
                                   {4.2501, 18.0001, -0.000043311987282322},
                                   {4.2501, 18.2501, -0.00003546343252519421},
                                   {4.2501, 18.5001, -0.00002901692045282664},
                                   {4.2501, 18.7501, -0.0000237261880216598},
                                   {4.2501, 19.0001, -0.00001938735630522429},
                                   {4.2501, 19.2501, -0.00001583181687571241},
                                   {4.2501, 19.5001, -0.00001292027436347939},
                                   {4.2501, 19.7501, -0.00001053776519532393},
                                   {4.2501, 20.0001, -8.58949885825816e-6},
                                   {4.2501, 20.2501, -6.997390887687541e-6},
                                   {4.2501, 20.5001, -5.697176519459227e-6},
                                   {4.2501, 20.7501, -4.636010933960932e-6},
                                   {4.2501, 21.0001, -3.770476590736602e-6},
                                   {4.2501, 21.2501, -3.06493060864327e-6},
                                   {4.2501, 21.5001, -2.49013576483566e-6},
                                   {4.2501, 21.7501, -2.022127712476297e-6},
                                   {4.2501, 22.0001, -1.641278671139091e-6},
                                   {4.2501, 22.2501, -1.331524318700151e-6},
                                   {4.2501, 22.5001, -1.079726078585982e-6},
                                   {4.2501, 22.7501, -8.75145599396076e-7},
                                   {4.2501, 23.0001, -7.090120934268896e-7},
                                   {4.2501, 23.2501, -5.741664473690431e-7},
                                   {4.2501, 23.5001, -4.647687378537325e-7},
                                   {4.2501, 23.7501, -3.760580584345178e-7},
                                   {4.2501, 24.0001, -3.041554629714033e-7},
                                   {4.2501, 24.2501, -2.459024128577274e-7},
                                   {4.2501, 24.5001, -1.987284327702769e-7},
                                   {4.2501, 24.7501, -1.605427745792934e-7},
                                   {4.2501, 25.0001, -1.296457980424388e-7},
                                   {4.2501, 25.2501, -1.046565305656344e-7},
                                   {4.2501, 25.5001, -8.44534924346459e-8},
                                   {4.2501, 25.7501, -6.812639017295592e-8},
                                   {4.2501, 26.0001, -5.493670723670246e-8},
                                   {4.2501, 26.2501, -4.428557332388482e-8},
                                   {4.2501, 26.5001, -3.568758386509346e-8},
                                   {4.2501, 26.7501, -2.874948038036073e-8},
                                   {4.2501, 27.0001, -2.315279916470174e-8},
                                   {4.2501, 27.2501, -1.863975755367102e-8},
                                   {4.2501, 27.5001, -1.500177992293071e-8},
                                   {4.2501, 27.7501, -1.207017465634719e-8},
                                   {4.2501, 28.0001, -9.70856277360702e-9},
                                   {4.2501, 28.2501, -7.806732210548915e-9},
                                   {4.2501, 28.5001, -6.275651765401049e-9},
                                   {4.2501, 28.7501, -5.043427832804628e-9},
                                   {4.2501, 29.0001, -4.05202719696275e-9},
                                   {4.2501, 29.2501, -3.254621959520981e-9},
                                   {4.2501, 29.5001, -2.613439461097427e-9},
                                   {4.2501, 29.7501, -2.098021908538377e-9},
                                   {4.5001, 0.0001, 0.},
                                   {4.5001, 0.2501, -0.0000915980739860815},
                                   {4.5001, 0.5001, -0.001306583721058352},
                                   {4.5001, 0.7501, -0.005495544257549252},
                                   {4.5001, 1.0001, -0.01406139902671273},
                                   {4.5001, 1.2501, -0.0274341174246084},
                                   {4.5001, 1.5001, -0.04511681707978089},
                                   {4.5001, 1.7501, -0.0659671810010884},
                                   {4.5001, 2.0001, -0.0885210778717348},
                                   {4.5001, 2.2501, -0.1112673214946902},
                                   {4.5001, 2.5001, -0.1328423840691313},
                                   {4.5001, 2.7501, -0.1521451110443603},
                                   {4.5001, 3.0001, -0.1683853263946005},
                                   {4.5001, 3.2501, -0.1810843068925719},
                                   {4.5001, 3.5001, -0.1900442302366767},
                                   {4.5001, 3.7501, -0.1953006950354466},
                                   {4.5001, 4.0001, -0.1970688404395347},
                                   {4.5001, 4.2501, -0.1956902538169803},
                                   {4.5001, 4.5001, -0.1915850845539854},
                                   {4.5001, 4.7501, -0.1852116660976889},
                                   {4.5001, 5.0001, -0.1770344434115745},
                                   {4.5001, 5.2501, -0.1675000104502737},
                                   {4.5001, 5.5001, -0.1570204690653762},
                                   {4.5001, 5.7501, -0.1459630205993316},
                                   {4.5001, 6.0001, -0.1346446039490581},
                                   {4.5001, 6.2501, -0.1233304273233095},
                                   {4.5001, 6.5001, -0.1122353512720752},
                                   {4.5001, 6.7501, -0.1015272291500313},
                                   {4.5001, 7.0001, -0.0913314716959488},
                                   {4.5001, 7.2501, -0.0817362581006958},
                                   {4.5001, 7.5001, -0.07279795704767643},
                                   {4.5001, 7.7501, -0.06454644293783401},
                                   {4.5001, 8.0001, -0.0569900933784794},
                                   {4.5001, 8.2501, -0.05012033464657959},
                                   {4.5001, 8.5001, -0.04391566407525902},
                                   {4.5001, 8.7501, -0.03834512459824868},
                                   {4.5001, 9.0001, -0.03337123964761515},
                                   {4.5001, 9.2501, -0.02895243878775159},
                                   {4.5001, 9.5001, -0.02504501821112383},
                                   {4.5001, 9.7501, -0.02160468754766602},
                                   {4.5001, 10.0001, -0.01858775705663459},
                                   {4.5001, 10.2501, -0.01595201856952835},
                                   {4.5001, 10.5001, -0.01365737064004996},
                                   {4.5001, 10.7501, -0.01166623408471236},
                                   {4.5001, 11.0001, -0.0099437991050319},
                                   {4.5001, 11.2501, -0.00845813993341863},
                                   {4.5001, 11.5001, -0.007180227763531484},
                                   {4.5001, 11.7501, -0.006083867825897237},
                                   {4.5001, 12.0001, -0.00514558198121761},
                                   {4.5001, 12.2501, -0.004344454195187809},
                                   {4.5001, 12.5001, -0.00366195275341207},
                                   {4.5001, 12.7501, -0.003081740065919645},
                                   {4.5001, 13.0001, -0.002589478370486482},
                                   {4.5001, 13.2501, -0.002172637532942498},
                                   {4.5001, 13.5001, -0.001820309415129611},
                                   {4.5001, 13.7501, -0.001523031889353182},
                                   {4.5001, 14.0001, -0.001272624475035001},
                                   {4.5001, 14.2501, -0.001062036714500729},
                                   {4.5001, 14.5001, -0.000885209749871097},
                                   {4.5001, 14.7501, -0.000736951075665228},
                                   {4.5001, 15.0001, -0.000612822090265086},
                                   {4.5001, 15.2501, -0.0005090378265459132},
                                   {4.5001, 15.5001, -0.0004223780846147323},
                                   {4.5001, 15.7501, -0.0003501090983755077},
                                   {4.5001, 16.0001, -0.0002899148265960317},
                                   {4.5001, 16.2501, -0.0002398369552889858},
                                   {4.5001, 16.5001, -0.0001982227210876619},
                                   {4.5001, 16.7501, -0.0001636797066080146},
                                   {4.5001, 17.0001, -0.0001350368120666401},
                                   {4.5001, 17.2501, -0.0001113106676903495},
                                   {4.5001, 17.5001, -0.0000916768149525434},
                                   {4.5001, 17.7501, -0.00007544504863801446},
                                   {4.5001, 18.0001, -0.00006203837419247257},
                                   {4.5001, 18.2501, -0.00005097509439760208},
                                   {4.5001, 18.5001, -0.00004185359524962299},
                                   {4.5001, 18.7501, -0.0000343394524994184},
                                   {4.5001, 19.0001, -0.00002815452740083759},
                                   {4.5001, 19.2501, -0.00002306776277780599},
                                   {4.5001, 19.5001, -0.0000188874286704634},
                                   {4.5001, 19.7501, -0.00001545460076325269},
                                   {4.5001, 20.0001, -0.0000126376848035399},
                                   {4.5001, 20.2501, -0.000010327826593454},
                                   {4.5001, 20.5001, -8.43507020151678e-6},
                                   {4.5001, 20.7501, -6.88514711705118e-6},
                                   {4.5001, 21.0001, -5.616796473375834e-6},
                                   {4.5001, 21.2501, -4.5795314939615e-6},
                                   {4.5001, 21.5001, -3.73178024776767e-6},
                                   {4.5001, 21.7501, -3.039339892410183e-6},
                                   {4.5001, 22.0001, -2.474093069942225e-6},
                                   {4.5001, 22.2501, -2.012943209981933e-6},
                                   {4.5001, 22.5001, -1.636932376350716e-6},
                                   {4.5001, 22.7501, -1.330511132679349e-6},
                                   {4.5001, 23.0001, -1.08093484617641e-6},
                                   {4.5001, 23.2501, -8.77765025362609e-7},
                                   {4.5001, 23.5001, -7.124578089892529e-7},
                                   {4.5001, 23.7501, -5.780246867246595e-7},
                                   {4.5001, 24.0001, -4.687530214584266e-7},
                                   {4.5001, 24.2501, -3.799760305196659e-7},
                                   {4.5001, 24.5001, -3.078836307586355e-7},
                                   {4.5001, 24.7501, -2.493670133537726e-7},
                                   {4.5001, 25.0001, -2.018910336273842e-7},
                                   {4.5001, 25.2501, -1.633895175747711e-7},
                                   {4.5001, 25.5001, -1.321794328884567e-7},
                                   {4.5001, 25.7501, -1.068905756360406e-7},
                                   {4.5001, 26.0001, -8.64080077759904e-8},
                                   {4.5001, 26.2501, -6.982496504774252e-8},
                                   {4.5001, 26.5001, -5.640435600934302e-8},
                                   {4.5001, 26.7501, -4.554730501509719e-8},
                                   {4.5001, 27.0001, -3.676746638138609e-8},
                                   {4.5001, 27.2501, -2.967006363250748e-8},
                                   {4.5001, 27.5001, -2.393479469555063e-8},
                                   {4.5001, 27.7501, -1.930189802210607e-8},
                                   {4.5001, 28.0001, -1.556080151953224e-8},
                                   {4.5001, 28.2501, -1.254088058181455e-8},
                                   {4.5001, 28.5001, -1.010393734075448e-8},
                                   {4.5001, 28.7501, -8.13808375619407e-9},
                                   {4.5001, 29.0001, -6.552769022304999e-9},
                                   {4.5001, 29.2501, -5.274739218628833e-9},
                                   {4.5001, 29.5001, -4.244756017534971e-9},
                                   {4.5001, 29.7501, -3.414933103461169e-9},
                                   {4.7501, 0.0001, 0.},
                                   {4.7501, 0.2501, -0.00004363315835523473},
                                   {4.7501, 0.5001, -0.0007417196832009489},
                                   {4.7501, 0.7501, -0.003457404218110118},
                                   {4.7501, 1.0001, -0.00951638261019633},
                                   {4.7501, 1.2501, -0.01964914934656783},
                                   {4.7501, 1.5001, -0.03384615589524886},
                                   {4.7501, 1.7501, -0.05146541278174719},
                                   {4.7501, 2.0001, -0.0714462563556963},
                                   {4.7501, 2.2501, -0.0925358499125388},
                                   {4.7501, 2.5001, -0.1134799081873202},
                                   {4.7501, 2.7501, -0.1331593681553552},
                                   {4.7501, 3.0001, -0.1506724168088512},
                                   {4.7501, 3.2501, -0.1653701159893109},
                                   {4.7501, 3.5001, -0.17685708801279},
                                   {4.7501, 3.7501, -0.1849687445284261},
                                   {4.7501, 4.0001, -0.1897349647374007},
                                   {4.7501, 4.2501, -0.1913379576181707},
                                   {4.7501, 4.5001, -0.190069847054604},
                                   {4.7501, 4.7501, -0.1862935872712885},
                                   {4.7501, 5.0001, -0.1804092624378779},
                                   {4.7501, 5.2501, -0.1728266616882998},
                                   {4.7501, 5.5001, -0.1639442098955355},
                                   {4.7501, 5.7501, -0.1541338141140682},
                                   {4.7501, 6.0001, -0.1437308900232902},
                                   {4.7501, 6.2501, -0.1330287013623819},
                                   {4.7501, 6.5001, -0.1222761268917315},
                                   {4.7501, 6.7501, -0.1116780229564789},
                                   {4.7501, 7.0001, -0.1013974443398951},
                                   {4.7501, 7.2501, -0.0915590995198569},
                                   {4.7501, 7.5001, -0.0822535335036706},
                                   {4.7501, 7.7501, -0.07354164244828475},
                                   {4.7501, 8.0001, -0.06545922371311495},
                                   {4.7501, 8.2501, -0.05802135020804035},
                                   {4.7501, 8.5001, -0.05122642824502794},
                                   {4.7501, 8.7501, -0.04505985420263732},
                                   {4.7501, 9.0001, -0.03949722853057485},
                                   {4.7501, 9.2501, -0.03450711768003357},
                                   {4.7501, 9.5001, -0.03005337727410979},
                                   {4.7501, 9.7501, -0.02609706500269389},
                                   {4.7501, 10.0001, -0.02259798095538084},
                                   {4.7501, 10.2501, -0.0195158778088603},
                                   {4.7501, 10.5001, -0.01681138465748903},
                                   {4.7501, 10.7501, -0.01444668729810782},
                                   {4.7501, 11.0001, -0.01238600523542981},
                                   {4.7501, 11.2501, -0.01059590217052571},
                                   {4.7501, 11.5001, -0.00904546273099144},
                                   {4.7501, 11.7501, -0.00770636403262031},
                                   {4.7501, 12.0001, -0.006552866564246642},
                                   {4.7501, 12.2501, -0.005561745016562282},
                                   {4.7501, 12.5001, -0.004712176128251421},
                                   {4.7501, 12.7501, -0.003985597449520901},
                                   {4.7501, 13.0001, -0.003365548141885065},
                                   {4.7501, 13.2501, -0.002837500538760136},
                                   {4.7501, 13.5001, -0.0023886891636366},
                                   {4.7501, 13.7501, -0.002007942211571843},
                                   {4.7501, 14.0001, -0.001685519110747579},
                                   {4.7501, 14.2501, -0.001412956657325048},
                                   {4.7501, 14.5001, -0.001182925322653493},
                                   {4.7501, 14.7501, -0.000989096632736312},
                                   {4.7501, 15.0001, -0.000826021984162064},
                                   {4.7501, 15.2501, -0.0006890228601000537},
                                   {4.7501, 15.5001, -0.000574092119461727},
                                   {4.7501, 15.7501, -0.0004778058303096258},
                                   {4.7501, 16.0001, -0.0003972449866079315},
                                   {4.7501, 16.2501, -0.0003299263699365297},
                                   {4.7501, 16.5001, -0.0002737417819537558},
                                   {4.7501, 16.7501, -0.0002269048686354389},
                                   {4.7501, 17.0001, -0.0001879047750990052},
                                   {4.7501, 17.2501, -0.0001554659033231938},
                                   {4.7501, 17.5001, -0.0001285130889307523},
                                   {4.7501, 17.7501, -0.0001061415632573748},
                                   {4.7501, 18.0001, -0.0000875911200244314},
                                   {4.7501, 18.2501, -0.00007222395971438445},
                                   {4.7501, 18.5001, -0.00005950573751499453},
                                   {4.7501, 18.7501, -0.00004898939126595217},
                                   {4.7501, 19.0001, -0.00004030137342733704},
                                   {4.7501, 19.2501, -0.00003312995522200691},
                                   {4.7501, 19.5001, -0.0000272153115475357},
                                   {4.7501, 19.7501, -0.00002234113194571558},
                                   {4.7501, 20.0001, -0.00001832753592244881},
                                   {4.7501, 20.2501, -0.00001502510037873822},
                                   {4.7501, 20.5001, -0.00001230983305237078},
                                   {4.7501, 20.7501, -0.00001007894892213425},
                                   {4.7501, 21.0001, -8.2473267515924e-6},
                                   {4.7501, 21.2501, -6.744540611710405e-6},
                                   {4.7501, 21.5001, -5.512376580600634e-6},
                                   {4.7501, 21.7501, -4.502758123208591e-6},
                                   {4.7501, 22.0001, -3.676015137886184e-6},
                                   {4.7501, 22.2501, -2.999441537223676e-6},
                                   {4.7501, 22.5001, -2.446094705483822e-6},
                                   {4.7501, 22.7501, -1.993797423987587e-6},
                                   {4.7501, 23.0001, -1.624309039925997e-6},
                                   {4.7501, 23.2501, -1.322637916809894e-6},
                                   {4.7501, 23.5001, -1.07647167307905e-6},
                                   {4.7501, 23.7501, -8.75705500982829e-7},
                                   {4.7501, 24.0001, -7.120520584745207e-7},
                                   {4.7501, 24.2501, -5.787191276945825e-7},
                                   {4.7501, 24.5001, -4.701435085327184e-7},
                                   {4.7501, 24.7501, -3.817715285948007e-7},
                                   {4.7501, 25.0001, -3.098781566343336e-7},
                                   {4.7501, 25.2501, -2.514180523257514e-7},
                                   {4.7501, 25.5001, -2.039030115408295e-7},
                                   {4.7501, 25.7501, -1.65301207502612e-7},
                                   {4.7501, 26.0001, -1.339544136673835e-7},
                                   {4.7501, 26.2501, -1.085100488351119e-7},
                                   {4.7501, 26.5001, -8.78654299187033e-8},
                                   {4.7501, 26.7501, -7.112207085148553e-8},
                                   {4.7501, 27.0001, -5.754824234062454e-8},
                                   {4.7501, 27.2501, -4.654831925729446e-8},
                                   {4.7501, 27.5001, -3.763770105225723e-8},
                                   {4.7501, 27.7501, -3.042230464312282e-8},
                                   {4.7501, 28.0001, -2.458180623369038e-8},
                                   {4.7501, 28.2501, -1.985595476180666e-8},
                                   {4.7501, 28.5001, -1.60334003761933e-8},
                                   {4.7501, 28.7501, -1.294258087756619e-8},
                                   {4.7501, 29.0001, -1.044429106825474e-8},
                                   {4.7501, 29.2501, -8.42562746941959e-9},
                                   {4.7501, 29.5001, -6.795056396467272e-9},
                                   {4.7501, 29.7501, -5.478399030091586e-9},
                                   {5.0001, 0.0001, 0.},
                                   {5.0001, 0.2501, -0.00002052364392755895},
                                   {5.0001, 0.5001, -0.0004157133435336676},
                                   {5.0001, 0.7501, -0.002147358404274935},
                                   {5.0001, 1.0001, -0.006357737235441863},
                                   {5.0001, 1.2501, -0.01389189892900794},
                                   {5.0001, 1.5001, -0.02506263624325999},
                                   {5.0001, 1.7501, -0.03963086116888494},
                                   {5.0001, 2.0001, -0.05691526505191792},
                                   {5.0001, 2.2501, -0.07595501274568015},
                                   {5.0001, 2.5001, -0.0956740406086424},
                                   {5.0001, 2.7501, -0.1150186042740193},
                                   {5.0001, 3.0001, -0.1330566517693998},
                                   {5.0001, 3.2501, -0.1490383343074049},
                                   {5.0001, 3.5001, -0.1624228181664052},
                                   {5.0001, 3.7501, -0.1728790228067755},
                                   {5.0001, 4.0001, -0.1802682546975609},
                                   {5.0001, 4.2501, -0.1846158802801873},
                                   {5.0001, 4.5001, -0.1860778294212961},
                                   {5.0001, 4.7501, -0.1849062461080914},
                                   {5.0001, 5.0001, -0.1814172345435365},
                                   {5.0001, 5.2501, -0.1759624962269128},
                                   {5.0001, 5.5001, -0.1689057521269187},
                                   {5.0001, 5.7501, -0.160604185108851},
                                   {5.0001, 6.0001, -0.1513946904375576},
                                   {5.0001, 6.2501, -0.141584446777834},
                                   {5.0001, 6.5001, -0.1314451763994682},
                                   {5.0001, 6.7501, -0.1212104148336952},
                                   {5.0001, 7.0001, -0.111075126393028},
                                   {5.0001, 7.2501, -0.101197058421054},
                                   {5.0001, 7.5001, -0.0916993054829795},
                                   {5.0001, 7.7501, -0.0826736417033349},
                                   {5.0001, 8.0001, -0.07418426610223984},
                                   {5.0001, 8.2501, -0.06627168639042975},
                                   {5.0001, 8.5001, -0.05895653805778127},
                                   {5.0001, 8.7501, -0.05224319631777322},
                                   {5.0001, 9.0001, -0.04612308835748657},
                                   {5.0001, 9.2501, -0.04057765297538617},
                                   {5.0001, 9.5001, -0.03558092510514275},
                                   {5.0001, 9.7501, -0.03110174517778694},
                                   {5.0001, 10.0001, -0.02710560907659132},
                                   {5.0001, 10.2501, -0.02355618485028143},
                                   {5.0001, 10.5001, -0.0204165285203549},
                                   {5.0001, 10.7501, -0.01765003425440486},
                                   {5.0001, 11.0001, -0.01522115473266694},
                                   {5.0001, 11.2501, -0.01309592641202347},
                                   {5.0001, 11.5001, -0.01124233215337831},
                                   {5.0001, 11.7501, -0.00963053076388133},
                                   {5.0001, 12.0001, -0.00823297974795917},
                                   {5.0001, 12.2501, -0.007024474204930799},
                                   {5.0001, 12.5001, -0.00598212152852602},
                                   {5.0001, 12.7501, -0.005085268470049419},
                                   {5.0001, 13.0001, -0.004315394293100367},
                                   {5.0001, 13.2501, -0.003655981211108093},
                                   {5.0001, 13.5001, -0.003092371072449806},
                                   {5.0001, 13.7501, -0.002611615337331723},
                                   {5.0001, 14.0001, -0.002202323760116328},
                                   {5.0001, 14.2501, -0.001854515827383726},
                                   {5.0001, 14.5001, -0.001559477878834414},
                                   {5.0001, 14.7501, -0.001309627926789913},
                                   {5.0001, 15.0001, -0.001098389462327825},
                                   {5.0001, 15.2501, -0.000920074965120106},
                                   {5.0001, 15.5001, -0.000769779394976272},
                                   {5.0001, 15.7501, -0.0006432836134943223},
                                   {5.0001, 16.0001, -0.00053696744423833},
                                   {5.0001, 16.2501, -0.0004477319122179747},
                                   {5.0001, 16.5001, -0.0003729300933345217},
                                   {5.0001, 16.7501, -0.0003103059393619592},
                                   {5.0001, 17.0001, -0.0002579404135054884},
                                   {5.0001, 17.2501, -0.0002142042670158018},
                                   {5.0001, 17.5001, -0.0001777168017349968},
                                   {5.0001, 17.7501, -0.000147309991186897},
                                   {5.0001, 18.0001, -0.0001219973694501248},
                                   {5.0001, 18.2501, -0.0001009471390965565},
                                   {5.0001, 18.5001, -0.0000834589942830131},
                                   {5.0001, 18.7501, -0.00006894420065692566},
                                   {5.0001, 19.0001, -0.00005690851862128914},
                                   {5.0001, 19.2501, -0.00004693759967349932},
                                   {5.0001, 19.5001, -0.0000386845262977672},
                                   {5.0001, 19.7501, -0.00003185920382525417},
                                   {5.0001, 20.0001, -0.0000262193475537332},
                                   {5.0001, 20.2501, -0.00002156284016314016},
                                   {5.0001, 20.5001, -0.00001772126310775124},
                                   {5.0001, 20.7501, -0.0000145544313198342},
                                   {5.0001, 21.0001, -0.00001194578338513631},
                                   {5.0001, 21.2501, -9.79849954136691e-6},
                                   {5.0001, 21.5001, -8.03223761815298e-6},
                                   {5.0001, 21.7501, -6.580392598349377e-6},
                                   {5.0001, 22.0001, -5.387799051903334e-6},
                                   {5.0001, 22.2501, -4.408807483165992e-6},
                                   {5.0001, 22.5001, -3.605675837914212e-6},
                                   {5.0001, 22.7501, -2.947226221180609e-6},
                                   {5.0001, 23.0001, -2.407724450295895e-6},
                                   {5.0001, 23.2501, -1.965946563076216e-6},
                                   {5.0001, 23.5001, -1.604401957455153e-6},
                                   {5.0001, 23.7501, -1.308687580061388e-6},
                                   {5.0001, 24.0001, -1.066951617444498e-6},
                                   {5.0001, 24.2501, -8.694485721509e-7},
                                   {5.0001, 24.5001, -7.081705121204869e-7},
                                   {5.0001, 24.7501, -5.765417406381195e-7},
                                   {5.0001, 25.0001, -4.691662103843843e-7},
                                   {5.0001, 25.2501, -3.816187553886383e-7},
                                   {5.0001, 25.5001, -3.102726876273007e-7},
                                   {5.0001, 25.7501, -2.521575425950002e-7},
                                   {5.0001, 26.0001, -2.048417964290695e-7},
                                   {5.0001, 26.2501, -1.663362469303993e-7},
                                   {5.0001, 26.5001, -1.350144784248595e-7},
                                   {5.0001, 26.7501, -1.095474382747425e-7},
                                   {5.0001, 27.0001, -8.88496600359474e-8},
                                   {5.0001, 27.2501, -7.203509091852021e-8},
                                   {5.0001, 27.5001, -5.83808330181297e-8},
                                   {5.0001, 27.7501, -4.729740028947369e-8},
                                   {5.0001, 28.0001, -3.830433616030438e-8},
                                   {5.0001, 28.2501, -3.101023822880546e-8},
                                   {5.0001, 28.5001, -2.5096403526505e-8},
                                   {5.0001, 28.7501, -2.030344613526489e-8},
                                   {5.0001, 29.0001, -1.64203533556418e-8},
                                   {5.0001, 29.2501, -1.327554117593626e-8},
                                   {5.0001, 29.5001, -1.072954786485841e-8},
                                   {5.0001, 29.7501, -8.66906892259363e-9},
                                   {5.2501, 0.0001, 0.},
                                   {5.2501, 0.2501, -9.5381948608344e-6},
                                   {5.2501, 0.5001, -0.0002301822518955988},
                                   {5.2501, 0.7501, -0.001317497169619662},
                                   {5.2501, 1.0001, -0.004195649649050536},
                                   {5.2501, 1.2501, -0.00970120010718375},
                                   {5.2501, 1.5001, -0.01833046192956837},
                                   {5.2501, 1.7501, -0.030141608820627},
                                   {5.2501, 2.0001, -0.04477960968603685},
                                   {5.2501, 2.2501, -0.06157350796809629},
                                   {5.2501, 2.5001, -0.07966181357711587},
                                   {5.2501, 2.7501, -0.0981151832293823},
                                   {5.2501, 3.0001, -0.1160386818830737},
                                   {5.2501, 3.2501, -0.1326461248845555},
                                   {5.2501, 3.5001, -0.1473058741192104},
                                   {5.2501, 3.7501, -0.1595614694507141},
                                   {5.2501, 4.0001, -0.1691323468969342},
                                   {5.2501, 4.2501, -0.1759003322283852},
                                   {5.2501, 4.5001, -0.1798871775986711},
                                   {5.2501, 4.7501, -0.1812275515786204},
                                   {5.2501, 5.0001, -0.1801408844381413},
                                   {5.2501, 5.2501, -0.176904486385881},
                                   {5.2501, 5.5001, -0.1718294924789265},
                                   {5.2501, 5.7501, -0.1652404852357886},
                                   {5.2501, 6.0001, -0.1574591112134868},
                                   {5.2501, 6.2501, -0.1487916275880318},
                                   {5.2501, 6.5001, -0.139520065937879},
                                   {5.2501, 6.7501, -0.129896556576541},
                                   {5.2501, 7.0001, -0.1201402922647681},
                                   {5.2501, 7.2501, -0.1104366021942454},
                                   {5.2501, 7.5001, -0.1009376368256843},
                                   {5.2501, 7.7501, -0.0917642165106877},
                                   {5.2501, 8.0001, -0.0830084605523383},
                                   {5.2501, 8.2501, -0.07473688038885424},
                                   {5.2501, 8.5001, -0.06699368547006296},
                                   {5.2501, 8.7501, -0.05980410975170311},
                                   {5.2501, 9.0001, -0.05317761872196356},
                                   {5.2501, 9.2501, -0.04711090077808567},
                                   {5.2501, 9.5001, -0.04159058263027791},
                                   {5.2501, 9.7501, -0.03659563675366893},
                                   {5.2501, 10.0001, -0.03209947054305725},
                                   {5.2501, 10.2501, -0.02807170268464862},
                                   {5.2501, 10.5001, -0.02447964330330253},
                                   {5.2501, 10.7501, -0.02128950158962718},
                                   {5.2501, 11.0001, -0.01846734869189606},
                                   {5.2501, 11.2501, -0.01597986540268479},
                                   {5.2501, 11.5001, -0.01379490419816132},
                                   {5.2501, 11.7501, -0.0118818940096073},
                                   {5.2501, 12.0001, -0.01021211413217412},
                                   {5.2501, 12.2501, -0.00875886122600255},
                                   {5.2501, 12.5001, -0.007497530683695681},
                                   {5.2501, 12.7501, -0.006405630905333166},
                                   {5.2501, 13.0001, -0.005462746364688376},
                                   {5.2501, 13.2501, -0.004650462852962159},
                                   {5.2501, 13.5001, -0.003952266001346716},
                                   {5.2501, 13.7501, -0.003353422138411902},
                                   {5.2501, 14.0001, -0.002840848741711376},
                                   {5.2501, 14.2501, -0.002402980191212681},
                                   {5.2501, 14.5001, -0.002029633212481931},
                                   {5.2501, 14.7501, -0.001711875291829873},
                                   {5.2501, 15.0001, -0.001441898432666844},
                                   {5.2501, 15.2501, -0.001212899879740832},
                                   {5.2501, 15.5001, -0.001018970843467586},
                                   {5.2501, 15.7501, -0.00085499378890754},
                                   {5.2501, 16.0001, -0.0007165484933439952},
                                   {5.2501, 16.2501, -0.0005998268049707853},
                                   {5.2501, 16.5001, -0.000501555837002038},
                                   {5.2501, 16.7501, -0.0004189291926770699},
                                   {5.2501, 17.0001, -0.0003495457251902574},
                                   {5.2501, 17.2501, -0.0002913552823743601},
                                   {5.2501, 17.5001, -0.0002426108604950755},
                                   {5.2501, 17.7501, -0.0002018265877297572},
                                   {5.2501, 18.0001, -0.0001677409700458244},
                                   {5.2501, 18.2501, -0.0001392848556180636},
                                   {5.2501, 18.5001, -0.0001155536049308098},
                                   {5.2501, 18.7501, -0.0000957829894018403},
                                   {5.2501, 19.0001, -0.00007932837950564654},
                                   {5.2501, 19.2501, -0.00006564682227763475},
                                   {5.2501, 19.5001, -0.00005428164650563717},
                                   {5.2501, 19.7501, -0.00004484927097616601},
                                   {5.2501, 20.0001, -0.00003702792623868667},
                                   {5.2501, 20.2501, -0.00003054803310186448},
                                   {5.2501, 20.5001, -0.00002518401127155991},
                                   {5.2501, 20.7501, -0.00002074731910006028},
                                   {5.2501, 21.0001, -0.00001708055035296506},
                                   {5.2501, 21.2501, -0.00001405243629513025},
                                   {5.2501, 21.5001, -0.00001155362137711349},
                                   {5.2501, 21.7501, -9.49309852513763e-6},
                                   {5.2501, 22.0001, -7.795205673936216e-6},
                                   {5.2501, 22.2501, -6.397098913333847e-6},
                                   {5.2501, 22.5001, -5.246629626496238e-6},
                                   {5.2501, 22.7501, -4.300563455950025e-6},
                                   {5.2501, 23.0001, -3.523088009800683e-6},
                                   {5.2501, 23.2501, -2.884564071525464e-6},
                                   {5.2501, 23.5001, -2.36048184684364e-6},
                                   {5.2501, 23.7501, -1.930589602562127e-6},
                                   {5.2501, 24.0001, -1.578167044539311e-6},
                                   {5.2501, 24.2501, -1.289420052391066e-6},
                                   {5.2501, 24.5001, -1.05297703304513e-6},
                                   {5.2501, 24.7501, -8.59470258614547e-7},
                                   {5.2501, 25.0001, -7.011881911303509e-7},
                                   {5.2501, 25.2501, -5.717870330808759e-7},
                                   {5.2501, 25.5001, -4.660516357729037e-7},
                                   {5.2501, 25.7501, -3.796974971157896e-7},
                                   {5.2501, 26.0001, -3.092069297437321e-7},
                                   {5.2501, 26.2501, -2.516936167560124e-7},
                                   {5.2501, 26.5001, -2.047907279027728e-7},
                                   {5.2501, 26.7501, -1.665585713639847e-7},
                                   {5.2501, 27.0001, -1.354084289845808e-7},
                                   {5.2501, 27.2501, -1.100397861119916e-7},
                                   {5.2501, 27.5001, -8.93886382264666e-8},
                                   {5.2501, 27.7501, -7.258494997251853e-8},
                                   {5.2501, 28.0001, -5.891767039169439e-8},
                                   {5.2501, 28.2501, -4.780598162188648e-8},
                                   {5.2501, 28.5001, -3.877568593935674e-8},
                                   {5.2501, 28.7501, -3.143982526302979e-8},
                                   {5.2501, 29.0001, -2.54827844218601e-8},
                                   {5.2501, 29.2501, -2.064725990654699e-8},
                                   {5.2501, 29.5001, -1.672358393915645e-8},
                                   {5.2501, 29.7501, -1.354098323116053e-8},
                                   {5.5001, 0.0001, 0.},
                                   {5.5001, 0.2501, -4.382213176321639e-6},
                                   {5.5001, 0.5001, -0.0001259853419437462},
                                   {5.5001, 0.7501, -0.0007989791257394581},
                                   {5.5001, 1.0001, -0.002736617084572208},
                                   {5.5001, 1.2501, -0.006695599038359777},
                                   {5.5001, 1.5001, -0.0132496703400587},
                                   {5.5001, 1.7501, -0.02265537954982099},
                                   {5.5001, 2.0001, -0.03481708647091653},
                                   {5.5001, 2.2501, -0.04932666772032738},
                                   {5.5001, 2.5001, -0.06554620380071762},
                                   {5.5001, 2.7501, -0.0827060574106824},
                                   {5.5001, 3.0001, -0.0999986988522685},
                                   {5.5001, 3.2501, -0.116656650122548},
                                   {5.5001, 3.5001, -0.1320094275194645},
                                   {5.5001, 3.7501, -0.1455189537587713},
                                   {5.5001, 4.0001, -0.1567957358034353},
                                   {5.5001, 4.2501, -0.1655995321999404},
                                   {5.5001, 4.5001, -0.17182866906415},
                                   {5.5001, 4.7501, -0.1755019654419325},
                                   {5.5001, 5.0001, -0.1767366780768017},
                                   {5.5001, 5.2501, -0.1757251749192363},
                                   {5.5001, 5.5001, -0.1727123295283435},
                                   {5.5001, 5.7501, -0.167974974344964},
                                   {5.5001, 6.0001, -0.1618041997938575},
                                   {5.5001, 6.2501, -0.1544908517073795},
                                   {5.5001, 6.5001, -0.1463142583017276},
                                   {5.5001, 6.7501, -0.1375339971399152},
                                   {5.5001, 7.0001, -0.128384375187038},
                                   {5.5001, 7.2501, -0.1190712232981558},
                                   {5.5001, 7.5001, -0.1097705834747701},
                                   {5.5001, 7.7501, -0.10062887834361},
                                   {5.5001, 8.0001, -0.0917641854970573},
                                   {5.5001, 8.2501, -0.0832682851347299},
                                   {5.5001, 8.5001, -0.07520920079040755},
                                   {5.5001, 8.7501, -0.06763400479727169},
                                   {5.5001, 9.0001, -0.06057170919482946},
                                   {5.5001, 9.2501, -0.0540361069858897},
                                   {5.5001, 9.5001, -0.04802846697359086},
                                   {5.5001, 9.7501, -0.04254001751968971},
                                   {5.5001, 10.0001, -0.03755418062315853},
                                   {5.5001, 10.2501, -0.03304853818586344},
                                   {5.5001, 10.5001, -0.02899652784474051},
                                   {5.5001, 10.7501, -0.02536887701663666},
                                   {5.5001, 11.0001, -0.02213479153848834},
                                   {5.5001, 11.2501, -0.01926292016969214},
                                   {5.5001, 11.5001, -0.01672211886921843},
                                   {5.5001, 11.7501, -0.01448203970371458},
                                   {5.5001, 12.0001, -0.01251356893958632},
                                   {5.5001, 12.2501, -0.01078913769752619},
                                   {5.5001, 12.5001, -0.00928292680442224},
                                   {5.5001, 12.7501, -0.007970985401867972},
                                   {5.5001, 13.0001, -0.006831280642965956},
                                   {5.5001, 13.2501, -0.005843693562661465},
                                   {5.5001, 13.5001, -0.004989974035397627},
                                   {5.5001, 13.7501, -0.004253665700190067},
                                   {5.5001, 14.0001, -0.003620009875609715},
                                   {5.5001, 14.2501, -0.003075835825377418},
                                   {5.5001, 14.5001, -0.002609443275301145},
                                   {5.5001, 14.7501, -0.00221048182031465},
                                   {5.5001, 15.0001, -0.001869830785946068},
                                   {5.5001, 15.2501, -0.001579482207010947},
                                   {5.5001, 15.5001, -0.001332428840728984},
                                   {5.5001, 15.7501, -0.001122558523927893},
                                   {5.5001, 16.0001, -0.000944555696715768},
                                   {5.5001, 16.2501, -0.0007938105309264981},
                                   {5.5001, 16.5001, -0.0006663358049196912},
                                   {5.5001, 16.7501, -0.000558691442546103},
                                   {5.5001, 17.0001, -0.000467916470437951},
                                   {5.5001, 17.2501, -0.0003914680330010279},
                                   {5.5001, 17.5001, -0.0003271670288553993},
                                   {5.5001, 17.7501, -0.0002731498877135066},
                                   {5.5001, 18.0001, -0.0002278259858322983},
                                   {5.5001, 18.2501, -0.0001898401954406836},
                                   {5.5001, 18.5001, -0.0001580400741740756},
                                   {5.5001, 18.7501, -0.0001314472206940654},
                                   {5.5001, 19.0001, -0.0001092323492554717},
                                   {5.5001, 19.2501, -0.0000906936665806174},
                                   {5.5001, 19.5001, -0.00007523816713363457},
                                   {5.5001, 19.7501, -0.00006236549632955417},
                                   {5.5001, 20.0001, -0.00005165406430671908},
                                   {5.5001, 20.2501, -0.00004274912487755794},
                                   {5.5001, 20.5001, -0.00003535256463047664},
                                   {5.5001, 20.7501, -0.00002921417554990009},
                                   {5.5001, 21.0001, -0.00002412421076222604},
                                   {5.5001, 21.2501, -0.00001990704702237293},
                                   {5.5001, 21.5001, -0.00001641579933001936},
                                   {5.5001, 21.7501, -0.00001352775266668393},
                                   {5.5001, 22.0001, -0.00001114049337539404},
                                   {5.5001, 22.2501, -9.16863829136046e-6},
                                   {5.5001, 22.5001, -7.541073517995491e-6},
                                   {5.5001, 22.7501, -6.198626878334551e-6},
                                   {5.5001, 23.0001, -5.092108709180518e-6},
                                   {5.5001, 23.2501, -4.180664952567178e-6},
                                   {5.5001, 23.5001, -3.430394578539428e-6},
                                   {5.5001, 23.7501, -2.813190378476311e-6},
                                   {5.5001, 24.0001, -2.305768223304503e-6},
                                   {5.5001, 24.2501, -1.888855099784855e-6},
                                   {5.5001, 24.5001, -1.546510724028256e-6},
                                   {5.5001, 24.7501, -1.265561377723099e-6},
                                   {5.5001, 25.0001, -1.035127902643016e-6},
                                   {5.5001, 25.2501, -8.46232597021991e-7},
                                   {5.5001, 25.5001, -6.914721489273546e-7},
                                   {5.5001, 25.7501, -5.647457745410493e-7},
                                   {5.5001, 26.0001, -4.610294538333333e-7},
                                   {5.5001, 26.2501, -3.761886165846002e-7},
                                   {5.5001, 26.5001, -3.0682286641122e-7},
                                   {5.5001, 26.7501, -2.501373725822952e-7},
                                   {5.5001, 27.0001, -2.038364376421495e-7},
                                   {5.5001, 27.2501, -1.660354878545704e-7},
                                   {5.5001, 27.5001, -1.351883544478562e-7},
                                   {5.5001, 27.7501, -1.100272347034913e-7},
                                   {5.5001, 28.0001, -8.95131585973201e-8},
                                   {5.5001, 28.2501, -7.279515217756551e-8},
                                   {5.5001, 28.5001, -5.917659438630664e-8},
                                   {5.5001, 28.7501, -4.80875191372805e-8},
                                   {5.5001, 29.0001, -3.906182723209234e-8},
                                   {5.5001, 29.2501, -3.171854996439996e-8},
                                   {5.5001, 29.5001, -2.574645379567465e-8},
                                   {5.5001, 29.7501, -2.089139815123608e-8},
                                   {5.7501, 0.0001, -4.249003841584093e-15},
                                   {5.7501, 0.2501, -1.991391649230723e-6},
                                   {5.7501, 0.5001, -0.00006819665064331377},
                                   {5.7501, 0.7501, -0.0004791693841156549},
                                   {5.7501, 1.0001, -0.001765128819235005},
                                   {5.7501, 1.2501, -0.004569667325180325},
                                   {5.7501, 1.5001, -0.00947009147765825},
                                   {5.7501, 1.7501, -0.01683766531327493},
                                   {5.7501, 2.0001, -0.02676700586356615},
                                   {5.7501, 2.2501, -0.03907110288318727},
                                   {5.7501, 2.5001, -0.05332398483649762},
                                   {5.7501, 2.7501, -0.06893004439248163},
                                   {5.7501, 3.0001, -0.0852018706618302},
                                   {5.7501, 3.2501, -0.1014334678126718},
                                   {5.7501, 3.5001, -0.11696091400157},
                                   {5.7501, 3.7501, -0.1312068518281316},
                                   {5.7501, 4.0001, -0.1437083764492177},
                                   {5.7501, 4.2501, -0.1541299290133425},
                                   {5.7501, 4.5001, -0.1622639024264133},
                                   {5.7501, 4.7501, -0.1680220639914153},
                                   {5.7501, 5.0001, -0.1714208244016606},
                                   {5.7501, 5.2501, -0.172563025875363},
                                   {5.7501, 5.5001, -0.1716184287794484},
                                   {5.7501, 5.7501, -0.1688045471027746},
                                   {5.7501, 6.0001, -0.1643689831310376},
                                   {5.7501, 6.2501, -0.1585739768459305},
                                   {5.7501, 6.5001, -0.1516835317263297},
                                   {5.7501, 6.7501, -0.1439532079234568},
                                   {5.7501, 7.0001, -0.135622480014605},
                                   {5.7501, 7.2501, -0.1269094290679831},
                                   {5.7501, 7.5001, -0.1180074652077157},
                                   {5.7501, 7.7501, -0.1090837449271192},
                                   {5.7501, 8.0001, -0.1002789458191776},
                                   {5.7501, 8.2501, -0.0917080805478597},
                                   {5.7501, 8.5001, -0.0834620639361786},
                                   {5.7501, 8.7501, -0.07560978590875499},
                                   {5.7501, 9.0001, -0.06820048418810937},
                                   {5.7501, 9.2501, -0.06126625094125764},
                                   {5.7501, 9.5001, -0.05482454493970586},
                                   {5.7501, 9.7501, -0.04888061402237261},
                                   {5.7501, 10.0001, -0.04342976117093532},
                                   {5.7501, 10.2501, -0.03845941121448493},
                                   {5.7501, 10.5001, -0.03395095428030253},
                                   {5.7501, 10.7501, -0.02988135699928494},
                                   {5.7501, 11.0001, -0.02622454366272986},
                                   {5.7501, 11.2501, -0.02295255755745205},
                                   {5.7501, 11.5001, -0.02003651812030073},
                                   {5.7501, 11.7501, -0.01744739285982448},
                                   {5.7501, 12.0001, -0.01515660465054189},
                                   {5.7501, 12.2501, -0.01313649541371218},
                                   {5.7501, 12.5001, -0.01136066669631358},
                                   {5.7501, 12.7501, -0.00980421652665447},
                                   {5.7501, 13.0001, -0.00844389038559701},
                                   {5.7501, 13.2501, -0.007258162363079792},
                                   {5.7501, 13.5001, -0.006227260704786004},
                                   {5.7501, 13.7501, -0.005333150092321168},
                                   {5.7501, 14.0001, -0.004559481211947735},
                                   {5.7501, 14.2501, -0.003891516498195518},
                                   {5.7501, 14.5001, -0.003316039417613053},
                                   {5.7501, 14.7501, -0.002821253298611597},
                                   {5.7501, 15.0001, -0.00239667451945063},
                                   {5.7501, 15.2501, -0.00203302383415922},
                                   {5.7501, 15.5001, -0.001722118736766346},
                                   {5.7501, 15.7501, -0.001456769025622382},
                                   {5.7501, 16.0001, -0.001230677118071568},
                                   {5.7501, 16.2501, -0.001038344166826224},
                                   {5.7501, 16.5001, -0.000874982628717004},
                                   {5.7501, 16.7501, -0.0007364356202742892},
                                   {5.7501, 17.0001, -0.0006191031500086118},
                                   {5.7501, 17.2501, -0.000519875132628688},
                                   {5.7501, 17.5001, -0.0004360709553365028},
                                   {5.7501, 17.7501, -0.0003653852716054406},
                                   {5.7501, 18.0001, -0.0003058396355414233},
                                   {5.7501, 18.2501, -0.000255739553263377},
                                   {5.7501, 18.5001, -0.0002136365109913499},
                                   {5.7501, 18.7501, -0.0001782945379236545},
                                   {5.7501, 19.0001, -0.0001486608715861345},
                                   {5.7501, 19.2501, -0.0001238403109488839},
                                   {5.7501, 19.5001, -0.0001030728656618278},
                                   {5.7501, 19.7501, -0.0000857143362304267},
                                   {5.7501, 20.0001, -0.00007121948825692894},
                                   {5.7501, 20.2501, -0.00005912751280567326},
                                   {5.7501, 20.5001, -0.00004904949361459975},
                                   {5.7501, 20.7501, -0.00004065762962003782},
                                   {5.7501, 21.0001, -0.00003367598763819537},
                                   {5.7501, 21.2501, -0.00002787258476239038},
                                   {5.7501, 21.5001, -0.00002305262292044252},
                                   {5.7501, 21.7501, -0.00001905271901605518},
                                   {5.7501, 22.0001, -0.00001573599314588352},
                                   {5.7501, 22.2501, -0.00001298789458575955},
                                   {5.7501, 22.5001, -0.00001071266065645536},
                                   {5.7501, 22.7501, -8.83031731635665e-6},
                                   {5.7501, 23.0001, -7.274142504795591e-6},
                                   {5.7501, 23.2501, -5.988524002055732e-6},
                                   {5.7501, 23.5001, -4.927153008546275e-6},
                                   {5.7501, 23.7501, -4.051502902596603e-6},
                                   {5.7501, 24.0001, -3.329549835145744e-6},
                                   {5.7501, 24.2501, -2.734698074990756e-6},
                                   {5.7501, 24.5001, -2.244878437051426e-6},
                                   {5.7501, 24.7501, -1.841792806677438e-6},
                                   {5.7501, 25.0001, -1.51028180505615e-6},
                                   {5.7501, 25.2501, -1.237796105370264e-6},
                                   {5.7501, 25.5001, -1.01395487929861e-6},
                                   {5.7501, 25.7501, -8.30177393674709e-7},
                                   {5.7501, 26.0001, -6.793759452026091e-7},
                                   {5.7501, 26.2501, -5.557001678890495e-7},
                                   {5.7501, 26.5001, -4.543243179195037e-7},
                                   {5.7501, 26.7501, -3.712704731293626e-7},
                                   {5.7501, 27.0001, -3.032617130230937e-7},
                                   {5.7501, 27.2501, -2.476003000247414e-7},
                                   {5.7501, 27.5001, -2.020666888792028e-7},
                                   {5.7501, 27.7501, -1.648358709406787e-7},
                                   {5.7501, 28.0001, -1.344081324832957e-7},
                                   {5.7501, 28.2501, -1.095517874570823e-7},
                                   {5.7501, 28.5001, -8.92558492584179e-8},
                                   {5.7501, 28.7501, -7.26909450211159e-8},
                                   {5.7501, 29.0001, -5.917705983505508e-8},
                                   {5.7501, 29.2501, -4.815693582190499e-8},
                                   {5.7501, 29.5001, -3.917414949168279e-8},
                                   {5.7501, 29.7501, -3.185505650075664e-8},
                                   {6.0001, 0.0001, -4.382961436267172e-15},
                                   {6.0001, 0.2501, -8.9548296607414e-7},
                                   {6.0001, 0.5001, -0.00003652634376793339},
                                   {6.0001, 0.7501, -0.0002843271136083389},
                                   {6.0001, 1.0001, -0.001126408294541789},
                                   {6.0001, 1.2501, -0.003085473774913761},
                                   {6.0001, 1.5001, -0.00669626885044527},
                                   {6.0001, 1.7501, -0.01237973152384658},
                                   {6.0001, 2.0001, -0.02035712862933841},
                                   {6.0001, 2.2501, -0.03061473421880811},
                                   {6.0001, 2.5001, -0.04291320843594138},
                                   {6.0001, 2.7501, -0.05682850520290849},
                                   {6.0001, 3.0001, -0.0718098504099398},
                                   {6.0001, 3.2501, -0.0872423440383154},
                                   {6.0001, 3.5001, -0.1025050904639649},
                                   {6.0001, 3.7501, -0.1170192484516911},
                                   {6.0001, 4.0001, -0.1302833883800861},
                                   {6.0001, 4.2501, -0.1418958044316128},
                                   {6.0001, 4.5001, -0.1515649370033139},
                                   {6.0001, 4.7501, -0.159109915864579},
                                   {6.0001, 5.0001, -0.1644535837670505},
                                   {6.0001, 5.2501, -0.1676103531015547},
                                   {6.0001, 5.5001, -0.1686710164845283},
                                   {6.0001, 5.7501, -0.1677862806552967},
                                   {6.0001, 6.0001, -0.1651503986215738},
                                   {6.0001, 6.2501, -0.160985889410043},
                                   {6.0001, 6.5001, -0.1555299894565436},
                                   {6.0001, 6.7501, -0.1490231905377156},
                                   {6.0001, 7.0001, -0.1416999912002964},
                                   {6.0001, 7.2501, -0.1337818197280822},
                                   {6.0001, 7.5001, -0.1254719704318562},
                                   {6.0001, 7.7501, -0.1169523230359267},
                                   {6.0001, 8.0001, -0.1083815781871289},
                                   {6.0001, 8.2501, -0.0998947320423725},
                                   {6.0001, 8.5001, -0.0916035218554128},
                                   {6.0001, 8.7501, -0.0835975960396288},
                                   {6.0001, 9.0001, -0.07594619115059162},
                                   {6.0001, 9.2501, -0.06870013062946521},
                                   {6.0001, 9.5001, -0.06189399306242899},
                                   {6.0001, 9.7501, -0.05554832913158171},
                                   {6.0001, 10.0001, -0.04967183507946224},
                                   {6.0001, 10.2501, -0.04426341567140671},
                                   {6.0001, 10.5001, -0.03931409103066613},
                                   {6.0001, 10.7501, -0.03480871935544893},
                                   {6.0001, 11.0001, -0.03072752162151853},
                                   {6.0001, 11.2501, -0.02704740526865545},
                                   {6.0001, 11.5001, -0.02374309196802447},
                                   {6.0001, 11.7501, -0.02078806029473895},
                                   {6.0001, 12.0001, -0.0181553179008549},
                                   {6.0001, 12.2501, -0.01581801998513364},
                                   {6.0001, 12.5001, -0.0137499518336472},
                                   {6.0001, 12.7501, -0.01192589326077491},
                                   {6.0001, 13.0001, -0.01032188216800908},
                                   {6.0001, 13.2501, -0.00891539336821903},
                                   {6.0001, 13.5001, -0.007685447464454952},
                                   {6.0001, 13.7501, -0.006612663057264999},
                                   {6.0001, 14.0001, -0.005679263983488721},
                                   {6.0001, 14.2501, -0.004869051736561664},
                                   {6.0001, 14.5001, -0.004167351735550967},
                                   {6.0001, 14.7501, -0.003560940731807111},
                                   {6.0001, 15.0001, -0.00303796138874338},
                                   {6.0001, 15.2501, -0.002587828951691564},
                                   {6.0001, 15.5001, -0.002201133942978446},
                                   {6.0001, 15.7501, -0.001869543968616935},
                                   {6.0001, 16.0001, -0.0015857069997565},
                                   {6.0001, 16.2501, -0.001343157884314637},
                                   {6.0001, 16.5001, -0.001136229340712118},
                                   {6.0001, 16.7501, -0.000959968274549322},
                                   {6.0001, 17.0001, -0.000810057928665067},
                                   {6.0001, 17.2501, -0.0006827461160881663},
                                   {6.0001, 17.5001, -0.0005747795834687935},
                                   {6.0001, 17.7501, -0.0004833444001322161},
                                   {6.0001, 18.0001, -0.0004060121564052361},
                                   {6.0001, 18.2501, -0.0003406916768170201},
                                   {6.0001, 18.5001, -0.0002855859026522148},
                                   {6.0001, 18.7501, -0.0002391535685496296},
                                   {6.0001, 19.0001, -0.0002000752846673624},
                                   {6.0001, 19.2501, -0.0001672236354228973},
                                   {6.0001, 19.5001, -0.0001396369146997356},
                                   {6.0001, 19.7501, -0.0001164961330271525},
                                   {6.0001, 20.0001, -0.0000971049524422046},
                                   {6.0001, 20.2501, -0.0000808722278311072},
                                   {6.0001, 20.5001, -0.00006729685819134328},
                                   {6.0001, 20.7501, -0.00005595467643787279},
                                   {6.0001, 21.0001, -0.00004648713133404808},
                                   {6.0001, 21.2501, -0.00003859153930624188},
                                   {6.0001, 21.5001, -0.0000320127069143674},
                                   {6.0001, 21.7501, -0.00002653574634512261},
                                   {6.0001, 22.0001, -0.00002197992632170905},
                                   {6.0001, 22.2501, -0.00001819341921372482},
                                   {6.0001, 22.5001, -0.00001504882187487785},
                                   {6.0001, 22.7501, -0.00001243934286918739},
                                   {6.0001, 23.0001, -0.00001027556233472711},
                                   {6.0001, 23.2501, -8.48268286496447e-6},
                                   {6.0001, 23.5001, -6.998200561582153e-6},
                                   {6.0001, 23.7501, -5.769934936336668e-6},
                                   {6.0001, 24.0001, -4.754364722178037e-6},
                                   {6.0001, 24.2501, -3.91522400339948e-6},
                                   {6.0001, 24.5001, -3.222319495166151e-6},
                                   {6.0001, 24.7501, -2.650535393152989e-6},
                                   {6.0001, 25.0001, -2.178997066516406e-6},
                                   {6.0001, 25.2501, -1.790369067304104e-6},
                                   {6.0001, 25.5001, -1.470266554652329e-6},
                                   {6.0001, 25.7501, -1.206762353448239e-6},
                                   {6.0001, 26.0001, -9.89974548204804e-7},
                                   {6.0001, 26.2501, -8.11721810640347e-7},
                                   {6.0001, 26.5001, -6.652356245074876e-7},
                                   {6.0001, 26.7501, -5.449202483716262e-7},
                                   {6.0001, 27.0001, -4.461526857467465e-7},
                                   {6.0001, 27.2501, -3.651161468544805e-7},
                                   {6.0001, 27.5001, -2.986615175032993e-7},
                                   {6.0001, 27.7501, -2.441922245014034e-7},
                                   {6.0001, 28.0001, -1.995686264505233e-7},
                                   {6.0001, 28.2501, -1.630286834684663e-7},
                                   {6.0001, 28.5001, -1.33122186396904e-7},
                                   {6.0001, 28.7501, -1.086562700272434e-7},
                                   {6.0001, 29.0001, -8.86503084050618e-8},
                                   {6.0001, 29.2501, -7.229860412977544e-8},
                                   {6.0001, 29.5001, -5.89395469566769e-8},
                                   {6.0001, 29.7501, -4.803013778614928e-8},
                                   {6.2501, 0.0001, -4.512016518645136e-15},
                                   {6.2501, 0.2501, -3.986397794561036e-7},
                                   {6.2501, 0.5001, -0.00001936591005397034},
                                   {6.2501, 0.7501, -0.0001669988993777483},
                                   {6.2501, 1.0001, -0.0007114828755735608},
                                   {6.2501, 1.2501, -0.002062028432404243},
                                   {6.2501, 1.5001, -0.004686359939233914},
                                   {6.2501, 1.7501, -0.00900854719207445},
                                   {6.2501, 2.0001, -0.01532282197076246},
                                   {6.2501, 2.2501, -0.02374122376216534},
                                   {6.2501, 2.5001, -0.03417827986074084},
                                   {6.2501, 2.7501, -0.04636693665763958},
                                   {6.2501, 3.0001, -0.05989597124002858},
                                   {6.2501, 3.2501, -0.0742585948435766},
                                   {6.2501, 3.5001, -0.0889034269410974},
                                   {6.2501, 3.7501, -0.1032813393466763},
                                   {6.2501, 4.0001, -0.1168841035129714},
                                   {6.2501, 4.2501, -0.1292729063007048},
                                   {6.2501, 4.5001, -0.1400964486636725},
                                   {6.2501, 4.7501, -0.1490994762596573},
                                   {6.2501, 5.0001, -0.1561232634199516},
                                   {6.2501, 5.2501, -0.1610998729191416},
                                   {6.2501, 5.5001, -0.1640420433835108},
                                   {6.2501, 5.7501, -0.1650304061601859},
                                   {6.2501, 6.0001, -0.164199480652672},
                                   {6.2501, 6.2501, -0.1617236001127988},
                                   {6.2501, 6.5001, -0.1578036200677802},
                                   {6.2501, 6.7501, -0.1526549856083339},
                                   {6.2501, 7.0001, -0.1464974966215529},
                                   {6.2501, 7.2501, -0.1395469179979633},
                                   {6.2501, 7.5001, -0.1320084351608727},
                                   {6.2501, 7.7501, -0.1240718504481575},
                                   {6.2501, 8.0001, -0.1159083473102829},
                                   {6.2501, 8.2501, -0.1076686104878205},
                                   {6.2501, 8.5001, -0.0994820747730296},
                                   {6.2501, 8.7501, -0.0914570766048168},
                                   {6.2501, 9.0001, -0.0836816963301947},
                                   {6.2501, 9.2501, -0.07622510011806005},
                                   {6.2501, 9.5001, -0.06913921576345469},
                                   {6.2501, 9.7501, -0.06246060334033997},
                                   {6.2501, 10.0001, -0.05621240795050211},
                                   {6.2501, 10.2501, -0.05040630639301678},
                                   {6.2501, 10.5001, -0.04504438165507135},
                                   {6.2501, 10.7501, -0.04012087829571062},
                                   {6.2501, 11.0001, -0.03562380793738895},
                                   {6.2501, 11.2501, -0.0315363872737808},
                                   {6.2501, 11.5001, -0.02783830145527882},
                                   {6.2501, 11.7501, -0.0245067937131821},
                                   {6.2501, 12.0001, -0.02151758795458872},
                                   {6.2501, 12.2501, -0.01884565513567186},
                                   {6.2501, 12.5001, -0.01646583682274305},
                                   {6.2501, 12.7501, -0.01435334077493289},
                                   {6.2501, 13.0001, -0.01248412389392966},
                                   {6.2501, 13.2501, -0.01083517771403769},
                                   {6.2501, 13.5001, -0.00938473094307114},
                                   {6.2501, 13.7501, -0.00811238257030907},
                                   {6.2501, 14.0001, -0.006999177859584718},
                                   {6.2501, 14.2501, -0.006027638243421837},
                                   {6.2501, 14.5001, -0.005181754803787232},
                                   {6.2501, 14.7501, -0.004446953722062728},
                                   {6.2501, 15.0001, -0.003810040844116894},
                                   {6.2501, 15.2501, -0.003259131361294088},
                                   {6.2501, 15.5001, -0.00278356956957192},
                                   {6.2501, 15.7501, -0.002373842743794981},
                                   {6.2501, 16.0001, -0.002021492352470045},
                                   {6.2501, 16.2501, -0.001719025137489105},
                                   {6.2501, 16.5001, -0.001459825985783656},
                                   {6.2501, 16.7501, -0.001238074017921845},
                                   {6.2501, 17.0001, -0.001048662902660336},
                                   {6.2501, 17.2501, -0.000887126066716277},
                                   {6.2501, 17.5001, -0.0007495671958929504},
                                   {6.2501, 17.7501, -0.0006325962079587606},
                                   {6.2501, 18.0001, -0.0005332707107583551},
                                   {6.2501, 18.2501, -0.0004490428330982844},
                                   {6.2501, 18.5001, -0.0003777112239853875},
                                   {6.2501, 18.7501, -0.0003173779516193351},
                                   {6.2501, 19.0001, -0.0002664099917726006},
                                   {6.2501, 19.2501, -0.0002234049712132755},
                                   {6.2501, 19.5001, -0.00018716082172179},
                                   {6.2501, 19.7501, -0.0001566490007391766},
                                   {6.2501, 20.0001, -0.0001309909430437717},
                                   {6.2501, 20.2501, -0.0001094374218617059},
                                   {6.2501, 20.5001, -0.0000913505156789703},
                                   {6.2501, 20.7501, -0.00007618789731024479},
                                   {6.2501, 21.0001, -0.00006348918337259969},
                                   {6.2501, 21.2501, -0.00005286410434997403},
                                   {6.2501, 21.5001, -0.00004398227727027079},
                                   {6.2501, 21.7501, -0.00003656438417906293},
                                   {6.2501, 22.0001, -0.00003037457975149723},
                                   {6.2501, 22.2501, -0.00002521397031869216},
                                   {6.2501, 22.5001, -0.00002091502416673816},
                                   {6.2501, 22.7501, -0.00001733678913349338},
                                   {6.2501, 23.0001, -0.00001436080827046732},
                                   {6.2501, 23.2501, -0.00001188763768197958},
                                   {6.2501, 23.5001, -9.83388265635791e-6},
                                   {6.2501, 23.7501, -8.12967893748943e-6},
                                   {6.2501, 24.0001, -6.716555534417496e-6},
                                   {6.2501, 24.2501, -5.545623923002381e-6},
                                   {6.2501, 24.5001, -4.576045950308723e-6},
                                   {6.2501, 24.7501, -3.773739301974511e-6},
                                   {6.2501, 25.0001, -3.110285125096658e-6},
                                   {6.2501, 25.2501, -2.562007399505404e-6},
                                   {6.2501, 25.5001, -2.1091979987195e-6},
                                   {6.2501, 25.7501, -1.735465152508878e-6},
                                   {6.2501, 26.0001, -1.427186283821239e-6},
                                   {6.2501, 26.2501, -1.173049005663192e-6},
                                   {6.2501, 26.5001, -9.63666484149724e-7},
                                   {6.2501, 26.7501, -7.912554523630143e-7},
                                   {6.2501, 27.0001, -6.493669404829687e-7},
                                   {6.2501, 27.2501, -5.326613104121981e-7},
                                   {6.2501, 27.5001, -4.367204827245378e-7},
                                   {6.2501, 27.7501, -3.578913509058088e-7},
                                   {6.2501, 28.0001, -2.931553193962917e-7},
                                   {6.2501, 28.2501, -2.400197013303307e-7},
                                   {6.2501, 28.5001, -1.964273894897275e-7},
                                   {6.2501, 28.7501, -1.606817875197633e-7},
                                   {6.2501, 29.0001, -1.313844731848672e-7},
                                   {6.2501, 29.2501, -1.073834745442619e-7},
                                   {6.2501, 29.5001, -8.77303847410483e-8},
                                   {6.2501, 29.7501, -7.164483135139653e-8},
                                   {6.5001, 0.0001, -4.636537581603227e-15},
                                   {6.5001, 0.2501, -1.757507990573377e-7},
                                   {6.5001, 0.5001, -0.00001016791070217672},
                                   {6.5001, 0.7501, -0.0000971293470829251},
                                   {6.5001, 1.0001, -0.0004449990100085101},
                                   {6.5001, 1.2501, -0.001364523047420946},
                                   {6.5001, 1.5001, -0.003247441297271094},
                                   {6.5001, 1.7501, -0.006490708777845051},
                                   {6.5001, 2.0001, -0.01141949386604146},
                                   {6.5001, 2.2501, -0.01822864857479539},
                                   {6.5001, 2.5001, -0.02695142791696287},
                                   {6.5001, 2.7501, -0.03745563080754515},
                                   {6.5001, 3.0001, -0.0494620832740967},
                                   {6.5001, 3.2501, -0.06257810509398205},
                                   {6.5001, 3.5001, -0.07633844057766379},
                                   {6.5001, 3.7501, -0.0902472288809985},
                                   {6.5001, 4.0001, -0.1038162482475916},
                                   {6.5001, 4.2501, -0.1165964170159622},
                                   {6.5001, 4.5001, -0.1282010901822197},
                                   {6.5001, 4.7501, -0.1383209194484954},
                                   {6.5001, 5.0001, -0.1467309130429845},
                                   {6.5001, 5.2501, -0.1532908657399853},
                                   {6.5001, 5.5001, -0.1579405867003824},
                                   {6.5001, 5.7501, -0.1606914006214286},
                                   {6.5001, 6.0001, -0.1616153016929349},
                                   {6.5001, 6.2501, -0.1608329565784449},
                                   {6.5001, 6.5001, -0.1585015270102353},
                                   {6.5001, 6.7501, -0.1548030476654999},
                                   {6.5001, 7.0001, -0.1499338731398925},
                                   {6.5001, 7.2501, -0.1440955125572589},
                                   {6.5001, 7.5001, -0.1374870083068549},
                                   {6.5001, 7.7501, -0.1302988882851883},
                                   {6.5001, 8.0001, -0.122708627221918},
                                   {6.5001, 8.2501, -0.1148774885643492},
                                   {6.5001, 8.5001, -0.1069485793497372},
                                   {6.5001, 8.7501, -0.0990459315794903},
                                   {6.5001, 9.0001, -0.0912744200750368},
                                   {6.5001, 9.2501, -0.083720334361427},
                                   {6.5001, 9.5001, -0.07645243712936373},
                                   {6.5001, 9.7501, -0.06952336127407859},
                                   {6.5001, 10.0001, -0.06297121905471919},
                                   {6.5001, 10.2501, -0.05682131880683189},
                                   {6.5001, 10.5001, -0.05108790563158251},
                                   {6.5001, 10.7501, -0.04577586176214809},
                                   {6.5001, 11.0001, -0.04088231939305225},
                                   {6.5001, 11.2501, -0.03639815343505166},
                                   {6.5001, 11.5001, -0.03230933390039693},
                                   {6.5001, 11.7501, -0.02859812753756425},
                                   {6.5001, 12.0001, -0.02524414611326129},
                                   {6.5001, 12.2501, -0.02222524462391115},
                                   {6.5001, 12.5001, -0.01951827697130787},
                                   {6.5001, 12.7501, -0.01709971952123835},
                                   {6.5001, 13.0001, -0.0149461747305182},
                                   {6.5001, 13.2501, -0.01303476790679483},
                                   {6.5001, 13.5001, -0.0113434503602745},
                                   {6.5001, 13.7501, -0.00985122189288332},
                                   {6.5001, 14.0001, -0.00853828489602302},
                                   {6.5001, 14.2501, -0.007386141414334613},
                                   {6.5001, 14.5001, -0.006377643476912996},
                                   {6.5001, 14.7501, -0.005497005875031347},
                                   {6.5001, 15.0001, -0.004729789434017726},
                                   {6.5001, 15.2501, -0.004062861728329707},
                                   {6.5001, 15.5001, -0.003484341152155896},
                                   {6.5001, 15.7501, -0.002983529301788261},
                                   {6.5001, 16.0001, -0.002550835761199435},
                                   {6.5001, 16.2501, -0.002177698613151634},
                                   {6.5001, 16.5001, -0.001856503324567351},
                                   {6.5001, 16.7501, -0.001580502073314753},
                                   {6.5001, 17.0001, -0.001343735088277471},
                                   {6.5001, 17.2501, -0.001140955158474455},
                                   {6.5001, 17.5001, -0.000967556122219289},
                                   {6.5001, 17.7501, -0.000819505865763427},
                                   {6.5001, 18.0001, -0.000693284134570842},
                                   {6.5001, 18.2501, -0.0005858252817024706},
                                   {6.5001, 18.5001, -0.0004944659396545653},
                                   {6.5001, 18.7501, -0.0004168974979270262},
                                   {6.5001, 19.0001, -0.0003511231927977271},
                                   {6.5001, 19.2501, -0.0002954195631277169},
                                   {6.5001, 19.5001, -0.0002483019920616814},
                                   {6.5001, 19.7501, -0.0002084940353843518},
                                   {6.5001, 20.0001, -0.0001749002297892744},
                                   {6.5001, 20.2501, -0.000146582075676361},
                                   {6.5001, 20.5001, -0.0001227368970492787},
                                   {6.5001, 20.7501, -0.0001026792937724126},
                                   {6.5001, 21.0001, -0.0000858249173641556},
                                   {6.5001, 21.2501, -0.00007167631944719551},
                                   {6.5001, 21.5001, -0.00005981064100368085},
                                   {6.5001, 21.7501, -0.00004986892996623929},
                                   {6.5001, 22.0001, -0.00004154689386656052},
                                   {6.5001, 22.2501, -0.000034586912860302},
                                   {6.5001, 22.5001, -0.0000287711561680462},
                                   {6.5001, 22.7501, -0.0000239156616296715},
                                   {6.5001, 23.0001, -0.00001986525355148295},
                                   {6.5001, 23.2501, -0.00001648918827758055},
                                   {6.5001, 23.5001, -0.00001367742992915499},
                                   {6.5001, 23.7501, -0.00001133747055035712},
                                   {6.5001, 24.0001, -9.3916195232128e-6},
                                   {6.5001, 24.2501, -7.774696628944637e-6},
                                   {6.5001, 24.5001, -6.432071611431897e-6},
                                   {6.5001, 24.7501, -5.318000618480757e-6},
                                   {6.5001, 25.0001, -4.394216538389478e-6},
                                   {6.5001, 25.2501, -3.62873609288632e-6},
                                   {6.5001, 25.5001, -2.994851670532915e-6},
                                   {6.5001, 25.7501, -2.470280361177227e-6},
                                   {6.5001, 26.0001, -2.036446551609159e-6},
                                   {6.5001, 26.2501, -1.677877829851919e-6},
                                   {6.5001, 26.5001, -1.381696879928482e-6},
                                   {6.5001, 26.7501, -1.137194584622447e-6},
                                   {6.5001, 27.0001, -9.35471739690083e-7},
                                   {6.5001, 27.2501, -7.6913866319366e-7},
                                   {6.5001, 27.5001, -6.320635974448803e-7},
                                   {6.5001, 27.7501, -5.191621834310494e-7},
                                   {6.5001, 28.0001, -4.262214694703558e-7},
                                   {6.5001, 28.2501, -3.497529244519977e-7},
                                   {6.5001, 28.5001, -2.868697852689652e-7},
                                   {6.5001, 28.7501, -2.351847988483773e-7},
                                   {6.5001, 29.0001, -1.92725039745874e-7},
                                   {6.5001, 29.2501, -1.57861010423254e-7},
                                   {6.5001, 29.5001, -1.292476767849102e-7},
                                   {6.5001, 29.7501, -1.057754681587562e-7},
                                   {6.7501, 0.0001, -4.756852306061102e-15},
                                   {6.7501, 0.2501, -7.676534768564593e-8},
                                   {6.7501, 0.5001, -5.288688891959641e-6},
                                   {6.7501, 0.7501, -0.00005596169734488885},
                                   {6.7501, 1.0001, -0.0002757038766916708},
                                   {6.7501, 1.2501, -0.000894426753572229},
                                   {6.7501, 1.5001, -0.002229025072663467},
                                   {6.7501, 1.7501, -0.004632219200798348},
                                   {6.7501, 2.0001, -0.00842960489230116},
                                   {6.7501, 2.2501, -0.01386281910732161},
                                   {6.7501, 2.5001, -0.02105005157516656},
                                   {6.7501, 2.7501, -0.02996817250666686},
                                   {6.7501, 3.0001, -0.04045541894826114},
                                   {6.7501, 3.2501, -0.05223036363999139},
                                   {6.7501, 3.5001, -0.06492153930561702},
                                   {6.7501, 3.7501, -0.07810209805874902},
                                   {6.7501, 4.0001, -0.0913247182582359},
                                   {6.7501, 4.2501, -0.1041531887999444},
                                   {6.7501, 4.5001, -0.1161883879305301},
                                   {6.7501, 4.7501, -0.1270875339275536},
                                   {6.7501, 5.0001, -0.1365765181731695},
                                   {6.7501, 5.2501, -0.1444558057710193},
                                   {6.7501, 5.5001, -0.1506008173552077},
                                   {6.7501, 5.7501, -0.1549579247165657},
                                   {6.7501, 6.0001, -0.1575372488403041},
                                   {6.7501, 6.2501, -0.1584033889929851},
                                   {6.7501, 6.5001, -0.1576650778045694},
                                   {6.7501, 6.7501, -0.1554645845327327},
                                   {6.7501, 7.0001, -0.1519675033022247},
                                   {6.7501, 7.2501, -0.1473533837223276},
                                   {6.7501, 7.5001, -0.1418074998245802},
                                   {6.7501, 7.7501, -0.1355139162614476},
                                   {6.7501, 8.0001, -0.1286499006353253},
                                   {6.7501, 8.2501, -0.1213816473037553},
                                   {6.7501, 8.5001, -0.1138612188090503},
                                   {6.7501, 8.7501, -0.106224572948489},
                                   {6.7501, 9.0001, -0.0985905227348266},
                                   {6.7501, 9.2501, -0.0910604693765383},
                                   {6.7501, 9.5001, -0.0837187514673166},
                                   {6.7501, 9.7501, -0.07663346376167551},
                                   {6.7501, 10.0001, -0.06985761366047793},
                                   {6.7501, 10.2501, -0.06343050076793299},
                                   {6.7501, 10.5001, -0.0573792230137099},
                                   {6.7501, 10.7501, -0.05172023068661076},
                                   {6.7501, 11.0001, -0.04646086648753815},
                                   {6.7501, 11.2501, -0.04160084486408549},
                                   {6.7501, 11.5001, -0.03713363715663609},
                                   {6.7501, 11.7501, -0.03304774036451338},
                                   {6.7501, 12.0001, -0.02932781665810536},
                                   {6.7501, 12.2501, -0.02595569823524186},
                                   {6.7501, 12.5001, -0.02291125791934314},
                                   {6.7501, 12.7501, -0.02017315022490146},
                                   {6.7501, 13.0001, -0.01771943068539956},
                                   {6.7501, 13.2501, -0.01552806325949432},
                                   {6.7501, 13.5001, -0.01357732680053983},
                                   {6.7501, 13.7501, -0.01184613207148859},
                                   {6.7501, 14.0001, -0.01031426076986616},
                                   {6.7501, 14.2501, -0.00896253763154167},
                                   {6.7501, 14.5001, -0.007772946021149528},
                                   {6.7501, 14.7501, -0.006728696584360449},
                                   {6.7501, 15.0001, -0.005814257607111988},
                                   {6.7501, 15.2501, -0.005015354757211508},
                                   {6.7501, 15.5001, -0.004318946917993753},
                                   {6.7501, 15.7501, -0.003713183893541566},
                                   {6.7501, 16.0001, -0.003187350892084262},
                                   {6.7501, 16.2501, -0.002731803892350431},
                                   {6.7501, 16.5001, -0.002337899274399017},
                                   {6.7501, 16.7501, -0.001997920454528859},
                                   {6.7501, 17.0001, -0.001705003702466852},
                                   {6.7501, 17.2501, -0.001453064834824606},
                                   {6.7501, 17.5001, -0.00123672806675649},
                                   {6.7501, 17.7501, -0.001051257957765274},
                                   {6.7501, 18.0001, -0.000892495101062846},
                                   {6.7501, 18.2501, -0.0007567959720236479},
                                   {6.7501, 18.5001, -0.0006409771634111765},
                                   {6.7501, 18.7501, -0.0005422640868737617},
                                   {6.7501, 19.0001, -0.0004582441058010597},
                                   {6.7501, 19.2501, -0.0003868239786335323},
                                   {6.7501, 19.5001, -0.0003261914293059403},
                                   {6.7501, 19.7501, -0.0002747806184261162},
                                   {6.7501, 20.0001, -0.000231241261331544},
                                   {6.7501, 20.2501, -0.0001944111241338247},
                                   {6.7501, 20.5001, -0.0001632916235368137},
                                   {6.7501, 20.7501, -0.0001370262583121336},
                                   {6.7501, 21.0001, -0.0001148816079358149},
                                   {6.7501, 21.2501, -0.0000962306454715516},
                                   {6.7501, 21.5001, -0.0000805381260643127},
                                   {6.7501, 21.7501, -0.00006734782837129445},
                                   {6.7501, 22.0001, -0.00005627144310936528},
                                   {6.7501, 22.2501, -0.00004697892002424406},
                                   {6.7501, 22.5001, -0.00003919010152210438},
                                   {6.7501, 22.7501, -0.00003266748760822758},
                                   {6.7501, 23.0001, -0.0000272099924092582},
                                   {6.7501, 23.2501, -0.00002264756725560539},
                                   {6.7501, 23.5001, -0.00001883657897229268},
                                   {6.7501, 23.7501, -0.00001565584462330506},
                                   {6.7501, 24.0001, -0.00001300323546719203},
                                   {6.7501, 24.2501, -0.00001079277332943809},
                                   {6.7501, 24.5001, -8.95215201924947e-6},
                                   {6.7501, 24.7501, -7.420624868228936e-6},
                                   {6.7501, 25.0001, -6.147207008194144e-6},
                                   {6.7501, 25.2501, -5.089147702479884e-6},
                                   {6.7501, 25.5001, -4.210633968873935e-6},
                                   {6.7501, 25.7501, -3.481691952122509e-6},
                                   {6.7501, 26.0001, -2.877257087142197e-6},
                                   {6.7501, 26.2501, -2.376388105161215e-6},
                                   {6.7501, 26.5001, -1.961603434707456e-6},
                                   {6.7501, 26.7501, -1.618321594175354e-6},
                                   {6.7501, 27.0001, -1.334389814698338e-6},
                                   {6.7501, 27.2501, -1.099687418771336e-6},
                                   {6.7501, 27.5001, -9.05792454607227e-7},
                                   {6.7501, 27.7501, -7.457017873827633e-7},
                                   {6.7501, 28.0001, -6.135963110788114e-7},
                                   {6.7501, 28.2501, -5.046441994955514e-7},
                                   {6.7501, 28.5001, -4.148361896575169e-7},
                                   {6.7501, 28.7501, -3.408478094307897e-7},
                                   {6.7501, 29.0001, -2.799242450475945e-7},
                                   {6.7501, 29.2501, -2.297842120226207e-7},
                                   {6.7501, 29.5001, -1.885397609395564e-7},
                                   {6.7501, 29.7501, -1.546294319642166e-7},
                                   {7.0001, 0.0001, -4.873253418046702e-15},
                                   {7.0001, 0.2501, -3.323003497299182e-8},
                                   {7.0001, 0.5001, -2.726060264544719e-6},
                                   {7.0001, 0.7501, -0.00003195103607797596},
                                   {7.0001, 1.0001, -0.0001692649903360554},
                                   {7.0001, 1.2501, -0.0005809495915982145},
                                   {7.0001, 1.5001, -0.001516035581415054},
                                   {7.0001, 1.7501, -0.003275662462208038},
                                   {7.0001, 2.0001, -0.0061655787393908},
                                   {7.0001, 2.2501, -0.0104459717069112},
                                   {7.0001, 2.5001, -0.01628993263276092},
                                   {7.0001, 2.7501, -0.02375708596643878},
                                   {7.0001, 3.0001, -0.03278432186200756},
                                   {7.0001, 3.2501, -0.04319213617436418},
                                   {7.0001, 3.5001, -0.05470303460742096},
                                   {7.0001, 3.7501, -0.0669676361552789},
                                   {7.0001, 4.0001, -0.07959419335377822},
                                   {7.0001, 4.2501, -0.0921778909062433},
                                   {7.0001, 4.5001, -0.104327197994805},
                                   {7.0001, 4.7501, -0.1156855170787539},
                                   {7.0001, 5.0001, -0.1259472535182453},
                                   {7.0001, 5.2501, -0.1348681504584214},
                                   {7.0001, 5.5001, -0.1422702645843745},
                                   {7.0001, 5.7501, -0.1480423053172741},
                                   {7.0001, 6.0001, -0.1521362463671065},
                                   {7.0001, 6.2501, -0.1545611767060096},
                                   {7.0001, 6.5001, -0.1553753222418506},
                                   {7.0001, 6.7501, -0.1546770715133123},
                                   {7.0001, 7.0001, -0.152595705516448},
                                   {7.0001, 7.2501, -0.1492823844939313},
                                   {7.0001, 7.5001, -0.1449017986624422},
                                   {7.0001, 7.7501, -0.1396247558067586},
                                   {7.0001, 8.0001, -0.133621862571038},
                                   {7.0001, 8.2501, -0.12705836095596},
                                   {7.0001, 8.5001, -0.1200901073891454},
                                   {7.0001, 8.7501, -0.1128606275354497},
                                   {7.0001, 9.0001, -0.1054991435079137},
                                   {7.0001, 9.2501, -0.0981194485749255},
                                   {7.0001, 9.5001, -0.0908194949346188},
                                   {7.0001, 9.7501, -0.083681559847962},
                                   {7.0001, 10.0001, -0.07677286185265019},
                                   {7.0001, 10.2501, -0.070146509731991},
                                   {7.0001, 10.5001, -0.06384268057593745},
                                   {7.0001, 10.7501, -0.05788993820853896},
                                   {7.0001, 11.0001, -0.05230661837665135},
                                   {7.0001, 11.2501, -0.04710222161268701},
                                   {7.0001, 11.5001, -0.04227876807081668},
                                   {7.0001, 11.7501, -0.03783208057197008},
                                   {7.0001, 12.0001, -0.03375297242276207},
                                   {7.0001, 12.2501, -0.03002832526481727},
                                   {7.0001, 12.5001, -0.02664204931977298},
                                   {7.0001, 12.7501, -0.02357592403649889},
                                   {7.0001, 13.0001, -0.02081032147158582},
                                   {7.0001, 13.2501, -0.01832481791049501},
                                   {7.0001, 13.5001, -0.01609870143784015},
                                   {7.0001, 13.7501, -0.01411138455880406},
                                   {7.0001, 14.0001, -0.0123427317158046},
                                   {7.0001, 14.2501, -0.0107733117759153},
                                   {7.0001, 14.5001, -0.00938458540854399},
                                   {7.0001, 14.7501, -0.0081590368349256},
                                   {7.0001, 15.0001, -0.00708025879915149},
                                   {7.0001, 15.2501, -0.006132998856572174},
                                   {7.0001, 15.5001, -0.005303174256635595},
                                   {7.0001, 15.7501, -0.004577861857824943},
                                   {7.0001, 16.0001, -0.003945268685516357},
                                   {7.0001, 16.2501, -0.003394687953156772},
                                   {7.0001, 16.5001, -0.002916444629376512},
                                   {7.0001, 16.7501, -0.002501833958554307},
                                   {7.0001, 17.0001, -0.002143055735162726},
                                   {7.0001, 17.2501, -0.001833146594461633},
                                   {7.0001, 17.5001, -0.001565912112563639},
                                   {7.0001, 17.7501, -0.001335860104415611},
                                   {7.0001, 18.0001, -0.001138136164375852},
                                   {7.0001, 18.2501, -0.000968462205584362},
                                   {7.0001, 18.5001, -0.000823078515602123},
                                   {7.0001, 18.7501, -0.0006986896511232641},
                                   {7.0001, 19.0001, -0.0005924143383582186},
                                   {7.0001, 19.2501, -0.000501739422643668},
                                   {7.0001, 19.5001, -0.0004244778160329054},
                                   {7.0001, 19.7501, -0.0003587303205726849},
                                   {7.0001, 20.0001, -0.0003028511536583818},
                                   {7.0001, 20.2501, -0.0002554169667245693},
                                   {7.0001, 20.5001, -0.0002151991264729042},
                                   {7.0001, 20.7501, -0.0001811390161920358},
                                   {7.0001, 21.0001, -0.0001523261112097237},
                                   {7.0001, 21.2501, -0.0001279785852195562},
                                   {7.0001, 21.5001, -0.0001074262115489073},
                                   {7.0001, 21.7501, -0.0000900953340695992},
                                   {7.0001, 22.0001, -0.00007549569533317992},
                                   {7.0001, 22.2501, -0.00006320892378604997},
                                   {7.0001, 22.5001, -0.00005287849691365965},
                                   {7.0001, 22.7501, -0.0000442010123575295},
                                   {7.0001, 23.0001, -0.00003691861405037162},
                                   {7.0001, 23.2501, -0.00003081243493388663},
                                   {7.0001, 23.5001, -0.00002569693165654163},
                                   {7.0001, 23.7501, -0.00002141499965871222},
                                   {7.0001, 24.0001, -0.00001783376915800392},
                                   {7.0001, 24.2501, -0.00001484099370855052},
                                   {7.0001, 24.5001, -0.0000123419532170902},
                                   {7.0001, 24.7501, -0.00001025680257222359},
                                   {7.0001, 25.0001, -8.51830541549397e-6},
                                   {7.0001, 25.2501, -7.06990009991426e-6},
                                   {7.0001, 25.5001, -5.864051597242409e-6},
                                   {7.0001, 25.7501, -4.860849088093301e-6},
                                   {7.0001, 26.0001, -4.026814259194e-6},
                                   {7.0001, 26.2501, -3.333890000017966e-6},
                                   {7.0001, 26.5001, -2.758583295475552e-6},
                                   {7.0001, 26.7501, -2.281239708608575e-6},
                                   {7.0001, 27.0001, -1.88542999047797e-6},
                                   {7.0001, 27.2501, -1.557432093189457e-6},
                                   {7.0001, 27.5001, -1.285794242000657e-6},
                                   {7.0001, 27.7501, -1.060966785531217e-6},
                                   {7.0001, 28.0001, -8.74992327250129e-7},
                                   {7.0001, 28.2501, -7.212451809220255e-7},
                                   {7.0001, 28.5001, -5.942125183014016e-7},
                                   {7.0001, 28.7501, -4.89310716506435e-7},
                                   {7.0001, 29.0001, -4.027313895470574e-7},
                                   {7.0001, 29.2501, -3.313124249693815e-7},
                                   {7.0001, 29.5001, -2.724300614911842e-7},
                                   {7.0001, 29.7501, -2.239086534968868e-7},
                                   {7.2501, 0.0001, -4.986003528275857e-15},
                                   {7.2501, 0.2501, -1.426035136671192e-8},
                                   {7.2501, 0.5001, -1.392939281693591e-6},
                                   {7.2501, 0.7501, -0.00001808306893110494},
                                   {7.2501, 1.0001, -0.0001030083173618145},
                                   {7.2501, 1.2501, -0.0003740271378080411},
                                   {7.2501, 1.5001, -0.001022036761663821},
                                   {7.2501, 1.7501, -0.00229596200798232},
                                   {7.2501, 2.0001, -0.004469816411314013},
                                   {7.2501, 2.2501, -0.00780170849934077},
                                   {7.2501, 2.5001, -0.01249464511934055},
                                   {7.2501, 2.7501, -0.01866637448074798},
                                   {7.2501, 3.0001, -0.02633209220397561},
                                   {7.2501, 3.2501, -0.03540071785872703},
                                   {7.2501, 3.5001, -0.04568316153808411},
                                   {7.2501, 3.7501, -0.05690965810571877},
                                   {7.2501, 4.0001, -0.06875273833850564},
                                   {7.2501, 4.2501, -0.0808525189919349},
                                   {7.2501, 4.5001, -0.0928414993452},
                                   {7.2501, 4.7501, -0.1043667506159507},
                                   {7.2501, 5.0001, -0.1151081251663093},
                                   {7.2501, 5.2501, -0.1247917932702531},
                                   {7.2501, 5.5001, -0.1331989789439322},
                                   {7.2501, 5.7501, -0.1401701896398939},
                                   {7.2501, 6.0001, -0.1456055180008256},
                                   {7.2501, 6.2501, -0.1494617526486975},
                                   {7.2501, 6.5001, -0.1517470920060458},
                                   {7.2501, 6.7501, -0.1525142356129688},
                                   {7.2501, 7.0001, -0.1518525554365105},
                                   {7.2501, 7.2501, -0.1498799463081425},
                                   {7.2501, 7.5001, -0.1467348369088391},
                                   {7.2501, 7.7501, -0.1425687235097801},
                                   {7.2501, 8.0001, -0.1375394769402534},
                                   {7.2501, 8.2501, -0.1318055746182131},
                                   {7.2501, 8.5001, -0.1255213268728715},
                                   {7.2501, 8.7501, -0.1188331011000179},
                                   {7.2501, 9.0001, -0.1118764979603914},
                                   {7.2501, 9.2501, -0.1047743993615905},
                                   {7.2501, 9.5001, -0.0976357863259184},
                                   {7.2501, 9.7501, -0.0905552137909378},
                                   {7.2501, 10.0001, -0.0836128266690375},
                                   {7.2501, 10.2501, -0.07687480501015809},
                                   {7.2501, 10.5001, -0.07039413401042554},
                                   {7.2501, 10.7501, -0.06421160531394539},
                                   {7.2501, 11.0001, -0.05835696828360416},
                                   {7.2501, 11.2501, -0.05285016266858022},
                                   {7.2501, 11.5001, -0.0477025766253696},
                                   {7.2501, 11.7501, -0.04291828583060417},
                                   {7.2501, 12.0001, -0.03849524011750072},
                                   {7.2501, 12.2501, -0.0344263734816857},
                                   {7.2501, 12.5001, -0.03070062135970729},
                                   {7.2501, 12.7501, -0.02730383579347664},
                                   {7.2501, 13.0001, -0.02421959452495464},
                                   {7.2501, 13.2501, -0.02142990432563698},
                                   {7.2501, 13.5001, -0.01891580208543228},
                                   {7.2501, 13.7501, -0.0166578595058799},
                                   {7.2501, 14.0001, -0.01463659880424265},
                                   {7.2501, 14.2501, -0.01283282777256234},
                                   {7.2501, 14.5001, -0.01122790297345244},
                                   {7.2501, 14.7501, -0.00980392990329981},
                                   {7.2501, 15.0001, -0.00854390871046441},
                                   {7.2501, 15.2501, -0.007431833603389665},
                                   {7.2501, 15.5001, -0.006452753489782605},
                                   {7.2501, 15.7501, -0.005592800708859667},
                                   {7.2501, 16.0001, -0.004839193998191968},
                                   {7.2501, 16.2501, -0.004180221108907047},
                                   {7.2501, 16.5001, -0.003605205773217662},
                                   {7.2501, 16.7501, -0.003104463054482967},
                                   {7.2501, 17.0001, -0.002669246484322741},
                                   {7.2501, 17.2501, -0.002291689820967169},
                                   {7.2501, 17.5001, -0.001964745751541739},
                                   {7.2501, 17.7501, -0.001682123409003986},
                                   {7.2501, 18.0001, -0.001438226180498619},
                                   {7.2501, 18.2501, -0.001228090945024473},
                                   {7.2501, 18.5001, -0.001047329590570088},
                                   {7.2501, 18.7501, -0.000892073419750318},
                                   {7.2501, 19.0001, -0.0007589208536659592},
                                   {7.2501, 19.2501, -0.0006448886813740689},
                                   {7.2501, 19.5001, -0.0005473669722908517},
                                   {7.2501, 19.7501, -0.0004640776665937512},
                                   {7.2501, 20.0001, -0.0003930367801126555},
                                   {7.2501, 20.2501, -0.0003325201015411833},
                                   {7.2501, 20.5001, -0.0002810322176874559},
                                   {7.2501, 20.7501, -0.0002372786739410483},
                                   {7.2501, 21.0001, -0.0002001410595597148},
                                   {7.2501, 21.2501, -0.000168654798534863},
                                   {7.2501, 21.5001, -0.0001419894247681958},
                                   {7.2501, 21.7501, -0.0001194311234734106},
                                   {7.2501, 22.0001, -0.0001003673277648491},
                                   {7.2501, 22.2501, -0.0000842731692050824},
                                   {7.2501, 22.5001, -0.0000706995927576971},
                                   {7.2501, 22.7501, -0.0000592629594102052},
                                   {7.2501, 23.0001, -0.00004963597312695772},
                                   {7.2501, 23.2501, -0.000041539782323125},
                                   {7.2501, 23.5001, -0.00003473711938494013},
                                   {7.2501, 23.7501, -0.0000290263546533193},
                                   {7.2501, 24.0001, -0.00002423635356440759},
                                   {7.2501, 24.2501, -0.0000202220371861747},
                                   {7.2501, 24.5001, -0.00001686055713553603},
                                   {7.2501, 24.7501, -0.00001404800577218432},
                                   {7.2501, 25.0001, -0.00001169659163755753},
                                   {7.2501, 25.2501, -9.73221835496467e-6},
                                   {7.2501, 25.5001, -8.09241265967336e-6},
                                   {7.2501, 25.7501, -6.724553925991495e-6},
                                   {7.2501, 26.0001, -5.584363549097015e-6},
                                   {7.2501, 26.2501, -4.634617873549537e-6},
                                   {7.2501, 26.5001, -3.84405309072104e-6},
                                   {7.2501, 26.7501, -3.186434706495349e-6},
                                   {7.2501, 27.0001, -2.639767859971032e-6},
                                   {7.2501, 27.2501, -2.185628002912561e-6},
                                   {7.2501, 27.5001, -1.808594274974378e-6},
                                   {7.2501, 27.7501, -1.49577037482271e-6},
                                   {7.2501, 28.0001, -1.236379872461404e-6},
                                   {7.2501, 28.2501, -1.021424770226747e-6},
                                   {7.2501, 28.5001, -8.43397732612709e-7},
                                   {7.2501, 28.7501, -6.960397986537749e-7},
                                   {7.2501, 29.0001, -5.74136592275778e-7},
                                   {7.2501, 29.2501, -4.733470801810017e-7},
                                   {7.2501, 29.5001, -3.900598151301187e-7},
                                   {7.2501, 29.7501, -3.212723641096654e-7},
                                   {7.5001, 0.0001, -5.095339159511843e-15},
                                   {7.5001, 0.2501, -6.068627787839286e-9},
                                   {7.5001, 0.5001, -7.057761427857539e-7},
                                   {7.5001, 0.7501, -0.00001014804473480705},
                                   {7.5001, 1.0001, -0.00006215686810281833},
                                   {7.5001, 1.2501, -0.0002387647818967284},
                                   {7.5001, 1.5001, -0.000683153673906115},
                                   {7.5001, 1.7501, -0.001595579155385908},
                                   {7.5001, 2.0001, -0.003212830134648844},
                                   {7.5001, 2.2501, -0.005777069676345161},
                                   {7.5001, 2.5001, -0.00950168997308021},
                                   {7.5001, 2.7501, -0.01454101678271328},
                                   {7.5001, 3.0001, -0.02096855888770742},
                                   {7.5001, 3.2501, -0.02876602596478894},
                                   {7.5001, 3.5001, -0.03782316959355214},
                                   {7.5001, 3.7501, -0.04794693690090069},
                                   {7.5001, 4.0001, -0.05887752519760763},
                                   {7.5001, 4.2501, -0.07030860824642994},
                                   {7.5001, 4.5001, -0.0819091255963052},
                                   {7.5001, 4.7501, -0.0933444284101028},
                                   {7.5001, 5.0001, -0.1042951185526318},
                                   {7.5001, 5.2501, -0.1144724935779523},
                                   {7.5001, 5.5001, -0.1236300437865676},
                                   {7.5001, 5.7501, -0.1315708945575072},
                                   {7.5001, 6.0001, -0.1381514281886781},
                                   {7.5001, 6.2501, -0.143281552845172},
                                   {7.5001, 6.5001, -0.1469222218260676},
                                   {7.5001, 6.7501, -0.149080860490617},
                                   {7.5001, 7.0001, -0.1498053495599777},
                                   {7.5001, 7.2501, -0.1491771606034441},
                                   {7.5001, 7.5001, -0.1473041588763626},
                                   {7.5001, 7.7501, -0.1443134940571349},
                                   {7.5001, 8.0001, -0.140344901513641},
                                   {7.5001, 8.2501, -0.1355446432232136},
                                   {7.5001, 8.5001, -0.1300602334446001},
                                   {7.5001, 8.7501, -0.1240360225737166},
                                   {7.5001, 9.0001, -0.1176096544726573},
                                   {7.5001, 9.2501, -0.1109093678505679},
                                   {7.5001, 9.5001, -0.1040520800459826},
                                   {7.5001, 9.7501, -0.0971421703401074},
                                   {7.5001, 10.0001, -0.0902708679851997},
                                   {7.5001, 10.2501, -0.0835161456617987},
                                   {7.5001, 10.5001, -0.07694302035400314},
                                   {7.5001, 10.7501, -0.07060416908263045},
                                   {7.5001, 11.0001, -0.06454077519872015},
                                   {7.5001, 11.2501, -0.05878353087859081},
                                   {7.5001, 11.5001, -0.0533537321670652},
                                   {7.5001, 11.7501, -0.04826441368973521},
                                   {7.5001, 12.0001, -0.04352148048904111},
                                   {7.5001, 12.2501, -0.03912480398468623},
                                   {7.5001, 12.5001, -0.03506925760186789},
                                   {7.5001, 12.7501, -0.03134567504230233},
                                   {7.5001, 13.0001, -0.02794172046545813},
                                   {7.5001, 13.2501, -0.02484266503247968},
                                   {7.5001, 13.5001, -0.0220320684155269},
                                   {7.5001, 13.7501, -0.01949236708901344},
                                   {7.5001, 14.0001, -0.017205373608701},
                                   {7.5001, 14.2501, -0.0151526927667866},
                                   {7.5001, 14.5001, -0.01331606160111591},
                                   {7.5001, 14.7501, -0.01167762084310061},
                                   {7.5001, 15.0001, -0.01022012561100254},
                                   {7.5001, 15.2501, -0.00892710308107766},
                                   {7.5001, 15.5001, -0.007782964574997397},
                                   {7.5001, 15.7501, -0.00677307905264358},
                                   {7.5001, 16.0001, -0.005883814448339484},
                                   {7.5001, 16.2501, -0.005102552679129618},
                                   {7.5001, 16.5001, -0.004417683519996578},
                                   {7.5001, 16.7501, -0.003818581909048294},
                                   {7.5001, 17.0001, -0.003295572635037595},
                                   {7.5001, 17.2501, -0.002839885783689833},
                                   {7.5001, 17.5001, -0.002443605787137284},
                                   {7.5001, 17.7501, -0.002099616437468363},
                                   {7.5001, 18.0001, -0.00180154379324413},
                                   {7.5001, 18.2501, -0.001543698526837457},
                                   {7.5001, 18.5001, -0.001321018929002696},
                                   {7.5001, 18.7501, -0.001129015502434435},
                                   {7.5001, 19.0001, -0.000963717834726072},
                                   {7.5001, 19.2501, -0.000821624239165019},
                                   {7.5001, 19.5001, -0.0006996544850868302},
                                   {7.5001, 19.7501, -0.0005951058039378063},
                                   {7.5001, 20.0001, -0.0005056122487768972},
                                   {7.5001, 20.2501, -0.0004291073999183271},
                                   {7.5001, 20.5001, -0.0003637903442936845},
                                   {7.5001, 20.7501, -0.0003080948077304082},
                                   {7.5001, 21.0001, -0.0002606612848671561},
                                   {7.5001, 21.2501, -0.0002203119883501867},
                                   {7.5001, 21.5001, -0.0001860284250922142},
                                   {7.5001, 21.7501, -0.0001569314008403624},
                                   {7.5001, 22.0001, -0.0001322632534844891},
                                   {7.5001, 22.2501, -0.0001113721190849528},
                                   {7.5001, 22.5001, -0.0000936980413788749},
                                   {7.5001, 22.7501, -0.00007876074460427108},
                                   {7.5001, 23.0001, -0.00006614890010387614},
                                   {7.5001, 23.2501, -0.00005551072872672491},
                                   {7.5001, 23.5001, -0.00004654579305512571},
                                   {7.5001, 23.7501, -0.00003899784557512287},
                                   {7.5001, 24.0001, -0.00003264861079770276},
                                   {7.5001, 24.2501, -0.00002731239081825354},
                                   {7.5001, 24.5001, -0.00002283139472649764},
                                   {7.5001, 24.7501, -0.00001907170255081449},
                                   {7.5001, 25.0001, -0.00001591978398123638},
                                   {7.5001, 25.2501, -0.00001327950093677149},
                                   {7.5001, 25.5001, -0.00001106953112098454},
                                   {7.5001, 25.7501, -9.22115705853344e-6},
                                   {7.5001, 26.0001, -7.676371751083844e-6},
                                   {7.5001, 26.2501, -6.386258069139757e-6},
                                   {7.5001, 26.5001, -5.309604348136004e-6},
                                   {7.5001, 26.7501, -4.411723427336327e-6},
                                   {7.5001, 27.0001, -3.663446604857887e-6},
                                   {7.5001, 27.2501, -3.040267727732202e-6},
                                   {7.5001, 27.5001, -2.521615937510464e-6},
                                   {7.5001, 27.7501, -2.0902384929157e-6},
                                   {7.5001, 28.0001, -1.731677632490451e-6},
                                   {7.5001, 28.2501, -1.433827660468205e-6},
                                   {7.5001, 28.5001, -1.18656037373767e-6},
                                   {7.5001, 28.7501, -9.81408629378248e-7},
                                   {7.5001, 29.0001, -8.11299310522823e-7},
                                   {7.5001, 29.2501, -6.703282101326677e-7},
                                   {7.5001, 29.5001, -5.535704418366833e-7},
                                   {7.5001, 29.7501, -4.56920925943105e-7},
                                   {7.7501, 0.0001, -5.201474119873138e-15},
                                   {7.7501, 0.2501, -2.561712286905864e-9},
                                   {7.7501, 0.5001, -3.546991013872741e-7},
                                   {7.7501, 0.7501, -5.648549903138403e-6},
                                   {7.7501, 1.0001, -0.00003719972578859752},
                                   {7.7501, 1.2501, -0.0001511689696364204},
                                   {7.7501, 1.5001, -0.0004528854165332046},
                                   {7.7501, 1.7501, -0.00109972434022582},
                                   {7.7501, 2.0001, -0.002290299122857418},
                                   {7.7501, 2.2501, -0.004242550096259166},
                                   {7.7501, 2.5001, -0.007165968144978761},
                                   {7.7501, 2.7501, -0.01123369571620528},
                                   {7.7501, 3.0001, -0.01655927052039801},
                                   {7.7501, 3.2501, -0.0231810803204255},
                                   {7.7501, 3.5001, -0.03105578694113269},
                                   {7.7501, 3.7501, -0.04006043553299699},
                                   {7.7501, 4.0001, -0.05000186994008468},
                                   {7.7501, 4.2501, -0.06063145760987952},
                                   {7.7501, 4.5001, -0.07166292862722784},
                                   {7.7501, 4.7501, -0.0827912513098274},
                                   {7.7501, 5.0001, -0.0937107901935412},
                                   {7.7501, 5.2501, -0.1041314208211439},
                                   {7.7501, 5.5001, -0.1137917298919768},
                                   {7.7501, 5.7501, -0.1224688528584305},
                                   {7.7501, 6.0001, -0.12998485967187},
                                   {7.7501, 6.2501, -0.1362098768624609},
                                   {7.7501, 6.5001, -0.1410623277714401},
                                   {7.7501, 6.7501, -0.1445067889216563},
                                   {7.7501, 7.0001, -0.1465500109021429},
                                   {7.7501, 7.2501, -0.1472356507922276},
                                   {7.7501, 7.5001, -0.1466382243188074},
                                   {7.7501, 7.7501, -0.1448567227226822},
                                   {7.7501, 8.0001, -0.1420082628584093},
                                   {7.7501, 8.2501, -0.1382220582495929},
                                   {7.7501, 8.5001, -0.1336339202724053},
                                   {7.7501, 8.7501, -0.128381426864195},
                                   {7.7501, 9.0001, -0.1225998338901275},
                                   {7.7501, 9.2501, -0.1164187528550234},
                                   {7.7501, 9.5001, -0.1099595782397139},
                                   {7.7501, 9.7501, -0.103333617821377},
                                   {7.7501, 10.0001, -0.0966408588570525},
                                   {7.7501, 10.2501, -0.089969290642005},
                                   {7.7501, 10.5001, -0.0833946982640584},
                                   {7.7501, 10.7501, -0.07698084193988785},
                                   {7.7501, 11.0001, -0.0707799398156303},
                                   {7.7501, 11.2501, -0.0648333783667524},
                                   {7.7501, 11.5001, -0.05917258253973872},
                                   {7.7501, 11.7501, -0.05381998672068065},
                                   {7.7501, 12.0001, -0.04879005684771158},
                                   {7.7501, 12.2501, -0.04409032301970762},
                                   {7.7501, 12.5001, -0.03972239044711984},
                                   {7.7501, 12.7501, -0.03568290431493312},
                                   {7.7501, 13.0001, -0.03196445095175534},
                                   {7.7501, 13.2501, -0.02855638356796488},
                                   {7.7501, 13.5001, -0.0254455657419776},
                                   {7.7501, 13.7501, -0.02261702984046056},
                                   {7.7501, 14.0001, -0.02005455072676784},
                                   {7.7501, 14.2501, -0.01774113752971694},
                                   {7.7501, 14.5001, -0.01565944800783875},
                                   {7.7501, 14.7501, -0.01379213124976475},
                                   {7.7501, 15.0001, -0.01212210519366713},
                                   {7.7501, 15.2501, -0.01063277581551185},
                                   {7.7501, 15.5001, -0.00930820490686023},
                                   {7.7501, 15.7501, -0.00813323320822437},
                                   {7.7501, 16.0001, -0.007093565344003022},
                                   {7.7501, 16.2501, -0.006175822570736679},
                                   {7.7501, 16.5001, -0.005367568843794786},
                                   {7.7501, 16.7501, -0.004657315162419774},
                                   {7.7501, 17.0001, -0.0040345065957848},
                                   {7.7501, 17.2501, -0.00348949584351227},
                                   {7.7501, 17.5001, -0.00301350665768499},
                                   {7.7501, 17.7501, -0.002598589959992506},
                                   {7.7501, 18.0001, -0.002237575033844348},
                                   {7.7501, 18.2501, -0.001924017760663649},
                                   {7.7501, 18.5001, -0.001652147503473829},
                                   {7.7501, 18.7501, -0.001416813918901094},
                                   {7.7501, 19.0001, -0.00121343469916652},
                                   {7.7501, 19.2501, -0.001037945005988654},
                                   {7.7501, 19.5001, -0.000886749155453595},
                                   {7.7501, 19.7501, -0.0007566749434139039},
                                   {7.7501, 20.0001, -0.0006449308613081829},
                                   {7.7501, 20.2501, -0.0005490663389303373},
                                   {7.7501, 20.5001, -0.0004669350602296832},
                                   {7.7501, 20.7501, -0.0003966613274978262},
                                   {7.7501, 21.0001, -0.0003366093953493163},
                                   {7.7501, 21.2501, -0.0002853556560553897},
                                   {7.7501, 21.5001, -0.000241663529650038},
                                   {7.7501, 21.7501, -0.0002044608936810788},
                                   {7.7501, 22.0001, -0.0001728198766811652},
                                   {7.7501, 22.2501, -0.0001459388347934519},
                                   {7.7501, 22.5001, -0.0001231263311464705},
                                   {7.7501, 22.7501, -0.0001037869413873946},
                                   {7.7501, 23.0001, -0.000087408715296925},
                                   {7.7501, 23.2501, -0.00007355213283488665},
                                   {7.7501, 23.5001, -0.00006184040266213835},
                                   {7.7501, 23.7501, -0.00005195096163684988},
                                   {7.7501, 24.0001, -0.00004360804458497404},
                                   {7.7501, 24.2501, -0.00003657620448051323},
                                   {7.7501, 24.5001, -0.00003065467380210034},
                                   {7.7501, 24.7501, -0.00002567246808285857},
                                   {7.7501, 25.0001, -0.00002148414241660745},
                                   {7.7501, 25.2501, -0.00001796612084320004},
                                   {7.7501, 25.5001, -0.00001501352706039517},
                                   {7.7501, 25.7501, -0.00001253745277662035},
                                   {7.7501, 26.0001, -0.00001046260722582888},
                                   {7.7501, 26.2501, -8.72529792508973e-6},
                                   {7.7501, 26.5001, -7.27169869129655e-6},
                                   {7.7501, 26.7501, -6.056366276874179e-6},
                                   {7.7501, 27.0001, -5.040971772063902e-6},
                                   {7.7501, 27.2501, -4.193217192680417e-6},
                                   {7.7501, 27.5001, -3.485911467837253e-6},
                                   {7.7501, 27.7501, -2.896183402753865e-6},
                                   {7.7501, 28.0001, -2.404812157213364e-6},
                                   {7.7501, 28.2501, -1.995658388792235e-6},
                                   {7.7501, 28.5001, -1.655181497865072e-6},
                                   {7.7501, 28.7501, -1.372030412507669e-6},
                                   {7.7501, 29.0001, -1.136697097201645e-6},
                                   {7.7501, 29.2501, -9.41223488557774e-7},
                                   {7.7501, 29.5001, -7.789538804556175e-7},
                                   {7.7501, 29.7501, -6.443259239096819e-7},
                                   {8.0001, 0.0001, -5.304602346061852e-15},
                                   {8.0001, 0.2501, -1.072904519750399e-9},
                                   {8.0001, 0.5001, -1.768577646220432e-7},
                                   {8.0001, 0.7501, -3.119244911537047e-6},
                                   {8.0001, 1.0001, -0.00002208708463753895},
                                   {8.0001, 1.2501, -0.0000949500279334497},
                                   {8.0001, 1.5001, -0.0002978458871813512},
                                   {8.0001, 1.7501, -0.0007519290521982992},
                                   {8.0001, 2.0001, -0.001619642221222953},
                                   {8.0001, 2.2501, -0.003090752559781312},
                                   {8.0001, 2.5001, -0.005361208067750338},
                                   {8.0001, 2.7501, -0.00860915568327014},
                                   {8.0001, 3.0001, -0.01297240217139539},
                                   {8.0001, 3.2501, -0.01853065985812083},
                                   {8.0001, 3.5001, -0.02529458834092746},
                                   {8.0001, 3.7501, -0.03320230019220554},
                                   {8.0001, 4.0001, -0.04212288151688921},
                                   {8.0001, 4.2501, -0.05186569709391488},
                                   {8.0001, 4.5001, -0.06219381972123395},
                                   {8.0001, 4.7501, -0.07283979996718051},
                                   {8.0001, 5.0001, -0.083522102444088},
                                   {8.0001, 5.2501, -0.093960797605455},
                                   {8.0001, 5.5001, -0.1038914404810648},
                                   {8.0001, 5.7501, -0.1130764304078217},
                                   {8.0001, 6.0001, -0.1213134859399943},
                                   {8.0001, 6.2501, -0.1284411598308721},
                                   {8.0001, 6.5001, -0.134341546804244},
                                   {8.0001, 6.7501, -0.1389404986424125},
                                   {8.0001, 7.0001, -0.1422057609607237},
                                   {8.0001, 7.2501, -0.1441434923738156},
                                   {8.0001, 7.5001, -0.1447936301954472},
                                   {8.0001, 7.7501, -0.1442245384387755},
                                   {8.0001, 8.0001, -0.1425273241230103},
                                   {8.0001, 8.2501, -0.1398101458244823},
                                   {8.0001, 8.5001, -0.1361927714368041},
                                   {8.0001, 8.7501, -0.1318015758772098},
                                   {8.0001, 9.0001, -0.1267651079949002},
                                   {8.0001, 9.2501, -0.1212103017548058},
                                   {8.0001, 9.5001, -0.1152593612428916},
                                   {8.0001, 9.7501, -0.1090273125901174},
                                   {8.0001, 10.0001, -0.1026201882804986},
                                   {8.0001, 10.2501, -0.0961337897693169},
                                   {8.0001, 10.5001, -0.0896529618849286},
                                   {8.0001, 10.7501, -0.0832513059816726},
                                   {8.0001, 11.0001, -0.07699125708685374},
                                   {8.0001, 11.2501, -0.07092445222887522},
                                   {8.0001, 11.5001, -0.06509232173631285},
                                   {8.0001, 11.7501, -0.05952684168053017},
                                   {8.0001, 12.0001, -0.05425139306214062},
                                   {8.0001, 12.2501, -0.04928168122218386},
                                   {8.0001, 12.5001, -0.04462667683480837},
                                   {8.0001, 12.7501, -0.04028954737290696},
                                   {8.0001, 13.0001, -0.0362685548993007},
                                   {8.0001, 13.2501, -0.03255790227853838},
                                   {8.0001, 13.5001, -0.02914851535310859},
                                   {8.0001, 13.7501, -0.02602875326218524},
                                   {8.0001, 14.0001, -0.02318504292070193},
                                   {8.0001, 14.2501, -0.02060243676977846},
                                   {8.0001, 14.5001, -0.01826509532297976},
                                   {8.0001, 14.7501, -0.01615669784372434},
                                   {8.0001, 15.0001, -0.01426078577876457},
                                   {8.0001, 15.2501, -0.01256104442200354},
                                   {8.0001, 15.5001, -0.01104152876922132},
                                   {8.0001, 15.7501, -0.00968683971882563},
                                   {8.0001, 16.0001, -0.00848225674050541},
                                   {8.0001, 16.2501, -0.007413832928716961},
                                   {8.0001, 16.5001, -0.00646845802930436},
                                   {8.0001, 16.7501, -0.005633894615509185},
                                   {8.0001, 17.0001, -0.004898792127155299},
                                   {8.0001, 17.2501, -0.004252683000312784},
                                   {8.0001, 17.5001, -0.003685964624821598},
                                   {8.0001, 17.7501, -0.003189870389207937},
                                   {8.0001, 18.0001, -0.002756432617981122},
                                   {8.0001, 18.2501, -0.002378439782717727},
                                   {8.0001, 18.5001, -0.00204938998047992},
                                   {8.0001, 18.7501, -0.001763442323423915},
                                   {8.0001, 19.0001, -0.001515367572585352},
                                   {8.0001, 19.2501, -0.001300499076085775},
                                   {8.0001, 19.5001, -0.001114684835715352},
                                   {8.0001, 19.7501, -0.000954241323669687},
                                   {8.0001, 20.0001, -0.000815909500390105},
                                   {8.0001, 20.2501, -0.0006968133419898681},
                                   {8.0001, 20.5001, -0.0005944210685834438},
                                   {8.0001, 20.7501, -0.0005065091699533644},
                                   {8.0001, 21.0001, -0.0004311292494935406},
                                   {8.0001, 21.2501, -0.0003665776485427746},
                                   {8.0001, 21.5001, -0.0003113677685659689},
                                   {8.0001, 21.7501, -0.0002642049758854501},
                                   {8.0001, 22.0001, -0.0002239639507837956},
                                   {8.0001, 22.2501, -0.000189668328003322},
                                   {8.0001, 22.5001, -0.0001604724673952196},
                                   {8.0001, 22.7501, -0.0001356451903770308},
                                   {8.0001, 23.0001, -0.0001145553187923233},
                                   {8.0001, 23.2501, -0.0000966588567619613},
                                   {8.0001, 23.5001, -0.000081487662363751},
                                   {8.0001, 23.7501, -0.0000686394638096775},
                                   {8.0001, 24.0001, -0.00005776908366454185},
                                   {8.0001, 24.2501, -0.00004858074413065596},
                                   {8.0001, 24.5001, -0.00004082133616596842},
                                   {8.0001, 24.7501, -0.00003427454494060125},
                                   {8.0001, 25.0001, -0.00002875573366715277},
                                   {8.0001, 25.2501, -0.00002410749701485512},
                                   {8.0001, 25.5001, -0.00002019580403235854},
                                   {8.0001, 25.7501, -0.00001690665868973327},
                                   {8.0001, 26.0001, -0.00001414321376683003},
                                   {8.0001, 26.2501, -0.00001182328084431548},
                                   {8.0001, 26.5001, -9.87718559459151e-6},
                                   {8.0001, 26.7501, -8.24592343444189e-6},
                                   {8.0001, 27.0001, -6.879575911091889e-6},
                                   {8.0001, 27.2501, -5.735952976485146e-6},
                                   {8.0001, 27.5001, -4.77943059335115e-6},
                                   {8.0001, 27.7501, -3.979956945944039e-6},
                                   {8.0001, 28.0001, -3.312203934154174e-6},
                                   {8.0001, 28.2501, -2.75484364802093e-6},
                                   {8.0001, 28.5001, -2.289932185712428e-6},
                                   {8.0001, 28.7501, -1.902385525615809e-6},
                                   {8.0001, 29.0001, -1.579534224358093e-6},
                                   {8.0001, 29.2501, -1.310745517381116e-6},
                                   {8.0001, 29.5001, -1.087102974972792e-6},
                                   {8.0001, 29.7501, -9.01135240029295e-7},
                                   {8.2501, 0.0001, -5.404900313314192e-15},
                                   {8.2501, 0.2501, -4.45951220804881e-10},
                                   {8.2501, 0.5001, -8.75114236785909e-8},
                                   {8.2501, 0.7501, -1.709331862830674e-6},
                                   {8.2501, 1.0001, -0.00001301344366958705},
                                   {8.2501, 1.2501, -0.00005918004074179368},
                                   {8.2501, 1.5001, -0.0001943731690542128},
                                   {8.2501, 1.7501, -0.0005101594100984909},
                                   {8.2501, 2.0001, -0.001136520318120706},
                                   {8.2501, 2.2501, -0.002234232999494586},
                                   {8.2501, 2.5001, -0.00397991288087645},
                                   {8.2501, 2.7501, -0.006546634134633468},
                                   {8.2501, 3.0001, -0.01008360880313081},
                                   {8.2501, 3.2501, -0.01469811026363323},
                                   {8.2501, 3.5001, -0.02044199754223687},
                                   {8.2501, 3.7501, -0.0273041546430406},
                                   {8.2501, 4.0001, -0.03520914982921603},
                                   {8.2501, 4.2501, -0.04402159717772952},
                                   {8.2501, 4.5001, -0.05355513630936003},
                                   {8.2501, 4.7501, -0.0635846424166703},
                                   {8.2501, 5.0001, -0.07386020382882169},
                                   {8.2501, 5.2501, -0.084121504390776},
                                   {8.2501, 5.5001, -0.0941114636608461},
                                   {8.2501, 5.7501, -0.1035882646317809},
                                   {8.2501, 6.0001, -0.1123351915172777},
                                   {8.2501, 6.2501, -0.1201679761653295},
                                   {8.2501, 6.5001, -0.1269395895660439},
                                   {8.2501, 6.7501, -0.132542603533881},
                                   {8.2501, 7.0001, -0.1369093837542006},
                                   {8.2501, 7.2501, -0.1400104614989047},
                                   {8.2501, 7.5001, -0.1418514735905836},
                                   {8.2501, 7.7501, -0.1424690667079247},
                                   {8.2501, 8.0001, -0.1419261415573859},
                                   {8.2501, 8.2501, -0.140306773134834},
                                   {8.2501, 8.5001, -0.13771109268858},
                                   {8.2501, 8.7501, -0.1342503612538853},
                                   {8.2501, 9.0001, -0.1300424085923895},
                                   {8.2501, 9.2501, -0.1252075585624044},
                                   {8.2501, 9.5001, -0.1198651147133453},
                                   {8.2501, 9.7501, -0.1141304395875465},
                                   {8.2501, 10.0001, -0.1081126283743426},
                                   {8.2501, 10.2501, -0.1019127521402698},
                                   {8.2501, 10.5001, -0.0956226273758041},
                                   {8.2501, 10.7501, -0.089324056300821},
                                   {8.2501, 11.0001, -0.0830884753574255},
                                   {8.2501, 11.2501, -0.07697694663784481},
                                   {8.2501, 11.5001, -0.07104042771374775},
                                   {8.2501, 11.7501, -0.06532025858618611},
                                   {8.2501, 12.0001, -0.05984880949414465},
                                   {8.2501, 12.2501, -0.0546502394486732},
                                   {8.2501, 12.5001, -0.04974132205945093},
                                   {8.2501, 12.7501, -0.04513230206478408},
                                   {8.2501, 13.0001, -0.04082775264147631},
                                   {8.2501, 13.2501, -0.03682740982627733},
                                   {8.2501, 13.5001, -0.0331269660722143},
                                   {8.2501, 13.7501, -0.02971881000173754},
                                   {8.2501, 14.0001, -0.02659270376599245},
                                   {8.2501, 14.2501, -0.02373639307640797},
                                   {8.2501, 14.5001, -0.02113614797040282},
                                   {8.2501, 14.7501, -0.01877723475610413},
                                   {8.2501, 15.0001, -0.01664432141246049},
                                   {8.2501, 15.2501, -0.0147218200681937},
                                   {8.2501, 15.5001, -0.01299417111460413},
                                   {8.2501, 15.7501, -0.01144607409066234},
                                   {8.2501, 16.0001, -0.01006267077748415},
                                   {8.2501, 16.2501, -0.00882968601113791},
                                   {8.2501, 16.5001, -0.00773353161938584},
                                   {8.2501, 16.7501, -0.006761378654347906},
                                   {8.2501, 17.0001, -0.00590120276746699},
                                   {8.2501, 17.2501, -0.005141807187448979},
                                   {8.2501, 17.5001, -0.004472827342050085},
                                   {8.2501, 17.7501, -0.00388472073136754},
                                   {8.2501, 18.0001, -0.003368745229650583},
                                   {8.2501, 18.2501, -0.002916928576535144},
                                   {8.2501, 18.5001, -0.002522031425547945},
                                   {8.2501, 18.7501, -0.002177505953421583},
                                   {8.2501, 19.0001, -0.001877451701611792},
                                   {8.2501, 19.2501, -0.0016165700229899},
                                   {8.2501, 19.5001, -0.001390118242169129},
                                   {8.2501, 19.7501, -0.001193864406432},
                                   {8.2501, 20.0001, -0.001024043304122303},
                                   {8.2501, 20.2501, -0.000877314256503192},
                                   {8.2501, 20.5001, -0.0007507210450049834},
                                   {8.2501, 20.7501, -0.000641654215877619},
                                   {8.2501, 21.0001, -0.0005478159058723421},
                                   {8.2501, 21.2501, -0.0004671872531071542},
                                   {8.2501, 21.5001, -0.0003979983942406112},
                                   {8.2501, 21.7501, -0.0003387010001694752},
                                   {8.2501, 22.0001, -0.0002879432655469109},
                                   {8.2501, 22.2501, -0.0002445472405610276},
                                   {8.2501, 22.5001, -0.0002074883748969437},
                                   {8.2501, 22.7501, -0.0001758771321107234},
                                   {8.2501, 23.0001, -0.000148942526446664},
                                   {8.2501, 23.2501, -0.0001260174322889704},
                                   {8.2501, 23.5001, -0.0001065255179811702},
                                   {8.2501, 23.7501, -0.0000899696598501235},
                                   {8.2501, 24.0001, -0.00007592169825068471},
                                   {8.2501, 24.2501, -0.00006401340473667627},
                                   {8.2501, 24.5001, -0.00005392853760358397},
                                   {8.2501, 24.7501, -0.0000453958716687832},
                                   {8.2501, 25.0001, -0.00003818309696432726},
                                   {8.2501, 25.2501, -0.00003209148978929945},
                                   {8.2501, 25.5001, -0.00002695126813248502},
                                   {8.2501, 25.7501, -0.00002261755170638485},
                                   {8.2501, 26.0001, -0.00001896685464255529},
                                   {8.2501, 26.2501, -0.00001589404622843039},
                                   {8.2501, 26.5001, -0.00001330972188390056},
                                   {8.2501, 26.7501, -0.00001113793286775429},
                                   {8.2501, 27.0001, -9.31422897009009e-6},
                                   {8.2501, 27.2501, -7.78397369847842e-6},
                                   {8.2501, 27.5001, -6.500896222572631e-6},
                                   {8.2501, 27.7501, -5.425848629244362e-6},
                                   {8.2501, 28.0001, -4.525740887043507e-6},
                                   {8.2501, 28.2501, -3.772629355873753e-6},
                                   {8.2501, 28.5001, -3.142937737166125e-6},
                                   {8.2501, 28.7501, -2.616792073442101e-6},
                                   {8.2501, 29.0001, -2.177453805194903e-6},
                                   {8.2501, 29.2501, -1.810837007478872e-6},
                                   {8.2501, 29.5001, -1.505097786915749e-6},
                                   {8.2501, 29.7501, -1.250285448653876e-6},
                                   {8.5001, 0.0001, -5.502529089316265e-15},
                                   {8.5001, 0.2501, -1.839959207015672e-10},
                                   {8.5001, 0.5001, -4.298146919860628e-8},
                                   {8.5001, 0.7501, -9.29753447723772e-7},
                                   {8.5001, 1.0001, -7.610302764693568e-6},
                                   {8.5001, 1.2501, -0.00003661038405578664},
                                   {8.5001, 1.5001, -0.0001258994973894861},
                                   {8.5001, 1.7501, -0.000343536449380337},
                                   {8.5001, 2.0001, -0.0007915324461764062},
                                   {8.5001, 2.2501, -0.001602957793362863},
                                   {8.5001, 2.5001, -0.002932312520498033},
                                   {8.5001, 2.7501, -0.004940809064833761},
                                   {8.5001, 3.0001, -0.007779130178484801},
                                   {8.5001, 3.2501, -0.01157041105344433},
                                   {8.5001, 3.5001, -0.01639581920179483},
                                   {8.5001, 3.7501, -0.02228440008442093},
                                   {8.5001, 4.0001, -0.02920803777809794},
                                   {8.5001, 4.2501, -0.03708161254317152},
                                   {8.5001, 4.5001, -0.04576782263764215},
                                   {8.5001, 4.7501, -0.05508572105595998},
                                   {8.5001, 5.0001, -0.06482180088510424},
                                   {8.5001, 5.2501, -0.07474241960129048},
                                   {8.5001, 5.5001, -0.0846064424353799},
                                   {8.5001, 5.7501, -0.0941771634885118},
                                   {8.5001, 6.0001, -0.1032327891793016},
                                   {8.5001, 6.2501, -0.1115750074706356},
                                   {8.5001, 6.5001, -0.1190353924554442},
                                   {8.5001, 6.7501, -0.1254795902688014},
                                   {8.5001, 7.0001, -0.1308093896351262},
                                   {8.5001, 7.2501, -0.1349628955612183},
                                   {8.5001, 7.5001, -0.137913099226505},
                                   {8.5001, 7.7501, -0.1396651755010405},
                                   {8.5001, 8.0001, -0.1402528479335979},
                                   {8.5001, 8.2501, -0.1397341463362288},
                                   {8.5001, 8.5001, -0.13818685096813},
                                   {8.5001, 8.7501, -0.1357038758845242},
                                   {8.5001, 9.0001, -0.132388797442103},
                                   {8.5001, 9.2501, -0.1283516863778079},
                                   {8.5001, 9.5001, -0.1237053563977485},
                                   {8.5001, 9.7501, -0.1185621009627526},
                                   {8.5001, 10.0001, -0.1130309542389872},
                                   {8.5001, 10.2501, -0.1072154826165252},
                                   {8.5001, 10.5001, -0.101212089876739},
                                   {8.5001, 10.7501, -0.0951088017164387},
                                   {8.5001, 11.0001, -0.0889844833592403},
                                   {8.5001, 11.2501, -0.0829084366961829},
                                   {8.5001, 11.5001, -0.07694032002282729},
                                   {8.5001, 11.7501, -0.07113033319875132},
                                   {8.5001, 12.0001, -0.06551961320773277},
                                   {8.5001, 12.2501, -0.06014078897330563},
                                   {8.5001, 12.5001, -0.05501864930218414},
                                   {8.5001, 12.7501, -0.05017088349874276},
                                   {8.5001, 13.0001, -0.04560886012258977},
                                   {8.5001, 13.2501, -0.04133841524195426},
                                   {8.5001, 13.5001, -0.0373606271415839},
                                   {8.5001, 13.7501, -0.03367255961796039},
                                   {8.5001, 14.0001, -0.03026796063802374},
                                   {8.5001, 14.2501, -0.02713790719877944},
                                   {8.5001, 14.5001, -0.02427139068981901},
                                   {8.5001, 14.7501, -0.02165583994254002},
                                   {8.5001, 15.0001, -0.0192775814823047},
                                   {8.5001, 15.2501, -0.01712223832977277},
                                   {8.5001, 15.5001, -0.01517507007981167},
                                   {8.5001, 15.7501, -0.01342125797880068},
                                   {8.5001, 16.0001, -0.011846139382044},
                                   {8.5001, 16.2501, -0.01043539635838946},
                                   {8.5001, 16.5001, -0.00917520337112812},
                                   {8.5001, 16.7501, -0.0080523389500214},
                                   {8.5001, 17.0001, -0.007054266120596269},
                                   {8.5001, 17.2501, -0.006169186109760561},
                                   {8.5001, 17.5001, -0.00538606953188083},
                                   {8.5001, 17.7501, -0.004694668902062544},
                                   {8.5001, 18.0001, -0.004085515943995827},
                                   {8.5001, 18.2501, -0.003549906774588739},
                                   {8.5001, 18.5001, -0.003079877669135672},
                                   {8.5001, 18.7501, -0.002668173748146318},
                                   {8.5001, 19.0001, -0.002308212586643909},
                                   {8.5001, 19.2501, -0.001994044432927289},
                                   {8.5001, 19.5001, -0.001720310438854491},
                                   {8.5001, 19.7501, -0.00148220004858196},
                                   {8.5001, 20.0001, -0.001275408467214391},
                                   {8.5001, 20.2501, -0.001096094933996032},
                                   {8.5001, 20.5001, -0.000940842354933695},
                                   {8.5001, 20.7501, -0.000806618705126343},
                                   {8.5001, 21.0001, -0.0006907404893985985},
                                   {8.5001, 21.2501, -0.0005908384488032797},
                                   {8.5001, 21.5001, -0.0005048256178684256},
                                   {8.5001, 21.7501, -0.0004308677708753716},
                                   {8.5001, 22.0001, -0.0003673562428355353},
                                   {8.5001, 22.2501, -0.0003128830701990228},
                                   {8.5001, 22.5001, -0.0002662183658579505},
                                   {8.5001, 22.7501, -0.0002262898210573641},
                                   {8.5001, 23.0001, -0.000192164211930644},
                                   {8.5001, 23.2501, -0.0001630307792424862},
                                   {8.5001, 23.5001, -0.000138186345425362},
                                   {8.5001, 23.7501, -0.0001170220321647498},
                                   {8.5001, 24.0001, -0.0000990114437972098},
                                   {8.5001, 24.2501, -0.0000837001859357905},
                                   {8.5001, 24.5001, -0.00007069659444723852},
                                   {8.5001, 24.7501, -0.00005966355669512509},
                                   {8.5001, 25.0001, -0.00005031131444169223},
                                   {8.5001, 25.2501, -0.00004239114565550893},
                                   {8.5001, 25.5001, -0.00003568983045451938},
                                   {8.5001, 25.7501, -0.00003002481433331949},
                                   {8.5001, 26.0001, -0.00002523998953498556},
                                   {8.5001, 26.2501, -0.00002120202282589265},
                                   {8.5001, 26.5001, -0.00001779716494302116},
                                   {8.5001, 26.7501, -0.00001492848355943823},
                                   {8.5001, 27.0001, -0.0000125134677278088},
                                   {8.5001, 27.2501, -0.00001048195740303826},
                                   {8.5001, 27.5001, -8.77435681511099e-6},
                                   {8.5001, 27.7501, -7.34009517294138e-6},
                                   {8.5001, 28.0001, -6.136302447557003e-6},
                                   {8.5001, 28.2501, -5.126671830954378e-6},
                                   {8.5001, 28.5001, -4.28048392139999e-6},
                                   {8.5001, 28.7501, -3.571770774480974e-6},
                                   {8.5001, 29.0001, -2.978600710283122e-6},
                                   {8.5001, 29.2501, -2.48246720908066e-6},
                                   {8.5001, 29.5001, -2.067767388607668e-6},
                                   {8.5001, 29.7501, -1.721357462009909e-6},
                                   {8.7501, 0.0001, -5.59763609323594e-15},
                                   {8.7501, 0.2501, -7.537342225686023e-11},
                                   {8.7501, 0.5001, -2.095883760695325e-8},
                                   {8.7501, 0.7501, -5.020742455725717e-7},
                                   {8.7501, 1.0001, -4.41837185135433e-6},
                                   {8.7501, 1.2501, -0.00002248419653820644},
                                   {8.7501, 1.5001, -0.0000809562177285905},
                                   {8.7501, 1.7501, -0.0002296537257389694},
                                   {8.7501, 2.0001, -0.0005472550539664333},
                                   {8.7501, 2.2501, -0.001141672373839101},
                                   {8.7501, 2.5001, -0.002144713694741493},
                                   {8.7501, 2.7501, -0.003701667061511282},
                                   {8.7501, 3.0001, -0.005957479093619233},
                                   {8.7501, 3.2501, -0.00904169561301028},
                                   {8.7501, 3.5001, -0.0130543205689124},
                                   {8.7501, 3.7501, -0.01805436596130183},
                                   {8.7501, 4.0001, -0.02405227545016349},
                                   {8.7501, 4.2501, -0.0310067580714665},
                                   {8.7501, 4.5001, -0.03882597843877843},
                                   {8.7501, 4.7501, -0.04737258483417141},
                                   {8.7501, 5.0001, -0.05647174621174891},
                                   {8.7501, 5.2501, -0.06592121273980611},
                                   {8.7501, 5.5001, -0.07550239170127936},
                                   {8.7501, 5.7501, -0.0849915105607398},
                                   {8.7501, 6.0001, -0.0941700879563083},
                                   {8.7501, 6.2501, -0.1028341195137736},
                                   {8.7501, 6.5001, -0.1108015820160372},
                                   {8.7501, 6.7501, -0.1179180463302268},
                                   {8.7501, 7.0001, -0.1240603529014833},
                                   {8.7501, 7.2501, -0.1291384358028735},
                                   {8.7501, 7.5001, -0.1330954794011397},
                                   {8.7501, 7.7501, -0.1359066564514102},
                                   {8.7501, 8.0001, -0.1375767311709712},
                                   {8.7501, 8.2501, -0.1381368203411002},
                                   {8.7501, 8.5001, -0.1376405951684744},
                                   {8.7501, 8.7501, -0.1361601819421488},
                                   {8.7501, 9.0001, -0.1337819854722968},
                                   {8.7501, 9.2501, -0.1306026202396215},
                                   {8.7501, 9.5001, -0.1267250936624394},
                                   {8.7501, 9.7501, -0.1222553466155873},
                                   {8.7501, 10.0001, -0.1172992202413549},
                                   {8.7501, 10.2501, -0.1119598864129687},
                                   {8.7501, 10.5001, -0.1063357525991693},
                                   {8.7501, 10.7501, -0.1005188305251814},
                                   {8.7501, 11.0001, -0.0945935417752419},
                                   {8.7501, 11.2501, -0.088635921937231},
                                   {8.7501, 11.5001, -0.0827131775009978},
                                   {8.7501, 11.7501, -0.07688354585986978},
                                   {8.7501, 12.0001, -0.07119640777878809},
                                   {8.7501, 12.2501, -0.06569260295159964},
                                   {8.7501, 12.5001, -0.06040490219200681},
                                   {8.7501, 12.7501, -0.05535859387163979},
                                   {8.7501, 13.0001, -0.05057214699414343},
                                   {8.7501, 13.2501, -0.04605791841313219},
                                   {8.7501, 13.5001, -0.04182287687648401},
                                   {8.7501, 13.7501, -0.03786932159102349},
                                   {8.7501, 14.0001, -0.03419557769288866},
                                   {8.7501, 14.2501, -0.03079665527509041},
                                   {8.7501, 14.5001, -0.02766486240389537},
                                   {8.7501, 14.7501, -0.02479036582360147},
                                   {8.7501, 15.0001, -0.02216169580595551},
                                   {8.7501, 15.2501, -0.01976619386675803},
                                   {8.7501, 15.5001, -0.01759040388287565},
                                   {8.7501, 15.7501, -0.01562040854153045},
                                   {8.7501, 16.0001, -0.01384211408871969},
                                   {8.7501, 16.2501, -0.01224148706486409},
                                   {8.7501, 16.5001, -0.01080474717239778},
                                   {8.7501, 16.7501, -0.00951852065856635},
                                   {8.7501, 17.0001, -0.0083699586600724},
                                   {8.7501, 17.2501, -0.00734682488290642},
                                   {8.7501, 17.5001, -0.006437556814528556},
                                   {8.7501, 17.7501, -0.005631304415573459},
                                   {8.7501, 18.0001, -0.004917949938887334},
                                   {8.7501, 18.2501, -0.004288112195111607},
                                   {8.7501, 18.5001, -0.003733138242411651},
                                   {8.7501, 18.7501, -0.003245085136019241},
                                   {8.7501, 19.0001, -0.002816694040667746},
                                   {8.7501, 19.2501, -0.002441358692791137},
                                   {8.7501, 19.5001, -0.002113089904382925},
                                   {8.7501, 19.7501, -0.001826477529719873},
                                   {8.7501, 20.0001, -0.001576651071350017},
                                   {8.7501, 20.2501, -0.001359239883289567},
                                   {8.7501, 20.5001, -0.001170333736865415},
                                   {8.7501, 20.7501, -0.001006444347036374},
                                   {8.7501, 21.0001, -0.00086446831283654},
                                   {8.7501, 21.2501, -0.0007416518030268771},
                                   {8.7501, 21.5001, -0.0006355572151692735},
                                   {8.7501, 21.7501, -0.0005440319511376947},
                                   {8.7501, 22.0001, -0.0004651793825492772},
                                   {8.7501, 22.2501, -0.00039733202379478},
                                   {8.7501, 22.5001, -0.0003390268864375629},
                                   {8.7501, 22.7501, -0.0002889829550286024},
                                   {8.7501, 23.0001, -0.0002460806992933077},
                                   {8.7501, 23.2501, -0.00020934351977867},
                                   {8.7501, 23.5001, -0.0001779210121550015},
                                   {8.7501, 23.7501, -0.0001510739283436123},
                                   {8.7501, 24.0001, -0.0001281607095312318},
                                   {8.7501, 24.2501, -0.0001086254661077964},
                                   {8.7501, 24.5001, -0.0000919872819224287},
                                   {8.7501, 24.7501, -0.00007783072439943419},
                                   {8.7501, 25.0001, -0.0000657974474969871},
                                   {8.7501, 25.2501, -0.00005557878081795558},
                                   {8.7501, 25.5001, -0.00004690920506321302},
                                   {8.7501, 25.7501, -0.00003956062118670779},
                                   {8.7501, 26.0001, -0.00003333732785873972},
                                   {8.7501, 26.2501, -0.00002807162900721146},
                                   {8.7501, 26.5001, -0.00002362000016399665},
                                   {8.7501, 26.7501, -0.00001985974900609317},
                                   {8.7501, 27.0001, -0.00001668611178725412},
                                   {8.7501, 27.2501, -0.00001400973326572895},
                                   {8.7501, 27.5001, -0.00001175448322566845},
                                   {8.7501, 27.7501, -9.85556775558773e-6},
                                   {8.7501, 28.0001, -8.25789808968328e-6},
                                   {8.7501, 28.2501, -6.914684047459817e-6},
                                   {8.7501, 28.5001, -5.786222940605986e-6},
                                   {8.7501, 28.7501, -4.83885827401732e-6},
                                   {8.7501, 29.0001, -4.044085673602692e-6},
                                   {8.7501, 29.2501, -3.377786251828044e-6},
                                   {8.7501, 29.5001, -2.819570098260855e-6},
                                   {8.7501, 29.7501, -2.352214782009153e-6},
                                   {9.0001, 0.0001, -5.690356609721867e-15},
                                   {9.0001, 0.2501, -3.066269375478337e-11},
                                   {9.0001, 0.5001, -1.01487093359737e-8},
                                   {9.0001, 0.7501, -2.692252077615769e-7},
                                   {9.0001, 1.0001, -2.547197381254609e-6},
                                   {9.0001, 1.2501, -0.00001371147867324914},
                                   {9.0001, 1.5001, -0.00005168982379380126},
                                   {9.0001, 1.7501, -0.0001524397746246193},
                                   {9.0001, 2.0001, -0.0003756911859170597},
                                   {9.0001, 2.2501, -0.000807379133867869},
                                   {9.0001, 2.5001, -0.001557549360100067},
                                   {9.0001, 2.7501, -0.002753639882179375},
                                   {9.0001, 3.0001, -0.004530037937033496},
                                   {9.0001, 3.2501, -0.007015462748510759},
                                   {9.0001, 3.5001, -0.01031997080243884},
                                   {9.0001, 3.7501, -0.01452327055405162},
                                   {9.0001, 4.0001, -0.01966567384596257},
                                   {9.0001, 4.2501, -0.02574252179891066},
                                   {9.0001, 4.5001, -0.03270240974457926},
                                   {9.0001, 4.7501, -0.04044907746147341},
                                   {9.0001, 5.0001, -0.04884647510030602},
                                   {9.0001, 5.2501, -0.05772628141546722},
                                   {9.0001, 5.5001, -0.06689703740688215},
                                   {9.0001, 5.7501, -0.07615404908522318},
                                   {9.0001, 6.0001, -0.085289284015733},
                                   {9.0001, 6.2501, -0.0941006114490642},
                                   {9.0001, 6.5001, -0.1023998905183165},
                                   {9.0001, 6.7501, -0.1100195742095344},
                                   {9.0001, 7.0001, -0.1168176524643016},
                                   {9.0001, 7.2501, -0.1226808947331108},
                                   {9.0001, 7.5001, -0.1275264640655547},
                                   {9.0001, 7.7501, -0.1313020587622458},
                                   {9.0001, 8.0001, -0.1339847940636588},
                                   {9.0001, 8.2501, -0.1355790677375114},
                                   {9.0001, 8.5001, -0.1361136634556261},
                                   {9.0001, 8.7501, -0.1356383388453549},
                                   {9.0001, 9.0001, -0.1342201254823363},
                                   {9.0001, 9.2501, -0.1319395400188527},
                                   {9.0001, 9.5001, -0.1288868727757114},
                                   {9.0001, 9.7501, -0.1251586855038516},
                                   {9.0001, 10.0001, -0.1208546160215396},
                                   {9.0001, 10.2501, -0.1160745557901901},
                                   {9.0001, 10.5001, -0.1109162383629056},
                                   {9.0001, 10.7501, -0.1054732526850926},
                                   {9.0001, 11.0001, -0.0998334757034535},
                                   {9.0001, 11.2501, -0.0940779035959139},
                                   {9.0001, 11.5001, -0.088279849894855},
                                   {9.0001, 11.7501, -0.0825044714159553},
                                   {9.0001, 12.0001, -0.0768085787173675},
                                   {9.0001, 12.2501, -0.0712406862574495},
                                   {9.0001, 12.5001, -0.06584125795695148},
                                   {9.0001, 12.7501, -0.06064310599831138},
                                   {9.0001, 13.0001, -0.05567190395502815},
                                   {9.0001, 13.2501, -0.05094677934219085},
                                   {9.0001, 13.5001, -0.04648095508318822},
                                   {9.0001, 13.7501, -0.0422824139288143},
                                   {9.0001, 14.0001, -0.03835456433456613},
                                   {9.0001, 14.2501, -0.03469689054509361},
                                   {9.0001, 14.5001, -0.03130557354389925},
                                   {9.0001, 14.7501, -0.02817407303377884},
                                   {9.0001, 15.0001, -0.02529366368405372},
                                   {9.0001, 15.2501, -0.02265392150507522},
                                   {9.0001, 15.5001, -0.02024315839906754},
                                   {9.0001, 15.7501, -0.01804880471355902},
                                   {9.0001, 16.0001, -0.01605774102340934},
                                   {9.0001, 16.2501, -0.01425658142948131},
                                   {9.0001, 16.5001, -0.01263191142873081},
                                   {9.0001, 16.7501, -0.01117048392463998},
                                   {9.0001, 17.0001, -0.00985937724984349},
                                   {9.0001, 17.2501, -0.00868611920322164},
                                   {9.0001, 17.5001, -0.007638781096973688},
                                   {9.0001, 17.7501, -0.006706045696696359},
                                   {9.0001, 18.0001, -0.005877252746700792},
                                   {9.0001, 18.2501, -0.005142425527121929},
                                   {9.0001, 18.5001, -0.004492281608394759},
                                   {9.0001, 18.7501, -0.003918230668420548},
                                   {9.0001, 19.0001, -0.003412361931033219},
                                   {9.0001, 19.2501, -0.002967423481159044},
                                   {9.0001, 19.5001, -0.002576795419824242},
                                   {9.0001, 19.7501, -0.002234458546280049},
                                   {9.0001, 20.0001, -0.001934959998598924},
                                   {9.0001, 20.2501, -0.001673377050324368},
                                   {9.0001, 20.5001, -0.001445280050153242},
                                   {9.0001, 20.7501, -0.001246695304316009},
                                   {9.0001, 21.0001, -0.001074068536737772},
                                   {9.0001, 21.2501, -0.000924229419155001},
                                   {9.0001, 21.5001, -0.0007943575407301306},
                                   {9.0001, 21.7501, -0.0006819500827324397},
                                   {9.0001, 22.0001, -0.0005847913768059685},
                                   {9.0001, 22.2501, -0.0005009244534533737},
                                   {9.0001, 22.5001, -0.000428624628880565},
                                   {9.0001, 22.7501, -0.0003663751315891185},
                                   {9.0001, 23.0001, -0.0003128447334876092},
                                   {9.0001, 23.2501, -0.000266867322352243},
                                   {9.0001, 23.5001, -0.0002274233318636326},
                                   {9.0001, 23.7501, -0.000193622930976094},
                                   {9.0001, 24.0001, -0.000164690864967771},
                                   {9.0001, 24.2501, -0.0001399528352329002},
                                   {9.0001, 24.5001, -0.0001188233028929228},
                                   {9.0001, 24.7501, -0.0001007946019162957},
                                   {9.0001, 25.0001, -0.0000854272500476432},
                                   {9.0001, 25.2501, -0.00007234134994961052},
                                   {9.0001, 25.5001, -0.00006120897813398471},
                                   {9.0001, 25.7501, -0.00005174746515529014},
                                   {9.0001, 26.0001, -0.00004371347687799957},
                                   {9.0001, 26.2501, -0.00003689781318175934},
                                   {9.0001, 26.5001, -0.00003112084705966827},
                                   {9.0001, 26.7501, -0.00002622853355545956},
                                   {9.0001, 27.0001, -0.00002208892427335731},
                                   {9.0001, 27.2501, -0.00001858912920470602},
                                   {9.0001, 27.5001, -0.00001563267329676623},
                                   {9.0001, 27.7501, -0.00001313720050874992},
                                   {9.0001, 28.0001, -0.00001103248304072794},
                                   {9.0001, 28.2501, -9.25869797681898e-6},
                                   {9.0001, 28.5001, -7.764937758542779e-6},
                                   {9.0001, 28.7501, -6.507924707732422e-6},
                                   {9.0001, 29.0001, -5.450903266295737e-6},
                                   {9.0001, 29.2501, -4.562686731201236e-6},
                                   {9.0001, 29.5001, -3.816838058382185e-6},
                                   {9.0001, 29.7501, -3.190966811093866e-6},
                                   {9.2501, 0.0001, -5.780815097533019e-15},
                                   {9.2501, 0.2501, -1.239028009834864e-11},
                                   {9.2501, 0.5001, -4.880850860678936e-9},
                                   {9.2501, 0.7501, -1.43382158227244e-7},
                                   {9.2501, 1.0001, -1.458435993319934e-6},
                                   {9.2501, 1.2501, -8.30443006854169e-6},
                                   {9.2501, 1.5001, -0.00003277733280821535},
                                   {9.2501, 1.7501, -0.0001004922516027551},
                                   {9.2501, 2.0001, -0.00025614033356665},
                                   {9.2501, 2.2501, -0.0005670429421222872},
                                   {9.2501, 2.5001, -0.001123346385660688},
                                   {9.2501, 2.7501, -0.002034293249509936},
                                   {9.2501, 3.0001, -0.003420859578327487},
                                   {9.2501, 3.2501, -0.005405732117434496},
                                   {9.2501, 3.5001, -0.00810200014316222},
                                   {9.2501, 3.7501, -0.0116020348753566},
                                   {9.2501, 4.0001, -0.0159678757205626},
                                   {9.2501, 4.2501, -0.02122411912718886},
                                   {9.2501, 4.5001, -0.02735390085373501},
                                   {9.2501, 4.7501, -0.03429815234675138},
                                   {9.2501, 5.0001, -0.04195795257803586},
                                   {9.2501, 5.2501, -0.05019952150222866},
                                   {9.2501, 5.5001, -0.05886122350870636},
                                   {9.2501, 5.7501, -0.06776186645125247},
                                   {9.2501, 6.0001, -0.07670958114427896},
                                   {9.2501, 6.2501, -0.0855106290061961},
                                   {9.2501, 6.5001, -0.0939775913889806},
                                   {9.2501, 6.7501, -0.1019365236456691},
                                   {9.2501, 7.0001, -0.1092327935231025},
                                   {9.2501, 7.2501, -0.1157354540626062},
                                   {9.2501, 7.5001, -0.1213401167607273},
                                   {9.2501, 7.7501, -0.1259703858208809},
                                   {9.2501, 8.0001, -0.1295779865357974},
                                   {9.2501, 8.2501, -0.1321417702227691},
                                   {9.2501, 8.5001, -0.1336658064702139},
                                   {9.2501, 8.7501, -0.1341767836349097},
                                   {9.2501, 9.0001, -0.133720934017596},
                                   {9.2501, 9.2501, -0.1323606845543022},
                                   {9.2501, 9.5001, -0.1301712106469858},
                                   {9.2501, 9.7501, -0.1272370430111101},
                                   {9.2501, 10.0001, -0.1236488477495641},
                                   {9.2501, 10.2501, -0.1195004703528794},
                                   {9.2501, 10.5001, -0.1148863065316716},
                                   {9.2501, 10.7501, -0.1098990377808591},
                                   {9.2501, 11.0001, -0.104627748006025},
                                   {9.2501, 11.2501, -0.099156419709473},
                                   {9.2501, 11.5001, -0.0935627941606304},
                                   {9.2501, 11.7501, -0.0879175694814812},
                                   {9.2501, 12.0001, -0.0822839033410998},
                                   {9.2501, 12.2501, -0.07671718256652554},
                                   {9.2501, 12.5001, -0.07126501999109908},
                                   {9.2501, 12.7501, -0.06596743882008395},
                                   {9.2501, 13.0001, -0.06085720625961373},
                                   {9.2501, 13.2501, -0.05596028072752813},
                                   {9.2501, 13.5001, -0.05129634028905082},
                                   {9.2501, 13.7501, -0.04687936373417992},
                                   {9.2501, 14.0001, -0.04271823968800403},
                                   {9.2501, 14.2501, -0.03881738312215454},
                                   {9.2501, 14.5001, -0.03517734246486612},
                                   {9.2501, 14.7501, -0.03179538408037856},
                                   {9.2501, 15.0001, -0.02866604413366609},
                                   {9.2501, 15.2501, -0.02578164073193632},
                                   {9.2501, 15.5001, -0.02313274172258657},
                                   {9.2501, 15.7501, -0.02070858562989808},
                                   {9.2501, 16.0001, -0.01849745494537617},
                                   {9.2501, 16.2501, -0.01648700237493991},
                                   {9.2501, 16.5001, -0.0146645317221927},
                                   {9.2501, 16.7501, -0.01301723588638324},
                                   {9.2501, 17.0001, -0.01153239501330594},
                                   {9.2501, 17.2501, -0.01019753819375807},
                                   {9.2501, 17.5001, -0.0090005722920387},
                                   {9.2501, 17.7501, -0.007929881538544993},
                                   {9.2501, 18.0001, -0.006974401464900258},
                                   {9.2501, 18.2501, -0.006123670622959869},
                                   {9.2501, 18.5001, -0.005367863332760531},
                                   {9.2501, 18.7501, -0.00469780646790086},
                                   {9.2501, 19.0001, -0.004104983025671177},
                                   {9.2501, 19.2501, -0.003581524956250574},
                                   {9.2501, 19.5001, -0.003120197450580747},
                                   {9.2501, 19.7501, -0.002714376617900731},
                                   {9.2501, 20.0001, -0.002358022227167064},
                                   {9.2501, 20.2501, -0.00204564694576812},
                                   {9.2501, 20.5001, -0.001772283286732173},
                                   {9.2501, 20.7501, -0.001533449273535342},
                                   {9.2501, 21.0001, -0.001325113650228845},
                                   {9.2501, 21.2501, -0.001143661303803722},
                                   {9.2501, 21.5001, -0.000985859424838441},
                                   {9.2501, 21.7501, -0.000848824810488718},
                                   {9.2501, 22.0001, -0.0007299926094759894},
                                   {9.2501, 22.2501, -0.000627086720448319},
                                   {9.2501, 22.5001, -0.0005380919813828024},
                                   {9.2501, 22.7501, -0.0004612282270133678},
                                   {9.2501, 23.0001, -0.0003949262420753763},
                                   {9.2501, 23.2501, -0.0003378055989977994},
                                   {9.2501, 23.5001, -0.0002886543381744924},
                                   {9.2501, 23.7501, -0.0002464104258432613},
                                   {9.2501, 24.0001, -0.0002101449077441596},
                                   {9.2501, 24.2501, -0.0001790466650829412},
                                   {9.2501, 24.5001, -0.0001524086719740482},
                                   {9.2501, 24.7501, -0.000129615649674035},
                                   {9.2501, 25.0001, -0.0001101330118407625},
                                   {9.2501, 25.2501, -0.0000934969961639526},
                                   {9.2501, 25.5001, -0.00007930588049643105},
                                   {9.2501, 25.7501, -0.00006721218564116766},
                                   {9.2501, 26.0001, -0.00005691577185781394},
                                   {9.2501, 26.2501, -0.00004815774164824238},
                                   {9.2501, 26.5001, -0.00004071506722359056},
                                   {9.2501, 26.7501, -0.00003439586705348521},
                                   {9.2501, 27.0001, -0.0000290352619005558},
                                   {9.2501, 27.2501, -0.00002449174663393114},
                                   {9.2501, 27.5001, -0.00002064401980725525},
                                   {9.2501, 27.7501, -0.00001738821841719784},
                                   {9.2501, 28.0001, -0.00001463551038470997},
                                   {9.2501, 28.2501, -0.00001231000209674008},
                                   {9.2501, 28.5001, -0.00001034692279701624},
                                   {9.2501, 28.7501, -8.69105171717445e-6},
                                   {9.2501, 29.0001, -7.295357598122307e-6},
                                   {9.2501, 29.2501, -6.119823676076955e-6},
                                   {9.2501, 29.5001, -5.130434312460469e-6},
                                   {9.2501, 29.7501, -4.298302248959317e-6},
                                   {9.5001, 0.0001, -5.869126325643798e-15},
                                   {9.5001, 0.2501, -4.974453030617862e-12},
                                   {9.5001, 0.5001, -2.331848552247651e-9},
                                   {9.5001, 0.7501, -7.585524204463814e-8},
                                   {9.5001, 1.0001, -8.2950015268859e-7},
                                   {9.5001, 1.2501, -4.996135457199676e-6},
                                   {9.5001, 1.5001, -0.00002064602148620842},
                                   {9.5001, 1.7501, -0.0000658047218141842},
                                   {9.5001, 2.0001, -0.0001734648990376335},
                                   {9.5001, 2.2501, -0.0003955832502074316},
                                   {9.5001, 2.5001, -0.000804759719480061},
                                   {9.5001, 2.7501, -0.001492787656878486},
                                   {9.5001, 3.0001, -0.002565927179518285},
                                   {9.5001, 3.2501, -0.004137387307270979},
                                   {9.5001, 3.5001, -0.006317968098749942},
                                   {9.5001, 3.7501, -0.00920605127434923},
                                   {9.5001, 4.0001, -0.012878139909661},
                                   {9.5001, 4.2501, -0.0173809795694343},
                                   {9.5001, 4.5001, -0.02272600880242828},
                                   {9.5001, 4.7501, -0.02888655187444868},
                                   {9.5001, 5.0001, -0.03579783679775824},
                                   {9.5001, 5.2501, -0.04335963751005361},
                                   {9.5001, 5.5001, -0.05144112427686201},
                                   {9.5001, 5.7501, -0.0598873700178888},
                                   {9.5001, 6.0001, -0.06852689970674117},
                                   {9.5001, 6.2501, -0.07717967485372858},
                                   {9.5001, 6.5001, -0.0856649606271214},
                                   {9.5001, 6.7501, -0.0938086132579762},
                                   {9.5001, 7.0001, -0.1014494345863268},
                                   {9.5001, 7.2501, -0.1084443556196838},
                                   {9.5001, 7.5001, -0.114672321285196},
                                   {9.5001, 7.7501, -0.1200368466864593},
                                   {9.5001, 8.0001, -0.1244672965134034},
                                   {9.5001, 8.2501, -0.1279190016686884},
                                   {9.5001, 8.5001, -0.130372370518281},
                                   {9.5001, 8.7501, -0.1318311777533956},
                                   {9.5001, 9.0001, -0.1323202239288154},
                                   {9.5001, 9.2501, -0.1318825561074546},
                                   {9.5001, 9.5001, -0.130576427658876},
                                   {9.5001, 9.7501, -0.128472156012287},
                                   {9.5001, 10.0001, -0.1256490136704833},
                                   {9.5001, 10.2501, -0.1221922622959969},
                                   {9.5001, 10.5001, -0.118190414006775},
                                   {9.5001, 10.7501, -0.113732779558607},
                                   {9.5001, 11.0001, -0.1089073408325873},
                                   {9.5001, 11.2501, -0.1037989656153161},
                                   {9.5001, 11.5001, -0.0984879663801556},
                                   {9.5001, 11.7501, -0.0930489917280593},
                                   {9.5001, 12.0001, -0.0875502292187299},
                                   {9.5001, 12.2501, -0.0820528912773907},
                                   {9.5001, 12.5001, -0.07661095137424883},
                                   {9.5001, 12.7501, -0.07127109537157674},
                                   {9.5001, 13.0001, -0.06607285243093587},
                                   {9.5001, 13.2501, -0.06104887079256837},
                                   {9.5001, 13.5001, -0.05622530572773999},
                                   {9.5001, 13.7501, -0.05162228970626125},
                                   {9.5001, 14.0001, -0.04725445804116659},
                                   {9.5001, 14.2501, -0.04313150674068723},
                                   {9.5001, 14.5001, -0.03925876282824126},
                                   {9.5001, 14.7501, -0.03563775083955445},
                                   {9.5001, 15.0001, -0.03226674246503269},
                                   {9.5001, 15.2501, -0.02914127930072586},
                                   {9.5001, 15.5001, -0.02625466135605279},
                                   {9.5001, 15.7501, -0.02359839631715842},
                                   {9.5001, 16.0001, -0.02116260657577287},
                                   {9.5001, 16.2501, -0.0189363927130604},
                                   {9.5001, 16.5001, -0.01690815349462635},
                                   {9.5001, 16.7501, -0.01506586351193293},
                                   {9.5001, 17.0001, -0.01339731042640883},
                                   {9.5001, 17.2501, -0.01189029436711984},
                                   {9.5001, 17.5001, -0.01053279243294681},
                                   {9.5001, 17.7501, -0.00931309148682581},
                                   {9.5001, 18.0001, -0.00821989253195167},
                                   {9.5001, 18.2501, -0.007242389954710169},
                                   {9.5001, 18.5001, -0.006370328830481801},
                                   {9.5001, 18.7501, -0.005594043337407605},
                                   {9.5001, 19.0001, -0.004904479127828575},
                                   {9.5001, 19.2501, -0.004293202282665838},
                                   {9.5001, 19.5001, -0.003752397233093225},
                                   {9.5001, 19.7501, -0.003274855786629535},
                                   {9.5001, 20.0001, -0.002853959149232938},
                                   {9.5001, 20.2501, -0.002483654597199086},
                                   {9.5001, 20.5001, -0.002158428227096473},
                                   {9.5001, 20.7501, -0.00187327500168667},
                                   {9.5001, 21.0001, -0.001623667116701597},
                                   {9.5001, 21.2501, -0.001405521538488683},
                                   {9.5001, 21.5001, -0.001215167406159474},
                                   {9.5001, 21.7501, -0.001049313853696542},
                                   {9.5001, 22.0001, -0.00090501868677613},
                                   {9.5001, 22.2501, -0.0007796582448412643},
                                   {9.5001, 22.5001, -0.0006708986900058309},
                                   {9.5001, 22.7501, -0.0005766688893626862},
                                   {9.5001, 23.0001, -0.0004951349948357042},
                                   {9.5001, 23.2501, -0.0004246767734837144},
                                   {9.5001, 23.5001, -0.0003638656997978135},
                                   {9.5001, 23.7501, -0.0003114447887614033},
                                   {9.5001, 24.0001, -0.0002663101230767181},
                                   {9.5001, 24.2501, -0.0002274940089096445},
                                   {9.5001, 24.5001, -0.0001941496807744243},
                                   {9.5001, 24.7501, -0.0001655374668821166},
                                   {9.5001, 25.0001, -0.0001410123206233104},
                                   {9.5001, 25.2501, -0.0001200126211553908},
                                   {9.5001, 25.5001, -0.0001020501457178894},
                                   {9.5001, 25.7501, -0.0000867011177908786},
                                   {9.5001, 26.0001, -0.0000735982381029695},
                                   {9.5001, 26.2501, -0.00006242360941875184},
                                   {9.5001, 26.5001, -0.00005290247068393141},
                                   {9.5001, 26.7501, -0.00004479766122802826},
                                   {9.5001, 27.0001, -0.00003790474111496602},
                                   {9.5001, 27.2501, -0.00003204769922802384},
                                   {9.5001, 27.5001, -0.00002707518614943993},
                                   {9.5001, 27.7501, -0.00002285721424826758},
                                   {9.5001, 28.0001, -0.00001928227254971084},
                                   {9.5001, 28.2501, -0.00001625480887267841},
                                   {9.5001, 28.5001, -0.00001369303635427874},
                                   {9.5001, 28.7501, -0.00001152702580881832},
                                   {9.5001, 29.0001, -9.69704938394665e-6},
                                   {9.5001, 29.2501, -8.15214467595155e-6},
                                   {9.5001, 29.5001, -6.848871854531835e-6},
                                   {9.5001, 29.7501, -5.75023943432906e-6},
                                   {9.7501, 0.0001, -5.955396363197365e-15},
                                   {9.7501, 0.2501, -1.985049445121899e-12},
                                   {9.7501, 0.5001, -1.106878980583174e-9},
                                   {9.7501, 0.7501, -3.987149300925716e-8},
                                   {9.7501, 1.0001, -4.687330583097564e-7},
                                   {9.7501, 1.2501, -2.986299813377505e-6},
                                   {9.7501, 1.5001, -0.00001292021067368727},
                                   {9.7501, 1.7501, -0.00004281029383654198},
                                   {9.7501, 2.0001, -0.000116710136686906},
                                   {9.7501, 2.2501, -0.0002741701615711125},
                                   {9.7501, 2.5001, -0.000572764929686945},
                                   {9.7501, 2.7501, -0.001088272612837929},
                                   {9.7501, 3.0001, -0.001912081195134596},
                                   {9.7501, 3.2501, -0.003145927178574741},
                                   {9.7501, 3.5001, -0.004894535631557444},
                                   {9.7501, 3.7501, -0.007257042683766185},
                                   {9.7501, 4.0001, -0.01031821312420007},
                                   {9.7501, 4.2501, -0.01414042876272759},
                                   {9.7501, 4.5001, -0.01875725626203272},
                                   {9.7501, 4.7501, -0.02416915613781746},
                                   {9.7501, 5.0001, -0.03034161698302201},
                                   {9.7501, 5.2501, -0.03720573205663652},
                                   {9.7501, 5.5001, -0.04466100879977959},
                                   {9.7501, 5.7501, -0.05258003279650715},
                                   {9.7501, 6.0001, -0.0608145022996006},
                                   {9.7501, 6.2501, -0.0692021051349978},
                                   {9.7501, 6.5001, -0.07757371810959119},
                                   {9.7501, 6.7501, -0.0857604582013663},
                                   {9.7501, 7.0001, -0.0936001919186392},
                                   {9.7501, 7.2501, -0.1009432019085215},
                                   {9.7501, 7.5001, -0.1076568074078835},
                                   {9.7501, 7.7501, -0.1136288288866062},
                                   {9.7501, 8.0001, -0.1187698710383258},
                                   {9.7501, 8.2501, -0.1230144682214531},
                                   {9.7501, 8.5001, -0.1263211906449573},
                                   {9.7501, 8.7501, -0.1286718477619034},
                                   {9.7501, 9.0001, -0.1300699484322463},
                                   {9.7501, 9.2501, -0.1305385872240633},
                                   {9.7501, 9.5001, -0.1301179249949639},
                                   {9.7501, 9.7501, -0.1288624220775269},
                                   {9.7501, 10.0001, -0.126837966396787},
                                   {9.7501, 10.2501, -0.1241190188978751},
                                   {9.7501, 10.5001, -0.1207858766938601},
                                   {9.7501, 10.7501, -0.1169221319544538},
                                   {9.7501, 11.0001, -0.1126123829893786},
                                   {9.7501, 11.2501, -0.1079402341404987},
                                   {9.7501, 11.5001, -0.1029866035817992},
                                   {9.7501, 11.7501, -0.0978283432694136},
                                   {9.7501, 12.0001, -0.0925371632023018},
                                   {9.7501, 12.2501, -0.0871788427967966},
                                   {9.7501, 12.5001, -0.0818127053709279},
                                   {9.7501, 12.7501, -0.07649132722018939},
                                   {9.7501, 13.0001, -0.07126045023954095},
                                   {9.7501, 13.2501, -0.0661590661803812},
                                   {9.7501, 13.5001, -0.06121964110009301},
                                   {9.7501, 13.7501, -0.05646845005618687},
                                   {9.7501, 14.0001, -0.05192599433495616},
                                   {9.7501, 14.2501, -0.04760747623765563},
                                   {9.7501, 14.5001, -0.04352330946420793},
                                   {9.7501, 14.7501, -0.039679646261439},
                                   {9.7501, 15.0001, -0.03607890560189285},
                                   {9.7501, 15.2501, -0.03272028962556732},
                                   {9.7501, 15.5001, -0.02960027833514019},
                                   {9.7501, 15.7501, -0.02671309503555718},
                                   {9.7501, 16.0001, -0.02405113722266252},
                                   {9.7501, 16.2501, -0.0216053695415434},
                                   {9.7501, 16.5001, -0.01936567705560241},
                                   {9.7501, 16.7501, -0.01732117840435081},
                                   {9.7501, 17.0001, -0.01546049950099202},
                                   {9.7501, 17.2501, -0.01377200925418399},
                                   {9.7501, 17.5001, -0.01224401941871542},
                                   {9.7501, 17.7501, -0.01086495111499206},
                                   {9.7501, 18.0001, -0.00962347083473827},
                                   {9.7501, 18.2501, -0.00850859889652395},
                                   {9.7501, 18.5001, -0.007509793354141527},
                                   {9.7501, 18.7501, -0.006617012315748959},
                                   {9.7501, 19.0001, -0.005820757521852925},
                                   {9.7501, 19.2501, -0.005112101872872289},
                                   {9.7501, 19.5001, -0.004482703406919891},
                                   {9.7501, 19.7501, -0.003924808017896826},
                                   {9.7501, 20.0001, -0.003431242983108944},
                                   {9.7501, 20.2501, -0.002995403146475855},
                                   {9.7501, 20.5001, -0.002611231384302446},
                                   {9.7501, 20.7501, -0.002273194770258094},
                                   {9.7501, 21.0001, -0.001976257658061644},
                                   {9.7501, 21.2501, -0.001715852716685383},
                                   {9.7501, 21.5001, -0.00148785078503229},
                                   {9.7501, 21.7501, -0.001288530261630112},
                                   {9.7501, 22.0001, -0.001114546609962389},
                                   {9.7501, 22.2501, -0.00096290244121409},
                                   {9.7501, 22.5001, -0.000830918532714046},
                                   {9.7501, 22.7501, -0.0007162060512448988},
                                   {9.7501, 23.0001, -0.0006166401745535253},
                                   {9.7501, 23.2501, -0.0005303352406387754},
                                   {9.7501, 23.5001, -0.0004556215014976634},
                                   {9.7501, 23.7501, -0.0003910235147649648},
                                   {9.7501, 24.0001, -0.0003352401719147197},
                                   {9.7501, 24.2501, -0.0002871263342975221},
                                   {9.7501, 24.5001, -0.0002456760272335327},
                                   {9.7501, 24.7501, -0.0002100071267220151},
                                   {9.7501, 25.0001, -0.0001793474622074744},
                                   {9.7501, 25.2501, -0.0001530222514940042},
                                   {9.7501, 25.5001, -0.0001304427796452174},
                                   {9.7501, 25.7501, -0.0001110962319535318},
                                   {9.7501, 26.0001, -0.0000945365912950278},
                                   {9.7501, 26.2501, -0.0000803765119631314},
                                   {9.7501, 26.5001, -0.00006828008502104234},
                                   {9.7501, 26.7501, -0.00005795641401405861},
                                   {9.7501, 27.0001, -0.0000491539242769402},
                                   {9.7501, 27.2501, -0.00004165533384330748},
                                   {9.7501, 27.5001, -0.00003527321893977236},
                                   {9.7501, 27.7501, -0.00002984611208834436},
                                   {9.7501, 28.0001, -0.00002523507583811353},
                                   {9.7501, 28.2501, -0.00002132070001832608},
                                   {9.7501, 28.5001, -0.0000180004750882042},
                                   {9.7501, 28.7501, -0.00001518649861046231},
                                   {9.7501, 29.0001, -0.00001280347606625582},
                                   {9.7501, 29.2501, -0.0000107869811418868},
                                   {9.7501, 29.5001, -9.08194424401787e-6},
                                   {9.7501, 29.7501, -7.641341339830348e-6},
                                   {10.0001, 0.0001, -6.039723445703111e-15},
                                   {10.0001, 0.2501, -7.87905220620886e-13},
                                   {10.0001, 0.5001, -5.221149955303199e-10},
                                   {10.0001, 0.7501, -2.082558926005819e-8},
                                   {10.0001, 1.0001, -2.632003990636566e-7},
                                   {10.0001, 1.2501, -1.773697469963919e-6},
                                   {10.0001, 1.5001, -8.03425500552519e-6},
                                   {10.0001, 1.7501, -0.00002767442284864221},
                                   {10.0001, 2.0001, -0.00007802640529818157},
                                   {10.0001, 2.2501, -0.0001888146577819165},
                                   {10.0001, 2.5001, -0.0004050580551420043},
                                   {10.0001, 2.7501, -0.0007883257233655973},
                                   {10.0001, 3.0001, -0.001415775921097382},
                                   {10.0001, 3.2501, -0.002376814873938365},
                                   {10.0001, 3.5001, -0.003767627152234582},
                                   {10.0001, 3.7501, -0.005684163990743541},
                                   {10.0001, 4.0001, -0.00821438142823343},
                                   {10.0001, 4.2501, -0.01143058350818927},
                                   {10.0001, 4.5001, -0.01538266239581591},
                                   {10.0001, 4.7501, -0.02009286954998067},
                                   {10.0001, 5.0001, -0.02555253908349399},
                                   {10.0001, 5.2501, -0.0317209537659445},
                                   {10.0001, 5.5001, -0.03852632680532222},
                                   {10.0001, 5.7501, -0.04586869057211857},
                                   {10.0001, 6.0001, -0.05362434936159842},
                                   {10.0001, 6.2501, -0.06165147129316917},
                                   {10.0001, 6.5001, -0.06979636209648678},
                                   {10.0001, 6.7501, -0.0778999738822776},
                                   {10.0001, 7.0001, -0.0858042455381416},
                                   {10.0001, 7.2501, -0.0933579377367611},
                                   {10.0001, 7.5001, -0.100421704689282},
                                   {10.0001, 7.7501, -0.106872227949838},
                                   {10.0001, 8.0001, -0.1126053177244686},
                                   {10.0001, 8.2501, -0.1175379590967178},
                                   {10.0001, 8.5001, -0.1216093410302338},
                                   {10.0001, 8.7501, -0.1247809532596533},
                                   {10.0001, 9.0001, -0.1270358698974634},
                                   {10.0001, 9.2501, -0.1283773594568729},
                                   {10.0001, 9.5001, -0.1288269704223446},
                                   {10.0001, 9.7501, -0.128422241322736},
                                   {10.0001, 10.0001, -0.1272141765000048},
                                   {10.0001, 10.2501, -0.1252646154457925},
                                   {10.0001, 10.5001, -0.1226436065931471},
                                   {10.0001, 10.7501, -0.1194268774733399},
                                   {10.0001, 11.0001, -0.1156934735784205},
                                   {10.0001, 11.2501, -0.1115236192188906},
                                   {10.0001, 11.5001, -0.1069968359583842},
                                   {10.0001, 11.7501, -0.1021903384072836},
                                   {10.0001, 12.0001, -0.0971777135994305},
                                   {10.0001, 12.2501, -0.0920278790041455},
                                   {10.0001, 12.5001, -0.0868043054316727},
                                   {10.0001, 12.7501, -0.081564484552207},
                                   {10.0001, 13.0001, -0.07635961626577414},
                                   {10.0001, 13.2501, -0.07123448848183132},
                                   {10.0001, 13.5001, -0.06622752071816826},
                                   {10.0001, 13.7501, -0.0613709430279526},
                                   {10.0001, 14.0001, -0.05669108284065362},
                                   {10.0001, 14.2501, -0.05220873410623277},
                                   {10.0001, 14.5001, -0.04793958543836657},
                                   {10.0001, 14.7501, -0.04389468656801149},
                                   {10.0001, 15.0001, -0.04008093518150174},
                                   {10.0001, 15.2501, -0.03650156899688374},
                                   {10.0001, 15.5001, -0.0331566506268515},
                                   {10.0001, 15.7501, -0.03004353531141672},
                                   {10.0001, 16.0001, -0.02715731392646857},
                                   {10.0001, 16.2501, -0.0244912257535027},
                                   {10.0001, 16.5001, -0.0220370373151338},
                                   {10.0001, 16.7501, -0.01978538513762741},
                                   {10.0001, 17.0001, -0.01772608160264074},
                                   {10.0001, 17.2501, -0.01584838410999699},
                                   {10.0001, 17.5001, -0.01414122861099115},
                                   {10.0001, 17.7501, -0.01259342920989004},
                                   {10.0001, 18.0001, -0.01119384599392033},
                                   {10.0001, 18.2501, -0.00993152356341603},
                                   {10.0001, 18.5001, -0.00879580291755976},
                                   {10.0001, 18.7501, -0.007776409429630851},
                                   {10.0001, 19.0001, -0.00686351963942422},
                                   {10.0001, 19.2501, -0.0060478095180362},
                                   {10.0001, 19.5001, -0.005320486737852286},
                                   {10.0001, 19.7501, -0.004673309322435778},
                                   {10.0001, 20.0001, -0.004098592869082988},
                                   {10.0001, 20.2501, -0.003589208341035031},
                                   {10.0001, 20.5001, -0.003138572224815324},
                                   {10.0001, 20.7501, -0.002740630647319739},
                                   {10.0001, 21.0001, -0.002389838852070943},
                                   {10.0001, 21.2501, -0.002081137248129048},
                                   {10.0001, 21.5001, -0.001809925071109293},
                                   {10.0001, 21.7501, -0.001572032535268446},
                                   {10.0001, 22.0001, -0.001363692209616008},
                                   {10.0001, 22.2501, -0.001181510219820865},
                                   {10.0001, 22.5001, -0.001022437761190438},
                                   {10.0001, 22.7501, -0.000883743305718655},
                                   {10.0001, 23.0001, -0.0007629857973963516},
                                   {10.0001, 23.2501, -0.0006579890537440114},
                                   {10.0001, 23.5001, -0.0005668175268440367},
                                   {10.0001, 23.7501, -0.0004877535229448088},
                                   {10.0001, 24.0001, -0.000419275934894781},
                                   {10.0001, 24.2501, -0.0003600405051735329},
                                   {10.0001, 24.5001, -0.0003088616080922047},
                                   {10.0001, 24.7501, -0.0002646955168712652},
                                   {10.0001, 25.0001, -0.0002266251038726108},
                                   {10.0001, 25.2501, -0.0001938459094456207},
                                   {10.0001, 25.5001, -0.0001656535059024991},
                                   {10.0001, 25.7501, -0.0001414320774058138},
                                   {10.0001, 26.0001, -0.000120644133446544},
                                   {10.0001, 26.2501, -0.0001028212726035346},
                                   {10.0001, 26.5001, -0.000087555913963},
                                   {10.0001, 26.7501, -0.0000744939155608837},
                                   {10.0001, 27.0001, -0.00006332800217013922},
                                   {10.0001, 27.2501, -0.00005379192841972998},
                                   {10.0001, 27.5001, -0.00004565530737856657},
                                   {10.0001, 27.7501, -0.00003871903918232694},
                                   {10.0001, 28.0001, -0.00003281127887589524},
                                   {10.0001, 28.2501, -0.00002778388727111389},
                                   {10.0001, 28.5001, -0.00002350931318669284},
                                   {10.0001, 28.7501, -0.00001987785987443324},
                                   {10.0001, 29.0001, -0.00001679529269175013},
                                   {10.0001, 29.2501, -0.00001418074911842184},
                                   {10.0001, 29.5001, -0.00001196491601163582},
                                   {10.0001, 29.7501, -0.00001008844253393509},
                                   {10.2501, 0.0001, -6.122198735520573e-15},
                                   {10.2501, 0.2501, -3.115698442764373e-13},
                                   {10.2501, 0.5001, -2.44774617730052e-10},
                                   {10.2501, 0.7501, -1.081080258991091e-8},
                                   {10.2501, 1.0001, -1.468816690802049e-7},
                                   {10.2501, 1.2501, -1.046986617521936e-6},
                                   {10.2501, 1.5001, -4.965158869612344e-6},
                                   {10.2501, 1.7501, -0.00001777939826443095},
                                   {10.2501, 2.0001, -0.0000518417610025507},
                                   {10.2501, 2.2501, -0.0001292271202466968},
                                   {10.2501, 2.5001, -0.0002846807784612271},
                                   {10.2501, 2.7501, -0.0005675073601728206},
                                   {10.2501, 3.0001, -0.001041785910238087},
                                   {10.2501, 3.2501, -0.001784579624637017},
                                   {10.2501, 3.5001, -0.002882149283952615},
                                   {10.2501, 3.7501, -0.004424498104161804},
                                   {10.2501, 4.0001, -0.006498815279035575},
                                   {10.2501, 4.2501, -0.00918251684929522},
                                   {10.2501, 4.5001, -0.01253660233881702},
                                   {10.2501, 4.7501, -0.0165999696183479},
                                   {10.2501, 5.0001, -0.02138518559861033},
                                   {10.2501, 5.2501, -0.0268760273316779},
                                   {10.2501, 5.5001, -0.0330269158291236},
                                   {10.2501, 5.7501, -0.03976418694165963},
                                   {10.2501, 6.0001, -0.04698899649660073},
                                   {10.2501, 6.2501, -0.05458154982122667},
                                   {10.2501, 6.5001, -0.06240628162051304},
                                   {10.2501, 6.7501, -0.07031758868698416},
                                   {10.2501, 7.0001, -0.07816572935690893},
                                   {10.2501, 7.2501, -0.0858025422535046},
                                   {10.2501, 7.5001, -0.0930866942289093},
                                   {10.2501, 7.7501, -0.0998882353704781},
                                   {10.2501, 8.0001, -0.1060923102750936},
                                   {10.2501, 8.2501, -0.1116019436770496},
                                   {10.2501, 8.5001, -0.1163398806139925},
                                   {10.2501, 8.7501, -0.1202495137943811},
                                   {10.2501, 9.0001, -0.1232949721935473},
                                   {10.2501, 9.2501, -0.1254604747792687},
                                   {10.2501, 9.5001, -0.1267490721459246},
                                   {10.2501, 9.7501, -0.1271809078289311},
                                   {10.2501, 10.0001, -0.1267911316725626},
                                   {10.2501, 10.2501, -0.1256275915149894},
                                   {10.2501, 10.5001, -0.1237484183426151},
                                   {10.2501, 10.7501, -0.1212196055695081},
                                   {10.2501, 11.0001, -0.1181126666641231},
                                   {10.2501, 11.2501, -0.1145024382036702},
                                   {10.2501, 11.5001, -0.1104650785766493},
                                   {10.2501, 11.7501, -0.1060762967278467},
                                   {10.2501, 12.0001, -0.1014098310754977},
                                   {10.2501, 12.2501, -0.0965361863566428},
                                   {10.2501, 12.5001, -0.0915216258347133},
                                   {10.2501, 12.7501, -0.0864274080576197},
                                   {10.2501, 13.0001, -0.0813092511051157},
                                   {10.2501, 13.2501, -0.07621700285584282},
                                   {10.2501, 13.5001, -0.07119449303293781},
                                   {10.2501, 13.7501, -0.0662795414208262},
                                   {10.2501, 14.0001, -0.06150409644376173},
                                   {10.2501, 14.2501, -0.05689447902191654},
                                   {10.2501, 14.5001, -0.05247170805069659},
                                   {10.2501, 14.7501, -0.04825188578171411},
                                   {10.2501, 15.0001, -0.04424662364272321},
                                   {10.2501, 15.2501, -0.0404634914688059},
                                   {10.2501, 15.5001, -0.03690647560503057},
                                   {10.2501, 15.7501, -0.03357643378420367},
                                   {10.2501, 16.0001, -0.03047153700833377},
                                   {10.2501, 16.2501, -0.02758769081618199},
                                   {10.2501, 16.5001, -0.0249189302671032},
                                   {10.2501, 16.7501, -0.02245778469382486},
                                   {10.2501, 17.0001, -0.02019560976677248},
                                   {10.2501, 17.2501, -0.01812288567264958},
                                   {10.2501, 17.5001, -0.01622948125014375},
                                   {10.2501, 17.7501, -0.01450488476099967},
                                   {10.2501, 18.0001, -0.01293840262383923},
                                   {10.2501, 18.2501, -0.01151932792152941},
                                   {10.2501, 18.5001, -0.01023708083186483},
                                   {10.2501, 18.7501, -0.00908132334694281},
                                   {10.2501, 19.0001, -0.00804205075910129},
                                   {10.2501, 19.2501, -0.007109662419556671},
                                   {10.2501, 19.5001, -0.006275014237144894},
                                   {10.2501, 19.7501, -0.005529455294214728},
                                   {10.2501, 20.0001, -0.004864850828212011},
                                   {10.2501, 20.2501, -0.004273593672390361},
                                   {10.2501, 20.5001, -0.003748606077127142},
                                   {10.2501, 20.7501, -0.003283333652549855},
                                   {10.2501, 21.0001, -0.002871732990070425},
                                   {10.2501, 21.2501, -0.002508254340077078},
                                   {10.2501, 21.5001, -0.002187820549321396},
                                   {10.2501, 21.7501, -0.001905803297287824},
                                   {10.2501, 22.0001, -0.001657997517982879},
                                   {10.2501, 22.2501, -0.001440594753332718},
                                   {10.2501, 22.5001, -0.001250156057332164},
                                   {10.2501, 22.7501, -0.001083584956370076},
                                   {10.2501, 23.0001, -0.000938100870520235},
                                   {10.2501, 23.2501, -0.000811213312512177},
                                   {10.2501, 23.5001, -0.0007006971048636196},
                                   {10.2501, 23.7501, -0.0006045687904138168},
                                   {10.2501, 24.0001, -0.0005210643563157893},
                                   {10.2501, 24.2501, -0.0004486183454595476},
                                   {10.2501, 24.5001, -0.0003858443913413385},
                                   {10.2501, 24.7501, -0.0003315171816224189},
                                   {10.2501, 25.0001, -0.0002845558311345227},
                                   {10.2501, 25.2501, -0.0002440086260433219},
                                   {10.2501, 25.5001, -0.0002090390864952857},
                                   {10.2501, 25.7501, -0.0001789132846356786},
                                   {10.2501, 26.0001, -0.0001529883477547883},
                                   {10.2501, 26.2501, -0.0001307020719244305},
                                   {10.2501, 26.5001, -0.0001115635693235413},
                                   {10.2501, 26.7501, -0.0000951448720804053},
                                   {10.2501, 27.0001, -0.0000810734164996499},
                                   {10.2501, 27.2501, -0.00006902533366923631},
                                   {10.2501, 27.5001, -0.00005871947538072478},
                                   {10.2501, 27.7501, -0.00004991210781411574},
                                   {10.2501, 28.0001, -0.00004239220934520066},
                                   {10.2501, 28.2501, -0.00003597731297202664},
                                   {10.2501, 28.5001, -0.00003050983810148416},
                                   {10.2501, 28.7501, -0.00002585386068697926},
                                   {10.2501, 29.0001, -0.00002189227488575233},
                                   {10.2501, 29.2501, -0.00001852430345061187},
                                   {10.2501, 29.5001, -0.00001566331794241199},
                                   {10.2501, 29.7501, -0.00001323493351634363},
                                   {10.5001, 0.0001, -6.202906991523105e-15},
                                   {10.5001, 0.2501, -1.232322861541596e-13},
                                   {10.5001, 0.5001, -1.140685798462328e-10},
                                   {10.5001, 0.7501, -5.57839246153687e-9},
                                   {10.5001, 1.0001, -8.14767476966508e-8},
                                   {10.5001, 1.2501, -6.143039831604834e-7},
                                   {10.5001, 1.5001, -3.049984121645546e-6},
                                   {10.5001, 1.7501, -0.00001135348553059447},
                                   {10.5001, 2.0001, -0.00003423644889547251},
                                   {10.5001, 2.2501, -0.0000879103279543068},
                                   {10.5001, 2.5001, -0.0001988680360841404},
                                   {10.5001, 2.7501, -0.0004060702412288042},
                                   {10.5001, 3.0001, -0.0007619463043734208},
                                   {10.5001, 3.2501, -0.001331792739653076},
                                   {10.5001, 3.5001, -0.002191409293657762},
                                   {10.5001, 3.7501, -0.003423090211678474},
                                   {10.5001, 4.0001, -0.005110330368675711},
                                   {10.5001, 4.2501, -0.007331775327827499},
                                   {10.5001, 4.5001, -0.01015502446372958},
                                   {10.5001, 4.7501, -0.01363088875518505},
                                   {10.5001, 5.0001, -0.01778862458216631},
                                   {10.5001, 5.2501, -0.02263253405833117},
                                   {10.5001, 5.5001, -0.02814016540152455},
                                   {10.5001, 5.7501, -0.03426218602844993},
                                   {10.5001, 6.0001, -0.04092385451800296},
                                   {10.5001, 6.2501, -0.04802789784547397},
                                   {10.5001, 6.5001, -0.05545851424148436},
                                   {10.5001, 6.7501, -0.06308617157767083},
                                   {10.5001, 7.0001, -0.07077285428792043},
                                   {10.5001, 7.2501, -0.07837742372410814},
                                   {10.5001, 7.5001, -0.0857607911696889},
                                   {10.5001, 7.7501, -0.0927906525737588},
                                   {10.5001, 8.0001, -0.0993455927150577},
                                   {10.5001, 8.2501, -0.1053184280105072},
                                   {10.5001, 8.5001, -0.1106187166797101},
                                   {10.5001, 8.7501, -0.1151744188196703},
                                   {10.5001, 9.0001, -0.118932734701276},
                                   {10.5001, 9.2501, -0.1218601859455064},
                                   {10.5001, 9.5001, -0.1239420307835944},
                                   {10.5001, 9.7501, -0.1251811216987345},
                                   {10.5001, 10.0001, -0.1255963222675231},
                                   {10.5001, 10.2501, -0.1252206011902457},
                                   {10.5001, 10.5001, -0.124098916721411},
                                   {10.5001, 10.7501, -0.1222859954300657},
                                   {10.5001, 11.0001, -0.1198440968190692},
                                   {10.5001, 11.2501, -0.1168408410687487},
                                   {10.5001, 11.5001, -0.1133471621232582},
                                   {10.5001, 11.7501, -0.1094354333908164},
                                   {10.5001, 12.0001, -0.1051777991645909},
                                   {10.5001, 12.2501, -0.1006447319811299},
                                   {10.5001, 12.5001, -0.095903824837292},
                                   {10.5001, 12.7501, -0.0910188176554474},
                                   {10.5001, 13.0001, -0.0860488496690399},
                                   {10.5001, 13.2501, -0.0810479234495096},
                                   {10.5001, 13.5001, -0.07606456199362174},
                                   {10.5001, 13.7501, -0.07114163747195786},
                                   {10.5001, 14.0001, -0.0663163487105885},
                                   {10.5001, 14.2501, -0.06162032403200928},
                                   {10.5001, 14.5001, -0.05707982651149956},
                                   {10.5001, 14.7501, -0.05271603981380356},
                                   {10.5001, 15.0001, -0.04854541438113747},
                                   {10.5001, 15.2501, -0.04458005568595663},
                                   {10.5001, 15.5001, -0.0408281384020958},
                                   {10.5001, 15.7501, -0.03729433257031025},
                                   {10.5001, 16.0001, -0.03398023004586345},
                                   {10.5001, 16.2501, -0.03088476164461237},
                                   {10.5001, 16.5001, -0.02800459739702229},
                                   {10.5001, 16.7501, -0.02533452414034032},
                                   {10.5001, 17.0001, -0.02286779630559026},
                                   {10.5001, 17.2501, -0.02059645717765267},
                                   {10.5001, 17.5001, -0.01851162912236902},
                                   {10.5001, 17.7501, -0.01660377229048478},
                                   {10.5001, 18.0001, -0.01486291213576493},
                                   {10.5001, 18.2501, -0.01327883673887625},
                                   {10.5001, 18.5001, -0.0118412654270001},
                                   {10.5001, 18.7501, -0.01053999054011543},
                                   {10.5001, 19.0001, -0.00936499443719342},
                                   {10.5001, 19.2501, -0.00830654397742912},
                                   {10.5001, 19.5001, -0.007355264770381162},
                                   {10.5001, 19.7501, -0.006502197480459129},
                                   {10.5001, 20.0001, -0.005738838410010667},
                                   {10.5001, 20.2501, -0.005057166484091635},
                                   {10.5001, 20.5001, -0.004449658629954165},
                                   {10.5001, 20.7501, -0.00390929539482546},
                                   {10.5001, 21.0001, -0.003429558484590486},
                                   {10.5001, 21.2501, -0.003004421740015211},
                                   {10.5001, 21.5001, -0.00262833690133574},
                                   {10.5001, 21.7501, -0.00229621535042029},
                                   {10.5001, 22.0001, -0.002003406865307408},
                                   {10.5001, 22.2501, -0.001745676276894637},
                                   {10.5001, 22.5001, -0.00151917878333159},
                                   {10.5001, 22.7501, -0.001320434555095551},
                                   {10.5001, 23.0001, -0.001146303153148144},
                                   {10.5001, 23.2501, -0.000993958183957297},
                                   {10.5001, 23.5001, -0.000860862528196092},
                                   {10.5001, 23.7501, -0.0007447444040581733},
                                   {10.5001, 24.0001, -0.000643574460665468},
                                   {10.5001, 24.2501, -0.0005555440411962628},
                                   {10.5001, 24.5001, -0.0004790447082836005},
                                   {10.5001, 24.7501, -0.0004126490850584281},
                                   {10.5001, 25.0001, -0.0003550930330788076},
                                   {10.5001, 25.2501, -0.0003052591624627368},
                                   {10.5001, 25.5001, -0.0002621616490367606},
                                   {10.5001, 25.7501, -0.0002249323174867637},
                                   {10.5001, 26.0001, -0.0001928079376707998},
                                   {10.5001, 26.2501, -0.0001651186728079521},
                                   {10.5001, 26.5001, -0.0001412776126360584},
                                   {10.5001, 26.7501, -0.0001207713213402811},
                                   {10.5001, 27.0001, -0.0001031513286588114},
                                   {10.5001, 27.2501, -0.0000880264926922344},
                                   {10.5001, 27.5001, -0.00007505616425195555},
                                   {10.5001, 27.7501, -0.00006394408480091808},
                                   {10.5001, 28.0001, -0.00005443295293007423},
                                   {10.5001, 28.2501, -0.00004629959767872712},
                                   {10.5001, 28.5001, -0.00003935070068220787},
                                   {10.5001, 28.7501, -0.00003341901298266805},
                                   {10.5001, 29.0001, -0.00002836001626045354},
                                   {10.5001, 29.2501, -0.00002404898214946586},
                                   {10.5001, 29.5001, -0.00002037838712419231},
                                   {10.5001, 29.7501, -0.00001725564413899504},
                                   {10.7501, 0.0001, -6.281927161174083e-15},
                                   {10.7501, 0.2501, -4.923051297677389e-14},
                                   {10.7501, 0.5001, -5.284800286354723e-11},
                                   {10.7501, 0.7501, -2.861622160272359e-9},
                                   {10.7501, 1.0001, -4.493105912278482e-8},
                                   {10.7501, 1.2501, -3.583176680532571e-7},
                                   {10.7501, 1.5001, -1.862520920651824e-6},
                                   {10.7501, 1.7501, -7.207380481609001e-6},
                                   {10.7501, 2.0001, -0.00002247662287130453},
                                   {10.7501, 2.2501, -0.00005945071639254511},
                                   {10.7501, 2.5001, -0.0001381021982553956},
                                   {10.7501, 2.7501, -0.0002888401712154365},
                                   {10.7501, 3.0001, -0.0005539813940397722},
                                   {10.7501, 3.2501, -0.000988008262257145},
                                   {10.7501, 3.5001, -0.0016563501898917},
                                   {10.7501, 3.7501, -0.00263264820754449},
                                   {10.7501, 4.0001, -0.003994684867064263},
                                   {10.7501, 4.2501, -0.005819343808894649},
                                   {10.7501, 4.5001, -0.00817708127973391},
                                   {10.7501, 4.7501, -0.0111264366335047},
                                   {10.7501, 5.0001, -0.01470908467540718},
                                   {10.7501, 5.2501, -0.01894585304512299},
                                   {10.7501, 5.5001, -0.02383401097049413},
                                   {10.7501, 5.7501, -0.02934600101087525},
                                   {10.7501, 6.0001, -0.03542965041227946},
                                   {10.7501, 6.2501, -0.04200977739599861},
                                   {10.7501, 6.5001, -0.04899100968954256},
                                   {10.7501, 6.7501, -0.05626156305358769},
                                   {10.7501, 7.0001, -0.06369768771929576},
                                   {10.7501, 7.2501, -0.07116847869077475},
                                   {10.7501, 7.5001, -0.0785407577914235},
                                   {10.7501, 7.7501, -0.0856837658922576},
                                   {10.7501, 8.0001, -0.0924734472445618},
                                   {10.7501, 8.2501, -0.0987961586981388},
                                   {10.7501, 8.5001, -0.1045516898710488},
                                   {10.7501, 8.7501, -0.1096555319683034},
                                   {10.7501, 9.0001, -0.1140403798379094},
                                   {10.7501, 9.2501, -0.1176568919113234},
                                   {10.7501, 9.5001, -0.1204737647271143},
                                   {10.7501, 9.7501, -0.1224772023920411},
                                   {10.7501, 10.0001, -0.1236698768300825},
                                   {10.7501, 10.2501, -0.1240694827061928},
                                   {10.7501, 10.5001, -0.1237069924921861},
                                   {10.7501, 10.7501, -0.1226247134391673},
                                   {10.7501, 11.0001, -0.1208742404596112},
                                   {10.7501, 11.2501, -0.1185143882924},
                                   {10.7501, 11.5001, -0.1156091739165315},
                                   {10.7501, 11.7501, -0.1122259069441072},
                                   {10.7501, 12.0001, -0.108433432448662},
                                   {10.7501, 12.2501, -0.104300557990291},
                                   {10.7501, 12.5001, -0.0998946849404924},
                                   {10.7501, 12.7501, -0.0952806538936555},
                                   {10.7501, 13.0001, -0.0905198051543313},
                                   {10.7501, 13.2501, -0.0856692480761555},
                                   {10.7501, 13.5001, -0.0807813273786993},
                                   {10.7501, 13.7501, -0.07590327039595496},
                                   {10.7501, 14.0001, -0.07107699638166625},
                                   {10.7501, 14.2501, -0.06633906735018664},
                                   {10.7501, 14.5001, -0.06172075929003523},
                                   {10.7501, 14.7501, -0.05724823277059983},
                                   {10.7501, 15.0001, -0.05294278279586716},
                                   {10.7501, 15.2501, -0.04882114907999041},
                                   {10.7501, 15.5001, -0.04489586958155548},
                                   {10.7501, 15.7501, -0.04117566200892451},
                                   {10.7501, 16.0001, -0.03766581999010084},
                                   {10.7501, 16.2501, -0.03436861259887149},
                                   {10.7501, 16.5001, -0.03128367787487957},
                                   {10.7501, 16.7501, -0.02840840281621844},
                                   {10.7501, 17.0001, -0.02573828402179006},
                                   {10.7501, 17.2501, -0.02326726469284894},
                                   {10.7501, 17.5001, -0.02098804505570158},
                                   {10.7501, 17.7501, -0.01889236443627082},
                                   {10.7501, 18.0001, -0.01697125420504638},
                                   {10.7501, 18.2501, -0.0152152616260395},
                                   {10.7501, 18.5001, -0.01361464529776389},
                                   {10.7501, 18.7501, -0.01215954338250967},
                                   {10.7501, 19.0001, -0.01084011619822116},
                                   {10.7501, 19.2501, -0.00964666501164942},
                                   {10.7501, 19.5001, -0.00856972903850784},
                                   {10.7501, 19.7501, -0.007600162741853177},
                                   {10.7501, 20.0001, -0.006729195538566923},
                                   {10.7501, 20.2501, -0.005948475989087845},
                                   {10.7501, 20.5001, -0.005250102469509913},
                                   {10.7501, 20.7501, -0.004626642218414398},
                                   {10.7501, 21.0001, -0.004071140522499197},
                                   {10.7501, 21.2501, -0.003577121662947048},
                                   {10.7501, 21.5001, -0.003138583094964706},
                                   {10.7501, 21.7501, -0.002749984181245922},
                                   {10.7501, 22.0001, -0.002406230650394567},
                                   {10.7501, 22.2501, -0.002102655806763379},
                                   {10.7501, 22.5001, -0.001834999381060229},
                                   {10.7501, 22.7501, -0.001599384783080729},
                                   {10.7501, 23.0001, -0.001392295400084132},
                                   {10.7501, 23.2501, -0.001210550477193029},
                                   {10.7501, 23.5001, -0.001051281019930325},
                                   {10.7501, 23.7501, -0.000911906073467256},
                                   {10.7501, 24.0001, -0.0007901096579697557},
                                   {10.7501, 24.2501, -0.0006838185740538352},
                                   {10.7501, 24.5001, -0.0005911812361343079},
                                   {10.7501, 24.7501, -0.0005105476436430399},
                                   {10.7501, 25.0001, -0.0004404505599338623},
                                   {10.7501, 25.2501, -0.000379587935403352},
                                   {10.7501, 25.5001, -0.0003268065841746903},
                                   {10.7501, 25.7501, -0.0002810871018796794},
                                   {10.7501, 26.0001, -0.0002415299949363684},
                                   {10.7501, 26.2501, -0.0002073429786097893},
                                   {10.7501, 26.5001, -0.0001778293914674181},
                                   {10.7501, 26.7501, -0.0001523776670609156},
                                   {10.7501, 27.0001, -0.0001304517992988745},
                                   {10.7501, 27.2501, -0.0001115827355934441},
                                   {10.7501, 27.5001, -0.0000953606310905833},
                                   {10.7501, 27.7501, -0.0000814278978019744},
                                   {10.7501, 28.0001, -0.00006947298396425429},
                                   {10.7501, 28.2501, -0.00005922482121755747},
                                   {10.7501, 28.5001, -0.00005044788001718494},
                                   {10.7501, 28.7501, -0.00004293777689975697},
                                   {10.7501, 29.0001, -0.00003651738067830424},
                                   {10.7501, 29.2501, -0.00003103336822520212},
                                   {10.7501, 29.5001, -0.00002635318412599213},
                                   {10.7501, 29.7501, -0.00002236236207869871},
                                   {11.0001, 0.0001, -6.359332905189669e-15},
                                   {11.0001, 0.2501, -2.033830284881127e-14},
                                   {11.0001, 0.5001, -2.434542797257163e-11},
                                   {11.0001, 0.7501, -1.459574947757234e-9},
                                   {11.0001, 1.0001, -2.4635733747523e-8},
                                   {11.0001, 1.2501, -2.078045242799264e-7},
                                   {11.0001, 1.5001, -1.130845457598283e-6},
                                   {11.0001, 1.7501, -4.549056045587719e-6},
                                   {11.0001, 2.0001, -0.00001467122676425635},
                                   {11.0001, 2.2501, -0.00003997283981318889},
                                   {11.0001, 2.5001, -0.0000953509073411283},
                                   {11.0001, 2.7501, -0.0002042681943844208},
                                   {11.0001, 3.0001, -0.0004004524575336016},
                                   {11.0001, 3.2501, -0.000728732031398372},
                                   {11.0001, 3.5001, -0.001244694193799962},
                                   {11.0001, 3.7501, -0.002013018387029587},
                                   {11.0001, 4.0001, -0.003104525088466914},
                                   {11.0001, 4.2501, -0.004592157113740587},
                                   {11.0001, 4.5001, -0.006546246131353994},
                                   {11.0001, 4.7501, -0.0090294975028621},
                                   {11.0001, 5.0001, -0.01209214714359062},
                                   {11.0001, 5.2501, -0.01576771033055174},
                                   {11.0001, 5.5001, -0.02006966610683304},
                                   {11.0001, 5.7501, -0.0249893172124768},
                                   {11.0001, 6.0001, -0.03049494981364118},
                                   {11.0001, 6.2501, -0.03653230356143817},
                                   {11.0001, 6.5001, -0.04302626160631404},
                                   {11.0001, 6.7501, -0.04988358952972688},
                                   {11.0001, 7.0001, -0.05699649563490098},
                                   {11.0001, 7.2501, -0.06424675347066939},
                                   {11.0001, 7.5001, -0.07151011920273776},
                                   {11.0001, 7.7501, -0.07866078813157895},
                                   {11.0001, 8.0001, -0.0855756619180911},
                                   {11.0001, 8.2501, -0.0921382361724636},
                                   {11.0001, 8.5001, -0.0982419623658717},
                                   {11.0001, 8.7501, -0.1037929843969334},
                                   {11.0001, 9.0001, -0.1087121951478809},
                                   {11.0001, 9.2501, -0.1129365993717998},
                                   {11.0001, 9.5001, -0.1164200044563243},
                                   {11.0001, 9.7501, -0.1191330889692438},
                                   {11.0001, 10.0001, -0.1210629200275444},
                                   {11.0001, 10.2501, -0.1222120045984172},
                                   {11.0001, 10.5001, -0.1225969673944403},
                                   {11.0001, 10.7501, -0.122246949892983},
                                   {11.0001, 11.0001, -0.1212018221754841},
                                   {11.0001, 11.2501, -0.1195102927880413},
                                   {11.0001, 11.5001, -0.1172279926950572},
                                   {11.0001, 11.7501, -0.1144155985822142},
                                   {11.0001, 12.0001, -0.1111370491010638},
                                   {11.0001, 12.2501, -0.107457895838378},
                                   {11.0001, 12.5001, -0.1034438194004755},
                                   {11.0001, 12.7501, -0.0991593304476684},
                                   {11.0001, 13.0001, -0.0946666660884859},
                                   {11.0001, 13.2501, -0.0900248839239557},
                                   {11.0001, 13.5001, -0.0852891492977068},
                                   {11.0001, 13.7501, -0.0805102059575605},
                                   {11.0001, 14.0001, -0.07573401630701938},
                                   {11.0001, 14.2501, -0.07100155461495774},
                                   {11.0001, 14.5001, -0.0663487348240375},
                                   {11.0001, 14.7501, -0.06180645380183107},
                                   {11.0001, 15.0001, -0.05740073085650293},
                                   {11.0001, 15.2501, -0.05315292493685643},
                                   {11.0001, 15.5001, -0.0490800120089051},
                                   {11.0001, 15.7501, -0.04519490651506677},
                                   {11.0001, 16.0001, -0.04150681246031231},
                                   {11.0001, 16.2501, -0.03802159143164032},
                                   {11.0001, 16.5001, -0.03474213665965987},
                                   {11.0001, 16.7501, -0.03166874400690522},
                                   {11.0001, 17.0001, -0.02879947246519624},
                                   {11.0001, 17.2501, -0.0261304883261726},
                                   {11.0001, 17.5001, -0.02365638862947599},
                                   {11.0001, 17.7501, -0.02137050077667488},
                                   {11.0001, 18.0001, -0.01926515631920101},
                                   {11.0001, 18.2501, -0.01733193788542587},
                                   {11.0001, 18.5001, -0.0155618990109572},
                                   {11.0001, 18.7501, -0.01394575728658292},
                                   {11.0001, 19.0001, -0.01247406175201991},
                                   {11.0001, 19.2501, -0.011137335854386},
                                   {11.0001, 19.5001, -0.00992619757258107},
                                   {11.0001, 19.7501, -0.00883145849716616},
                                   {11.0001, 20.0001, -0.00784420376413494},
                                   {11.0001, 20.2501, -0.00695585478370675},
                                   {11.0001, 20.5001, -0.006158216694451504},
                                   {11.0001, 20.7501, -0.005443512420029477},
                                   {11.0001, 21.0001, -0.004804405120674434},
                                   {11.0001, 21.2501, -0.004234010723062987},
                                   {11.0001, 21.5001, -0.003725902087928898},
                                   {11.0001, 21.7501, -0.003274106241028503},
                                   {11.0001, 22.0001, -0.002873095955054229},
                                   {11.0001, 22.2501, -0.002517776832020976},
                                   {11.0001, 22.5001, -0.002203470900799839},
                                   {11.0001, 22.7501, -0.001925897615332664},
                                   {11.0001, 23.0001, -0.001681153017429553},
                                   {11.0001, 23.2501, -0.001465687715147643},
                                   {11.0001, 23.5001, -0.001276284224307236},
                                   {11.0001, 23.7501, -0.001110034127059759},
                                   {11.0001, 24.0001, -0.000964315417605597},
                                   {11.0001, 24.2501, -0.000836770330948857},
                                   {11.0001, 24.5001, -0.0007252838855677172},
                                   {11.0001, 24.7501, -0.000627963314538974},
                                   {11.0001, 25.0001, -0.0005431185113620098},
                                   {11.0001, 25.2501, -0.0004692435758065017},
                                   {11.0001, 25.5001, -0.0004049995108629459},
                                   {11.0001, 25.7501, -0.0003491980936078006},
                                   {11.0001, 26.0001, -0.0003007869198252695},
                                   {11.0001, 26.2501, -0.00025883560390479},
                                   {11.0001, 26.5001, -0.0002225231012454534},
                                   {11.0001, 26.7501, -0.0001911261095791099},
                                   {11.0001, 27.0001, -0.0001640084977543375},
                                   {11.0001, 27.2501, -0.0001406117051350106},
                                   {11.0001, 27.5001, -0.0001204460514405291},
                                   {11.0001, 27.7501, -0.0001030828952185367},
                                   {11.0001, 28.0001, -0.000088147578869555},
                                   {11.0001, 28.2501, -0.00007531309895356808},
                                   {11.0001, 28.5001, -0.00006429444215796931},
                                   {11.0001, 28.7501, -0.00005484352958721372},
                                   {11.0001, 29.0001, -0.00004674471477233471},
                                   {11.0001, 29.2501, -0.00003981078384752556},
                                   {11.0001, 29.5001, -0.00003387940958125635},
                                   {11.0001, 29.7501, -0.00002881001428335093},
                                   {11.2501, 0.0001, -6.435193064127478e-15},
                                   {11.2501, 0.2501, -9.13548628239937e-15},
                                   {11.2501, 0.5001, -1.115320125536666e-11},
                                   {11.2501, 0.7501, -7.402997256705014e-10},
                                   {11.2501, 1.0001, -1.343218124486743e-8},
                                   {11.2501, 1.2501, -1.198395490416211e-7},
                                   {11.2501, 1.5001, -6.827481641808357e-7},
                                   {11.2501, 1.7501, -2.855075067538496e-6},
                                   {11.2501, 2.0001, -9.52251691605052e-6},
                                   {11.2501, 2.2501, -0.00002672518183983325},
                                   {11.2501, 2.5001, -0.00006546283873392909},
                                   {11.2501, 2.7501, -0.0001436441205819053},
                                   {11.2501, 3.0001, -0.0002878385938337523},
                                   {11.2501, 3.2501, -0.0005344608169183676},
                                   {11.2501, 3.5001, -0.000930063184783474},
                                   {11.2501, 3.7501, -0.001530525590334768},
                                   {11.2501, 4.0001, -0.002399078730851163},
                                   {11.2501, 4.2501, -0.003603254575962869},
                                   {11.2501, 4.5001, -0.005210995606026751},
                                   {11.2501, 4.7501, -0.007286254901555866},
                                   {11.2501, 5.0001, -0.00988447211710677},
                                   {11.2501, 5.2501, -0.01304831460903265},
                                   {11.2501, 5.5001, -0.01680403424433374},
                                   {11.2501, 5.7501, -0.02115871899235055},
                                   {11.2501, 6.0001, -0.0260986267240291},
                                   {11.2501, 6.2501, -0.03158868920671849},
                                   {11.2501, 6.5001, -0.03757317810096305},
                                   {11.2501, 6.7501, -0.04397744043173838},
                                   {11.2501, 7.0001, -0.05071054428382517},
                                   {11.2501, 7.2501, -0.05766862932230908},
                                   {11.2501, 7.5001, -0.06473873165782408},
                                   {11.2501, 7.7501, -0.07180284709549799},
                                   {11.2501, 8.0001, -0.07874200808026631},
                                   {11.2501, 8.2501, -0.0854401740218376},
                                   {11.2501, 8.5001, -0.0917877681831575},
                                   {11.2501, 8.7501, -0.0976847330736042},
                                   {11.2501, 9.0001, -0.1030430168165182},
                                   {11.2501, 9.2501, -0.1077884423480969},
                                   {11.2501, 9.5001, -0.1118619473053311},
                                   {11.2501, 9.7501, -0.1152202135102407},
                                   {11.2501, 10.0001, -0.1178357301317226},
                                   {11.2501, 10.2501, -0.1196963535401703},
                                   {11.2501, 10.5001, -0.1208044396571019},
                                   {11.2501, 10.7501, -0.1211756316843822},
                                   {11.2501, 11.0001, -0.1208373881588725},
                                   {11.2501, 11.2501, -0.119827334146514},
                                   {11.2501, 11.5001, -0.1181915129543104},
                                   {11.2501, 11.7501, -0.1159826078834793},
                                   {11.2501, 12.0001, -0.1132581941007774},
                                   {11.2501, 12.2501, -0.1100790704063804},
                                   {11.2501, 12.5001, -0.1065077101538499},
                                   {11.2501, 12.7501, -0.1026068603391056},
                                   {11.2501, 13.0001, -0.0984383083097734},
                                   {11.2501, 13.2501, -0.0940618269297262},
                                   {11.2501, 13.5001, -0.0895343015405889},
                                   {11.2501, 13.7501, -0.0849090357796239},
                                   {11.2501, 14.0001, -0.0802352282570493},
                                   {11.2501, 14.2501, -0.07555760822434255},
                                   {11.2501, 14.5001, -0.07091621559546541},
                                   {11.2501, 14.7501, -0.06634630890369024},
                                   {11.2501, 15.0001, -0.06187838385911814},
                                   {11.2501, 15.2501, -0.05753828497982271},
                                   {11.2501, 15.5001, -0.05334739316664213},
                                   {11.2501, 15.7501, -0.04932287294766022},
                                   {11.2501, 16.0001, -0.045477964313079},
                                   {11.2501, 16.2501, -0.04182230548694318},
                                   {11.2501, 16.5001, -0.03836227454573147},
                                   {11.2501, 16.7501, -0.03510133941665452},
                                   {11.2501, 17.0001, -0.03204040740660917},
                                   {11.2501, 17.2501, -0.02917816697589692},
                                   {11.2501, 17.5001, -0.02651141594136279},
                                   {11.2501, 17.7501, -0.02403537164504743},
                                   {11.2501, 18.0001, -0.02174395983991107},
                                   {11.2501, 18.2501, -0.01963008011490237},
                                   {11.2501, 18.5001, -0.01768584660541663},
                                   {11.2501, 18.7501, -0.01590280351500737},
                                   {11.2501, 19.0001, -0.01427211561699123},
                                   {11.2501, 19.2501, -0.01278473442002757},
                                   {11.2501, 19.5001, -0.01143154108141367},
                                   {11.2501, 19.7501, -0.01020346744831159},
                                   {11.2501, 20.0001, -0.00909159681340528},
                                   {11.2501, 20.2501, -0.00808724610045449},
                                   {11.2501, 20.5001, -0.007182031259238562},
                                   {11.2501, 20.7501, -0.006367917660061907},
                                   {11.2501, 21.0001, -0.005637257245947661},
                                   {11.2501, 21.2501, -0.004982814135421886},
                                   {11.2501, 21.5001, -0.004397780278804746},
                                   {11.2501, 21.7501, -0.00387578266346561},
                                   {11.2501, 22.0001, -0.003410883444762636},
                                   {11.2501, 22.2501, -0.002997574254540466},
                                   {11.2501, 22.5001, -0.002630765812320941},
                                   {11.2501, 22.7501, -0.00230577383905173},
                                   {11.2501, 23.0001, -0.002018302152077681},
                                   {11.2501, 23.2501, -0.001764423704807122},
                                   {11.2501, 23.5001, -0.001540560226730081},
                                   {11.2501, 23.7501, -0.001343461019898912},
                                   {11.2501, 24.0001, -0.001170181377199983},
                                   {11.2501, 24.2501, -0.001018061005903749},
                                   {11.2501, 24.5001, -0.000884702767002457},
                                   {11.2501, 24.7501, -0.0007679519764580465},
                                   {11.2501, 25.0001, -0.0006658764582719488},
                                   {11.2501, 25.2501, -0.0005767474907368403},
                                   {11.2501, 25.5001, -0.0004990217457559504},
                                   {11.2501, 25.7501, -0.0004313242861003868},
                                   {11.2501, 26.0001, -0.0003724326562884168},
                                   {11.2501, 26.2501, -0.0003212620787879188},
                                   {11.2501, 26.5001, -0.0002768517478590435},
                                   {11.2501, 26.7501, -0.0002383521979931821},
                                   {11.2501, 27.0001, -0.0002050137120282197},
                                   {11.2501, 27.2501, -0.000176175725131788},
                                   {11.2501, 27.5001, -0.0001512571744906131},
                                   {11.2501, 27.7501, -0.0001297477403164387},
                                   {11.2501, 28.0001, -0.0001111999213126657},
                                   {11.2501, 28.2501, -0.0000952218867185285},
                                   {11.2501, 28.5001, -0.0000814710471772727},
                                   {11.2501, 28.7501, -0.00006964828771688591},
                                   {11.2501, 29.0001, -0.00005949280787651436},
                                   {11.2501, 29.2501, -0.00005077751628025432},
                                   {11.2501, 29.5001, -0.00004330492960232291},
                                   {11.2501, 29.7501, -0.00003690352875869335},
                                   {11.5001, 0.0001, -6.509572074065836e-15},
                                   {11.5001, 0.2501, -4.828272592436827e-15},
                                   {11.5001, 0.5001, -5.082222007425473e-12},
                                   {11.5001, 0.7501, -3.734304150818961e-10},
                                   {11.5001, 1.0001, -7.283558487698606e-9},
                                   {11.5001, 1.2501, -6.873180147815581e-8},
                                   {11.5001, 1.5001, -4.099464782528974e-7},
                                   {11.5001, 1.7501, -1.782052362754599e-6},
                                   {11.5001, 2.0001, -6.146691560151845e-6},
                                   {11.5001, 2.2501, -0.00001776963811571093},
                                   {11.5001, 2.5001, -0.00004469564294571533},
                                   {11.5001, 2.7501, -0.0001004554668626076},
                                   {11.5001, 3.0001, -0.0002057520194133125},
                                   {11.5001, 3.2501, -0.000389815789474941},
                                   {11.5001, 3.5001, -0.0006911246956872885},
                                   {11.5001, 3.7501, -0.001157247711606344},
                                   {11.5001, 4.0001, -0.001843679816970672},
                                   {11.5001, 4.2501, -0.002811665759834834},
                                   {11.5001, 4.5001, -0.00412513860665627},
                                   {11.5001, 4.7501, -0.00584700657395715},
                                   {11.5001, 5.0001, -0.00803509496213632},
                                   {11.5001, 5.2501, -0.01073808309760353},
                                   {11.5001, 5.5001, -0.0139917695604714},
                                   {11.5001, 5.7501, -0.0178159582628544},
                                   {11.5001, 6.0001, -0.02221219202512048},
                                   {11.5001, 6.2501, -0.02716247945594823},
                                   {11.5001, 6.5001, -0.03262907529982239},
                                   {11.5001, 6.7501, -0.03855529278988723},
                                   {11.5001, 7.0001, -0.04486725574709868},
                                   {11.5001, 7.2501, -0.05147644271530343},
                                   {11.5001, 7.5001, -0.0582828375761793},
                                   {11.5001, 7.7501, -0.06517848112128968},
                                   {11.5001, 8.0001, -0.07205121466542503},
                                   {11.5001, 8.2501, -0.0787884175450456},
                                   {11.5001, 8.5001, -0.085280562177243},
                                   {11.5001, 8.7501, -0.0914244399220478},
                                   {11.5001, 9.0001, -0.0971259450305438},
                                   {11.5001, 9.2501, -0.1023023395237364},
                                   {11.5001, 9.5001, -0.1068839564536333},
                                   {11.5001, 9.7501, -0.1108153307205742},
                                   {11.5001, 10.0001, -0.1140557740998422},
                                   {11.5001, 10.2501, -0.1165794335446217},
                                   {11.5001, 10.5001, -0.1183748888355311},
                                   {11.5001, 10.7501, -0.1194443572869809},
                                   {11.5001, 11.0001, -0.1198025798489585},
                                   {11.5001, 11.2501, -0.1194754651258028},
                                   {11.5001, 11.5001, -0.1184985662701378},
                                   {11.5001, 11.7501, -0.1169154611612877},
                                   {11.5001, 12.0001, -0.1147760995079736},
                                   {11.5001, 12.2501, -0.1121351722492756},
                                   {11.5001, 12.5001, -0.1090505495184051},
                                   {11.5001, 12.7501, -0.1055818240421182},
                                   {11.5001, 13.0001, -0.1017889876350407},
                                   {11.5001, 13.2501, -0.0977312597706175},
                                   {11.5001, 13.5001, -0.0934660793285978},
                                   {11.5001, 13.7501, -0.0890482637033235},
                                   {11.5001, 14.0001, -0.0845293336000724},
                                   {11.5001, 14.2501, -0.07995699707569535},
                                   {11.5001, 14.5001, -0.07537478267014029},
                                   {11.5001, 14.7501, -0.07082180876320004},
                                   {11.5001, 15.0001, -0.06633267448422918},
                                   {11.5001, 15.2501, -0.06193745649237123},
                                   {11.5001, 15.5001, -0.05766179561287653},
                                   {11.5001, 15.7501, -0.05352705754135133},
                                   {11.5001, 16.0001, -0.04955055249585671},
                                   {11.5001, 16.2501, -0.04574579969788467},
                                   {11.5001, 16.5001, -0.04212282379895896},
                                   {11.5001, 16.7501, -0.03868847175352821},
                                   {11.5001, 17.0001, -0.03544674009727454},
                                   {11.5001, 17.2501, -0.03239910406207547},
                                   {11.5001, 17.5001, -0.02954484139601943},
                                   {11.5001, 17.7501, -0.02688134512186029},
                                   {11.5001, 18.0001, -0.02440442073310907},
                                   {11.5001, 18.2501, -0.02210856447556023},
                                   {11.5001, 18.5001, -0.01998722038300925},
                                   {11.5001, 18.7501, -0.01803301462510744},
                                   {11.5001, 19.0001, -0.01623796648363456},
                                   {11.5001, 19.2501, -0.01459367590576173},
                                   {11.5001, 19.5001, -0.01309148809680635},
                                   {11.5001, 19.7501, -0.01172263602020427},
                                   {11.5001, 20.0001, -0.01047836197982046},
                                   {11.5001, 20.2501, -0.00935001968075842},
                                   {11.5001, 20.5001, -0.00832915831108025},
                                   {11.5001, 20.7501, -0.007407590269587036},
                                   {11.5001, 21.0001, -0.00657744419472813},
                                   {11.5001, 21.2501, -0.005831204936719862},
                                   {11.5001, 21.5001, -0.005161742068060118},
                                   {11.5001, 21.7501, -0.004562328454845302},
                                   {11.5001, 22.0001, -0.004026650319649428},
                                   {11.5001, 22.2501, -0.003548810122243859},
                                   {11.5001, 22.5001, -0.003123323472210553},
                                   {11.5001, 22.7501, -0.0027451111717419},
                                   {11.5001, 23.0001, -0.002409487371031982},
                                   {11.5001, 23.2501, -0.002112144705332268},
                                   {11.5001, 23.5001, -0.001849137174017708},
                                   {11.5001, 23.7501, -0.001616861419384647},
                                   {11.5001, 24.0001, -0.001412036967407978},
                                   {11.5001, 24.2501, -0.001231685904956583},
                                   {11.5001, 24.5001, -0.001073112388315932},
                                   {11.5001, 24.7501, -0.000933882306347794},
                                   {11.5001, 25.0001, -0.000811803358079429},
                                   {11.5001, 25.2501, -0.0007049057486539613},
                                   {11.5001, 25.5001, -0.0006114236589733482},
                                   {11.5001, 25.7501, -0.000529777602531833},
                                   {11.5001, 26.0001, -0.0004585577473297727},
                                   {11.5001, 26.2501, -0.0003965082508105101},
                                   {11.5001, 26.5001, -0.0003425126309068489},
                                   {11.5001, 26.7501, -0.0002955801759593663},
                                   {11.5001, 27.0001, -0.0002548333799380576},
                                   {11.5001, 27.2501, -0.0002194963765528274},
                                   {11.5001, 27.5001, -0.0001888843360029706},
                                   {11.5001, 27.7501, -0.0001623937808549754},
                                   {11.5001, 28.0001, -0.0001394937724552729},
                                   {11.5001, 28.2501, -0.0001197179160234313},
                                   {11.5001, 28.5001, -0.0001026571308142985},
                                   {11.5001, 28.7501, -0.0000879531312048264},
                                   {11.5001, 29.0001, -0.00007529256500826925},
                                   {11.5001, 29.2501, -0.00006440175653358048},
                                   {11.5001, 29.5001, -0.00005504200370981373},
                                   {11.5001, 29.7501, -0.00004700538083029199},
                                   {11.7501, 0.0001, -6.582530338429872e-15},
                                   {11.7501, 0.2501, -3.193390270477736e-15},
                                   {11.7501, 0.5001, -2.304030413294068e-12},
                                   {11.7501, 0.7501, -1.873632699405499e-10},
                                   {11.7501, 1.0001, -3.928332285446187e-9},
                                   {11.7501, 1.2501, -3.920841992374757e-8},
                                   {11.7501, 1.5001, -2.448245202575456e-7},
                                   {11.7501, 1.7501, -1.106323134285988e-6},
                                   {11.7501, 2.0001, -3.946276014797928e-6},
                                   {11.7501, 2.2501, -0.00001175143398215013},
                                   {11.7501, 2.5001, -0.00003035205483567954},
                                   {11.7501, 2.7501, -0.00006987312962064856},
                                   {11.7501, 3.0001, -0.0001462812159201652},
                                   {11.7501, 3.2501, -0.0002827814665227203},
                                   {11.7501, 3.5001, -0.0005107954455201851},
                                   {11.7501, 3.7501, -0.000870276954326829},
                                   {11.7501, 4.0001, -0.001409193935030421},
                                   {11.7501, 4.2501, -0.002182104841862473},
                                   {11.7501, 4.5001, -0.003247869209556522},
                                   {11.7501, 4.7501, -0.004666636542071557},
                                   {11.7501, 5.0001, -0.006496340727531452},
                                   {11.7501, 5.2501, -0.00878897984357761},
                                   {11.7501, 5.5001, -0.01158697996240306},
                                   {11.7501, 5.7501, -0.0149199279093688},
                                   {11.7501, 6.0001, -0.0188019171688289},
                                   {11.7501, 6.2501, -0.02322969088536038},
                                   {11.7501, 6.5001, -0.02818169470606318},
                                   {11.7501, 6.7501, -0.0336180782985683},
                                   {11.7501, 7.0001, -0.03948161486386967},
                                   {11.7501, 7.2501, -0.04569944828081193},
                                   {11.7501, 7.5001, -0.0521855312325875},
                                   {11.7501, 7.7501, -0.05884358650541332},
                                   {11.7501, 8.0001, -0.06557040773613553},
                                   {11.7501, 8.2501, -0.07225931405819863},
                                   {11.7501, 8.5001, -0.07880358328538972},
                                   {11.7501, 8.7501, -0.0850997078709083},
                                   {11.7501, 9.0001, -0.0910503440645387},
                                   {11.7501, 9.2501, -0.0965668546985483},
                                   {11.7501, 9.5001, -0.1015713773554187},
                                   {11.7501, 9.7501, -0.1059983801878292},
                                   {11.7501, 10.0001, -0.1097956957116117},
                                   {11.7501, 10.2501, -0.1129250472901391},
                                   {11.7501, 10.5001, -0.1153621030430105},
                                   {11.7501, 10.7501, -0.1170961072176534},
                                   {11.7501, 11.0001, -0.118129149673484},
                                   {11.7501, 11.2501, -0.1184751403237123},
                                   {11.7501, 11.5001, -0.1181585576299106},
                                   {11.7501, 11.7501, -0.1172130391408607},
                                   {11.7501, 12.0001, -0.1156798782626353},
                                   {11.7501, 12.2501, -0.1136064856045025},
                                   {11.7501, 12.5001, -0.1110448659995762},
                                   {11.7501, 12.7501, -0.1080501542276505},
                                   {11.7501, 13.0001, -0.104679244072444},
                                   {11.7501, 13.2501, -0.100989537043425},
                                   {11.7501, 13.5001, -0.0970378292123715},
                                   {11.7501, 13.7501, -0.0928793474004237},
                                   {11.7501, 14.0001, -0.0885669395674476},
                                   {11.7501, 14.2501, -0.0841504187973839},
                                   {11.7501, 14.5001, -0.07967605577734707},
                                   {11.7501, 14.7501, -0.075186211123226},
                                   {11.7501, 15.0001, -0.07071909626224277},
                                   {11.7501, 15.2501, -0.06630864976847678},
                                   {11.7501, 15.5001, -0.06198451496828014},
                                   {11.7501, 15.7501, -0.05777210418652494},
                                   {11.7501, 16.0001, -0.05369273508611714},
                                   {11.7501, 16.2501, -0.04976382505832269},
                                   {11.7501, 16.5001, -0.04599913045193841},
                                   {11.7501, 16.7501, -0.04240901849528194},
                                   {11.7501, 17.0001, -0.039000760986512},
                                   {11.7501, 17.2501, -0.03577884013602279},
                                   {11.7501, 17.5001, -0.03274525828188249},
                                   {11.7501, 17.7501, -0.0298998445187328},
                                   {11.7501, 18.0001, -0.02724055254572423},
                                   {11.7501, 18.2501, -0.02476374522278294},
                                   {11.7501, 18.5001, -0.02246446240792541},
                                   {11.7501, 18.7501, -0.02033666961973742},
                                   {11.7501, 19.0001, -0.01837348592278328},
                                   {11.7501, 19.2501, -0.01656739016875548},
                                   {11.7501, 19.5001, -0.01491040534559729},
                                   {11.7501, 19.7501, -0.0133942612965133},
                                   {11.7501, 20.0001, -0.01201053647867373},
                                   {11.7501, 20.2501, -0.01075077974682671},
                                   {11.7501, 20.5001, -0.00960661338002319},
                                   {11.7501, 20.7501, -0.00856981873057429},
                                   {11.7501, 21.0001, -0.007632405973430048},
                                   {11.7501, 21.2501, -0.006786669481221798},
                                   {11.7501, 21.5001, -0.006025230354459508},
                                   {11.7501, 21.7501, -0.005341067606278472},
                                   {11.7501, 22.0001, -0.00472753944429783},
                                   {11.7501, 22.2501, -0.00417839601531697},
                                   {11.7501, 22.5001, -0.003687784887579664},
                                   {11.7501, 22.7501, -0.003250250445166092},
                                   {11.7501, 23.0001, -0.002860728263903757},
                                   {11.7501, 23.2501, -0.002514535431443035},
                                   {11.7501, 23.5001, -0.002207357668563574},
                                   {11.7501, 23.7501, -0.001935234006498961},
                                   {11.7501, 24.0001, -0.001694539677692318},
                                   {11.7501, 24.2501, -0.001481967786070205},
                                   {11.7501, 24.5001, -0.00129451023840372},
                                   {11.7501, 24.7501, -0.001129438341049263},
                                   {11.7501, 25.0001, -0.000984283396498788},
                                   {11.7501, 25.2501, -0.000856817571683056},
                                   {11.7501, 25.5001, -0.0007450352546609967},
                                   {11.7501, 25.7501, -0.0006471350678717024},
                                   {11.7501, 26.0001, -0.0005615026641136518},
                                   {11.7501, 26.2501, -0.0004866943953813797},
                                   {11.7501, 26.5001, -0.0004214219141323886},
                                   {11.7501, 26.7501, -0.0003645377409616155},
                                   {11.7501, 27.0001, -0.0003150218115136524},
                                   {11.7501, 27.2501, -0.0002719689982636476},
                                   {11.7501, 27.5001, -0.0002345775890679434},
                                   {11.7501, 27.7501, -0.0002021386936748723},
                                   {11.7501, 28.0001, -0.0001740265412770373},
                                   {11.7501, 28.2501, -0.0001496896262959946},
                                   {11.7501, 28.5001, -0.0001286426555715276},
                                   {11.7501, 28.7501, -0.0001104592476693676},
                                   {11.7501, 29.0001, -0.0000947653338467917},
                                   {11.7501, 29.2501, -0.0000812332100817191},
                                   {11.7501, 29.5001, -0.00006957619026566441},
                                   {11.7501, 29.7501, -0.00005954381200104384},
                                   {12.0001, 0.0001, -6.654124575584188e-15},
                                   {12.0001, 0.2501, -2.588139766027245e-15},
                                   {12.0001, 0.5001, -1.039639926878904e-12},
                                   {12.0001, 0.7501, -9.35151539054412e-11},
                                   {12.0001, 1.0001, -2.107607312440786e-9},
                                   {12.0001, 1.2501, -2.224920381264334e-8},
                                   {12.0001, 1.5001, -1.454431906826584e-7},
                                   {12.0001, 1.7501, -6.83206262339784e-7},
                                   {12.0001, 2.0001, -2.520227062222361e-6},
                                   {12.0001, 2.2501, -7.730496881232041e-6},
                                   {12.0001, 2.5001, -0.00002050281705512694},
                                   {12.0001, 2.7501, -0.0000483445765265507},
                                   {12.0001, 3.0001, -0.0001034504785330213},
                                   {12.0001, 3.2501, -0.000204051877515171},
                                   {12.0001, 3.5001, -0.0003755212343173228},
                                   {12.0001, 3.7501, -0.0006510050215502004},
                                   {12.0001, 4.0001, -0.001071397497617145},
                                   {12.0001, 4.2501, -0.001684539082801679},
                                   {12.0001, 4.5001, -0.002543613331133219},
                                   {12.0001, 4.7501, -0.003704810633129926},
                                   {12.0001, 5.0001, -0.00522441096593321},
                                   {12.0001, 5.2501, -0.007155501688826561},
                                   {12.0001, 5.5001, -0.00954458335221321},
                                   {12.0001, 5.7501, -0.01242832495673704},
                                   {12.0001, 6.0001, -0.01583071210069063},
                                   {12.0001, 6.2501, -0.01976079184308162},
                                   {12.0001, 6.5001, -0.02421116341089108},
                                   {12.0001, 6.7501, -0.02915730118818544},
                                   {12.0001, 7.0001, -0.0345577324984363},
                                   {12.0001, 7.2501, -0.0403550332882396},
                                   {12.0001, 7.5001, -0.04647755430853817},
                                   {12.0001, 7.7501, -0.05284175159479921},
                                   {12.0001, 8.0001, -0.05935496929934368},
                                   {12.0001, 8.2501, -0.06591851024219018},
                                   {12.0001, 8.5001, -0.07243082888971153},
                                   {12.0001, 8.7501, -0.07879069106725822},
                                   {12.0001, 9.0001, -0.0849001623416645},
                                   {12.0001, 9.2501, -0.0906673102744953},
                                   {12.0001, 9.5001, -0.0960085322936488},
                                   {12.0001, 9.7501, -0.1008504486168641},
                                   {12.0001, 10.0001, -0.105131326665085},
                                   {12.0001, 10.2501, -0.1088020282885615},
                                   {12.0001, 10.5001, -0.1118264928570567},
                                   {12.0001, 10.7501, -0.1141817871864754},
                                   {12.0001, 11.0001, -0.1158577670835878},
                                   {12.0001, 11.2501, -0.116856404977411},
                                   {12.0001, 11.5001, -0.1171908438915174},
                                   {12.0001, 11.7501, -0.1168842402872178},
                                   {12.0001, 12.0001, -0.1159684575755191},
                                   {12.0001, 12.2501, -0.1144826689172151},
                                   {12.0001, 12.5001, -0.1124719228817677},
                                   {12.0001, 12.7501, -0.1099857191736141},
                                   {12.0001, 13.0001, -0.1070766344708919},
                                   {12.0001, 13.2501, -0.1037990309058065},
                                   {12.0001, 13.5001, -0.1002078722254601},
                                   {12.0001, 13.7501, -0.0963576655088914},
                                   {12.0001, 14.0001, -0.0923015397080185},
                                   {12.0001, 14.2501, -0.0880904663854821},
                                   {12.0001, 14.5001, -0.0837726229373534},
                                   {12.0001, 14.7501, -0.07939289435641514},
                                   {12.0001, 15.0001, -0.07499250621154294},
                                   {12.0001, 15.2501, -0.07060877895555002},
                                   {12.0001, 15.5001, -0.06627499186715573},
                                   {12.0001, 15.7501, -0.06202034380454114},
                                   {12.0001, 16.0001, -0.05786999740992181},
                                   {12.0001, 16.2501, -0.05384519336387724},
                                   {12.0001, 16.5001, -0.04996342165227934},
                                   {12.0001, 16.7501, -0.04623863748894336},
                                   {12.0001, 17.0001, -0.04268151045155376},
                                   {12.0001, 17.2501, -0.03929969646333105},
                                   {12.0001, 17.5001, -0.03609812342401691},
                                   {12.0001, 17.7501, -0.03307928250656019},
                                   {12.0001, 18.0001, -0.03024351834558237},
                                   {12.0001, 18.2501, -0.02758931251472293},
                                   {12.0001, 18.5001, -0.0251135557952839},
                                   {12.0001, 18.7501, -0.02281180575882255},
                                   {12.0001, 19.0001, -0.02067852710877672},
                                   {12.0001, 19.2501, -0.01870731304380784},
                                   {12.0001, 19.5001, -0.01689108661596348},
                                   {12.0001, 19.7501, -0.01522228166138952},
                                   {12.0001, 20.0001, -0.01369300338445557},
                                   {12.0001, 20.2501, -0.01229516908421355},
                                   {12.0001, 20.5001, -0.0110206298329669},
                                   {12.0001, 20.7501, -0.00986127415915962},
                                   {12.0001, 21.0001, -0.00880911495999526},
                                   {12.0001, 21.2501, -0.007856360982411457},
                                   {12.0001, 21.5001, -0.006995474273263369},
                                   {12.0001, 21.7501, -0.006219215019344231},
                                   {12.0001, 22.0001, -0.005520675183109609},
                                   {12.0001, 22.2501, -0.004893302297872086},
                                   {12.0001, 22.5001, -0.004330914723222923},
                                   {12.0001, 22.7501, -0.003827709583154675},
                                   {12.0001, 23.0001, -0.003378264520664062},
                                   {12.0001, 23.2501, -0.002977534307621979},
                                   {12.0001, 23.5001, -0.002620843250823588},
                                   {12.0001, 23.7501, -0.00230387423715173},
                                   {12.0001, 24.0001, -0.002022655164900768},
                                   {12.0001, 24.2501, -0.001773543416204139},
                                   {12.0001, 24.5001, -0.001553208938431863},
                                   {12.0001, 24.7501, -0.001358616421238293},
                                   {12.0001, 25.0001, -0.001187006981189276},
                                   {12.0001, 25.2501, -0.001035879697861289},
                                   {12.0001, 25.5001, -0.000902973284048471},
                                   {12.0001, 25.7501, -0.0007862481181330894},
                                   {12.0001, 26.0001, -0.0006838688185376666},
                                   {12.0001, 26.2501, -0.0005941874981536608},
                                   {12.0001, 26.5001, -0.0005157278003365019},
                                   {12.0001, 26.7501, -0.0004471697870314498},
                                   {12.0001, 27.0001, -0.0003873357233878431},
                                   {12.0001, 27.2501, -0.000335176781362636},
                                   {12.0001, 27.5001, -0.000289760666844974},
                                   {12.0001, 27.7501, -0.00025026016030449},
                                   {12.0001, 28.0001, -0.0002159425494516189},
                                   {12.0001, 28.2501, -0.0001861599235002756},
                                   {12.0001, 28.5001, -0.0001603402919735752},
                                   {12.0001, 28.7501, -0.0001379794862555996},
                                   {12.0001, 29.0001, -0.0001186337989626328},
                                   {12.0001, 29.2501, -0.0001019133144138462},
                                   {12.0001, 29.5001, -0.0000874758827831521},
                                   {12.0001, 29.7501, -0.00007502169069928183},
                                   {12.2501, 0.0001, -6.724408054319752e-15},
                                   {12.2501, 0.2501, -2.377248610217019e-15},
                                   {12.2501, 0.5001, -4.672863851044448e-13},
                                   {12.2501, 0.7501, -4.643563663599022e-11},
                                   {12.2501, 1.0001, -1.124955585713522e-9},
                                   {12.2501, 1.2501, -1.256060446343079e-8},
                                   {12.2501, 1.5001, -8.59587584786751e-8},
                                   {12.2501, 1.7501, -4.197373634547919e-7},
                                   {12.2501, 2.0001, -1.601200761090603e-6},
                                   {12.2501, 2.2501, -5.059132188920009e-6},
                                   {12.2501, 2.5001, -0.00001377810182608531},
                                   {12.2501, 2.7501, -0.0000332762381825109},
                                   {12.2501, 3.0001, -0.00007278199398800817},
                                   {12.2501, 3.2501, -0.0001464793682716095},
                                   {12.2501, 3.5001, -0.0002746420231470319},
                                   {12.2501, 3.7501, -0.0004844568197985079},
                                   {12.2501, 4.0001, -0.000810351261114891},
                                   {12.2501, 4.2501, -0.001293684561608603},
                                   {12.2501, 4.5001, -0.001981730238155492},
                                   {12.2501, 4.7501, -0.002925957687280173},
                                   {12.2501, 5.0001, -0.004179699032786546},
                                   {12.2501, 5.2501, -0.005795354962089903},
                                   {12.2501, 5.5001, -0.007821341617065809},
                                   {12.2501, 5.7501, -0.0102990057061176},
                                   {12.2501, 6.0001, -0.01325973618480158},
                                   {12.2501, 6.2501, -0.01672248037850464},
                                   {12.2501, 6.5001, -0.02069183467274996},
                                   {12.2501, 6.7501, -0.02515683045568608},
                                   {12.2501, 7.0001, -0.03009048078743277},
                                   {12.2501, 7.2501, -0.03545009785450473},
                                   {12.2501, 7.5001, -0.04117834033914216},
                                   {12.2501, 7.7501, -0.04720490692219098},
                                   {12.2501, 8.0001, -0.05344875949852704},
                                   {12.2501, 8.2501, -0.05982073833853939},
                                   {12.2501, 8.5001, -0.06622642132122174},
                                   {12.2501, 8.7501, -0.07256907957676444},
                                   {12.2501, 9.0001, -0.0787525908783519},
                                   {12.2501, 9.2501, -0.0846841880145007},
                                   {12.2501, 9.5001, -0.0902769401069558},
                                   {12.2501, 9.7501, -0.0954518884021545},
                                   {12.2501, 10.0001, -0.1001397826179144},
                                   {12.2501, 10.2501, -0.1042823879010917},
                                   {12.2501, 10.5001, -0.1078333545976905},
                                   {12.2501, 10.7501, -0.1107586624445753},
                                   {12.2501, 11.0001, -0.1130366668805819},
                                   {12.2501, 11.2501, -0.114657787661484},
                                   {12.2501, 11.5001, -0.1156238888192192},
                                   {12.2501, 11.7501, -0.1159474044058001},
                                   {12.2501, 12.0001, -0.1156502667325003},
                                   {12.2501, 12.2501, -0.1147626933825911},
                                   {12.2501, 12.5001, -0.1133218866248636},
                                   {12.2501, 12.7501, -0.1113706944874046},
                                   {12.2501, 13.0001, -0.1089562771561545},
                                   {12.2501, 13.2501, -0.1061288159947766},
                                   {12.2501, 13.5001, -0.1029402957440693},
                                   {12.2501, 13.7501, -0.0994433836924903},
                                   {12.2501, 14.0001, -0.0956904230913679},
                                   {12.2501, 14.2501, -0.0917325520313764},
                                   {12.2501, 14.5001, -0.0876189535520658},
                                   {12.2501, 14.7501, -0.0833962380195348},
                                   {12.2501, 15.0001, -0.07910795482655285},
                                   {12.2501, 15.2501, -0.07479422725233564},
                                   {12.2501, 15.5001, -0.07049150184154324},
                                   {12.2501, 15.7501, -0.06623240187551007},
                                   {12.2501, 16.0001, -0.06204567334780949},
                                   {12.2501, 16.2501, -0.05795621124487215},
                                   {12.2501, 16.5001, -0.05398515378906508},
                                   {12.2501, 16.7501, -0.05015003254401933},
                                   {12.2501, 17.0001, -0.0464649668302341},
                                   {12.2501, 17.2501, -0.04294089167835097},
                                   {12.2501, 17.5001, -0.03958580949014905},
                                   {12.2501, 17.7501, -0.0364050566234088},
                                   {12.2501, 18.0001, -0.03340157721499604},
                                   {12.2501, 18.2501, -0.03057619766407994},
                                   {12.2501, 18.5001, -0.0279278962798692},
                                   {12.2501, 18.7501, -0.02545406362893811},
                                   {12.2501, 19.0001, -0.0231507500764654},
                                   {12.2501, 19.2501, -0.02101289789008724},
                                   {12.2501, 19.5001, -0.019034556056485},
                                   {12.2501, 19.7501, -0.01720907664567732},
                                   {12.2501, 20.0001, -0.01552929214629713},
                                   {12.2501, 20.2501, -0.01398767368980056},
                                   {12.2501, 20.5001, -0.01257647048762586},
                                   {12.2501, 20.7501, -0.01128783112938055},
                                   {12.2501, 21.0001, -0.0101139076397683},
                                   {12.2501, 21.2501, -0.00904694337530473},
                                   {12.2501, 21.5001, -0.00807934596723076},
                                   {12.2501, 21.7501, -0.007203746592620437},
                                   {12.2501, 22.0001, -0.006413046889374735},
                                   {12.2501, 22.2501, -0.00570045482998},
                                   {12.2501, 22.5001, -0.005059510840373303},
                                   {12.2501, 22.7501, -0.004484105400112884},
                                   {12.2501, 23.0001, -0.003968489293717491},
                                   {12.2501, 23.2501, -0.003507277605229801},
                                   {12.2501, 23.5001, -0.00309544846281057},
                                   {12.2501, 23.7501, -0.002728337450869992},
                                   {12.2501, 24.0001, -0.002401628516679863},
                                   {12.2501, 24.2501, -0.002111342108828229},
                                   {12.2501, 24.5001, -0.001853821198032846},
                                   {12.2501, 24.7501, -0.001625715748048229},
                                   {12.2501, 25.0001, -0.001423966126638973},
                                   {12.2501, 25.2501, -0.001245785874489682},
                                   {12.2501, 25.5001, -0.001088644183855337},
                                   {12.2501, 25.7501, -0.000950248378884863},
                                   {12.2501, 26.0001, -0.000828526635860801},
                                   {12.2501, 26.2501, -0.0007216111339390912},
                                   {12.2501, 26.5001, -0.0006278217850919109},
                                   {12.2501, 26.7501, -0.0005456506555254837},
                                   {12.2501, 27.0001, -0.0004737471594854512},
                                   {12.2501, 27.2501, -0.0004109040796656912},
                                   {12.2501, 27.5001, -0.0003560444459789208},
                                   {12.2501, 27.7501, -0.0003082092858040673},
                                   {12.2501, 28.0001, -0.0002665462435800267},
                                   {12.2501, 28.2501, -0.0002302990553680887},
                                   {12.2501, 28.5001, -0.0001987978543779641},
                                   {12.2501, 28.7501, -0.0001714502760925194},
                                   {12.2501, 29.0001, -0.0001477333262094936},
                                   {12.2501, 29.2501, -0.0001271859708491113},
                                   {12.2501, 29.5001, -0.0001094024060883127},
                                   {12.2501, 29.7501, -0.0000940259626376115},
                                   {12.5001, 0.0001, -6.793430969145543e-15},
                                   {12.5001, 0.2501, -2.316425945025649e-15},
                                   {12.5001, 0.5001, -2.095629779498547e-13},
                                   {12.5001, 0.7501, -2.294257094768803e-11},
                                   {12.5001, 1.0001, -5.974350720670757e-10},
                                   {12.5001, 1.2501, -7.05525998293054e-9},
                                   {12.5001, 1.5001, -5.054645792111901e-8},
                                   {12.5001, 1.7501, -2.565695190634427e-7},
                                   {12.5001, 2.0001, -1.012165632927089e-6},
                                   {12.5001, 2.2501, -3.294143955749393e-6},
                                   {12.5001, 2.5001, -9.21216237356713e-6},
                                   {12.5001, 2.7501, -0.0000227884914389849},
                                   {12.5001, 3.0001, -0.00005094586573532974},
                                   {12.5001, 3.2501, -0.000104617571349146},
                                   {12.5001, 3.5001, -0.0001998437811070479},
                                   {12.5001, 3.7501, -0.0003586872078856626},
                                   {12.5001, 4.0001, -0.0006097966892397125},
                                   {12.5001, 4.2501, -0.000988470719177371},
                                   {12.5001, 4.5001, -0.001536120149352648},
                                   {12.5001, 4.7501, -0.002299092359032525},
                                   {12.5001, 5.0001, -0.003326888338403016},
                                   {12.5001, 5.2501, -0.004669869610557376},
                                   {12.5001, 5.5001, -0.006376605594220617},
                                   {12.5001, 5.7501, -0.00849104827960376},
                                   {12.5001, 6.0001, -0.01104973724550048},
                                   {12.5001, 6.2501, -0.01407923413513353},
                                   {12.5001, 6.5001, -0.01759396405015293},
                                   {12.5001, 6.7501, -0.02159460582819231},
                                   {12.5001, 7.0001, -0.02606712861410884},
                                   {12.5001, 7.2501, -0.03098252348134684},
                                   {12.5001, 7.5001, -0.03629723070880902},
                                   {12.5001, 7.7501, -0.04195421951796402},
                                   {12.5001, 8.0001, -0.04788464049163196},
                                   {12.5001, 8.2501, -0.05400994333687001},
                                   {12.5001, 8.5001, -0.06024433490728638},
                                   {12.5001, 8.7501, -0.06649744436071028},
                                   {12.5001, 9.0001, -0.07267706318039729},
                                   {12.5001, 9.2501, -0.0786918362069961},
                                   {12.5001, 9.5001, -0.0844537941822104},
                                   {12.5001, 9.7501, -0.0898806368366567},
                                   {12.5001, 10.0001, -0.0948976965348248},
                                   {12.5001, 10.2501, -0.0994395343348978},
                                   {12.5001, 10.5001, -0.103451141671007},
                                   {12.5001, 10.7501, -0.1068887406319824},
                                   {12.5001, 11.0001, -0.1097201931934651},
                                   {12.5001, 11.2501, -0.1119250442401237},
                                   {12.5001, 11.5001, -0.1134942345292771},
                                   {12.5001, 11.7501, -0.114429527855035},
                                   {12.5001, 12.0001, -0.1147427017105725},
                                   {12.5001, 12.2501, -0.1144545529875964},
                                   {12.5001, 12.5001, -0.1135937700609026},
                                   {12.5001, 12.7501, -0.1121957204001068},
                                   {12.5001, 13.0001, -0.1103011990683088},
                                   {12.5001, 13.2501, -0.1079551785398317},
                                   {12.5001, 13.5001, -0.1052055945998348},
                                   {12.5001, 13.7501, -0.1021021970387891},
                                   {12.5001, 14.0001, -0.0986954877343815},
                                   {12.5001, 14.2501, -0.0950357627763837},
                                   {12.5001, 14.5001, -0.0911722697340535},
                                   {12.5001, 14.7501, -0.0871524861344422},
                                   {12.5001, 15.0001, -0.083021520807957},
                                   {12.5001, 15.2501, -0.07882163601569177},
                                   {12.5001, 15.5001, -0.07459188521578255},
                                   {12.5001, 15.7501, -0.07036785893812809},
                                   {12.5001, 16.0001, -0.06618152948013214},
                                   {12.5001, 16.2501, -0.06206118395607792},
                                   {12.5001, 16.5001, -0.05803143456390116},
                                   {12.5001, 16.7501, -0.05411329470411944},
                                   {12.5001, 17.0001, -0.05032430972326843},
                                   {12.5001, 17.2501, -0.04667873148654126},
                                   {12.5001, 17.5001, -0.04318772664342796},
                                   {12.5001, 17.7501, -0.03985960927363021},
                                   {12.5001, 18.0001, -0.03670008953277089},
                                   {12.5001, 18.2501, -0.03371253091020061},
                                   {12.5001, 18.5001, -0.03089820972387718},
                                   {12.5001, 18.7501, -0.02825657147664573},
                                   {12.5001, 19.0001, -0.02578547965809857},
                                   {12.5001, 19.2501, -0.02348145347683245},
                                   {12.5001, 19.5001, -0.02133989183540126},
                                   {12.5001, 19.7501, -0.01935528160567234},
                                   {12.5001, 20.0001, -0.01752138892097626},
                                   {12.5001, 20.2501, -0.01583143277225717},
                                   {12.5001, 20.5001, -0.01427824068004808},
                                   {12.5001, 20.7501, -0.01285438661634848},
                                   {12.5001, 21.0001, -0.01155231167578171},
                                   {12.5001, 21.2501, -0.01036442825025452},
                                   {12.5001, 21.5001, -0.00928320865287928},
                                   {12.5001, 21.7501, -0.00830125927259499},
                                   {12.5001, 22.0001, -0.0074113814281961},
                                   {12.5001, 22.2501, -0.006606620136592756},
                                   {12.5001, 22.5001, -0.005880302021951823},
                                   {12.5001, 22.7501, -0.005226063576276728},
                                   {12.5001, 23.0001, -0.004637870943775619},
                                   {12.5001, 23.2501, -0.004110032346227566},
                                   {12.5001, 23.5001, -0.003637204199042635},
                                   {12.5001, 23.7501, -0.003214391891761808},
                                   {12.5001, 24.0001, -0.002836946125698606},
                                   {12.5001, 24.2501, -0.002500555618070216},
                                   {12.5001, 24.5001, -0.002201236898571618},
                                   {12.5001, 24.7501, -0.001935321842718005},
                                   {12.5001, 25.0001, -0.00169944350781256},
                                   {12.5001, 25.2501, -0.001490520763122224},
                                   {12.5001, 25.5001, -0.001305742136487738},
                                   {12.5001, 25.7501, -0.001142549235618233},
                                   {12.5001, 26.0001, -0.000998620043970022},
                                   {12.5001, 26.2501, -0.000871852338451914},
                                   {12.5001, 26.5001, -0.0007603474291624329},
                                   {12.5001, 26.7501, -0.0006623943797660048},
                                   {12.5001, 27.0001, -0.0005764548306923433},
                                   {12.5001, 27.2501, -0.000501148515775343},
                                   {12.5001, 27.5001, -0.0004352395358763397},
                                   {12.5001, 27.7501, -0.0003776234300820227},
                                   {12.5001, 28.0001, -0.0003273150658420128},
                                   {12.5001, 28.2501, -0.0002834373535302221},
                                   {12.5001, 28.5001, -0.0002452107780034647},
                                   {12.5001, 28.7501, -0.0002119437294331783},
                                   {12.5001, 29.0001, -0.0001830236076655306},
                                   {12.5001, 29.2501, -0.0001579086683097217},
                                   {12.5001, 29.5001, -0.0001361205743777547},
                                   {12.5001, 29.7501, -0.0001172376143415735},
                                   {12.7501, 0.0001, -6.861240603543228e-15},
                                   {12.7501, 0.2501, -2.312251410247876e-15},
                                   {12.7501, 0.5001, -9.4116523662075e-14},
                                   {12.7501, 0.7501, -1.127992545732429e-11},
                                   {12.7501, 1.0001, -3.157180944561669e-10},
                                   {12.7501, 1.2501, -3.943352465918052e-9},
                                   {12.7501, 1.5001, -2.957596642040658e-8},
                                   {12.7501, 1.7501, -1.560551089430728e-7},
                                   {12.7501, 2.0001, -6.366503955229506e-7},
                                   {12.7501, 2.2501, -2.134278393125929e-6},
                                   {12.7501, 2.5001, -6.128782402471835e-6},
                                   {12.7501, 2.7501, -0.00001552873077752279},
                                   {12.7501, 3.0001, -0.00003548392832447155},
                                   {12.7501, 3.2501, -0.00007434801379870784},
                                   {12.7501, 3.5001, -0.0001446937396739727},
                                   {12.7501, 3.7501, -0.0002642476429618172},
                                   {12.7501, 4.0001, -0.0004565940613293725},
                                   {12.7501, 4.2501, -0.0007515047887884625},
                                   {12.7501, 4.5001, -0.001184779411200211},
                                   {12.7501, 4.7501, -0.001797527882606829},
                                   {12.7501, 5.0001, -0.002634883989625436},
                                   {12.7501, 5.2501, -0.003744197797630373},
                                   {12.7501, 5.5001, -0.005172809224925883},
                                   {12.7501, 5.7501, -0.006965547333258602},
                                   {12.7501, 6.0001, -0.00916212670976567},
                                   {12.7501, 6.2501, -0.01179462176286985},
                                   {12.7501, 6.5001, -0.0148851923658119},
                                   {12.7501, 6.7501, -0.01844421232152407},
                                   {12.7501, 7.0001, -0.02246891906086844},
                                   {12.7501, 7.2501, -0.02694266291089132},
                                   {12.7501, 7.5001, -0.03183479135248546},
                                   {12.7501, 7.7501, -0.03710116175098191},
                                   {12.7501, 8.0001, -0.04268523825826974},
                                   {12.7501, 8.2501, -0.04851969729192648},
                                   {12.7501, 8.5001, -0.0545284426502707},
                                   {12.7501, 8.7501, -0.06062891652881673},
                                   {12.7501, 9.0001, -0.06673458632863392},
                                   {12.7501, 9.2501, -0.07275748846388646},
                                   {12.7501, 9.5001, -0.07861071823340772},
                                   {12.7501, 9.7501, -0.0842107678113249},
                                   {12.7501, 10.0001, -0.0894796310208612},
                                   {12.7501, 10.2501, -0.0943466122920317},
                                   {12.7501, 10.5001, -0.0987497966972937},
                                   {12.7501, 10.7501, -0.1026371570279675},
                                   {12.7501, 11.0001, -0.1059672915667974},
                                   {12.7501, 11.2501, -0.1087098018223076},
                                   {12.7501, 11.5001, -0.1108453325537996},
                                   {12.7501, 11.7501, -0.112365306689169},
                                   {12.7501, 12.0001, -0.113271395171058},
                                   {12.7501, 12.2501, -0.1135747664675613},
                                   {12.7501, 12.5001, -0.1132951626793876},
                                   {12.7501, 12.7501, -0.1124598491775344},
                                   {12.7501, 13.0001, -0.1111024828760262},
                                   {12.7501, 13.2501, -0.1092619409663123},
                                   {12.7501, 13.5001, -0.1069811475940096},
                                   {12.7501, 13.7501, -0.1043059309039737},
                                   {12.7501, 14.0001, -0.1012839374405806},
                                   {12.7501, 14.2501, -0.0979636253474781},
                                   {12.7501, 14.5001, -0.0943933523977952},
                                   {12.7501, 14.7501, -0.0906205697855828},
                                   {12.7501, 15.0001, -0.086691127958209},
                                   {12.7501, 15.2501, -0.0826486966596679},
                                   {12.7501, 15.5001, -0.07853429783924417},
                                   {12.7501, 15.7501, -0.0743859471782725},
                                   {12.7501, 16.0001, -0.07023839769193613},
                                   {12.7501, 16.2501, -0.06612297714378408},
                                   {12.7501, 16.5001, -0.0620675098226358},
                                   {12.7501, 16.7501, -0.05809631251871171},
                                   {12.7501, 17.0001, -0.05423025423575801},
                                   {12.7501, 17.2501, -0.0504868692235934},
                                   {12.7501, 17.5001, -0.04688051324630247},
                                   {12.7501, 17.7501, -0.04342255355343426},
                                   {12.7501, 18.0001, -0.04012158373775432},
                                   {12.7501, 18.2501, -0.03698365549175773},
                                   {12.7501, 18.5001, -0.03401252017107118},
                                   {12.7501, 18.7501, -0.0312098739975186},
                                   {12.7501, 19.0001, -0.02857560165610492},
                                   {12.7501, 19.2501, -0.02610801393296118},
                                   {12.7501, 19.5001, -0.02380407588578556},
                                   {12.7501, 19.7501, -0.02165962282024815},
                                   {12.7501, 20.0001, -0.0196695620556514},
                                   {12.7501, 20.2501, -0.01782805909534006},
                                   {12.7501, 20.5001, -0.01612870736979804},
                                   {12.7501, 20.7501, -0.01456468119365593},
                                   {12.7501, 21.0001, -0.01312887197471354},
                                   {12.7501, 21.2501, -0.01181400803791769},
                                   {12.7501, 21.5001, -0.01061275868553232},
                                   {12.7501, 21.7501, -0.00951782331273485},
                                   {12.7501, 22.0001, -0.00852200654220297},
                                   {12.7501, 22.2501, -0.007618280438669732},
                                   {12.7501, 22.5001, -0.006799834921563362},
                                   {12.7501, 22.7501, -0.006060117517078477},
                                   {12.7501, 23.0001, -0.005392863586314461},
                                   {12.7501, 23.2501, -0.00479211813894615},
                                   {12.7501, 23.5001, -0.004252250297209322},
                                   {12.7501, 23.7501, -0.003767961417176724},
                                   {12.7501, 24.0001, -0.003334287807196179},
                                   {12.7501, 24.2501, -0.002946598910242122},
                                   {12.7501, 24.5001, -0.002600591740558081},
                                   {12.7501, 24.7501, -0.002292282287621195},
                                   {12.7501, 25.0001, -0.002017994523981875},
                                   {12.7501, 25.2501, -0.001774347579369287},
                                   {12.7501, 25.5001, -0.001558241572705179},
                                   {12.7501, 25.7501, -0.001366842527131711},
                                   {12.7501, 26.0001, -0.001197566731372044},
                                   {12.7501, 26.2501, -0.001048064854027352},
                                   {12.7501, 26.5001, -0.000916206065913756},
                                   {12.7501, 26.7501, -0.000800062379256183},
                                   {12.7501, 27.0001, -0.0006978933713683548},
                                   {12.7501, 27.2501, -0.0006081314241570773},
                                   {12.7501, 27.5001, -0.0005293675791293802},
                                   {12.7501, 27.7501, -0.0004603380802432271},
                                   {12.7501, 28.0001, -0.0003999116535897524},
                                   {12.7501, 28.2501, -0.0003470775531763826},
                                   {12.7501, 28.5001, -0.0003009343856420829},
                                   {12.7501, 28.7501, -0.000260679713230178},
                                   {12.7501, 29.0001, -0.0002256004234347722},
                                   {12.7501, 29.2501, -0.0001950638451048194},
                                   {12.7501, 29.5001, -0.0001685095841367801},
                                   {12.7501, 29.7501, -0.0001454420469364996},
                                   {13.0001, 0.0001, -6.927881573116965e-15},
                                   {13.0001, 0.2501, -2.329196119058166e-15},
                                   {13.0001, 0.5001, -4.267038348824608e-14},
                                   {13.0001, 0.7501, -5.519554770811269e-12},
                                   {13.0001, 1.0001, -1.660366397028324e-10},
                                   {13.0001, 1.2501, -2.193361645982836e-9},
                                   {13.0001, 1.5001, -1.722173264742421e-8},
                                   {13.0001, 1.7501, -9.44579609486257e-8},
                                   {13.0001, 2.0001, -3.985073036230275e-7},
                                   {13.0001, 2.2501, -1.376080357810331e-6},
                                   {13.0001, 2.5001, -4.0576033850983e-6},
                                   {13.0001, 2.7501, -0.00001053022819518022},
                                   {13.0001, 3.0001, -0.00002459431026347037},
                                   {13.0001, 3.2501, -0.00005257910328682929},
                                   {13.0001, 3.5001, -0.0001042525891227139},
                                   {13.0001, 3.7501, -0.0001937239728462709},
                                   {13.0001, 4.0001, -0.000340213491554594},
                                   {13.0001, 4.2501, -0.0005685581540983009},
                                   {13.0001, 4.5001, -0.00090933556150465},
                                   {13.0001, 4.7501, -0.001398519184467943},
                                   {13.0001, 5.0001, -0.002076622699614494},
                                   {13.0001, 5.2501, -0.002987341843819309},
                                   {13.0001, 5.5001, -0.004175752935102449},
                                   {13.0001, 5.7501, -0.005686171574311832},
                                   {13.0001, 6.0001, -0.007559808350527221},
                                   {13.0001, 6.2501, -0.00983237773411605},
                                   {13.0001, 6.5001, -0.01253182079076387},
                                   {13.0001, 6.7501, -0.01567629266475571},
                                   {13.0001, 7.0001, -0.01927254411064828},
                                   {13.0001, 7.2501, -0.02331479576314599},
                                   {13.0001, 7.5001, -0.0277841678300886},
                                   {13.0001, 7.7501, -0.03264868999174197},
                                   {13.0001, 8.0001, -0.03786387968186177},
                                   {13.0001, 8.2501, -0.04337384423553422},
                                   {13.0001, 8.5001, -0.04911283553592922},
                                   {13.0001, 8.7501, -0.05500716595281617},
                                   {13.0001, 9.0001, -0.06097738200644555},
                                   {13.0001, 9.2501, -0.0669405871582849},
                                   {13.0001, 9.5001, -0.07281280677719046},
                                   {13.0001, 9.7501, -0.07851129565246168},
                                   {13.0001, 10.0001, -0.0839567002039738},
                                   {13.0001, 10.2501, -0.0890750024648168},
                                   {13.0001, 10.5001, -0.0937991896919634},
                                   {13.0001, 10.7501, -0.0980706109051277},
                                   {13.0001, 11.0001, -0.1018399987329834},
                                   {13.0001, 11.2501, -0.1050681508245888},
                                   {13.0001, 11.5001, -0.1077262791376336},
                                   {13.0001, 11.7501, -0.1097960472272159},
                                   {13.0001, 12.0001, -0.111269325005042},
                                   {13.0001, 12.2501, -0.1121476972633801},
                                   {13.0001, 12.5001, -0.1124417666439017},
                                   {13.0001, 12.7501, -0.112170293869242},
                                   {13.0001, 13.0001, -0.1113592182114334},
                                   {13.0001, 13.2501, -0.1100405996603263},
                                   {13.0001, 13.5001, -0.1082515214124967},
                                   {13.0001, 13.7501, -0.1060329874632886},
                                   {13.0001, 14.0001, -0.1034288455716661},
                                   {13.0001, 14.2501, -0.1004847609710132},
                                   {13.0001, 14.5001, -0.0972472611737173},
                                   {13.0001, 14.7501, -0.0937628672767502},
                                   {13.0001, 15.0001, -0.0900773224900472},
                                   {13.0001, 15.2501, -0.0862349243078262},
                                   {13.0001, 15.5001, -0.0822779629143297},
                                   {13.0001, 15.7501, -0.07824626511379239},
                                   {13.0001, 16.0001, -0.07417684032319904},
                                   {13.0001, 16.2501, -0.07010362296373934},
                                   {13.0001, 16.5001, -0.06605730391074463},
                                   {13.0001, 16.7501, -0.06206524247506654},
                                   {13.0001, 17.0001, -0.05815144964344949},
                                   {13.0001, 17.2501, -0.05433663294695422},
                                   {13.0001, 17.5001, -0.05063829329723957},
                                   {13.0001, 17.7501, -0.04707086437249488},
                                   {13.0001, 18.0001, -0.04364588559192381},
                                   {13.0001, 18.2501, -0.04037220033737813},
                                   {13.0001, 18.5001, -0.03725617181524494},
                                   {13.0001, 18.7501, -0.0343019097587083},
                                   {13.0001, 19.0001, -0.03151150201359761},
                                   {13.0001, 19.2501, -0.02888524589968349},
                                   {13.0001, 19.5001, -0.02642187506871942},
                                   {13.0001, 19.7501, -0.02411877837139574},
                                   {13.0001, 20.0001, -0.0219722079832502},
                                   {13.0001, 20.2501, -0.01997747471444598},
                                   {13.0001, 20.5001, -0.01812912903397418},
                                   {13.0001, 20.7501, -0.01642112687228877},
                                   {13.0001, 21.0001, -0.01484697972731173},
                                   {13.0001, 21.2501, -0.01339988898895246},
                                   {13.0001, 21.5001, -0.01207286472018468},
                                   {13.0001, 21.7501, -0.0108588293929211},
                                   {13.0001, 22.0001, -0.00975070727982348},
                                   {13.0001, 22.2501, -0.00874150035466228},
                                   {13.0001, 22.5001, -0.007824351659977832},
                                   {13.0001, 22.7501, -0.006992597167660929},
                                   {13.0001, 23.0001, -0.00623980719154869},
                                   {13.0001, 23.2501, -0.005559818416789812},
                                   {13.0001, 23.5001, -0.004946757593739271},
                                   {13.0001, 23.7501, -0.004395057909200238},
                                   {13.0001, 24.0001, -0.003899468999150351},
                                   {13.0001, 24.2501, -0.003455061508376138},
                                   {13.0001, 24.5001, -0.003057227036899977},
                                   {13.0001, 24.7501, -0.002701674243446372},
                                   {13.0001, 25.0001, -0.002384421804736207},
                                   {13.0001, 25.2501, -0.002101788857981607},
                                   {13.0001, 25.5001, -0.001850383484067138},
                                   {13.0001, 25.7501, -0.00162708972169752},
                                   {13.0001, 26.0001, -0.00142905353912673},
                                   {13.0001, 26.2501, -0.001253668130563945},
                                   {13.0001, 26.5001, -0.001098558849369003},
                                   {13.0001, 26.7501, -0.000961568039915361},
                                   {13.0001, 27.0001, -0.000840739984576639},
                                   {13.0001, 27.2501, -0.0007343061416310272},
                                   {13.0001, 27.5001, -0.0006406708138320333},
                                   {13.0001, 27.7501, -0.0005583973557510552},
                                   {13.0001, 28.0001, -0.0004861950004948484},
                                   {13.0001, 28.2501, -0.000422906362743496},
                                   {13.0001, 28.5001, -0.000367495654927354},
                                   {13.0001, 28.7501, -0.0003190376364416579},
                                   {13.0001, 29.0001, -0.000276707301762924},
                                   {13.0001, 29.2501, -0.0002397703018675382},
                                   {13.0001, 29.5001, -0.0002075740841585735},
                                   {13.0001, 29.7501, -0.0001795397288972821},
                                   {13.2501, 0.0001, -6.993396024590769e-15},
                                   {13.2501, 0.2501, -2.353823428950458e-15},
                                   {13.2501, 0.5001, -1.986539413718019e-14},
                                   {13.2501, 0.7501, -2.688528519097257e-12},
                                   {13.2501, 1.0001, -8.69050900900454e-11},
                                   {13.2501, 1.2501, -1.214191974027843e-9},
                                   {13.2501, 1.5001, -9.98032919925999e-9},
                                   {13.2501, 1.7501, -5.690197067788825e-8},
                                   {13.2501, 2.0001, -2.482549961260367e-7},
                                   {13.2501, 2.2501, -8.83001449978637e-7},
                                   {13.2501, 2.5001, -2.673551021292464e-6},
                                   {13.2501, 2.7501, -7.106599033382528e-6},
                                   {13.2501, 3.0001, -0.00001696518609074215},
                                   {13.2501, 3.2501, -0.00003700640609658667},
                                   {13.2501, 3.5001, -0.0000747554513950523},
                                   {13.2501, 3.7501, -0.0001413427598520388},
                                   {13.2501, 4.0001, -0.0002522840903882023},
                                   {13.2501, 4.2501, -0.0004280891737154366},
                                   {13.2501, 4.5001, -0.0006945863823902215},
                                   {13.2501, 4.7501, -0.001082868883576414},
                                   {13.2501, 5.0001, -0.001628799501483839},
                                   {13.2501, 5.2501, -0.002372052548963862},
                                   {13.2501, 5.5001, -0.003354715671253251},
                                   {13.2501, 5.7501, -0.004619517681692851},
                                   {13.2501, 6.0001, -0.00620778458775283},
                                   {13.2501, 6.2501, -0.00815725191477985},
                                   {13.2501, 6.5001, -0.01049987499918945},
                                   {13.2501, 6.7501, -0.01325977968118834},
                                   {13.2501, 7.0001, -0.01645148470902863},
                                   {13.2501, 7.2501, -0.02007850617612585},
                                   {13.2501, 7.5001, -0.02413242614749295},
                                   {13.2501, 7.7501, -0.02859247530216658},
                                   {13.2501, 8.0001, -0.03342564590152422},
                                   {13.2501, 8.2501, -0.03858731936360342},
                                   {13.2501, 8.5001, -0.04402236436154424},
                                   {13.2501, 8.7501, -0.04966663825243188},
                                   {13.2501, 9.0001, -0.05544880773524605},
                                   {13.2501, 9.2501, -0.06129239429096298},
                                   {13.2501, 9.5001, -0.06711794601161002},
                                   {13.2501, 9.7501, -0.07284523929979264},
                                   {13.2501, 10.0001, -0.07839542073809862},
                                   {13.2501, 10.2501, -0.0836930101280831},
                                   {13.2501, 10.5001, -0.0886676991442116},
                                   {13.2501, 10.7501, -0.0932558951164487},
                                   {13.2501, 11.0001, -0.0974019751087936},
                                   {13.2501, 11.2501, -0.1010592307986299},
                                   {13.2501, 11.5001, -0.104190498948902},
                                   {13.2501, 11.7501, -0.1067684849479638},
                                   {13.2501, 12.0001, -0.1087757975961527},
                                   {13.2501, 12.2501, -0.1102047218368775},
                                   {13.2501, 12.5001, -0.1110567624039802},
                                   {13.2501, 12.7501, -0.1113419954499067},
                                   {13.2501, 13.0001, -0.1110782672904074},
                                   {13.2501, 13.2501, -0.110290279679946},
                                   {13.2501, 13.5001, -0.1090085997907273},
                                   {13.2501, 13.7501, -0.1072686306020836},
                                   {13.2501, 14.0001, -0.1051095740136743},
                                   {13.2501, 14.2501, -0.1025734149612668},
                                   {13.2501, 14.5001, -0.0997039504001313},
                                   {13.2501, 14.7501, -0.0965458824595547},
                                   {13.2501, 15.0001, -0.0931439905583065},
                                   {13.2501, 15.2501, -0.0895423929632557},
                                   {13.2501, 15.5001, -0.0857839042928081},
                                   {13.2501, 15.7501, -0.0819094918994309},
                                   {13.2501, 16.0001, -0.07795783096545312},
                                   {13.2501, 16.2501, -0.07396495553996607},
                                   {13.2501, 16.5001, -0.06996400063502013},
                                   {13.2501, 16.7501, -0.06598502887056835},
                                   {13.2501, 17.0001, -0.06205493397941993},
                                   {13.2501, 17.2501, -0.05819741271510665},
                                   {13.2501, 17.5001, -0.05443299629955098},
                                   {13.2501, 17.7501, -0.05077913245267453},
                                   {13.2501, 18.0001, -0.04725030921055984},
                                   {13.2501, 18.2501, -0.04385821211157776},
                                   {13.2501, 18.5001, -0.0406119068628923},
                                   {13.2501, 18.7501, -0.03751804024875354},
                                   {13.2501, 19.0001, -0.03458105276748937},
                                   {13.2501, 19.2501, -0.03180339725173008},
                                   {13.2501, 19.5001, -0.02918575850703137},
                                   {13.2501, 19.7501, -0.02672726977377343},
                                   {13.2501, 20.0001, -0.02442572255700131},
                                   {13.2501, 20.2501, -0.02227776706429091},
                                   {13.2501, 20.5001, -0.02027910113242041},
                                   {13.2501, 20.7501, -0.01842464610284502},
                                   {13.2501, 21.0001, -0.01670870862002891},
                                   {13.2501, 21.2501, -0.01512512777446464},
                                   {13.2501, 21.5001, -0.01366740739466072},
                                   {13.2501, 21.7501, -0.0123288336120775},
                                   {13.2501, 22.0001, -0.01110257808372656},
                                   {13.2501, 22.2501, -0.00998178746355695},
                                   {13.2501, 22.5001, -0.00895965987100923},
                                   {13.2501, 22.7501, -0.00802950921868372},
                                   {13.2501, 23.0001, -0.007184818336463355},
                                   {13.2501, 23.2501, -0.006419281872073512},
                                   {13.2501, 23.5001, -0.005726839963134092},
                                   {13.2501, 23.7501, -0.005101703668117537},
                                   {13.2501, 24.0001, -0.004538373117730766},
                                   {13.2501, 24.2501, -0.004031649308115109},
                                   {13.2501, 24.5001, -0.00357664040648165},
                                   {13.2501, 24.7501, -0.00316876338149161},
                                   {13.2501, 25.0001, -0.002803741707533866},
                                   {13.2501, 25.2501, -0.002477599826306477},
                                   {13.2501, 25.5001, -0.002186654982648289},
                                   {13.2501, 25.7501, -0.001927506985905578},
                                   {13.2501, 26.0001, -0.00169702638445218},
                                   {13.2501, 26.2501, -0.001492341480220381},
                                   {13.2501, 26.5001, -0.001310824552908025},
                                   {13.2501, 26.7501, -0.00115007761035658},
                                   {13.2501, 27.0001, -0.001007917932718651},
                                   {13.2501, 27.2501, -0.000882363633576698},
                                   {13.2501, 27.5001, -0.0007716194211427849},
                                   {13.2501, 27.7501, -0.0006740627069717748},
                                   {13.2501, 28.0001, -0.0005882301780944345},
                                   {13.2501, 28.2501, -0.0005128049209046491},
                                   {13.2501, 28.5001, -0.0004466041612612096},
                                   {13.2501, 28.7501, -0.0003885676648095884},
                                   {13.2501, 29.0001, -0.0003377468242003048},
                                   {13.2501, 29.2501, -0.0002932944453815327},
                                   {13.2501, 29.5001, -0.0002544552331817954},
                                   {13.2501, 29.7501, -0.0002205569666902999},
                                   {13.5001, 0.0001, -7.057823799106052e-15},
                                   {13.5001, 0.2501, -2.381082147533423e-15},
                                   {13.5001, 0.5001, -9.81316283969568e-15},
                                   {13.5001, 0.7501, -1.303944533936686e-12},
                                   {13.5001, 1.0001, -4.527555342493336e-11},
                                   {13.5001, 1.2501, -6.69014993055008e-10},
                                   {13.5001, 1.5001, -5.756810567588743e-9},
                                   {13.5001, 1.7501, -3.411797199838447e-8},
                                   {13.5001, 2.0001, -1.539306879530117e-7},
                                   {13.5001, 2.2501, -5.639531829260514e-7},
                                   {13.5001, 2.5001, -1.753355684416052e-6},
                                   {13.5001, 2.7501, -4.773613759739402e-6},
                                   {13.5001, 3.0001, -0.00001164777322993966},
                                   {13.5001, 3.2501, -0.00002592387337571025},
                                   {13.5001, 3.5001, -0.00005335279206962001},
                                   {13.5001, 3.7501, -0.0001026410566109267},
                                   {13.5001, 4.0001, -0.0001862021449717539},
                                   {13.5001, 4.2501, -0.0003208110122893244},
                                   {13.5001, 4.5001, -0.0005280599798955778},
                                   {13.5001, 4.7501, -0.000834521426788431},
                                   {13.5001, 5.0001, -0.00127154324826866},
                                   {13.5001, 5.2501, -0.001874634072564416},
                                   {13.5001, 5.5001, -0.002682432642328151},
                                   {13.5001, 5.7501, -0.003735294852096539},
                                   {13.5001, 6.0001, -0.005073568100430204},
                                   {13.5001, 6.2501, -0.00673565202071384},
                                   {13.5001, 6.5001, -0.0087559645858996},
                                   {13.5001, 6.7501, -0.01116294163782406},
                                   {13.5001, 7.0001, -0.01397719595713873},
                                   {13.5001, 7.2501, -0.01720995006586307},
                                   {13.5001, 7.5001, -0.0208618368851025},
                                   {13.5001, 7.7501, -0.02492213652831411},
                                   {13.5001, 8.0001, -0.02936848848440761},
                                   {13.5001, 8.2501, -0.03416708876335345},
                                   {13.5001, 8.5001, -0.03927335348955102},
                                   {13.5001, 8.7501, -0.04463300575561567},
                                   {13.5001, 9.0001, -0.05018352260069027},
                                   {13.5001, 9.2501, -0.05585586452958208},
                                   {13.5001, 9.5001, -0.06157640131482456},
                                   {13.5001, 9.7501, -0.0672689447571685},
                                   {13.5001, 10.0001, -0.07285680110384982},
                                   {13.5001, 10.2501, -0.07826476216788518},
                                   {13.5001, 10.5001, -0.0834209639299376},
                                   {13.5001, 10.7501, -0.0882585535460187},
                                   {13.5001, 11.0001, -0.0927171192500763},
                                   {13.5001, 11.2501, -0.0967438517232611},
                                   {13.5001, 11.5001, -0.100294419310252},
                                   {13.5001, 11.7501, -0.1033335523494528},
                                   {13.5001, 12.0001, -0.1058353433557529},
                                   {13.5001, 12.2501, -0.1077832795151324},
                                   {13.5001, 12.5001, -0.1091700317290224},
                                   {13.5001, 12.7501, -0.1099970302219697},
                                   {13.5001, 13.0001, -0.1102738605466024},
                                   {13.5001, 13.2501, -0.1100175158189229},
                                   {13.5001, 13.5001, -0.1092515413912959},
                                   {13.5001, 13.7501, -0.1080051071579462},
                                   {13.5001, 14.0001, -0.1063120405476668},
                                   {13.5001, 14.2501, -0.1042098502548568},
                                   {13.5001, 14.5001, -0.1017387671483253},
                                   {13.5001, 14.7501, -0.0989408248138223},
                                   {13.5001, 15.0001, -0.0958589980410492},
                                   {13.5001, 15.2501, -0.0925364134383021},
                                   {13.5001, 15.5001, -0.0890156423945314},
                                   {13.5001, 15.7501, -0.0853380829232907},
                                   {13.5001, 16.0001, -0.081543433598313},
                                   {13.5001, 16.2501, -0.0776692598801249},
                                   {13.5001, 16.5001, -0.07375065066568437},
                                   {13.5001, 16.7501, -0.06981996087546394},
                                   {13.5001, 17.0001, -0.06590663431404058},
                                   {13.5001, 17.2501, -0.06203709987671379},
                                   {13.5001, 17.5001, -0.05823473339146849},
                                   {13.5001, 17.7501, -0.05451987694145686},
                                   {13.5001, 18.0001, -0.05090990736291543},
                                   {13.5001, 18.2501, -0.04741934571041553},
                                   {13.5001, 18.5001, -0.0440599997794476},
                                   {13.5001, 18.7501, -0.04084113223151519},
                                   {13.5001, 19.0001, -0.0377696474383301},
                                   {13.5001, 19.2501, -0.03485029081252311},
                                   {13.5001, 19.5001, -0.03208585509014579},
                                   {13.5001, 19.7501, -0.02947738874743955},
                                   {13.5001, 20.0001, -0.02702440244784748},
                                   {13.5001, 20.2501, -0.02472507010648849},
                                   {13.5001, 20.5001, -0.02257642181393616},
                                   {13.5001, 20.7501, -0.02057452646858613},
                                   {13.5001, 21.0001, -0.01871466251997356},
                                   {13.5001, 21.2501, -0.01699147571985215},
                                   {13.5001, 21.5001, -0.01539912321186667},
                                   {13.5001, 21.7501, -0.01393140366446143},
                                   {13.5001, 22.0001, -0.01258187346708956},
                                   {13.5001, 22.2501, -0.01134394926987286},
                                   {13.5001, 22.5001, -0.01021099735554325},
                                   {13.5001, 22.7501, -0.00917641049430661},
                                   {13.5001, 23.0001, -0.00823367305207802},
                                   {13.5001, 23.2501, -0.007376415205352849},
                                   {13.5001, 23.5001, -0.006598457166773581},
                                   {13.5001, 23.7501, -0.00589384434904014},
                                   {13.5001, 24.0001, -0.005256874395737407},
                                   {13.5001, 24.2501, -0.00468211699013634},
                                   {13.5001, 24.5001, -0.004164427320902263},
                                   {13.5001, 24.7501, -0.003698954040354303},
                                   {13.5001, 25.0001, -0.003281142499491679},
                                   {13.5001, 25.2501, -0.002906733987060245},
                                   {13.5001, 25.5001, -0.002571761639712353},
                                   {13.5001, 25.7501, -0.002272543628685336},
                                   {13.5001, 26.0001, -0.002005674166922086},
                                   {13.5001, 26.2501, -0.001768012820408452},
                                   {13.5001, 26.5001, -0.001556672549660469},
                                   {13.5001, 26.7501, -0.001369006852473463},
                                   {13.5001, 27.0001, -0.001202596327750628},
                                   {13.5001, 27.2501, -0.001055234932789451},
                                   {13.5001, 27.5001, -0.000924916163000674},
                                   {13.5001, 27.7501, -0.000809819343724892},
                                   {13.5001, 28.0001, -0.0007082961885567675},
                                   {13.5001, 28.2501, -0.0006188577472697975},
                                   {13.5001, 28.5001, -0.0005401618388809425},
                                   {13.5001, 28.7501, -0.0004710010413872255},
                                   {13.5001, 29.0001, -0.0004102912890000411},
                                   {13.5001, 29.2501, -0.0003570611100345528},
                                   {13.5001, 29.5001, -0.0003104415237103769},
                                   {13.5001, 29.7501, -0.000269656601714662},
                                   {13.7501, 0.0001, -7.121202671859995e-15},
                                   {13.7501, 0.2501, -2.409087096988693e-15},
                                   {13.7501, 0.5001, -5.411127051135932e-15},
                                   {13.7501, 0.7501, -6.300130295498825e-13},
                                   {13.7501, 1.0001, -2.348012114282499e-11},
                                   {13.7501, 1.2501, -3.669385013619747e-10},
                                   {13.7501, 1.5001, -3.305411621357072e-9},
                                   {13.7501, 1.7501, -2.036309649895581e-8},
                                   {13.7501, 2.0001, -9.50069852139793e-8},
                                   {13.7501, 2.2501, -3.58530719160624e-7},
                                   {13.7501, 2.5001, -1.144595314952533e-6},
                                   {13.7501, 2.7501, -3.19177261778828e-6},
                                   {13.7501, 3.0001, -7.960224153838568e-6},
                                   {13.7501, 3.2501, -0.0000180767341722559},
                                   {13.7501, 3.5001, -0.0000379024768249987},
                                   {13.7501, 3.7501, -0.00007419317097516131},
                                   {13.7501, 4.0001, -0.0001367961696115705},
                                   {13.7501, 4.2501, -0.000239308403412401},
                                   {13.7501, 4.5001, -0.0003996070700865093},
                                   {13.7501, 4.7501, -0.0006401641145471563},
                                   {13.7501, 5.0001, -0.000988066540505706},
                                   {13.7501, 5.2501, -0.00147468620802796},
                                   {13.7501, 5.5001, -0.00213497226410475},
                                   {13.7501, 5.7501, -0.003006373036555793},
                                   {13.7501, 6.0001, -0.00412742809127709},
                                   {13.7501, 6.2501, -0.005536101467852674},
                                   {13.7501, 6.5001, -0.007267950840717972},
                                   {13.7501, 6.7501, -0.00935424246776058},
                                   {13.7501, 7.0001, -0.0118201273515356},
                                   {13.7501, 7.2501, -0.01468299017203894},
                                   {13.7501, 7.5001, -0.01795107027208387},
                                   {13.7501, 7.7501, -0.02162243496894632},
                                   {13.7501, 8.0001, -0.02568436181395255},
                                   {13.7501, 8.2501, -0.03011316035648263},
                                   {13.7501, 8.5001, -0.034874437644068},
                                   {13.7501, 8.7501, -0.03992378700575914},
                                   {13.7501, 9.0001, -0.04520785814769269},
                                   {13.7501, 9.2501, -0.05066574932523089},
                                   {13.7501, 9.5001, -0.05623064997931438},
                                   {13.7501, 9.7501, -0.06183165494242774},
                                   {13.7501, 10.0001, -0.06739566896653808},
                                   {13.7501, 10.2501, -0.07284932243845842},
                                   {13.7501, 10.5001, -0.07812082504912844},
                                   {13.7501, 10.7501, -0.0831416930617505},
                                   {13.7501, 11.0001, -0.0878482968129699},
                                   {13.7501, 11.2501, -0.0921831873241403},
                                   {13.7501, 11.5001, -0.0960961736004172},
                                   {13.7501, 11.7501, -0.0995451346574802},
                                   {13.7501, 12.0001, -0.1024965619657552},
                                   {13.7501, 12.2501, -0.1049258384013149},
                                   {13.7501, 12.5001, -0.1068172686377382},
                                   {13.7501, 12.7501, -0.1081638830284592},
                                   {13.7501, 13.0001, -0.1089670423530038},
                                   {13.7501, 13.2501, -0.1092358743680969},
                                   {13.7501, 13.5001, -0.10898657502808},
                                   {13.7501, 13.7501, -0.1082416076877774},
                                   {13.7501, 14.0001, -0.1070288327824231},
                                   {13.7501, 14.2501, -0.1053805986220056},
                                   {13.7501, 14.5001, -0.1033328212760035},
                                   {13.7501, 14.7501, -0.1009240782875199},
                                   {13.7501, 15.0001, -0.0981947373563673},
                                   {13.7501, 15.2501, -0.0951861373596372},
                                   {13.7501, 15.5001, -0.0919398353001455},
                                   {13.7501, 15.7501, -0.0884969291237318},
                                   {13.7501, 16.0001, -0.0848974629325296},
                                   {13.7501, 16.2501, -0.0811799180219098},
                                   {13.7501, 16.5001, -0.07738079043682138},
                                   {13.7501, 16.7501, -0.07353425340865033},
                                   {13.7501, 17.0001, -0.06967190110658112},
                                   {13.7501, 17.2501, -0.06582256861148234},
                                   {13.7501, 17.5001, -0.06201222187624305},
                                   {13.7501, 17.7501, -0.05826391064523845},
                                   {13.7501, 18.0001, -0.05459777683141437},
                                   {13.7501, 18.2501, -0.05103111065245152},
                                   {13.7501, 18.5001, -0.04757844686584217},
                                   {13.7501, 18.7501, -0.04425169367473015},
                                   {13.7501, 19.0001, -0.04106028726175348},
                                   {13.7501, 19.2501, -0.03801136540920922},
                                   {13.7501, 19.5001, -0.03510995424633061},
                                   {13.7501, 19.7501, -0.03235916279790582},
                                   {13.7501, 20.0001, -0.02976038066658282},
                                   {13.7501, 20.2501, -0.02731347484188342},
                                   {13.7501, 20.5001, -0.02501698227415235},
                                   {13.7501, 20.7501, -0.02286829546720027},
                                   {13.7501, 21.0001, -0.02086383891859745},
                                   {13.7501, 21.2501, -0.01899923476393786},
                                   {13.7501, 21.5001, -0.01726945645618148},
                                   {13.7501, 21.7501, -0.01566896973101789},
                                   {13.7501, 22.0001, -0.0141918604736513},
                                   {13.7501, 22.2501, -0.01283194941264421},
                                   {13.7501, 22.5001, -0.01158289382485709},
                                   {13.7501, 22.7501, -0.01043827664538286},
                                   {13.7501, 23.0001, -0.00939168354162878},
                                   {13.7501, 23.2501, -0.00843676863567312},
                                   {13.7501, 23.5001, -0.007567309648240248},
                                   {13.7501, 23.7501, -0.006777253295648952},
                                   {13.7501, 24.0001, -0.006060751802343999},
                                   {13.7501, 24.2501, -0.005412191400371129},
                                   {13.7501, 24.5001, -0.004826213677374774},
                                   {13.7501, 24.7501, -0.004297730610036881},
                                   {13.7501, 25.0001, -0.003821934083630309},
                                   {13.7501, 25.2501, -0.003394300653459249},
                                   {13.7501, 25.5001, -0.00301059225296162},
                                   {13.7501, 25.7501, -0.002666853498355052},
                                   {13.7501, 26.0001, -0.002359406182778666},
                                   {13.7501, 26.2501, -0.002084841495459055},
                                   {13.7501, 26.5001, -0.001840010444761517},
                                   {13.7501, 26.7501, -0.001622012909064932},
                                   {13.7501, 27.0001, -0.001428185686976785},
                                   {13.7501, 27.2501, -0.001256089869036409},
                                   {13.7501, 27.5001, -0.001103497807117678},
                                   {13.7501, 27.7501, -0.00096837991546758},
                                   {13.7501, 28.0001, -0.000848891498811811},
                                   {13.7501, 28.2501, -0.0007433597682300951},
                                   {13.7501, 28.5001, -0.0006502711744801527},
                                   {13.7501, 28.7501, -0.0005682591609958796},
                                   {13.7501, 29.0001, -0.0004960924147222734},
                                   {13.7501, 29.2501, -0.0004326636720642885},
                                   {13.7501, 29.5001, -0.0003769791192851003},
                                   {13.7501, 29.7501, -0.0003281484114456626},
                                   {14.0001, 0.0001, -7.18356837880493e-15},
                                   {14.0001, 0.2501, -2.437142127448508e-15},
                                   {14.0001, 0.5001, -3.500254808970082e-15},
                                   {14.0001, 0.7501, -3.035239880737436e-13},
                                   {14.0001, 1.0001, -1.212265389853571e-11},
                                   {14.0001, 1.2501, -2.00353072204834e-10},
                                   {14.0001, 1.5001, -1.889347484705864e-9},
                                   {14.0001, 1.7501, -1.209888439009874e-8},
                                   {14.0001, 2.0001, -5.837477538205422e-8},
                                   {14.0001, 2.2501, -2.26906885874267e-7},
                                   {14.0001, 2.5001, -7.438247732649897e-7},
                                   {14.0001, 2.7501, -2.124477854005006e-6},
                                   {14.0001, 3.0001, -5.415545791482934e-6},
                                   {14.0001, 3.2501, -0.0000125479743268256},
                                   {14.0001, 3.5001, -0.00002680468396970519},
                                   {14.0001, 3.7501, -0.00005338737440672033},
                                   {14.0001, 4.0001, -0.0001000447275847414},
                                   {14.0001, 4.2501, -0.000177703871140438},
                                   {14.0001, 4.5001, -0.0003010319671208278},
                                   {14.0001, 4.7501, -0.0004888482074118044},
                                   {14.0001, 5.0001, -0.0007643098810406385},
                                   {14.0001, 5.2501, -0.001154809485755352},
                                   {14.0001, 5.5001, -0.001691541572666415},
                                   {14.0001, 5.7501, -0.002408725511568213},
                                   {14.0001, 6.0001, -0.00334250039139812},
                                   {14.0001, 6.2501, -0.004529537451371008},
                                   {14.0001, 6.5001, -0.006005440729933301},
                                   {14.0001, 6.7501, -0.00780302564315686},
                                   {14.0001, 7.0001, -0.00995057644783983},
                                   {14.0001, 7.2501, -0.01247018641825041},
                                   {14.0001, 7.5001, -0.01537627934725698},
                                   {14.0001, 7.7501, -0.01867439867314219},
                                   {14.0001, 8.0001, -0.02236033265792028},
                                   {14.0001, 8.2501, -0.02641962243315454},
                                   {14.0001, 8.5001, -0.03082747631248098},
                                   {14.0001, 8.7501, -0.0355490903863431},
                                   {14.0001, 9.0001, -0.04054035367402282},
                                   {14.0001, 9.2501, -0.04574889729471963},
                                   {14.0001, 9.5001, -0.05111543213966795},
                                   {14.0001, 9.7501, -0.05657530890017741},
                                   {14.0001, 10.0001, -0.0620602281869195},
                                   {14.0001, 10.2501, -0.06750002670207028},
                                   {14.0001, 10.5001, -0.07282446758276759},
                                   {14.0001, 10.7501, -0.07796496852298782},
                                   {14.0001, 11.0001, -0.0828562093893645},
                                   {14.0001, 11.2501, -0.087437571014332},
                                   {14.0001, 11.5001, -0.0916543679246095},
                                   {14.0001, 11.7501, -0.095458849244226},
                                   {14.0001, 12.0001, -0.0988109532840606},
                                   {14.0001, 12.2501, -0.1016788118856051},
                                   {14.0001, 12.5001, -0.1040390100334603},
                                   {14.0001, 12.7501, -0.1058766143150763},
                                   {14.0001, 13.0001, -0.1071849903256608},
                                   {14.0001, 13.2501, -0.1079654340299215},
                                   {14.0001, 13.5001, -0.1082266454252493},
                                   {14.0001, 13.7501, -0.1079840746971095},
                                   {14.0001, 14.0001, -0.1072591715628339},
                                   {14.0001, 14.2501, -0.1060785678461256},
                                   {14.0001, 14.5001, -0.1044732217130886},
                                   {14.0001, 14.7501, -0.1024775496401813},
                                   {14.0001, 15.0001, -0.100128569280001},
                                   {14.0001, 15.2501, -0.0974650731345925},
                                   {14.0001, 15.5001, -0.0945268495117022},
                                   {14.0001, 15.7501, -0.0913539637778992},
                                   {14.0001, 16.0001, -0.0879861095595779},
                                   {14.0001, 16.2501, -0.0844620363786805},
                                   {14.0001, 16.5001, -0.0808190573197156},
                                   {14.0001, 16.7501, -0.07709263776011727},
                                   {14.0001, 17.0001, -0.07331606398801805},
                                   {14.0001, 17.2501, -0.06952018869266761},
                                   {14.0001, 17.5001, -0.06573324884034751},
                                   {14.0001, 17.7501, -0.06198075032777202},
                                   {14.0001, 18.0001, -0.05828541301135327},
                                   {14.0001, 18.2501, -0.05466716921341332},
                                   {14.0001, 18.5001, -0.05114320857026446},
                                   {14.0001, 18.7501, -0.04772806207470704},
                                   {14.0001, 19.0001, -0.04443371833914322},
                                   {14.0001, 19.2501, -0.04126976542838001},
                                   {14.0001, 19.5001, -0.03824355204856433},
                                   {14.0001, 19.7501, -0.03536036239865084},
                                   {14.0001, 20.0001, -0.03262359956480609},
                                   {14.0001, 20.2501, -0.03003497294129122},
                                   {14.0001, 20.5001, -0.02759468577247932},
                                   {14.0001, 20.7501, -0.02530161951227814},
                                   {14.0001, 21.0001, -0.02315351227539636},
                                   {14.0001, 21.2501, -0.02114712919892841},
                                   {14.0001, 21.5001, -0.01927842303491348},
                                   {14.0001, 21.7501, -0.0175426837497311},
                                   {14.0001, 22.0001, -0.0159346763115601},
                                   {14.0001, 22.2501, -0.01444876620167256},
                                   {14.0001, 22.5001, -0.01307903248962397},
                                   {14.0001, 22.7501, -0.01181936856822566},
                                   {14.0001, 23.0001, -0.01066357085425966},
                                   {14.0001, 23.2501, -0.00960541592860437},
                                   {14.0001, 23.5001, -0.0086387267186007},
                                   {14.0001, 23.7501, -0.007757428420171141},
                                   {14.0001, 24.0001, -0.006955594921558204},
                                   {14.0001, 24.2501, -0.006227486528679924},
                                   {14.0001, 24.5001, -0.005567579807969084},
                                   {14.0001, 24.7501, -0.004970590359905585},
                                   {14.0001, 25.0001, -0.004431489318731002},
                                   {14.0001, 25.2501, -0.003945514344201065},
                                   {14.0001, 25.5001, -0.003508175832508404},
                                   {14.0001, 25.7501, -0.003115259028181613},
                                   {14.0001, 26.0001, -0.002762822668995272},
                                   {14.0001, 26.2501, -0.002447194743549449},
                                   {14.0001, 26.5001, -0.002164965887738121},
                                   {14.0001, 26.7501, -0.001912980893090106},
                                   {14.0001, 27.0001, -0.001688328747948417},
                                   {14.0001, 27.2501, -0.001488331582445612},
                                   {14.0001, 27.5001, -0.00131053284082694},
                                   {14.0001, 27.7501, -0.001152684960291771},
                                   {14.0001, 28.0001, -0.001012736794442412},
                                   {14.0001, 28.2501, -0.000888820981800281},
                                   {14.0001, 28.5001, -0.0007792414257234189},
                                   {14.0001, 28.7501, -0.0006824610214053241},
                                   {14.0001, 29.0001, -0.0005970897383573552},
                                   {14.0001, 29.2501, -0.0005218731427304664},
                                   {14.0001, 29.5001, -0.0004556814228356598},
                                   {14.0001, 29.7501, -0.0003974989630705114},
                                   {14.2501, 0.0001, -7.24495484418588e-15},
                                   {14.2501, 0.2501, -2.464995261746445e-15},
                                   {14.2501, 0.5001, -2.682435996973995e-15},
                                   {14.2501, 0.7501, -1.460868529035383e-13},
                                   {14.2501, 1.0001, -6.231666920267671e-12},
                                   {14.2501, 1.2501, -1.089129124860417e-10},
                                   {14.2501, 1.5001, -1.07516639849722e-9},
                                   {14.2501, 1.7501, -7.156861752739906e-9},
                                   {14.2501, 2.0001, -3.570830338656669e-8},
                                   {14.2501, 2.2501, -1.42969027204463e-7},
                                   {14.2501, 2.5001, -4.812393106948996e-7},
                                   {14.2501, 2.7501, -1.407807117173554e-6},
                                   {14.2501, 3.0001, -3.667995883349148e-6},
                                   {14.2501, 3.2501, -8.67153546605256e-6},
                                   {14.2501, 3.5001, -0.00001887216173169376},
                                   {14.2501, 3.7501, -0.000038245490166686},
                                   {14.2501, 4.0001, -0.0000728418124938595},
                                   {14.2501, 4.2501, -0.0001313715639865218},
                                   {14.2501, 4.5001, -0.000225765161060703},
                                   {14.2501, 4.7501, -0.0003716386994190027},
                                   {14.2501, 5.0001, -0.0005885946884164099},
                                   {14.2501, 5.2501, -0.000900293384057489},
                                   {14.2501, 5.5001, -0.001334244870940858},
                                   {14.2501, 5.7501, -0.001921293196545204},
                                   {14.2501, 6.0001, -0.002694789138122726},
                                   {14.2501, 6.2501, -0.003689474744087815},
                                   {14.2501, 6.5001, -0.004940127809451834},
                                   {14.2501, 6.7501, -0.006480035448446079},
                                   {14.2501, 7.0001, -0.00833938105632203},
                                   {14.2501, 7.2501, -0.01054363709333914},
                                   {14.2501, 7.5001, -0.01311205694074742},
                                   {14.2501, 7.7501, -0.01605635294866221},
                                   {14.2501, 8.0001, -0.01937963568088517},
                                   {14.2501, 8.2501, -0.02307567263894399},
                                   {14.2501, 8.5001, -0.02712850502666383},
                                   {14.2501, 8.7501, -0.03151244006577959},
                                   {14.2501, 9.0001, -0.03619241556930699},
                                   {14.2501, 9.2501, -0.04112471429195347},
                                   {14.2501, 9.5001, -0.0462579890896758},
                                   {14.2501, 9.7501, -0.0515345468917856},
                                   {14.2501, 10.0001, -0.05689183034463717},
                                   {14.2501, 10.2501, -0.0622640308402461},
                                   {14.2501, 10.5001, -0.06758376533997501},
                                   {14.2501, 10.7501, -0.07278375156967273},
                                   {14.2501, 11.0001, -0.07779842126823234},
                                   {14.2501, 11.2501, -0.0825654185890408},
                                   {14.2501, 11.5001, -0.0870269398140656},
                                   {14.2501, 11.7501, -0.0911308805804618},
                                   {14.2501, 12.0001, -0.0948317672216222},
                                   {14.2501, 12.2501, -0.0980914590440581},
                                   {14.2501, 12.5001, -0.1008796179460247},
                                   {14.2501, 12.7501, -0.1031739503826022},
                                   {14.2501, 13.0001, -0.1049602340474493},
                                   {14.2501, 13.2501, -0.1062321476246203},
                                   {14.2501, 13.5001, -0.1069909265047538},
                                   {14.2501, 13.7501, -0.1072448704752198},
                                   {14.2501, 14.0001, -0.1070087311622525},
                                   {14.2501, 14.2501, -0.1063030075508032},
                                   {14.2501, 14.5001, -0.1051531773936998},
                                   {14.2501, 14.7501, -0.1035888909240029},
                                   {14.2501, 15.0001, -0.1016431511891707},
                                   {14.2501, 15.2501, -0.0993515027165928},
                                   {14.2501, 15.5001, -0.096751247271065},
                                   {14.2501, 15.7501, -0.0938807023339288},
                                   {14.2501, 16.0001, -0.0907785147593003},
                                   {14.2501, 16.2501, -0.0874830389615522},
                                   {14.2501, 16.5001, -0.0840317860537848},
                                   {14.2501, 16.7501, -0.0804609476608794},
                                   {14.2501, 17.0001, -0.0768049957232626},
                                   {14.2501, 17.2501, -0.0730963575200035},
                                   {14.2501, 17.5001, -0.06936516338680874},
                                   {14.2501, 17.7501, -0.06563906318620848},
                                   {14.2501, 18.0001, -0.06194310649253151},
                                   {14.2501, 18.2501, -0.05829968066301649},
                                   {14.2501, 18.5001, -0.05472850045195141},
                                   {14.2501, 18.7501, -0.05124664255610913},
                                   {14.2501, 19.0001, -0.04786861842359497},
                                   {14.2501, 19.2501, -0.04460647878040758},
                                   {14.2501, 19.5001, -0.0414699435959563},
                                   {14.2501, 19.7501, -0.03846655158848353},
                                   {14.2501, 20.0001, -0.03560182383417418},
                                   {14.2501, 20.2501, -0.0328794365629445},
                                   {14.2501, 20.5001, -0.03030139877594148},
                                   {14.2501, 20.7501, -0.0278682308844455},
                                   {14.2501, 21.0001, -0.0255791411302853},
                                   {14.2501, 21.2501, -0.0234321970904005},
                                   {14.2501, 21.5001, -0.02142449008219438},
                                   {14.2501, 21.7501, -0.01955229076393763},
                                   {14.2501, 22.0001, -0.01781119466029907},
                                   {14.2501, 22.2501, -0.01619625673381651},
                                   {14.2501, 22.5001, -0.01470211446732397},
                                   {14.2501, 22.7501, -0.01332309922006721},
                                   {14.2501, 23.0001, -0.0120533358727223},
                                   {14.2501, 23.2501, -0.01088683098597198},
                                   {14.2501, 23.5001, -0.00981754986657028},
                                   {14.2501, 23.7501, -0.0088394830672893},
                                   {14.2501, 24.0001, -0.007946702946433258},
                                   {14.2501, 24.2501, -0.007133410982495696},
                                   {14.2501, 24.5001, -0.006393976583802621},
                                   {14.2501, 24.7501, -0.005722968155306721},
                                   {14.2501, 25.0001, -0.005115177188580634},
                                   {14.2501, 25.2501, -0.004565636129774898},
                                   {14.2501, 25.5001, -0.004069630756863169},
                                   {14.2501, 25.7501, -0.00362270776460608},
                                   {14.2501, 26.0001, -0.003220678215735794},
                                   {14.2501, 26.2501, -0.002859617472003677},
                                   {14.2501, 26.5001, -0.002535862170757512},
                                   {14.2501, 26.7501, -0.00224600476315687},
                                   {14.2501, 27.0001, -0.001986886080269423},
                                   {14.2501, 27.2501, -0.001755586344152108},
                                   {14.2501, 27.5001, -0.001549414993428455},
                                   {14.2501, 27.7501, -0.001365899647455009},
                                   {14.2501, 28.0001, -0.001202774490385755},
                                   {14.2501, 28.2501, -0.001057968316609619},
                                   {14.2501, 28.5001, -0.000929592442345587},
                                   {14.2501, 28.7501, -0.000815928654723649},
                                   {14.2501, 29.0001, -0.000715417339464937},
                                   {14.2501, 29.2501, -0.0006266459012413859},
                                   {14.2501, 29.5001, -0.0005483375668324016},
                                   {14.2501, 29.7501, -0.0004793406401524598},
                                   {14.5001, 0.0001, -7.305394279874568e-15},
                                   {14.5001, 0.2501, -2.492559464622242e-15},
                                   {14.5001, 0.5001, -2.341899408442592e-15},
                                   {14.5001, 0.7501, -7.05167708563923e-14},
                                   {14.5001, 1.0001, -3.1899272273279e-12},
                                   {14.5001, 1.2501, -5.894921874921563e-11},
                                   {14.5001, 1.5001, -6.091872044446049e-10},
                                   {14.5001, 1.7501, -4.215114736364395e-9},
                                   {14.5001, 2.0001, -2.17480959882934e-8},
                                   {14.5001, 2.2501, -8.96897891300237e-8},
                                   {14.5001, 2.5001, -3.099967572209259e-7},
                                   {14.5001, 2.7501, -9.28835152947671e-7},
                                   {14.5001, 3.0001, -2.473540411107245e-6},
                                   {14.5001, 3.2501, -5.966519251500718e-6},
                                   {14.5001, 3.5001, -0.00001322922561474386},
                                   {14.5001, 3.7501, -0.00002727865322091386},
                                   {14.5001, 4.0001, -0.00005280409012859498},
                                   {14.5001, 4.2501, -0.0000966953152799933},
                                   {14.5001, 4.5001, -0.0001685777107674308},
                                   {14.5001, 4.7501, -0.0002812976646466945},
                                   {14.5001, 5.0001, -0.0004512953883156811},
                                   {14.5001, 5.2501, -0.0006988032197521285},
                                   {14.5001, 5.5001, -0.001047815904784745},
                                   {14.5001, 5.7501, -0.001525794463351984},
                                   {14.5001, 6.0001, -0.002163085407770783},
                                   {14.5001, 6.2501, -0.002992060063162787},
                                   {14.5001, 6.5001, -0.004046002090458539},
                                   {14.5001, 6.7501, -0.005357792666947194},
                                   {14.5001, 7.0001, -0.006958460138199944},
                                   {14.5001, 7.2501, -0.00887567286826622},
                                   {14.5001, 7.5001, -0.01113225967703301},
                                   {14.5001, 7.7501, -0.01374484151210718},
                                   {14.5001, 8.0001, -0.01672265129405676},
                                   {14.5001, 8.2501, -0.02006660710858011},
                                   {14.5001, 8.5001, -0.02376868833664576},
                                   {14.5001, 8.7501, -0.02781164632950219},
                                   {14.5001, 9.0001, -0.03216906229691406},
                                   {14.5001, 9.2501, -0.0368057465392729},
                                   {14.5001, 9.5001, -0.04167845618565909},
                                   {14.5001, 9.7501, -0.04673689411872087},
                                   {14.5001, 10.0001, -0.05192494040957476},
                                   {14.5001, 10.2501, -0.05718205970188207},
                                   {14.5001, 10.5001, -0.06244482365639918},
                                   {14.5001, 10.7501, -0.06764848664611879},
                                   {14.5001, 11.0001, -0.07272855504203919},
                                   {14.5001, 11.2501, -0.07762229517999906},
                                   {14.5001, 11.5001, -0.0822701318954431},
                                   {14.5001, 11.7501, -0.0866168977647678},
                                   {14.5001, 12.0001, -0.0906129023135044},
                                   {14.5001, 12.2501, -0.0942147998961264},
                                   {14.5001, 12.5001, -0.0973862442363861},
                                   {14.5001, 12.7501, -0.1000983263374774},
                                   {14.5001, 13.0001, -0.1023298003133365},
                                   {14.5001, 13.2501, -0.1040671084318785},
                                   {14.5001, 13.5001, -0.1053042221606326},
                                   {14.5001, 13.7501, -0.1060423202067615},
                                   {14.5001, 14.0001, -0.1062893274568635},
                                   {14.5001, 14.2501, -0.1060593404132303},
                                   {14.5001, 14.5001, -0.1053719653014009},
                                   {14.5001, 14.7501, -0.1042515946282734},
                                   {14.5001, 15.0001, -0.1027266467585822},
                                   {14.5001, 15.2501, -0.1008287912161907},
                                   {14.5001, 15.5001, -0.098592180070512},
                                   {14.5001, 15.7501, -0.0960527030947533},
                                   {14.5001, 16.0001, -0.09324728152556},
                                   {14.5001, 16.2501, -0.0902132123400861},
                                   {14.5001, 16.5001, -0.0869875721043895},
                                   {14.5001, 16.7501, -0.0836066867241023},
                                   {14.5001, 17.0001, -0.0801056709123502},
                                   {14.5001, 17.2501, -0.07651803892965237},
                                   {14.5001, 17.5001, -0.07287538617741069},
                                   {14.5001, 17.7501, -0.06920713955655089},
                                   {14.5001, 18.0001, -0.06554037313870371},
                                   {14.5001, 18.2501, -0.06189968463100701},
                                   {14.5001, 18.5001, -0.05830712733062113},
                                   {14.5001, 18.7501, -0.05478219173852152},
                                   {14.5001, 19.0001, -0.05134183070686373},
                                   {14.5001, 19.2501, -0.04800052190044362},
                                   {14.5001, 19.5001, -0.04477036142967832},
                                   {14.5001, 19.7501, -0.04166118272948661},
                                   {14.5001, 20.0001, -0.03868069508601029},
                                   {14.5001, 20.2501, -0.03583463662378725},
                                   {14.5001, 20.5001, -0.03312693703472834},
                                   {14.5001, 20.7501, -0.03055988583483409},
                                   {14.5001, 21.0001, -0.02813430245576463},
                                   {14.5001, 21.2501, -0.02584970499990896},
                                   {14.5001, 21.5001, -0.02370447499619412},
                                   {14.5001, 21.7501, -0.02169601597901586},
                                   {14.5001, 22.0001, -0.01982090416641548},
                                   {14.5001, 22.2501, -0.0180750299303329},
                                   {14.5001, 22.5001, -0.0164537291278269},
                                   {14.5001, 22.7501, -0.01495190369570271},
                                   {14.5001, 23.0001, -0.01356413120161724},
                                   {14.5001, 23.2501, -0.01228476329322333},
                                   {14.5001, 23.5001, -0.01110801319497776},
                                   {14.5001, 23.7501, -0.01002803257229399},
                                   {14.5001, 24.0001, -0.0090389782176856},
                                   {14.5001, 24.2501, -0.00813506911666358},
                                   {14.5001, 24.5001, -0.007310634525833843},
                                   {14.5001, 24.7501, -0.00656015374535299},
                                   {14.5001, 25.0001, -0.005878288296051045},
                                   {14.5001, 25.2501, -0.005259907221397326},
                                   {14.5001, 25.5001, -0.004700106229159982},
                                   {14.5001, 25.7501, -0.004194221369947694},
                                   {14.5001, 26.0001, -0.003737837922424319},
                                   {14.5001, 26.2501, -0.003326795120181447},
                                   {14.5001, 26.5001, -0.002957187315092904},
                                   {14.5001, 26.7501, -0.002625362128240121},
                                   {14.5001, 27.0001, -0.002327916093708761},
                                   {14.5001, 27.2501, -0.002061688253990043},
                                   {14.5001, 27.5001, -0.001823752119423186},
                                   {14.5001, 27.7501, -0.001611406358929855},
                                   {14.5001, 28.0001, -0.001422164545874401},
                                   {14.5001, 28.2501, -0.001253744241728336},
                                   {14.5001, 28.5001, -0.001104055661675675},
                                   {14.5001, 28.7501, -0.00097119013059733},
                                   {14.5001, 29.0001, -0.000853408505145408},
                                   {14.5001, 29.2501, -0.0007491297079049009},
                                   {14.5001, 29.5001, -0.0006569194929149971},
                                   {14.5001, 29.7501, -0.0005754795380050203},
                                   {14.7501, 0.0001, -7.364917299972168e-15},
                                   {14.7501, 0.2501, -2.519808506966022e-15},
                                   {14.7501, 0.5001, -2.208729776796031e-15},
                                   {14.7501, 0.7501, -3.440956529509434e-14},
                                   {14.7501, 1.0001, -1.62635268987751e-12},
                                   {14.7501, 1.2501, -3.177068691056138e-11},
                                   {14.7501, 1.5001, -3.436922312087865e-10},
                                   {14.7501, 1.7501, -2.471941389866911e-9},
                                   {14.7501, 2.0001, -1.318906046122303e-8},
                                   {14.7501, 2.2501, -5.602519836794211e-8},
                                   {14.7501, 2.5001, -1.98834366113152e-7},
                                   {14.7501, 2.7501, -6.101988058097483e-7},
                                   {14.7501, 3.0001, -1.660907562124539e-6},
                                   {14.7501, 3.2501, -4.08772336353791e-6},
                                   {14.7501, 3.5001, -9.23382824815145e-6},
                                   {14.7501, 3.7501, -0.00001937311481459942},
                                   {14.7501, 4.0001, -0.00003811426079133689},
                                   {14.7501, 4.2501, -0.00007086665583646622},
                                   {14.7501, 4.5001, -0.0001253358127591555},
                                   {14.7501, 4.7501, -0.0002120032493334466},
                                   {14.7501, 5.0001, -0.0003445371612276689},
                                   {14.7501, 5.2501, -0.000540077151528471},
                                   {14.7501, 5.5001, -0.000819339653060458},
                                   {14.7501, 5.7501, -0.001206500384290246},
                                   {14.7501, 6.0001, -0.001728825282803061},
                                   {14.7501, 6.2501, -0.002416040268677798},
                                   {14.7501, 6.5001, -0.003299450910389753},
                                   {14.7501, 6.7501, -0.00441084348696514},
                                   {14.7501, 7.0001, -0.005781217094103651},
                                   {14.7501, 7.2501, -0.007439410713358983},
                                   {14.7501, 7.5001, -0.00941069842799565},
                                   {14.7501, 7.7501, -0.01171542965763334},
                                   {14.7501, 8.0001, -0.01436778937632291},
                                   {14.7501, 8.2501, -0.01737474624229973},
                                   {14.7501, 8.5001, -0.02073524525439597},
                                   {14.7501, 8.7501, -0.02443968707343579},
                                   {14.7501, 9.0001, -0.02846971975291808},
                                   {14.7501, 9.2501, -0.03279835157004663},
                                   {14.7501, 9.5001, -0.03739037710371019},
                                   {14.7501, 9.7501, -0.04220309367023022},
                                   {14.7501, 10.0001, -0.0471872724809269},
                                   {14.7501, 10.2501, -0.05228833896319108},
                                   {14.7501, 10.5001, -0.05744770987699378},
                                   {14.7501, 10.7501, -0.06260423121932003},
                                   {14.7501, 11.0001, -0.06769566029775836},
                                   {14.7501, 11.2501, -0.07266013746902853},
                                   {14.7501, 11.5001, -0.07743759745973543},
                                   {14.7501, 11.7501, -0.0819710764237407},
                                   {14.7501, 12.0001, -0.0862078784203867},
                                   {14.7501, 12.2501, -0.0901005733017598},
                                   {14.7501, 12.5001, -0.0936078065899381},
                                   {14.7501, 12.7501, -0.0966949103765799},
                                   {14.7501, 13.0001, -0.0993343122268657},
                                   {14.7501, 13.2501, -0.1015057462348752},
                                   {14.7501, 13.5001, -0.1031962765547269},
                                   {14.7501, 13.7501, -0.1044001487946781},
                                   {14.7501, 14.0001, -0.1051184885535491},
                                   {14.7501, 14.2501, -0.105358869105025},
                                   {14.7501, 14.5001, -0.1051347718507813},
                                   {14.7501, 14.7501, -0.1044649637623577},
                                   {14.7501, 15.0001, -0.1033728157366731},
                                   {14.7501, 15.2501, -0.1018855847410663},
                                   {14.7501, 15.5001, -0.1000336809690416},
                                   {14.7501, 15.7501, -0.097849939116092},
                                   {14.7501, 16.0001, -0.0953689104584832},
                                   {14.7501, 16.2501, -0.0926261898080032},
                                   {14.7501, 16.5001, -0.089657788739105},
                                   {14.7501, 16.7501, -0.0864995638414538},
                                   {14.7501, 17.0001, -0.083186706222707},
                                   {14.7501, 17.2501, -0.07975329613758636},
                                   {14.7501, 17.5001, -0.07623192449698434},
                                   {14.7501, 17.7501, -0.07265338114617059},
                                   {14.7501, 18.0001, -0.06904640821115687},
                                   {14.7501, 18.2501, -0.06543751550178174},
                                   {14.7501, 18.5001, -0.06185085392376925},
                                   {14.7501, 18.7501, -0.05830814207649542},
                                   {14.7501, 19.0001, -0.05482864067893244},
                                   {14.7501, 19.2501, -0.05142916914939488},
                                   {14.7501, 19.5001, -0.0481241585387654},
                                   {14.7501, 19.7501, -0.04492573505402513},
                                   {14.7501, 20.0001, -0.04184382858124954},
                                   {14.7501, 20.2501, -0.03888630089768386},
                                   {14.7501, 20.5001, -0.03605908862558379},
                                   {14.7501, 20.7501, -0.03336635640279568},
                                   {14.7501, 21.0001, -0.03081065620560286},
                                   {14.7501, 21.2501, -0.02839308923987756},
                                   {14.7501, 21.5001, -0.02611346730146082},
                                   {14.7501, 21.7501, -0.02397047098303648},
                                   {14.7501, 22.0001, -0.02196180256222141},
                                   {14.7501, 22.2501, -0.02008433183619906},
                                   {14.7501, 22.5001, -0.01833423356617745},
                                   {14.7501, 22.7501, -0.01670711555637877},
                                   {14.7501, 23.0001, -0.01519813671495174},
                                   {14.7501, 23.2501, -0.01380211472733592},
                                   {14.7501, 23.5001, -0.01251362321655679},
                                   {14.7501, 23.7501, -0.01132707847097383},
                                   {14.7501, 24.0001, -0.01023681599014108},
                                   {14.7501, 24.2501, -0.00923715723618679},
                                   {14.7501, 24.5001, -0.00832246708434847},
                                   {14.7501, 24.7501, -0.007487202545089557},
                                   {14.7501, 25.0001, -0.006725953384738541},
                                   {14.7501, 25.2501, -0.006033475304982772},
                                   {14.7501, 25.5001, -0.005404716356875925},
                                   {14.7501, 25.7501, -0.00483483726518805},
                                   {14.7501, 26.0001, -0.004319226326651279},
                                   {14.7501, 26.2501, -0.00385350952341862},
                                   {14.7501, 26.5001, -0.003433556463100556},
                                   {14.7501, 26.7501, -0.00305548272106736},
                                   {14.7501, 27.0001, -0.002715649121047158},
                                   {14.7501, 27.2501, -0.002410658447911862},
                                   {14.7501, 27.5001, -0.002137350043195534},
                                   {14.7501, 27.7501, -0.001892792690388422},
                                   {14.7501, 28.0001, -0.001674276154253041},
                                   {14.7501, 28.2501, -0.001479301696996997},
                                   {14.7501, 28.5001, -0.001305571854632534},
                                   {14.7501, 28.7501, -0.001150979719638427},
                                   {14.7501, 29.0001, -0.001013597941378739},
                                   {14.7501, 29.2501, -0.000891667623786485},
                                   {14.7501, 29.5001, -0.0007835872706639312},
                                   {14.7501, 29.7501, -0.0006879019025910951},
                                   {15.0001, 0.0001, -7.423553025912099e-15},
                                   {15.0001, 0.2501, -2.54673832658096e-15},
                                   {15.0001, 0.5001, -2.165166233764269e-15},
                                   {15.0001, 0.7501, -1.7238677298767e-14},
                                   {15.0001, 1.0001, -8.26129924736184e-13},
                                   {15.0001, 1.2501, -1.705141654105364e-11},
                                   {15.0001, 1.5001, -1.930919426840411e-10},
                                   {15.0001, 1.7501, -1.443578385798419e-9},
                                   {15.0001, 2.0001, -7.964867014414319e-9},
                                   {15.0001, 2.2501, -3.484934829474274e-8},
                                   {15.0001, 2.5001, -1.269976043063087e-7},
                                   {15.0001, 2.7501, -3.99183755465901e-7},
                                   {15.0001, 3.0001, -1.110554313960875e-6},
                                   {15.0001, 3.2501, -2.788746220835652e-6},
                                   {15.0001, 3.5001, -6.417936602951642e-6},
                                   {15.0001, 3.7501, -0.00001370066052858309},
                                   {15.0001, 4.0001, -0.00002739506109032963},
                                   {15.0001, 4.2501, -0.00005171810772779033},
                                   {15.0001, 4.5001, -0.0000927926923791498},
                                   {15.0001, 4.7501, -0.0001591042889012954},
                                   {15.0001, 5.0001, -0.0002619230191774178},
                                   {15.0001, 5.2501, -0.0004156412114060497},
                                   {15.0001, 5.5001, -0.0006379760038106388},
                                   {15.0001, 5.7501, -0.000949991658230398},
                                   {15.0001, 6.0001, -0.001375906665331251},
                                   {15.0001, 6.2501, -0.001942665441052073},
                                   {15.0001, 6.5001, -0.002679271933718677},
                                   {15.0001, 6.7501, -0.003615901014384543},
                                   {15.0001, 7.0001, -0.004782821303246148},
                                   {15.0001, 7.2501, -0.006209178457553809},
                                   {15.0001, 7.5001, -0.007921699609624646},
                                   {15.0001, 7.7501, -0.00994338673164828},
                                   {15.0001, 8.0001, -0.01229226882844535},
                                   {15.0001, 8.2501, -0.01498028009433476},
                                   {15.0001, 8.5001, -0.01801232399339749},
                                   {15.0001, 8.7501, -0.02138557242495784},
                                   {15.0001, 9.0001, -0.02508903571701471},
                                   {15.0001, 9.2501, -0.02910342424756978},
                                   {15.0001, 9.5001, -0.03340130712342399},
                                   {15.0001, 9.7501, -0.03794755855742977},
                                   {15.0001, 10.0001, -0.04270006923668168},
                                   {15.0001, 10.2501, -0.04761068873087716},
                                   {15.0001, 10.5001, -0.05262635630388692},
                                   {15.0001, 10.7501, -0.05769037159999666},
                                   {15.0001, 11.0001, -0.06274375361757217},
                                   {15.0001, 11.2501, -0.06772663602266466},
                                   {15.0001, 11.5001, -0.07257964892041146},
                                   {15.0001, 11.7501, -0.0772452413193042},
                                   {15.0001, 12.0001, -0.0816689042558954},
                                   {15.0001, 12.2501, -0.0858002614312144},
                                   {15.0001, 12.5001, -0.0895940017844735},
                                   {15.0001, 12.7501, -0.093010636262815},
                                   {15.0001, 13.0001, -0.0960170687541432},
                                   {15.0001, 13.2501, -0.0985869784106845},
                                   {15.0001, 13.5001, -0.1007010171491331},
                                   {15.0001, 13.7501, -0.1023468317844649},
                                   {15.0001, 14.0001, -0.1035189249221011},
                                   {15.0001, 14.2501, -0.1042183723428992},
                                   {15.0001, 14.5001, -0.1044524171679826},
                                   {15.0001, 14.7501, -0.1042339626317526},
                                   {15.0001, 15.0001, -0.1035809859033417},
                                   {15.0001, 15.2501, -0.1025158951869437},
                                   {15.0001, 15.5001, -0.101064851424269},
                                   {15.0001, 15.7501, -0.0992570744505079},
                                   {15.0001, 16.0001, -0.0971241515524963},
                                   {15.0001, 16.2501, -0.0946993641733737},
                                   {15.0001, 16.5001, -0.0920170461217159},
                                   {15.0001, 16.7501, -0.0891119841821167},
                                   {15.0001, 17.0001, -0.0860188695809734},
                                   {15.0001, 17.2501, -0.0827718064124942},
                                   {15.0001, 17.5001, -0.07940388093638728},
                                   {15.0001, 17.7501, -0.07594679366552404},
                                   {15.0001, 18.0001, -0.07243055439987454},
                                   {15.0001, 18.2501, -0.06888323884997448},
                                   {15.0001, 18.5001, -0.06533080423558644},
                                   {15.0001, 18.7501, -0.06179696024003887},
                                   {15.0001, 19.0001, -0.0583030909372768},
                                   {15.0001, 19.2501, -0.05486822277034628},
                                   {15.0001, 19.5001, -0.05150903332602295},
                                   {15.0001, 19.7501, -0.04823989549698328},
                                   {15.0001, 20.0001, -0.04507295162525253},
                                   {15.0001, 20.2501, -0.04201821235322909},
                                   {15.0001, 20.5001, -0.03908367514651742},
                                   {15.0001, 20.7501, -0.03627545777247377},
                                   {15.0001, 21.0001, -0.0335979423979318},
                                   {15.0001, 21.2501, -0.03105392638930478},
                                   {15.0001, 21.5001, -0.02864477634078284},
                                   {15.0001, 21.7501, -0.02637058230672189},
                                   {15.0001, 22.0001, -0.02423030966006005},
                                   {15.0001, 22.2501, -0.02222194642955252},
                                   {15.0001, 22.5001, -0.02034264437685792},
                                   {15.0001, 22.7501, -0.01858885245413037},
                                   {15.0001, 23.0001, -0.01695644162968188},
                                   {15.0001, 23.2501, -0.01544082038097389},
                                   {15.0001, 23.5001, -0.01403704042952778},
                                   {15.0001, 23.7501, -0.01273989253129407},
                                   {15.0001, 24.0001, -0.01154399233948801},
                                   {15.0001, 24.2501, -0.01044385652649952},
                                   {15.0001, 24.5001, -0.0094339694893696},
                                   {15.0001, 24.7501, -0.00850884107201872},
                                   {15.0001, 25.0001, -0.007663055819679183},
                                   {15.0001, 25.2501, -0.006891314339705835},
                                   {15.0001, 25.5001, -0.006188467381021235},
                                   {15.0001, 25.7501, -0.005549543264740656},
                                   {15.0001, 26.0001, -0.004969769303748667},
                                   {15.0001, 26.2501, -0.004444587841728755},
                                   {15.0001, 26.5001, -0.003969667524751623},
                                   {15.0001, 26.7501, -0.003540910393161714},
                                   {15.0001, 27.0001, -0.003154455350094527},
                                   {15.0001, 27.2501, -0.002806678527210016},
                                   {15.0001, 27.5001, -0.002494191029616178},
                                   {15.0001, 27.7501, -0.002213834501742487},
                                   {15.0001, 28.0001, -0.001962674915162926},
                                   {15.0001, 28.2501, -0.001737994938933374},
                                   {15.0001, 28.5001, -0.001537285213597132},
                                   {15.0001, 28.7501, -0.001358234812171688},
                                   {15.0001, 29.0001, -0.00119872113557005},
                                   {15.0001, 29.2501, -0.001056799456323819},
                                   {15.0001, 29.5001, -0.000930692293354215},
                                   {15.0001, 29.7501, -0.000818778771987417},
                                   {15.2501, 0.0001, -7.481329182994267e-15},
                                   {15.2501, 0.2501, -2.57335276759783e-15},
                                   {15.2501, 0.5001, -2.160067863547475e-15},
                                   {15.2501, 0.7501, -9.1139444875934e-15},
                                   {15.2501, 1.0001, -4.183463915583405e-13},
                                   {15.2501, 1.2501, -9.1141851216739e-12},
                                   {15.2501, 1.5001, -1.080351108520066e-10},
                                   {15.2501, 1.7501, -8.39549717837483e-10},
                                   {15.2501, 2.0001, -4.790111957919864e-9},
                                   {15.2501, 2.2501, -2.158774231488471e-8},
                                   {15.2501, 2.5001, -8.07792606160221e-8},
                                   {15.2501, 2.7501, -2.600600734685281e-7},
                                   {15.2501, 3.0001, -7.394904726187987e-7},
                                   {15.2501, 3.2501, -1.894672351980478e-6},
                                   {15.2501, 3.5001, -4.44227991358685e-6},
                                   {15.2501, 3.7501, -9.6489424467455e-6},
                                   {15.2501, 4.0001, -0.00001960886851513662},
                                   {15.2501, 4.2501, -0.00003758704404308414},
                                   {15.2501, 4.5001, -0.0000684142598695622},
                                   {15.2501, 4.7501, -0.000118909061976797},
                                   {15.2501, 5.0001, -0.0001982916486604475},
                                   {15.2501, 5.2501, -0.00031854738515495},
                                   {15.2501, 5.5001, -0.0004946942573191659},
                                   {15.2501, 5.7501, -0.0007449099999235549},
                                   {15.2501, 6.0001, -0.001090480940446387},
                                   {15.2501, 6.2501, -0.001555545302635062},
                                   {15.2501, 6.5001, -0.002166617797193479},
                                   {15.2501, 6.7501, -0.002951898406829298},
                                   {15.2501, 7.0001, -0.003940384792696921},
                                   {15.2501, 7.2501, -0.005160823169589098},
                                   {15.2501, 7.5001, -0.006640545462821369},
                                   {15.2501, 7.7501, -0.00840425002485917},
                                   {15.2501, 8.0001, -0.01047278849357954},
                                   {15.2501, 8.2501, -0.01286202226592088},
                                   {15.2501, 8.5001, -0.01558180868004844},
                                   {15.2501, 8.7501, -0.01863516982054179},
                                   {15.2501, 9.0001, -0.02201768661499066},
                                   {15.2501, 9.2501, -0.02571714847236478},
                                   {15.2501, 9.5001, -0.0297134750921798},
                                   {15.2501, 9.7501, -0.03397891320579843},
                                   {15.2501, 10.0001, -0.03847849777175153},
                                   {15.2501, 10.2501, -0.04317075527457114},
                                   {15.2501, 10.5001, -0.04800861683992798},
                                   {15.2501, 10.7501, -0.0529405012601117},
                                   {15.2501, 11.0001, -0.05791152291905631},
                                   {15.2501, 11.2501, -0.06286477703827089},
                                   {15.2501, 11.5001, -0.06774265450760843},
                                   {15.2501, 11.7501, -0.07248814057111199},
                                   {15.2501, 12.0001, -0.07704605547403074},
                                   {15.2501, 12.2501, -0.0813642004535695},
                                   {15.2501, 12.5001, -0.0853943787600528},
                                   {15.2501, 12.7501, -0.0890932683168585},
                                   {15.2501, 13.0001, -0.0924231297816715},
                                   {15.2501, 13.2501, -0.0953523408151737},
                                   {15.2501, 13.5001, -0.0978557540064863},
                                   {15.2501, 13.7501, -0.0999148819176914},
                                   {15.2501, 14.0001, -0.1015179179246854},
                                   {15.2501, 14.2501, -0.102659605840888},
                                   {15.2501, 14.5001, -0.1033409746620549},
                                   {15.2501, 14.7501, -0.1035689571618752},
                                   {15.2501, 15.0001, -0.1033559125375046},
                                   {15.2501, 15.2501, -0.1027190739226411},
                                   {15.2501, 15.5001, -0.101679941448046},
                                   {15.2501, 15.7501, -0.1002636407461684},
                                   {15.2501, 16.0001, -0.0984982654866416},
                                   {15.2501, 16.2501, -0.0964142208136042},
                                   {15.2501, 16.5001, -0.0940435825512268},
                                   {15.2501, 16.7501, -0.0914194848599047},
                                   {15.2501, 17.0001, -0.0885755467608697},
                                   {15.2501, 17.2501, -0.0855453456871352},
                                   {15.2501, 17.5001, -0.0823619440353739},
                                   {15.2501, 17.7501, -0.07905747264386296},
                                   {15.2501, 18.0001, -0.07566277324936142},
                                   {15.2501, 18.2501, -0.07220710031091065},
                                   {15.2501, 18.5001, -0.06871788114934391},
                                   {15.2501, 18.7501, -0.06522053214556021},
                                   {15.2501, 19.0001, -0.06173832776727718},
                                   {15.2501, 19.2501, -0.05829231844469165},
                                   {15.2501, 19.5001, -0.05490129277624173},
                                   {15.2501, 19.7501, -0.05158177919831547},
                                   {15.2501, 20.0001, -0.0483480820763237},
                                   {15.2501, 20.2501, -0.04521234714648816},
                                   {15.2501, 20.5001, -0.04218465133487337},
                                   {15.2501, 20.7501, -0.03927311217977625},
                                   {15.2501, 21.0001, -0.03648401236372017},
                                   {15.2501, 21.2501, -0.03382193520159155},
                                   {15.2501, 21.5001, -0.0312899073133674},
                                   {15.2501, 21.7501, -0.02888954511694036},
                                   {15.2501, 22.0001, -0.0266212021944773},
                                   {15.2501, 22.2501, -0.0244841150024823},
                                   {15.2501, 22.5001, -0.02247654480136961},
                                   {15.2501, 22.7501, -0.02059591406703051},
                                   {15.2501, 23.0001, -0.01883893600863357},
                                   {15.2501, 23.2501, -0.01720173614947631},
                                   {15.2501, 23.5001, -0.01567996522836182},
                                   {15.2501, 23.7501, -0.01426890294626201},
                                   {15.2501, 24.0001, -0.01296355231660437},
                                   {15.2501, 24.2501, -0.01175872457793333},
                                   {15.2501, 24.5001, -0.01064911479621952},
                                   {15.2501, 24.7501, -0.00962936842253257},
                                   {15.2501, 25.0001, -0.00869413918236274},
                                   {15.2501, 25.2501, -0.00783813875804268},
                                   {15.2501, 25.5001, -0.007056178788098608},
                                   {15.2501, 25.7501, -0.006343205749618646},
                                   {15.2501, 26.0001, -0.00569432931450981},
                                   {15.2501, 26.2501, -0.005104844780379619},
                                   {15.2501, 26.5001, -0.004570250174148683},
                                   {15.2501, 26.7501, -0.004086258613632038},
                                   {15.2501, 27.0001, -0.003648806491286329},
                                   {15.2501, 27.2501, -0.00325405801696989},
                                   {15.2501, 27.5001, -0.002898406624557961},
                                   {15.2501, 27.7501, -0.002578473712042993},
                                   {15.2501, 28.0001, -0.002291105147576588},
                                   {15.2501, 28.2501, -0.002033365935830403},
                                   {15.2501, 28.5001, -0.001802533400945577},
                                   {15.2501, 28.7501, -0.001596089204917739},
                                   {15.2501, 29.0001, -0.0014117104840934},
                                   {15.2501, 29.2501, -0.001247260351968055},
                                   {15.2501, 29.5001, -0.001100777983995447},
                                   {15.2501, 29.7501, -0.000970468469860144},
                                   {15.5001, 0.0001, -7.538272189185967e-15},
                                   {15.5001, 0.2501, -2.599658349241025e-15},
                                   {15.5001, 0.5001, -2.17132690478718e-15},
                                   {15.5001, 0.7501, -5.291759912309678e-15},
                                   {15.5001, 1.0001, -2.114266464466319e-13},
                                   {15.5001, 1.2501, -4.852252027995343e-12},
                                   {15.5001, 1.5001, -6.02008082462845e-11},
                                   {15.5001, 1.7501, -4.862792962093589e-10},
                                   {15.5001, 2.0001, -2.869093402397827e-9},
                                   {15.5001, 2.2501, -1.331835376555972e-8},
                                   {15.5001, 2.5001, -5.117218586353063e-8},
                                   {15.5001, 2.7501, -1.687342840468292e-7},
                                   {15.5001, 3.0001, -4.904032580347433e-7},
                                   {15.5001, 3.2501, -1.2819953187337e-6},
                                   {15.5001, 3.5001, -3.062265801644322e-6},
                                   {15.5001, 3.7501, -6.767740628016409e-6},
                                   {15.5001, 4.0001, -0.00001397841500332793},
                                   {15.5001, 4.2501, -0.00002720559600814246},
                                   {15.5001, 4.5001, -0.00005023465673676812},
                                   {15.5001, 4.7501, -0.0000885057367003926},
                                   {15.5001, 5.0001, -0.0001495058066753614},
                                   {15.5001, 5.2501, -0.0002431374582337564},
                                   {15.5001, 5.5001, -0.0003820245782867293},
                                   {15.5001, 5.7501, -0.0005817136764130303},
                                   {15.5001, 6.0001, -0.000860732509630165},
                                   {15.5001, 6.2501, -0.00124047471865331},
                                   {15.5001, 6.5001, -0.001744889866868276},
                                   {15.5001, 6.7501, -0.002399971564713409},
                                   {15.5001, 7.0001, -0.003233051009063528},
                                   {15.5001, 7.2501, -0.004271917907500636},
                                   {15.5001, 7.5001, -0.005543804082904659},
                                   {15.5001, 7.7501, -0.007074275943488352},
                                   {15.5001, 8.0001, -0.00888608961996787},
                                   {15.5001, 8.2501, -0.01099806641654264},
                                   {15.5001, 8.5001, -0.01342404614963296},
                                   {15.5001, 8.7501, -0.01617197214134852},
                                   {15.5001, 9.0001, -0.01924315455559025},
                                   {15.5001, 9.2501, -0.02263174908500095},
                                   {15.5001, 9.5001, -0.02632447651932515},
                                   {15.5001, 9.7501, -0.03030059630570143},
                                   {15.5001, 10.0001, -0.03453213468625635},
                                   {15.5001, 10.2501, -0.03898435612776693},
                                   {15.5001, 10.5001, -0.04361645617983931},
                                   {15.5001, 10.7501, -0.04838244509943694},
                                   {15.5001, 11.0001, -0.05323218488486882},
                                   {15.5001, 11.2501, -0.05811253793324998},
                                   {15.5001, 11.5001, -0.06296858338325282},
                                   {15.5001, 11.7501, -0.06774485721081936},
                                   {15.5001, 12.0001, -0.07238657408607945},
                                   {15.5001, 12.2501, -0.07684079257548373},
                                   {15.5001, 12.5001, -0.0810574901368114},
                                   {15.5001, 12.7501, -0.0849905201378432},
                                   {15.5001, 13.0001, -0.0885984294661006},
                                   {15.5001, 13.2501, -0.0918451218429403},
                                   {15.5001, 13.5001, -0.0947003584029388},
                                   {15.5001, 13.7501, -0.0971400931883045},
                                   {15.5001, 14.0001, -0.0991466467302474},
                                   {15.5001, 14.2501, -0.1007087256919227},
                                   {15.5001, 14.5001, -0.1018213005314383},
                                   {15.5001, 14.7501, -0.1024853562589998},
                                   {15.5001, 15.0001, -0.102707533604177},
                                   {15.5001, 15.2501, -0.1024996793093559},
                                   {15.5001, 15.5001, -0.1018783248852595},
                                   {15.5001, 15.7501, -0.100864113087655},
                                   {15.5001, 16.0001, -0.0994811906995349},
                                   {15.5001, 16.2501, -0.0977565850368419},
                                   {15.5001, 16.5001, -0.0957195800472009},
                                   {15.5001, 16.7501, -0.093401106046578},
                                   {15.5001, 17.0001, -0.0908331551382821},
                                   {15.5001, 17.2501, -0.0880482322729426},
                                   {15.5001, 17.5001, -0.0850788498163593},
                                   {15.5001, 17.7501, -0.0819570714613862},
                                   {15.5001, 18.0001, -0.07871410940434391},
                                   {15.5001, 18.2501, -0.07537997694733373},
                                   {15.5001, 18.5001, -0.07198319711473044},
                                   {15.5001, 18.7501, -0.06855056650361045},
                                   {15.5001, 19.0001, -0.06510697243276748},
                                   {15.5001, 19.2501, -0.06167526051383657},
                                   {15.5001, 19.5001, -0.0582761490345823},
                                   {15.5001, 19.7501, -0.05492818600688444},
                                   {15.5001, 20.0001, -0.05164774437459055},
                                   {15.5001, 20.2501, -0.0484490506806051},
                                   {15.5001, 20.5001, -0.04534424243806152},
                                   {15.5001, 20.7501, -0.04234344951615727},
                                   {15.5001, 21.0001, -0.0394548950162768},
                                   {15.5001, 21.2501, -0.03668501135816058},
                                   {15.5001, 21.5001, -0.03403856760010048},
                                   {15.5001, 21.7501, -0.03151880436403713},
                                   {15.5001, 22.0001, -0.0291275731104177},
                                   {15.5001, 22.2501, -0.02686547689511487},
                                   {15.5001, 22.5001, -0.0247320101299902},
                                   {15.5001, 22.7501, -0.02272569525016545},
                                   {15.5001, 23.0001, -0.02084421455699425},
                                   {15.5001, 23.2501, -0.01908453585012144},
                                   {15.5001, 23.5001, -0.0174430307805018},
                                   {15.5001, 23.7501, -0.01591558514588121},
                                   {15.5001, 24.0001, -0.01449770060932462},
                                   {15.5001, 24.2501, -0.01318458754927129},
                                   {15.5001, 24.5001, -0.01197124894655378},
                                   {15.5001, 24.7501, -0.01085255538078585},
                                   {15.5001, 25.0001, -0.00982331134701033},
                                   {15.5001, 25.2501, -0.00887831321541291},
                                   {15.5001, 25.5001, -0.00801239924444479},
                                   {15.5001, 25.7501, -0.007220492123220983},
                                   {15.5001, 26.0001, -0.006497634565018117},
                                   {15.5001, 26.2501, -0.005839018502532173},
                                   {15.5001, 26.5001, -0.005240008449663699},
                                   {15.5001, 26.7501, -0.004696159596258957},
                                   {15.5001, 27.0001, -0.004203231193592505},
                                   {15.5001, 27.2501, -0.003757195771406325},
                                   {15.5001, 27.5001, -0.00335424470381713},
                                   {15.5001, 27.7501, -0.002990790612972568},
                                   {15.5001, 28.0001, -0.002663467067393132},
                                   {15.5001, 28.2501, -0.002369125997707717},
                                   {15.5001, 28.5001, -0.002104833217025602},
                                   {15.5001, 28.7501, -0.001867862397366219},
                                   {15.5001, 29.0001, -0.00165568781811464},
                                   {15.5001, 29.2501, -0.001465976167967441},
                                   {15.5001, 29.5001, -0.001296577648735072},
                                   {15.5001, 29.7501, -0.001145516598015055},
                                   {15.7501, 0.0001, -7.594407236925122e-15},
                                   {15.7501, 0.2501, -2.625662362450786e-15},
                                   {15.7501, 0.5001, -2.189430401576289e-15},
                                   {15.7501, 0.7501, -3.507121073766916e-15},
                                   {15.7501, 1.0001, -1.068707602535959e-13},
                                   {15.7501, 1.2501, -2.573326726905324e-12},
                                   {15.7501, 1.5001, -3.341231285429174e-11},
                                   {15.7501, 1.7501, -2.805349936289577e-10},
                                   {15.7501, 2.0001, -1.711607102744189e-9},
                                   {15.7501, 2.2501, -8.1837645381266e-9},
                                   {15.7501, 2.5001, -3.22868997281947e-8},
                                   {15.7501, 2.7501, -1.090411386883008e-7},
                                   {15.7501, 3.0001, -3.239147201832537e-7},
                                   {15.7501, 3.2501, -8.63961870224899e-7},
                                   {15.7501, 3.5001, -2.102494918870537e-6},
                                   {15.7501, 3.7501, -4.727833129306143e-6},
                                   {15.7501, 4.0001, -9.92469444630312e-6},
                                   {15.7501, 4.2501, -0.00001961243633816833},
                                   {15.7501, 4.5001, -0.00003673778074842066},
                                   {15.7501, 4.7501, -0.00006561151009963268},
                                   {15.7501, 5.0001, -0.0001122699005763927},
                                   {15.7501, 5.2501, -0.0001848335736951792},
                                   {15.7501, 5.5001, -0.000293830208269548},
                                   {15.7501, 5.7501, -0.0004524441812749773},
                                   {15.7501, 6.0001, -0.0006766563714543094},
                                   {15.7501, 6.2501, -0.000985241301447625},
                                   {15.7501, 6.5001, -0.001399596294213301},
                                   {15.7501, 6.7501, -0.001943387747700791},
                                   {15.7501, 7.0001, -0.002642012042734227},
                                   {15.7501, 7.2501, -0.003521881858648295},
                                   {15.7501, 7.5001, -0.00460956159344253},
                                   {15.7501, 7.7501, -0.005930787061244057},
                                   {15.7501, 8.0001, -0.007509413744180816},
                                   {15.7501, 8.2501, -0.00936634394084609},
                                   {15.7501, 8.5001, -0.01151848580931477},
                                   {15.7501, 8.7501, -0.01397779648191461},
                                   {15.7501, 9.0001, -0.01675045734319924},
                                   {15.7501, 9.2501, -0.01983622265565291},
                                   {15.7501, 9.5001, -0.02322797360482852},
                                   {15.7501, 9.7501, -0.02691149923622325},
                                   {15.7501, 10.0001, -0.03086551442703634},
                                   {15.7501, 10.2501, -0.03506191371106466},
                                   {15.7501, 10.5001, -0.03946624911583855},
                                   {15.7501, 10.7501, -0.04403841072957555},
                                   {15.7501, 11.0001, -0.04873348091052632},
                                   {15.7501, 11.2501, -0.05350272715835573},
                                   {15.7501, 11.5001, -0.05829469481981996},
                                   {15.7501, 11.7501, -0.06305635900132314},
                                   {15.7501, 12.0001, -0.06773429519761578},
                                   {15.7501, 12.2501, -0.07227583001644462},
                                   {15.7501, 12.5001, -0.07663013671433249},
                                   {15.7501, 12.7501, -0.0807492447479924},
                                   {15.7501, 13.0001, -0.0845889378597451},
                                   {15.7501, 13.2501, -0.0881095210262895},
                                   {15.7501, 13.5001, -0.0912764425998907},
                                   {15.7501, 13.7501, -0.0940607638833102},
                                   {15.7501, 14.0001, -0.096439473969742},
                                   {15.7501, 14.2501, -0.098395652758498},
                                   {15.7501, 14.5001, -0.0999184894867317},
                                   {15.7501, 14.7501, -0.1010031678054183},
                                   {15.7501, 15.0001, -0.1016506313270215},
                                   {15.7501, 15.2501, -0.1018672456753795},
                                   {15.7501, 15.5001, -0.1016643744016635},
                                   {15.7501, 15.7501, -0.1010578867472804},
                                   {15.7501, 16.0001, -0.1000676152092033},
                                   {15.7501, 16.2501, -0.0987167802832922},
                                   {15.7501, 16.5001, -0.0970313987225331},
                                   {15.7501, 16.7501, -0.0950396902483274},
                                   {15.7501, 17.0001, -0.0927714959907872},
                                   {15.7501, 17.2501, -0.0902577200999063},
                                   {15.7501, 17.5001, -0.0875298040469173},
                                   {15.7501, 17.7501, -0.0846192411976436},
                                   {15.7501, 18.0001, -0.0815571373497146},
                                   {15.7501, 18.2501, -0.07837382113412267},
                                   {15.7501, 18.5001, -0.07509850652835991},
                                   {15.7501, 18.7501, -0.0717590082419435},
                                   {15.7501, 19.0001, -0.06838150943416537},
                                   {15.7501, 19.2501, -0.06499038011803803},
                                   {15.7501, 19.5001, -0.06160804369557285},
                                   {15.7501, 19.7501, -0.05825488835317046},
                                   {15.7501, 20.0001, -0.0549492195123047},
                                   {15.7501, 20.2501, -0.05170724916617637},
                                   {15.7501, 20.5001, -0.04854311772114134},
                                   {15.7501, 20.7501, -0.04546894388425481},
                                   {15.7501, 21.0001, -0.04249489817612433},
                                   {15.7501, 21.2501, -0.0396292957822277},
                                   {15.7501, 21.5001, -0.03687870466723802},
                                   {15.7501, 21.7501, -0.03424806514800999},
                                   {15.7501, 22.0001, -0.03174081743538357},
                                   {15.7501, 22.2501, -0.02935903399811588},
                                   {15.7501, 22.5001, -0.02710355396107824},
                                   {15.7501, 22.7501, -0.02497411711318284},
                                   {15.7501, 23.0001, -0.02296949545897427},
                                   {15.7501, 23.2501, -0.02108762059382335},
                                   {15.7501, 23.5001, -0.01932570551022668},
                                   {15.7501, 23.7501, -0.01768035974738774},
                                   {15.7501, 24.0001, -0.0161476970749322},
                                   {15.7501, 24.2501, -0.01472343515238141},
                                   {15.7501, 24.5001, -0.01340298682798627},
                                   {15.7501, 24.7501, -0.01218154293367936},
                                   {15.7501, 25.0001, -0.01105414659790644},
                                   {15.7501, 25.2501, -0.01001575923617045},
                                   {15.7501, 25.5001, -0.00906131849190205},
                                   {15.7501, 25.7501, -0.00818578848969668},
                                   {15.7501, 26.0001, -0.007384202831159087},
                                   {15.7501, 26.2501, -0.006651700812804871},
                                   {15.7501, 26.5001, -0.005983557377945694},
                                   {15.7501, 26.7501, -0.005375207332458807},
                                   {15.7501, 27.0001, -0.004822264359959464},
                                   {15.7501, 27.2501, -0.004320535367186646},
                                   {15.7501, 27.5001, -0.00386603067726421},
                                   {15.7501, 27.7501, -0.003454970568635993},
                                   {15.7501, 28.0001, -0.003083788632448156},
                                   {15.7501, 28.2501, -0.002749132392344467},
                                   {15.7501, 28.5001, -0.002447861599255857},
                                   {15.7501, 28.7501, -0.002177044580843168},
                                   {15.7501, 29.0001, -0.001933952991670399},
                                   {15.7501, 29.2501, -0.001716055276676033},
                                   {15.7501, 29.5001, -0.00152100912766681},
                                   {15.7501, 29.7501, -0.001346653180853229},
                                   {16.0001, 0.0001, -7.649758368581341e-15},
                                   {16.0001, 0.2501, -2.651372186848002e-15},
                                   {16.0001, 0.5001, -2.210304536251192e-15},
                                   {16.0001, 0.7501, -2.683268812699751e-15},
                                   {16.0001, 1.0001, -5.425946438643492e-14},
                                   {16.0001, 1.2501, -1.359744845424466e-12},
                                   {16.0001, 1.5001, -1.847176583765876e-11},
                                   {16.0001, 1.7501, -1.612048257169151e-10},
                                   {16.0001, 2.0001, -1.017071396789365e-9},
                                   {16.0001, 2.2501, -5.00890229778805e-9},
                                   {16.0001, 2.5001, -2.029105498934346e-8},
                                   {16.0001, 2.7501, -7.018793566649661e-8},
                                   {16.0001, 3.0001, -2.131043315881465e-7},
                                   {16.0001, 3.2501, -5.79944230909924e-7},
                                   {16.0001, 3.5001, -1.43783768012384e-6},
                                   {16.0001, 3.7501, -3.289749020619452e-6},
                                   {16.0001, 4.0001, -7.0187205196306e-6},
                                   {16.0001, 4.2501, -0.00001408269809599688},
                                   {16.0001, 4.5001, -0.00002676103324153651},
                                   {16.0001, 4.7501, -0.00004844719242686251},
                                   {16.0001, 5.0001, -0.0000839746296141565},
                                   {16.0001, 5.2501, -0.0001399551441094053},
                                   {16.0001, 5.5001, -0.0002251024148332558},
                                   {16.0001, 5.7501, -0.0003505087695837835},
                                   {16.0001, 6.0001, -0.0005298413948219386},
                                   {16.0001, 6.2501, -0.0007794255718897042},
                                   {16.0001, 6.5001, -0.00111818720988444},
                                   {16.0001, 6.7501, -0.001567434621650677},
                                   {16.0001, 7.0001, -0.00215046951482064},
                                   {16.0001, 7.2501, -0.002892028660750812},
                                   {16.0001, 7.5001, -0.003817569646567076},
                                   {16.0001, 7.7501, -0.004952425480625327},
                                   {16.0001, 8.0001, -0.006320862671618404},
                                   {16.0001, 8.2501, -0.007945084973964268},
                                   {16.0001, 8.5001, -0.00984422975757976},
                                   {16.0001, 8.7501, -0.01203340565000435},
                                   {16.0001, 9.0001, -0.01452281870481811},
                                   {16.0001, 9.2501, -0.01731703010028952},
                                   {16.0001, 9.5001, -0.0204143816880542},
                                   {16.0001, 9.7501, -0.02380661715576113},
                                   {16.0001, 10.0001, -0.02747871678487265},
                                   {16.0001, 10.2501, -0.031408953445542},
                                   {16.0001, 10.5001, -0.03556916721954612},
                                   {16.0001, 10.7501, -0.03992524645692491},
                                   {16.0001, 11.0001, -0.04443779463106488},
                                   {16.0001, 11.2501, -0.04906295542134929},
                                   {16.0001, 11.5001, -0.05375336325687297},
                                   {16.0001, 11.7501, -0.05845918320919029},
                                   {16.0001, 12.0001, -0.06312920262178054},
                                   {16.0001, 12.2501, -0.067711937104749},
                                   {16.0001, 12.5001, -0.07215671532136076},
                                   {16.0001, 12.7501, -0.07641471010616172},
                                   {16.0001, 13.0001, -0.0804398876038096},
                                   {16.0001, 13.2501, -0.0841898510080878},
                                   {16.0001, 13.5001, -0.087626560818345},
                                   {16.0001, 13.7501, -0.0907169190389032},
                                   {16.0001, 14.0001, -0.093433210177243},
                                   {16.0001, 14.2501, -0.0957533970369343},
                                   {16.0001, 14.5001, -0.0976612739806626},
                                   {16.0001, 14.7501, -0.0991464844299176},
                                   {16.0001, 15.0001, -0.1002044127862438},
                                   {16.0001, 15.2501, -0.1008359636596764},
                                   {16.0001, 15.5001, -0.1010472432641622},
                                   {16.0001, 15.7501, -0.100849159109063},
                                   {16.0001, 16.0001, -0.1002569547267167},
                                   {16.0001, 16.2501, -0.0992896961938528},
                                   {16.0001, 16.5001, -0.0979697267078678},
                                   {16.0001, 16.7501, -0.09632210455377},
                                   {16.0001, 17.0001, -0.094374038533174},
                                   {16.0001, 17.2501, -0.0921543334111743},
                                   {16.0001, 17.5001, -0.0896928562539785},
                                   {16.0001, 17.7501, -0.0870200327566794},
                                   {16.0001, 18.0001, -0.0841663808646436},
                                   {16.0001, 18.2501, -0.0811620872320575},
                                   {16.0001, 18.5001, -0.07803663038525128},
                                   {16.0001, 18.7501, -0.07481845290424506},
                                   {16.0001, 19.0001, -0.07153468353133043},
                                   {16.0001, 19.2501, -0.06821090887898324},
                                   {16.0001, 19.5001, -0.06487099335127931},
                                   {16.0001, 19.7501, -0.06153694501630401},
                                   {16.0001, 20.0001, -0.05822882446877188},
                                   {16.0001, 20.2501, -0.05496469319424234},
                                   {16.0001, 20.5001, -0.05176059757715262},
                                   {16.0001, 20.7501, -0.04863058446984978},
                                   {16.0001, 21.0001, -0.04558674414253904},
                                   {16.0001, 21.2501, -0.04263927644724181},
                                   {16.0001, 21.5001, -0.03979657613488757},
                                   {16.0001, 21.7501, -0.03706533344628165},
                                   {16.0001, 22.0001, -0.0344506463384333},
                                   {16.0001, 22.2501, -0.03195614099227714},
                                   {16.0001, 22.5001, -0.02958409756226582},
                                   {16.0001, 22.7501, -0.02733557846029733},
                                   {16.0001, 23.0001, -0.02521055680525539},
                                   {16.0001, 23.2501, -0.0232080430060218},
                                   {16.0001, 23.5001, -0.02132620777271677},
                                   {16.0001, 23.7501, -0.01956250016221328},
                                   {16.0001, 24.0001, -0.01791375955514924},
                                   {16.0001, 24.2501, -0.01637632072949968},
                                   {16.0001, 24.5001, -0.01494611143818306},
                                   {16.0001, 24.7501, -0.01361874211405348},
                                   {16.0001, 25.0001, -0.01238958751470266},
                                   {16.0001, 25.2501, -0.01125386028217632},
                                   {16.0001, 25.5001, -0.01020667652996397},
                                   {16.0001, 25.7501, -0.00924311368283687},
                                   {16.0001, 26.0001, -0.00835826088598583},
                                   {16.0001, 26.2501, -0.007547262370355888},
                                   {16.0001, 26.5001, -0.006805354213121807},
                                   {16.0001, 26.7501, -0.006127894967978419},
                                   {16.0001, 27.0001, -0.00551039066140656},
                                   {16.0001, 27.2501, -0.004948514660332393},
                                   {16.0001, 27.5001, -0.004438122915545216},
                                   {16.0001, 27.7501, -0.003975265075672232},
                                   {16.0001, 28.0001, -0.00355619195008222},
                                   {16.0001, 28.2501, -0.003177359777304187},
                                   {16.0001, 28.5001, -0.002835431729742535},
                                   {16.0001, 28.7501, -0.002527277056828174},
                                   {16.0001, 29.0001, -0.002249968238290009},
                                   {16.0001, 29.2501, -0.002000776487838221},
                                   {16.0001, 29.5001, -0.001777165915953941},
                                   {16.0001, 29.7501, -0.001576786629283309},
                                   {16.2501, 0.0001, -7.704348546159078e-15},
                                   {16.2501, 0.2501, -2.676795052750283e-15},
                                   {16.2501, 0.5001, -2.232213999791863e-15},
                                   {16.2501, 0.7501, -2.310529755791515e-15},
                                   {16.2501, 1.0001, -2.789725689880526e-14},
                                   {16.2501, 1.2501, -7.160921100854376e-13},
                                   {16.2501, 1.5001, -1.017280769157105e-11},
                                   {16.2501, 1.7501, -9.22754106623034e-11},
                                   {16.2501, 2.0001, -6.02023625575793e-10},
                                   {16.2501, 2.2501, -3.053835168911074e-9},
                                   {16.2501, 2.5001, -1.270268647299125e-8},
                                   {16.2501, 2.7501, -4.500351076313052e-8},
                                   {16.2501, 3.0001, -1.396577167660012e-7},
                                   {16.2501, 3.2501, -3.877825357726683e-7},
                                   {16.2501, 3.5001, -9.79477491664791e-7},
                                   {16.2501, 3.7501, -2.280197504506894e-6},
                                   {16.2501, 4.0001, -4.944327649074518e-6},
                                   {16.2501, 4.2501, -0.00001007275169835168},
                                   {16.2501, 4.5001, -0.0000194178102189864},
                                   {16.2501, 4.7501, -0.00003563396215848114},
                                   {16.2501, 5.0001, -0.00006256613159416977},
                                   {16.2501, 5.2501, -0.0001055608476864689},
                                   {16.2501, 5.5001, -0.0001717787480955253},
                                   {16.2501, 5.7501, -0.000270481724147124},
                                   {16.2501, 6.0001, -0.0004132647445107107},
                                   {16.2501, 6.2501, -0.0006142017854698272},
                                   {16.2501, 6.5001, -0.000889877601504858},
                                   {16.2501, 6.7501, -0.001259282238493006},
                                   {16.2501, 7.0001, -0.001743552853789884},
                                   {16.2501, 7.2501, -0.002365556929238761},
                                   {16.2501, 7.5001, -0.00314932152931841},
                                   {16.2501, 7.7501, -0.004119323966139596},
                                   {16.2501, 8.0001, -0.005299669196213609},
                                   {16.2501, 8.2501, -0.006713187699065837},
                                   {16.2501, 8.5001, -0.00838049384844153},
                                   {16.2501, 8.7501, -0.01031904846592753},
                                   {16.2501, 9.0001, -0.0125422701554904},
                                   {16.2501, 9.2501, -0.01505873819099319},
                                   {16.2501, 9.5001, -0.01787152540284576},
                                   {16.2501, 9.7501, -0.02097769308244507},
                                   {16.2501, 10.0001, -0.02436797190718264},
                                   {16.2501, 10.2501, -0.02802664386284653},
                                   {16.2501, 10.5001, -0.0319316306988967},
                                   {16.2501, 10.7501, -0.03605478516292324},
                                   {16.2501, 11.0001, -0.04036237262859421},
                                   {16.2501, 11.2501, -0.04481572317292915},
                                   {16.2501, 11.5001, -0.04937202798542716},
                                   {16.2501, 11.7501, -0.05398524940371475},
                                   {16.2501, 12.0001, -0.05860711095868085},
                                   {16.2501, 12.2501, -0.0631881325663673},
                                   {16.2501, 12.5001, -0.06767867632693346},
                                   {16.2501, 12.7501, -0.07202997011559916},
                                   {16.2501, 13.0001, -0.07619507905818564},
                                   {16.2501, 13.2501, -0.0801297988240133},
                                   {16.2501, 13.5001, -0.0837934491763212},
                                   {16.2501, 13.7501, -0.0871495511312725},
                                   {16.2501, 14.0001, -0.0901663761418723},
                                   {16.2501, 14.2501, -0.0928173607186038},
                                   {16.2501, 14.5001, -0.0950813846324428},
                                   {16.2501, 14.7501, -0.0969429151630448},
                                   {16.2501, 15.0001, -0.0983920236388276},
                                   {16.2501, 15.2501, -0.0994242836880391},
                                   {16.2501, 15.5001, -0.1000405631383185},
                                   {16.2501, 15.7501, -0.1002467233566355},
                                   {16.2501, 16.0001, -0.1000532410295353},
                                   {16.2501, 16.2501, -0.09947476798572},
                                   {16.2501, 16.5001, -0.0985296447170212},
                                   {16.2501, 16.7501, -0.0972393828298939},
                                   {16.2501, 17.0001, -0.095628130835321},
                                   {16.2501, 17.2501, -0.093722136541262},
                                   {16.2501, 17.5001, -0.0915492179287696},
                                   {16.2501, 17.7501, -0.0891382528473653},
                                   {16.2501, 18.0001, -0.0865186962279961},
                                   {16.2501, 18.2501, -0.0837201318461037},
                                   {16.2501, 18.5001, -0.0807718640275042},
                                   {16.2501, 18.7501, -0.0777025531211707},
                                   {16.2501, 19.0001, -0.0745398971015351},
                                   {16.2501, 19.2501, -0.07131036033544501},
                                   {16.2501, 19.5001, -0.06803894937383297},
                                   {16.2501, 19.7501, -0.06474903461619039},
                                   {16.2501, 20.0001, -0.06146221585108425},
                                   {16.2501, 20.2501, -0.05819822899647049},
                                   {16.2501, 20.5001, -0.05497489084302094},
                                   {16.2501, 20.7501, -0.05180807823199309},
                                   {16.2501, 21.0001, -0.04871173786351893},
                                   {16.2501, 21.2501, -0.0456979228169171},
                                   {16.2501, 21.5001, -0.04277685185602776},
                                   {16.2501, 21.7501, -0.03995698767352515},
                                   {16.2501, 22.0001, -0.03724513038274889},
                                   {16.2501, 22.2501, -0.03464652277849451},
                                   {16.2501, 22.5001, -0.03216496414507697},
                                   {16.2501, 22.7501, -0.02980292967770242},
                                   {16.2501, 23.0001, -0.02756169289001591},
                                   {16.2501, 23.2501, -0.02544144869637709},
                                   {16.2501, 23.5001, -0.02344143517319694},
                                   {16.2501, 23.7501, -0.02156005231227583},
                                   {16.2501, 24.0001, -0.0197949763746641},
                                   {16.2501, 24.2501, -0.01814326873159378},
                                   {16.2501, 24.5001, -0.01660147833618708},
                                   {16.2501, 24.7501, -0.01516573720369495},
                                   {16.2501, 25.0001, -0.01383184848766442},
                                   {16.2501, 25.2501, -0.01259536692419012},
                                   {16.2501, 25.5001, -0.01145167157645777},
                                   {16.2501, 25.7501, -0.01039603094786778},
                                   {16.2501, 26.0001, -0.00942366064529299},
                                   {16.2501, 26.2501, -0.00852977386595311},
                                   {16.2501, 26.5001, -0.007709625053682395},
                                   {16.2501, 26.7501, -0.006958547124868439},
                                   {16.2501, 27.0001, -0.006271982702961294},
                                   {16.2501, 27.2501, -0.005645509825117502},
                                   {16.2501, 27.5001, -0.005074862597137936},
                                   {16.2501, 27.7501, -0.004555947275193491},
                                   {16.2501, 28.0001, -0.004084854246615057},
                                   {16.2501, 28.2501, -0.003657866368837242},
                                   {16.2501, 28.5001, -0.003271464106874232},
                                   {16.2501, 28.7501, -0.002922327886771882},
                                   {16.2501, 29.0001, -0.002607338056475956},
                                   {16.2501, 29.2501, -0.00232357281749076},
                                   {16.2501, 29.5001, -0.002068304461442596},
                                   {16.2501, 29.7501, -0.001838994215943257},
                                   {16.5001, 0.0001, -7.75819971576476e-15},
                                   {16.5001, 0.2501, -2.701937964391388e-15},
                                   {16.5001, 0.5001, -2.254424489984159e-15},
                                   {16.5001, 0.7501, -2.148677621296672e-15},
                                   {16.5001, 1.0001, -1.474491556834932e-14},
                                   {16.5001, 1.2501, -3.76072832127008e-13},
                                   {16.5001, 1.5001, -5.58137637011412e-12},
                                   {16.5001, 1.7501, -5.261841188058836e-11},
                                   {16.5001, 2.0001, -3.549901964422161e-10},
                                   {16.5001, 2.2501, -1.854761814252903e-9},
                                   {16.5001, 2.5001, -7.921823049359922e-9},
                                   {16.5001, 2.7501, -2.874538415388105e-8},
                                   {16.5001, 3.0001, -9.11747648546607e-8},
                                   {16.5001, 3.2501, -2.583013201369261e-7},
                                   {16.5001, 3.5001, -6.646833258008487e-7},
                                   {16.5001, 3.7501, -1.574408001945454e-6},
                                   {16.5001, 4.0001, -3.469693342743881e-6},
                                   {16.5001, 4.2501, -7.177024198049699e-6},
                                   {16.5001, 4.5001, -0.00001403560520916728},
                                   {16.5001, 4.7501, -0.00002610914509654121},
                                   {16.5001, 5.0001, -0.00004643688621403825},
                                   {16.5001, 5.2501, -0.00007931384730780234},
                                   {16.5001, 5.5001, -0.000130584142255055},
                                   {16.5001, 5.7501, -0.000207925757976329},
                                   {16.5001, 6.0001, -0.0003211010875005285},
                                   {16.5001, 6.2501, -0.0004821454567563199},
                                   {16.5001, 6.5001, -0.0007054662757156205},
                                   {16.5001, 6.7501, -0.001007828434095623},
                                   {16.5001, 7.0001, -0.001408207011018398},
                                   {16.5001, 7.2501, -0.001927495876064814},
                                   {16.5001, 7.5001, -0.002588069716129601},
                                   {16.5001, 7.7501, -0.003413206683428709},
                                   {16.5001, 8.0001, -0.004426388428063369},
                                   {16.5001, 8.2501, -0.005650502986319943},
                                   {16.5001, 8.5001, -0.007106983176181002},
                                   {16.5001, 8.7501, -0.00881491829108422},
                                   {16.5001, 9.0001, -0.01079017965589484},
                                   {16.5001, 9.2501, -0.01304460088928106},
                                   {16.5001, 9.5001, -0.01558525157112132},
                                   {16.5001, 9.7501, -0.01841383867938684},
                                   {16.5001, 10.0001, -0.02152626401119027},
                                   {16.5001, 10.2501, -0.02491235830513176},
                                   {16.5001, 10.5001, -0.02855580445565964},
                                   {16.5001, 10.7501, -0.03243425358317728},
                                   {16.5001, 11.0001, -0.0365196292966154},
                                   {16.5001, 11.2501, -0.0407786077008402},
                                   {16.5001, 11.5001, -0.04517325392248392},
                                   {16.5001, 11.7501, -0.04966179042426438},
                                   {16.5001, 12.0001, -0.05419946832081125},
                                   {16.5001, 12.2501, -0.05873951037307013},
                                   {16.5001, 12.5001, -0.06323409330935985},
                                   {16.5001, 12.7501, -0.06763533750837274},
                                   {16.5001, 13.0001, -0.07189627373055195},
                                   {16.5001, 13.2501, -0.07597175930199567},
                                   {16.5001, 13.5001, -0.0798193197134781},
                                   {16.5001, 13.7501, -0.083399895757689},
                                   {16.5001, 14.0001, -0.0866784808528837},
                                   {16.5001, 14.2501, -0.089624637866203},
                                   {16.5001, 14.5001, -0.0922128893524526},
                                   {16.5001, 14.7501, -0.0944229794902625},
                                   {16.5001, 15.0001, -0.0962400099861394},
                                   {16.5001, 15.2501, -0.0976544557212838},
                                   {16.5001, 15.5001, -0.0986620688636803},
                                   {16.5001, 15.7501, -0.099263682518749},
                                   {16.5001, 16.0001, -0.0994649267348413},
                                   {16.5001, 16.2501, -0.0992758708294247},
                                   {16.5001, 16.5001, -0.0987106065930639},
                                   {16.5001, 16.7501, -0.0977867870125289},
                                   {16.5001, 17.0001, -0.0965251347943367},
                                   {16.5001, 17.2501, -0.0949489342357344},
                                   {16.5001, 17.5001, -0.0930835189548626},
                                   {16.5001, 17.7501, -0.0909557667287793},
                                   {16.5001, 18.0001, -0.0885936112675508},
                                   {16.5001, 18.2501, -0.0860255792399767},
                                   {16.5001, 18.5001, -0.0832803593203595},
                                   {16.5001, 18.7501, -0.080386408496928},
                                   {16.5001, 19.0001, -0.07737159941368366},
                                   {16.5001, 19.2501, -0.07426291114270594},
                                   {16.5001, 19.5001, -0.07108616452922729},
                                   {16.5001, 19.7501, -0.06786580213519521},
                                   {16.5001, 20.0001, -0.06462471183961189},
                                   {16.5001, 20.2501, -0.06138409234043623},
                                   {16.5001, 20.5001, -0.05816335814261892},
                                   {16.5001, 20.7501, -0.05498008110485245},
                                   {16.5001, 21.0001, -0.05184996524523856},
                                   {16.5001, 21.2501, -0.04878685126205157},
                                   {16.5001, 21.5001, -0.04580274709698759},
                                   {16.5001, 21.7501, -0.04290788084050488},
                                   {16.5001, 22.0001, -0.0401107723373444},
                                   {16.5001, 22.2501, -0.03741831998037324},
                                   {16.5001, 22.5001, -0.03483589936829041},
                                   {16.5001, 22.7501, -0.03236747073404775},
                                   {16.5001, 23.0001, -0.03001569231370365},
                                   {16.5001, 23.2501, -0.02778203710870385},
                                   {16.5001, 23.5001, -0.0256669107884606},
                                   {16.5001, 23.7501, -0.0236697687761404},
                                   {16.5001, 24.0001, -0.02178923085169271},
                                   {16.5001, 24.2501, -0.02002319188659778},
                                   {16.5001, 24.5001, -0.01836892759005669},
                                   {16.5001, 24.7501, -0.01682319439300937},
                                   {16.5001, 25.0001, -0.01538232282208649},
                                   {16.5001, 25.2501, -0.01404230391892675},
                                   {16.5001, 25.5001, -0.01279886844054537},
                                   {16.5001, 25.7501, -0.01164755873360459},
                                   {16.5001, 26.0001, -0.01058379331003164},
                                   {16.5001, 26.2501, -0.00960292426440045},
                                   {16.5001, 26.5001, -0.00870028776611399},
                                   {16.5001, 26.7501, -0.007871247933202664},
                                   {16.5001, 27.0001, -0.007111234451155594},
                                   {16.5001, 27.2501, -0.006415774341376813},
                                   {16.5001, 27.5001, -0.005780518311387828},
                                   {16.5001, 27.7501, -0.005201262134543737},
                                   {16.5001, 28.0001, -0.004673963512496965},
                                   {16.5001, 28.2501, -0.004194754870550174},
                                   {16.5001, 28.5001, -0.003759952525900006},
                                   {16.5001, 28.7501, -0.00336606265297566},
                                   {16.5001, 29.0001, -0.003009784449879858},
                                   {16.5001, 29.2501, -0.002688010886468466},
                                   {16.5001, 29.5001, -0.002397827388848018},
                                   {16.5001, 29.7501, -0.00213650878788532},
                                   {16.7501, 0.0001, -7.811332867305203e-15},
                                   {16.7501, 0.2501, -2.726807680924486e-15},
                                   {16.7501, 0.5001, -2.27662830609226e-15},
                                   {16.7501, 0.7501, -2.084957999330174e-15},
                                   {16.7501, 1.0001, -8.21353752310019e-15},
                                   {16.7501, 1.2501, -1.971575345628978e-13},
                                   {16.7501, 1.5001, -3.051102477636936e-12},
                                   {16.7501, 1.7501, -2.989235754111379e-11},
                                   {16.7501, 2.0001, -2.085380079779575e-10},
                                   {16.7501, 2.2501, -1.122264888999226e-9},
                                   {16.7501, 2.5001, -4.921737617093197e-9},
                                   {16.7501, 2.7501, -1.8291646967429e-8},
                                   {16.7501, 3.0001, -5.929889732860683e-8},
                                   {16.7501, 3.2501, -1.714062248712863e-7},
                                   {16.7501, 3.5001, -4.49361717597485e-7},
                                   {16.7501, 3.7501, -1.082985123444776e-6},
                                   {16.7501, 4.0001, -2.4256870796348e-6},
                                   {16.7501, 4.2501, -5.094481707873002e-6},
                                   {16.7501, 4.5001, -0.00001010696729462426},
                                   {16.7501, 4.7501, -0.00001905809767665891},
                                   {16.7501, 5.0001, -0.0000343356121417825},
                                   {16.7501, 5.2501, -0.00005936803287384294},
                                   {16.7501, 5.5001, -0.0000988936802040641},
                                   {16.7501, 5.7501, -0.0001592338387107395},
                                   {16.7501, 6.0001, -0.0002485487190686182},
                                   {16.7501, 6.2501, -0.000377051836739909},
                                   {16.7501, 6.5001, -0.0005571573635988915},
                                   {16.7501, 6.7501, -0.000803536190406597},
                                   {16.7501, 7.0001, -0.001133059913212765},
                                   {16.7501, 7.2501, -0.001564617528109162},
                                   {16.7501, 7.5001, -0.002118796873399261},
                                   {16.7501, 7.7501, -0.002817431218974164},
                                   {16.7501, 8.0001, -0.003683020194123007},
                                   {16.7501, 8.2501, -0.004738042765126186},
                                   {16.7501, 8.5001, -0.006004187562251559},
                                   {16.7501, 8.7501, -0.007501531950999918},
                                   {16.7501, 9.0001, -0.0092477054254846},
                                   {16.7501, 9.2501, -0.01125707492082551},
                                   {16.7501, 9.5001, -0.01353998941937397},
                                   {16.7501, 9.7501, -0.01610211885182222},
                                   {16.7501, 10.0001, -0.01894391800300166},
                                   {16.7501, 10.2501, -0.0220602402716453},
                                   {16.7501, 10.5001, -0.02544011912957964},
                                   {16.7501, 10.7501, -0.02906672744473171},
                                   {16.7501, 11.0001, -0.03291751694398455},
                                   {16.7501, 11.2501, -0.03696453243854255},
                                   {16.7501, 11.5001, -0.04117488840496863},
                                   {16.7501, 11.7501, -0.04551138942642397},
                                   {16.7501, 12.0001, -0.04993327108477414},
                                   {16.7501, 12.2501, -0.05439703430171368},
                                   {16.7501, 12.5001, -0.05885734391715046},
                                   {16.7501, 12.7501, -0.06326796144870228},
                                   {16.7501, 13.0001, -0.06758268241268361},
                                   {16.7501, 13.2501, -0.07175625016552263},
                                   {16.7501, 13.5001, -0.07574522076647784},
                                   {16.7501, 13.7501, -0.07950875666396445},
                                   {16.7501, 14.0001, -0.0830093308535226},
                                   {16.7501, 14.2501, -0.086213327331209},
                                   {16.7501, 14.5001, -0.08909152796909},
                                   {16.7501, 14.7501, -0.0916194801862489},
                                   {16.7501, 15.0001, -0.0937777438214653},
                                   {16.7501, 15.2501, -0.0955520193038194},
                                   {16.7501, 15.5001, -0.096933162467088},
                                   {16.7501, 15.7501, -0.0979170940958113},
                                   {16.7501, 16.0001, -0.098504614487357},
                                   {16.7501, 16.2501, -0.098701134953695},
                                   {16.7501, 16.5001, -0.0985163392804151},
                                   {16.7501, 16.7501, -0.0979637887393483},
                                   {16.7501, 17.0001, -0.0970604843604364},
                                   {16.7501, 17.2501, -0.0958263998645177},
                                   {16.7501, 17.5001, -0.0942839980046167},
                                   {16.7501, 17.7501, -0.0924577421256816},
                                   {16.7501, 18.0001, -0.0903736135983406},
                                   {16.7501, 18.2501, -0.0880586444756839},
                                   {16.7501, 18.5001, -0.0855404733235672},
                                   {16.7501, 18.7501, -0.0828469307388552},
                                   {16.7501, 19.0001, -0.0800056596439223},
                                   {16.7501, 19.2501, -0.07704377406967887},
                                   {16.7501, 19.5001, -0.07398755884583141},
                                   {16.7501, 19.7501, -0.07086221143094301},
                                   {16.7501, 20.0001, -0.0676916260539005},
                                   {16.7501, 20.2501, -0.06449821941385468},
                                   {16.7501, 20.5001, -0.06130279640294168},
                                   {16.7501, 20.7501, -0.05812445367544775},
                                   {16.7501, 21.0001, -0.05498051838464837},
                                   {16.7501, 21.2501, -0.05188651903705406},
                                   {16.7501, 21.5001, -0.04885618516336121},
                                   {16.7501, 21.7501, -0.04590147236432006},
                                   {16.7501, 22.0001, -0.04303260924510999},
                                   {16.7501, 22.2501, -0.04025816279018397},
                                   {16.7501, 22.5001, -0.03758511883836149},
                                   {16.7501, 22.7501, -0.03501897448199665},
                                   {16.7501, 23.0001, -0.03256383942177274},
                                   {16.7501, 23.2501, -0.03022254354843224},
                                   {16.7501, 23.5001, -0.02799674828398095},
                                   {16.7501, 23.7501, -0.02588705948824066},
                                   {16.7501, 24.0001, -0.02389314001394208},
                                   {16.7501, 24.2501, -0.02201382026797847},
                                   {16.7501, 24.5001, -0.02024720540232679},
                                   {16.7501, 24.7501, -0.01859077801099033},
                                   {16.7501, 25.0001, -0.0170414954456989},
                                   {16.7501, 25.2501, -0.01559588108056629},
                                   {16.7501, 25.5001, -0.01425010905286068},
                                   {16.7501, 25.7501, -0.01300008218265094},
                                   {16.7501, 26.0001, -0.01184150292815095},
                                   {16.7501, 26.2501, -0.01076993736642134},
                                   {16.7501, 26.5001, -0.00978087230145818},
                                   {16.7501, 26.7501, -0.00886976569468415},
                                   {16.7501, 27.0001, -0.00803209068778989},
                                   {16.7501, 27.2501, -0.007263373546246642},
                                   {16.7501, 27.5001, -0.006559225895226267},
                                   {16.7501, 27.7501, -0.005915371649763323},
                                   {16.7501, 28.0001, -0.005327669059420077},
                                   {16.7501, 28.2501, -0.004792128296069905},
                                   {16.7501, 28.5001, -0.004304925013231803},
                                   {16.7501, 28.7501, -0.00386241029810928},
                                   {16.7501, 29.0001, -0.003461117424444494},
                                   {16.7501, 29.2501, -0.003097765796709093},
                                   {16.7501, 29.5001, -0.002769262455109118},
                                   {16.7501, 29.7501, -0.002472701487350917},
                                   {17.0001, 0.0001, -7.863768089836304e-15},
                                   {17.0001, 0.2501, -2.751410717722573e-15},
                                   {17.0001, 0.5001, -2.298698734315481e-15},
                                   {17.0001, 0.7501, -2.06666533773092e-15},
                                   {17.0001, 1.0001, -4.9874399208661e-15},
                                   {17.0001, 1.2501, -1.0337958115839e-13},
                                   {17.0001, 1.5001, -1.662083248472318e-12},
                                   {17.0001, 1.7501, -1.691924182461592e-11},
                                   {17.0001, 2.0001, -1.220519825928342e-10},
                                   {17.0001, 2.2501, -6.765372424106211e-10},
                                   {17.0001, 2.5001, -3.04649132871238e-9},
                                   {17.0001, 2.7501, -1.15964457242878e-8},
                                   {17.0001, 3.0001, -3.842423932622837e-8},
                                   {17.0001, 3.2501, -1.133215751916289e-7},
                                   {17.0001, 3.5001, -3.02665418950752e-7},
                                   {17.0001, 3.7501, -7.421856868795161e-7},
                                   {17.0001, 4.0001, -1.689517937513645e-6},
                                   {17.0001, 4.2501, -3.602794178011301e-6},
                                   {17.0001, 4.5001, -7.250933967376074e-6},
                                   {17.0001, 4.7501, -0.00001385955759437789},
                                   {17.0001, 5.0001, -0.00002529350361572477},
                                   {17.0001, 5.2501, -0.00004427294225245165},
                                   {17.0001, 5.5001, -0.00007461537558563974},
                                   {17.0001, 5.7501, -0.0001214909013355383},
                                   {17.0001, 6.0001, -0.0001916735737228859},
                                   {17.0001, 6.2501, -0.0002937681143146516},
                                   {17.0001, 6.5001, -0.0004383891254970663},
                                   {17.0001, 6.7501, -0.000638269713445923},
                                   {17.0001, 7.0001, -0.00090827821909608},
                                   {17.0001, 7.2501, -0.001265325555262862},
                                   {17.0001, 7.5001, -0.001728151220219559},
                                   {17.0001, 7.7501, -0.002316982991196503},
                                   {17.0001, 8.0001, -0.003053073056099681},
                                   {17.0001, 8.2501, -0.003958121309653694},
                                   {17.0001, 8.5001, -0.005053604104600103},
                                   {17.0001, 8.7501, -0.006360033342046199},
                                   {17.0001, 9.0001, -0.00789617593642001},
                                   {17.0001, 9.2501, -0.0096782670588329},
                                   {17.0001, 9.5001, -0.01171925195613805},
                                   {17.0001, 9.7501, -0.01402809052274809},
                                   {17.0001, 10.0001, -0.01660915627305582},
                                   {17.0001, 10.2501, -0.01946175715222881},
                                   {17.0001, 10.5001, -0.02257980005610772},
                                   {17.0001, 10.7501, -0.02595161439470095},
                                   {17.0001, 11.0001, -0.02955994294714741},
                                   {17.0001, 11.2501, -0.03338210103776082},
                                   {17.0001, 11.5001, -0.03739029810433855},
                                   {17.0001, 11.7501, -0.04155210937364034},
                                   {17.0001, 12.0001, -0.04583107988228887},
                                   {17.0001, 12.2501, -0.05018743868757158},
                                   {17.0001, 12.5001, -0.05457889792742164},
                                   {17.0001, 12.7501, -0.05896150946232605},
                                   {17.0001, 13.0001, -0.06329055114487918},
                                   {17.0001, 13.2501, -0.06752141523632027},
                                   {17.0001, 13.5001, -0.07161047299682909},
                                   {17.0001, 13.7501, -0.07551589185557289},
                                   {17.0001, 14.0001, -0.07919838463313611},
                                   {17.0001, 14.2501, -0.0826218738485469},
                                   {17.0001, 14.5001, -0.0857540580019782},
                                   {17.0001, 14.7501, -0.0885668706987502},
                                   {17.0001, 15.0001, -0.0910368274042703},
                                   {17.0001, 15.2501, -0.0931452583495127},
                                   {17.0001, 15.5001, -0.0948784295250916},
                                   {17.0001, 15.7501, -0.0962275567191127},
                                   {17.0001, 16.0001, -0.0971887201075939},
                                   {17.0001, 16.2501, -0.0977626889604583},
                                   {17.0001, 16.5001, -0.0979546675690448},
                                   {17.0001, 16.7501, -0.0977739745418567},
                                   {17.0001, 17.0001, -0.0972336681804451},
                                   {17.0001, 17.2501, -0.0963501307772702},
                                   {17.0001, 17.5001, -0.0951426244225809},
                                   {17.0001, 17.7501, -0.0936328303248719},
                                   {17.0001, 18.0001, -0.0918443827997952},
                                   {17.0001, 18.2501, -0.0898024080265856},
                                   {17.0001, 18.5001, -0.0875330764683763},
                                   {17.0001, 18.7501, -0.085063176558849},
                                   {17.0001, 19.0001, -0.0824197159229626},
                                   {17.0001, 19.2501, -0.07962955506844916},
                                   {17.0001, 19.5001, -0.07671907719504821},
                                   {17.0001, 19.7501, -0.07371389655087302},
                                   {17.0001, 20.0001, -0.07063860664378723},
                                   {17.0001, 20.2501, -0.06751656860759761},
                                   {17.0001, 20.5001, -0.0643697391395502},
                                   {17.0001, 20.7501, -0.0612185366729195},
                                   {17.0001, 21.0001, -0.0580817438275343},
                                   {17.0001, 21.2501, -0.0549764436890217},
                                   {17.0001, 21.5001, -0.05191798709826666},
                                   {17.0001, 21.7501, -0.04891998787746086},
                                   {17.0001, 22.0001, -0.04599434276770038},
                                   {17.0001, 22.2501, -0.04315127279374064},
                                   {17.0001, 22.5001, -0.04039938279192149},
                                   {17.0001, 22.7501, -0.03774573592495438},
                                   {17.0001, 23.0001, -0.0351959401499524},
                                   {17.0001, 23.2501, -0.03275424379204892},
                                   {17.0001, 23.5001, -0.03042363759423995},
                                   {17.0001, 23.7501, -0.02820596085469509},
                                   {17.0001, 24.0001, -0.02610200951678023},
                                   {17.0001, 24.2501, -0.02411164433661726},
                                   {17.0001, 24.5001, -0.02223389751151346},
                                   {17.0001, 24.7501, -0.0204670764044962},
                                   {17.0001, 25.0001, -0.01880886324103276},
                                   {17.0001, 25.2501, -0.01725640988035315},
                                   {17.0001, 25.5001, -0.01580642697310081},
                                   {17.0001, 25.7501, -0.01445526700760549},
                                   {17.0001, 26.0001, -0.01319900091792597},
                                   {17.0001, 26.2501, -0.0120334880775811},
                                   {17.0001, 26.5001, -0.01095443963373396},
                                   {17.0001, 26.7501, -0.00995747524809116},
                                   {17.0001, 27.0001, -0.00903817340383842},
                                   {17.0001, 27.2501, -0.00819211551371554},
                                   {17.0001, 27.5001, -0.007414924124178932},
                                   {17.0001, 27.7501, -0.006702295555961262},
                                   {17.0001, 28.0001, -0.006050027353730397},
                                   {17.0001, 28.2501, -0.005454040938499504},
                                   {17.0001, 28.5001, -0.004910399867451066},
                                   {17.0001, 28.7501, -0.004415324108357535},
                                   {17.0001, 29.0001, -0.003965200731182028},
                                   {17.0001, 29.2501, -0.003556591409001084},
                                   {17.0001, 29.5001, -0.00318623710527983},
                                   {17.0001, 29.7501, -0.002851060305807933},
                                   {17.2501, 0.0001, -7.915524622938584e-15},
                                   {17.2501, 0.2501, -2.775753354471058e-15},
                                   {17.2501, 0.5001, -2.320585472625406e-15},
                                   {17.2501, 0.7501, -2.069263425401034e-15},
                                   {17.2501, 1.0001, -3.404887753060803e-15},
                                   {17.2501, 1.2501, -5.44162086286443e-14},
                                   {17.2501, 1.5001, -9.0246508086288e-13},
                                   {17.2501, 1.7501, -9.54178279238976e-12},
                                   {17.2501, 2.0001, -7.117369373255942e-11},
                                   {17.2501, 2.2501, -4.063505912665286e-10},
                                   {17.2501, 2.5001, -1.878855154424062e-9},
                                   {17.2501, 2.7501, -7.325007756198133e-9},
                                   {17.2501, 3.0001, -2.48070063973798e-8},
                                   {17.2501, 3.2501, -7.464632079264804e-8},
                                   {17.2501, 3.5001, -2.031134780645258e-7},
                                   {17.2501, 3.7501, -5.067704905189557e-7},
                                   {17.2501, 4.0001, -1.172462559566344e-6},
                                   {17.2501, 4.2501, -2.538554870369365e-6},
                                   {17.2501, 4.5001, -5.18291679598633e-6},
                                   {17.2501, 4.7501, -0.00001004213247532791},
                                   {17.2501, 5.0001, -0.00001856434075132089},
                                   {17.2501, 5.2501, -0.00003289501257924216},
                                   {17.2501, 5.5001, -0.0000560910650352335},
                                   {17.2501, 5.7501, -0.0000923543478836371},
                                   {17.2501, 6.0001, -0.0001472711931662246},
                                   {17.2501, 6.2501, -0.000228040912170463},
                                   {17.2501, 6.5001, -0.0003436733589155898},
                                   {17.2501, 6.7501, -0.0005051343695906007},
                                   {17.2501, 7.0001, -0.0007254183074063212},
                                   {17.2501, 7.2501, -0.00101952919218454},
                                   {17.2501, 7.5001, -0.00140435588887294},
                                   {17.2501, 7.7501, -0.001898432310921507},
                                   {17.2501, 8.0001, -0.002521580162340693},
                                   {17.2501, 8.2501, -0.00329443889723515},
                                   {17.2501, 8.5001, -0.004237894771885537},
                                   {17.2501, 8.7501, -0.005372427561950687},
                                   {17.2501, 9.0001, -0.006717399229376092},
                                   {17.2501, 9.2501, -0.00829031315540211},
                                   {17.2501, 9.5001, -0.01010607523173396},
                                   {17.2501, 9.7501, -0.0121762889781864},
                                   {17.2501, 10.0001, -0.01450861592257208},
                                   {17.2501, 10.2501, -0.01710622985190784},
                                   {17.2501, 10.5001, -0.01996738944312066},
                                   {17.2501, 10.7501, -0.02308514850679299},
                                   {17.2501, 11.0001, -0.02644721698199688},
                                   {17.2501, 11.2501, -0.03003597928064203},
                                   {17.2501, 11.5001, -0.03382866996963495},
                                   {17.2501, 11.7501, -0.03779770044563821},
                                   {17.2501, 12.0001, -0.0419111245022513},
                                   {17.2501, 12.2501, -0.04613322575637286},
                                   {17.2501, 12.5001, -0.05042520596631163},
                                   {17.2501, 12.7501, -0.05474595044679913},
                                   {17.2501, 13.0001, -0.05905284510622723},
                                   {17.2501, 13.2501, -0.06330261907859002},
                                   {17.2501, 13.5001, -0.06745218742328247},
                                   {17.2501, 13.7501, -0.07145946980411012},
                                   {17.2501, 14.0001, -0.0752841632873945},
                                   {17.2501, 14.2501, -0.07888845025087877},
                                   {17.2501, 14.5001, -0.0822376256941958},
                                   {17.2501, 14.7501, -0.085300631812587},
                                   {17.2501, 15.0001, -0.0880504913719064},
                                   {17.2501, 15.2501, -0.0904646350537308},
                                   {17.2501, 15.5001, -0.0925251213939141},
                                   {17.2501, 15.7501, -0.0942187511087859},
                                   {17.2501, 16.0001, -0.0955370804078361},
                                   {17.2501, 16.2501, -0.0964763402724783},
                                   {17.2501, 16.5001, -0.0970372706034532},
                                   {17.2501, 16.7501, -0.0972248795925679},
                                   {17.2501, 17.0001, -0.0970481396647943},
                                   {17.2501, 17.2501, -0.096519631887404},
                                   {17.2501, 17.5001, -0.0956551508896444},
                                   {17.2501, 17.7501, -0.094473282124804},
                                   {17.2501, 18.0001, -0.0929949627880021},
                                   {17.2501, 18.2501, -0.0912430369326818},
                                   {17.2501, 18.5001, -0.0892418143624337},
                                   {17.2501, 18.7501, -0.0870166417669117},
                                   {17.2501, 19.0001, -0.084593493372586},
                                   {17.2501, 19.2501, -0.0819985871378094},
                                   {17.2501, 19.5001, -0.07925803127862505},
                                   {17.2501, 19.7501, -0.0763975047023923},
                                   {17.2501, 20.0001, -0.07344197377984968},
                                   {17.2501, 20.2501, -0.07041544682562394},
                                   {17.2501, 20.5001, -0.06734076669935378},
                                   {17.2501, 20.7501, -0.06423944109585003},
                                   {17.2501, 21.0001, -0.06113150936931491},
                                   {17.2501, 21.2501, -0.05803544413539729},
                                   {17.2501, 21.5001, -0.05496808541380235},
                                   {17.2501, 21.7501, -0.05194460470823579},
                                   {17.2501, 22.0001, -0.04897849616214915},
                                   {17.2501, 22.2501, -0.04608159176876309},
                                   {17.2501, 22.5001, -0.04326409754165907},
                                   {17.2501, 22.7501, -0.0405346475566135},
                                   {17.2501, 23.0001, -0.03790037284481076},
                                   {17.2501, 23.2501, -0.03536698224073447},
                                   {17.2501, 23.5001, -0.03293885245394355},
                                   {17.2501, 23.7501, -0.03061912483229235},
                                   {17.2501, 24.0001, -0.02840980650549021},
                                   {17.2501, 24.2501, -0.02631187383370331},
                                   {17.2501, 24.5001, -0.02432537632869554},
                                   {17.2501, 24.7501, -0.02244953945834483},
                                   {17.2501, 25.0001, -0.02068286498386123},
                                   {17.2501, 25.2501, -0.01902322770827656},
                                   {17.2501, 25.5001, -0.0174679677313248},
                                   {17.2501, 25.7501, -0.01601397750710397},
                                   {17.2501, 26.0001, -0.01465778318510967},
                                   {17.2501, 26.2501, -0.01339561988125088},
                                   {17.2501, 26.5001, -0.01222350067279595},
                                   {17.2501, 26.7501, -0.01113727923984902},
                                   {17.2501, 27.0001, -0.01013270618634321},
                                   {17.2501, 27.2501, -0.00920547916640515},
                                   {17.2501, 27.5001, -0.00835128701830267},
                                   {17.2501, 27.7501, -0.00756584816922617},
                                   {17.2501, 28.0001, -0.006844943621191821},
                                   {17.2501, 28.2501, -0.006184444862781671},
                                   {17.2501, 28.5001, -0.005580337074669004},
                                   {17.2501, 28.7501, -0.005028738010323003},
                                   {17.2501, 29.0001, -0.004525912938312114},
                                   {17.2501, 29.2501, -0.004068286030532108},
                                   {17.2501, 29.5001, -0.003652448572694306},
                                   {17.2501, 29.7501, -0.003275164360648814},
                                   {17.5001, 0.0001, -7.966620904458452e-15},
                                   {17.5001, 0.2501, -2.799841645229674e-15},
                                   {17.5001, 0.5001, -2.342270294379889e-15},
                                   {17.5001, 0.7501, -2.081376197598643e-15},
                                   {17.5001, 1.0001, -2.636395599225226e-15},
                                   {17.5001, 1.2501, -2.895084906959204e-14},
                                   {17.5001, 1.5001, -4.88606214227934e-13},
                                   {17.5001, 1.7501, -5.362161741232232e-12},
                                   {17.5001, 2.0001, -4.135550603596443e-11},
                                   {17.5001, 2.2501, -2.431902013776424e-10},
                                   {17.5001, 2.5001, -1.154573383003499e-9},
                                   {17.5001, 2.7501, -4.610259785339398e-9},
                                   {17.5001, 3.0001, -1.595794239724158e-8},
                                   {17.5001, 3.2501, -4.899334092703162e-8},
                                   {17.5001, 3.5001, -1.35814756661406e-7},
                                   {17.5001, 3.7501, -3.447797948785956e-7},
                                   {17.5001, 4.0001, -8.10711634595195e-7},
                                   {17.5001, 4.2501, -1.782232800030908e-6},
                                   {17.5001, 4.5001, -3.69134681948001e-6},
                                   {17.5001, 4.7501, -7.249906871902093e-6},
                                   {17.5001, 5.0001, -0.00001357624198531661},
                                   {17.5001, 5.2501, -0.00002435290878779122},
                                   {17.5001, 5.5001, -0.00004201339605692267},
                                   {17.5001, 5.7501, -0.00006995187022043037},
                                   {17.5001, 6.0001, -0.0001127460730111276},
                                   {17.5001, 6.2501, -0.000176379705018439},
                                   {17.5001, 6.5001, -0.0002684475087558264},
                                   {17.5001, 6.7501, -0.0003983242208213094},
                                   {17.5001, 7.0001, -0.0005772779205906089},
                                   {17.5001, 7.2501, -0.000818509254872787},
                                   {17.5001, 7.5001, -0.001137100599820844},
                                   {17.5001, 7.7501, -0.001549863309005493},
                                   {17.5001, 8.0001, -0.002075076520952544},
                                   {17.5001, 8.2501, -0.002732117176838238},
                                   {17.5001, 8.5001, -0.003540987471183701},
                                   {17.5001, 8.7501, -0.004521752437748282},
                                   {17.5001, 9.0001, -0.005693906287327971},
                                   {17.5001, 9.2501, -0.00707569104706664},
                                   {17.5001, 9.5001, -0.00868339467225021},
                                   {17.5001, 9.7501, -0.01053065788938146},
                                   {17.5001, 10.0001, -0.01262781947956265},
                                   {17.5001, 10.2501, -0.01498132853702515},
                                   {17.5001, 10.5001, -0.01759324955946782},
                                   {17.5001, 10.7501, -0.02046088225509143},
                                   {17.5001, 11.0001, -0.02357651296398226},
                                   {17.5001, 11.2501, -0.02692730890995365},
                                   {17.5001, 11.5001, -0.03049536046226742},
                                   {17.5001, 11.7501, -0.03425787052867659},
                                   {17.5001, 12.0001, -0.03818748443029572},
                                   {17.5001, 12.2501, -0.04225274839170158},
                                   {17.5001, 12.5001, -0.04641868033025633},
                                   {17.5001, 12.7501, -0.05064743310127695},
                                   {17.5001, 13.0001, -0.05489902784309636},
                                   {17.5001, 13.2501, -0.05913213360132171},
                                   {17.5001, 13.5001, -0.06330486897319365},
                                   {17.5001, 13.7501, -0.06737560203243493},
                                   {17.5001, 14.0001, -0.07130372616614304},
                                   {17.5001, 14.2501, -0.07505039154417674},
                                   {17.5001, 14.5001, -0.07857917459650525},
                                   {17.5001, 14.7501, -0.0818566709354689},
                                   {17.5001, 15.0001, -0.0848530004687557},
                                   {17.5001, 15.2501, -0.0875422168539698},
                                   {17.5001, 15.5001, -0.0899026168095903},
                                   {17.5001, 15.7501, -0.091916948000655},
                                   {17.5001, 16.0001, -0.0935725171623468},
                                   {17.5001, 16.2501, -0.0948612027348129},
                                   {17.5001, 16.5001, -0.0957793785044911},
                                   {17.5001, 16.7501, -0.0963277565489775},
                                   {17.5001, 17.0001, -0.0965111591518941},
                                   {17.5001, 17.2501, -0.0963382302966383},
                                   {17.5001, 17.5001, -0.0958210978834008},
                                   {17.5001, 17.7501, -0.0949749979743115},
                                   {17.5001, 18.0001, -0.0938178721977782},
                                   {17.5001, 18.2501, -0.0923699489817587},
                                   {17.5001, 18.5001, -0.0906533185869595},
                                   {17.5001, 18.7501, -0.0886915110259016},
                                   {17.5001, 19.0001, -0.0865090849325455},
                                   {17.5001, 19.2501, -0.0841312343372005},
                                   {17.5001, 19.5001, -0.0815834191463367},
                                   {17.5001, 19.7501, -0.07889102396541952},
                                   {17.5001, 20.0001, -0.07607904876836711},
                                   {17.5001, 20.2501, -0.07317183383736747},
                                   {17.5001, 20.5001, -0.07019282039356424},
                                   {17.5001, 20.7501, -0.06716434742896986},
                                   {17.5001, 21.0001, -0.06410748444415919},
                                   {17.5001, 21.2501, -0.06104189910137724},
                                   {17.5001, 21.5001, -0.05798575822104287},
                                   {17.5001, 21.7501, -0.05495566008005655},
                                   {17.5001, 22.0001, -0.0519665956086808},
                                   {17.5001, 22.2501, -0.04903193582256584},
                                   {17.5001, 22.5001, -0.04616344265948151},
                                   {17.5001, 22.7501, -0.04337130030699758},
                                   {17.5001, 23.0001, -0.0406641640974833},
                                   {17.5001, 23.2501, -0.03804922409979947},
                                   {17.5001, 23.5001, -0.03553228064238435},
                                   {17.5001, 23.7501, -0.0331178291498615},
                                   {17.5001, 24.0001, -0.03080915185514841},
                                   {17.5001, 24.2501, -0.02860841415237356},
                                   {17.5001, 24.5001, -0.02651676357461723},
                                   {17.5001, 24.7501, -0.02453442960740497},
                                   {17.5001, 25.0001, -0.02266082277778644},
                                   {17.5001, 25.2501, -0.02089463168447167},
                                   {17.5001, 25.5001, -0.01923391685254746},
                                   {17.5001, 25.7501, -0.01767620050332282},
                                   {17.5001, 26.0001, -0.01621855152323432},
                                   {17.5001, 26.2501, -0.0148576650936093},
                                   {17.5001, 26.5001, -0.01358993660422602},
                                   {17.5001, 26.7501, -0.01241152961739457},
                                   {17.5001, 27.0001, -0.01131843777557102},
                                   {17.5001, 27.2501, -0.01030654065458149},
                                   {17.5001, 27.5001, -0.0093716536569751},
                                   {17.5001, 27.7501, -0.00850957211670729},
                                   {17.5001, 28.0001, -0.007716109848333195},
                                   {17.5001, 28.2501, -0.00698713242235331},
                                   {17.5001, 28.5001, -0.006318585484574044},
                                   {17.5001, 28.7501, -0.005706518462634801},
                                   {17.5001, 29.0001, -0.005147104018525511},
                                   {17.5001, 29.2501, -0.004636653613259659},
                                   {17.5001, 29.5001, -0.004171629550113309},
                                   {17.5001, 29.7501, -0.003748653857154963},
                                   {17.7501, 0.0001, -8.01707461492073e-15},
                                   {17.7501, 0.2501, -2.823681428768465e-15},
                                   {17.7501, 0.5001, -2.363748330768197e-15},
                                   {17.7501, 0.7501, -2.097750890396834e-15},
                                   {17.7501, 1.0001, -2.269541282481344e-15},
                                   {17.7501, 1.2501, -1.575935805825232e-14},
                                   {17.7501, 1.5001, -2.639594113051445e-13},
                                   {17.7501, 1.7501, -3.002992908595289e-12},
                                   {17.7501, 2.0001, -2.394477227272476e-11},
                                   {17.7501, 2.2501, -1.450273253711408e-10},
                                   {17.7501, 2.5001, -7.069798769428893e-10},
                                   {17.7501, 2.7501, -2.891340192804996e-9},
                                   {17.7501, 3.0001, -1.022904899995783e-8},
                                   {17.7501, 3.2501, -3.204209784570608e-8},
                                   {17.7501, 3.5001, -9.04919326557574e-8},
                                   {17.7501, 3.7501, -2.337364627343715e-7},
                                   {17.7501, 4.0001, -5.585827427635085e-7},
                                   {17.7501, 4.2501, -1.246796393073486e-6},
                                   {17.7501, 4.5001, -2.619680090530982e-6},
                                   {17.7501, 4.7501, -5.215444061352051e-6},
                                   {17.7501, 5.0001, -9.89308178111556e-6},
                                   {17.7501, 5.2501, -0.00001796483543119369},
                                   {17.7501, 5.5001, -0.00003135690194594965},
                                   {17.7501, 5.7501, -0.0000527949313646526},
                                   {17.7501, 6.0001, -0.0000860073624515422},
                                   {17.7501, 6.2501, -0.0001359360747516016},
                                   {17.7501, 6.5001, -0.0002089406086398164},
                                   {17.7501, 6.7501, -0.0003129797113970907},
                                   {17.7501, 7.0001, -0.0004577525524580964},
                                   {17.7501, 7.2501, -0.0006547818650235307},
                                   {17.7501, 7.5001, -0.000917422639921136},
                                   {17.7501, 7.7501, -0.001260782807462335},
                                   {17.7501, 8.0001, -0.001701546443294928},
                                   {17.7501, 8.2501, -0.002257695153694322},
                                   {17.7501, 8.5001, -0.002948129071466187},
                                   {17.7501, 8.7501, -0.003792194907423681},
                                   {17.7501, 9.0001, -0.004809134320135804},
                                   {17.7501, 9.2501, -0.006017471076490252},
                                   {17.7501, 9.5001, -0.007434359721290596},
                                   {17.7501, 9.7501, -0.00907492148055935},
                                   {17.7501, 10.0001, -0.01095159471318352},
                                   {17.7501, 10.2501, -0.01307352732653665},
                                   {17.7501, 10.5001, -0.01544603721397202},
                                   {17.7501, 10.7501, -0.01807016407867803},
                                   {17.7501, 11.0001, -0.02094233217934011},
                                   {17.7501, 11.2501, -0.02405413882543884},
                                   {17.7501, 11.5001, -0.02739227815612854},
                                   {17.7501, 11.7501, -0.03093860416213827},
                                   {17.7501, 12.0001, -0.03467033135374708},
                                   {17.7501, 12.2501, -0.03856036621395414},
                                   {17.7501, 12.5001, -0.0425777578406604},
                                   {17.7501, 12.7501, -0.04668825216328421},
                                   {17.7501, 13.0001, -0.05085493095260217},
                                   {17.7501, 13.2501, -0.05503891460753298},
                                   {17.7501, 13.5001, -0.05920010642563706},
                                   {17.7501, 13.7501, -0.0632979557232941},
                                   {17.7501, 14.0001, -0.06729221770306864},
                                   {17.7501, 14.2501, -0.07114368927230617},
                                   {17.7501, 14.5001, -0.07481490197642802},
                                   {17.7501, 14.7501, -0.07827075568487986},
                                   {17.7501, 15.0001, -0.0814790795121845},
                                   {17.7501, 15.2501, -0.0844111095264982},
                                   {17.7501, 15.5001, -0.0870418759559632},
                                   {17.7501, 15.7501, -0.0893504957238083},
                                   {17.7501, 16.0001, -0.0913203691176492},
                                   {17.7501, 16.2501, -0.0929392821366403},
                                   {17.7501, 16.5001, -0.0941994184920253},
                                   {17.7501, 16.7501, -0.0950972873124974},
                                   {17.7501, 17.0001, -0.0956335742954647},
                                   {17.7501, 17.2501, -0.0958129253366862},
                                   {17.7501, 17.5001, -0.0956436725676965},
                                   {17.7501, 17.7501, -0.0951375132503861},
                                   {17.7501, 18.0001, -0.0943091521494607},
                                   {17.7501, 18.2501, -0.0931759178629141},
                                   {17.7501, 18.5001, -0.0917573631804976},
                                   {17.7501, 18.7501, -0.0900748589061269},
                                   {17.7501, 19.0001, -0.0881511897690571},
                                   {17.7501, 19.2501, -0.0860101601066042},
                                   {17.7501, 19.5001, -0.0836762159721261},
                                   {17.7501, 19.7501, -0.0811740892463783},
                                   {17.7501, 20.0001, -0.07852846824447478},
                                   {17.7501, 20.2501, -0.07576369824587168},
                                   {17.7501, 20.5001, -0.07290351435729994},
                                   {17.7501, 20.7501, -0.06997080816940354},
                                   {17.7501, 21.0001, -0.06698742880295043},
                                   {17.7501, 21.2501, -0.06397401817101132},
                                   {17.7501, 21.5001, -0.06094987961620928},
                                   {17.7501, 21.7501, -0.05793287851988602},
                                   {17.7501, 22.0001, -0.05493937302229376},
                                   {17.7501, 22.2501, -0.05198417263637638},
                                   {17.7501, 22.5001, -0.04908052227676235},
                                   {17.7501, 22.7501, -0.04624010905293502},
                                   {17.7501, 23.0001, -0.04347308908262383},
                                   {17.7501, 23.2501, -0.04078813155893488},
                                   {17.7501, 23.5001, -0.038192477342889},
                                   {17.7501, 23.7501, -0.03569200944208586},
                                   {17.7501, 24.0001, -0.03329133286662281},
                                   {17.7501, 24.2501, -0.03099386151608625},
                                   {17.7501, 24.5001, -0.02880190993794729},
                                   {17.7501, 24.7501, -0.02671678800033568},
                                   {17.7501, 25.0001, -0.02473889673406972},
                                   {17.7501, 25.2501, -0.02286782381399591},
                                   {17.7501, 25.5001, -0.02110243736303352},
                                   {17.7501, 25.7501, -0.01944097696958573},
                                   {17.7501, 26.0001, -0.01788114100675865},
                                   {17.7501, 26.2501, -0.01642016952748318},
                                   {17.7501, 26.5001, -0.01505492218123001},
                                   {17.7501, 26.7501, -0.01378195075424747},
                                   {17.7501, 27.0001, -0.01259756607539335},
                                   {17.7501, 27.2501, -0.01149789915341297},
                                   {17.7501, 27.5001, -0.01047895651907518},
                                   {17.7501, 27.7501, -0.00953666983738436},
                                   {17.7501, 28.0001, -0.00866693993186863},
                                   {17.7501, 28.2501, -0.007865675425628677},
                                   {17.7501, 28.5001, -0.00712882625348758},
                                   {17.7501, 28.7501, -0.006452412337370397},
                                   {17.7501, 29.0001, -0.005832547744174245},
                                   {17.7501, 29.2501, -0.005265460663089982},
                                   {17.7501, 29.5001, -0.00474750954881406},
                                   {17.7501, 29.7501, -0.004275195779511903},
                                   {18.0001, 0.0001, -8.0669027203833e-15},
                                   {18.0001, 0.2501, -2.847278339129039e-15},
                                   {18.0001, 0.5001, -2.385020203440569e-15},
                                   {18.0001, 0.7501, -2.115972512621494e-15},
                                   {18.0001, 1.0001, -2.100062512930986e-15},
                                   {18.0001, 1.2501, -8.95483729361962e-15},
                                   {18.0001, 1.5001, -1.424648048374033e-13},
                                   {18.0001, 1.7501, -1.676219912542223e-12},
                                   {18.0001, 2.0001, -1.381582996141469e-11},
                                   {18.0001, 2.2501, -8.61855332406729e-11},
                                   {18.0001, 2.5001, -4.313915390153213e-10},
                                   {18.0001, 2.7501, -1.80697113840167e-9},
                                   {18.0001, 3.0001, -6.53388074563532e-9},
                                   {18.0001, 3.2501, -2.088246817694763e-8},
                                   {18.0001, 3.5001, -6.008267099619241e-8},
                                   {18.0001, 3.7501, -1.579018035477299e-7},
                                   {18.0001, 4.0001, -3.835165539786689e-7},
                                   {18.0001, 4.2501, -8.69163918565028e-7},
                                   {18.0001, 4.5001, -1.852619766688727e-6},
                                   {18.0001, 4.7501, -3.738732394849029e-6},
                                   {18.0001, 5.0001, -7.183853589749375e-6},
                                   {18.0001, 5.2501, -0.00001320593408611372},
                                   {18.0001, 5.5001, -0.00002332124016279637},
                                   {18.0001, 5.7501, -0.00003970616379896104},
                                   {18.0001, 6.0001, -0.00006537960862357986},
                                   {18.0001, 6.2501, -0.0001043982005922661},
                                   {18.0001, 6.5001, -0.0001620534243414454},
                                   {18.0001, 6.7501, -0.0002450570783522659},
                                   {18.0001, 7.0001, -0.0003616995121356815},
                                   {18.0001, 7.2501, -0.0005219642357835617},
                                   {18.0001, 7.5001, -0.0007375828632266622},
                                   {18.0001, 7.7501, -0.001022016037770227},
                                   {18.0001, 8.0001, -0.001390348941544996},
                                   {18.0001, 8.2501, -0.001859094041756776},
                                   {18.0001, 8.5001, -0.002445898608820201},
                                   {18.0001, 8.7501, -0.00316915991480668},
                                   {18.0001, 9.0001, -0.004047556505291555},
                                   {18.0001, 9.2501, -0.005099509148138503},
                                   {18.0001, 9.5001, -0.006342589640330929},
                                   {18.0001, 9.7501, -0.007792899294559366},
                                   {18.0001, 10.0001, -0.00946444140230278},
                                   {18.0001, 10.2501, -0.01136851313940237},
                                   {18.0001, 10.5001, -0.01351314219648742},
                                   {18.0001, 10.7501, -0.01590259192297663},
                                   {18.0001, 11.0001, -0.0185369560931055},
                                   {18.0001, 11.2501, -0.02141186072477145},
                                   {18.0001, 11.5001, -0.02451828594426723},
                                   {18.0001, 11.7501, -0.02784251595830096},
                                   {18.0001, 12.0001, -0.03136622004479985},
                                   {18.0001, 12.2501, -0.0350666623735439},
                                   {18.0001, 12.5001, -0.03891703366117488},
                                   {18.0001, 12.7501, -0.04288689336200569},
                                   {18.0001, 13.0001, -0.04694270746237374},
                                   {18.0001, 13.2501, -0.05104846410004694},
                                   {18.0001, 13.5001, -0.05516634724011072},
                                   {18.0001, 13.7501, -0.05925744752599773},
                                   {18.0001, 14.0001, -0.06328248916670064},
                                   {18.0001, 14.2501, -0.06720255225930792},
                                   {18.0001, 14.5001, -0.07097977119042954},
                                   {18.0001, 14.7501, -0.07457799159938699},
                                   {18.0001, 15.0001, -0.0779633706947047},
                                   {18.0001, 15.2501, -0.0811049083614712},
                                   {18.0001, 15.5001, -0.0839748993489561},
                                   {18.0001, 15.7501, -0.0865492997601871},
                                   {18.0001, 16.0001, -0.0888080039637654},
                                   {18.0001, 16.2501, -0.0907350308133633},
                                   {18.0001, 16.5001, -0.0923186206093594},
                                   {18.0001, 16.7501, -0.0935512465053501},
                                   {18.0001, 17.0001, -0.0944295460036092},
                                   {18.0001, 17.2501, -0.0949541797695087},
                                   {18.0001, 17.5001, -0.0951296262134657},
                                   {18.0001, 17.7501, -0.0949639211427807},
                                   {18.0001, 18.0001, -0.0944683522899222},
                                   {18.0001, 18.2501, -0.0936571187036621},
                                   {18.0001, 18.5001, -0.0925469648780061},
                                   {18.0001, 18.7501, -0.0911567991295324},
                                   {18.0001, 19.0001, -0.0895073051582195},
                                   {18.0001, 19.2501, -0.0876205549830531},
                                   {18.0001, 19.5001, -0.0855196305741312},
                                   {18.0001, 19.7501, -0.0832282605482992},
                                   {18.0001, 20.0001, -0.0807704772931852},
                                   {18.0001, 20.2501, -0.07817029886875916},
                                   {18.0001, 20.5001, -0.0754514390357027},
                                   {18.0001, 20.7501, -0.07263704780079956},
                                   {18.0001, 21.0001, -0.0697494839713305},
                                   {18.0001, 21.2501, -0.06681012038849453},
                                   {18.0001, 21.5001, -0.0638391817751751},
                                   {18.0001, 21.7501, -0.0608556144928246},
                                   {18.0001, 22.0001, -0.0578769869591051},
                                   {18.0001, 22.2501, -0.05491941903226326},
                                   {18.0001, 22.5001, -0.05199753831742722},
                                   {18.0001, 22.7501, -0.0491244610893096},
                                   {18.0001, 23.0001, -0.04631179534871916},
                                   {18.0001, 23.2501, -0.04356966342912923},
                                   {18.0001, 23.5001, -0.04090674153582469},
                                   {18.0001, 23.7501, -0.03833031362491501},
                                   {18.0001, 24.0001, -0.03584633710370674},
                                   {18.0001, 24.2501, -0.03345951794868197},
                                   {18.0001, 24.5001, -0.03117339298410594},
                                   {18.0001, 24.7501, -0.02899041723510941},
                                   {18.0001, 25.0001, -0.02691205445664751},
                                   {18.0001, 25.2501, -0.0249388691374631},
                                   {18.0001, 25.5001, -0.02307061848031447},
                                   {18.0001, 25.7501, -0.02130634306131265},
                                   {18.0001, 26.0001, -0.01964445506810153},
                                   {18.0001, 26.2501, -0.01808282320543231},
                                   {18.0001, 26.5001, -0.01661885353478326},
                                   {18.0001, 26.7501, -0.01524956568007913},
                                   {18.0001, 27.0001, -0.01397166398290133},
                                   {18.0001, 27.2501, -0.0127816033270119},
                                   {18.0001, 27.5001, -0.01167564947316796},
                                   {18.0001, 27.7501, -0.01064993385110041},
                                   {18.0001, 28.0001, -0.00970050284651464},
                                   {18.0001, 28.2501, -0.00882336169764812},
                                   {18.0001, 28.5001, -0.00801451317909842},
                                   {18.0001, 28.7501, -0.007269991301269581},
                                   {18.0001, 29.0001, -0.006585890292932},
                                   {18.0001, 29.2501, -0.005958389163165796},
                                   {18.0001, 29.5001, -0.005383772158499448},
                                   {18.0001, 29.7501, -0.004858445442497301},
                                   {18.2501, 0.0001, -8.11612150466804e-15},
                                   {18.2501, 0.2501, -2.870637812957262e-15},
                                   {18.2501, 0.5001, -2.406088730789011e-15},
                                   {18.2501, 0.7501, -2.134936033934307e-15},
                                   {18.2501, 1.0001, -2.027179793565918e-15},
                                   {18.2501, 1.2501, -5.461582827111203e-15},
                                   {18.2501, 1.5001, -7.699600525938672e-14},
                                   {18.2501, 1.7501, -9.32735090204849e-13},
                                   {18.2501, 2.0001, -7.944376015903021e-12},
                                   {18.2501, 2.2501, -5.104128760137739e-11},
                                   {18.2501, 2.5001, -2.623230759508068e-10},
                                   {18.2501, 2.7501, -1.12538886668647e-9},
                                   {18.2501, 3.0001, -4.159162335768563e-9},
                                   {18.2501, 3.2501, -1.356253493783458e-8},
                                   {18.2501, 3.5001, -3.975449426050601e-8},
                                   {18.2501, 3.7501, -1.063028384869835e-7},
                                   {18.2501, 4.0001, -2.624082013506678e-7},
                                   {18.2501, 4.2501, -6.038152799289856e-7},
                                   {18.2501, 4.5001, -1.305630166476881e-6},
                                   {18.2501, 4.7501, -2.670871106880004e-6},
                                   {18.2501, 5.0001, -5.198504636085886e-6},
                                   {18.2501, 5.2501, -9.67408154394719e-6},
                                   {18.2501, 5.5001, -0.00001728480695475685},
                                   {18.2501, 5.7501, -0.00002975895696691016},
                                   {18.2501, 6.0001, -0.00004952708509423443},
                                   {18.2501, 6.2501, -0.00007989962999341916},
                                   {18.2501, 6.5001, -0.0001252525999564112},
                                   {18.2501, 6.7501, -0.0001912102726167951},
                                   {18.2501, 7.0001, -0.0002848116227743456},
                                   {18.2501, 7.2501, -0.0004146457615748456},
                                   {18.2501, 7.5001, -0.0005909412587995489},
                                   {18.2501, 7.7501, -0.000825594960718278},
                                   {18.2501, 8.0001, -0.001132127838960632},
                                   {18.2501, 8.2501, -0.001525558433742762},
                                   {18.2501, 8.5001, -0.002022188410507432},
                                   {18.2501, 8.7501, -0.002639299373701209},
                                   {18.2501, 9.0001, -0.003394765059276668},
                                   {18.2501, 9.2501, -0.004306588014995291},
                                   {18.2501, 9.5001, -0.005392374533140334},
                                   {18.2501, 9.7501, -0.006668765611918671},
                                   {18.2501, 10.0001, -0.00815084483054042},
                                   {18.2501, 10.2501, -0.00985154603941707},
                                   {18.2501, 10.5001, -0.01178108458158955},
                                   {18.2501, 10.7501, -0.0139464353475128},
                                   {18.2501, 11.0001, -0.01635087937478661},
                                   {18.2501, 11.2501, -0.01899363805923322},
                                   {18.2501, 11.5001, -0.02186961052225923},
                                   {18.2501, 11.7501, -0.02496922550060722},
                                   {18.2501, 12.0001, -0.02827841453075495},
                                   {18.2501, 12.2501, -0.03177870844033872},
                                   {18.2501, 12.5001, -0.03544745447324213},
                                   {18.2501, 12.7501, -0.03925814698165206},
                                   {18.2501, 13.0001, -0.04318086070347299},
                                   {18.2501, 13.2501, -0.04718277235371461},
                                   {18.2501, 13.5001, -0.05122875369725072},
                                   {18.2501, 13.7501, -0.05528201749688987},
                                   {18.2501, 14.0001, -0.05930479676163745},
                                   {18.2501, 14.2501, -0.06325903753327253},
                                   {18.2501, 14.5001, -0.06710708598952593},
                                   {18.2501, 14.7501, -0.07081235182706668},
                                   {18.2501, 15.0001, -0.07433993161529154},
                                   {18.2501, 15.2501, -0.07765717796807675},
                                   {18.2501, 15.5001, -0.080734202844892},
                                   {18.2501, 15.7501, -0.0835443059450359},
                                   {18.2501, 16.0001, -0.0860643218849052},
                                   {18.2501, 16.2501, -0.0882748825437208},
                                   {18.2501, 16.5001, -0.0901605935367016},
                                   {18.2501, 16.7501, -0.0917101261502374},
                                   {18.2501, 17.0001, -0.0929162281915278},
                                   {18.2501, 17.2501, -0.0937756590224385},
                                   {18.2501, 17.5001, -0.094289055537157},
                                   {18.2501, 17.7501, -0.0944607369937815},
                                   {18.2501, 18.0001, -0.0942984574228681},
                                   {18.2501, 18.2501, -0.0938131148243108},
                                   {18.2501, 18.5001, -0.0930184265502414},
                                   {18.2501, 18.7501, -0.0919305801857095},
                                   {18.2501, 19.0001, -0.090567868915621},
                                   {18.2501, 19.2501, -0.0889503198438471},
                                   {18.2501, 19.5001, -0.087099323047959},
                                   {18.2501, 19.7501, -0.0850372683498666},
                                   {18.2501, 20.0001, -0.0827871958963898},
                                   {18.2501, 20.2501, -0.0803724657095015},
                                   {18.2501, 20.5001, -0.0778164504153346},
                                   {18.2501, 20.7501, -0.07514225442179524},
                                   {18.2501, 21.0001, -0.07237246191028174},
                                   {18.2501, 21.2501, -0.06952891515678045},
                                   {18.2501, 21.5001, -0.06663252391635915},
                                   {18.2501, 21.7501, -0.06370310590361511},
                                   {18.2501, 22.0001, -0.060759257786945},
                                   {18.2501, 22.2501, -0.05781825559015337},
                                   {18.2501, 22.5001, -0.05489598296148213},
                                   {18.2501, 22.7501, -0.0520068854256465},
                                   {18.2501, 23.0001, -0.04916394847484862},
                                   {18.2501, 23.2501, -0.04637869717430909},
                                   {18.2501, 23.5001, -0.04366121484970172},
                                   {18.2501, 23.7501, -0.04102017838026432},
                                   {18.2501, 24.0001, -0.03846290763408144},
                                   {18.2501, 24.2501, -0.03599542664271813},
                                   {18.2501, 24.5001, -0.03362253421273723},
                                   {18.2501, 24.7501, -0.03134788180366487},
                                   {18.2501, 25.0001, -0.02917405665815471},
                                   {18.2501, 25.2501, -0.02710266834349802},
                                   {18.2501, 25.5001, -0.02513443704797077},
                                   {18.2501, 25.7501, -0.02326928216525562},
                                   {18.2501, 26.0001, -0.02150640989053278},
                                   {18.2501, 26.2501, -0.01984439873874823},
                                   {18.2501, 26.5001, -0.01828128207571205},
                                   {18.2501, 26.7501, -0.01681462692341068},
                                   {18.2501, 27.0001, -0.01544160846022479},
                                   {18.2501, 27.2501, -0.01415907978319598},
                                   {18.2501, 27.5001, -0.01296363663216245},
                                   {18.2501, 27.7501, -0.01185167689401406},
                                   {18.2501, 28.0001, -0.01081945480941518},
                                   {18.2501, 28.2501, -0.00986312989434069},
                                   {18.2501, 28.5001, -0.00897881066515994},
                                   {18.2501, 28.7501, -0.00816259331948166},
                                   {18.2501, 29.0001, -0.007410595576389199},
                                   {18.2501, 29.2501, -0.006718985920006628},
                                   {18.2501, 29.5001, -0.006084008520566789},
                                   {18.2501, 29.7501, -0.005502004128358849},
                                   {18.5001, 0.0001, -8.16474661542827e-15},
                                   {18.5001, 0.2501, -2.893765102093232e-15},
                                   {18.5001, 0.5001, -2.426957561092471e-15},
                                   {18.5001, 0.7501, -2.154138768125039e-15},
                                   {18.5001, 1.0001, -2.001357668645412e-15},
                                   {18.5001, 1.2501, -3.678733436187308e-15},
                                   {18.5001, 1.5001, -4.184531661488522e-14},
                                   {18.5001, 1.7501, -5.175836753969939e-13},
                                   {18.5001, 2.0001, -4.552934417793062e-12},
                                   {18.5001, 2.2501, -3.01254529179936e-11},
                                   {18.5001, 2.5001, -1.589726581225448e-10},
                                   {18.5001, 2.7501, -6.98512169689934e-10},
                                   {18.5001, 3.0001, -2.638516605208954e-9},
                                   {18.5001, 3.2501, -8.77846625583e-9},
                                   {18.5001, 3.5001, -2.6214492743236e-8},
                                   {18.5001, 3.7501, -7.132148578682711e-8},
                                   {18.5001, 4.0001, -1.78931993167229e-7},
                                   {18.5001, 4.2501, -4.180453469720443e-7},
                                   {18.5001, 4.5001, -9.17002555134777e-7},
                                   {18.5001, 4.7501, -1.901505512138572e-6},
                                   {18.5001, 5.0001, -3.748997481062871e-6},
                                   {18.5001, 5.2501, -7.062618847136532e-6},
                                   {18.5001, 5.5001, -0.00001276710717556229},
                                   {18.5001, 5.7501, -0.00002222758322751478},
                                   {18.5001, 6.0001, -0.00003739019093127803},
                                   {18.5001, 6.2501, -0.00006094115705739447},
                                   {18.5001, 6.5001, -0.0000964781973648668},
                                   {18.5001, 6.7501, -0.000148685567531681},
                                   {18.5001, 7.0001, -0.0002235017146355234},
                                   {18.5001, 7.2501, -0.0003282667000497914},
                                   {18.5001, 7.5001, -0.0004718355737311497},
                                   {18.5001, 7.7501, -0.0006646438564528395},
                                   {18.5001, 8.0001, -0.000918712321096065},
                                   {18.5001, 8.2501, -0.001247580353752768},
                                   {18.5001, 8.5001, -0.001666160223584071},
                                   {18.5001, 8.7501, -0.002190508416355986},
                                   {18.5001, 9.0001, -0.002837514542705755},
                                   {18.5001, 9.2501, -0.00362451292690915},
                                   {18.5001, 9.5001, -0.00456882650547456},
                                   {18.5001, 9.7501, -0.005687256815220781},
                                   {18.5001, 10.0001, -0.006995537356754293},
                                   {18.5001, 10.2501, -0.00850777026110534},
                                   {18.5001, 10.5001, -0.01023586780863706},
                                   {18.5001, 10.7501, -0.01218902086603302},
                                   {18.5001, 11.0001, -0.01437321570842434},
                                   {18.5001, 11.2501, -0.01679081903809191},
                                   {18.5001, 11.5001, -0.01944024841784026},
                                   {18.5001, 11.7501, -0.02231574197370873},
                                   {18.5001, 12.0001, -0.02540723728995282},
                                   {18.5001, 12.2501, -0.02870036514001729},
                                   {18.5001, 12.5001, -0.03217655929559108},
                                   {18.5001, 12.7501, -0.03581327934758561},
                                   {18.5001, 13.0001, -0.03958433945312587},
                                   {18.5001, 13.2501, -0.04346033235691102},
                                   {18.5001, 13.5001, -0.0474091350534052},
                                   {18.5001, 13.7501, -0.05139648014903662},
                                   {18.5001, 14.0001, -0.05538657540194444},
                                   {18.5001, 14.2501, -0.05934275307367997},
                                   {18.5001, 14.5001, -0.06322813060081558},
                                   {18.5001, 14.7501, -0.06700626463300824},
                                   {18.5001, 15.0001, -0.07064178161209524},
                                   {18.5001, 15.2501, -0.0741009696909841},
                                   {18.5001, 15.5001, -0.07735231880684652},
                                   {18.5001, 15.7501, -0.080366998020621},
                                   {18.5001, 16.0001, -0.0831192617045413},
                                   {18.5001, 16.2501, -0.0855867786968531},
                                   {18.5001, 16.5001, -0.0877508810524633},
                                   {18.5001, 16.7501, -0.0895967314162207},
                                   {18.5001, 17.0001, -0.0911134102618406},
                                   {18.5001, 17.2501, -0.0922939262190436},
                                   {18.5001, 17.5001, -0.0931351544142415},
                                   {18.5001, 17.7501, -0.0936377091507987},
                                   {18.5001, 18.0001, -0.0938057583419226},
                                   {18.5001, 18.2501, -0.0936467878833496},
                                   {18.5001, 18.5001, -0.0931713246255349},
                                   {18.5001, 18.7501, -0.0923926267961095},
                                   {18.5001, 19.0001, -0.0913263506597916},
                                   {18.5001, 19.2501, -0.0899902019164688},
                                   {18.5001, 19.5001, -0.0884035798635748},
                                   {18.5001, 19.7501, -0.0865872217223671},
                                   {18.5001, 20.0001, -0.0845628537853968},
                                   {18.5001, 20.2501, -0.0823528552192381},
                                   {18.5001, 20.5001, -0.07997993948502174},
                                   {18.5001, 20.7501, -0.07746685744913691},
                                   {18.5001, 21.0001, -0.07483612537372264},
                                   {18.5001, 21.2501, -0.07210978012354285},
                                   {18.5001, 21.5001, -0.06930916312082342},
                                   {18.5001, 21.7501, -0.06645473383698643},
                                   {18.5001, 22.0001, -0.06356591294050985},
                                   {18.5001, 22.2501, -0.06066095463040333},
                                   {18.5001, 22.5001, -0.05775684717884767},
                                   {18.5001, 22.7501, -0.05486924028539844},
                                   {18.5001, 23.0001, -0.05201239750738972},
                                   {18.5001, 23.2501, -0.04919917177337684},
                                   {18.5001, 23.5001, -0.04644100180363014},
                                   {18.5001, 23.7501, -0.04374792714763669},
                                   {18.5001, 24.0001, -0.04112861949626003},
                                   {18.5001, 24.2501, -0.03859042792811562},
                                   {18.5001, 24.5001, -0.03613943579809348},
                                   {18.5001, 24.7501, -0.03378052706308047},
                                   {18.5001, 25.0001, -0.0315174599583118},
                                   {18.5001, 25.2501, -0.0293529460803191},
                                   {18.5001, 25.5001, -0.02728873309255879},
                                   {18.5001, 25.7501, -0.02532568944152183},
                                   {18.5001, 26.0001, -0.02346388964912209},
                                   {18.5001, 26.2501, -0.0217026989268013},
                                   {18.5001, 26.5001, -0.02004085603412614},
                                   {18.5001, 26.7501, -0.01847655347641591},
                                   {18.5001, 27.0001, -0.01700751429949548},
                                   {18.5001, 27.2501, -0.01563106489298881},
                                   {18.5001, 27.5001, -0.01434420335517065},
                                   {18.5001, 27.7501, -0.0131436631012888},
                                   {18.5001, 28.0001, -0.01202597151289949},
                                   {18.5001, 28.2501, -0.01098750352794191},
                                   {18.5001, 28.5001, -0.01002453016014292},
                                   {18.5001, 28.7501, -0.00913326201228037},
                                   {18.5001, 29.0001, -0.00830988791143517},
                                   {18.5001, 29.2501, -0.007550608846378757},
                                   {18.5001, 29.5001, -0.006851667428537853},
                                   {18.5001, 29.7501, -0.00620937312948911},
                                   {18.7501, 0.0001, -8.21279309055263e-15},
                                   {18.7501, 0.2501, -2.916665279579033e-15},
                                   {18.7501, 0.5001, -2.447630604574843e-15},
                                   {18.7501, 0.7501, -2.173353915995307e-15},
                                   {18.7501, 1.0001, -1.998339093584718e-15},
                                   {18.7501, 1.2501, -2.776171723848694e-15},
                                   {18.7501, 1.5001, -2.304185175928435e-14},
                                   {18.7501, 1.7501, -2.865799064855818e-13},
                                   {18.7501, 2.0001, -2.600834894956727e-12},
                                   {18.7501, 2.2501, -1.772118751840504e-11},
                                   {18.7501, 2.5001, -9.6017373012542e-11},
                                   {18.7501, 2.7501, -4.321010947251862e-10},
                                   {18.7501, 3.0001, -1.668219152323414e-9},
                                   {18.7501, 3.2501, -5.662851482755448e-9},
                                   {18.7501, 3.5001, -1.722800304315022e-8},
                                   {18.7501, 3.7501, -4.769070003561338e-8},
                                   {18.7501, 4.0001, -1.216006669215652e-7},
                                   {18.7501, 4.2501, -2.88456043581192e-7},
                                   {18.7501, 4.5001, -6.418853779071798e-7},
                                   {18.7501, 4.7501, -1.349206568887932e-6},
                                   {18.7501, 5.0001, -2.694559087381403e-6},
                                   {18.7501, 5.2501, -5.138747876158264e-6},
                                   {18.7501, 5.5001, -9.39843780222379e-6},
                                   {18.7501, 5.7501, -0.00001654632977886976},
                                   {18.7501, 6.0001, -0.00002813242663932429},
                                   {18.7501, 6.2501, -0.00004632452117840153},
                                   {18.7501, 6.5001, -0.00007406374286111788},
                                   {18.7501, 6.7501, -0.0001152285752843685},
                                   {18.7501, 7.0001, -0.0001747984354435836},
                                   {18.7501, 7.2501, -0.0002590059348290175},
                                   {18.7501, 7.5001, -0.0003754655548619825},
                                   {18.7501, 7.7501, -0.0005332658589213509},
                                   {18.7501, 8.0001, -0.0007430126621103572},
                                   {18.7501, 8.2501, -0.00101681184304201},
                                   {18.7501, 8.5001, -0.001368182680997026},
                                   {18.7501, 8.7501, -0.001811895627444975},
                                   {18.7501, 9.0001, -0.002363732092856623},
                                   {18.7501, 9.2501, -0.00304016791345948},
                                   {18.7501, 9.5001, -0.003857986390213028},
                                   {18.7501, 9.7501, -0.00483383088533172},
                                   {18.7501, 10.0001, -0.005983710653495658},
                                   {18.7501, 10.2501, -0.007322476640599844},
                                   {18.7501, 10.5001, -0.0088632862155091},
                                   {18.7501, 10.7501, -0.01061707708180275},
                                   {18.7501, 11.0001, -0.01259207088364658},
                                   {18.7501, 11.2501, -0.01479332627465714},
                                   {18.7501, 11.5001, -0.01722235952376511},
                                   {18.7501, 11.7501, -0.01987684820316802},
                                   {18.7501, 12.0001, -0.02275043029762372},
                                   {18.7501, 12.2501, -0.02583260737751191},
                                   {18.7501, 12.5001, -0.02910875649159412},
                                   {18.7501, 12.7501, -0.03256025136287671},
                                   {18.7501, 13.0001, -0.03616468950658507},
                                   {18.7501, 13.2501, -0.0398962182076792},
                                   {18.7501, 13.5001, -0.04372594904409056},
                                   {18.7501, 13.7501, -0.04762244793598768},
                                   {18.7501, 14.0001, -0.05155228562067081},
                                   {18.7501, 14.2501, -0.05548063204114946},
                                   {18.7501, 14.5001, -0.05937187740378845},
                                   {18.7501, 14.7501, -0.06319026258519717},
                                   {18.7501, 15.0001, -0.06690050210263376},
                                   {18.7501, 15.2501, -0.07046838393594184},
                                   {18.7501, 15.5001, -0.0738613320169046},
                                   {18.7501, 15.7501, -0.07704891908820642},
                                   {18.7501, 16.0001, -0.0800033197785333},
                                   {18.7501, 16.2501, -0.0826996960425698},
                                   {18.7501, 16.5001, -0.0851165094791253},
                                   {18.7501, 16.7501, -0.0872357573797226},
                                   {18.7501, 17.0001, -0.0890431315967529},
                                   {18.7501, 17.2501, -0.0905281013902299},
                                   {18.7501, 17.5001, -0.0916839232642493},
                                   {18.7501, 17.7501, -0.0925075824011943},
                                   {18.7501, 18.0001, -0.0929996716196693},
                                   {18.7501, 18.2501, -0.0931642148097847},
                                   {18.7501, 18.5001, -0.0930084425367748},
                                   {18.7501, 18.7501, -0.0925425279608088},
                                   {18.7501, 19.0001, -0.0917792914151615},
                                   {18.7501, 19.2501, -0.0907338819409024},
                                   {18.7501, 19.5001, -0.0894234438228012},
                                   {18.7501, 19.7501, -0.0878667757400564},
                                   {18.7501, 20.0001, -0.0860839895699868},
                                   {18.7501, 20.2501, -0.0840961751963558},
                                   {18.7501, 20.5001, -0.0819250769088521},
                                   {18.7501, 20.7501, -0.07959278616681952},
                                   {18.7501, 21.0001, -0.07712145466633529},
                                   {18.7501, 21.2501, -0.07453303081973361},
                                   {18.7501, 21.5001, -0.07184902195174841},
                                   {18.7501, 21.7501, -0.06909028375404651},
                                   {18.7501, 22.0001, -0.06627683783387354},
                                   {18.7501, 22.2501, -0.06342771755315177},
                                   {18.7501, 22.5001, -0.06056084178868593},
                                   {18.7501, 22.7501, -0.05769291575617564},
                                   {18.7501, 23.0001, -0.0548393576318727},
                                   {18.7501, 23.2501, -0.05201424937503251},
                                   {18.7501, 23.5001, -0.04923030989895631},
                                   {18.7501, 23.7501, -0.0464988885540336},
                                   {18.7501, 24.0001, -0.04382997676722716},
                                   {18.7501, 24.2501, -0.0412322356225196},
                                   {18.7501, 24.5001, -0.03871303715905134},
                                   {18.7501, 24.7501, -0.03627851720086378},
                                   {18.7501, 25.0001, -0.03393363760712895},
                                   {18.7501, 25.2501, -0.03168225593748452},
                                   {18.7501, 25.5001, -0.0295272006569121},
                                   {18.7501, 25.7501, -0.02747035015226199},
                                   {18.7501, 26.0001, -0.02551271399233865},
                                   {18.7501, 26.2501, -0.02365451503031554},
                                   {18.7501, 26.5001, -0.02189527111667137},
                                   {18.7501, 26.7501, -0.02023387535899206},
                                   {18.7501, 27.0001, -0.01866867402865509},
                                   {18.7501, 27.2501, -0.01719754137099593},
                                   {18.7501, 27.5001, -0.01581795072300894},
                                   {18.7501, 27.7501, -0.01452704147943743},
                                   {18.7501, 28.0001, -0.01332168157321056},
                                   {18.7501, 28.2501, -0.01219852524895643},
                                   {18.7501, 28.5001, -0.01115406600849156},
                                   {18.7501, 28.7501, -0.0101846846947947},
                                   {18.7501, 29.0001, -0.00928669275631047},
                                   {18.7501, 29.2501, -0.0084563707969942},
                                   {18.7501, 29.5001, -0.007690002569959584},
                                   {18.7501, 29.7501, -0.006983904614702957},
                                   {19.0001, 0.0001, -8.26027539153394e-15},
                                   {19.0001, 0.2501, -2.93934324840273e-15},
                                   {19.0001, 0.5001, -2.468111803052613e-15},
                                   {19.0001, 0.7501, -2.192480539727218e-15},
                                   {19.0001, 1.0001, -2.006289649547215e-15},
                                   {19.0001, 1.2501, -2.325026789261307e-15},
                                   {19.0001, 1.5001, -1.302125131774854e-14},
                                   {19.0001, 1.7501, -1.584866920554289e-13},
                                   {19.0001, 2.0001, -1.481089041676453e-12},
                                   {19.0001, 2.2501, -1.039018554313078e-11},
                                   {19.0001, 2.5001, -5.780145621079101e-11},
                                   {19.0001, 2.7501, -2.66413583946807e-10},
                                   {19.0001, 3.0001, -1.051247995984624e-9},
                                   {19.0001, 3.2501, -3.640909985475191e-9},
                                   {19.0001, 3.5001, -1.128460013268396e-8},
                                   {19.0001, 3.7501, -3.178369000232485e-8},
                                   {19.0001, 4.0001, -8.23646384330637e-8},
                                   {19.0001, 4.2501, -1.9837748322925e-7},
                                   {19.0001, 4.5001, -4.478169506445786e-7},
                                   {19.0001, 4.7501, -9.54146489779022e-7},
                                   {19.0001, 5.0001, -1.930259442654144e-6},
                                   {19.0001, 5.2501, -3.726524135055806e-6},
                                   {19.0001, 5.5001, -6.895624681100302e-6},
                                   {19.0001, 5.7501, -0.00001227624608254362},
                                   {19.0001, 6.0001, -0.00002109652383614863},
                                   {19.0001, 6.2501, -0.00003509660448733015},
                                   {19.0001, 6.5001, -0.0000566677260990148},
                                   {19.0001, 6.7501, -0.0000890030665559243},
                                   {19.0001, 7.0001, -0.0001362534094414722},
                                   {19.0001, 7.2501, -0.0002036786557773449},
                                   {19.0001, 7.5001, -0.0002977845834012321},
                                   {19.0001, 7.7501, -0.0004264332225286721},
                                   {19.0001, 8.0001, -0.0005989149324649406},
                                   {19.0001, 8.2501, -0.000825970827399728},
                                   {19.0001, 8.5001, -0.001119755635215308},
                                   {19.0001, 8.7501, -0.001493733334860237},
                                   {19.0001, 9.0001, -0.001962500887758076},
                                   {19.0001, 9.2501, -0.002541538880260368},
                                   {19.0001, 9.5001, -0.003246891706974412},
                                   {19.0001, 9.7501, -0.004094783803793852},
                                   {19.0001, 10.0001, -0.00510118213486498},
                                   {19.0001, 10.2501, -0.006281318414471349},
                                   {19.0001, 10.5001, -0.007649187199545596},
                                   {19.0001, 10.7501, -0.00921703786290465},
                                   {19.0001, 11.0001, -0.01099487944704434},
                                   {19.0001, 11.2501, -0.01299001745736805},
                                   {19.0001, 11.5001, -0.0152066407939436},
                                   {19.0001, 11.7501, -0.01764547530770692},
                                   {19.0001, 12.0001, -0.02030351801172755},
                                   {19.0001, 12.2501, -0.02317386292774187},
                                   {19.0001, 12.5001, -0.02624562607393565},
                                   {19.0001, 12.7501, -0.02950397338555075},
                                   {19.0001, 13.0001, -0.03293025158976075},
                                   {19.0001, 13.2501, -0.03650221840531445},
                                   {19.0001, 13.5001, -0.04019436506232096},
                                   {19.0001, 13.7501, -0.04397832116989452},
                                   {19.0001, 14.0001, -0.04782332950131508},
                                   {19.0001, 14.2501, -0.05169677638810152},
                                   {19.0001, 14.5001, -0.05556476215388152},
                                   {19.0001, 14.7501, -0.05939269538326169},
                                   {19.0001, 15.0001, -0.06314589478915309},
                                   {19.0001, 15.2501, -0.06679018296927133},
                                   {19.0001, 15.5001, -0.0702924573645525},
                                   {19.0001, 15.7501, -0.07362122517049109},
                                   {19.0001, 16.0001, -0.0767470907192452},
                                   {19.0001, 16.2501, -0.0796431858538462},
                                   {19.0001, 16.5001, -0.082285535964281},
                                   {19.0001, 16.7501, -0.0846533565609296},
                                   {19.0001, 17.0001, -0.0867292774434134},
                                   {19.0001, 17.2501, -0.0884994936115441},
                                   {19.0001, 17.5001, -0.0899538440002537},
                                   {19.0001, 17.7501, -0.0910858208548684},
                                   {19.0001, 18.0001, -0.0918925140621024},
                                   {19.0001, 18.2501, -0.0923744959932017},
                                   {19.0001, 18.5001, -0.0925356533877548},
                                   {19.0001, 18.7501, -0.0923829735092193},
                                   {19.0001, 19.0001, -0.0919262922446397},
                                   {19.0001, 19.2501, -0.0911780120173329},
                                   {19.0001, 19.5001, -0.0901527973544084},
                                   {19.0001, 19.7501, -0.0888672557271595},
                                   {19.0001, 20.0001, -0.087339610890733},
                                   {19.0001, 20.2501, -0.0855893754206576},
                                   {19.0001, 20.5001, -0.0836370285086108},
                                   {19.0001, 20.7501, -0.0815037043682297},
                                   {19.0001, 21.0001, -0.07921089584212913},
                                   {19.0001, 21.2501, -0.07678017701954413},
                                   {19.0001, 21.5001, -0.07423294789325602},
                                   {19.0001, 21.7501, -0.07159020332464904},
                                   {19.0001, 22.0001, -0.06887232786350693},
                                   {19.0001, 22.2501, -0.06609891729779229},
                                   {19.0001, 22.5001, -0.06328862719821173},
                                   {19.0001, 22.7501, -0.06045904817984658},
                                   {19.0001, 23.0001, -0.05762660713271034},
                                   {19.0001, 23.2501, -0.05480649327645867},
                                   {19.0001, 23.5001, -0.05201260757113129},
                                   {19.0001, 23.7501, -0.04925753376342932},
                                   {19.0001, 24.0001, -0.04655252916281938},
                                   {19.0001, 24.2501, -0.04390753311875919},
                                   {19.0001, 24.5001, -0.0413311911037751},
                                   {19.0001, 24.7501, -0.03883089229065889},
                                   {19.0001, 25.0001, -0.03641281853907181},
                                   {19.0001, 25.2501, -0.03408200277065931},
                                   {19.0001, 25.5001, -0.0318423948058236},
                                   {19.0001, 25.7501, -0.02969693285327308},
                                   {19.0001, 26.0001, -0.02764761897946432},
                                   {19.0001, 26.2501, -0.02569559703364232},
                                   {19.0001, 26.5001, -0.02384123166048163},
                                   {19.0001, 26.7501, -0.02208418719201784},
                                   {19.0001, 27.0001, -0.02042350536991014},
                                   {19.0001, 27.2501, -0.01885768100494804},
                                   {19.0001, 27.5001, -0.01738473483052984},
                                   {19.0001, 27.7501, -0.01600228294855456},
                                   {19.0001, 28.0001, -0.01470760239823293},
                                   {19.0001, 28.2501, -0.01349769249963925},
                                   {19.0001, 28.5001, -0.01236933173369578},
                                   {19.0001, 28.7501, -0.01131913001836013},
                                   {19.0001, 29.0001, -0.01034357632702601},
                                   {19.0001, 29.2501, -0.00943908166975556},
                                   {19.0001, 29.5001, -0.00860201752134592},
                                   {19.0001, 29.7501, -0.007828749832965796},
                                   {19.2501, 0.0001, -8.30720743287018e-15},
                                   {19.2501, 0.2501, -2.961803749107445e-15},
                                   {19.2501, 0.5001, -2.488405037876527e-15},
                                   {19.2501, 0.7501, -2.211474879424365e-15},
                                   {19.2501, 1.0001, -2.019457093485265e-15},
                                   {19.2501, 1.2501, -2.104529484724394e-15},
                                   {19.2501, 1.5001, -7.70283720634743e-15},
                                   {19.2501, 1.7501, -8.77019753309335e-14},
                                   {19.2501, 2.0001, -8.40975724053623e-13},
                                   {19.2501, 2.2501, -6.072281739064151e-12},
                                   {19.2501, 2.5001, -3.468242300254754e-11},
                                   {19.2501, 2.7501, -1.637216557046111e-10},
                                   {19.2501, 3.0001, -6.602905267782555e-10},
                                   {19.2501, 3.2501, -2.333253545989789e-9},
                                   {19.2501, 3.5001, -7.36739826000316e-9},
                                   {19.2501, 3.7501, -2.111306248997535e-8},
                                   {19.2501, 4.0001, -5.5605983094831e-8},
                                   {19.2501, 4.2501, -1.359817452482532e-7},
                                   {19.2501, 4.5001, -3.114000722906605e-7},
                                   {19.2501, 4.7501, -6.725529069427343e-7},
                                   {19.2501, 5.0001, -1.378218630059143e-6},
                                   {19.2501, 5.2501, -2.693547922097316e-6},
                                   {19.2501, 5.5001, -5.042726305683761e-6},
                                   {19.2501, 5.7501, -9.078268928586e-6},
                                   {19.2501, 6.0001, -0.00001576840904104262},
                                   {19.2501, 6.2501, -0.00002650283105303467},
                                   {19.2501, 6.5001, -0.00004321541258784051},
                                   {19.2501, 6.7501, -0.00006852077208833261},
                                   {19.2501, 7.0001, -0.000105859411720144},
                                   {19.2501, 7.2501, -0.0001596442770430995},
                                   {19.2501, 7.5001, -0.0002353998197410882},
                                   {19.2501, 7.7501, -0.0003398833385197065},
                                   {19.2501, 8.0001, -0.0004811776526310529},
                                   {19.2501, 8.2501, -0.0006687441562899608},
                                   {19.2501, 8.5001, -0.000913426078170641},
                                   {19.2501, 8.7501, -0.001227393331918952},
                                   {19.2501, 9.0001, -0.001624022629740845},
                                   {19.2501, 9.2501, -0.002117709420179016},
                                   {19.2501, 9.5001, -0.002723611532273184},
                                   {19.2501, 9.7501, -0.003457327955708757},
                                   {19.2501, 10.0001, -0.004334519736807021},
                                   {19.2501, 10.2501, -0.005370483299725455},
                                   {19.2501, 10.5001, -0.006579689404102101},
                                   {19.2501, 10.7501, -0.007975303248751603},
                                   {19.2501, 11.0001, -0.00956870279223357},
                                   {19.2501, 11.2501, -0.01136901310084377},
                                   {19.2501, 11.5001, -0.01338267442089971},
                                   {19.2501, 11.7501, -0.01561306072467647},
                                   {19.2501, 12.0001, -0.0180601637646776},
                                   {19.2501, 12.2501, -0.02072035529570445},
                                   {19.2501, 12.5001, -0.02358623722576302},
                                   {19.2501, 12.7501, -0.02664658619300788},
                                   {19.2501, 13.0001, -0.02988639560427577},
                                   {19.2501, 13.2501, -0.03328701467856223},
                                   {19.2501, 13.5001, -0.03682638067381227},
                                   {19.2501, 13.7501, -0.04047933737827155},
                                   {19.2501, 14.0001, -0.04421803023605405},
                                   {19.2501, 14.2501, -0.0480123662412964},
                                   {19.2501, 14.5001, -0.05183052503815356},
                                   {19.2501, 14.7501, -0.05563950653765576},
                                   {19.2501, 15.0001, -0.05940569981199602},
                                   {19.2501, 15.2501, -0.06309545803184493},
                                   {19.2501, 15.5001, -0.06667566473087061},
                                   {19.2501, 15.7501, -0.07011427765444428},
                                   {19.2501, 16.0001, -0.07338083780436069},
                                   {19.2501, 16.2501, -0.07644693294786029},
                                   {19.2501, 16.5001, -0.0792866067330348},
                                   {19.2501, 16.7501, -0.08187670655972},
                                   {19.2501, 17.0001, -0.0841971654147836},
                                   {19.2501, 17.2501, -0.0862312149193793},
                                   {19.2501, 17.5001, -0.0879655287880609},
                                   {19.2501, 17.7501, -0.0893902977106664},
                                   {19.2501, 18.0001, -0.0904992382937664},
                                   {19.2501, 18.2501, -0.0912895401067939},
                                   {19.2501, 18.5001, -0.0917617560475155},
                                   {19.2501, 18.7501, -0.091919642161588},
                                   {19.2501, 19.0001, -0.0917699537204836},
                                   {19.2501, 19.2501, -0.0913222047883084},
                                   {19.2501, 19.5001, -0.0905883987052667},
                                   {19.2501, 19.7501, -0.0895827369035386},
                                   {19.2501, 20.0001, -0.0883213132741071},
                                   {19.2501, 20.2501, -0.0868218009472733},
                                   {19.2501, 20.5001, -0.0851031378634093},
                                   {19.2501, 20.7501, -0.0831852169224127},
                                   {19.2501, 21.0001, -0.0810885858381863},
                                   {19.2501, 21.2501, -0.07883416111468256},
                                   {19.2501, 21.5001, -0.0764429598269024},
                                   {19.2501, 21.7501, -0.0739358521554866},
                                   {19.2501, 22.0001, -0.07133333690604449},
                                   {19.2501, 22.2501, -0.06865534155998666},
                                   {19.2501, 22.5001, -0.06592104776513366},
                                   {19.2501, 22.7501, -0.06314874259154269},
                                   {19.2501, 23.0001, -0.06035569535775162},
                                   {19.2501, 23.2501, -0.05755805937928884},
                                   {19.2501, 23.5001, -0.05477079760677825},
                                   {19.2501, 23.7501, -0.05200763080516428},
                                   {19.2501, 24.0001, -0.04928100667663024},
                                   {19.2501, 24.2501, -0.04660208814439315},
                                   {19.2501, 24.5001, -0.04398075888831936},
                                   {19.2501, 24.7501, -0.04142564415098227},
                                   {19.2501, 25.0001, -0.03894414480857887},
                                   {19.2501, 25.2501, -0.03654248271892445},
                                   {19.2501, 25.5001, -0.03422575541233452},
                                   {19.2501, 25.7501, -0.03199799827443305},
                                   {19.2501, 26.0001, -0.02986225247686884},
                                   {19.2501, 26.2501, -0.0278206370369876},
                                   {19.2501, 26.5001, -0.02587442352552778},
                                   {19.2501, 26.7501, -0.02402411208770516},
                                   {19.2501, 27.0001, -0.02226950759346873},
                                   {19.2501, 27.2501, -0.02060979488363393},
                                   {19.2501, 27.5001, -0.01904361222695995},
                                   {19.2501, 27.7501, -0.01756912224649285},
                                   {19.2501, 28.0001, -0.01618407970960678},
                                   {19.2501, 28.2501, -0.01488589570357438},
                                   {19.2501, 28.5001, -0.0136716978360437},
                                   {19.2501, 28.7501, -0.01253838620673949},
                                   {19.2501, 29.0001, -0.01148268499262765},
                                   {19.2501, 29.2501, -0.01050118957355962},
                                   {19.2501, 29.5001, -0.00959040919917563},
                                   {19.2501, 29.7501, -0.00874680526091903},
                                   {19.5001, 0.0001, -8.35360260960272e-15},
                                   {19.5001, 0.2501, -2.984051366979255e-15},
                                   {19.5001, 0.5001, -2.508514095144382e-15},
                                   {19.5001, 0.7501, -2.230319027715946e-15},
                                   {19.5001, 1.0001, -2.035056128163374e-15},
                                   {19.5001, 1.2501, -2.001440519587878e-15},
                                   {19.5001, 1.5001, -4.8931560305248e-15},
                                   {19.5001, 1.7501, -4.872006569336448e-14},
                                   {19.5001, 2.0001, -4.762781032970959e-13},
                                   {19.5001, 2.2501, -3.537619101093977e-12},
                                   {19.5001, 2.5001, -2.074350990794401e-11},
                                   {19.5001, 2.7501, -1.002890379398828e-10},
                                   {19.5001, 3.0001, -4.133912662388849e-10},
                                   {19.5001, 3.2501, -1.490423338270082e-9},
                                   {19.5001, 3.5001, -4.794434059583971e-9},
                                   {19.5001, 3.7501, -1.397954216913577e-8},
                                   {19.5001, 4.0001, -3.741938525895745e-8},
                                   {19.5001, 4.2501, -9.29100870414139e-8},
                                   {19.5001, 4.5001, -2.158393154566771e-7},
                                   {19.5001, 4.7501, -4.725319497783098e-7},
                                   {19.5001, 5.0001, -9.80874741823735e-7},
                                   {19.5001, 5.2501, -1.940609584929915e-6},
                                   {19.5001, 5.5001, -3.675780608888758e-6},
                                   {19.5001, 5.7501, -6.691640844985524e-6},
                                   {19.5001, 6.0001, -0.00001174780433617368},
                                   {19.5001, 6.2501, -0.00001994853584518962},
                                   {19.5001, 6.5001, -0.00003284981150640065},
                                   {19.5001, 6.7501, -0.00005258121596252502},
                                   {19.5001, 7.0001, -0.0000819789668979019},
                                   {19.5001, 7.2501, -0.0001247245170920315},
                                   {19.5001, 7.5001, -0.0001854814433134668},
                                   {19.5001, 7.7501, -0.000270021865429907},
                                   {19.5001, 8.0001, -0.0003853326133160292},
                                   {19.5001, 8.2501, -0.0005396909115825453},
                                   {19.5001, 8.5001, -0.0007426995788525668},
                                   {19.5001, 8.7501, -0.001005272682747707},
                                   {19.5001, 9.0001, -0.001339564239704736},
                                   {19.5001, 9.2501, -0.001758834828860265},
                                   {19.5001, 9.5001, -0.002277253778864682},
                                   {19.5001, 9.7501, -0.002909637722003708},
                                   {19.5001, 10.0001, -0.003671129600375084},
                                   {19.5001, 10.2501, -0.004576825450905215},
                                   {19.5001, 10.5001, -0.005641359289923744},
                                   {19.5001, 10.7501, -0.006878458981936792},
                                   {19.5001, 11.0001, -0.00830048795934704},
                                   {19.5001, 11.2501, -0.0099179889476608},
                                   {19.5001, 11.5001, -0.01173924637671512},
                                   {19.5001, 11.7501, -0.01376988390228596},
                                   {19.5001, 12.0001, -0.01601251244952906},
                                   {19.5001, 12.2501, -0.01846644248696981},
                                   {19.5001, 12.5001, -0.021127471948905},
                                   {19.5001, 12.7501, -0.02398775847326429},
                                   {19.5001, 13.0001, -0.02703578155655457},
                                   {19.5001, 13.2501, -0.03025639700055989},
                                   {19.5001, 13.5001, -0.03363098278880725},
                                   {19.5001, 13.7501, -0.03713767242691622},
                                   {19.5001, 14.0001, -0.04075166893628771},
                                   {19.5001, 14.2501, -0.04444563021048248},
                                   {19.5001, 14.5001, -0.04819011440889259},
                                   {19.5001, 14.7501, -0.05195407252748482},
                                   {19.5001, 15.0001, -0.0557053742796919},
                                   {19.5001, 15.2501, -0.0594113529450283},
                                   {19.5001, 15.5001, -0.0630393548790602},
                                   {19.5001, 15.7501, -0.06655727988681363},
                                   {19.5001, 16.0001, -0.06993409958771926},
                                   {19.5001, 16.2501, -0.0731403421773259},
                                   {19.5001, 16.5001, -0.07614853354537874},
                                   {19.5001, 16.7501, -0.07893358646407478},
                                   {19.5001, 17.0001, -0.0814731314371464},
                                   {19.5001, 17.2501, -0.083747784725954},
                                   {19.5001, 17.5001, -0.0857413509749587},
                                   {19.5001, 17.7501, -0.0874409596856763},
                                   {19.5001, 18.0001, -0.0888371364846571},
                                   {19.5001, 18.2501, -0.0899238116565177},
                                   {19.5001, 18.5001, -0.0906982697372854},
                                   {19.5001, 18.7501, -0.0911610450662923},
                                   {19.5001, 19.0001, -0.0913157690662359},
                                   {19.5001, 19.2501, -0.0911689756592915},
                                   {19.5001, 19.5001, -0.0907298716385531},
                                   {19.5001, 19.7501, -0.0900100790113141},
                                   {19.5001, 20.0001, -0.0890233563317249},
                                   {19.5001, 20.2501, -0.0877853058670183},
                                   {19.5001, 20.5001, -0.0863130731182585},
                                   {19.5001, 20.7501, -0.0846250447693821},
                                   {19.5001, 21.0001, -0.082740550593545},
                                   {19.5001, 21.2501, -0.08067957422931},
                                   {19.5001, 21.5001, -0.07846247707564576},
                                   {19.5001, 21.7501, -0.07610973886680887},
                                   {19.5001, 22.0001, -0.07364171779641273},
                                   {19.5001, 22.2501, -0.07107843238221591},
                                   {19.5001, 22.5001, -0.06843936661447295},
                                   {19.5001, 22.7501, -0.06574329932335161},
                                   {19.5001, 23.0001, -0.06300815814441819},
                                   {19.5001, 23.2501, -0.06025089796236688},
                                   {19.5001, 23.5001, -0.05748740327639999},
                                   {19.5001, 23.7501, -0.05473241355811377},
                                   {19.5001, 24.0001, -0.05199947036462115},
                                   {19.5001, 24.2501, -0.04930088472449256},
                                   {19.5001, 24.5001, -0.04664772312909108},
                                   {19.5001, 24.7501, -0.04404981033310126},
                                   {19.5001, 25.0001, -0.04151574709076558},
                                   {19.5001, 25.2501, -0.03905294092324711},
                                   {19.5001, 25.5001, -0.0366676480219909},
                                   {19.5001, 25.7501, -0.0343650244371759},
                                   {19.5001, 26.0001, -0.0321491847735881},
                                   {19.5001, 26.2501, -0.03002326671292292},
                                   {19.5001, 26.5001, -0.02798949979635648},
                                   {19.5001, 26.7501, -0.02604927702929404},
                                   {19.5001, 27.0001, -0.02420322800703541},
                                   {19.5001, 27.2501, -0.02245129240169319},
                                   {19.5001, 27.5001, -0.0207927927935613},
                                   {19.5001, 27.7501, -0.01922650597126501},
                                   {19.5001, 28.0001, -0.01775073196192775},
                                   {19.5001, 28.2501, -0.01636336018324061},
                                   {19.5001, 28.5001, -0.01506193223213353},
                                   {19.5001, 28.7501, -0.01384370093855374},
                                   {19.5001, 29.0001, -0.01270568541685209},
                                   {19.5001, 29.2501, -0.01164472194098948},
                                   {19.5001, 29.5001, -0.01065751055301144},
                                   {19.5001, 29.7501, -0.00974065738705324},
                                   {19.7501, 0.0001, -8.39947382313214e-15},
                                   {19.7501, 0.2501, -3.006090538841089e-15},
                                   {19.7501, 0.5001, -2.528442654357837e-15},
                                   {19.7501, 0.7501, -2.249006696410869e-15},
                                   {19.7501, 1.0001, -2.051743525507101e-15},
                                   {19.7501, 1.2501, -1.957880586411952e-15},
                                   {19.7501, 1.5001, -3.417354907344635e-15},
                                   {19.7501, 1.7501, -2.732631615572274e-14},
                                   {19.7501, 2.0001, -2.691854266128023e-13},
                                   {19.7501, 2.2501, -2.054676045099982e-12},
                                   {19.7501, 2.5001, -1.236740764927036e-11},
                                   {19.7501, 2.7501, -6.123743035183924e-11},
                                   {19.7501, 3.0001, -2.579894726835049e-10},
                                   {19.7501, 3.2501, -9.4901067062248e-10},
                                   {19.7501, 3.5001, -3.110096059013117e-9},
                                   {19.7501, 3.7501, -9.2267231172414e-9},
                                   {19.7501, 4.0001, -2.510060598892822e-8},
                                   {19.7501, 4.2501, -6.327864762103969e-8},
                                   {19.7501, 4.5001, -1.491262577644817e-7},
                                   {19.7501, 4.7501, -3.309384980750019e-7},
                                   {19.7501, 5.0001, -6.95857098610875e-7},
                                   {19.7501, 5.2501, -1.393677900668874e-6},
                                   {19.7501, 5.5001, -2.670817769069039e-6},
                                   {19.7501, 5.7501, -4.916685375386762e-6},
                                   {19.7501, 6.0001, -8.72439828676905e-6},
                                   {19.7501, 6.2501, -0.00001496716276533515},
                                   {19.7501, 6.5001, -0.00002489066818061132},
                                   {19.7501, 6.7501, -0.00004022057014272733},
                                   {19.7501, 7.0001, -0.00006328261244863126},
                                   {19.7501, 7.2501, -0.0000971312734259134},
                                   {19.7501, 7.5001, -0.0001456811531568759},
                                   {19.7501, 7.7501, -0.0002138337977352162},
                                   {19.7501, 8.0001, -0.0003075914406698924},
                                   {19.7501, 8.2501, -0.0004341483714509053},
                                   {19.7501, 8.5001, -0.0006019504300601419},
                                   {19.7501, 8.7501, -0.000820713546078304},
                                   {19.7501, 9.0001, -0.001101393315644641},
                                   {19.7501, 9.2501, -0.001456099310802318},
                                   {19.7501, 9.5001, -0.001897950065720702},
                                   {19.7501, 9.7501, -0.002440867361290284},
                                   {19.7501, 10.0001, -0.003099311378271711},
                                   {19.7501, 10.2501, -0.003887961332890966},
                                   {19.7501, 10.5001, -0.004821349163238913},
                                   {19.7501, 10.7501, -0.005913456521823611},
                                   {19.7501, 11.0001, -0.007177287589419176},
                                   {19.7501, 11.2501, -0.00862443192712198},
                                   {19.7501, 11.5001, -0.01026463263293378},
                                   {19.7501, 11.7501, -0.01210537541292978},
                                   {19.7501, 12.0001, -0.01415151380418914},
                                   {19.7501, 12.2501, -0.01640494472696224},
                                   {19.7501, 12.5001, -0.01886434686337422},
                                   {19.7501, 12.7501, -0.02152499215602293},
                                   {19.7501, 13.0001, -0.0243786381115912},
                                   {19.7501, 13.2501, -0.02741350571596913},
                                   {19.7501, 13.5001, -0.03061434475829129},
                                   {19.7501, 13.7501, -0.03396258535967107},
                                   {19.7501, 14.0001, -0.03743657163709617},
                                   {19.7501, 14.2501, -0.04101187081779304},
                                   {19.7501, 14.5001, -0.04466164884878107},
                                   {19.7501, 14.7501, -0.04835710169233685},
                                   {19.7501, 15.0001, -0.05206793010885466},
                                   {19.7501, 15.2501, -0.05576284482841319},
                                   {19.7501, 15.5001, -0.05941008860281634},
                                   {19.7501, 15.7501, -0.06297796169200427},
                                   {19.7501, 16.0001, -0.06643533783595457},
                                   {19.7501, 16.2501, -0.06975215864476171},
                                   {19.7501, 16.5001, -0.07289989554426885},
                                   {19.7501, 16.7501, -0.07585196987445487},
                                   {19.7501, 17.0001, -0.07858412338161962},
                                   {19.7501, 17.2501, -0.081074733102251},
                                   {19.7501, 17.5001, -0.0833050664382666},
                                   {19.7501, 17.7501, -0.0852594740074169},
                                   {19.7501, 18.0001, -0.0869255195635111},
                                   {19.7501, 18.2501, -0.0882940478717379},
                                   {19.7501, 18.5001, -0.0893591928568978},
                                   {19.7501, 18.7501, -0.090118329588562},
                                   {19.7501, 19.0001, -0.0905719747081273},
                                   {19.7501, 19.2501, -0.0907236407284651},
                                   {19.7501, 19.5001, -0.0905796502455123},
                                   {19.7501, 19.7501, -0.0901489164980354},
                                   {19.7501, 20.0001, -0.089442696908284},
                                   {19.7501, 20.2501, -0.088474326248586},
                                   {19.7501, 20.5001, -0.0872589359270516},
                                   {19.7501, 20.7501, -0.0858131655919153},
                                   {19.7501, 21.0001, -0.0841548728425818},
                                   {19.7501, 21.2501, -0.0823028463305481},
                                   {19.7501, 21.5001, -0.0802765269591076},
                                   {19.7501, 21.7501, -0.07809574127006123},
                                   {19.7501, 22.0001, -0.07578045045990171},
                                   {19.7501, 22.2501, -0.07335051781636809},
                                   {19.7501, 22.5001, -0.07082549672577777},
                                   {19.7501, 22.7501, -0.06822444078651158},
                                   {19.7501, 23.0001, -0.06556573698621138},
                                   {19.7501, 23.2501, -0.06286696236884945},
                                   {19.7501, 23.5001, -0.06014476413957151},
                                   {19.7501, 23.7501, -0.0574147627345332},
                                   {19.7501, 24.0001, -0.05469147702218265},
                                   {19.7501, 24.2501, -0.05198827050208696},
                                   {19.7501, 24.5001, -0.04931731712636403},
                                   {19.7501, 24.7501, -0.04668958518465417},
                                   {19.7501, 25.0001, -0.04411483756287557},
                                   {19.7501, 25.2501, -0.04160164660448118},
                                   {19.7501, 25.5001, -0.03915742176572359},
                                   {19.7501, 25.7501, -0.0367884482583366},
                                   {19.7501, 26.0001, -0.03449993490868624},
                                   {19.7501, 26.2501, -0.03229606952645243},
                                   {19.7501, 26.5001, -0.03018008016303381},
                                   {19.7501, 26.7501, -0.02815430074512001},
                                   {19.7501, 27.0001, -0.02622023968757897},
                                   {19.7501, 27.2501, -0.0243786502176826},
                                   {19.7501, 27.5001, -0.02262960127590127},
                                   {19.7501, 27.7501, -0.02097254799365174},
                                   {19.7501, 28.0001, -0.01940640088256957},
                                   {19.7501, 28.2501, -0.01792959300064196},
                                   {19.7501, 28.5001, -0.01654014448587154},
                                   {19.7501, 28.7501, -0.01523572396645978},
                                   {19.7501, 29.0001, -0.01401370646660287},
                                   {19.7501, 29.2501, -0.01287122752803931},
                                   {19.7501, 29.5001, -0.01180523335895066},
                                   {19.7501, 29.7501, -0.01081252690344368}};

  for (int i = 0; i < n_tests; ++i) {
    double a = test[i][0];
    double z = test[i][1];

    double result = stan::math::grad_reg_lower_inc_gamma(a, z, 1.0e-10);
    if (i == 0) {
      EXPECT_NEAR(test[i][2], result, 1.5e-5);
    } else {
      EXPECT_NEAR(test[i][2], result, 1.0e-10);
    }
  }
}  // NOLINT(readability/fn_size)
