 /* compile with: gcc -lsscript -o example example.c */

#include <stdio.h>
#include <errno.h>

main()
{
/* initializing variables */
 char host[255]="127.0.0.1";
 char result[255]=".";
 char question[255];
 int sockfd=0,i;

/* get the local hostname */
 strcpy(result,(char *)sscript_get_localhost());
 printf("LOCAHOST: %s",result);

/* and resolve it */
 strcpy(question,(char *)sscript_resolve_host(result));
 printf("[%s]\n",question);

/* get the login for uid 0 */
 printf("Super User login name on this system is: %s\n",sscript_uid_to_login(0));

/* connect somewhere */
 printf("Connecting to %s... Let's see if there's something listening...\n",host);

/* call to sscript_connect to connect to the server */
 sockfd=sscript_connect(host,21,NULL);

/* if it returns -1, then print the error code */
 if(sockfd<1)
 {
  printf("An error occured: %d\n",errno);
  exit(1);
 }

/* call to sscript_read and copy the result in 'result' */
 strcpy(result,(char *)sscript_time_read(sockfd,5));

/* print the result */
 printf("I read: [%s]\n",result);

/* disconnects */
 sscript_disconnect(sockfd);
}

