#!/bin/bash -e
path="."
if [ x"$1" != x ]; then
	path="$1"
fi

versiongit() {
	gitbranch=`git rev-parse --abbrev-ref HEAD`
	gitversion=`git rev-parse HEAD`
	cat <<EOF > $path/comptime.h

// Do not edit!  This file was autogenerated
// by the $0 script with git
//
const char* compbranch = "$gitbranch";
const char* comprevision = "${gitversion:0:8}";
EOF
exit 0
}

versionsvn() {
	svnrevision=`svnversion -n $1`
	cat <<EOF > $path/comptime.h

// Do not edit!  This file was autogenerated
// by the $0 script with subversion
//
const char* compbranch = "Subversion";
const char* comprevision = "r$svnrevision";
EOF
exit 0
}

versionfake() {
	cat <<EOF > $path/comptime.h

// Do not edit!  This file was autogenerated
// by the $0 script with an unknown or nonexist SCM
//
const char* compbranch = "Unknown";
const char* comprevision = "illegal";
EOF
}

compversion() {
touch $path/comptime.c
versionfake
test -d $path/.svn && versionsvn
test -d $path/../.git && versiongit
exit 1
}

test -f $path/comptime.c && compversion
exit 2
