/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import com.jidesoft.spinner.PointFormatter;
import com.jidesoft.spinner.SpinnerPointModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.DefaultFormatterFactory;

public class PointSpinner
extends JSpinner {
    public PointSpinner(SpinnerPointModel model) {
        this.setModel(model);
        this.setEditor(this.createEditor(model));
        this.setOpaque(true);
        this.updateUI();
    }

    public PointSpinner() {
        this(new SpinnerPointModel());
    }

    private JComponent createEditor(SpinnerPointModel model) {
        return new PointEditor(this);
    }

    private void updateField() {
        JComponent editor = this.getEditor();
        if (editor instanceof PointEditor && this.getModel() instanceof SpinnerPointModel) {
            JFormattedTextField ftf = ((PointEditor)editor).getTextField();
            SpinnerPointModel model = (SpinnerPointModel)this.getModel();
            int comma = ftf.getText().indexOf(44);
            int caret = ftf.getCaretPosition();
            model.setField(caret <= comma ? 0 : 1);
        }
    }

    @Override
    public Object getNextValue() {
        this.updateField();
        return super.getNextValue();
    }

    @Override
    public Object getPreviousValue() {
        this.updateField();
        return super.getPreviousValue();
    }

    public static class PointEditor
    extends JSpinner.DefaultEditor {
        public PointEditor(JSpinner spinner) {
            super(spinner);
            if (!(spinner.getModel() instanceof SpinnerPointModel)) {
                throw new IllegalArgumentException("model not a SpinnerPointModel");
            }
            final SpinnerPointModel model = (SpinnerPointModel)spinner.getModel();
            JFormattedTextField.AbstractFormatter formatter = PointFormatter.getInstance();
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            final JFormattedTextField ftf = this.getTextField();
            ftf.setEditable(true);
            ftf.setFormatterFactory(factory);
            ftf.setHorizontalAlignment(4);
            String min = Integer.toString(Integer.MIN_VALUE);
            ftf.setColumns(4 + 2 * min.length());
            ftf.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int number;
                    String digit;
                    String text = ftf.getText();
                    int comma = text.indexOf(44);
                    if (model.getField() == 0) {
                        digit = text.substring(text.indexOf(40) + 1, comma).trim();
                        number = text.indexOf(digit);
                    } else {
                        digit = text.substring(comma + 1, text.indexOf(41)).trim();
                        number = text.lastIndexOf(digit);
                    }
                    ftf.select(number, number + digit.length());
                }
            });
        }
    }
}

