/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import net.sourceforge.napkinlaf.shapes.DrawnBoxHolder;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinScrollBarUI
extends BasicScrollBarUI
implements NapkinPainter {
    private DrawnLineHolder track;
    private final boolean vertical;
    private DrawnBoxHolder thumb;

    public NapkinScrollBarUI(JScrollBar bar) {
        this.vertical = bar.getOrientation() == 1;
    }

    public static ComponentUI createUI(JComponent c) {
        return new NapkinScrollBarUI((JScrollBar)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    protected JButton createDecreaseButton(int orientation) {
        return NapkinUtil.createArrowButton(orientation);
    }

    protected JButton createIncreaseButton(int orientation) {
        return NapkinUtil.createArrowButton(orientation);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(c.getForeground());
        this.track = NapkinUtil.paintLine(g, this.vertical, this.track, trackBounds);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (this.thumb == null) {
            this.thumb = new DrawnBoxHolder();
        }
        this.thumb.shapeUpToDate(thumbBounds);
        Graphics2D lineG = NapkinUtil.copy(g);
        lineG.setColor(c.getForeground());
        lineG.translate(thumbBounds.x, thumbBounds.y);
        this.thumb.draw(lineG);
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c) {
        super.update(g, c);
    }
}

