/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DnDTabbedPaneData;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DndTabUtils;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.GhostGlassPane;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.OutwardDndTabbedPaneChanel;

class DndTabbedPaneDropTargetListener
implements DropTargetListener {
    private DnDTabbedPaneData _dnDTabbedPaneData;
    private GhostGlassPane _glassPane;
    private OutwardDndTabbedPaneChanel _outwardDndTabbedPaneChanel;
    private Point _glassPt = new Point();

    public DndTabbedPaneDropTargetListener(DnDTabbedPaneData dnDTabbedPaneData, GhostGlassPane glassPane, OutwardDndTabbedPaneChanel outwardDndTabbedPaneChanel) {
        this._dnDTabbedPaneData = dnDTabbedPaneData;
        this._glassPane = glassPane;
        this._outwardDndTabbedPaneChanel = outwardDndTabbedPaneChanel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (this.isDragAcceptable(e)) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Point glassPt = e.getLocation();
        if (this._dnDTabbedPaneData.getTabbedPane().getTabPlacement() == 1 || this._dnDTabbedPaneData.getTabbedPane().getTabPlacement() == 3) {
            this.initTargetLeftRightLine(DndTabUtils.getTargetTabIndex(glassPt, this._glassPane, this._dnDTabbedPaneData.getTabbedPane()));
        } else {
            this.initTargetTopBottomLine(DndTabUtils.getTargetTabIndex(glassPt, this._glassPane, this._dnDTabbedPaneData.getTabbedPane()));
        }
        if (this._dnDTabbedPaneData.isHasGhost()) {
            this._glassPane.setPoint(glassPt);
        }
        if (!this._glassPt.equals(glassPt)) {
            this._glassPane.repaint();
        }
        this._glassPt = glassPt;
        this.autoScrollTest(glassPt);
    }

    private void autoScrollTest(Point glassPt) {
        Rectangle r = DndTabUtils.getTabAreaBounds(this._dnDTabbedPaneData.getTabbedPane());
        int tabPlacement = this._dnDTabbedPaneData.getTabbedPane().getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            this._dnDTabbedPaneData.getrBackward().setBounds(r.x, r.y, 20, r.height);
            this._dnDTabbedPaneData.getrForward().setBounds(r.x + r.width - 20 - 30, r.y, 50, r.height);
        } else if (tabPlacement == 2 || tabPlacement == 4) {
            this._dnDTabbedPaneData.getrBackward().setBounds(r.x, r.y, r.width, 20);
            this._dnDTabbedPaneData.getrForward().setBounds(r.x, r.y + r.height - 20 - 30, r.width, 50);
        }
        this._dnDTabbedPaneData.setrBackward(SwingUtilities.convertRectangle(this._dnDTabbedPaneData.getTabbedPane().getParent(), this._dnDTabbedPaneData.getrBackward(), this._glassPane));
        this._dnDTabbedPaneData.setrForward(SwingUtilities.convertRectangle(this._dnDTabbedPaneData.getTabbedPane().getParent(), this._dnDTabbedPaneData.getrForward(), this._glassPane));
        if (this._dnDTabbedPaneData.getrBackward().contains(glassPt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (this._dnDTabbedPaneData.getrForward().contains(glassPt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    private void clickArrowButton(String actionKey) {
        Action action;
        ActionMap map = this._dnDTabbedPaneData.getTabbedPane().getActionMap();
        if (map != null && (action = map.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this._dnDTabbedPaneData.getTabbedPane(), 1001, null, 0L, 0));
        }
    }

    private void initTargetLeftRightLine(int next) {
        if (next < 0 || this._dnDTabbedPaneData.getTabbedPane().getTabCount() < next || 0 == this._dnDTabbedPaneData.getTabbedPane().getTabCount()) {
            this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this._dnDTabbedPaneData.getTabbedPane(), this._dnDTabbedPaneData.getTabbedPane().getBoundsAt(0), this._glassPane);
            this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(r.x - 1, r.y, 3.0, r.height);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this._dnDTabbedPaneData.getTabbedPane(), this._dnDTabbedPaneData.getTabbedPane().getBoundsAt(next - 1), this._glassPane);
            this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(r.x + r.width - 1, r.y, 3.0, r.height);
        }
    }

    private void initTargetTopBottomLine(int next) {
        if (next < 0 || this._dnDTabbedPaneData.getTabbedPane().getTabCount() < next) {
            this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this._dnDTabbedPaneData.getTabbedPane(), this._dnDTabbedPaneData.getTabbedPane().getBoundsAt(0), this._glassPane);
            this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(r.x, r.y - 1, r.width, 3.0);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this._dnDTabbedPaneData.getTabbedPane(), this._dnDTabbedPaneData.getTabbedPane().getBoundsAt(next - 1), this._glassPane);
            this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(r.x, r.y + r.height - 1, r.width, 3.0);
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (this.isDropAcceptable(e)) {
            if (null != this._outwardDndTabbedPaneChanel && null != this._outwardDndTabbedPaneChanel.getDndTabbedPaneData() && this._outwardDndTabbedPaneChanel.getDndTabbedPaneData() != this._dnDTabbedPaneData) {
                int targetTabIndex = DndTabUtils.getTargetTabIndex(e.getLocation(), this._glassPane, this._dnDTabbedPaneData.getTabbedPane());
                if (-1 == targetTabIndex) {
                    targetTabIndex = this._dnDTabbedPaneData.getTabbedPane().getTabCount();
                }
                this._outwardDndTabbedPaneChanel.moveDraggedTabTo(this._dnDTabbedPaneData.getTabbedPane(), targetTabIndex);
            } else {
                this.convertTab(this._dnDTabbedPaneData.getDragTabIndex(), DndTabUtils.getTargetTabIndex(e.getLocation(), this._glassPane, this._dnDTabbedPaneData.getTabbedPane()));
            }
            e.dropComplete(true);
        } else {
            e.dropComplete(false);
        }
        this._dnDTabbedPaneData.getTabbedPane().repaint();
    }

    private void convertTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this._dnDTabbedPaneData.getTabbedPane().getComponentAt(prev);
        Component tab = this._dnDTabbedPaneData.getTabbedPane().getTabComponentAt(prev);
        String str = this._dnDTabbedPaneData.getTabbedPane().getTitleAt(prev);
        Icon icon = this._dnDTabbedPaneData.getTabbedPane().getIconAt(prev);
        String tip = this._dnDTabbedPaneData.getTabbedPane().getToolTipTextAt(prev);
        boolean flg = this._dnDTabbedPaneData.getTabbedPane().isEnabledAt(prev);
        int tgtindex = prev > next ? next : next - 1;
        this._dnDTabbedPaneData.getTabbedPane().remove(prev);
        this._dnDTabbedPaneData.getTabbedPane().insertTab(str, icon, cmp, tip, tgtindex);
        this._dnDTabbedPaneData.getTabbedPane().setEnabledAt(tgtindex, flg);
        if (flg) {
            this._dnDTabbedPaneData.getTabbedPane().setSelectedIndex(tgtindex);
        }
        this._dnDTabbedPaneData.getTabbedPane().setTabComponentAt(tgtindex, tab);
    }

    private boolean isDragAcceptable(DropTargetDragEvent e) {
        return this.dragAndDropAllowed(e.getTransferable());
    }

    private boolean isDropAcceptable(DropTargetDropEvent e) {
        return this.dragAndDropAllowed(e.getTransferable());
    }

    private boolean dragAndDropAllowed(Transferable transferable) {
        if (transferable == null) {
            return false;
        }
        DataFlavor[] f = transferable.getTransferDataFlavors();
        if (!transferable.isDataFlavorSupported(f[0])) {
            return false;
        }
        if (null != this._outwardDndTabbedPaneChanel && null != this._outwardDndTabbedPaneChanel.getDndTabbedPaneData()) {
            return true;
        }
        return this._dnDTabbedPaneData.getDragTabIndex() >= 0;
    }
}

