/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.IOutOfMemoryErrorHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class OutOfMemoryErrorHandler
implements IOutOfMemoryErrorHandler {
    private static final ILogger log = LoggerController.createLogger(OutOfMemoryErrorHandler.class);
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(OutOfMemoryErrorHandler.class);
    private IApplication application;

    public OutOfMemoryErrorHandler() {
    }

    public OutOfMemoryErrorHandler(IApplication application) {
        this.setApplication(application);
    }

    public IApplication getApplication() {
        return this.application;
    }

    public void setApplication(IApplication application) {
        if (application == null) {
            throw new IllegalArgumentException("application must not be null");
        }
        this.application = application;
    }

    @Override
    public synchronized void handleOutOfMemoryError() {
        SessionManager sessionManager = this.application.getSessionManager();
        ISession[] sessions = sessionManager.getConnectedSessions();
        if (sessions.length != 0) {
            for (ISession session : sessions) {
                this.closeResultTabs(session);
            }
            this.showMessage(sessionManager);
        } else {
            log.info("A OutOfMemoryError occurred, but there are no sessions connected - so we can't free memory.");
        }
    }

    private void showMessage(SessionManager sessionManager) {
        ISession activeSession = sessionManager.getActiveSession();
        if (activeSession != null) {
            log.info(i18n.message);
            activeSession.showErrorMessage(i18n.message);
            this.application.showErrorDialog(i18n.message);
        } else {
            log.info("A OutOfMemoryError occurred, but there are no active session!");
        }
    }

    private void closeResultTabs(ISession session) {
        session.getSessionInternalFrame().getSQLPanelAPI().closeAllSQLResultTabs();
    }

    static /* synthetic */ StringManager access$000() {
        return stringMgr;
    }

    static interface i18n {
        public static final String message = OutOfMemoryErrorHandler.access$000().getString("OutOfMemoryErrorHandler.message");
    }
}

