Example of illegal code:

```ada
X : Integer;

function F return Integer
  with Global => (Output => X);
```

This error is issued on functions which declare outputs in their Global or
Depends contract. This side-effect is not allowed in functions in SPARK for two
reasons: this could lead to different behaviors on code with problematic
aliasing depending on the choice made by the compiler in the order of
evaluation of sub-expressions; and functions can be called in assertions and
contracts, and as such should have a logical interpretation as mathematical
functions from inputs to result, which excludes the possibility of
side-effects.

The fix is to declare that the function has side-effects, which has the effect
of restricting its use so that the cases mentioned above cannot occur.
This is achieved by declaring `F` with the aspect `Side_Effects`:

```ada
X : Integer;

function F return Integer
  with Side_Effects,
       Global => (Output => X);
```

As a result, calls to `F` can only appear as the right-hand side of
assignments, which may require adapting `F`'s callers:

```ada
declare
   Y : Integer := F; -- error
begin
   Y := F; -- ok
   Y := F + 1; -- error
end;
```

Note that the same error is issued when `X` is declared with mode `In_Out` in
the Global contract, or when `X` is used as an output item in a Depends
contract. The fix in all these cases is to declare that the function has
side-effects.
