#ifndef SP_TIME_H
#define SP_TIME_H

/**
   The time management
 */

#include "../stk/stk.h"

class Sp_Adm_Time;
class Sp_Client_Time;


class Sp_Adm_Time:public Stk_Timer
{
  public:
        /// Constructor
    Sp_Adm_Time();
        /// time elapsed from the beginning of programme
    long GetElapsedTime();
        /// time elapsed from last frame
    long GetFrameElapsedTime();
        /// function which must be called once time per frame
    void FrameTick();
        /// function wich give the number of the current frame
    long GetFrameCounter();
    
  protected:
        /// time recorded at the construction of this object
    long start;
        /// time for last frame
    long last;
        /// time for current frame
    long current;
        /// number of frame
    long frame_counter;
};


class Sp_Client_Time
{
  public:
        //the members functions
        /// The constructor
    Sp_Client_Time(Sp_Adm_Time *);
        /** these functions must be called after that adm called FrameTick
            time elapsed from the beginning of programme */
    long GetElapsedTime();
        /// time elapsed from last frame
    long GetFrameElapsedTime();
        /// number of the current frame
    long GetFrameCounter();

  protected:
    Sp_Adm_Time *adm;
};



#endif
