
#include "sp_time.h"

/* the Adm Time class */


Sp_Adm_Time::Sp_Adm_Time()
{
    frame_counter=0;
    start=last=current=GetTime();
}

long Sp_Adm_Time::GetElapsedTime()
{
    return GetTime()-start;   
}


long Sp_Adm_Time::GetFrameElapsedTime()
{
    return current-last;
}

long Sp_Adm_Time::GetFrameCounter()
{
    return frame_counter;
}


void Sp_Adm_Time::FrameTick()
{
    frame_counter++;
    last=current;
    current=GetTime();
}



/* the client class */
Sp_Client_Time::Sp_Client_Time(Sp_Adm_Time *a)
{
    adm=a;
}

long Sp_Client_Time::GetElapsedTime()
{
    return adm->GetElapsedTime();
}

long Sp_Client_Time::GetFrameElapsedTime()
{
    return adm->GetFrameElapsedTime();
}

long Sp_Client_Time::GetFrameCounter()
{
    return adm->GetFrameCounter();
}
