// This file defines some macros to make easy errors searching
// It uses the flag define in config.h DEBUG
// We choice it with the option --enable-debug in the configure
// command
#include "../../config.h"

// Some define usefull
#ifdef DEBUG
// this define is used to place some code to verify presence of errors
#define ERROR_CODE
#endif



// The information msg
#ifndef DEBUG
#define SP_INFORMATION (msg)
#else
#define SP_INFORMATION(msg)        \
    printf("%s\n",msg); 
#endif


// The Warning function with msg
#ifndef DEBUG
#define SP_WARNING(cond,msg) 
#else
#define SP_WARNING(cond,msg) \
if(cond){                    \
    printf("%s\n",msg);      \
}                            
#endif




// The Error function with msg
#ifndef DEBUG
#define SP_ERROR(cond,msg)
#else
#define SP_ERROR(cond,msg) \
if(cond){                  \
    printf("%s\n",msg);    \
    exit(0);               \
}                          
#endif


