#include <stdlib.h> 
#include "stk_time.h"


#ifndef WIN32


struct timeval Delta(const struct timeval src1,const struct timeval src2)
{
    struct timeval dest;
    if(((dest).tv_usec = (src1).tv_usec - (src2).tv_usec) < 0) {
        (dest).tv_usec += 1000000;
        (dest).tv_sec = (src1).tv_sec - (src2).tv_sec - 1;
    } else {
        (dest).tv_sec = (src1).tv_sec - (src2).tv_sec;
    }
    return dest;   
}


Stk_Timer::Stk_Timer()
{
    gettimeofday(&start,0);
}


/* Return elapsed milliseconds. */
long Stk_Timer::GetTime() const
{
    struct timeval elapsed, now;
    gettimeofday(&now,0);
    elapsed=Delta(now,start);
    return  ((elapsed.tv_sec * 1000) + (elapsed.tv_usec / 1000));
}

#endif

#ifdef WIN32

stk_time Delta(const stk_time src1,const stk_time src2)
{
    stk_time dest;
    if(((dest).millitm = (src1).millitm - (src2).millitm) < 0) {
        (dest).millitm += 1000;
        (dest).time = (src1).time - (src2).time - 1;
    } else {
        (dest).time = (src1).time - (src2).time;
    }
    return dest;   
}


Stk_Timer::Stk_Timer()
{
	struct _timeb starttmp;
	_ftime(&starttmp);
	start.time=starttmp.time;
	start.millitm=starttmp.millitm;

	
}

long Stk_Timer::GetTime() const
{
	struct _timeb nowtmp;
	stk_time now,elapsed;
	_ftime(&nowtmp);
	now.time=nowtmp.time;
	now.millitm=nowtmp.millitm;
	elapsed=Delta(now,start);
	return ((elapsed.millitm) + (elapsed.time * 1000));
}

#endif
