#include "stk_debug.h"
#include "stk_thread.h"


/* --------------------- Mutex class ------------------ */
Stk_Mutex::Stk_Mutex()
{
    m=SDL_CreateMutex();
    STK_ERROR((!m),"Problem in creation of mutex");
}

Stk_Mutex::~Stk_Mutex()
{
    if(m){
        SDL_DestroyMutex(m);
        m=0;
    }
}

void Stk_Mutex::P()
{
    STK_ERROR( (SDL_mutexP(m)==-1) ,"Problem in operation P of mutex");
}

void Stk_Mutex::V()
{
    STK_ERROR( (SDL_mutexV(m)==-1) ,"Problem in operation V of mutex");
}




/* --------------------- Thread class ------------------ */
int thread_function(void *current)
{
    ((Stk_Thread *)current)->function();
    printf("thread cree\n");
    return 0;
}

Stk_Thread::Stk_Thread()
{}

void Stk_Thread::Start()
{
    thread=SDL_CreateThread(thread_function,this); 
}


int Stk_Thread::function()
{
    return 1;
}
