#ifdef WIN32
#include <windows.h>
#endif
#include <GL/gl.h>
#include <GL/glu.h>
#include "stk_fnt.h"
#include "../kernel/stk_debug.h"

/* ----------------------- Stk_font ----------------- */

Stk_Font::Stk_Font()
{
    size=10;
}


void Stk_Font::DrawChar(char c,float xi,float yi,float zi) const
{}


void Stk_Font::SetSize(float sz)
{
    size=sz;
}


float Stk_Font::GetSize() const
{
    return size;
}


/* ---------------------- stk_font txf -------------- */


Stk_FontTXF::Stk_FontTXF(char *filename)
        :Stk_Font(),Stk_File(filename)
{       // test if it is really a txf file
    unsigned char signature [ 4 ] ;
    fread ( &signature, 1, sizeof (unsigned int), fd ) ;
    if ( signature [ 0 ] != 0xFF || signature [ 1 ] != 't' ||
         signature [ 2 ] != 'x'  || signature [ 3 ] != 'f' ){
        fprintf ( stderr, "%s is not a true TXF file\n", filename ) ;
        return ;
    }
        // this int serves to know the sex of machine which has save this file...
    int format;
    int tex_width;
    int tex_height;
    int nb_glyph;
    endian=(LoadInt()!=0x12345678);
    format=SwapInt(LoadInt());
    tex_width=SwapInt(LoadInt());
    tex_height=SwapInt(LoadInt());
    int max_height=SwapInt(LoadInt());
    LoadInt();
        // nb glyth
    nb_glyph=SwapInt(LoadInt());

    Glyph_TXF  glyph;
    int w = tex_width  ;
    int h = tex_height ;
    
    float xstep = 0.5f / (float) w ;
    float ystep = 0.5f / (float) h ;
    
    int i,j;

    chars=new charTXF[FNTMAX_CHAR];
    
    for ( i = 0 ; i < nb_glyph ; i++ ){
        glyph . ch      = SwapShort(LoadShort());
        glyph .  w      = LoadChar() ;
        glyph .  h      = LoadChar() ;
        glyph . x_off   = LoadChar() ;
        glyph . y_off   = LoadChar() ;
        glyph . step    = LoadChar() ;
        glyph . unknown = LoadChar() ;
        glyph . x       = SwapShort(LoadShort());
        glyph . y       = SwapShort(LoadShort());
        
        setGlyph ( (char) glyph.ch,
                   (float)glyph.x / (float) w + xstep, (float)( glyph.x + glyph.w ) / (float) w + xstep,
                   (float)glyph.y / (float) h + ystep, (float)( glyph.y + glyph.h ) / (float) h + ystep,
                   (float)glyph.x_off/(float)max_height, (float)(glyph.x_off + glyph.w)/(float)max_height,
                   (float)glyph.y_off/(float)max_height, (float)(glyph.y_off + glyph.h)/(float)max_height ) ;
    }



    int ntexels = w * h ;
    
    unsigned char *teximage  ;
    unsigned char *texbitmap ;

    teximage = new unsigned char [ 4 * ntexels ] ;
    
    switch ( format ){
        case 0:
        {
            unsigned char *orig = new unsigned char [ ntexels ] ;
            fread(orig, 1, ntexels, fd);
            for ( i = 0 ; i < ntexels ; i++ ){
                teximage [ i*4     ] = orig [ i ] ;
                teximage [ i*4 + 1 ] = orig [ i ] ;
                teximage [ i*4 + 2 ] = orig [ i ] ;
                teximage [ i*4 + 3 ] = orig [ i ] ;
            }
            delete orig ;
        }
        break ;
        
        case 1:
        {
            int stride = (w + 7) >> 3;
            
            texbitmap = new unsigned char [ stride * h ] ;
            fread ( texbitmap, 1, stride * h, fd ) ;
            for ( i = 0 ; i < 4 * ntexels ; i++ )
                teximage [ i ] = 0 ;
            for (i = 0; i < h; i++)
                for (j = 0; j < w; j++)
                    if (texbitmap[i * stride + (j >> 3)] & (1 << (j & 7))){
                        teximage[(i * w + j) * 4    ] = 255;
                        teximage[(i * w + j) * 4 + 1] = 255;
                        teximage[(i * w + j) * 4 + 2] = 255;
                        teximage[(i * w + j) * 4 + 3] = 255;
                    }
            delete texbitmap ;
        }
        break ;
    }
    glEnable(GL_TEXTURE_2D);
    glGenTextures ( 1,(unsigned int *) &texture ) ;
    glBindTexture(GL_TEXTURE_2D, texture);
    gluBuild2DMipmaps(GL_TEXTURE_2D,4,w,h,GL_RGBA,GL_UNSIGNED_BYTE,teximage);
    delete teximage;
}


Stk_FontTXF::~Stk_FontTXF()
{}


void Stk_FontTXF::DrawChar(char c,float xi,float yi,float zi) const
{
    unsigned int cc = (unsigned char) c ;
    
        // Auto case-convert if character is absent from font.
    if ( ! chars[ cc ].exist ){
        if ( cc >= 'A' && cc <= 'Z' )
            cc = cc - 'A' + 'a' ;
        else
            if ( cc >= 'a' && cc <= 'z' )
                cc = cc - 'a' + 'A' ;
    }
        // we use the font texture

    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, texture);
        // we draw char
    glBegin ( GL_TRIANGLE_STRIP ) ;

    glTexCoord2f(chars[cc].t_left, chars[cc].t_top);
    glVertex3f(xi+chars[cc].v_left*size,
               yi+size-chars[cc].v_top* size,
               zi);

  
 
    glTexCoord2f(chars[cc].t_left, chars[cc].t_bot);
    glVertex3f(xi+chars[cc].v_left*size,
               yi+size-chars[cc].v_bot* size,
               zi);

    

    glTexCoord2f(chars[cc].t_right, chars[cc].t_top);
    glVertex3f(xi+chars[cc].v_right*size,
               yi+size-chars[cc].v_top* size,
               zi);

 
  
    glTexCoord2f(chars[cc].t_right,chars[cc].t_bot);
    glVertex3f(xi+chars[cc].v_right*size,
               yi+size-chars[cc].v_bot* size,
               zi);

    glEnd () ;
}








void  Stk_FontTXF::setGlyph ( char c,
                            float tex_left, float tex_right,
                            float tex_bot , float tex_top  ,
                            float vtx_left, float vtx_right,
                            float vtx_bot , float vtx_top  )
{
  unsigned int cc = (unsigned char) c ;
  
  chars[cc].exist = 1 ;
  chars[cc].t_left = tex_left ; chars[cc].t_right = tex_right ;
  chars[cc].t_bot  = tex_bot  ; chars[cc].t_top   = tex_top   ;
  chars[cc].v_left = vtx_left ; chars[cc].v_right = vtx_right ;
  chars[cc].v_bot  = vtx_bot  ; chars[cc].v_top   = vtx_top   ;
}



int Stk_FontTXF::SwapInt(int a)
{
    int b;
    if(endian){
        char *pa=(char *)&a;
        char *pb=(char *)&b;
        pb[0]=pa[3]; pb[1]=pa[2];
        pb[2]=pa[1]; pb[3]=pa[0];
    }
    return b;
}

short Stk_FontTXF::SwapShort(short a)
{
    short b;
    if(endian){
        char *pa=(char *)&a;
        char *pb=(char *)&b;
        pb[0]=pa[1]; pb[1]=pa[0];
    }
    return b;
}
