#ifndef __SP_MENU
#define __SP_MENU

#include "stk/stk.h"

// Global defines and variables
#define MENUPLANETS 6
#define PLANETSLICES 20
#define PLANETSTACKS 20
#define PLANETRADIUS 1.0
#define DZPLANETROTATION 5




/* A Planet */
class Sp_BPlanet:public Stk_Gui_Button 
{
public:
    Sp_BPlanet(char *tex_name);
        // draw the button
    void DrawButton();
        // active planet
    int active;
private:
        // angle rotation
    float angle;
        // number of texture
    int num_tex;
        // num de la quadric
    GLUquadricObj  *obj;
};

/* A choice */
class Sp_Choice:public Stk_Gui_VBox
{
public:
    Sp_Choice(Stk_Font *fnt);
    Sp_BPlanet *button;
    Stk_Gui_Text *text;
private:
    Stk_Font *font;
};




/* ------------------------------------------------------ */
/* ---------------- We have six planet items ------------ */
/* ------------------------------------------------------ */

/* ----------------- NewGame -------------------- */
class Sp_Menu_NewGame:public Sp_BPlanet
{
public:
    Sp_Menu_NewGame();
        // when click on the planet player
    void Click(); 
};


class Sp_Choice_NewGame:public Sp_Choice
{
public:
    Sp_Choice_NewGame(Stk_Font *fnt);
};


/* ----------------- High Scores --------------------- */
class Sp_Menu_HighScores:public Sp_BPlanet
{
public:
    Sp_Menu_HighScores();
        // when click on the planet quit
    void Click();
};

class Sp_Choice_HighScores:public Sp_Choice
{
public:
    Sp_Choice_HighScores(Stk_Font *fnt);
};

/* ----------------- Quit --------------------- */
class Sp_Menu_Quit:public Sp_BPlanet
{
public:
    Sp_Menu_Quit();
        // when click on the planet quit
    void Click();
};

class Sp_Choice_Quit:public Sp_Choice
{
public:
    Sp_Choice_Quit(Stk_Font *fnt);
};


/* ----------------- Player ------------------- */
class Sp_Menu_Player:public Sp_BPlanet
{
public:
    Sp_Menu_Player();
        // when click on the planet about
    void Click();
};

class Sp_Choice_Player:public Sp_Choice
{
public:
    Sp_Choice_Player(Stk_Font *fnt);
};

/* ----------------- Options ------------------- */
class Sp_Menu_Options:public Sp_BPlanet
{
public:
    Sp_Menu_Options();
        // when click on the planet about
    void Click();
};

class Sp_Choice_Options:public Sp_Choice
{
public:
    Sp_Choice_Options(Stk_Font *fnt);
};


/* ----------------- About ------------------- */
class Sp_Menu_About:public Sp_BPlanet
{
public:
    Sp_Menu_About();
        // when click on the planet about
    void Click();
};

class Sp_Choice_About:public Sp_Choice
{
public:
    Sp_Choice_About(Stk_Font *fnt);
};









class Sp_MenuPrincipal: public Stk_Prog
{
public:
    Sp_MenuPrincipal(Stk_Looper *);
    void GetFocus();
    ~Sp_MenuPrincipal();
    
    void MessageReceived(Stk_Message *);    
    int Loop();
private:
        // active planet
    int menuchoice;

    Stk_Font *font;
    Stk_Gui_Window *window;
    Sp_Choice *choice[6];

    Stk_CSound *clientsound;
    

};





#endif
