#include <stdio.h>
#include <stdlib.h>

#include "./graphics/ImageBuffer.h"
#include "stk/stk.h"
#include "sp_about.h"



extern int Sp_width;
extern int Sp_height;

float about_loop=0.0f;

Sp_WindowAbout::Sp_WindowAbout(Stk_Handler *handler, const Stk_Gui_Rect &r,char *tex_name)
        :Stk_Gui_Window(handler,r)
{
        // we load the texture
    ImageBuffer img(tex_name);
    img.toRGBA();
        // Read a texture
    glGenTextures(1,(GLuint *)&num_tex);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, num_tex);
    gluBuild2DMipmaps(GL_TEXTURE_2D,4,
                      img.getWidth(),
                      img.getHeight(),GL_RGBA,GL_UNSIGNED_BYTE,(unsigned char *)img.getData());
}

void Sp_WindowAbout::DrawBackGround()
{
        // draw the image
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, num_tex);
    glBegin(GL_QUADS);
    glTexCoord2f(0.0f,0.0f);
    glVertex3f(384.0f-about_loop,0.0f+about_loop,0.0f);
    glTexCoord2f(1.0f,0.0f);
    glVertex3f(639.0f-about_loop,0.0f+about_loop,0.0f);
    glTexCoord2f(1.0f,1.0f);
    glVertex3f(639.0f-about_loop,128.0f+about_loop,0.0f);
    glTexCoord2f(0.0f,1.0f);
    glVertex3f(384.0f-about_loop,128.0f+about_loop,0.0f);
    glEnd();
}




Sp_About::Sp_About(Stk_Prog *prg)
        :Stk_Prog(prg)
{
    quit=1;
    font=new Stk_FontTXF("default.txf");
    font->SetSize(10);
        // create the window
    window=new Sp_WindowAbout(this,Stk_Gui_Rect(0,0,640,480),"logo.png");
    vbox=new Stk_Gui_VBox();
    window->Attach(vbox);

    Stk_Gui_Text *t1;

    t1=new Stk_Gui_Text(font,"Ellis (Laurent Mallet)",STK_GUI_CENTER);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Programmers:",STK_GUI_LEFT);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Johannes Hirche",STK_GUI_CENTER);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Thomas Lund",STK_GUI_CENTER);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Webmaster:",STK_GUI_LEFT);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Bruno Van Frachem",STK_GUI_CENTER);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Configure:",STK_GUI_LEFT);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Luc Saillard",STK_GUI_CENTER);
     vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Graphics",STK_GUI_LEFT);
     vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Matti Hamalainen",STK_GUI_CENTER);
    vbox->Attach(t1);

    t1=new Stk_Gui_Text(font,"Track:",STK_GUI_LEFT);
    vbox->Attach(t1);
    
    Stk_Gui_EditLine *t2;
    t2=new Stk_Gui_EditLine(font,STK_GUI_CENTER);
    vbox->Attach(t2);

    Stk_Gui_Button *t3;
    t3=new Stk_Gui_Button(Stk_Gui_Rect());
    vbox->Attach(t3);
    
    t1=new Stk_Gui_Text(font,"Chris Cougourdan",STK_GUI_CENTER);
    vbox->Attach(t1);

 

}


Sp_About::~Sp_About()
{
    delete font;
    delete window;
}


void Sp_About::MessageReceived(Stk_Message *msg)
{
    int *valeur;
        // we have interest only in keyboard clavier
    if(msg->what!=STK_KEY_EVENT)
        return;
        // we have interest in keypressed message
    msg->FindInt("pressed",valeur);
     if(*valeur==0)
        return;
    msg->FindInt("key",valeur);
    switch(*valeur){
    case STK_K_ENTER:
      quit=0;
      break;
    case STK_K_ESCAPE:
      quit=0;
      break;
    }
}



int Sp_About::Loop()
{
        // On efface le color buffer
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    about_loop+=1;
    if(about_loop>(480.0f))
        about_loop=0;

    glDisable(GL_LIGHTING);
    window->Draw();
    glEnable(GL_LIGHTING);
    
    Stk_SwapBuffers();
    return quit;
}
