#ifndef __CIRCUIT_H
#define __CIRCUIT_H

#include <string>
#include <list>
#include <vector>
#include <stdio.h>
#include <stdlib.h>
#include "../stk/stk.h"
using namespace std;



#include "../math/sp_matrice.h"
#include "../math/sp_math.h"
#include "../math/sp_mathlin.h"
#include "../motor3d/sp_journey.h"
#include "../motor3d/sp_box.h"


// Nothing Optimised

class Sp_FaceC;
class Sp_CircuitC;



/* What's new:
   - the class Sp_Segment has disappeared
   - A Sp_FaceC is a face composed with 3 points
*/





/* *******************************************
*************** A 3D MultiBox ****************
******************************************* */
/** A multibox is a box which is divided into
    mini box. Pmin<= Point < Pmax */
class Sp_MBox:public Sp_Box
{
public:
        /// constructor
    Sp_MBox(int nb_step=3);
        /// the constructor
    Sp_MBox(float xmi,float xma,float ymi,float yma,float zmi,float zma,int nb_step=3);
        /// Another constructor
    Sp_MBox(const Sp_Box &,int nb_step=3);

    void Set(const Sp_Box &,int );
    
        // look the code
    int MinI(const Sp_Box &b);
    int MaxI(const Sp_Box &b);
    int MinJ(const Sp_Box &b);
    int MaxJ(const Sp_Box &b);
    int MinK(const Sp_Box &b);
    int MaxK(const Sp_Box &b);
    
        /// integer: number of minibox^3
    int nbstep;
};




/* ****************************************
**               an octo Tree            **
******************************************/
// A Sp_Box is divided into precision^3 sub box
template <class T>
class OctoTree
{
        // ******** Public Code *********
public:
        // the functions members
        // the constructors
    OctoTree(Sp_Box &b,int preci);

        // if we use the constructor without args, you must call the init function
    OctoTree();   
    void Init(const Sp_Box &b,int preci);
    
        // Insert an element T (Sp_Box is his including volume ) in OctoTree
    void Insert(const T &,const Sp_Box &);
    
        // Essential functions
        // find a list of element T which could contain point P
    void FindList(list<T> &,const Sp_Point &);
        // find a list of element T which could intersect box B
    void FindList(list<T> &,const Sp_Box &);
        // find a list of element T which could intersect Sphere S
    void FindList(list<T> &,const Sp_Sphere &);
    


        // *******  Private code  ********* 
  private:
        // find the coord in the tab  Warning the point must be in the bound box !!!
    void FindCoord(const Sp_Point &,int &x,int &y,int &z) const;    
        // Ajoute une liste a une autre
    void Add_Liste(list<T> &l,list<T> &l2);
    
        // the members datas
  private:
        // the bound box
    Sp_Box box;
        // the hashtable
    list<T> *tab;
        // the precision
    int precision;

};






/** The Tree World. Many constants are defined in sp_circuit.cpp */
//template <class T>
class Sp_Tree:public Sp_MBox
{
public:
        /// Constructor: We give a box which contains world 
    Sp_Tree(Sp_Box &b,int granu=4,int dp=0);
        /// if we use the constructor without args, you must call the init function
    Sp_Tree();
        /// Init function
    void Init(const Sp_Box &b,int granu=4,int dp=0);
    
    
        /// Add Element to build the Tree
    void Insert(Sp_FaceC *,const Sp_Box &);
    
    
        // Essential functions
        /// find a list of element T which could contain point P
    void FindList(list<Sp_FaceC *> &,const Sp_Point &);
        /// find a list of element T which could intersect box B
    void FindList(list<Sp_FaceC *> &,const Sp_Box &);
        /// find a list of element T which could intersect Sphere S
    void FindList(list<Sp_FaceC *> &,const Sp_Sphere &);

private:
        /// Ajoute une liste a une autre
    void Add_Liste(list<Sp_FaceC *> &l,list<Sp_FaceC *> &l2);
        /// Create a deeper tree
    void CreateDepth();
        /// Is this Tree a node ?
    char node;
        /// if it is node, elements are in this list
    list<Sp_FaceC *> elements;
        /// if not, we have an indirection
    Sp_Tree *indirection;
        /// Depth of this Leaf
    int depth;

};











/* ***************************************
***** a point and the face where it is ***
**************************************** */
class Sp_PointOnFace
{
  public:
    Sp_PointOnFace();
    Sp_PointOnFace(const Sp_Point &p1,Sp_FaceC *f1);
    Sp_Point p;
    Sp_FaceC *face;
};






/* ******************************************
  **  a circuit is a set of  faces **
 ***************************************** */
/** This class stocks informations about the structure of a circuit.
    But it is a Sp_Journey too */
class Sp_CircuitC :public Sp_Journey
{
  public:
        /// Constructor
    Sp_CircuitC();
        /// Add face from the list
    void Add_Face(Sp_FaceC *);

        // make some precomputations
    void PreCompute();
        // Find location 
    int FindLocation(list<Sp_PointOnFace> &l,const Sp_Sphere &,const Sp_Plan &);
    int FindLocationOn(Sp_PointOnFace &P,const Sp_Vecteur &displacement,Sp_PointOnFace &init);

        // Print information
    void Print() const;
    
        //the list of faces
    vector<Sp_FaceC *> list_faces;

    
  private:
        // private data
    OctoTree<Sp_FaceC *> octotree_faces;
    float size_average;
    float size_min;
    float size_max;
    
        // prviate functions
  public:
    
    void FindList(list<Sp_FaceC *> &,const Sp_Point &);
    void FindList(list<Sp_FaceC *> &,const Sp_Box &);
    void FindList(list<Sp_FaceC *> &,const Sp_Sphere &);

};










/* ***************************************
   ** a face is a closed outline **
*************************************** */
/** A face is composed by 3 points and used to build a track \\
    The 3 points are defined as pointers. So when points changed
    you must call the ReCompute() function.
    Version rewritten
 */
class Sp_FaceC
{  
public:

// member functions
    
        /// Constructor
    Sp_FaceC(float *p1,float *p2,float *p3);

        /// This function must be called when a point has changed
    void ReCompute();

        /// Give the normal of this face
    Sp_Vecteur Normale() const {return norm; }
  
        /// Give the center of this face
    Sp_Point Center() const {return center; }

        /// Give the plan of this face
    Sp_Plan Plan() const { return plan; }
    
        /// Is this point in the volume defined by face and diretion ?
    int IsIn(const Sp_Point &,const Sp_Vecteur &) const;
  
        /// Project a point on the face
    Sp_Point Project(const Sp_Point &,const Sp_Vecteur &) const;
  
        /// Project a vecteur on the face
    Sp_Vecteur Project(const Sp_Vecteur &) const;
  
        // Find the point where we quit the face
    int FindIntersection(const Sp_Segment &seg,Sp_Point &P) const;

    
    
        /// Print information for a face
    void Print() const;

        /// Attach this face to a checkpoint
    void AttachToCheckPoint(Sp_CheckPoint *);

        /// This player is on this face
    void Touch(int player,long time);
    
    
// member data
        // Pointers on the 3 points
    float *P1,*P2,*P3;

  
  public:
        // A face is contained in a box
    Sp_Box box; 



private:
        // compute the center
    void Calc_Center();
        // compute the normale
    void Calc_Normale();
        // compute the plan
    void Calc_Plan();
    
        // intern variable
    Sp_Vecteur norm;
    Sp_Point center;
    Sp_Plan  plan;
    Sp_Point Po1;
    Sp_Point Po2;
    Sp_Point Po3;
    Sp_Segment seg[3];

        // Pointer on the checkpoint
    Sp_CheckPoint *checkpoint;

};






#endif
