#include "../stk/stk.h"
#include "../util/sp_debug.h"
#include "sp_car.h"


#define SIGN_NORMALE -


/*    ****************************************
************** A Point on a circuit **********
****************************************    */



/* a stupid constructor */
Sp_RepereOnCircuit::Sp_RepereOnCircuit()
{}





// **** Compute the next position ****
/* direction is the displacement directional vector and distance the distance to do  */
void Sp_RepereOnCircuit::Compute_Next_Position(const Sp_Vecteur &displacement)
{
    
    Sp_PointOnFace init(O,face);
    Sp_PointOnFace P;
    if(circuit->FindLocationOn(P,displacement,init)){
            // we save the result
        O=P.p;
        face=P.face;
            // we compute I and K 
        K= SIGN_NORMALE face->Normale();     
        I=face->Project(I);
        I.Norme();
        K.Norme();
    } else {    
        printf("ComputeNextPosition not found\n");
    }

}




// **** The Init function: ****
// it finds: - the face of begin of track
//           - the normale for the car
void Sp_RepereOnCircuit::Init(Sp_CircuitC *c,Sp_Point &p,Sp_Vecteur &direction)
{
        // the current track
    I=direction;
    circuit=c;
        // We take this face for the begin of track
    face=(c->list_faces[2]);
    O=face->Center();
    I=face->Project(I);
        // We are doing the first reference
    K= SIGN_NORMALE face->Normale();
}









/*    ****************************************
**************** Behaviour of a car **********
****************************************    */


// ****  The constructor ****
Sp_Car::Sp_Car(char *name,Sp_Adm *gest3d,Sp_Obj *ton_pere,Stk_Control *control)
        :Sp_View(name,gest3d,ton_pere),Sp_Client_Time(gest3d)
{
        // We set the controler
    controler=control;
        // we set values of car
    distance_FR=3.0;
    angle_FR=15.0f*6.28f/360.0f;
    speed=0;
    angle=0;
        // we are adding a transformation
    position=new Sp_Trans(gest3d);
    trans.Add_Trans(position);
}


// ****  The desctructor ****
Sp_Car::~Sp_Car()
{}

// **** This Init function call this of the Sp_RepereOnCircuit ****
void Sp_Car::Init(Sp_CircuitC *c,Sp_Point &p,Sp_Vecteur &direction)
{
    Sp_RepereOnCircuit::Init(c,p,direction);
    Sp_Vecteur v=K^I;
    SetPosition(I,v);
}







#define DISTANCE_AU_SOL 0
// we give I & J
void Sp_Car::SetPosition(Sp_Vecteur &dirI,Sp_Vecteur &dirJ)
{
    Sp_Vecteur newK=dirI^dirJ;        
    dirJ=newK^dirI;

    dirI.Norme();                   
    dirJ.Norme();                  
    newK.Norme();                   

    Sp_Point OH;                 
    OH=O+newK*DISTANCE_AU_SOL;      
    position->Set(dirJ,dirI^dirJ,-dirI,OH);
}







/* This function compute the new Position of the car */
void Sp_Car::ComputeNextPosition(float time_elapsed)
{
    face->Touch(Sp_Player::id_journey,GetElapsedTime());
    
    Sp_Vecteur displacement=CIR(time_elapsed);
        //displacement.Print();
    
    Compute_Next_Position(displacement);

// Compute the rear points (Left and right)
    Sp_Point RR,RL;    
    if(FindRearPoint(distance_FR,-angle_FR,RR)&&FindRearPoint(distance_FR,angle_FR,RL)){
            // Case with rear point
            // Compute the middle
        Sp_Point Rear=Middle(RR,RL);
        Sp_Vecteur dirI=O-Rear;
        Sp_Vecteur dirJ=RR-RL;
            //    Sp_Vecteur dirJ=K^I;
        SetPosition(dirI,dirJ);        
        } else {
            // Case with no R or L rear points
            //printf("merde\n");
        Sp_Vecteur dirI(I);
        Sp_Vecteur dirJ(K^I);
        SetPosition(dirI,dirJ);
        }   
}





// this functions is based on CIR algo 
// it computes:
//    - a new I
//    - a displacement vector
Sp_Vecteur Sp_Car::CIR(float time_elapsed)
{

        // angle must be between -pi/2 and pi/2
    SP_ERROR( ( (angle>=(SP_PI/2)) || (angle <= (-SP_PI/2)) ),
              "Angle of wheels of car is stupid");

        // Compute the distance
    float distance=speed*time_elapsed;
    
        // the easiest case near 0

// !!! We must change this with a near operator
    if(angle==0)
        return I*distance;


        // Others cases
        //printf("angle:%f\n",angle);
        //I.Print();
 
    
        // We must find the rotational instantaneous center

        // We compute the Rear point
    Sp_Point Rear_Point;
    Rear_Point=O;
    Rear_Point=Rear_Point-I*distance_FR;
        // Now we compute CIR Point
    Sp_Point CIR;
    float R2=distance_FR/tan(angle);
    float R1=distance_FR/sin(angle);
    
        // to avoid problems
    if(R2>1000)
        return I*distance;
    
    CIR=Rear_Point-(K^I)*R2;

        // We compute the angular distance
    float alpha=distance/R1;
    
        // We compute the new I
        // printf("R1 %f\n",R1);
        //printf("angular distance %f\n",alpha);
    Sp_Axis Axis(CIR,K);
        //I.Print();
    I=Axis.TurnAround(I,alpha);
    I.Norme();
        //I.Print();
        // We compute NewO
    Sp_Point newO;
    if(distance>0)
        alpha=-alpha;
    
    newO=Axis.TurnAround(O,alpha);
    O.Print();
        //newO.Print();
    Sp_Vecteur dis;
    dis=newO-O;
    dis.Norme();
    return dis*distance;
}






/* This function search the position of Rear wheels
   method: we search intersection of a circle and the circuit
   the circle his the intersection of a sphere (center O radius width) and a plane
   inlcluding the direction of rear wheels. After we choice the rearest point
 */
int Sp_Car::FindRearPoint(float width,float angle,Sp_Point &result)
{
    Sp_Axis axis(O,K);
    Sp_Vecteur OR1=axis.TurnAround(I,angle);
    Sp_Plan P1(O,Sp_Point(O+OR1),face->Normale());
    list<Sp_PointOnFace> l1;
        // find solution if it exists
    if(circuit->FindLocation(l1,Sp_Sphere(O,width),P1)==0)
        return 0;
        // we choice the point behind O
    typedef list<Sp_PointOnFace>::iterator iter;
//    printf("profile info: %d\n ",l1.size());
    for(iter i=l1.begin();i!=l1.end();i++){
        if(O.IsAheadOf((*i).p,I)){
            result=(*i).p;
            return 1;
        }
    }
    return 0;
}



// ****** Essential *******

void Sp_Car::Event()
{
        // We compute time elapsed
    float time_frame=((float)GetFrameElapsedTime())/1000.0f;
        // we read state of controler
    controler->ReadState();
    
        // we accelerate as we push the controler
    Accelerate( time_frame  * 5.0f*controler->getPositionAxeY());
    TurnRL(30.0 * controler->getPositionAxeX()/360.0);
}




// this function is called each frame 
void Sp_Car::DrawObj(void)
{
        // We compute time elapsed
    float time_frame=((float)GetFrameElapsedTime())/1000.0f;
    Event();
        // we have a unacceleration cst
    if(speed>0){
        speed-=0.95*time_frame;
        if(speed<0)
            speed=0;
    }else{
        speed+=0.95*time_frame;
        if(speed>0)
            speed=0; 
    }
    
        // suuuuper stupid slowdown
        // We must insert code for each frame
    ComputeNextPosition(1);
}



// *****  functions to conduct a car *****

// the direction of car 
void Sp_Car::TurnRL(float theta)
{
    angle=theta;
    if(angle>60.0f*6.28f/360.0f){
        angle=59.0f*6.28f/360.0f;
    }else if(angle<-60.0f*6.28f/360.0f){
        angle=-59.0f*6.28f/360.0f;
    }    
}

void Sp_Car::Accelerate(float value)
{
        // no speed limit...  ;)
        // linear acceleration :(
        // limitation speed
    if( (speed < 5.0f) && (speed > -5.0f)){
        speed+=value;
    }
}









Sp_CameraCar::Sp_CameraCar(char *name,Sp_Adm *gest3d,Sp_Obj *ton_pere)
        :Sp_View(name,gest3d,ton_pere)
{
        // we are adding a transformation
    position=new Sp_Trans(gest3d);
    position->Trans(0,2,-1);
    trans.Add_Trans(position);
}
