#ifndef SP_TRANS_H
#define SP_TRANS_H

#include <list>
#include "../math/sp_matrice.h"
#include "../util/sp_time.h"
using namespace std;

// A Trans (it represents a geometric transformation)
class Sp_Trans;
// A List of Trans 
class Sp_LTrans;


class Sp_Trans : public Sp_Mat4, public Sp_Client_Time
{
  public:
        // the constructor
    Sp_Trans(Sp_Adm_Time *);
        // the function which is called at each frame:
        // it allows to modify automaticaly a matrix
   void Tick();
       // this function is called in Tick: to modify the trans use it
   virtual void Work();

  public:
       // A flag to indicate if the matrix has changed not yet used
   int changed;
  protected:
       // the current frame number
   long current_framecounter;
};


class Sp_LTrans
{
  public:
        // the constructor
    Sp_LTrans();
        // Add an Trans
    void Add_Trans(Sp_Trans *);
    void Rem_Trans(Sp_Trans *);
        // Compute the result
    void Compute();
    
        // the datas
        // a list of transformations
    list<Sp_Trans *> list_trans;
        // the result
    Sp_Mat4 result;
  
    
};


/* *********** Some classics Trans ************ */
class Sp_Rot : public Sp_Trans
{
  public:
        // the constructors
    Sp_Rot(Sp_Adm_Time *,float r1,float r2,float r3);
    virtual void Work();
  private:
    float ra;
    float rb;
    float rc;
};




#endif
