#include "sp_trans.h"


/* ************* The Trans Class ************* */

Sp_Trans::Sp_Trans(Sp_Adm_Time *admtime):Sp_Mat4(),Sp_Client_Time(admtime)
{
    changed=0;
    Id();
}


void Sp_Trans::Tick()
{
    if(current_framecounter==GetFrameCounter()){
            // the work for this frame has been done
        return;
    }
    current_framecounter=GetFrameCounter();
    Work();
}

// You must surcharge this function to modify trans at each frame
void Sp_Trans::Work()
{
}


/* ************* The LTrans Class ************* */

Sp_LTrans::Sp_LTrans()
{}


void Sp_LTrans::Add_Trans(Sp_Trans *tr)
{
    list_trans.push_front(tr);
}


void Sp_LTrans::Rem_Trans(Sp_Trans *tr)
{
    list_trans.remove(tr);
}

void Sp_LTrans::Compute()
{
    Sp_Mat4 res;
    res.Id();
    typedef list<Sp_Trans *>::iterator iter_Sp_Trans;
    for(iter_Sp_Trans i=list_trans.begin();i!=list_trans.end();i++)
    {
        (*i)->Tick();
        res=res*(**i);
    }
    result=res;
}


/* ************* Some classics Trans ************** */
Sp_Rot::Sp_Rot(Sp_Adm_Time *adm,float r1,float r2,float r3)
        :Sp_Trans(adm)
{
    ra=r1;
    rb=r2;
    rc=r3;
}


void Sp_Rot::Work()
{
    float t=GetFrameElapsedTime()/100.0;
    Sp_Mat4 rx;rx.SetX(ra*t);
    Sp_Mat4 ry;ry.SetY(rb*t);
    Sp_Mat4 rz;rz.SetZ(rc*t);
    Sp_Mat4 rotation; rotation=rx*ry*rz;
    *((Sp_Mat4 *)this)=(*((Sp_Mat4 *)this))*rotation;
}
