#include <stdio.h>
#include <stdlib.h>

#include "../stk/stk.h"
#include "../motor3d/sp_obj.h"
#include "../motor3d/face.h"
#include "../graphics/ImageBuffer.h"


/* -------------------------------------------------------------- */
/*                              Sp_Obj                            */
/* -------------------------------------------------------------- */

/* Don't use this constructor */
Sp_Obj::Sp_Obj()
{
    Name="Unknown Object";
    father=0; 
}


/* You must use this constructor */
Sp_Obj::Sp_Obj(char *name,Sp_Adm *adm3d,Sp_Obj *your_father,int prio)
        :Name(name)
{
    father=your_father;
    adm=adm3d;
    priority=prio;    
}

Sp_Obj::~Sp_Obj()
{
}


void Sp_Obj::Add_Obj(Sp_Obj *son)
{
    sons.push_back(son);
}


void Sp_Obj::Rem_Obj(Sp_Obj *son)
{
    sons.remove(son);
}


void Sp_Obj::Add_Entity(Sp_EntityBase *entity)
{
    entities.push_back(entity);
}


void Sp_Obj::Rem_Entity(Sp_EntityBase *entity)
{
    entities.remove(entity);
}


void Sp_Obj::Print() const 
{
    printf("name of object: %s\n",Name.c_str());
    coord_camera.Print();
}

Sp_Mat4 Sp_Obj::GetProjection() const
{
    Sp_Mat4 tmp;
    glGetFloatv(GL_PROJECTION_MATRIX,tmp.tab);
    return tmp*coord_camera;
}


void Sp_Obj::DrawObj()
{}



void Sp_Obj::ComputeTrans()
{
        // On parcourt la liste des fils
    typedef list<Sp_Obj *>::iterator iter_Sp_Obj;

    trans.Compute();
    coord_camera=father->coord_camera*trans.result;
    
    for(iter_Sp_Obj i=sons.begin();i!=sons.end();i++){
        (*i)->ComputeTrans();
    }
}

void Sp_Obj::ComputeTrans2()
{
        // On parcourt la liste des fils
    typedef list<Sp_Obj *>::iterator iter_Sp_Obj;
    coord_camera=father->coord_camera*trans.result;
    
    for(iter_Sp_Obj i=sons.begin();i!=sons.end();i++){
        (*i)->ComputeTrans2();
    }
}


/* ------------------------------------------------------ */
/* ------------------ Sp_View   ------------------------- */
/* ------------------------------------------------------ */
Sp_View::Sp_View(char *name,Sp_Adm *adm3d,Sp_Obj *your_father)
        :Sp_Obj(name,adm3d,your_father,0) // no priority
{}


Sp_View::~Sp_View()
{}


/* -------------------------------------------------------------- */
/*                              Sp_Light                          */
/* -------------------------------------------------------------- */
Sp_Light::Sp_Light(char *name,Sp_Adm *adm3d,Sp_Obj *your_father)
        :Sp_Obj(name,adm3d,your_father,0) //no priority
{
    active=0;
    num_light=-1;
}

Sp_Light::~Sp_Light()
{}

void Sp_Light::Enable()
{
    active=1;
}

void Sp_Light::Disable()
{
    active=0;
}

int Sp_Light::IsEnabled()
{
    return active;
}

void Sp_Light::Light()
{}


/* -------------------------------------------------------------- */
/*                              Sp_Adm                            */
/* -------------------------------------------------------------- */
//   Le constructeur
Sp_Adm::Sp_Adm(char *name):Sp_Adm_Time()
{
    Name=name;
    adm=this;
    father=0;
}



//   Le destructeur
Sp_Adm::~Sp_Adm()
{
}



void Sp_Adm::Add_Obj(Sp_Obj *new_obj)
{
    typedef list<Sp_Obj *>::iterator iter;
    iter i=objs.begin();
    while(i!=objs.end()){
        if(new_obj->priority < (*i)->priority){
            objs.insert(i,new_obj);
            Sp_Obj::Add_Obj(new_obj);
            return;
        }
        i++;
    }
    objs.push_back(new_obj);
    Sp_Obj::Add_Obj(new_obj);
}


void Sp_Adm::Rem_Obj(Sp_Obj *old_obj)
{
    objs.remove(old_obj);
    Sp_Obj::Rem_Obj(old_obj);
}


int Sp_Adm::Load_texture(char *filename)
{
    int tex;
    
    ImageBuffer img(filename);
    img.toRGBA();

    glGenTextures(1,(GLuint *)&tex);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, tex);
    gluBuild2DMipmaps(GL_TEXTURE_2D,4,
                      img.getWidth(),
                      img.getHeight(),GL_RGBA,GL_UNSIGNED_BYTE,(unsigned char *)img.getData());
    return tex;
}


void Sp_Adm::Delete_texture(int t)
{
    glDeleteTextures(1,(GLuint *)&t);
}


void Sp_Adm::Add_View(Sp_View *v)
{
    views.push_back(v);
}

void Sp_Adm::Rem_View(Sp_View *v)
{
    views.remove(v);
}

void Sp_Adm::Active_View(Sp_View *v)
{
    current_view=v;
}


void Sp_Adm::Add_Light(Sp_Light *l)
{
    lights.push_back(l);
}

void Sp_Adm::Rem_Light(Sp_Light *l)
{
    lights.remove(l);
}

void Sp_Adm::LightScene()
{
     typedef list<Sp_Light *>::iterator iter_Sp_Light;
     for(iter_Sp_Light i=lights.begin();i!=lights.end();i++){
         if((*i)->IsEnabled())
             (*i)->Light();
     }
}



void Sp_Adm::Transformations()
{
    typedef list<Sp_Obj *>::iterator iter_Sp_Obj;
    trans.Compute();
    coord_camera=trans.result;
    
    for(iter_Sp_Obj i=sons.begin();i!=sons.end();i++){
        (*i)->ComputeTrans();
    }
}

void Sp_Adm::Transformations2()
{
    typedef list<Sp_Obj *>::iterator iter_Sp_Obj;
    coord_camera=current_view->coord_camera.Inverse();
    
    for(iter_Sp_Obj i=sons.begin();i!=sons.end();i++){
        (*i)->ComputeTrans2();
    }
}




void Sp_Adm::DrawScene()
{
        // this function must be called once at each frame
        // it computes the time elapsed with the last frame
        // it is a function from the time server
    FrameTick();

        // We compute the Transformations % world
    Transformations();

        // and % view
    Transformations2();
    
        // Light the scene
    LightScene();

        // Next, we draw each object (classified by priority)
    typedef list<Sp_Obj *>::iterator iter;
    for(iter i=objs.begin();i!=objs.end();i++){
        glPushMatrix();
        glLoadMatrixf((*i)->coord_camera.tab);
        (*i)->DrawObj();
        glPopMatrix();
    }
}




