#include "../stk/stk.h"
#include "../math/sp_math.h"
#include "../motor3d/sp_box.h"
#include "../util/sp_debug.h"

// ***********************************************************
// ************ A 3d box *************************************
// ***********************************************************

Sp_Box::Sp_Box(const Sp_Point &p)
{
  Pmin=Pmax=p;
}


Sp_Box:: Sp_Box(float xmi,float xma,float ymi,float yma,float zmi,float zma)
{
  Pmin.x=xmi; Pmax.x=xma;
  Pmin.y=ymi; Pmax.y=yma;
  Pmin.z=zmi; Pmax.z=zma;
}

Sp_Box::Sp_Box(const Sp_Box &b)
{
  Pmin=b.Pmin; Pmax=b.Pmax;
}


Sp_Point Sp_Box::Center() const
{
    Sp_Point tmp;
    tmp.x=(Pmin.x+Pmax.x)/2;
    tmp.y=(Pmin.y+Pmax.y)/2;
    tmp.z=(Pmin.z+Pmax.z)/2;        
    return tmp;
}


int Sp_Box::IsIn(const Sp_Point &p) const
{
  if( (p.x>=Pmin.x) && (p.y>=Pmin.y) && (p.z>=Pmin.z) &&
      (p.x<=Pmax.x) && (p.y<=Pmax.y) && (p.z<=Pmax.z))
    return 1;
  else
    return 0;
}

int Sp_Box::IsIn(const Sp_Box &b) const
{
  if(IsIn(b.Pmin)&&IsIn(b.Pmax))
    return 1;
  else
    return 0;
}


int Sp_Box::IsIntersection(const Sp_Box &b) const
{
  // we have three cases:
  // b is in this, this is in b or a point of b is in this
  if(IsIn(b)||b.IsIn(*this))
    return 1;
  if(IsIn(b.Pmin)|| IsIn(b.Pmax))
    return 1;
  return 0;
}

void Sp_Box::Add_Point(const Sp_Point &p)
{
  if(Pmin.x>p.x)
    Pmin.x=p.x;
  if(Pmin.y>p.y)
    Pmin.y=p.y;
  if(Pmin.z>p.z)
    Pmin.z=p.z;
  if(Pmax.x<p.x)
    Pmax.x=p.x;
  if(Pmax.y<p.y)
    Pmax.y=p.y;
  if(Pmax.z<p.z)
    Pmax.z=p.z;
}

void Sp_Box::Add_Box(const Sp_Box &b)
{
  Add_Point(b.Pmin);
  Add_Point(b.Pmax);
}

void Sp_Box::Print() const
{
  printf("une Sp_Box\n");
  Pmin.Print();
  Pmax.Print();
}

float Sp_Box::WidthX() const
{
    return Pmax.x-Pmin.x;
}

float Sp_Box::WidthY() const
{
    return Pmax.y-Pmin.y;
}

float Sp_Box::WidthZ() const
{
    return Pmax.z-Pmin.z;
}


float Sp_Box::Width() const
{
    return Pmin.Distance(Pmax);
}



static void create_8_points(Sp_Point *pts,const Sp_Point &min,const Sp_Point &max)
{
    pts[0].x=min.x;  pts[0].y=min.y; pts[0].z=min.z;
    pts[1].x=min.x;  pts[1].y=min.y; pts[1].z=max.z;
    pts[2].x=min.x;  pts[2].y=max.y; pts[2].z=min.z;
    pts[3].x=min.x;  pts[3].y=max.y; pts[3].z=max.z;

    pts[4].x=max.x;  pts[4].y=min.y; pts[4].z=min.z;
    pts[5].x=max.x;  pts[5].y=min.y; pts[5].z=max.z;
    pts[6].x=max.x;  pts[6].y=max.y; pts[6].z=min.z;
    pts[7].x=max.x;  pts[7].y=max.y; pts[7].z=max.z;
    return;
}

/*
  return = 1 if all w > 0
  return = 2 if all w < 0
  return = 0 else
 */
static int test1(Sp_Point *pts)
{
    int i;
    int plusw=0; int moinsw=0;
    for(i=0;i<8;i++){
        if(pts[i].w>0){
            plusw+=1;
        } else {
            moinsw+=1;
        }
    }
    if(plusw==8)
        return 1;
    if(moinsw==8){
        return 2;
    }
    return 0;    
}

/*
  return = 1 if all x > 1
  return = 2 if all x < -1
  return = 0 else
 */  
static int test2(Sp_Point *pts)
{
    int i;
    int plusw=0; int moinsw=0;
    for(i=0;i<8;i++){
        if(pts[i].x>1){
            plusw+=1;
        } else if (pts[i].x<-1) {
            moinsw+=1;
        }
    }
    if(plusw==8)
        return 1;
    if(moinsw==8){
        return 2;
    }
    return 0;    
}


/*
  return = 1 if all y > 1
  return = 2 if all y < -1
  return = 0 else
 */  
static int test3(Sp_Point *pts)
{
    int i;
    int plusw=0; int moinsw=0;
    for(i=0;i<8;i++){
        if(pts[i].y>1){
            plusw+=1;
        } else if (pts[i].y<-1) {
            moinsw+=1;
        }
    }
    if(plusw==8)
        return 1;
    if(moinsw==8){
        return 2;
    }
    return 0;    
}

/*
  return = 1 if all z > 1
  return = 2 if all z < -1
  return = 0 else
 */  
static int test4(Sp_Point *pts)
{
    int i;
    int plusw=0; int moinsw=0;
    for(i=0;i<8;i++){
        if(pts[i].z>1){
            plusw+=1;
        } else if (pts[i].z<-1) {
            moinsw+=1;
        }
    }
    if(plusw==8)
        return 1;
    if(moinsw==8){
        return 2;
    }
    return 0;    
}


int Sp_Box::IsVisible(const Sp_Mat4 &projection) const
{
    int i;
    Sp_Point pts[8];
    create_8_points(pts,Pmin,Pmax);
    for(i=0;i<8;i++){
        pts[i]=projection*pts[i];
    }
    switch(test1(pts)){
        case 0:
            return 1;
        case 2:
            return 0;
        case 1:
            break;
    }
        // all w > 0
    for(i=0;i<8;i++){
        pts[i].x/=pts[i].w;  pts[i].y/=pts[i].w;  pts[i].z/=pts[i].w;
    }

    int tet=test2(pts)*test3(pts)*test4(pts);
    if(tet!=0){
        return 0;
    }
    return 1;
}


