#include "../stk/stk.h"
#include "planets.h"

#define STACKS 10
#define SLICES 10
#define COEF   10

Sp_Obj_Planets *mercure,*venus,*earth,*mars,*jupiter,*saturne,*uranus,*neptune;

void Sp_Load_Planetes(Sp_Adm *gest3d,Sp_Obj *ton_pere)
{
    Sp_Trans *tr;
        // on cree une planete MERCURE
    mercure=new Sp_Obj_Planets(0.1f,"mercury.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(mercure);
    tr=new Sp_Rot(gest3d,0.0f,0.0f,10.0f/360.0f);
    mercure->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(-1.867591f*COEF,0.469926f*COEF,3.371086f*COEF);
    mercure->trans.Add_Trans(tr);

        // on cree une planete VENUS
    venus=new Sp_Obj_Planets(0.25f,"venus.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(venus);
    tr=new Sp_Rot(gest3d,0.0f,10.0f/360,0.0f);
    venus->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(7.114879f*COEF,0.199492f*COEF,-1.292640f*COEF);
    venus->trans.Add_Trans(tr);
    
        // on cree une planete EARTH
    earth=new Sp_Obj_Planets(0.26f,"earth.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(earth);
        // Rotation
    tr=new Sp_Rot(gest3d,10.0f/360.0f,0.0f,0.0f);
    earth->trans.Add_Trans(tr);
        // Translation
    tr=new Sp_Trans(gest3d);
    tr->Trans(4.579938f*COEF,-0.000004f*COEF,8.887195f*COEF);
    earth->trans.Add_Trans(tr);

        // on cree une planete MARS
    mars=new Sp_Obj_Planets(0.14f,"mars.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(mars);
    tr=new Sp_Rot(gest3d,0.0f,10.0f/360.0f,0.0f);
    mars->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(-12.469102f*COEF,-0.488428f*COEF,-8.722921f*COEF);
    mars->trans.Add_Trans(tr);

        // on cree une planete JUPITER
    jupiter=new Sp_Obj_Planets(0.96f,"jupiter.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(jupiter);
    tr=new Sp_Rot(gest3d,0.0f,10.0f/360.0f,0.0f);
    jupiter->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(3.869f*COEF,-0.022f*COEF,-51.843f*COEF);
    jupiter->trans.Add_Trans(tr);
 
        // on cree une planete SATURNE
    saturne=new Sp_Obj_Planets(0.80f,"saturn.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(saturne);
    tr=new Sp_Rot(gest3d,10.0f/360.0f,0.0f,0.0f);
    saturne->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(-59.942f*COEF,-3.537f*COEF,74.268f*COEF);
    saturne->trans.Add_Trans(tr);
    
        // on cree une planete URANUS
    uranus=new Sp_Obj_Planets(0.34f,"uranus.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(uranus);
    tr=new Sp_Rot(gest3d,0.0f,10.0f/360.0f,0.0f);
    uranus->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(-40.61f*COEF,-2.58f*COEF,-187.566f*COEF);
    uranus->trans.Add_Trans(tr);

        // on cree une planete NEPTUNE
    neptune=new Sp_Obj_Planets(0.33f,"neptune.png",gest3d,ton_pere,1);
    gest3d->Add_Obj(neptune);
    tr=new Sp_Rot(gest3d,0.0f,0.0,10.0f/360.0f);
    neptune->trans.Add_Trans(tr);
    tr=new Sp_Trans(gest3d);
    tr->Trans(188.032f*COEF,7.040f*COEF,234.41f*COEF);
    neptune->trans.Add_Trans(tr);

}

void Sp_Delete_Planetes()
{
  delete mercure; delete venus;
  delete earth; delete mars;
  delete jupiter; delete saturne;
  delete uranus; delete neptune;
}

Sp_Obj_Planets::Sp_Obj_Planets(float radius,char *texname,Sp_Adm *adm3d,Sp_Obj *ton_pere,int priority):Sp_Obj(texname,adm3d,ton_pere,priority)
{
  // On cree une Sp_Entity
  Sp_Entity *entity=new Sp_Entity(this);
  
  // on a une phere
  Sp_GEntitySphere *current;
  current=new Sp_GEntitySphere(entity,radius*COEF);
  current->slices=SLICES;
  current->stacks=STACKS;
  current->num_tex=Sp_Adm::Load_texture(texname);
  entity->Add_GEntity(current);
  
  Add_Entity(entity);
}


void Sp_Obj_Planets::Draw()
{
  typedef list<Sp_EntityBase *>::iterator iter;
  typedef list<Sp_GEntityBase *>::iterator iter2;
  
  for(iter i=entities.begin();i!=entities.end();i++)
    {
      (*i)->DrawEntity();
    }
}

void Sp_Obj_Planets::DrawObj()
{
    glDisable(GL_DEPTH_TEST);
    Draw();
    glEnable(GL_DEPTH_TEST);
}
