#include "../stk/stk.h"
#include "../stk/kernel/stk_debug.h"
#include "loadgl.h"






// Constantes used for the description of the circuit
//   number of point to describe the shape of circuit ?
#define NB_PT_CONTOUR 16
//   number of float by point
#define NB_FLOAT_PT 8
//   number of draw elements
#define CST 22272
//   scaling of circuit
#define SCALE 5.0
//   number of pieces ( CST mod NB_SEGMENTS must be 0!!! circuit is divised into pieces )
#define NB_SEGMENTS 64



// basis triangles
int tr1[3]={0,17,16};
int tr2[3]={17,0,1};

// pt in
int tsize=9;
int tsel[NB_PT_CONTOUR]={0,1,2,3,4, 15,14,13,12};



template <class T>
Stk_Array<T>::Stk_Array(int sz_max)
{
    nb_elements=0;
    size_max=sz_max;
    array=new T[size_max];
}

template <class T>
Stk_Array<T>::~Stk_Array()
{
    delete[] array ;
}


template <class T>
void Stk_Array<T>::put(const T &el)
{
    STK_ERROR((nb_elements>=size_max),"We are out the limit of this array");
    array[nb_elements]=el;
    nb_elements++;
}



// ---------------------------------------------------
// ----------------- Select indices ------------------
// ---------------------------------------------------

sp_indice_list::sp_indice_list(int sz_max,int nb)
        :Stk_Array<unsigned int>(sz_max)
{
        // shape
    nb_points_on_shape=nb;
}

void sp_indice_list::Add_Indice(const unsigned int &ind)
{
    put(ind);
}

int sp_indice_list::isIndiceInList(const unsigned int &ind)
{
    int j;
    for(j=0;j<nb_elements;j++){
        if( (ind%nb_points_on_shape)==array[j] )
            return 1;
    }
    return 0;
}

unsigned int *sp_indice_list::select_face_in(unsigned int *data,int nb_faces,int *nb_trouve)
{
    int i,nb;
    unsigned int *new_data;
    new_data=new unsigned int[nb_faces*3];
    
    nb=0;
    for(i=0;i<nb_faces;i++)
    {
        if(isIndiceInList(data[3*i+0])==0)
            continue;
        if(isIndiceInList(data[3*i+1])==0)
            continue;
        if(isIndiceInList(data[3*i+2])==0)
            continue;
            // Les trois indices y sont
        new_data[nb*3]=data[3*i+0];
        new_data[nb*3+1]=data[3*i+1];
        new_data[nb*3+2]=data[3*i+2];
        nb++;
    }
    *nb_trouve=nb*3;
    return new_data;
}

unsigned int *sp_indice_list::select_face_out(unsigned int *data,int nb_faces,int *nb_trouve)
{
    int i,nb;
    unsigned int *new_data;
    new_data=new unsigned int[nb_faces*3];

    nb=0;
    for(i=0;i<nb_faces;i++)
    {
        if((isIndiceInList(data[3*i+0])==1)&&(isIndiceInList(data[3*i+1])==1)&&(isIndiceInList(data[3*i+2])==1))
            continue;
            // Les trois indices y sont
        new_data[nb*3]=data[3*i+0];
        new_data[nb*3+1]=data[3*i+1];
        new_data[nb*3+2]=data[3*i+2];
        nb++;
    }
    *nb_trouve=nb*3;
    return new_data;
}







// ------------------------------------------------
// -------------- UseFull functions ---------------
// ------------------------------------------------

static int module(int nb_total,int pan_out,int indice)
{
    if(pan_out*indice>nb_total){
        return nb_total-pan_out*indice;
    }
    return pan_out;
}


// generates indices to compose triangles with the shape



static int formule1(int a,int b)
{
    int div=a/NB_PT_CONTOUR;
    int mod=(a+b)%NB_PT_CONTOUR;
    return (div*NB_PT_CONTOUR)+mod;
}

// create NB_PT_CONTOUR triangles: WARNING dst is modified 
static int *GenerateTrianglesForAStep(int *data,int ind_basis)
{
    int i;
    for(i=0;i<NB_PT_CONTOUR;i++){
            // triangles odd
        data[0]=formule1(tr1[0]+ind_basis,i);
        data[1]=formule1(tr1[1]+ind_basis,i);
        data[2]=formule1(tr1[2]+ind_basis,i);
            // others triangles
        data[3]=formule1(tr2[0]+ind_basis,i);
        data[4]=formule1(tr2[1]+ind_basis,i);
        data[5]=formule1(tr2[2]+ind_basis,i);
        data+=6;
    }
    return data;
}


// create triangles
static void GenerateTriangles(int *dst,int nb_step)
{
    int i;
    int *data=dst;
    for(i=0;i<nb_step;i++){
        data=GenerateTrianglesForAStep(data,i*NB_PT_CONTOUR);
    };
    
}





// generate the texture coordinates
// pour un point, on a 8 float decoupe comme ci dessous
        // 2 de textures
        // 3 de normales
        // 3 de point
        // entity est une suite de ces groupements
        // ici le contour du circuit est en 8 points
        // d ou 8*8 decrit un contour
static void TextureCoords(float *data,int nbpts)
{
    float texture_depth=0.0f;
    float step=0.1f;
    int   i,k;
    for(k=0;k<nbpts;k+=NB_PT_CONTOUR){
        for(i=0;i<NB_PT_CONTOUR;i++){
            data[(k+i)*NB_FLOAT_PT+1]=texture_depth;
        }
        texture_depth+=step;
    }
    for(k=0;k<nbpts;k+=NB_PT_CONTOUR){

            // point 4
        data[(k+4) *NB_FLOAT_PT]=0.0f;
            // point 3
        data[(k+3) *NB_FLOAT_PT]=0.1f;
            // point 2
        data[(k+2) *NB_FLOAT_PT]=0.2f;
            // point 1 
        data[(k+1) *NB_FLOAT_PT]=0.4f;
            // point 0
        data[(k+0) *NB_FLOAT_PT]=0.5f;
            // point 15
        data[(k+15)*NB_FLOAT_PT]=0.6f;
            // point 14
        data[(k+14)*NB_FLOAT_PT]=0.8f;
            // point 13
        data[(k+13)*NB_FLOAT_PT]=0.9f;
            // point 12
        data[(k+12)*NB_FLOAT_PT]=1.0f;
    }
    
}




// takes points from file. copy the first shape to the end
// generates the texture coordinates & normalize normales
static float *LoadGL(char *filename,long &nbfloat)
{
    int i;
    Stk_File *File=new Stk_File(filename);
    nbfloat=File->Size()/4;
    float *fdata=new float[nbfloat+NB_PT_CONTOUR*NB_FLOAT_PT];
        // Pt in 3ds file
    for(i=0;i<nbfloat;i++){
        fdata[i]=File->LoadFloat();
    }
    delete File;
        // loop points
    for(i=0;i<NB_PT_CONTOUR*NB_FLOAT_PT;i++){
        fdata[nbfloat+i]=fdata[i];
    }
    nbfloat+=NB_PT_CONTOUR*NB_FLOAT_PT;
        // scale & normalize
    for(i=0;i<(nbfloat/NB_FLOAT_PT);i++){
        fdata[8*i+5]*=SCALE;
        fdata[8*i+6]*=SCALE;
        fdata[8*i+7]*=SCALE;
        float rac=sqrt(fdata[8*i+2]*fdata[8*i+2]+
                       fdata[8*i+3]*fdata[8*i+3]+
                       fdata[8*i+4]*fdata[8*i+4]);
        if(rac!=0){
            fdata[8*i+2]/=rac;
            fdata[8*i+3]/=rac;
            fdata[8*i+4]/=rac;
        } else {
            STK_WARNING((rac==0),"Problem with normals");
        }
    }
    TextureCoords(fdata,(nbfloat/NB_FLOAT_PT));
    return fdata;
}



// ---------------------------------------------------
// -------------- Load a graphic File ----------------
// ---------------------------------------------------
Sp_Obj_gl::Sp_Obj_gl(char *filename,Sp_Adm *adm3d,Sp_Obj *ton_pere,int priority):Sp_Obj(filename,adm3d,ton_pere,priority)
{


    int i;
    long size;

    Sp_EntityMultiplexe *entity=new Sp_EntityMultiplexe(this);
    entity->Init_Data(0,GL_T2F_N3F_V3F);
    entity->data=LoadGL(filename,size);

    int begin_pts=0;
    int nb_pts=size/8;

    int nb2=CST;
    unsigned int *data2=new unsigned int[CST];
    GenerateTriangles((int *)data2,(nb_pts/NB_PT_CONTOUR)-1);
    
                      
        // un epurateur permet de selectionner des faces 
    sp_indice_list epurateur(NB_PT_CONTOUR,NB_PT_CONTOUR); // nb de points dans le contour

    for(i=0;i<tsize;i++){
        epurateur.Add_Indice(tsel[i]);
    }
    

        // Dans ce cas, on selectionne les faces qui ne contiennent pas les
        // points indices dans l epurateur
    int nb_out;
    unsigned int *data_out=epurateur.select_face_out(data2,nb2/3,&nb_out);
    int nbtriangles_out=nb_out/3;
    int pan_out=nbtriangles_out/NB_SEGMENTS;
    int num_texture=Sp_Adm::Load_texture("texture2.png");
    for(i=0;i<NB_SEGMENTS;i++){
        Sp_GEntityMulti *current;
        current=new Sp_GEntityMulti(entity);
        current->type=GL_TRIANGLES;
        current->data=&data_out[pan_out*i*3];
        current->num_tex=num_texture;
        current->nb=module(nb_out,pan_out*3,i);
        current->ComputeBox();
            // svg dans un fichier
            //printf("nb:%i\n",current->nb);
        entity->Add_GEntity(current);
    }
    



        // Dans ce cas, on selectionne les faces qui contiennent les
        // points indices dans l epurateur

    int nb_in;
    unsigned int *data_in=epurateur.select_face_in(data2,nb2/3,&nb_in);
    int nbtriangles_in=nb_in/3;
    int pan_in=nbtriangles_in/NB_SEGMENTS;
    num_texture=Sp_Adm::Load_texture("texture4.png");

    for(i=0;i<NB_SEGMENTS;i++){
        Sp_GEntityMulti *current;
        current=new Sp_GEntityMulti(entity);
        current->type=GL_TRIANGLES;
        current->data=&data_in[pan_in*i*3];
        current->num_tex=num_texture;
        current->nb=module(nb_in,pan_in*3,i);
        current->ComputeBox();
            // svg dans un fichier
            //printf("nb:%i\n",current->nb);
        entity->Add_GEntity(current);
    }
  
    
    Add_Entity(entity);

        // We're creating ojects for the physics
    for(i=begin_pts;i<NB_PT_CONTOUR*2;i++){
        printf("%f %f %f \n",
               entity->data[i*8+5],
               entity->data[i*8+6],
               entity->data[i*8+7]);    
    }
  
  
}

void Sp_Obj_gl::Draw()
{
    typedef list<Sp_EntityBase *>::iterator iter;
  
    for(iter i=entities.begin();i!=entities.end();i++)
    {
        (*i)->DrawEntity();
    }
}

void Sp_Obj_gl::DrawObj()
{
    Draw();
}



Sp_Load_CircuitC::Sp_Load_CircuitC(char *filename)
        :Sp_CircuitC()
{

    int i;
    long size;
    float *donnees=LoadGL(filename,size);
    int nb_pts=size/8;
    
    int nb2=CST;
    
    unsigned int *data2=new unsigned int[CST];
    GenerateTriangles((int *)data2,(nb_pts/NB_PT_CONTOUR)-1);

    
        // un epurateur permet de selectionner des faces 
    sp_indice_list epurateur(NB_PT_CONTOUR,NB_PT_CONTOUR); // nb de points dans le contour

    for(i=0;i<tsize;i++){
        epurateur.Add_Indice(tsel[i]);
    }

    
    unsigned int *data; int nb;
        // In data we find choisen faces
    data=epurateur.select_face_in(data2,nb2/3,&nb);

        // Construction of  FaceC
        // We must create the checkpoints too
        // The Sp_Load_CircuitC inherit of Journey class. so we have a finish
        // To make a journey, we must build at least two other checkpoints
    Sp_CheckPoint *C1=new Sp_CheckPoint();
    Sp_CheckPoint *C2=new Sp_CheckPoint();
    AddCheckPoint(C1);
    AddCheckPoint(C2);
    
        // if we have "nb" points on shape of circuit,
        // we have "nb-1" faces for each step of circuit
        // We place checkpoint at each third of circuit.
    
    Sp_FaceC *face_cur;
    int nb_faces=nb/3;
    int nb_pts_on_shape=tsize;
    int nb_faces_by_step=(nb_pts_on_shape-1)*2;
    int nb_step=nb_faces/nb_faces_by_step;
    int first_third=(nb_step/3)*nb_faces_by_step;
    int second_third=(2*nb_step/3)*nb_faces_by_step;
    
    for(i=0;i<nb;i+=3){
        face_cur=new Sp_FaceC(&donnees[(data[i]*8)+5],&donnees[(data[i+1]*8)+5],&donnees[(data[i+2]*8)+5]);
            // face belonging to finish
        if((i/3)<nb_faces_by_step){
            face_cur->AttachToCheckPoint(this);
        }
            // face belonging to the first third
        if( ((i/3)>=first_third) && ((i/3)<first_third+nb_faces_by_step) ){
            face_cur->AttachToCheckPoint(C1);
        }
            // face belonging to the second third
        if( ((i/3)>=second_third) && ((i/3)<second_third+nb_faces_by_step) ){
            face_cur->AttachToCheckPoint(C2);
        }
        Add_Face(face_cur);
    }
       

    PreCompute();
}




