#ifndef __FACE_H
#define __FACE_H

class Sp_Entity;
class Sp_EntityMultiplexe;

#include "../../config.h"
#include "sp_obj.h"
#include "sp_box.h"
#include "sp_face.h"






class Sp_Entity: public Sp_EntityBase
{
public:
        /*  --- Les fonctions membres */
    Sp_Entity(Sp_Obj *);
        // Creer et detruire les tableaux
    void Init_Data(int nbpt,int nbnor,int nbtex);
    void Del_Data();
        // la fonction Draw
    virtual void Draw();
        // Le tableau qui contient les points (rem: un pt c est 4 float)
    float *tab_points;
        // Le tableau qui contient les normales ( c est aussi 4 float)
    float *tab_normales;
        // Le tableau  qui contient les coord textures ( c est 2 float)
    float *tab_textures;
};


class Sp_EntityMultiplexe: public Sp_EntityBase
{
public:
        /*  --- Les fonctions membres */
    Sp_EntityMultiplexe(Sp_Obj *);
        // Creer et detruire le tableau
    void Init_Data(int nbpt,GLenum mode);
    void Del_Data();
        // la fonction Draw
    virtual void Draw();
        /*  --- Les donnees pures --- */
        // Le tableau multiplexe (contenant points, normales, textures)
    float *data;
        // Le format ex : GL_T2F_V3F
    GLenum format;
};




/* ------------------------------------------------------ */
/* ----------------- Les classes derivees --------------- */
/* -----------------   pour Sp_Entity     --------------- */
/* ------------------------------------------------------ */

/* ################## Sp_GEntityPoints   ##################### */
/*
  Info: Ensemble de Point
*/
class Sp_GEntityPoints: public Sp_GEntityBase
{
public:
        // Les fonctions membres

        // le constructeur
    Sp_GEntityPoints(int nbpts,Sp_Entity *);
        // La fonction d affichage
    virtual void Draw();

        // Les donnees membres
        // le numero de la Callliste
  
        // le nombre de points
    int nb;
        // la taille du point
    float taille;
        // Il s agit d indices dans les tableaux de Sp_Entity
    int *pt;
        //int *norm;
    float *color;
private:
    Sp_Entity *master;
};



/* ################## Sp_GEntity1   ##################### */
/*
  Info: Point
*/
class Sp_GEntity1: public Sp_GEntityBase
{
public:
        // Les fonctions membres

        // le constructeur
    Sp_GEntity1(Sp_Entity *);
        // La fonction d affichage
    virtual void Draw();

        // Les donnees membres
        // Il s agit d indices dans les tableaux de Sp_Entity
    int pt[1];
    int norm[4];
        // la couleur du point
    float color[4];
private:
    Sp_Entity *master;
};

/* ################## Sp_GEntity4   ##################### */
/*
  Info: face non translucide avec texture a 4 pts
*/
class Sp_GEntity4: public Sp_GEntityBase
{
public:
        // Les fonctions membres

        // le constructeur
    Sp_GEntity4(Sp_Entity *);
        // La fonction d affichage
    virtual void Draw();

        // Les donnees membres
        // Il s agit d indice dans les tableaux de Sp_Entity
    int pt[4];
    int norm[4];
    int tex[4];
        // numero de la texture
    int num_tex;
private:
    Sp_Entity *master;
};


/* ################## Sp_GEntitySphere   ##################### */
/*
  Info: face non translucide avec texture a 4 pts
*/

class Sp_GEntitySphere: public Sp_GEntityBase
{
public:
        // Les fonctions membres

        // le constructeur
    Sp_GEntitySphere(Sp_Entity *,float r);
        // La fonction d affichage
    virtual void Draw();

        // Les donnees membres
        // rayon et precision de la sphere
    float radius;
    int slices;
    int stacks;
        // num de la quadric
    GLUquadricObj  *obj;
        // numero de la texture
    int num_tex;
private:
    Sp_Entity *master;
};


class Sp_GEntityMulti: public Sp_GEntityBase
{
public:
        // Les fonctions membres

        // le constructeur
    Sp_GEntityMulti(Sp_EntityMultiplexe *);
        // La fonction d affichage
    virtual void Draw();
        // compute the bounding box
    void ComputeBox();
    
    
        // Le type ex: GL_TRIANGLES
    GLenum type;
        // Le nombre d elements
    int nb;
        // le tableau des indices
    unsigned int *data;
        // le num de la texture
    int num_tex;
private:
    Sp_EntityMultiplexe *master;
};


#endif



