#ifndef __CMATH_H
#define __CMATH_H

#include <stdio.h>
#include <stdlib.h>
#include "sp_math.h"

/*  LES NOUVELLES CLASSES POUR SPACE RACER 2000  */
/* We adopt the OpenGL convention: */
/* a0  a4  a8  a12  */
/* a1  a5  a9  a13  */
/* a2  a6 a10  a14  */
/* a3  a7 a11  a15  */

class Sp_Mat4;



/** A 4x4 Matrix compatible with the opengl matrix */
class Sp_Mat4
{
  public:
        /**@name The constructors */
        //@{
        /// the null constructor
    Sp_Mat4();
        /// the opengl constructor
    Sp_Mat4(float *t);
        /// A constrcutor define by a repere
    Sp_Mat4(const Sp_Vecteur &i,const Sp_Vecteur &j,const Sp_Vecteur &k,const Sp_Point &O);
        /// copy constructor
    Sp_Mat4(const Sp_Mat4 &);
        //@}
    
        /// the destructor
    virtual ~Sp_Mat4();
    
    
        /// Set this matrix to Identity
    void Id();
        /// the set function
    void Set(float *);
        /// another set function
    void Set(const Sp_Vecteur &i,const Sp_Vecteur &j,const Sp_Vecteur &k,const Sp_Point &O);
        /// the get function
    void Get(float *);
    
        /// Define the matrix to be a translation
    void Trans(float x,float y,float z);
        /// Set the Matrix to be rotation around axe X
    void SetX(float);
        /// Set the Matrix to be rotation around axe Y
    void SetY(float);
        /// Set the Matrix to be rotation around axe Z
    void SetZ(float);
    

        /**@name The operators */
        //@{
        /// the product with another matrix
    Sp_Mat4 operator*(const Sp_Mat4 &) const;
        /// the product with a vector
    Sp_Vecteur operator*(const Sp_Vecteur &)const;
        /// the product with a point
    Sp_Point operator*(const Sp_Point &) const;
        /// the inverse
    Sp_Mat4 Inverse() const;
        /// the copy
    Sp_Mat4 &operator=(const Sp_Mat4 &);
        //@}
    
        /// Print its informations
    void Print() const;
        /// its datas
    float *tab;
};

/**  A quaternion: It is equivalent to a rotation matrix.
     Warning: code not tested */
class Sp_Quat
{
public:
        /// basic constructor
    Sp_Quat();
        /// constrcutor by float
    Sp_Quat(float r1,float x1,float y1,float z1);
        /// Constructor by an axis and an angle
    Sp_Quat(const Sp_Axis &axe,const float angle);
    

        /// Set the quaternion to be null
    void Null();
        /// Set the quaternion to be Identity
    void Id();
        /// Make norme to 1
    void Norme();
        /// Compute Norme
    float ComputeNorme() const;
        /// Give his equivalent matrix
    Sp_Mat4 Mat4() const;
        /// Give his axe & angle
    void ComposedBy(Sp_Axis &,float &angle) const;
    

        /// Inverse
    Sp_Quat Inverse() const;
        /// Multiplication by another quaternion
    Sp_Quat operator*(const Sp_Quat &) const;
    

        /// Print
    void Print();
    
    
private:
        // real part
    float r;
        // complex vector
    float x;
    float y;
    float z;
};


#endif

