#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "sp_mathlin.h"
#include "../util/sp_debug.h"



/*
  There is some code that must run quick. If you do a profile,
  you will see that most cpu is used here. Warning when you make a profile be
  sure that you don't use the FLAG ERROR_CODE or SP_W* macro because their
  presence is only to verify integrity of program

  So there is some optimisation;
  - When we have a constant borne in "for,while", we used an integer size_i to save it.

 But i think that we need to rewrite this module without STL !!! But that s not urgent!

 */




float sqr(float x)
{
  return x*x;
}


/* **********************************************************
*************** To Solve a linear system ******* ************
********************************************************** */



// The constructors
Sp_Vector_lin::Sp_Vector_lin(float a,float b,float c,float d)
{
    v=new float[4];
    size=4;
    v[0]=a; v[1]=b; v[2]=c; v[3]=d;
}


Sp_Vector_lin::Sp_Vector_lin(const Sp_Plan &p)
{
    v=new float[4];
    size=4;
    v[0]=p.A; v[1]=p.B; v[2]=p.C; v[3]=p.D;
}

Sp_Vector_lin::Sp_Vector_lin(const Sp_Vector_lin &a)
{
    v=new float[4];
    size=4;
    v[0]=a.v[0]; v[1]=a.v[1]; v[2]=a.v[2]; v[3]=a.v[3];
}

Sp_Vector_lin::~Sp_Vector_lin()
{
    delete[] v;
}



// Print informations
void Sp_Vector_lin::Print() const
{
    int i;
    printf("vector line:");
    for(i=0;i<Size();i++){
        printf("%d:%f",i,v[i]);
    }
    printf("\n");
}

// The coef v[i] is reduce to 1 and the other coef divide by v[i]
void Sp_Vector_lin::Reduce(int i)
{
    SP_ERROR((v[i]==0),
             "PB in the class Sp_Vector_lin:Reduce");
    float coef=v[i];
    for(int j=0;j<Size();j++){
        v[j]/=coef;
    } 
}


int Sp_Vector_lin::IsCoefNull(int i) const
{
    return (v[i]==0);
}


int Sp_Vector_lin::Size() const
{
    return size;
}














/* ************************ */
/*    The linear system     */
/* ************************ */

//  constructor
Sp_System_lin::Sp_System_lin()
{
    flag=0;
}

// affiche le systeme
void Sp_System_lin::Print() const
{
  printf("Linear System\n");
  for(int i=0;i<NumberOfLines();i++){
      lines[i]->Print();
    }
}

void Sp_System_lin::Add(Sp_Vector_lin *a)
{
  lines.push_back(a);
}

void Sp_System_lin::ExchangeLines(int j,int k)
{
    if(j==k)
        return;
    Sp_Vector_lin *tmp;
    tmp=lines[k];
    lines[k]=lines[j];
    lines[j]=tmp;
}


int Sp_System_lin::FindLine(int col,int lig)
{
  for(int j=lig;j<NumberOfLines();j++)
    {
      if(!lines[j]->IsCoefNull(col))
        return j;
    }
  return -1;
}


// the coord col_i from line_i is set to 0 whith the line lig_j 
void Sp_System_lin::MakeNullCoef(int lig_i,int col_i,int lig_j)
{
    float f;
    f=lines[lig_i]->v[col_i]/lines[lig_j]->v[col_i];
    if(f==0)
        return;
    int size_i=Size();
    for(int i=0;i<size_i;i++){
        lines[lig_i]->v[i]-=f*lines[lig_j]->v[i];
    }
}



int Sp_System_lin::DiagLine(int col,int lig)
{
        // We are searching a line with a coef[col] not nul  
    int j=FindLine(col,lig);
    if(j==-1){
        return -1;
    }
        // Reduce this Line
    lines[j]->Reduce(col);
        // On trouve une ligne on l echange donc
    ExchangeLines(lig,j);
        // On annule les lignes suivantes
    int size_i=NumberOfLines();
    for(int k=0;k<size_i;k++){
        if(k!=lig)
            MakeNullCoef(k,col,lig);
    }
  return 0;
  
}

void Sp_System_lin::Diagonalise()
{
    int i,j;
    i=j=0;
    int size_i=NumberOfLines();
    while(i<size_i){
        if(DiagLine(j,i)!=-1){
            i++;
        }
        j++;
    }
    
}




int Sp_System_lin::Size() const
{
    int tmp;
    tmp=lines[0]->Size();
#ifdef ERROR_CODE
    int i;
    for(i=1;i<NumberOfLines();i++){
        if(tmp!=lines[i]->Size()){
            printf("linear system with line of different size\n");
            exit(0);
        }
    }
#endif
    return tmp;
}

int Sp_System_lin::NumberOfLines() const
{
    return lines.size();
}


int Sp_System_lin::GetSol(float &x,int col)
{
    if(flag==0){
        Diagonalise();
        flag=1;
    }
    int lig=FindLine(col,0);
    if(lig<0)
        return 0;
    x= -(lines[lig]->v[lines[lig]->Size()-1]/lines[lig]->v[col]);
    return 1;
}



/* **********************************************************
***************  Les equations du second degre **************
********************************************************** */

// le constructeur
Sp_Eq2dg::Sp_Eq2dg(float a1,float b1,float c1)
{
  a=a1; b=b1; c=c1;
}

void Sp_Eq2dg::Add(float sol)
{
  solution.push_back(sol);
}

// affiche l equation
void Sp_Eq2dg::Print()
{
    typedef list<float>::iterator iter;
    printf("liste des solutions\n");
    for(iter i=solution.begin();i!=solution.end();i++){
        printf("sol:%f\n",*i);
    }
}

void Sp_Eq2dg::Solution()
{
    if(a==0){
            // cas a == 0 eq du 1er dg
        if(b==0){
            return;
        } else {
            Add(-c/b);
            return;
        }
    } else {
            // a<>0
        float delta;
        delta=b*b-4*a*c;
        if(delta<0){
                // cas imaginaires
            return;
        }
        if(delta==0){
            float s;
            s=-b/(2*a);
            Add(s);
            return;
        }
            // cas 2 sol
        delta=sqrt(delta);
        float s1,s2;
        s1=(-b-delta)/(2*a);
        s2=(-b+delta)/(2*a);
        Add(s1); Add(s2);
        return;
    }
}


/* **********************************************************
***************  Les solutions d intersection  **************
********************************************************** */

Intersection::Intersection(const Sp_Droite &d,const Sp_Sphere &s)
{
    Init(d,s);
    return;
    
    float a,b,c;
  
  a=d.v.x+d.v.y+d.v.z;
  b=2*(d.v.x*(d.p.x-s.xo)+d.v.y*(d.p.y-s.yo)+d.v.z*(d.p.z-s.zo));
  c=sqr(d.p.x-s.xo)+sqr(d.p.y-s.yo)+sqr(d.p.z-s.zo)-sqr(s.r);
 
  Sp_Eq2dg  eq(a,b,c);
  eq.Solution();
  typedef list<float>::iterator iter;
  for(iter i=eq.solution.begin();i!=eq.solution.end();i++)
      {
        Sp_Point *p=new Sp_Point();
        *p=d.p+(d.v*(*i));
        liste_points.push_back(*p);
      }
}

void Intersection::Init(const Sp_Droite &d,const Sp_Sphere &s)
{
    
  float a,b,c;  
  a=sqr(d.v.x)+sqr(d.v.y)+sqr(d.v.z);
  b=2*(d.v.x*(d.p.x-s.xo)+d.v.y*(d.p.y-s.yo)+d.v.z*(d.p.z-s.zo));
  c=sqr(d.p.x-s.xo)+sqr(d.p.y-s.yo)+sqr(d.p.z-s.zo)-sqr(s.r);
 
  Sp_Eq2dg  eq(a,b,c);
  eq.Solution();
  typedef list<float>::iterator iter;
  for(iter i=eq.solution.begin();i!=eq.solution.end();i++)
      {
          Sp_Point p;
          p=d.p+(d.v*(*i));
          liste_points.push_back(p);
      }
}



Intersection::Intersection(const Sp_Plan &p1,const Sp_Plan &p2)
{
  Sp_Vecteur u,v,w;
  u=p1.Normale(); v=p2.Normale(); w=u^v;
      // verif
  if(w.IsNull()){
      return;
  }    
  Sp_Plan plan1(p1),plan2(p2);
  Sp_Point P(0,0,0);
  function1(plan1,plan2,w,P);
}

Intersection::Intersection(const Sp_Plan &p1,const Sp_Plan &p2,const Sp_Point &p)
{
  Sp_Vecteur u,v,w;
  u=p1.Normale(); v=p2.Normale(); w=u^v;
      // verif
  if(w.IsNull()){
      return;
  }    
  Sp_Plan plan1(p1),plan2(p2);
  function1(plan1,plan2,w,p);
}










Intersection::Intersection(const Sp_Droite &d,const Sp_Plan &plan)
{
  float a,b,c;
  a=0; b=(d.v.x*plan.A+d.v.y*plan.B+d.v.z*plan.C); c=plan.D+plan.A*d.p.x+plan.B*d.p.y+plan.C*d.p.z;
  Sp_Eq2dg  eq(a,b,c);
  eq.Solution();
  typedef list<float>::iterator iter;
  for(iter i=eq.solution.begin();i!=eq.solution.end();i++)
    {
      Sp_Point *p1=new Sp_Point();
      *p1=d.p+(d.v*(*i));
      liste_points.push_back(*p1);
    }
}


void Intersection::function1(Sp_Plan &plan1,Sp_Plan &plan2,Sp_Vecteur &v1,const Sp_Point &p)
{
#ifdef ERROR_CODE
    if(v1.IsNull()){
        printf("pb in intersection of 2 plans\n");
        exit(0);
    }
#endif
        // le 1er vecteur
    Sp_Vector_lin adlin(plan1);
        // le 2nd
    Sp_Vector_lin adlin2(plan2);
        // le 3eme vecteur
    float a,b,c,d;
    a=b=c=d=0;
    if(v1.x!=0){
        a=1; d=-p.x;
    } else if (v1.y!=0) {
        b=1; d=-p.y;
    } else {
        c=1; d=-p.z;
    }
    Sp_Vector_lin adlin3(a,b,c,d);
    
        // on cree un systeme et on ajoute les 2 vecteurs
    Sp_System_lin systeme;
    systeme.Add(&adlin);
    systeme.Add(&adlin2);
    systeme.Add(&adlin3);

    float x,y,z;
    if(systeme.GetSol(x,0)&&systeme.GetSol(y,1)&&systeme.GetSol(z,2)){
        Sp_Point p_sol(x,y,z);
            // on a une solution
        Sp_Droite dr(p_sol,v1);
        liste_droites.push_back(dr);
    }
}

