#ifndef SP_MATH_H
#define SP_MATH_H

/* This file is documented with doc++
 To generate the doc: doc++ -d html *.h
 this documentation system use the java doc method
*/


#define SP_PI 3.1415926535

#include <stdio.h>
#include <stdlib.h>
#include <list>
#include <math.h>
using namespace std;


class Sp_Vecteur;
class Sp_Point;
class Sp_Droite;
class Sp_Plan;
class Sp_Sphere;

/** The vector class.
    It defines vector with 3 or 4 coordinates (x,y,z,w).
 */
class Sp_Vecteur
{
  public:
        /**@name The constructors */
        //@{
        /// the null constructor
    Sp_Vecteur();
        /// a 3 coordinates constructor
    Sp_Vecteur(float x1,float y1,float z1);
        /// a 4 corrdinates costructor
    Sp_Vecteur(float x1,float y1,float z1,float w1);
        /// the copy constructor
    Sp_Vecteur(const Sp_Vecteur &);
        //@}
    
        /**@name Operators */
        //@{
        /// the operator =
    Sp_Vecteur &operator=(const Sp_Vecteur &);
        /// the + operator
    Sp_Vecteur operator+(const Sp_Vecteur &) const;
        /// the - operator
    Sp_Vecteur operator-(const Sp_Vecteur &) const;
        /// the plus operator
    Sp_Vecteur operator+() const;    
        /// the minus operator
    Sp_Vecteur operator-() const;
        /// the dot product
    float      operator*(const Sp_Vecteur &) const;
        ///we * the coordinates by a 
    Sp_Vecteur operator*(const float &a) const;
        /// the cross product apply only the coordinates x,y,z 
    Sp_Vecteur operator^(const Sp_Vecteur &) const;
        //@}
    
        /// make the norme of vector equal to 1
    void Norme();
        /// compute the norme of a vector
    float Compute_norme() const;
        /// Is this vector Null
    int IsNull() const;
        /// print information about this vecteur
    void Print() const;

        // the data members
        /// the coordinate x
    float x;
        /// the coordinate y
    float y;
        /// the coordinate z
    float z;
        /// the coordinate w
    float w;
};


/** The point class
    It defines a point with 3 or 4 coordinates
 */
class Sp_Point
{
  public:

        /**@name The constructors */
        //@{
        /// the null constructor
    Sp_Point();
        /// a 3 coordinates constructor
    Sp_Point(float x1,float y1,float z1);
        /// a 4 coordinates costructor
    Sp_Point(float x1,float y1,float z1,float w1);
        /// a copy constructor
    Sp_Point(const Sp_Point &);
        //@}

        /**@name operators */
        //@{
        /// the operator =
    Sp_Point &operator=(const Sp_Point &);
        /// the + operator
    Sp_Point operator+(const Sp_Vecteur &) const;
        /// the - operator
    Sp_Point operator-(const Sp_Vecteur &) const;
    Sp_Vecteur operator-(const Sp_Point &) const;
        /// the == operator
    inline    int operator==(const Sp_Point &p) const 
    {
        if(x!=p.x)
        return 0;
        else
        if(y!=p.y)
        return 0;
        else
        if(z!=p.z)
        return 0;
        return 1;
    }
        //@}
    
        /// Compute the distance beetween two points
    float Distance(const Sp_Point &) const;
        /// Is this point in front of P ?
    int IsAheadOf(const Sp_Point &P,const Sp_Vecteur &direction) const;
        /// Print information about this point 
    void Print() const;
  
        // the data members
            /// the coordinate x
    float x;
        /// the coordinate y
    float y;
        /// the coordinate z
    float z;
        /// the coordinate w
    float w;
};



/** The straight line class
 */
class Sp_Droite
{
  public:
        /**@name The constructors */
        //@{
        /// We constructs it with a point and a direction
    Sp_Droite(Sp_Point &p,Sp_Vecteur &v);
        /// we constructs it with two points
    Sp_Droite(Sp_Point &p0,Sp_Point &p1);
        //@}
    
        /// Print its information
    void Print() const;
        /// Test if the point is belonging to the straight
    int IsIn(const Sp_Point &P1) const;

// the data members
        ///  its Point
    Sp_Point p;
        /// its direction
    Sp_Vecteur v;
};



/** The Segment class
 */
class Sp_Segment
{
  public:

        /**@name The constructors */
        //@{
        /// null constructor
    Sp_Segment() {};
        /// constructor with pointers
    Sp_Segment(Sp_Point *,Sp_Point *);
        /// constructor with references
    Sp_Segment(Sp_Point &,Sp_Point &);
        //@}

        
        /** Test if the point is belonging to the segment
            !!! Warning to float precision !!! 
            use rather the IsBetween function */
    int IsIn(const Sp_Point &P1) const;
        
    
        /// Test if the point is between
    int IsBetween(const Sp_Point &P1) const;
        /// Compute Intersection between two segments
    int intersection(const Sp_Segment &seg,const Sp_Vecteur &normale,Sp_Point &) const;
        /// write information
    void Print() const;
        ///  Test if the two points are on the same side 
    float SameSide(const Sp_Point &p1,const Sp_Point &p2,const Sp_Vecteur &normale)const;
  
        // member data
        /// A pointer on the first point
    Sp_Point *p1;
        /// A pointer on the second point
    Sp_Point *p2;
};


/** The Axis class constituted by a Point and a normed vector 
 */
class Sp_Axis
{
public:
/**@name The constructors */
        //@{
        /// Default constructor
    Sp_Axis(const Sp_Point &,const Sp_Vecteur &);
        /// Copy constructor
    Sp_Axis(const Sp_Axis &);
        //@}

/**@name Get and Set functions */
        //@{
        /// Get a point of this axis
    Sp_Point getPoint() const;
        /// Get a normed vector with the direction of this axis
    Sp_Vecteur getDirection()const;    
        //@}

        /// Turn a vector around this axis
    Sp_Vecteur TurnAround(const Sp_Vecteur &,float angle) const;
        /// Turn a point around this axis
    Sp_Point TurnAround(const Sp_Point &,float angle) const;
    
    
// members datas
private:
        /// A Point which belong to the axis
    Sp_Point p;
        /// The direction
    Sp_Vecteur v;
};





/** The Plan class
    Optimisation: A plan is builded with a normale normalized
 */
class Sp_Plan
{
  public:
        /**@name The constructors */
        //@{
        /// null constructor
    Sp_Plan() {};
        /// unusefull constructor
    Sp_Plan(float a,float b,float c,float d);
        /// copy constructor
    Sp_Plan(const Sp_Plan &p);
        /// pt is a point belonging to the plan and norm a normale for the plan 
    Sp_Plan(const Sp_Point &pt,const Sp_Vecteur &norm);
        /// p1 & p2 & v0 belonging to the plan 
    Sp_Plan(const Sp_Point &p1,const Sp_Point &p2,const Sp_Vecteur &v0);
        //@}
    
// the functions
        /// Give the normale normalized of the plan
    Sp_Vecteur Normale() const;
        /// Give the face of the point
    float Sign(const Sp_Point &) const;
        /// Project a point on a surface
    Sp_Point Project(const Sp_Point &) const;
        /// Project a point on this plan with this direction
    Sp_Point Project(const Sp_Point &,const Sp_Vecteur &) const;    
        /// Project a vector on a surface
    Sp_Vecteur Project(const Sp_Vecteur &i1) const; 
        /// Compute the distance between a point and the plan
    float Distance(const Sp_Point &p) const;
        /// Print information
    void Print() const;
    
        // data
public:
    float A;
    float B;
    float C;
    float D;
};


/** The Sphere class
 */
class Sp_Sphere
{
  public:
        /**@name The constructors */
        //@{
        /// basic constructor
    Sp_Sphere(float xo,float yo,float zo,float r);
        /// easier constructor
    Sp_Sphere(Sp_Point &p,float r);
        //@}
    
        /// Information about it
    void Print() const;
    
        // les donnees
    float xo,yo,zo,r;
};




// Some functions

// project a point B on a vector AC (defines by two points)
Sp_Point Project(const Sp_Point &B,const Sp_Point &A,const Sp_Point &C);

Sp_Point Middle(const Sp_Point &A,const Sp_Point &B);


#endif
