#include "sp_math.h"
#include "../util/sp_debug.h"
#include "sp_mathlin.h"
#include "sp_matrice.h"



int IsEqual(float a,float b)
{
    if(a!=0)
    {
        if( fabs((a-b)/a) < 00.1 )
        {return 1; }
        else
        {return 0; }
    }
    else if(b!=0)
    {
        if( fabs((a-b)/b) < 00.1 )
            return 1;
        else
            return 0;
    }
    else
    {
        return 1;
    }
}


/* ************************ Sp_Vecteur *************************** */



Sp_Vecteur::Sp_Vecteur()
{
        // par securite
    x=y=z=w=0;
}

Sp_Vecteur::Sp_Vecteur(float x1,float y1,float z1)
{
    x=x1; y=y1; z=z1; w=0;
}

Sp_Vecteur::Sp_Vecteur(float x1,float y1,float z1,float w1)
{
    x=x1; y=y1; z=z1; w=w1;
}

Sp_Vecteur::Sp_Vecteur(const Sp_Vecteur &v)
{
    x=v.x; y=v.y; z=v.z; w=v.w;
}


Sp_Vecteur &Sp_Vecteur::operator=(const Sp_Vecteur &v)
{
    x=v.x; y=v.y; z=v.z; w=v.w;
    return *this;
}


Sp_Vecteur Sp_Vecteur::operator+(const Sp_Vecteur &a) const
{
    Sp_Vecteur r;
    r.x=x+a.x;
    r.y=y+a.y;
    r.z=z+a.z;
    r.w=w+a.w;
    return r;
}

Sp_Vecteur Sp_Vecteur::operator-(const Sp_Vecteur &a) const
{
    Sp_Vecteur r;
    r.x=x-a.x;
    r.y=y-a.y;
    r.z=z-a.z;
    r.w=w-a.w;
    return r;
}

Sp_Vecteur Sp_Vecteur::operator-() const
{
    return Sp_Vecteur(-x,-y,-z,-w);
}

Sp_Vecteur Sp_Vecteur::operator+() const
{
    return Sp_Vecteur(x,y,z,w);
}

float      Sp_Vecteur::operator*(const Sp_Vecteur &a) const
{
    return x*a.x+y*a.y+z*a.z+w*a.w;
}

Sp_Vecteur Sp_Vecteur::operator*(const float &c) const
{
    Sp_Vecteur r;
    r.x=x*c; r.y=y*c; r.z=z*c; r.w=w*c;
    return r;
}


Sp_Vecteur Sp_Vecteur::operator^(const Sp_Vecteur &v) const
{
    Sp_Vecteur r;
    r.x=y*v.z-z*v.y; 
    r.y=z*v.x-x*v.z; 
    r.z=x*v.y-y*v.x; 
    return r;
}

void Sp_Vecteur::Norme()
{
    float norme;
    norme=sqrt(x*x+y*y+z*z);
    SP_ERROR(norme==0,"it is not a good idea to norme a null vector\n");
    x/=norme; y/=norme; z/=norme;
}

float Sp_Vecteur::Compute_norme() const
{
    return sqrt(x*x+y*y+z*z);
}


int Sp_Vecteur::IsNull() const
{
    if((x==0)&&(y==0)&&(z==0))
        return 1;
    return 0;
}


void Sp_Vecteur::Print() const
{
    printf("x:%f y:%f z:%f w:%f\n",x,y,z,w);
}

/* ************************ Sp_Point ***************************** */

Sp_Point::Sp_Point()
{}

Sp_Point::Sp_Point(float x1,float y1,float z1)
{
    x=x1; y=y1; z=z1; w=0;
}

Sp_Point::Sp_Point(float x1,float y1,float z1,float w1)
{
    x=x1; y=y1; z=z1; w=w1;
}


Sp_Point::Sp_Point(const Sp_Point &p)
{
    x=p.x; y=p.y; z=p.z; w=p.w;
}



Sp_Point &Sp_Point::operator=(const Sp_Point &v)
{
    this->x=v.x; this->y=v.y; this->z=v.z; this->w=v.w;
    return *this;
}


Sp_Point Sp_Point::operator+(const Sp_Vecteur &v) const
{
    Sp_Point r;
    r.x=x+v.x; r.y=y+v.y;
    r.z=z+v.z; r.w=w+v.w;
    return r;
}

Sp_Point Sp_Point::operator-(const Sp_Vecteur &v) const
{
    Sp_Point r;
    r.x=x-v.x; r.y=y-v.y;
    r.z=z-v.z; r.w=w-v.w;
    return r;
}

Sp_Vecteur Sp_Point::operator-(const Sp_Point &p) const 
{
    Sp_Vecteur v;
    v.x=x-p.x; v.y=y-p.y;
    v.z=z-p.z; v.w=w-p.w;
    return v;
}


float Sp_Point::Distance(const Sp_Point &point) const
{
    Sp_Point tmp;
    Sp_Vecteur tmp2;
    tmp.x=this->x;tmp.y=this->y;tmp.z=this->z;
    tmp2=tmp-point;
    return tmp2.Compute_norme();
}

int Sp_Point::IsAheadOf(const Sp_Point &p,const Sp_Vecteur &direction) const
{
    Sp_Vecteur v;
    v=*this-p;
    if(v*direction>=0){
        return 1;
    }else {
        return 0;
    }
}

    
    


void Sp_Point::Print() const
{
    printf("x:%f y:%f z:%f w:%f\n",x,y,z,w);
}











Sp_Droite::Sp_Droite(Sp_Point &p0,Sp_Vecteur &v0)
{
    p.x=p0.x;p.y=p0.y;p.z=p0.z;p.w=p0.w; 
    v.x=v0.x;v.y=v0.y;v.z=v0.z;v.w=v0.w;
}

Sp_Droite::Sp_Droite(Sp_Point &p0,Sp_Point &p1)
{
    p.x=p0.x;p.y=p0.y;p.z=p0.z;p.w=p0.w;
    Sp_Vecteur v0=p0-p1;
    v0.Norme();
    v.x=v0.x;v.y=v0.y;v.z=v0.z;v.w=v0.w;
}

void Sp_Droite::Print() const 
{
    printf("une droite: un point et un vecteur\n");
    p.Print();
    v.Print();
}

int Sp_Droite::IsIn(const Sp_Point &P1) const
{
        // lambda 
    float lx,ly,lz;
        // Is lambda existing ?
    int   fx,fy,fz;
        // coord X
    if(v.x!=0)
    {
        fx=1;
        lx=(P1.x-p.x)/v.x;
    }
    else
    {
        lx=0;
        fx=0;
    }
        // coord Y
    if(v.y!=0)
    {
        fy=1;
        ly=(P1.y-p.y)/v.y;
    }
    else
    {
        ly=0;
        fy=0;
    }
        // coord Z
    if(v.z!=0)
    {
        fz=1;
        lz=(P1.z-p.z)/v.z;
    }
    else
    {
        lz=0;
        fz=0;
    }
        // we are testing if l? are equal
    if((fx!=0)&&(fy!=0))
    {
        if(IsEqual(lx,ly)==0)
            return 0;
    }
    if((fy!=0)&&(fz!=0))
    {
        if(IsEqual(ly,lz)==0)
            return 0;
    }
    if((fx!=0)&&(fz!=0))
    {
        if(IsEqual(lx,lz)==0)
            return 0;
    }
    SP_ERROR((fx==0)&&(fy==0)&&(fz==0),
             "Problem the director vector of a straight line is null");
    return 1;
}


Sp_Segment::Sp_Segment(Sp_Point *pp0,Sp_Point *pp1)
{
    SP_ERROR((pp0->x==pp1->x) && (pp0->y==pp1->y) && (pp0->z==pp1->z),
             "ceci n est pas un segment: on a deux points identiques");
    p1=pp0;
    p2=pp1;
}
Sp_Segment::Sp_Segment(Sp_Point &pp0,Sp_Point &pp1)
{
    SP_ERROR((pp0.x==pp1.x) && (pp0.y==pp1.y) && (pp0.z==pp1.z),
             "ceci n est pas un segment: on a deux points identiques");
    p1=&pp0;
    p2=&pp1;
}


int Sp_Segment::IsBetween(const Sp_Point &P1) const
{
    Sp_Point &A=*p1;
    Sp_Point &B=*p2;
    Sp_Vecteur AB=B-A;
    Sp_Vecteur AP1=P1-A;
    Sp_Vecteur P1B=B-P1;
    if(AP1.IsNull()!=0)
        return 1;
    if(P1B.IsNull()!=0)
        return 1;
    AB.Norme(); AP1.Norme(); P1B.Norme();
    float c1,c2;
    c1=AB*AP1;
    c2=AB*P1B;
    if((c1>=0)&&(c2>=0))
        return 1;
    else
        return 0;
}



int Sp_Segment::IsIn(const Sp_Point &P1) const
{
    Sp_Point &A=*p1;
    Sp_Point &B=*p2;
    
    Sp_Vecteur AB=B-A;
    Sp_Vecteur AP1=P1-A;
    Sp_Vecteur P1B=B-P1;
    if(AP1.IsNull()!=0)
        return 1;
    if(P1B.IsNull()!=0)
        return 1;
    AB.Norme(); AP1.Norme(); P1B.Norme();
    float c1,c2;
    c1=AB*AP1;
    c2=AB*P1B;
        //printf("c1:%f c2:%f\n",c1,c2);
    if((c1>=0.99)&&(c1<1.001))
    {
        if((c2>=0.99)&&(c2<1.001))
            return 1;
    }
    return 0;
}

int Sp_Segment::intersection(const Sp_Segment &seg,const Sp_Vecteur &normale,Sp_Point &resultat) const
{
    
        // we are computing the intersection of two segments
        // we are creating a plane
    Sp_Point PP1(*p1);
    Sp_Point PP2(*p2);
    Sp_Plan plan(PP1,PP2,normale);
    Sp_Droite droite(*seg.p1,*seg.p2);
    Intersection inter(droite,plan);
        // we are testing if we have an intersection
    if(inter.liste_points.size()==0)
        return 0;
        // we are testing if the result is belonging to the segment
    typedef list<Sp_Point>::iterator iter;
    iter i=inter.liste_points.begin();
    Sp_Point result=(*i);
    if((IsBetween(result)!=0)&&(seg.IsBetween(result)!=0)){
        resultat=result;
        return 1;
    }

    return 0;
}


// Are the points in the same side from plane
// yes if dot >= 0 else no
float Sp_Segment::SameSide(const Sp_Point &P1,const Sp_Point &P2,const Sp_Vecteur &normale) const
{
    Sp_Plan p(*p1,*p2,normale);
    return p.Sign(P1)*p.Sign(P2);
}


void Sp_Segment::Print() const
{
    printf("un segement\n");
    p1->Print();
    p2->Print();
}







/* ************************ Sp_Axis ***************************** */


Sp_Axis::Sp_Axis(const Sp_Point &P,const Sp_Vecteur &V)
        :p(P),v(V)
{
    v.Norme();
}


Sp_Axis::Sp_Axis(const Sp_Axis &axe)
        :p(axe.p),v(axe.v)
{
    SP_ERROR((v.Compute_norme()!=1),"The directional vector of this axis must be normed");
}


Sp_Point Sp_Axis::getPoint() const
{
    return p;
}


Sp_Vecteur Sp_Axis::getDirection() const
{
    return v;
}

Sp_Vecteur Sp_Axis::TurnAround(const Sp_Vecteur &K,float angle) const
{
    Sp_Vecteur    j(K^v);
        // If V is // to K
    if(j.IsNull()){
        return Sp_Vecteur(K);
    }
        // We need normalized vector
    j.Norme();
        //Compute the last vector
    Sp_Vecteur k(K/*v^j*/);

        // the rotation matrix
    Sp_Mat4 rot;
    rot.SetX(angle);

        // repere
    Sp_Mat4 tmp(v,j,k,p);
    Sp_Mat4 tmp_1=tmp.Inverse();
    
    tmp=tmp*rot*tmp_1;
    return tmp*K;    
}

Sp_Point Sp_Axis::TurnAround(const Sp_Point &V,float angle) const
{
    Sp_Vecteur    K(V-p);
    Sp_Vecteur    j(K^v);
        // If V is // to K
    if(j.IsNull()){
        return V;
    }
        // We need normalized vector
    j.Norme();
        //Compute the last vector
    Sp_Vecteur k(v^j);

        // the rotation matrix
    Sp_Mat4 rot;
    rot.SetX(angle);

        // repere
    Sp_Mat4 tmp(v,j,k,p);
    Sp_Mat4 tmp_1=tmp.Inverse();
    
    tmp=tmp*rot*tmp_1;
    return tmp*V;     
}


/* ************************************************************** */
/* ************************ Sp_Plan ***************************** */
/* ************************************************************** */

Sp_Plan::Sp_Plan(float a,float b,float c,float d)
{
    float norme=sqrt(a*a+b*b+c*c);
    SP_ERROR(norme==0,"A plan cannot have a null normal\n");
    A=a/norme; B=b/norme;
    C=c/norme; D=d/norme;
}

Sp_Plan::Sp_Plan(const Sp_Plan &p)
{
    A=p.A; B=p.B;
    C=p.C; D=p.D;
}

Sp_Plan::Sp_Plan(const Sp_Point &pt,const Sp_Vecteur &normale)
{
    float norme;
    norme=sqrt((normale.x*normale.x)+(normale.y*normale.y)+(normale.z*normale.z));
    SP_ERROR(norme==0,"A plan cannot have a null normal\n");
    A=normale.x/norme;
    B=normale.y/norme;
    C=normale.z/norme;
    D=-(A*pt.x)-(B*pt.y)-(C*pt.z);
}

Sp_Plan::Sp_Plan(const Sp_Point &pt,const Sp_Point &p2,const Sp_Vecteur &v0)
{

    Sp_Vecteur v1=p2-pt;
    Sp_Vecteur normale=v0^v1;
    float norme;
    norme=sqrt((normale.x*normale.x)+(normale.y*normale.y)+(normale.z*normale.z));
    SP_ERROR(norme==0,"A plan cannot have a null normal\n");
    A=normale.x/norme;
    B=normale.y/norme;
    C=normale.z/norme;
    D=-(A*pt.x)-(B*pt.y)-(C*pt.z);  
}

Sp_Vecteur Sp_Plan::Normale() const
{
    SP_ERROR((A==0)&&(B==0)&&(C==0),"Plan is defined with a normal null vector");
    Sp_Vecteur v;
    v.x=A; v.y=B; v.z=C; v.w=0;
    return v;
}

float Sp_Plan::Sign(const Sp_Point &p) const
{
    return A*p.x+B*p.y+C*p.z+D;
}

// Project a point on the plan
Sp_Point Sp_Plan::Project(const Sp_Point &p) const
{
    float K=Sign(p);
    Sp_Point P=p-(Normale()*K);
    return P;
}

// Project a point on the plan with direction dir
Sp_Point Sp_Plan::Project(const Sp_Point &p,const Sp_Vecteur &dir) const
{
    float scalaire=dir*Normale();
    float K=Sign(p)/scalaire;
    Sp_Point P=p-(dir*K);
    return P;
}



Sp_Vecteur Sp_Plan::Project(const Sp_Vecteur &i1) const
{
    Sp_Vecteur normale=Normale();
    normale.x=A;normale.y=B;normale.z=C;
    Sp_Vecteur k1=i1^Normale();
    return Normale()^k1;
    
}

float Sp_Plan::Distance(const Sp_Point &p) const
{
    float lambda;
    float K=Sign(p);
    lambda=fabs(K/(A*A+B*B+C*C));
    return lambda*Normale().Compute_norme();
}


void Sp_Plan::Print() const
{
    printf("un plan\n");
    printf("A:%f B:%f C:%f D:%f\n",A,B,C,D);
}



















Sp_Sphere::Sp_Sphere(float x,float y,float z,float r0)
{
    xo=x; yo=y; zo=z; r=r0;
}

Sp_Sphere::Sp_Sphere(Sp_Point &p,float r0)
{
    xo=p.x; yo=p.y; zo=p.z; r=r0;
}

void Sp_Sphere::Print() const
{
    printf("Sphere: xo:%f yo:%f zo:%f r:%f \n",xo,yo,zo,r);
}





Sp_Point Project(const Sp_Point &B,const Sp_Point &A,const Sp_Point &C)
{
    Sp_Point result;
    Sp_Vecteur AB,AC;
    AB=B-A;
    AC=C-A;
    float scal;
    scal=AB*AC;
    float AC2=AC.Compute_norme();
    AC2*=AC2;
    result=A+(AC*(scal/AC2));
    return result;
}


Sp_Point Middle(const Sp_Point &A,const Sp_Point &B)
{
    Sp_Point result;
    result.x=(A.x+B.x)/2;
    result.y=(A.y+B.y)/2;
    result.z=(A.z+B.z)/2;
    return result;
}







