#include "PPMImage.h"
#include <stdio.h>
#include <errno.h>
#include <string.h>

PPMImage::PPMImage(char *filename)
{
  FILE * imfile;

  imfile = fopen(filename,"r");
  if(!imfile){
    perror("PPMImage::PPMImage(char*) :");
    cp_data=NULL;
    i_width=0;
    i_height=0;
    i_format=-1;
    return;
  }
  
  char buf[100];
  int notdone=1;

  while(notdone){ 
    fgets(buf,100,imfile);
    if(buf[0]=='#')
	continue;
    switch(notdone){
    case 1:  //Image Type
      if(strncmp(buf,"P6",2)){
	fprintf(stderr,"PPMImage: wrong Image Type!\n");
	return;
      }
      else notdone++;
      break;
    case 2:   //Image size
      sscanf(buf,"%d %d",&i_width,&i_height);
      notdone++;
      break;
    case 3:   //entries per channel  (not used)
      notdone=0;
      break;
    case 4:   //finally the image
      notdone=0;
      break;
    }
  }
    
  cp_data=new unsigned char[i_width*i_height*3];
  fread(cp_data,i_width*i_height*3,1,imfile);
  fclose(imfile);
}
