/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyVersionMap
implements DependencyNodeVisitor {
    private boolean demandReleasedVersions = false;
    private Map<String, List<DependencyNode>> idsToNode = new HashMap<String, List<DependencyNode>>();
    private List<DependencyNode> snapshots = new ArrayList<DependencyNode>();

    public DependencyVersionMap(Log log) {
    }

    public DependencyVersionMap(boolean demandReleasedVersions, Log log) {
        this(log);
        this.demandReleasedVersions = demandReleasedVersions;
    }

    public boolean visit(DependencyNode node) {
        this.addDependency(node);
        if (this.containsConflicts(node)) {
            return false;
        }
        if (this.demandReleasedVersions && node.getArtifact().isSnapshot()) {
            this.snapshots.add(node);
            return false;
        }
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        return true;
    }

    private String constructKey(DependencyNode node) {
        return this.constructKey(node.getArtifact());
    }

    private String constructKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public void addDependency(DependencyNode node) {
        List<DependencyNode> nodes;
        String key = this.constructKey(node);
        if (node.getArtifact().isSnapshot()) {
            this.snapshots.add(node);
        }
        if ((nodes = this.idsToNode.get(key)) == null) {
            nodes = new ArrayList<DependencyNode>();
            this.idsToNode.put(key, nodes);
        }
        nodes.add(node);
    }

    public List<DependencyNode> getSnapshots() {
        return this.snapshots;
    }

    private boolean containsConflicts(DependencyNode node) {
        return this.containsConflicts(node.getArtifact());
    }

    private boolean containsConflicts(Artifact artifact) {
        return this.containsConflicts(this.idsToNode.get(this.constructKey(artifact)));
    }

    private boolean containsConflicts(List<DependencyNode> nodes) {
        String version = null;
        for (DependencyNode node : nodes) {
            if (version == null) {
                version = node.getArtifact().getVersion();
                continue;
            }
            if (version.compareTo(node.getArtifact().getVersion()) == 0) continue;
            return true;
        }
        return false;
    }

    public List<List<DependencyNode>> getConflictedVersionNumbers() {
        ArrayList<List<DependencyNode>> output = new ArrayList<List<DependencyNode>>();
        for (List<DependencyNode> nodes : this.idsToNode.values()) {
            if (!this.containsConflicts(nodes)) continue;
            output.add(nodes);
        }
        return output;
    }
}

