/* # skkinput (Simple Kana-Kanji Input)
 * OverWin.c --- Making OverTheSpotWinWidget.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "OverWinP.h"
#include "config.h"
#include "skkkey.h"
#include "skkel.h"
#include "Canvas.h"
#include "WmcloseShell.h"
#include "MyError.h"
#include "draw.h"
#include "MyDispatch.h"

#ifndef XtNgeometry
#define XtNgeometry		"geometry"
#define XtCGeometry		"Geometry"
#endif

#define offset(field) XtOffsetOf (OverthespotWinRec, overthespotWin.field)
#define goffset(field) XtOffsetOf (WidgetRec, core.field)

static XtResource OTSW_resources[] = {
  /* Ȥ餢꥽*/
  { XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
    goffset(width), XtRImmediate, (XtPointer) 400},
  { XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
    goffset(height), XtRImmediate, (XtPointer) 400},
  /* ߥ˥Хåե礭ꤹġǥեȤΤ͡١ꥵ *
   * Ф褦ˤ褦 */
  { XtNmwidth, XtCMwidth, XtRDimension, sizeof(Dimension),
    offset(minibuf_width), XtRImmediate, (XtPointer)640 },
  /* ʬȤǺä꥽*/
  { XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
    offset(puppixel), XtRString, XtDefaultForeground },
  /* Minibuffer ȿžɽ뤫ɤȤäˤʤ롣*/
  { XtNreverseVideo, XtCReverseVideo, XtRBoolean, sizeof (Boolean),
    offset(reverse_video), XtRImmediate, (XtPointer) FALSE},
  /* Overthespot Ѥեȵڤӥ޻եȡ*/
  { XtNfontset, XtCFontset,  XtRString, sizeof (String),
    offset(fontset_string), XtRImmediate, (XtPointer)DEFAULT_FONTSET },
  /* Minibuffer Window 褹ΤѤڤӥ޻եȡ*/
  { XtNmfontset, XtCFontset,  XtRString, sizeof (String),
    offset(minibuf_fontset_string), XtRImmediate, DEFAULT_FONTSET },
  /* Minibuffer Window 礭եȤν˺뤫ɤ*/
  { XtNchangeMinibufferFont, XtCChangeMinibufferFont,
    XtRBoolean, sizeof (Boolean),
    offset(change_minibuffer_font), XtRImmediate, (XtPointer)TRUE },
  /* skkinput 뤬ĤѤ callback */
  { XtNendNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(endcallback), XtRCallback, (caddr_t)NULL },
  /* skkinput  client ʸѤ callback */
  { XtNfixNotify, XtCCallback, XtRCallback, sizeof (caddr_t), 
    offset(fixcallback), XtRCallback, (caddr_t)NULL },
  /* key event  client ֤Ѥ callback */
  { XtNkeybackNotify, XtCCallback, XtRCallback, sizeof (caddr_t), 
    offset(keybackcallback), XtRCallback, (caddr_t)NULL },
  { XtNtextNotify,	XtCCallback, XtRCallback, sizeof (XtCallbackList),
	offset (m_lstTextCallback),	XtRCallback, (caddr_t) NULL },
  /* egg ߴ j-newline ݤ*/
  { XtNeggLikeNewline, XtCEggLikeNewline, XtRImmediate, sizeof (Boolean),
    XtOffsetOf (OverthespotWinRec, overthespotWin.buffer.egg_like_newline),
    XtRImmediate, (XtPointer) FALSE},
  /* chat-adapter-mode ݤ*/
  { XtNchatAdapter, XtCChatAdapter, XtRImmediate, sizeof (Boolean),
    XtOffsetOf (OverthespotWinRec, overthespotWin.buffer.chat_adapter),
    XtRImmediate, (XtPointer) FALSE},
  { XtNjisyoDirty, XtCJisyoDirty, XtRImmediate, sizeof (Boolean),
    XtOffsetOf (OverthespotWinRec, overthespotWin.buffer.jisyo_dirty),
    XtRImmediate, (XtPointer) FALSE },
  /* Ѵ°λꡣ*/
  { XtNconversionAttribute, XtCConversionAttribute, XtRImmediate, 
    sizeof (struct ConvAttrsMesg *),
    offset (camsg), XtRImmediate,  (XtPointer)NULL },
  /* ߥ˥Хåեξõ롣*/
  { XtNclearMinibuffer, XtCClearMinibuffer, XtRImmediate, sizeof (Boolean),
    offset (clearMinibuffer), XtRImmediate, (XtPointer)FALSE },
  {	XtNinput,	XtCInput,	XtRBoolean,		sizeof (Boolean),
    offset (m_fInputFocus),	XtRImmediate,  (XtPointer)TRUE },
  /* ¦ɽġ*/
  { XtNsouthCursor, XtCSouthCursor, XtRBoolean, sizeof (Boolean),
    offset (south_cursor), XtRImmediate,  (XtPointer)FALSE },
  { XtNclientWindow, XtCClientWindow, XtRImmediate, sizeof (Window),
    offset (client_window), XtRImmediate, (XtPointer)None },
  { XtNsetFocus, XtCSetFocus, XtRImmediate, sizeof (int),
    offset (conversion_set_focus), XtRImmediate, (XtPointer)FALSE },
  { XtNunsetFocus, XtCUnsetFocus, XtRImmediate, sizeof (int),
    offset (conversion_unset_focus), XtRImmediate, (XtPointer)FALSE  },
  /* Subwindow ե֤ɥꤹ롣*/
  { XtNprobeWindow, XtCProbeWindow, XtRImmediate, sizeof (Window),
    offset (probe_window), XtRImmediate,  (XtPointer)None },
  /* history νѤؿ*/
  { XtNconversionHistory, XtCConversionHistory, XtRImmediate,
    sizeof (HistoryListNode *), offset (historyAttribute),
    XtRImmediate,  (XtPointer)NULL },
  { XtNoverTheSpotLikeInput, XtCOverTheSpotLikeInput, XtRBoolean,
    sizeof (Boolean), offset (overthespotLikeInput),
    XtRImmediate,  (XtPointer)TRUE },
  { XtNshiftHaTugiDeYukou, XtCShiftHaTugiDeYukou, XtRBoolean,
    sizeof (Boolean), 
    XtOffsetOf (OverthespotWinRec, overthespotWin.buffer.toggleShiftMode),
    XtRImmediate,  (XtPointer)FALSE },
  { XtNcontrolHaTugiDeYukou, XtCControlHaTugiDeYukou, XtRBoolean,
    sizeof (Boolean), 
    XtOffsetOf (OverthespotWinRec, overthespotWin.buffer.toggleControlMode),
    XtRImmediate,  (XtPointer)FALSE },
  { XtNmodeshell_geometry, XtCModeShell_Geometry, XtRString,
    sizeof (String),
    XtOffsetOf (OverthespotWinRec, overthespotWin.modeshell_geometry),
    XtRImmediate, (XtPointer)DEFAULT_MODELINE_GEOMETRY},
} ;

#undef offset
#undef goffset

/*
 * ץȥ
 */
/*
 * ΥåȤƤǤȤʤؿ
 */
static void OTSW_Initialize
 (Widget greq, Widget gnew, ArgList args, Cardinal *num_args) ;
static void OTSW_Realize
 (Widget gw, XtValueMask *valueMask, XSetWindowAttributes *attrs) ;
static void OTSW_Redisplay
 (Widget gw, XEvent *event, Region region) ;
static void OTSW_Destroy (Widget gw) ;
static Boolean OTSW_SetValues
 (Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args) ;
static void KeyDownEventHandler
 (Widget w, XEvent *event, String *params, Cardinal *num_params) ;
static void FocusEventHandler
 (Widget gw, XEvent *xevent, String *params, Cardinal *num_params) ;

static void OTSW_CreateAllGCs (Widget gw) ;
static void OTSW_CreateMinibufferGCs (Widget gw) ;
static void OTSW_ReleaseAllGCs (Widget gw) ;
static void OTSW_ReleaseMinibufferGCs (Widget gw) ;

static int OTSW_ChangeAttributes
 (Widget gw, unsigned long valuemask, struct ConvAttrs *values) ;
static void OTSW_resetupModeWindow (Widget gw) ;
static void OTSW_ReconfigureColor
 (Widget gw, unsigned long valuemask) ;

static void OTSW_ConfigureMinibuffer (Widget gw) ;
static int OTSW_ConfigureSubWindowMinibuffer (Widget gw, int flag) ;

static void OTSW_RedrawScreen (Widget gw) ;

static void OTSW_ConfigureWindowsScreenIsSmall
 (Widget gw,                  int endx, int endy,
  struct myChar *linetop,     int linetop_pos,
  struct myChar *midline_top, int midline_pos) ;
static int OTSW_ReconfigureFocusPosition
 (Widget gw) ;

static int focusCheck (Widget gw) ;

static void Minibuffer_Redisplay (Widget gw, Window win) ;

/*
 * callbacks
 */
static void Topline_Redisplay
 (Widget gw, Window win) ;
static void Midline_Redisplay
 (Widget gw, Window win) ;
static void Botline_Redisplay
 (Widget gw, Window win) ;
static void Modeshell_Display
 (Widget gw, Window win) ;
static void Modeshell_Redisplay
 (Widget gw, Window win) ;

static void Minibuffer_RedisplayCallback
 (Widget gw, caddr_t client, caddr_t caller) ;
static void OTSW_wmMessageCloseCallback
 (Widget gw, caddr_t client, caddr_t caller) ;
static void OTSW_wmShellDestroyCallback
 (Widget gw, caddr_t client, caddr_t caller) ;
static void Canvas_DestroyCallback
 (Widget gw, caddr_t client, caddr_t caller) ;
static void		OverWin_fixcallback		(Widget, XtPointer, XtPointer) ;

/* common style */
extern void skkinput_bufferInit (struct skkinputBuffer *buffer) ;
extern int commonKeyEventHandler
 (Widget gw, XEvent *xevent, struct skkinputBuffer *buffer) ;
extern void force_keyboard_quit
 (Widget gw, struct skkinputBuffer *buffer) ;

/*
 * Хѿ
 */
static XtActionsRec overthespotWinActionsTable [] = {
  { "KeyDownEventHandler",	   KeyDownEventHandler },
  { "FocusInEventHandler",	   FocusEventHandler },
  { "FocusOutEventHandler",	   FocusEventHandler },
};

static char defaultOverthespotWinTranslations[] =  
"<Key>:                   KeyDownEventHandler()\n\
 <KeyRelease>:            KeyDownEventHandler()\n\
 <FocusIn>:               FocusInEventHandler()\n\
 <FocusOut>:              FocusOutEventHandler()\n" ;

OverthespotWinClassRec overthespotWinClassRec = {
    { /* core fields */
    /* superclass		*/	&widgetClassRec,
    /* class_name		*/	"Overthespot",
    /* size			*/	sizeof (OverthespotWinRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	OTSW_Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	OTSW_Realize,
    /* actions			*/	overthespotWinActionsTable,
    /* num_actions		*/	XtNumber (overthespotWinActionsTable),
    /* resources		*/	OTSW_resources,
    /* num_resources		*/	XtNumber (OTSW_resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	OTSW_Destroy,
    /* resize			*/	NULL,
    /* expose			*/	OTSW_Redisplay,
    /* set_values		*/	OTSW_SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultOverthespotWinTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    }
};

WidgetClass overthespotWinWidgetClass =
 (WidgetClass)&overthespotWinClassRec ;

static void OTSW_InitializeHistory (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

  if (w->overthespotWin.historyAttribute == NULL){
    return ;
  }
  /* ꤷȤСġ*/
  if (w->overthespotWin.historyAttribute->overthespot_like_input == False){
    /* X Resource ¦ꤹ롣*/
    w->overthespotWin.buffer.overthespot_like_input = 
      w->overthespotWin.overthespotLikeInput ;
  } else {
    /* ήѤ롣*/
    w->overthespotWin.buffer.overthespot_like_input = 
      w->overthespotWin.historyAttribute->overthespot_like_input ;
  }
  /* ҥȥν򤹤롣ϥ⡼ڤؤǡϥ⡼
     ˰ưƤޤäΤݸǤ롣*/
  w->overthespotWin.buffer.historybuffer =
    w->overthespotWin.historyAttribute->history ;
  w->overthespotWin.buffer.hist_start = 
    w->overthespotWin.historyAttribute->history_start ;
  w->overthespotWin.buffer.hist_end = 
    w->overthespotWin.historyAttribute->history_end ;
  w->overthespotWin.buffer.histcurbackbuffer =
    w->overthespotWin.historyAttribute->histcurbak ;
  w->overthespotWin.buffer.hist_cur = -1 ;
  
  w->overthespotWin.buffer.chat_adapter =
    w->overthespotWin.historyAttribute->chat_adapter ;
  w->overthespotWin.buffer.egg_like_newline =
    w->overthespotWin.historyAttribute->egg_nl ;
  
  w->overthespotWin.buffer.topbuffer->j_mode =
    w->overthespotWin.historyAttribute->j_mode ;
  w->overthespotWin.buffer.topbuffer->j_zenkaku =
    w->overthespotWin.historyAttribute->j_zenkaku ;
  w->overthespotWin.buffer.topbuffer->j_katakana_mode =
    w->overthespotWin.historyAttribute->j_katakana_mode ;
  return ;
}

static void OTSW_Initialize 
 (Widget greq, Widget gnew, ArgList args, Cardinal *num_args)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gnew ;
  int i ;

  /* colormap ڤӥե饦ɡХå饦ɥ顼ν
   * */ 
  w->overthespotWin.background = w->core.background_pixel ;
  w->overthespotWin.foreground = w->overthespotWin.puppixel ;
  w->overthespotWin.colormap   = w->core.colormap ;

  w->overthespotWin.oforeground = w->overthespotWin.foreground ;
  w->overthespotWin.obackground = w->overthespotWin.background ;

  /* եȥåȤ롣*/
  for (i = 0 ; i < NUMBER_OF_CHARSET ; i ++){
    w->overthespotWin.fontset[ i ] = NULL ;
    w->overthespotWin.minibuf_fontset[ i ] = NULL ;
  }
  w->overthespotWin.gc = w->overthespotWin.rgc = NULL ;
  w->overthespotWin.minibuf_gc = w->overthespotWin.minibuf_rgc = NULL ;

  /* ǥեȤΥեȤꤷƤ*/
  fontMgr_copyDefaultFontSet
     (XtDisplay (gnew), w->overthespotWin.fontset) ;
  fontMgr_copyDefaultMinibufFontSet
     (XtDisplay (gnew), w->overthespotWin.minibuf_fontset) ;
  /* եȤ礭ξȴФƤ*/
  fontMgr_GetFontSetInfo
     (w->overthespotWin.fontset, 
      &w->overthespotWin.font_height, &w->overthespotWin.font_ascent) ;
  fontMgr_GetFontSetInfo
     (w->overthespotWin.minibuf_fontset, 
      &w->overthespotWin.mfont_height, &w->overthespotWin.mfont_ascent) ;

  /* Хåեν򤷤Ƥ*/
  skkinput_bufferInit (& (w->overthespotWin.buffer)) ;
  w->overthespotWin.buffer.redraw = OTSW_RedrawScreen ;
  /* w->overthespotWin.buffer.overthespot_like_input = True ; */

  /* ޤFocus ϺǽϳƤȻפ衣*/
  w->overthespotWin.is_focus = False ;

  /* Over-the-spot Window ȤƵǽ뤿ɬפѿν*/
  w->overthespotWin.focus_window = None ;
  w->overthespotWin.input_focus_window = None ;
  w->overthespotWin.spot_x = w->overthespotWin.spot_y = 0 ;
  w->overthespotWin.focus_offset_x =
    w->overthespotWin.focus_offset_y = 0 ;
  w->overthespotWin.client_x =
    w->overthespotWin.client_y = 0 ;
  w->overthespotWin.client_area.x = 
    w->overthespotWin.client_area.y = 0 ;
  w->overthespotWin.client_area.height = 
    w->overthespotWin.client_area.width = 0 ;
  w->overthespotWin.status_area.x = 
    w->overthespotWin.status_area.y = 0 ;
  w->overthespotWin.status_area.height = 
    w->overthespotWin.status_area.width = 0 ;

  /* ХåեȤɽ뤿˻ȤɥõƤ*/
  w->overthespotWin.topline_probe = False ;
  w->overthespotWin.midline_probe = False ;
  w->overthespotWin.botline_probe = False ;
  w->overthespotWin.minibuffer_probe = False ;
  w->overthespotWin.modeshell_probe = False ;

  w->overthespotWin.attribute_mask = 0L ;

  /* 礭ꡣ*/
  w->overthespotWin.cursor_width = 8 ;

  /* ҥȥν򤹤롣*/
  OTSW_InitializeHistory (gnew) ;

  w->overthespotWin.modeshell_border_width = 2 ;
  w->overthespotWin.modeshell_width =
    w->overthespotWin.modeshell_height = 1 ;

  w->overthespotWin.topline_win =
    w->overthespotWin.midline_win =
    w->overthespotWin.botline_win =
    w->overthespotWin.modeshell_win = 
    w->overthespotWin.minibuffer_win = None ;
  return ;
}

static void OTSW_ReleaseAllGCs (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  if (w->overthespotWin.gc != NULL)
    XFreeGC (XtDisplay (gw), w->overthespotWin.gc) ;
  if (w->overthespotWin.rgc != NULL)
    XFreeGC (XtDisplay (gw), w->overthespotWin.rgc) ;
  w->overthespotWin.gc = w->overthespotWin.rgc = NULL ;
  return ;
}

static void OTSW_ReleaseMinibufferGCs (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  if (w->overthespotWin.minibuf_gc != NULL)
    XFreeGC (XtDisplay (gw), w->overthespotWin.minibuf_gc) ;
  if (w->overthespotWin.minibuf_rgc != NULL)
    XFreeGC (XtDisplay (gw), w->overthespotWin.minibuf_rgc) ;
  w->overthespotWin.minibuf_gc = w->overthespotWin.minibuf_rgc = NULL ;
  return ;
}

static void OTSW_FreeFontSet (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  int i ;

  for (i = 0 ; i < NUMBER_OF_CHARSET ; i ++){
    fontMgr_FreeFont
       (XtDisplay (gw), w->overthespotWin.fontset[ i ]) ;
    fontMgr_FreeFont
       (XtDisplay (gw), w->overthespotWin.minibuf_fontset[ i ]) ;
    w->overthespotWin.fontset[ i ] = 
      w->overthespotWin.minibuf_fontset[ i ] = NULL ;
  }
  return ;
}

static void OTSW_CreateAllGCs (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  Window drawable = w->overthespotWin.focus_window ;
  XGCValues values ;

  values.foreground = w->overthespotWin.oforeground ;
  values.background = w->overthespotWin.obackground ;
  w->overthespotWin.gc = XCreateGC
     (XtDisplay (gw), drawable, GCForeground | GCBackground, &values) ;
  values.foreground = w->overthespotWin.obackground ;
  values.background = w->overthespotWin.oforeground ;
  w->overthespotWin.rgc = XCreateGC
     (XtDisplay (gw), drawable, GCForeground | GCBackground, &values) ;
  return ;
}

static void OTSW_CreateMinibufferGCs (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  XGCValues values ;

  /* ̤ŽդפΥߥ˥ХåեʤкɬפϤʤ*/
  if (w->overthespotWin.minibuffer_win != None)
    return ;

  /* Ѳϼʤ褦ˤ롣ͳϴñ顼ޥåפۤʤ
   * ǽ뤫Ǥ㤢顼ޥåפˤ褦ġDEPTH 
   * 㤦ǽޤDEPTH ˤ褦Ĥäơ  */
  values.foreground = w->overthespotWin.foreground ;
  values.background = w->overthespotWin.background ;
  w->overthespotWin.minibuf_gc = XCreateGC
     (XtDisplay (gw), XtWindow (w->overthespotWin.minibuffer_canvas),
      GCForeground | GCBackground, &values) ;
  values.foreground = w->overthespotWin.background ;
  values.background = w->overthespotWin.foreground ;
  w->overthespotWin.minibuf_rgc = XCreateGC
     (XtDisplay (gw), XtWindow (w->overthespotWin.minibuffer_canvas),
      GCForeground | GCBackground, &values) ;
  return ;
}

static Window OTSW_CreateModeShellWin
 (Widget gw, Window focus_window, int *probe, int border_width)
{
  OverthespotWinWidget	w	=  (OverthespotWinWidget)gw ;
  Window		win ;
  XSetWindowAttributes attr;

  if (border_width <= 0){
    win = XCreateSimpleWindow
       (XtDisplay (gw), focus_window, 0, 0, 1, 1, 0,
	w->overthespotWin.obackground,
	w->overthespotWin.obackground) ;
  } else {
    win = XCreateSimpleWindow
       (XtDisplay (gw), focus_window, 0, 0, 1, 1, border_width,
	w->overthespotWin.oforeground,
	w->overthespotWin.obackground) ;
  }
  attr.override_redirect = True;
  XChangeWindowAttributes (XtDisplay (gw), win, CWOverrideRedirect, &attr);
  /* ϤΤɬפˤʤޤǤϡmap ʤ*/
  *probe = False ;
  return win ;
}

static Window OTSW_CreateSubCanvas
 (Widget gw, Window focus_window, int *probe, int border_width)
{
	OverthespotWinWidget	w	=  (OverthespotWinWidget)gw ;
	Window		win ;
	XSetWindowAttributes	xswa ;
	
	if (border_width <= 0){
		win = XCreateSimpleWindow
			(XtDisplay (gw), focus_window, 0, 0, 1, 1, 0,
			 w->overthespotWin.obackground,
			 w->overthespotWin.obackground) ;
	} else {
		win = XCreateSimpleWindow
			(XtDisplay (gw), focus_window, 0, 0, 1, 1, border_width,
			 w->overthespotWin.oforeground,
			 w->overthespotWin.obackground) ;
	}
	add_myeventhandler  (XtDisplay (gw), win, XtWindow (gw), Expose, ExposureMask) ;
	add_myeventhandler  (XtDisplay (gw), win, XtWindow (gw), KeyPress, KeyPressMask) ;
	add_myeventhandler  (XtDisplay (gw), win, XtWindow (gw), KeyRelease, KeyReleaseMask) ;
	add_myeventhandler  (XtDisplay (gw), win, XtWindow (gw), DestroyNotify, SubstructureNotifyMask) ;
	
	/* SaveUnder ˤʤ modeshell ΰưˤä ExposureEvent ƤǤޤ*/
	xswa.save_under = True ;
	XChangeWindowAttributes (XtDisplay(gw), win, CWSaveUnder, &xswa) ;
	
	/* avoid Unmap on Qt by setting over-ride-redirect */
	xswa.override_redirect = True ;
	XChangeWindowAttributes (XtDisplay(gw), win, CWOverrideRedirect, &xswa) ;
	
	/* ϤΤɬפˤʤޤǤϡmap ʤ*/
	*probe = False ;
	return win ;
}

static int OTSW_ParseModeShellGeometry(Widget gw)
{
	OverthespotWinWidget ow = (OverthespotWinWidget)gw;
	int x, y;
	unsigned int w, h;
	int r;

	x = y = 0;
	w = h = 0;
	r = XParseGeometry(ow->overthespotWin.modeshell_geometry, &x, &y, &w, &h);
	if (r == 0) {
		/* not specified, or invalid geometry */
		return 0;
	}
	if ((r & XValue) == XValue) {
		ow->overthespotWin.modeshell_x = x;
	}
	if ((r & YValue) == YValue) {
		ow->overthespotWin.modeshell_y = y;
	}
	/* not recommended? */
	if ((r & WidthValue) == WidthValue) {
		ow->overthespotWin.modeshell_width = w;
	}
	if ((r & HeightValue) == HeightValue) {
		ow->overthespotWin.modeshell_height = h;
	}
	
	if ((r & XNegative) == XNegative) {
		ow->overthespotWin.modeshell_x = 
			DisplayWidth (XtDisplay (gw), DefaultScreen (XtDisplay (gw))) 
			- ow->overthespotWin.modeshell_width - 10;
	}
	if ((r & YNegative) == YNegative) {
		ow->overthespotWin.modeshell_y = 
			DisplayHeight (XtDisplay (gw), DefaultScreen (XtDisplay (gw))) 
			- ow->overthespotWin.modeshell_height - 10;
	}
	return r;
}

/*
 * [--]Υ⡼ɥɽ륦ɥؿ
 *---
 * ˱ƼΤ褦ʤȤ򤷤Ƥޤ
 *  1. ơꥢλ꤬ ..... 
 *         ⡼ɥϥơꥢ˸ꤷ֤ޤ 
 *  2. ơꥢ̵ .....
 *         ⡼ɥϥեɥưޤ
 */
static void OTSW_CreateModeShell (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	Window parentwin ;
	int border_width ;

	parentwin    = w->overthespotWin.client_window ;
	if ((w->overthespotWin.attribute_mask & CAStatusArea) &&
		w->overthespotWin.client_window != w->overthespotWin.focus_window){
		/* ξˤϡ⡼ɥˤ롣*/
		border_width = 0 ;
		w->overthespotWin.fixed_modeshell = True ;
	} else {
		border_width = w->overthespotWin.modeshell_border_width ;
		w->overthespotWin.fixed_modeshell = False ;
	}
	/* ⡼ɥ롣*/
	if (OTSW_ParseModeShellGeometry(gw)) {
	    w->overthespotWin.modeshell_win = OTSW_CreateModeShellWin
		(gw, RootWindowOfScreen (XtScreen(gw)), &w->overthespotWin.modeshell_probe, border_width) ;
	} else {
	    w->overthespotWin.modeshell_win = OTSW_CreateSubCanvas
		(gw, parentwin, &w->overthespotWin.modeshell_probe, border_width) ;
	}
	/* 礭νresize ϰ̤äߤΤǤ顣*/
	w->overthespotWin.modeshell_width  = 1 ;
	w->overthespotWin.modeshell_height = 1 ;
	return ;
}

/*
 * ߥ˥ХåեβΤ˸ƤӽФؿ
 */
static void OTSW_RealizeMinibuffer (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	Widget minibuffer_popup, minibuffer_canvas ;
	XSizeHints sizehints ;
	unsigned int winwidth, winheight, font_height ;

	winwidth  = w->overthespotWin.minibuf_width ;
	if (w->overthespotWin.change_minibuffer_font){
		winheight   = w->overthespotWin.font_height ;
		font_height = w->overthespotWin.font_height ;
	} else {
		winheight   = w->overthespotWin.mfont_height ;
		font_height = w->overthespotWin.mfont_height ;
	}
	minibuffer_popup = XtVaCreatePopupShell
		("minibuffer", wmcloseShellWidgetClass, gw,
		 XtNinput, 				w->overthespotWin.m_fInputFocus,
		 XtNmappedWhenManaged,	TRUE, 
		 XtNwidth,				winwidth,
		 XtNheight,				winheight, 
		 XtNcolormap,			gw->core.colormap,
		 XtNreverseVideo,		w->overthespotWin.reverse_video,
		 XtNbackground,			w->overthespotWin.background,
		 XtNforeground,			w->overthespotWin.foreground, NULL) ;
	XtAddCallback
		(minibuffer_popup, XtNwmcloseNotify, 
		 (XtCallbackProc)OTSW_wmMessageCloseCallback, gw) ;
	XtAddCallback
		(minibuffer_popup, XtNdestroyNotify, 
		 (XtCallbackProc)OTSW_wmShellDestroyCallback, gw) ;
	
	/* βˤĤɽѤ widget 롣shellwidget ľ *
	 * ܽ񤤤ƤϤޤäȤΤǡġ*/
	minibuffer_canvas = XtVaCreateManagedWidget
		("canvas", canvasWidgetClass, minibuffer_popup,
		 XtNreverseVideo, w->overthespotWin.reverse_video,
		 XtNbackground, w->overthespotWin.background, 
		 XtNforeground, w->overthespotWin.foreground, NULL) ;
	w->overthespotWin.minibuffer_probe = False ;
	/* 襤٥ȤåäƤ*/
	XtAddCallback
		(minibuffer_canvas, XtNredrawNotify,
		 (XtCallbackProc)Minibuffer_RedisplayCallback, gw) ;
	XtAddCallback
		(minibuffer_canvas, XtNdestroyNotify, 
		 (XtCallbackProc)Canvas_DestroyCallback, gw) ;
	
	/* ˥ߥ˥ХåեξϤƤrealize Ƥȴ*/
	w->overthespotWin.minibuffer_popup  = minibuffer_popup ;
	w->overthespotWin.minibuffer_canvas = minibuffer_canvas ;
	
	/* 괺ΤġXtPopDown ȤפʤΤʤ*/
	XtRealizeWidget (minibuffer_popup) ;
	XtRealizeWidget (minibuffer_canvas) ;

	minibuffer_popup->core.border_width = 0 ;
	/* Ƥ˥ꥵäƤ롩 */
	(void) XtMakeResizeRequest
		((Widget)minibuffer_popup,
		 (Dimension)winwidth,  (Dimension)winheight,
		 &minibuffer_popup->core.width,
		 &minibuffer_popup->core.height) ;
	
	/* ɥΥꥵ¾ꡣ*/
	sizehints.win_gravity = NorthWestGravity ;
	sizehints.base_width  = 0 ; /*minibuffer_popup->core.border_width * 2 ;*/
	sizehints.base_height = 0 ; /*minibuffer_popup->core.border_width * 2 ;*/
	sizehints.width      = sizehints.base_width + winwidth ;
	sizehints.height     = sizehints.base_height + winheight ;
	sizehints.width_inc  = 1 ;  /* ĹեȤꤹȺǾʬ
								 * Ǥʤ*/
	sizehints.height_inc = font_height ;
	sizehints.min_width  = sizehints.base_width ;
	sizehints.min_height = sizehints.base_height + winheight ;
	/* Ǿ礭ϤäƤ礭̵Ĥ褦ˤƤߤ
	 * mule ϡĤ顢ˤ碌뤳ȡ(minibuffer Τ) */
	sizehints.flags      =
		(PBaseSize | PMinSize | PResizeInc | USSize | PWinGravity) ;
	/* Window Manager ˥ҥȤäƤ롣*/
	XSetWMNormalHints
		(XtDisplay (gw), XtWindow (minibuffer_popup), &sizehints) ;
	/*XFlush (XtDisplay (gw)) ;*/
	return ;
}

static void
OTSW_CreateMinibuffer (
	register Widget		gw)
{
	register OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

	if ((w->overthespotWin.attribute_mask & CAStatusArea) &&
		w->overthespotWin.client_window != w->overthespotWin.focus_window){
		/* ɤаޤǤäϡ饤ȤŽդ*/
		w->overthespotWin.minibuffer_win = OTSW_CreateSubCanvas
			(gw, w->overthespotWin.client_window,
			 &w->overthespotWin.minibuffer_probe, 0) ;
		if (OTSW_ConfigureSubWindowMinibuffer (gw, False)){
			/* åȤѤʤΤǡNULL Ƥ*/
			w->overthespotWin.minibuffer_popup = 
				w->overthespotWin.minibuffer_canvas = NULL ;
			return ;
		}
		/* Ѵ饤ȤŽդפΥߥ˥ХåեǤϤȤƤ礭
		 * ­ʤΤǡ˳פˤ롣*/
		XDestroyWindow (XtDisplay (gw), w->overthespotWin.minibuffer_win) ;
	}
	w->overthespotWin.minibuffer_win = None ;
	w->overthespotWin.minibuffer_ofstx = 0 ;
	OTSW_RealizeMinibuffer (gw) ;

	if (w->overthespotWin.m_fInputFocus) {
		XtSetKeyboardFocus (w->overthespotWin.minibuffer_popup, gw) ;
		XtSetKeyboardFocus (w->overthespotWin.minibuffer_canvas, gw) ;
	}
	return ;
}

/*
 * Widget β˸ƤФؿ
 */
static void OTSW_Realize (
	register Widget					gw,
	register XtValueMask*			valueMask,
	register XSetWindowAttributes*	attrs)
{
	register OverthespotWinWidget	w		= (OverthespotWinWidget)gw ;
	register CoreWidgetClass		super	= (CoreWidgetClass)XtClass (gw)->core_class.superclass ;
	register Window					wndParent ;

	/* ŬڤʥɥѰդƤ*/
	(*super->core_class.realize) (gw, valueMask, attrs) ;

	/* Ѵ饤Ȥ¸ߤʤ⤷ϡեȤäƤȶ
	 * λ롣*/
	if (w->overthespotWin.client_window == None){
		XtDestroyWidget (gw) ;
		return ;
	}
	if (XtHasCallbacks (gw, XtNfixNotify) != XtCallbackHasSome) 
		XtAddCallback (gw, XtNfixNotify, OverWin_fixcallback, NULL) ;

	if (w->overthespotWin.focus_window == None){
		w->overthespotWin.focus_window = w->overthespotWin.client_window ;
		if (! (w->overthespotWin.attribute_mask & CAClientArea))
			XGetRectangleOfWindow
				(XtDisplay (gw), w->overthespotWin.focus_window, 
				 &w->overthespotWin.client_area) ;
	}
	OTSW_ReconfigureFocusPosition (gw) ;
	OTSW_CreateAllGCs (gw) ;
	
	/* Minibuffer 롣*/
	OTSW_CreateMinibuffer (gw) ;
	OTSW_CreateMinibufferGCs (gw) ;

#if 0
	printf ("Client = %ld, Focus = %ld\n",
			w->overthespotWin.client_window,
			w->overthespotWin.focus_window) ;
#endif
	/* modeshell ɽΤΥåȤ롣*/
	OTSW_CreateModeShell (gw) ;

	/* ʸѤΥХ3ɬפˤʤ롣*/
	wndParent	= w->overthespotWin.client_window ;
	w->overthespotWin.topline_win = OTSW_CreateSubCanvas
		(gw, wndParent, &w->overthespotWin.topline_probe, 0) ;
	w->overthespotWin.midline_win = OTSW_CreateSubCanvas
		(gw, wndParent, &w->overthespotWin.midline_probe, 0) ;
	w->overthespotWin.botline_win = OTSW_CreateSubCanvas
		(gw, wndParent, &w->overthespotWin.botline_probe, 0) ;
	
	/*
	 * ΰ֤ʤ⡼ɥƤʤ
	 */
	OTSW_resetupModeWindow (gw) ;
	OTSW_ReconfigureColor (gw, CAForegroundPixel | CABackgroundPixel | CAColormap) ;
#if 0
	XSync (XtDisplay (gw), False) ;
#endif
	w->overthespotWin.is_focus = focusCheck (gw) ;
	return ;
}

/*
 * ƤΥ٥Ȥդʤ褦ˤؿ
 *---
 * ͡Destroy ˸Ƥǲ
 */
static void OTSW_IgnoreAllWindowEvent (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

  remove_allmyeventhandler
     (XtDisplay (gw), w->overthespotWin.modeshell_win) ;
  remove_allmyeventhandler
     (XtDisplay (gw), w->overthespotWin.topline_win) ;
  remove_allmyeventhandler
     (XtDisplay (gw), w->overthespotWin.midline_win) ;
  remove_allmyeventhandler
     (XtDisplay (gw), w->overthespotWin.botline_win) ;
  if (w->overthespotWin.minibuffer_win != None){
    remove_allmyeventhandler
       (XtDisplay (gw), w->overthespotWin.minibuffer_win) ;
  } else {
    XSafeSelectInput
       (XtDisplay (gw), XtWindow (w->overthespotWin.minibuffer_popup),
	NoEventMask) ;
    XSafeSelectInput
       (XtDisplay (gw), XtWindow (w->overthespotWin.minibuffer_canvas),
	NoEventMask) ;
  }
  XSafeSelectInput (XtDisplay (gw), XtWindow (gw), NoEventMask) ;
  /* Event Queue եå夷Ƥ*/
  XSafeFlush (XtDisplay (gw)) ;
  return ;
}

/*
 * SIW  XtDestroyWidget 򤫤˸ƤӽФؿ
 *-----
 * SIW νλ·äƤ롣GC Ƥ顢malloc Ƥ
 * Ƥ롣
 */
static void OTSW_Destroy (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	struct SKKInputNode *node, *pNode ;
	/*
	 * XFreeFont (XtDisplay (gw), w->overthespotWin.fs_kanji) ;
	 * XFreeFont (XtDisplay (gw), w->overthespotWin.fs_roman) ;
	 * ɤ顢Widget ˳ݤƤ櫓ʤߤʤΤǡ
	 * ȤϤޤߤ
	 */
	/* Destroy ʾ塢ʲΥɥΥ٥Ȥ̵뤹롣*/
	OTSW_IgnoreAllWindowEvent (gw) ;
	OTSW_ReleaseAllGCs (gw) ;
	OTSW_ReleaseMinibufferGCs (gw) ;
	OTSW_FreeFontSet (gw) ;
	
	if (w->overthespotWin.modeshell_win != None)
		XDestroyWindow (XtDisplay (gw), w->overthespotWin.modeshell_win) ;
	if (w->overthespotWin.topline_win != None)
		XDestroyWindow (XtDisplay (gw), w->overthespotWin.topline_win) ;
	if (w->overthespotWin.midline_win != None)
		XDestroyWindow (XtDisplay (gw), w->overthespotWin.midline_win) ;
	if (w->overthespotWin.botline_win != None)
		XDestroyWindow (XtDisplay (gw), w->overthespotWin.botline_win) ;
	if (w->overthespotWin.minibuffer_win != None)
		XDestroyWindow (XtDisplay (gw), w->overthespotWin.minibuffer_win) ;
    
	/*
	 * ҥȥƤؤ֤
	 */
	if (w->overthespotWin.historyAttribute != NULL){
		/* ҥȥˤĤƿƤ֤ޤ*/
		w->overthespotWin.historyAttribute->history_start =
			w->overthespotWin.buffer.hist_start ;
		w->overthespotWin.historyAttribute->history_end =
			w->overthespotWin.buffer.hist_end ;
		/* ξѴ⡼ɤξˤĤƿƤؤ֤*/
		w->overthespotWin.historyAttribute->overthespot_like_input =
			w->overthespotWin.buffer.overthespot_like_input ;
		/* ޤĤβ̾⡼ɤξƤؤ֤ޤ*/
		if (w->overthespotWin.buffer.topbuffer != NULL){
			w->overthespotWin.historyAttribute->j_mode =
				w->overthespotWin.buffer.topbuffer->j_mode ;
			w->overthespotWin.historyAttribute->j_zenkaku =
				w->overthespotWin.buffer.topbuffer->j_zenkaku ;
			w->overthespotWin.historyAttribute->j_katakana_mode =
				w->overthespotWin.buffer.topbuffer->j_katakana_mode ;
		}
	}
	/*
	 * ХåեƲƤ
	 */
	node =  (w->overthespotWin.buffer).lastbuffer ;
	while (node != NULL){
		pNode = node->parentbuffer ;
		free_Minibuffer (gw, & (w->overthespotWin.buffer), node) ;
		node  = pNode ;
	}
	XtCallCallbacks (gw, XtNendNotify, w->overthespotWin.historyAttribute) ;
	w->overthespotWin.historyAttribute = NULL ;
	return ;
}

/*
 * ̤褹ؿ
 */
static void OTSW_Redisplay (Widget gw, XEvent *event, Region region)
{
#if 0
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  /* ϲΥߥ󥰤Ǵְä Widget κ褬Ƥ롣*/
  if (w->overthespotWin.buffer.topbuffer == NULL || 
      w->core.being_destroyed){
#if defined(DEBUG)
    fprintf (stderr, "Illegal Widget Exposure Event.\n") ;
#endif
    return ;
  }
#endif
  OTSW_RedrawScreen (gw) ;
  return ;
}

/*
 * 䤳ȥ饤ȤΥå򸫤ơåȤ
 * ꤹؿ
 *----
 * 饤ȥɥΰưΤ饤ȥɥ
 *  lower ꡢ raise ȡɤ褦̵褦ʵ
 * ġɤˤ臘ʤͤʤȤʤΤɤġ
 */
static int OTSW_ReconfigureWindows (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

  if (w->overthespotWin.minibuffer_probe &&
      w->overthespotWin.minibuffer_popup != NULL){
    XRaiseWindow
       (XtDisplay (gw),
	XtWindow (w->overthespotWin.minibuffer_popup)) ;
  }
  /* Spot Location ѲˤʸɽƤ륭Хư */
  /* ʤФʤʤν˺ä C-h ѴưԽ */
  /* ʸõ˥ɥĤ뤳Ȥˤʤ롣*/
  OTSW_RedrawScreen (gw) ;
  w->overthespotWin.camsg = NULL ;
  return True ;
}

/*
 * Minibuffer 礭ѹ塢modeshell 礭ѹؿ
 *---
 * 㤨Хեȥѹ줿ˤ Minibuffer 礭ѹ
 * ɬפޤ͡ ޤmodeshell 礭ѹɬפ
 * ޤ͡ 
 */
static void OTSW_ResizeMinibufferAndModeshell (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  XSizeHints sizehints ;

  /* Minibuffer Window ¸ߤʤС¸ߤʤȤ̵ɡ
   * 饤ȤŽդפΥɥǤХꥵϤʤ*/
  if (w->overthespotWin.minibuffer_win != None)
    return ;

  /* modeshell ξϤޤǲȤǤ礦͡*/
  if (w->overthespotWin.change_minibuffer_font){
    if (w->overthespotWin.minibuf_width != 
	w->overthespotWin.minibuffer_popup->core.width ||
	w->overthespotWin.font_height !=
	w->overthespotWin.minibuffer_popup->core.height){
      /* core width, height ѹƤ*/
      w->overthespotWin.minibuffer_canvas->core.width = 
      w->overthespotWin.minibuffer_popup->core.width = 
	w->overthespotWin.minibuf_width ;
      w->overthespotWin.minibuffer_canvas->core.height =
      w->overthespotWin.minibuffer_popup->core.height =
	w->overthespotWin.font_height ;
      /* Window 礭ѹ롣*/
      XtResizeWindow (w->overthespotWin.minibuffer_popup) ;
      XtResizeWindow (w->overthespotWin.minibuffer_canvas) ;
      /* ߥ˥ХåեΥɥޥ͡㡼°롣*/
      sizehints.base_width  = 
	w->overthespotWin.minibuffer_popup->core.border_width * 2 ;
      sizehints.base_height = 
	w->overthespotWin.minibuffer_popup->core.border_width * 2 ;
      sizehints.width_inc  = 1 ;
      sizehints.height_inc = w->overthespotWin.font_height ;
      sizehints.min_width  = sizehints.base_width ;
      sizehints.min_height = w->overthespotWin.font_height +
	sizehints.base_height ;
      sizehints.flags =  (PBaseSize | PMinSize | PResizeInc) ;
      XChangeWMNormalHints
	 (XtDisplay (gw),
	  XtWindow (w->overthespotWin.minibuffer_popup),
	  &sizehints) ;
    }
  } else {
    if (w->overthespotWin.minibuf_width != 
	w->overthespotWin.minibuffer_popup->core.width ||
	w->overthespotWin.mfont_height !=
	w->overthespotWin.minibuffer_popup->core.height){
      /* core width, height ѹƤ*/
      w->overthespotWin.minibuffer_canvas->core.width = 
      w->overthespotWin.minibuffer_popup->core.width = 
	w->overthespotWin.minibuf_width ;
      w->overthespotWin.minibuffer_canvas->core.height =
      w->overthespotWin.minibuffer_popup->core.height =
	w->overthespotWin.mfont_height ;
      /* Window 礭ѹ롣*/
      XtResizeWindow (w->overthespotWin.minibuffer_popup) ;
    }
  }
  return ;
}

/*
 * foreground color, background color ѹƤȤ׵᤬褿 
 * modeshell ʤɤطʿѹ GC  foreground color ѹ
 * ؿ
 */
static void OTSW_ReconfigureColor (Widget gw, unsigned long valuemask)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	unsigned long mask ;
	XSetWindowAttributes xswa ;

	mask = 0L ;
	if (valuemask & CABackgroundPixel){
		mask	|= CWBackPixel ;
		xswa.background_pixel = w->overthespotWin.obackground ;
	}
	if (valuemask & CAForegroundPixel) {
		mask	|= CWBorderPixel ;
		xswa.border_pixel     = w->overthespotWin.oforeground ;
	}
	if (valuemask & CAColormap){
		mask |= CWColormap ;
		xswa.colormap = w->overthespotWin.colormap ;
	}
	if (mask){
		XChangeWindowAttributes
			(XtDisplay (gw), w->overthespotWin.modeshell_win, 
			 mask, &xswa) ;
		XChangeWindowAttributes
			(XtDisplay (gw), w->overthespotWin.topline_win, 
			 mask, &xswa) ;
		XChangeWindowAttributes
			(XtDisplay (gw), w->overthespotWin.midline_win, 
			 mask, &xswa) ;
		XChangeWindowAttributes
			(XtDisplay (gw), w->overthespotWin.botline_win, 
			 mask, &xswa) ;
		if (w->overthespotWin.minibuffer_win != None){
			XChangeWindowAttributes
				(XtDisplay (gw), w->overthespotWin.minibuffer_win, 
				 mask, &xswa) ;
		}
	}
	if (! (valuemask & (CAForegroundPixel | CABackgroundPixel)))
		return ;

	/* GC  foreground, background ѹ롣*/
	if (XtIsRealized (gw)){
		OTSW_ReleaseAllGCs (gw) ;
		OTSW_CreateAllGCs (gw) ;
	}
	return ;
}

/*
 * åȴ֤ΥåȤؿ
 */
static Boolean OTSW_SetValues
 (Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args)
{
  OverthespotWinWidget curw =  (OverthespotWinWidget)current ;
  OverthespotWinWidget reqw =  (OverthespotWinWidget)request ;
  OverthespotWinWidget neww =  (OverthespotWinWidget)new ;
  struct ConvAttrsMesg *camsg ;

  /* 񤬽Ƥ顢ľ¹Ԥ롣*/
  if (curw->overthespotWin.buffer.jisyo_dirty !=
      reqw->overthespotWin.buffer.jisyo_dirty){
    neww->overthespotWin.buffer.jisyo_dirty =
      reqw->overthespotWin.buffer.jisyo_dirty ;
    /* 뤬Ƥʤм¹Ԥʤȡ*/
    if (neww->overthespotWin.modeshell_probe){
      Modeshell_Redisplay (new, neww->overthespotWin.modeshell_win) ;
    }
    return False ;
  }
  /* Ѵ°ν׵᤬褿ȸդꡣ*/
  if (reqw->overthespotWin.camsg != NULL){
    int ret ;
    camsg = reqw->overthespotWin.camsg ;
    reqw->overthespotWin.camsg = neww->overthespotWin.camsg = 
      curw->overthespotWin.camsg = NULL ;

    ret = OTSW_ChangeAttributes
       (new, camsg->mask, &camsg->value) ;
    /* ѹαƶäơ realize ƤˤϡĽ롣*/
    if (XtIsRealized (new) && ret)
      OTSW_ReconfigureWindows (new) ;
    return ret ;
  }
  /* ߥ˥ХåեõȤ˾νԤ*/
  if (reqw->overthespotWin.clearMinibuffer){
    if (curw->overthespotWin.minibuffer_probe){
      if (curw->overthespotWin.minibuffer_win != None){
	XUnmapWindow
	   (XtDisplay (curw), curw->overthespotWin.minibuffer_win) ;
      } else {
	XtPopdown (curw->overthespotWin.minibuffer_popup) ;
      }
      curw->overthespotWin.minibuffer_probe =
	reqw->overthespotWin.minibuffer_probe =
	neww->overthespotWin.minibuffer_probe = False ;
    }
    reqw->overthespotWin.clearMinibuffer =
      neww->overthespotWin.clearMinibuffer = 
      curw->overthespotWin.clearMinibuffer = False ;
    return FALSE ;
  }
  if (reqw->overthespotWin.conversion_set_focus){
    reqw->overthespotWin.conversion_set_focus = 
      neww->overthespotWin.conversion_set_focus = 
      curw->overthespotWin.conversion_set_focus = False ;
    /* modeshell 褵롣*/
    if (!neww->overthespotWin.modeshell_probe){
      XMapWindow (XtDisplay (neww), neww->overthespotWin.modeshell_win) ;
      neww->overthespotWin.modeshell_probe = True ;
      OTSW_resetupModeWindow (new);
    }
    /* mini-buffer ɽ롣⤷ɬפʤСĤǤ뤬*/
    OTSW_ConfigureMinibuffer (new) ;
    return FALSE ;
  }
  if (reqw->overthespotWin.conversion_unset_focus){
    reqw->overthespotWin.conversion_unset_focus = 
      neww->overthespotWin.conversion_unset_focus = 
      curw->overthespotWin.conversion_unset_focus = False ;
    if (neww->overthespotWin.modeshell_probe){
      XUnmapWindow (XtDisplay (new), neww->overthespotWin.modeshell_win) ;
      neww->overthespotWin.modeshell_probe = False ;
    }
    return FALSE ;
  }
  return (FALSE) ;
}

/*
 *
 */
static int OTSW_ReconfigureFocusPosition
 (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	int			x, y, ofx, ofy ;
	Window		dummy ;
	int			ret = False ;

	/* 롼ȥɥǤΥեɥа֤򻻽 *
	 * 롣*/
	XTranslateCoordinates
		(XtDisplay (gw), w->overthespotWin.client_window,
		 RootWindowOfScreen (XtScreen (gw)),
		 0, 0, &x, &y, &dummy) ;
	if (w->overthespotWin.focus_window != w->overthespotWin.client_window){
		XTranslateCoordinates
			(XtDisplay (gw), w->overthespotWin.focus_window,
			 w->overthespotWin.client_window, 
			 0, 0, &ofx, &ofy, &dummy) ;
	} else {
		ofx = ofy = 0 ;
	}
	if (w->overthespotWin.client_x != x || w->overthespotWin.client_y != y){
		w->overthespotWin.client_x = x ;
		w->overthespotWin.client_y = y ;
		ret = True ;
	}
	if (w->overthespotWin.focus_offset_x != ofx ||
		w->overthespotWin.focus_offset_y != ofy){
		w->overthespotWin.focus_offset_x = ofx ;
		w->overthespotWin.focus_offset_y = ofy ;
		ret = True ;
	}
	return ret ;
}

/*
 */
static void OTSW_ChangeFocusWindow (
	register Widget	gw,
	register Window	focus_win)
{
	register Display*	pDisplay	= XtDisplay (gw) ;
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

	XReparentWindow (pDisplay, w->overthespotWin.topline_win, focus_win, 0, 0) ;
	XReparentWindow (pDisplay, w->overthespotWin.midline_win, focus_win, 0, 0) ;
	XReparentWindow (pDisplay, w->overthespotWin.botline_win, focus_win, 0, 0) ;
	
	/* focus window ˤϤĤƤɥ˴롣*/
	if (!w->overthespotWin.fixed_modeshell)
		XReparentWindow (pDisplay, w->overthespotWin.modeshell_win, focus_win, 0, 0) ;

	w->overthespotWin.focus_window = focus_win ;
	OTSW_ReleaseAllGCs (gw) ;
	OTSW_CreateAllGCs (gw) ;
	return ;
}

/*
 * Ѵ饤ȤΡѴ°ν׵פ򤵤Фؿ
 */
static int OTSW_ChangeAttributes
 (Widget gw, unsigned long valuemask, struct ConvAttrs *values)
{
	OverthespotWinWidget w   =  (OverthespotWinWidget)gw ;
	int ret = False, rec_col ;

	if (valuemask & CAFocusWindow){
#if defined (DEBUG)
		fprintf (stderr, "(OTSW)Focus window (%ld)\n", values->focus_window) ;
#endif
		/* եäƼºߤΡ Ȥ¤Ϥ⤦ä *
		 * ɬפȻפ*/
		if (values->focus_window != None){
			/* ꤷȦΥեʪˤʤäƤ顢̣Ǥ */
			/* ʤ ȤäǤ*/
			if (w->overthespotWin.focus_window != None &&
				w->overthespotWin.focus_window != values->focus_window){
				/* ե롣*/
				OTSW_ChangeFocusWindow
					(gw, values->focus_window) ;
				/* Υ饤ȥꥢФϺˤƤ
				 * ʤʤΤǡ˴롣*/
				w->overthespotWin.attribute_mask &= ~ (CAClientArea) ;
			} else {
				w->overthespotWin.focus_window = values->focus_window ;
			}
			if (!((w->overthespotWin.attribute_mask) & CAClientArea)){
				XGetRectangleOfWindow
					(XtDisplay (gw), w->overthespotWin.focus_window,
					 &w->overthespotWin.client_area) ;
			}
			OTSW_ReconfigureFocusPosition (gw) ;
			ret = True ;
		}
	}
	if (valuemask & CAStatusArea){
		/* ɸνä⤷ɽΰ褬Ƥ硣*/
		if (values->status_area.x != w->overthespotWin.status_area.x ||
			values->status_area.y != w->overthespotWin.status_area.y ||
			values->status_area.width  != w->overthespotWin.status_area.width || 
			values->status_area.height != w->overthespotWin.status_area.height){
			w->overthespotWin.status_area.x = values->status_area.x ;
			w->overthespotWin.status_area.y = values->status_area.y ;
			w->overthespotWin.status_area.width  = values->status_area.width ;
			w->overthespotWin.status_area.height = values->status_area.height ;
			w->overthespotWin.attribute_mask |= CAStatusArea ;
#ifdef DEBUG
			printf ("Status Area: (x,y,w,h) = (%d,%d,%d,%d)\n",
					values->status_area.x, values->status_area.y,
					values->status_area.width, values->status_area.height) ;
#endif
			ret = True ;
		}
	}
	rec_col = False ;
	/* 顼ޥåפѹ׵᤬Ƥ顢롣*/
	if ((valuemask & CAColormap) &&
		w->overthespotWin.colormap != values->colormap){
		w->overthespotWin.colormap = values->colormap ;
#if defined(DEBUG)
		fprintf (stderr, "(OTSW)Change colormap.\n") ;
#endif
		rec_col = True ;
	}
	/* ե饦ɥ顼ڤӥХå饦ɥ顼ѹ׵᤬ *
	 * 顢ġ*/
	if ((valuemask & CAForegroundPixel) &&
		w->overthespotWin.oforeground != values->foreground){
#if defined(DEBUG)
		fprintf (stderr, "(OTSW)Change foreground and background colors.\n") ;
#endif
		w->overthespotWin.oforeground = values->foreground ;
		rec_col = True ;
	}
	if ((valuemask & CABackgroundPixel) &&
		w->overthespotWin.obackground != values->background) {
		w->overthespotWin.obackground = values->background ;
		rec_col = True ;
	}
	if (XtIsRealized (gw) && rec_col){
		OTSW_ReconfigureColor (gw, valuemask) ;
		ret = True ;
	}
	/* Ѵ饤ȤɽΰνΤ褿ν*/
	if (valuemask & CAClientArea){
		/* ɸνä⤷ɽΰ褬Ƥ硣*/
		if (values->client_area.x != w->overthespotWin.client_area.x ||
			values->client_area.y != w->overthespotWin.client_area.y ||
			values->client_area.width != w->overthespotWin.client_area.width || 
			values->client_area.height != w->overthespotWin.client_area.height){
			/* Ѵ饤ȤɽΰѹФƤ*/
			w->overthespotWin.client_area    = values->client_area ;
#ifdef DEBUG
			fprintf	(stderr, "(OTSW)Client pos:(%d,%d), size:%d x %d.\n",
					 w->overthespotWin.client_area.x,
					 w->overthespotWin.client_area.y,
					 w->overthespotWin.client_area.width,
					 w->overthespotWin.client_area.height) ;
#endif
			w->overthespotWin.attribute_mask |= CAClientArea ;
			ret = True ;
		}
	}
	/* ɸȤ׵᤬ƤνԤ*/
	if (valuemask & CASpotLocation){
		if (w->overthespotWin.focus_window != None){
			int prev_focus ;
#if defined(DEBUG)
			fprintf (stderr, "CASPOT nanode FOCUSWINDOW miru (%ld).\n",
					 w->overthespotWin.focus_window) ;
#endif
			prev_focus = w->overthespotWin.is_focus ;
			w->overthespotWin.is_focus = focusCheck (gw) ;
			if (prev_focus != w->overthespotWin.is_focus){
				ret = True ;
			}
			if (OTSW_ReconfigureFocusPosition (gw))
				ret = True ;
		}
		if (values->spot_x != w->overthespotWin.spot_x ||
			values->spot_y != w->overthespotWin.spot_y){
#ifdef DEBUG
			fprintf (stderr, "Get Basho Shitei meirei.\n") ;
#endif
			/* ֤뤵*/
			w->overthespotWin.spot_x = values->spot_x ;
			w->overthespotWin.spot_y = values->spot_y ;
			ret = True ;
		}
	}
	/* եȾνäν*/
	if (valuemask & CAFonts){
		/* եȾ򹹿롣λ饤¦ΥեȤξ
		 * ƹ碌ΤȤ롣㤨饤ȤեȤ
		 * ꤷƤʤƥǥեȤΥեȤȤȤˤʤꡢΥե
		 * Ȥι⤵ʤƤġ(ɤΤ) */
		if (fontMgr_GetFontSetInfo
			(values->fontset,
			 &w->overthespotWin.font_height,
			 &w->overthespotWin.font_ascent)){
			/* եȥåȤ򥳥ԡ롣*/
			fontMgr_CopyFontSet
				(XtDisplay (gw), w->overthespotWin.fontset, values->fontset) ;
			/* ߥ˥Хåեȥ⡼ɥ礭롣*/
			if (XtIsRealized (gw))
				OTSW_ResizeMinibufferAndModeshell (gw) ;
			ret = True ;
		}
	}
	/* եȤι⤵˴ؤƤˤϡġ*/
	if (valuemask & CALineSpacing){
		if (values->linespacing > 0){
			w->overthespotWin.font_height = values->linespacing ;
			ret = True ;
		}
	}
	if (( (valuemask & CAFonts) ||  (valuemask & CAStatusArea)) &&
		w->overthespotWin.minibuffer_win != None){
		OTSW_ConfigureSubWindowMinibuffer (gw, True) ;
	}
	return ret ;
}

/*
 * 줿Ȥ٥ȤνԤؿ
 *----
 * Υ줿ȤԲǽʾ礬Τǡ줿Ȥ
 * Ǿ꤯ư褦˺ʤФʤʤ
 */
static void KeyDownEventHandler
 (Widget gw, XEvent *xevent, String *params, Cardinal *num_params)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

#ifdef DEBUG
  fprintf (stderr, "[XEvent] Type(%d), Serial(%ld), Window(%ld)\n", 
	   xevent->type, xevent->xany.serial, xevent->xany.window) ;
#endif
  if (commonKeyEventHandler (gw, xevent, & (w->overthespotWin.buffer)))
    OTSW_RedrawScreen (gw) ;
  return ;
}

/*
 * ߥޥեƤ뤫ɤå뤿δؿ
 *-----
 * ΤƤХȤơեΰư˾꤯ȡ
 * Pointer ¸ߤƤ뤳ȤƨƤޤȤġʤʬ
 * 뤫
 */
static int focusCheck (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  Window mouse_focus, rootwin, childwin ;
  int ret_focus_state ;
  int rootx, rooty, winx, winy ;
  unsigned int winmask ;
  
  /* ޤޥΥեåäƤͤդ롣*/
  XGetInputFocus
     (XtDisplay (gw), &mouse_focus, &ret_focus_state) ;

#if defined(DEBUG)
  fprintf (stderr, "Mouse Focus Window:(%ld)\n", mouse_focus) ;
#endif
  if (mouse_focus == None)
    return False ;
  if (mouse_focus == PointerRoot)
    return True ;

  if (w->overthespotWin.input_focus_window != None){
    if (mouse_focus == w->overthespotWin.input_focus_window)
      return True ;
  } 
  if (XQueryPointer
      (XtDisplay (gw), mouse_focus,
       &rootwin, &childwin, &rootx, &rooty, &winx, &winy, 
       &winmask)){
#if defined(DEBUG)
    fprintf
       (stderr, "Focus Root Window:(%ld), Focus Child Window:(%ld)\n",
        rootwin, childwin) ;
#endif
    /* Ѵ饤ȤޥΥեäƤ롢⤷ */
    /* ϤλҶޥΥեäƤΤʤ True */
    if (w->overthespotWin.focus_window == childwin){
      if (w->overthespotWin.input_focus_window == None){
	w->overthespotWin.input_focus_window = mouse_focus ;
      }
      return True ;
    }
    if (w->overthespotWin.focus_window == mouse_focus)
      return True ;
    /* ߥ˥ХåեɥƤ⤢衣*/
    if (w->overthespotWin.minibuffer_probe){
      Window win ;
      if (w->overthespotWin.minibuffer_win != None){
	win = w->overthespotWin.minibuffer_win ;
      } else {
	win = XtWindow (w->overthespotWin.minibuffer_popup) ;
      }
      if (win == childwin || win == mouse_focus)
	return True ;
    }
  }
  return False ;
}

/*
 * ե蘆줿νԤؿ
 */
static void FocusEventHandler
 (Widget gw, XEvent *xevent, String *params, Cardinal *num_params)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  int prev_focus ;

  /* եɥޤäƤʤΤˡʥեIN ʤ */
  /* äƤ礸ʤ*/
  if (w->overthespotWin.focus_window == None)
    return ;
  /* ޤϥե򼺤äΤȹͤ롣*/
  prev_focus = w->overthespotWin.is_focus ;
  w->overthespotWin.is_focus = focusCheck (gw) ;
  /* ̤νĥηѲΤǡ*/
  if (prev_focus != w->overthespotWin.is_focus)
    OTSW_RedrawScreen (gw) ;
  return ;
}

/*
 * ʲΥեϡOverthespotWinWidget ΥΰǤ롣
 */

/*
 * ιԤ褹ؿ
 *------
 * ʣԽ񤫤ʤФʤʤ⤷ʤΤǡ褹٤Կ
 * Ϥɬפ롣
 */
static int OTSW_FullDrawTopBufferMiddleLines
 (Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, struct myChar *text, int text_pos,
  int font_ascent, int font_height, int width, int line_num,
  int cur_pos, int cur_exist, int is_focus)
{
  int x = 0, y = 0, xdiff ;
  int cursor_flag = False ;
  
  for (; !IS_END_OF_STRING (*text) ; text ++, text_pos ++){
    /* charset Ƚ̤Ȥˤեη׻*/
    xdiff = myCharTextWidth (fontset, text, 1) ;
    /* ̤αüޤ褷ΤɤȽǤ롣*/
    if ((x + xdiff) >= width){
      XDrawLine (disp, win, gc, x, y, width, y + font_height) ;
      y += font_height ;
      x = 0 ;
      line_num -- ;
      if (line_num <= 0)
	break ;
    }
    /* ɽʤΤɤȽꤹ롣*/
    if (text_pos == cur_pos && cur_exist){
      skkinputDrawCursor
	 (disp, win, gc, rgc,
	  x, y + font_ascent, font_ascent, xdiff,
	  font_height, is_focus) ;
      cursor_flag = True ;
    }
    /* ԥɤξˤϡɽ֤ɬפ롣*/
    if (IS_ASCII_EQUAL (*text, '\n')){
      y += font_height ;
      x  = 0 ;
      line_num -- ;
      if (line_num <= 0)
	break ;
    } else {
      if (cursor_flag){
	if (is_focus){
	  skkwin_jputMyChar
	     (disp, win, fontset, rgc, gc, 
	      x, y + font_ascent, *text, 
	      font_height, font_ascent, True) ;
	} else {
	  skkwin_jputMyChar
	     (disp, win, fontset, gc, rgc, 
	      x, y + font_ascent, *text, 
	      font_height, font_ascent, True) ;
	}
      } else {
	skkwin_jputMyChar
	   (disp, win, fontset, gc, rgc, 
	    x, y + font_ascent, *text, 
	    font_height, font_ascent, False) ;
      }
      x += xdiff ;
    }
    cursor_flag = False ;
  }
  return text_pos ;
}

static void XQueryPopdown (Widget gw, int *probe, Window win)
{
	if (probe){
		XUnmapWindow (XtDisplay (gw), win) ;
		*probe = False ;
	}
	return ;
}

/*
 * ̵礭ƱʤؿˤʤääȽɬפ
 * 롣
 */
static void OTSW_CalcSizeOfBufferWindows (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	int x, y; 			/* ɽ */
	int width, height ;		/* ̥*/
	struct SKKInputNode *node ;
	struct myChar *text ;
	struct myChar *line_top, *midline_top ;
	int cursor_flag, pos, linetop_pos, line_num, midline_pos = 0 ;
	int xdiff ;			/* ʸ*/
	register int	focus_offset_x, focus_offset_y ;
	
	/* ޤɸ򥻥åȤƤ*/
	x 					= w->overthespotWin.spot_x ;
	y 					= w->overthespotWin.spot_y ;
	focus_offset_x		= w->overthespotWin.focus_offset_x ;
	focus_offset_y		= w->overthespotWin.focus_offset_y ;
	
	/* ɽΰ礭ȤΤ׻Ƥ*/
	width  = w->overthespotWin.client_area.width + 
		w->overthespotWin.client_area.x ;
	height = w->overthespotWin.client_area.height +
		w->overthespotWin.client_area.y ;
	
	/* Ĵ٤ʤФʤʤʸƬˤ碌Ƥ*/
	node = w->overthespotWin.buffer.topbuffer ;
	text = node->textbuffer ;
	
	if (IS_END_OF_STRING (*text)){
		/* ʸ󤬰ĤäƤʤä顢ХåեȤɽ뤿 *
		 * ʤƤΤפˤʤΤ顢äƤޤλˡ *
		 * ¸ߤƤʤ褦äƤޤܤƤޤΤ *
		 * դ뤳 */
		XQueryPopdown
			(gw, &w->overthespotWin.topline_probe, 
			 w->overthespotWin.topline_win) ;
		XQueryPopdown
			(gw, &w->overthespotWin.midline_probe, 
			 w->overthespotWin.midline_win) ;
		XQueryPopdown
			(gw, &w->overthespotWin.botline_probe, 
			 w->overthespotWin.botline_win) ;
		w->overthespotWin.canvas_lines = 0 ;
		return ;
	}
	line_top    = text ;
	linetop_pos = 0 ;
	line_num    = 0 ;
	midline_top = NULL ;
	cursor_flag = False ;
	
	/* Ĵ٤뤳Ȥˤʤ롣*/
	for (pos = 0 ; !IS_END_OF_STRING (*text) ; text ++, pos ++){
		xdiff = myCharTextWidth (w->overthespotWin.fontset, text, 1) ;
		if ((x + xdiff) >= width){
			if ((y + w->overthespotWin.font_height) >= height){
				goto exit_loop ;
			} else {
				y += w->overthespotWin.font_height ;
				x =  w->overthespotWin.client_area.x ;
				line_num ++ ;
			}
			/* Ƭΰ֤ФƤϥɽȤΤɬס*/
			line_top    = text ;
			linetop_pos = pos ;
			/* 2ܤιƬ֤ФƤ*/
			if (midline_top == NULL){
				midline_top = line_top ;
				midline_pos = linetop_pos ;
			}
		}
		/* ɽʤΤɤȽꤹ롣*/
		if (pos == node->cur_pos &&
			(( (y + w->overthespotWin.font_height) < height)))
			cursor_flag = True ;
		if (IS_ASCII_EQUAL (*text, '\n')){
			if ((y + w->overthespotWin.font_height) >= height){
				goto exit_loop ;
			} else {
				y += w->overthespotWin.font_height ;
				x =  w->overthespotWin.client_area.x ;
				line_num ++ ;
			}
			/* Ƭΰ֤ФƤϥɽȤΤɬס
			 */
			line_top    = text + 1 ;
			linetop_pos = pos + 1 ;
			/* 2ܤιƬ֤ФƤ*/
			if (midline_top == NULL){
				midline_top = line_top ;
				midline_pos = linetop_pos ;
			}
		} else {
			x += xdiff ;
		}
	}
	/* ޤǤǥ뤬ɽƤʤäν*/
	if (!cursor_flag){
		/* Ԥɬפꡩ */
		if ((x + w->overthespotWin.cursor_width) >= width){
			if ((y + w->overthespotWin.font_height) < height){
				y += w->overthespotWin.font_height ;
				line_num ++ ;
				x = w->overthespotWin.client_area.x ;
				line_top    = text ;
				linetop_pos = pos ;
				x += w->overthespotWin.cursor_width ;
				cursor_flag = True ;
			}
		} else {
			x +=  (w->overthespotWin.cursor_width) ;
			cursor_flag = True ;
		}
	}
  exit_loop:
	/* ɽ٤Կ򵭲Ƥ*/
	w->overthespotWin.canvas_lines = line_num + 1 ;
	/*
	 *  (y - w->overthespotWin.spot_y) / w->overthespotWin.font_height + 1 ;
	 */
	if (!cursor_flag){
		OTSW_ConfigureWindowsScreenIsSmall
			(gw, x, y, line_top, linetop_pos, midline_top, midline_pos) ;
		return ;
	}

	/* 饦ɥκƷ׻֤ʤɤԤ*/
	if (w->overthespotWin.canvas_lines == 1){
		if (x <= w->overthespotWin.spot_x){
			XQueryPopdown
				(gw, &w->overthespotWin.topline_probe,
				 w->overthespotWin.topline_win) ;
			XQueryPopdown
				(gw, &w->overthespotWin.midline_probe,
				 w->overthespotWin.midline_win) ;
			XQueryPopdown
				(gw, &w->overthespotWin.botline_probe,
				 w->overthespotWin.botline_win) ;
			w->overthespotWin.topline_width =
				w->overthespotWin.botline_width = 0 ;
			return ;
		}
		w->overthespotWin.topline_width = x - w->overthespotWin.spot_x ;
	} else {
		int width = w->overthespotWin.client_area.width - 
			w->overthespotWin.spot_x + w->overthespotWin.client_area.x ;
		/* եܿˤʤ餺;äƤޤʬΤƤƤ*/
		w->overthespotWin.topline_width = width ;
	}
	w->overthespotWin.topline_text = node->textbuffer ;
	w->overthespotWin.topline_pos  = 0 ;
	w->overthespotWin.topline_x    = w->overthespotWin.spot_x ;
	
	XMoveResizeWindow
		(XtDisplay (gw), w->overthespotWin.topline_win,
		 focus_offset_x + w->overthespotWin.topline_x, 
		 focus_offset_y + w->overthespotWin.spot_y - w->overthespotWin.font_ascent,
		 w->overthespotWin.topline_width,
		 w->overthespotWin.font_height) ;
	
	if (!w->overthespotWin.topline_probe){
		XMapWindow (XtDisplay (gw), w->overthespotWin.topline_win) ;
		w->overthespotWin.topline_probe = True ;
	}
	
	/* ʤν¸ߤν*/
	if (w->overthespotWin.canvas_lines > 2){
		w->overthespotWin.midline_text = midline_top ;
		w->overthespotWin.midline_pos  = midline_pos ;
		
		XMoveResizeWindow
			(XtDisplay (gw), w->overthespotWin.midline_win,
			 focus_offset_x + w->overthespotWin.client_area.x,
			 focus_offset_y + w->overthespotWin.spot_y + w->overthespotWin.font_height - 
			 w->overthespotWin.font_ascent,
			 w->overthespotWin.client_area.width,
			 y - w->overthespotWin.spot_y - w->overthespotWin.font_height) ;
		if (!w->overthespotWin.midline_probe){
			XMapWindow (XtDisplay (gw), w->overthespotWin.midline_win) ;
			w->overthespotWin.midline_probe = True ;
		}
	} else {
		/* õ롣*/
		XQueryPopdown
			(gw, &w->overthespotWin.midline_probe, 
			 w->overthespotWin.midline_win) ;
		w->overthespotWin.midline_text = NULL ;
		w->overthespotWin.midline_pos  = 0 ;
	}
	
	/* ʤν¸ߤġ*/
	if (w->overthespotWin.canvas_lines > 1){
		w->overthespotWin.botline_width =
			x - w->overthespotWin.client_area.x ;       
		w->overthespotWin.botline_text  = line_top ;
		w->overthespotWin.botline_pos   = linetop_pos ;
		
		/* ɸν*/
		XMoveResizeWindow
			(XtDisplay (gw), w->overthespotWin.botline_win,
			 focus_offset_x + w->overthespotWin.client_area.x,
			 focus_offset_y + y - w->overthespotWin.font_ascent,
			 w->overthespotWin.botline_width,
			 w->overthespotWin.font_height) ;
		if (!w->overthespotWin.botline_probe){
			XMapWindow (XtDisplay (gw), w->overthespotWin.botline_win) ;
			w->overthespotWin.botline_probe = True ;
		}
	} else {
		/* ǲʤĤ롣*/
		XQueryPopdown
			(gw, &w->overthespotWin.botline_probe, 
			 w->overthespotWin.botline_win) ;
		w->overthespotWin.botline_text = NULL ;
		w->overthespotWin.botline_pos  = 0 ;
	}
	return ;
}

/*
 * ⡼ɥɥ֤˰ư硢ȤޤǤɽ
 * ƤޤȤʴؿ
 */
static void OTSW_resetupModeWindow (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	register int x, y, min_y, max_y, min_x, max_x, focus_offset_x, focus_offset_y ;
	register int modeshell_width, modeshell_height ;
	XSetWindowAttributes xswa ;
	
	modeshell_width  = getWidthOfModeLine
		(w->overthespotWin.fontset,
		 w->overthespotWin.buffer.topbuffer,
		 w->overthespotWin.buffer.jisyo_dirty,
		 w->overthespotWin.buffer.overthespot_like_input) ;
	modeshell_height = w->overthespotWin.font_height ;
	
	/* 礭ΤǤ뤫ɤȽǤ롣*/
	if (w->overthespotWin.modeshell_width != modeshell_width ||
		w->overthespotWin.modeshell_height != modeshell_height){
		w->overthespotWin.modeshell_width  = modeshell_width ;
		w->overthespotWin.modeshell_height = modeshell_height ;
		XResizeWindow
			(XtDisplay (gw), w->overthespotWin.modeshell_win,
			 modeshell_width, modeshell_height) ;
	}
	
	if (!XtIsRealized (gw))
		return ;
	
	focus_offset_x	= w->overthespotWin.focus_offset_x ;
	focus_offset_y	= w->overthespotWin.focus_offset_y ;
	/* ꥵΥ⡼ɥʤС礭νʾΤȤϤʤ*/
	if (w->overthespotWin.fixed_modeshell){
		x = w->overthespotWin.status_area.x ;
		y = w->overthespotWin.status_area.y ;
		focus_offset_x	= 0 ;
		focus_offset_y	= 0 ;
	} else if (OTSW_ParseModeShellGeometry(gw)) {
		x = w->overthespotWin.modeshell_x;
		y = w->overthespotWin.modeshell_y;
	} else {
		min_x = w->overthespotWin.client_area.x ;
		min_y = w->overthespotWin.client_area.y ;
		max_x = min_x + 
			w->overthespotWin.client_area.width - modeshell_width -
			w->overthespotWin.modeshell_border_width ;
		max_y = min_y +
			w->overthespotWin.client_area.height - modeshell_height -
			w->overthespotWin.modeshell_border_width * 2 ;
		
		xswa.win_gravity = NorthWestGravity ;
		/* ⡼ɥɥư롣*/
		if (!w->overthespotWin.botline_probe &&
			!w->overthespotWin.midline_probe){
			/* ʸϤȤʸϤƤʤС *
			 * Ʊ롣*/
			x = w->overthespotWin.spot_x ;
			y = w->overthespotWin.spot_y -
				w->overthespotWin.font_ascent + w->overthespotWin.font_height ;
		} else {
			x = w->overthespotWin.client_area.x ;
			y = w->overthespotWin.spot_y + 
				w->overthespotWin.font_height * w->overthespotWin.canvas_lines -
				w->overthespotWin.font_ascent ;
		}
		/* ɽ꤬뤫ɤ򸫤롣*/
		if (x > max_x){
			x = max_x ;
		} else if (x < min_x){
			x = min_x ;
		}
		/* Τޤɽ̤β˽ФƤޤ */
		if (y > max_y && !w->overthespotWin.south_cursor){
#ifdef DEBUG
			fprintf (stderr, "modeshell y = %d, max_y = %d\n", y, max_y) ;
			fprintf (stderr, "spot_y = %d, font_ascent = %d, font_height = %d\n",
					 w->overthespotWin.spot_y, w->overthespotWin.font_ascent,
					 w->overthespotWin.font_height) ;
			fprintf (stderr, "client y = %d, height = %d\n", 
					 w->overthespotWin.client_area.y, 
					 w->overthespotWin.client_area.height) ;
			fprintf (stderr, "border width = %d\n",
					 w->overthespotWin.modeshell_popup->core.border_width) ;
#endif
			y = w->overthespotWin.spot_y -
				w->overthespotWin.font_ascent -
				w->overthespotWin.modeshell_border_width * 2 -
				w->overthespotWin.font_height ;
			/* ̤ξ夫ФƤޤΡ */
			if (y < min_y){
				y = w->overthespotWin.spot_y ;
				x = min_x ;
			} else {
				xswa.win_gravity = SouthWestGravity ;
			}
		}
		/* Window  Gravity ꤹ롣*/
		XChangeWindowAttributes
			(XtDisplay (gw), w->overthespotWin.modeshell_win,
			 CWWinGravity, &xswa) ;
  }
#ifdef DEBUG
	fprintf (stderr, "modeshell (x,y) = (%d,%d) size = (%d,%d, %d)\n",
			 x, y, modeshell_width, modeshell_height, 
			 w->overthespotWin.modeshell_border_width) ;
	fprintf (stderr, "spot (x,y) = (%d,%d)\n",
			 w->overthespotWin.spot_x, w->overthespotWin.spot_y) ;
	fprintf (stderr, "client (x,y) = (%d,%d) size = (%d, %d)\n",
			 w->overthespotWin.client_area.x, 
			 w->overthespotWin.client_area.y, 
			 w->overthespotWin.client_area.width,
			 w->overthespotWin.client_area.height) ;
	fflush (stderr) ;
#endif
	/* ⡼ɥɥ¸ߤƤʤääƤޤ*/
	if (!w->overthespotWin.modeshell_probe){
		w->overthespotWin.modeshell_probe = True ;
		XMoveWindow
			(XtDisplay (gw), w->overthespotWin.modeshell_win, focus_offset_x + x, focus_offset_y + y) ;
		XMapWindow
			(XtDisplay (gw), w->overthespotWin.modeshell_win) ;
#if 1
		XRaiseWindow(XtDisplay(gw), w->overthespotWin.modeshell_win);
#endif
	} else {
		/* ɽ֤ν򤹤롣*/
		XMoveWindow
			(XtDisplay (gw), w->overthespotWin.modeshell_win, focus_offset_x + x, focus_offset_y + y) ;
	}
	Modeshell_Display (gw, w->overthespotWin.modeshell_win) ;
  return ;
}

/*
 * skkinput β̤򤤤ľؿ
 *-----
 * ̤礭ѹʤɤԤ줿ˤϤδؿƤФ뤳Ȥ
 * ʤ롣
 */
static void OTSW_RedrawScreen (Widget gw)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

  /* ɽκƷ׻Ԥ*/
  OTSW_CalcSizeOfBufferWindows (gw) ;
  /* 褵롣*/
  if (w->overthespotWin.topline_probe)
    Topline_Redisplay (gw, w->overthespotWin.topline_win) ;
  if (w->overthespotWin.midline_probe)
    Midline_Redisplay (gw, w->overthespotWin.midline_win) ;
  if (w->overthespotWin.botline_probe)
    Botline_Redisplay (gw, w->overthespotWin.botline_win) ;
  /* ⡼ɥɥɽ롣*/
  OTSW_resetupModeWindow (gw) ;
  /* mini-buffer ɽ롣*/
  OTSW_ConfigureMinibuffer (gw) ;
  return ;
}

/*
 * ɽڤƤޤä(*text,pos)
 */
static void OTSW_ConfigureWindowsScreenIsSmall
 (Widget gw,                  int endx, int endy,
  struct myChar *linetop,     int linetop_pos,
  struct myChar *midline_top, int midline_pos)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	struct SKKInputNode *node = w->overthespotWin.buffer.topbuffer ;
	int width, start_x, toppos ;
	struct myChar *toptext ;
	register int	focus_offset_x, focus_offset_y ;
	
	focus_offset_x		= w->overthespotWin.focus_offset_x ;
	focus_offset_y		= w->overthespotWin.focus_offset_y ;

	/* ǵ줿 pos  text ɽɤ*/
	OTSW_CalcTopPositionOfBuffer
		(w->overthespotWin.fontset,
		 linetop, linetop_pos, node->cur_pos, 
		 w->overthespotWin.client_area.width,
		 &toptext, &toppos) ;
	
	/* ξ硣ȥåץ饤礭ꤷʤȤʤ*/
	{
		struct myChar *tmp_ptr = toptext ;
		int tmp_pos = toppos, cursor_flag = False ;
		
		width = 0 ;
		/* ޤɽɤΤ׻롣*/
		while (!IS_END_OF_STRING (*tmp_ptr) &&
			   width < w->overthespotWin.client_area.width){
			if (tmp_pos == node->cur_pos)
				cursor_flag = True ;
			width += myCharTextWidth
				(w->overthespotWin.fontset, tmp_ptr, 1) ;
			tmp_ptr ++ ;
			tmp_pos ++ ;
		}
		if (!cursor_flag){
			width += w->overthespotWin.cursor_width ;
		}
	}
	/* ơɤΥɥưɤΤͤ롣*/
	if (w->overthespotWin.canvas_lines == 1){
		if (endx <= w->overthespotWin.spot_x){
			/* ä顢ɥ˴롣*/
			XQueryPopdown
				(gw, &w->overthespotWin.topline_probe,
				 w->overthespotWin.topline_win) ;
			XQueryPopdown
				(gw, &w->overthespotWin.midline_probe,
				 w->overthespotWin.midline_win) ;
			XQueryPopdown
				(gw, &w->overthespotWin.botline_probe,
				 w->overthespotWin.botline_win) ;
			w->overthespotWin.topline_width =
				w->overthespotWin.botline_width = 0 ;
			return ;
		}
		if ((width + w->overthespotWin.spot_x) >=
			(w->overthespotWin.client_area.x +
			 w->overthespotWin.client_area.width) || linetop_pos != toppos){
			start_x = w->overthespotWin.client_area.x ;
		} else {
			start_x = w->overthespotWin.spot_x ;
		}
		/* ФʤȤȤϤޤ */
		if (width >= w->overthespotWin.client_area.width){
			width   = w->overthespotWin.client_area.width ;
		}
		/* ɽϰ֡¾ꡣ*/
		w->overthespotWin.topline_width = width ;
		w->overthespotWin.topline_x     = start_x ;
		w->overthespotWin.topline_text  = toptext ;
		w->overthespotWin.topline_pos   = toppos ;
	} else {
		w->overthespotWin.topline_width =
			w->overthespotWin.client_area.width - w->overthespotWin.spot_x +
			w->overthespotWin.client_area.x ;
		w->overthespotWin.topline_x     = w->overthespotWin.spot_x ;
		w->overthespotWin.topline_text  = node->textbuffer ;
		w->overthespotWin.topline_pos   = 0 ;
	}
	XMoveResizeWindow
		(XtDisplay (gw), w->overthespotWin.topline_win,
		 focus_offset_x + w->overthespotWin.topline_x,
		 focus_offset_y + w->overthespotWin.spot_y - w->overthespotWin.font_ascent,
		 w->overthespotWin.topline_width,
		 w->overthespotWin.font_height) ;
	/* ǾʤΥ饤ɽpopup롣*/
	if (!w->overthespotWin.topline_probe){
		XMapWindow (XtDisplay (gw), w->overthespotWin.topline_win) ;
		w->overthespotWin.topline_probe = True ;
	}
	/* ʤν¸ߤν*/
	if (w->overthespotWin.canvas_lines > 2){
		w->overthespotWin.midline_text = midline_top ;
		w->overthespotWin.midline_pos  = midline_pos ;
		XMoveResizeWindow
			(XtDisplay (gw), w->overthespotWin.midline_win,
			 focus_offset_x + w->overthespotWin.client_area.x,
			 focus_offset_y + w->overthespotWin.spot_y + 
			 w->overthespotWin.font_height - w->overthespotWin.font_ascent,
			 w->overthespotWin.client_area.width,
			 endy - w->overthespotWin.spot_y -
			 w->overthespotWin.font_height) ;
		if (!w->overthespotWin.midline_probe){
			XMapWindow (XtDisplay (gw), w->overthespotWin.midline_win) ;
			w->overthespotWin.midline_probe = True ;
		}
	} else {
		XQueryPopdown
			(gw, &w->overthespotWin.midline_probe, 
			 w->overthespotWin.midline_win) ;
		w->overthespotWin.midline_text = NULL ;
		w->overthespotWin.midline_pos  = 0 ;
	}
	/* ʤν¸ߤġ*/
	if (w->overthespotWin.canvas_lines > 1){
		if (width >= w->overthespotWin.client_area.width){
			width   = w->overthespotWin.client_area.width ;
		}
		w->overthespotWin.botline_width = width ;
		w->overthespotWin.botline_text  = toptext ;
		w->overthespotWin.botline_pos   = toppos ;
		
		XMoveResizeWindow
			(XtDisplay (gw), w->overthespotWin.botline_win,
			 focus_offset_x + w->overthespotWin.client_area.x, 
			 focus_offset_y + endy - w->overthespotWin.font_ascent,
			 w->overthespotWin.botline_width,
			 w->overthespotWin.font_height) ;
		if (!w->overthespotWin.botline_probe){
			XMapWindow (XtDisplay (gw), w->overthespotWin.botline_win) ;
			w->overthespotWin.botline_probe = True ;
		}
	} else {
		/* ǲʤĤ롣*/
		XQueryPopdown
			(gw, &w->overthespotWin.botline_probe,
			 w->overthespotWin.botline_win) ;
		w->overthespotWin.botline_text = NULL ;
	}
	return ;
}

/* ǡΰ֤̳˽ФΤɤȽǤʤФʤ *
 * ʤ*/
static void OTSW_ConfigureMinibufferPosition (Widget gw, int *rx, int *ry)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	XWindowAttributes xwa ;
	unsigned int mheight, mwidth ;
	int y_lower, y_base, y, x ;
	int win_gravity ;
	XSizeHints sizehints ;

	win_gravity = NorthWestGravity ;

	/* ɽ륦ɥΰ֤롣ϵִ֤ *
	 * 롣Ͼ˾ꤷƤ͡*/
	y_base = w->overthespotWin.client_y + 
		w->overthespotWin.focus_offset_y + 
		w->overthespotWin.spot_y - w->overthespotWin.font_ascent ;
	x = w->overthespotWin.client_x + w->overthespotWin.focus_offset_x ;
	
	if (!w->overthespotWin.topline_probe){
		y = y_base + w->overthespotWin.font_height ;
	} else {
		/* ǽΰԲɽƤˤϡĥХ˽񤫤Ƥ *
		 * ΤäƤޤʤ褦֤롣*/
		y = y_base + w->overthespotWin.font_height *
			w->overthespotWin.canvas_lines ;
	}
	/* 롼ȥɥ礭롣*/
	XGetWindowAttributes
		(XtDisplay (gw),
		 RootWindowOfScreen
		 (XtScreen (w->overthespotWin.minibuffer_popup)),
		 &xwa) ;
#ifdef DEBUG
	fprintf (stderr, "Root Window Height : %d\n", xwa.height) ;
#endif
	/* ߥ˥Хåեι⤵ФƤ٤ */
	mheight = w->overthespotWin.minibuffer_popup->core.border_width * 2 +
		((w->overthespotWin.change_minibuffer_font)?
		 w->overthespotWin.font_height : w->overthespotWin.mfont_height) ;
	mwidth = w->overthespotWin.minibuffer_popup->core.border_width * 2 +
		w->overthespotWin.minibuf_width ;
	
	/* κɸߥ˥ХåեȤΰֲκɸˤʤ롣*/
	y_lower = y + mheight ;
#ifdef DEBUG
	fprintf (stderr, "Minibuffer : y (%d) + height (%d)\n", 
			 y, mheight) ;
#endif
	/* ̳˽ФƤޤΡ */
	if (y_lower > xwa.height){
		if (y_base > xwa.height){
			/* ʤ̤ΰֲ˶ŪˤϤäĤޤ*/
			y = xwa.height - mheight -
				w->overthespotWin.minibuffer_popup->core.border_width * 2 ;
		} else {
			/* ʤ饫ξɽޤ礦*/
			y = y_base - mheight -
				w->overthespotWin.minibuffer_popup->core.border_width * 2 ;
		}
		win_gravity = SouthWestGravity ;
	}
	/* ⤷Ʋ̤ξ˽ФƤޤȤȤΤǤ */
	if (y < 0){
		/* ʤΤޤ󡣤⤦̤ξ֤Ƥޤޤ*/
		y = 0 ;
		win_gravity = NorthWestGravity ;
	}
#ifdef DEBUG
	fprintf (stderr, "Result Y = %d, y_base = %d\n", y, y_base) ;
#endif
	if (x + mwidth > xwa.width){
		x = xwa.width - mwidth ;
		if (x < 0){
			x = 0 ;
		} else {
			if (win_gravity == NorthWestGravity){
				win_gravity = NorthEastGravity ;
			} else {
				win_gravity = SouthEastGravity ;
			}
		}
	} else if (x < 0){
		x = 0 ;
	}
	/* Window Manager ˥ҥȤäƤ롣XSetWMNormalHints * 
	 * ʬ񴹤ʤ褦ʤΤǡ hints ɤߤȤäƤ麹*
	 * ؤȤˡȤʤФʤʤ*/
	sizehints.flags = PWinGravity ;
	sizehints.win_gravity = win_gravity ;
	XChangeWMNormalHints
		(XtDisplay (gw),
		 XtWindow (w->overthespotWin.minibuffer_popup),
		 &sizehints) ;
	*rx = x ;
	*ry = y ;
	return  ;
}

/*
 * 饤ŽդפΥߥ˥Хåեΰ֤礭
 * ؿ 
 */
static int OTSW_ConfigureSubWindowMinibuffer (Widget gw, int flag)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	int width, height ;

	/* ޤκˤĤƤȦΥ⡼ɥ礭ڤäƤ*/
	w->overthespotWin.minibuffer_ofstx = getMaxLengthOfModeline
		(w->overthespotWin.fontset) ;
	/* Ŭڤ礭ѹƤ*/
	width = w->overthespotWin.status_area.width - 
		w->overthespotWin.minibuffer_ofstx ;
	/* 礭ʤä顢1x1 ˤФ롣*/
	height = w->overthespotWin.status_area.height ;
	if (width < 1){
		if (!flag)
			return False ;
		width = 1 ;
	}
	if (height < 1){
		if (!flag)
			return False ;
		height = 1 ;
	}
	XMoveResizeWindow
		(XtDisplay (gw), w->overthespotWin.minibuffer_win,
		 w->overthespotWin.status_area.x +
		 w->overthespotWin.minibuffer_ofstx, 
		 w->overthespotWin.status_area.y,
		 width, height) ;
	return True ;
}

/*
 * ߥ˥Хåեɥ֡礭Ԥؿ
 *----
 * 礭ϼ¤ꤷƤޤ󡣺ǽꤷǤ̤˥ߥ
 * Хåե򲿽֤ɤΤʡĤȽǤ˻Ȥ櫓Ǥ
 */
static void OTSW_ConfigureMinibuffer (Widget gw)
{
	OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
	struct SKKInputNode *node = w->overthespotWin.buffer.topbuffer ;
	struct SKKInputNode *mNode = w->overthespotWin.buffer.lastbuffer ;
	Window win ;
	int x, y ;
	
	if (mNode == node){
		/* ɽ٤ƥȤ̵äˤϡ*/
		if (IS_END_OF_STRING (node->mtextbuffer[ 0 ])){
			/* УϣХåפ֤ä顢Ĥ롣*/ 
			if (w->overthespotWin.minibuffer_probe){
				w->overthespotWin.minibuffer_probe = False ;
				if (w->overthespotWin.minibuffer_win == None){
					XtPopdown (w->overthespotWin.minibuffer_popup) ;
				} else {
					XUnmapWindow
						(XtDisplay (gw),w->overthespotWin.minibuffer_win) ;
				}
			}
			return ;
		}
	}
	/* ߥ˥ХåեϵƤʤΡ ƤʤΤä鵯ɬ *
	 * 衣*/
	if (w->overthespotWin.minibuffer_win == None){
		if (!w->overthespotWin.minibuffer_probe){
			/* ꤵ줿֤˥ߥ˥Хåեư롣*/
			OTSW_ConfigureMinibufferPosition (gw, &x, &y) ;
			XtMoveWidget
				(w->overthespotWin.minibuffer_popup, x, y) ;
			/* Popup 롣*/
			XtPopup (w->overthespotWin.minibuffer_popup, XtGrabNone) ;
		}
		win = XtWindow (w->overthespotWin.minibuffer_canvas) ;
	} else {
		x = w->overthespotWin.status_area.x +
			w->overthespotWin.minibuffer_ofstx ;
		y = w->overthespotWin.status_area.y ;
		/* minibuffer window ươġ*/
		XMoveWindow
			(XtDisplay (gw), w->overthespotWin.minibuffer_win, x, y) ;
		/* minibuffer window  map 롣*/
		XMapWindow (XtDisplay (gw), w->overthespotWin.minibuffer_win) ;
		
		win = w->overthespotWin.minibuffer_win ;
	}
	w->overthespotWin.minibuffer_probe = True ;
	/* Хľ褦׵Ф*/
	Minibuffer_Redisplay (gw, win) ;
	return ;
}    

/*
 * ʲcanvasWidget Ѥ callback ã
 */
static void Topline_Redisplay
 (Widget gw, Window win)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  struct SKKInputNode *node = w->overthespotWin.buffer.topbuffer ;

  if (!w->overthespotWin.topline_probe)
    return ;

  XClearWindow (XtDisplay (gw), win) ;
  OTSW_FullDrawTopBufferTopLine
     (XtDisplay (gw), win,
      w->overthespotWin.fontset, 
      w->overthespotWin.gc, w->overthespotWin.rgc,
      w->overthespotWin.topline_text,
      w->overthespotWin.topline_pos,
      w->overthespotWin.font_ascent, w->overthespotWin.font_height,
      w->overthespotWin.topline_width,
       ((w->overthespotWin.botline_probe ||
	  w->overthespotWin.midline_probe ||
	 (w->overthespotWin.topline_x +
	  w->overthespotWin.topline_width) >=
	  w->overthespotWin.client_area.x + 
	  w->overthespotWin.client_area.width)? True : False),
      w->overthespotWin.cursor_width,
      node->cur_pos, node->cur_exist, w->overthespotWin.is_focus) ;
  return ;
}

static void Midline_Redisplay
 (Widget gw, Window win)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  struct SKKInputNode *node = w->overthespotWin.buffer.topbuffer ;

  if (!w->overthespotWin.midline_probe)
    return ;
    
  XClearWindow (XtDisplay (gw), win) ;
  /* ιԤ褹롣*/
  OTSW_FullDrawTopBufferMiddleLines
     (XtDisplay (gw), win,
      w->overthespotWin.fontset, 
      w->overthespotWin.gc, w->overthespotWin.rgc,
      w->overthespotWin.midline_text,
      w->overthespotWin.midline_pos,
      w->overthespotWin.font_ascent, w->overthespotWin.font_height,
      w->overthespotWin.client_area.width,
      w->overthespotWin.canvas_lines - 2,
      node->cur_pos, node->cur_exist, w->overthespotWin.is_focus) ;
  return ;
}

static void Botline_Redisplay
 (Widget gw, Window win)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  struct SKKInputNode *node = w->overthespotWin.buffer.topbuffer ;

  if (!w->overthespotWin.botline_probe)
    return ;

  XClearWindow (XtDisplay (gw), win) ;
  /* ֲιԤ褹롣*/
  OTSW_FullDrawTopBufferTopLine
     (XtDisplay (gw), win,
      w->overthespotWin.fontset, 
      w->overthespotWin.gc, w->overthespotWin.rgc, 
      w->overthespotWin.botline_text,
      w->overthespotWin.botline_pos,
      w->overthespotWin.font_ascent, w->overthespotWin.font_height,
      w->overthespotWin.botline_width, 
       (w->overthespotWin.botline_width <
        w->overthespotWin.client_area.width)? False : True,
      w->overthespotWin.cursor_width,
      node->cur_pos, node->cur_exist, w->overthespotWin.is_focus) ;
  return ;
}

static void Minibuffer_Redisplay (Widget gw, Window win)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  struct SKKInputNode *mNode ;
  struct SKKInputNode *node = w->overthespotWin.buffer.topbuffer ;
  struct skkinputManagedFont **fontset ;
  int toppos, fontheight, fontascent ;
  GC gc, rgc ;

  if (!w->overthespotWin.minibuffer_probe)
    return ;

  if (w->overthespotWin.minibuffer_win != None){
    gc  = w->overthespotWin.gc ;
    rgc = w->overthespotWin.rgc ; 
  } else {
    gc  = w->overthespotWin.minibuf_gc ;
    rgc = w->overthespotWin.minibuf_rgc ;

    XRaiseWindow
       (XtDisplay (gw), win) ;
  }
  if (w->overthespotWin.change_minibuffer_font ||
      w->overthespotWin.minibuffer_win != None){
    fontset    = w->overthespotWin.fontset ;
    fontascent = w->overthespotWin.font_ascent ;
    fontheight = w->overthespotWin.font_height ;
  } else { 
    fontset    = w->overthespotWin.minibuf_fontset ;
    fontascent = w->overthespotWin.mfont_ascent ;
    fontheight = w->overthespotWin.mfont_height ;
  }
  XClearWindow (XtDisplay (gw), win) ;

  /* mini-buffer ɽ롣*/
  mNode = w->overthespotWin.buffer.lastbuffer ;

  if (mNode == node){
    /* ɽ٤ƥȤ̵äˤϡ*/
    if (IS_END_OF_STRING (node->mtextbuffer[ 0 ]))
      return ;

    skkwin_jputstring
       (XtDisplay (gw), win, fontset, gc,
	0, fontascent, node->mtextbuffer) ;
  } else {

    if (!IS_END_OF_STRING (mNode->mtextbuffer[ 0 ])){
      skkwin_jputstring
	 (XtDisplay (gw), win, fontset, gc,
	  0, fontascent, mNode->mtextbuffer) ;
    } else {
      struct myChar *toptext ;
      int width ;

      if (w->overthespotWin.minibuffer_win == None){
	XWindowAttributes xwa ;
	/* ǲˤʤ뤫ĲȴФƤ*/
	XGetWindowAttributes
	   (XtDisplay (gw), win, &xwa) ;
	width = xwa.width ;
      } else {
	width = w->overthespotWin.status_area.width -
	  w->overthespotWin.minibuffer_ofstx ;
	if (width < 1)
	  width = 1 ;
      }
      /* Window  buffer ʸɽ롣*/
      OTSW_CalcTopPositionOfBuffer
	   (fontset, mNode->textbuffer, 0, mNode->cur_pos, width,
	    &toptext, &toppos) ;
      OTSW_FullDrawTopBufferTopLine
	 (XtDisplay (gw), win,
	  fontset, gc, rgc, 
	  toptext, toppos, fontascent, fontheight, width,
	  !IS_END_OF_STRING (mNode->textbuffer[ mNode->cur_pos ]),
	  w->overthespotWin.cursor_width,
	  mNode->cur_pos, mNode->cur_exist, 
	  w->overthespotWin.is_focus) ;
    }
  }
  XFlush (XtDisplay (gw)) ;
  return ;
}

/*
 * δؿϸߤξǤκ褷ޤpopup/popdown ʤɤ
 * ƤФäƤƤ뤳Ȥˤޤꥢ꤫ʤ Ǥ⡢
 * ѲڤäưͿΤϿ(Ĥޤ overthespotWinWidget)ʤΤ
 * 顢ҶǤȤ餻äƤΤϡġ
 */
static void Minibuffer_RedisplayCallback
 (Widget gw, caddr_t client, caddr_t caller)
{
  Widget w =  (Widget)client ;
  Minibuffer_Redisplay (w, XtWindow (gw)) ;
  return ;
}

/*
 * modeshell window ˥⡼ɤɽ򤹤ؿ
 */
static void Modeshell_Display
 (Widget gw, Window win)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;
  unsigned long mode_status ;

  /* ⡼ɥɥ¸ߤƤʤä񤫤ʤ*/
  if (!w->overthespotWin.modeshell_probe)
    return ;
  /* ߤξ֤򸫤롣*/
  mode_status =
     ((skkinput_GetModelineNumber
	 (w->overthespotWin.buffer.topbuffer)) |
       (w->overthespotWin.buffer.jisyo_dirty << 3) |
       (w->overthespotWin.buffer.overthespot_like_input << 4)) ;
  if (w->overthespotWin.prevModeStatus != mode_status){
    XClearWindow (XtDisplay (gw), win) ;
    w->overthespotWin.prevModeStatus = mode_status ;
  }
#if 1
  XRaiseWindow(XtDisplay(gw), win);
#endif
  /* ⡼ɥ饤ɽ롣ʬɽľбͽǤϤ롣*/
  fullDrawModeLine
     (XtDisplay (gw), win,
      w->overthespotWin.fontset,
      w->overthespotWin.gc,
      w->overthespotWin.buffer.topbuffer,
      0, w->overthespotWin.font_ascent,
      w->overthespotWin.buffer.jisyo_dirty,
      w->overthespotWin.buffer.overthespot_like_input) ;
  return ;
}

/*
 * modeshell window κ򤹤ؿ
 */
static void Modeshell_Redisplay
 (Widget gw, Window win)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)gw ;

  /* ⡼ɥɥ¸ߤƤʤääƤޤ*/
  if (!w->overthespotWin.modeshell_probe)
    return ;
#if 1
  XRaiseWindow(XtDisplay(gw), win);
#endif
  /* ľΤ˾õƤ*/
  XClearWindow (XtDisplay (gw), win) ;
  /* ⡼ɥ饤ɽ롣ʬɽľбͽǤϤ롣*/
  fullDrawModeLine
     (XtDisplay (gw), win,
      w->overthespotWin.fontset,
      w->overthespotWin.gc,
      w->overthespotWin.buffer.topbuffer,
      0, w->overthespotWin.font_ascent,
      w->overthespotWin.buffer.jisyo_dirty,
      w->overthespotWin.buffer.overthespot_like_input) ;
  w->overthespotWin.prevModeStatus = 
     ((skkinput_GetModelineNumber
	 (w->overthespotWin.buffer.topbuffer)) |
       (w->overthespotWin.buffer.jisyo_dirty << 3) |
       (w->overthespotWin.buffer.overthespot_like_input << 4)) ;
  return ;
}

/*
 * Window Manager  close button 򥯥å˸ƤФ륳Х
 * ؿ
 */
static void OTSW_wmMessageCloseCallback
 (Widget gw, caddr_t client, caddr_t caller)
{
  OverthespotWinWidget w =  (OverthespotWinWidget)client ;

  force_keyboard_quit ((Widget)w, & (w->overthespotWin.buffer)) ;
  return ;
}

static void OTSW_wmShellDestroyCallback
 (Widget gw, caddr_t client, caddr_t caller)
{
  /* ƤΥХåؿ˴Ƥ*/
  XtRemoveAllCallbacks (gw, XtNwmcloseNotify) ;
  XtRemoveAllCallbacks (gw, XtNdestroyNotify) ;
  return ;
}

/*
 * Canvas Widget ˸ƤӽФ륳Хåؿ
 */
static void Canvas_DestroyCallback
 (Widget gw, caddr_t client, caddr_t caller)
{
  XtRemoveAllCallbacks (gw, XtNredrawNotify) ;
  XtRemoveAllCallbacks (gw, XtNdestroyNotify) ;
  return ;
}

static void
OverWin_fixcallback (
	register Widget		gw,
	register XtPointer	client,
	register XtPointer	caller)
{
	XtCallCallbacks (gw, XtNtextNotify, caller) ;
	return ;
}

