/*
 * Copyright (c) 1997, Matthew N. Dodd
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
	"Copyright (c) 1997 Matthew N. Dodd\n\tAll rights reserved.\n";
#endif /* not lint */

#ifndef lint
static const char rcsid[] =
	"$Id: setquota.c,v 1.7 1997/03/24 04:14:47 winter Exp $";
#endif /* not lint */

#include <stdio.h>
#include <sys/param.h>
#include <ufs/ufs/quota.h>
#include <errno.h>
#include <string.h>
#include "quotatool.h"

int set_quota(qmstr*);

int set_quota(qm)
	register qmstr *qm;
{
	int qcmd;

	qcmd = QCMD(Q_SETQUOTA, f_mtype);
	while (qm) {
		
		if (f_bh)
			qm->dq_dqb.dqb_bhardlimit = v_bh;
		if (f_bs)
			qm->dq_dqb.dqb_bsoftlimit = v_bs;
#ifdef 0
		if (f_bg)
			qm->dq_dqb.dqb_btime = v_bg;
#endif
		if (f_ih)
			qm->dq_dqb.dqb_ihardlimit = v_ih;
		if (f_is)
			qm->dq_dqb.dqb_isoftlimit = v_is;
#ifdef 0
		if (f_ig)
			qm->dq_dqb.dqb_itime = v_ig;
#endif

		if (quotactl(f_fsname, qcmd, qm->id, (char*)&qm->dq_dqb) != 0) {
			fprintf(stderr, "%s : unable to update quota for %s(%d).  %s\n",
				m_proc[f_mode], qm->name, qm->id, strerror(errno));
		}
		
		qm = qm->next;
	}

	return 0;
}
