/*
** ascii.h
**
** definitions of ASCII mnemonics and synonyms.
** This file is in the public domain.
*/

#ifndef	__ASCII_H
#define	__ASCII_H
#define	NUL	'\0'
#define	SOH	'\001'
#define	STX	'\002'
#define	ETX	'\003'
#define	EOT	'\004'
#define	ENQ	'\005'
#define	ACK	'\006'
#define	BEL	'\007'
#define	BS	'\010'
#define	HT	'\011'
#define	LF	'\012'
#define	VT	'\013'
#define	FF	'\014'
#define	CR	'\015'
#define	SO	'\016'
#define	SI	'\017'
#define	DLE	'\020'
#define	DC1	'\021'
#define	DC2	'\022'
#define	DC3	'\023'
#define	DC4	'\024'
#define	NAK	'\025'
#define	SYN	'\026'
#define	ETB	'\027'
#define	CAN	'\030'
#define	EM	'\031'
#define	SUB	'\032'
#define	ESC	'\033'
#define	FS	'\034'
#define	GS	'\035'
#define	RS	'\036'
#define	US	'\037'
#define	SP	'\040'
#define	DEL	'\177'
#define	CTRL_A	SOH
#define	CTRL_B	STX
#define	CTRL_C	ETX
#define	CTRL_D	EOT
#define	CTRL_E	ENQ
#define	CTRL_F	ACK
#define	CTRL_G	BEL
#define	CTRL_H	BS
#define	CTRL_I	HT
#define	CTRL_J	LF
#define	CTRL_K	VT
#define	CTRL_L	FF
#define	CTRL_M	CR
#define	CTRL_N	SO
#define	CTRL_O	SI
#define	CTRL_P	DLE
#define	CTRL_Q	DC1
#define	CTRL_R	DC2
#define	CTRL_S	DC3
#define	CTRL_T	DC4
#define	CTRL_U	NAK
#define	CTRL_V	SYN
#define	CTRL_W	ETB
#define	CTRL_X	CAN
#define	CTRL_Y	EM
#define	CTRL_Z	SUB
#endif
